// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_ACCESSIBILITY_AX_NODE_ID_FORWARD_H_
#define UI_ACCESSIBILITY_AX_NODE_ID_FORWARD_H_

#include <limits.h>
#include <stdint.h>

namespace ui {

// Defines the type used for AXNode IDs, which are unique for a given context,
// such as a renderer, or Views, but not guaranteed to be unique within the
// current process or WebContents, which can contain multiple renderers.
// Because Accessibility APIs often need uniqueness within a WebContents,
// a AXUniqueId will be generated in order to differentiate a node in one
// renderer from another.
using AXNodeID = int32_t;

// If a node is not yet or no longer valid, its ID should have a value of
// kInvalidAXNodeID.
// Note: positive AXNodeIDs match DOM node ids generated by Blink. They are used
// for objects that contain that matching DOM node.
static constexpr AXNodeID kInvalidAXNodeID = 0;
// The browser needs to generate an AXNodeID for objects that it inserts in
// the hierarchy, such as "extra mac nodes"
static constexpr AXNodeID kFirstGeneratedBrowserNodeID = -1;
static constexpr AXNodeID kLastGeneratedBrowserNodeID = -999999999;
// A new AXTree is constructed with an empty document. The root must have a
// unique AXNodeID that will not match any other id.
static constexpr AXNodeID kInitialEmptyDocumentRootNodeID = -1000000000;
// The renderer needs to generate an AXNodeID for objects that don't have a DOM
// node. These start with this value and subsequent ids each subtract 1.
static constexpr AXNodeID kFirstGeneratedRendererNodeID = -1000000001;
static constexpr AXNodeID kLastGeneratedRendererNodeID = INT_MIN;

}  // namespace ui

#endif  // UI_ACCESSIBILITY_AX_NODE_ID_FORWARD_H_
