/*
* This license applies to all parts of web-tooling-benchmark that are not
* externally maintained libraries. The externally maintained libraries
* used by web-tooling-benchmark are:
* 
*   - The Backbone.js distribution, located in third_party/backbone-1.1.0.js.
*     This is copyrighted by Jeremy Ashkenas, DocumentCloud, and released
*     under the terms of the MIT license.
* 
*   - The lexer from the CoffeeScript project, located in
*     third_party/coffeescript-lexer-2.0.1.coffee, which is copyrighted by
*     Jeremy Ashkenas, and relased under the terms of the MIT license.
* 
*   - The jQuery distribution, located in third_party/jquery-3.2.1.js. This
*     is copyrighted by the JS Foundation and other contributors, and
*     released under the terms of the MIT license.
* 
*   - The Lodash distribution, located in third_party/lodash.core-4.17.4.js
*     and third_party/lodash.min-4.17.4.js.map. This is copyrighted by
*     the JS Foundation and other contributors, and released under the
*     terms of the MIT license.
* 
*   - The MooTools distribution, located in third_party/mootools-core-1.6.0.js.
*     This is copyrighted by Valerio Proietti, and released under the
*     terms of the MIT license.
* 
*   - The Preact distribution, located in third_party/preact-8.2.5.js and
*     third_party/preact-8.2.5.js.map. This is copyrighted by Jason Miller,
*     and released under the terms of the MIT license.
* 
*   - The Redux distribution, located in third_party/redux.min-3.7.2.js.
*     This is copyrighted by Dan Abramov, and released under the terms
*     of the MIT license.
* 
*   - The source-map distribution, located in
*     third_party/source-map.min-0.5.7.map. This is copyrighted by the
*     Mozilla Foundation and contributors, and released under the terms
*     of a 3-clause BSD license.
* 
*   - Several tests from the TodoMVC distribution, located in
*     third_party/speedometer-es2015-test-2.0.js and third_party/todomvc.
*     These are copyrighted by Addy Osmani, Sindre Sorhus, Pascal
*     Hartig, Stephen Sawchuk, and released under the terms of the
*     MIT license.
* 
*   - The Underscore.js distribution, located in
*     third_party/underscore-1.8.3.js and
*     third_party/underscore.min-1.8.3.js.map. This is copyrighted by
*     Jeremy Ashkenas, and released under the terms of the MIT license.
* 
*   - The VueJS distribution, located in
*     third_party/vue.runtime.esm-nobuble-2.4.4.js. This is copyrighted
*     Yuxi (Evan) You, and released under the terms of the MIT license.
* 
* These libraries have their own licenses; we recommend you read them,
* as their terms may differ from the terms below.
* 
* Copyright 2017, the V8 project authors. All rights reserved.
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions are
* met:
* 
*     * Redistributions of source code must retain the above copyright
*       notice, this list of conditions and the following disclaimer.
*     * Redistributions in binary form must reproduce the above
*       copyright notice, this list of conditions and the following
*       disclaimer in the documentation and/or other materials provided
*       with the distribution.
*     * Neither the name of Google Inc. nor the names of its
*       contributors may be used to endorse or promote products derived
*       from this software without specific prior written permission.
* 
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
* "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
* LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
* A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
* OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
* SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
* LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
* DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
* THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
* OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

// Work-around for the weird JaegerMonkey
// work-around inside benchmark.js.
const define = { amd: {} };

/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
/******/ 			});
/******/ 		}
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 387);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _Value = __webpack_require__(300);

Object.defineProperty(exports, "Value", {
  enumerable: true,
  get: function () {
    return _interopRequireDefault(_Value).default;
  }
});

var _ConcreteValue = __webpack_require__(654);

Object.defineProperty(exports, "ConcreteValue", {
  enumerable: true,
  get: function () {
    return _interopRequireDefault(_ConcreteValue).default;
  }
});

var _PrimitiveValue = __webpack_require__(301);

Object.defineProperty(exports, "PrimitiveValue", {
  enumerable: true,
  get: function () {
    return _interopRequireDefault(_PrimitiveValue).default;
  }
});

var _ObjectValue = __webpack_require__(655);

Object.defineProperty(exports, "ObjectValue", {
  enumerable: true,
  get: function () {
    return _interopRequireDefault(_ObjectValue).default;
  }
});

var _FunctionValue = __webpack_require__(920);

Object.defineProperty(exports, "FunctionValue", {
  enumerable: true,
  get: function () {
    return _interopRequireDefault(_FunctionValue).default;
  }
});

var _ECMAScriptFunctionValue = __webpack_require__(921);

Object.defineProperty(exports, "ECMAScriptFunctionValue", {
  enumerable: true,
  get: function () {
    return _interopRequireDefault(_ECMAScriptFunctionValue).default;
  }
});

var _ECMAScriptSourceFunctionValue = __webpack_require__(922);

Object.defineProperty(exports, "ECMAScriptSourceFunctionValue", {
  enumerable: true,
  get: function () {
    return _interopRequireDefault(_ECMAScriptSourceFunctionValue).default;
  }
});

var _BoundFunctionValue = __webpack_require__(923);

Object.defineProperty(exports, "BoundFunctionValue", {
  enumerable: true,
  get: function () {
    return _interopRequireDefault(_BoundFunctionValue).default;
  }
});

var _NativeFunctionValue = __webpack_require__(924);

Object.defineProperty(exports, "NativeFunctionValue", {
  enumerable: true,
  get: function () {
    return _interopRequireDefault(_NativeFunctionValue).default;
  }
});
Object.defineProperty(exports, "NativeFunctionCallback", {
  enumerable: true,
  get: function () {
    return _NativeFunctionValue.NativeFunctionCallback;
  }
});

var _ArrayValue = __webpack_require__(925);

Object.defineProperty(exports, "ArrayValue", {
  enumerable: true,
  get: function () {
    return _interopRequireDefault(_ArrayValue).default;
  }
});

var _UndefinedValue = __webpack_require__(926);

Object.defineProperty(exports, "UndefinedValue", {
  enumerable: true,
  get: function () {
    return _interopRequireDefault(_UndefinedValue).default;
  }
});

var _EmptyValue = __webpack_require__(927);

Object.defineProperty(exports, "EmptyValue", {
  enumerable: true,
  get: function () {
    return _interopRequireDefault(_EmptyValue).default;
  }
});

var _NullValue = __webpack_require__(928);

Object.defineProperty(exports, "NullValue", {
  enumerable: true,
  get: function () {
    return _interopRequireDefault(_NullValue).default;
  }
});

var _NumberValue = __webpack_require__(929);

Object.defineProperty(exports, "NumberValue", {
  enumerable: true,
  get: function () {
    return _NumberValue.NumberValue;
  }
});
Object.defineProperty(exports, "IntegralValue", {
  enumerable: true,
  get: function () {
    return _NumberValue.IntegralValue;
  }
});

var _ProxyValue = __webpack_require__(930);

Object.defineProperty(exports, "ProxyValue", {
  enumerable: true,
  get: function () {
    return _interopRequireDefault(_ProxyValue).default;
  }
});

var _StringExotic = __webpack_require__(931);

Object.defineProperty(exports, "StringExotic", {
  enumerable: true,
  get: function () {
    return _interopRequireDefault(_StringExotic).default;
  }
});

var _ArgumentsExotic = __webpack_require__(932);

Object.defineProperty(exports, "ArgumentsExotic", {
  enumerable: true,
  get: function () {
    return _interopRequireDefault(_ArgumentsExotic).default;
  }
});

var _IntegerIndexedExotic = __webpack_require__(933);

Object.defineProperty(exports, "IntegerIndexedExotic", {
  enumerable: true,
  get: function () {
    return _interopRequireDefault(_IntegerIndexedExotic).default;
  }
});

var _BooleanValue = __webpack_require__(934);

Object.defineProperty(exports, "BooleanValue", {
  enumerable: true,
  get: function () {
    return _interopRequireDefault(_BooleanValue).default;
  }
});

var _StringValue = __webpack_require__(935);

Object.defineProperty(exports, "StringValue", {
  enumerable: true,
  get: function () {
    return _interopRequireDefault(_StringValue).default;
  }
});

var _SymbolValue = __webpack_require__(936);

Object.defineProperty(exports, "SymbolValue", {
  enumerable: true,
  get: function () {
    return _interopRequireDefault(_SymbolValue).default;
  }
});

var _AbstractValue = __webpack_require__(368);

Object.defineProperty(exports, "AbstractValue", {
  enumerable: true,
  get: function () {
    return _interopRequireDefault(_AbstractValue).default;
  }
});
Object.defineProperty(exports, "AbstractValueBuildNodeFunction", {
  enumerable: true,
  get: function () {
    return _AbstractValue.AbstractValueBuildNodeFunction;
  }
});

var _AbstractObjectValue = __webpack_require__(370);

Object.defineProperty(exports, "AbstractObjectValue", {
  enumerable: true,
  get: function () {
    return _interopRequireDefault(_AbstractObjectValue).default;
  }
});

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/***/ }),
/* 1 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = invariant;
/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 */

function invariant(condition, format) {
  if (condition) return;
  const message = `${format}
This is likely a bug in Prepack, not your code. Feel free to open an issue on GitHub.`;
  let error = new Error(message);
  error.name = "Invariant Violation";
  throw error;
}

/***/ }),
/* 2 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setCreate = setCreate;
exports.setEnvironment = setEnvironment;
exports.setFunctions = setFunctions;
exports.setHavoc = setHavoc;
exports.setJoin = setJoin;
exports.setPath = setPath;
exports.setProperties = setProperties;
exports.setTo = setTo;
exports.setWiden = setWiden;
exports.setConcretize = setConcretize;
exports.setUtils = setUtils;
let Create = exports.Create = null; /**
                                     * Copyright (c) 2017-present, Facebook, Inc.
                                     * All rights reserved.
                                     *
                                     * This source code is licensed under the BSD-style license found in the
                                     * LICENSE file in the root directory of this source tree. An additional grant
                                     * of patent rights can be found in the PATENTS file in the same directory.
                                     */

let Environment = exports.Environment = null;
let Functions = exports.Functions = null;
let Havoc = exports.Havoc = null;
let Join = exports.Join = null;
let Path = exports.Path = null;
let Properties = exports.Properties = null;
let To = exports.To = null;
let Widen = exports.Widen = null;
let concretize = exports.concretize = null;
let Utils = exports.Utils = null;

function setCreate(singleton) {
  exports.Create = Create = singleton;
}

function setEnvironment(singleton) {
  exports.Environment = Environment = singleton;
}

function setFunctions(singleton) {
  exports.Functions = Functions = singleton;
}

function setHavoc(singleton) {
  exports.Havoc = Havoc = singleton;
}

function setJoin(singleton) {
  exports.Join = Join = singleton;
}

function setPath(singleton) {
  exports.Path = Path = singleton;
}

function setProperties(singleton) {
  exports.Properties = Properties = singleton;
}

function setTo(singleton) {
  exports.To = To = singleton;
}

function setWiden(singleton) {
  exports.Widen = Widen = singleton;
}

function setConcretize(singleton) {
  exports.concretize = concretize = singleton;
}

function setUtils(singleton) {
  exports.Utils = Utils = singleton;
}

/***/ }),
/* 3 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PossiblyNormalCompletion = exports.JoinedAbruptCompletions = exports.ReturnCompletion = exports.BreakCompletion = exports.ContinueCompletion = exports.ThrowCompletion = exports.AbruptCompletion = exports.NormalCompletion = exports.Completion = undefined;

var _invariant = __webpack_require__(1);

var _invariant2 = _interopRequireDefault(_invariant);

var _index = __webpack_require__(0);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class Completion {
  constructor(value, location, target) {
    this.value = value;
    this.target = target;
    this.location = location;
  }

}

exports.Completion = Completion; // Normal completions are returned just like spec completions
/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 */

class NormalCompletion extends Completion {}

exports.NormalCompletion = NormalCompletion; // Abrupt completions are thrown as exeptions, to make it a easier
// to quickly get to the matching high level construct.

class AbruptCompletion extends Completion {}

exports.AbruptCompletion = AbruptCompletion;
class ThrowCompletion extends AbruptCompletion {
  constructor(value, location, nativeStack) {
    super(value, location);
    this.nativeStack = nativeStack || new Error().stack;
  }

}
exports.ThrowCompletion = ThrowCompletion;
class ContinueCompletion extends AbruptCompletion {
  constructor(value, location, target) {
    super(value, location, target);
  }
}

exports.ContinueCompletion = ContinueCompletion;
class BreakCompletion extends AbruptCompletion {
  constructor(value, location, target) {
    super(value, location, target);
  }
}

exports.BreakCompletion = BreakCompletion;
class ReturnCompletion extends AbruptCompletion {
  constructor(value, location) {
    super(value, location);
  }
}

exports.ReturnCompletion = ReturnCompletion;
class JoinedAbruptCompletions extends AbruptCompletion {
  constructor(realm, joinCondition, consequent, consequentEffects, alternate, alternateEffects) {
    super(realm.intrinsics.empty, consequent.location);
    this.joinCondition = joinCondition;
    this.consequent = consequent;
    this.consequentEffects = consequentEffects;
    this.alternate = alternate;
    this.alternateEffects = alternateEffects;
  }

  containsBreakOrContinue() {
    if (this.consequent instanceof BreakCompletion || this.consequent instanceof ContinueCompletion) return true;
    if (this.alternate instanceof BreakCompletion || this.alternate instanceof ContinueCompletion) return true;
    if (this.consequent instanceof JoinedAbruptCompletions) {
      if (this.consequent.containsBreakOrContinue()) return true;
    }
    if (this.alternate instanceof JoinedAbruptCompletions) {
      if (this.alternate.containsBreakOrContinue()) return true;
    }
    return false;
  }
}

exports.JoinedAbruptCompletions = JoinedAbruptCompletions; // Possibly normal completions have to be treated like normal completions
// and are thus never thrown. At the end of a try block or loop body, however,
// action must be taken to deal with the possibly abrupt case of the completion.

class PossiblyNormalCompletion extends NormalCompletion {
  constructor(value, joinCondition, consequent, consequentEffects, alternate, alternateEffects, pathConditions, savedPathConditions, savedEffects = undefined) {
    (0, _invariant2.default)(consequent === consequentEffects[0]);
    (0, _invariant2.default)(alternate === alternateEffects[0]);
    (0, _invariant2.default)(consequent instanceof NormalCompletion || consequent instanceof _index.Value || alternate instanceof NormalCompletion || alternate instanceof _index.Value);
    (0, _invariant2.default)(consequent instanceof AbruptCompletion || alternate instanceof AbruptCompletion);
    (0, _invariant2.default)(value === consequent || consequent instanceof AbruptCompletion || consequent instanceof NormalCompletion && value === consequent.value);
    (0, _invariant2.default)(value === alternate || alternate instanceof AbruptCompletion || alternate instanceof NormalCompletion && value === alternate.value);
    let loc = consequent instanceof AbruptCompletion ? consequent.location : alternate instanceof Completion ? alternate.location : alternate.expressionLocation;
    super(value, loc);
    this.joinCondition = joinCondition;
    this.consequent = consequent;
    this.consequentEffects = consequentEffects;
    this.alternate = alternate;
    this.alternateEffects = alternateEffects;
    this.savedEffects = savedEffects;
    this.pathConditions = pathConditions;
    this.savedPathConditions = savedPathConditions;
  }

  containsBreakOrContinue() {
    if (this.consequent instanceof BreakCompletion || this.consequent instanceof ContinueCompletion) return true;
    if (this.alternate instanceof BreakCompletion || this.alternate instanceof ContinueCompletion) return true;
    if (this.consequent instanceof JoinedAbruptCompletions || this.consequent instanceof PossiblyNormalCompletion) {
      if (this.consequent.containsBreakOrContinue()) return true;
    }
    if (this.alternate instanceof JoinedAbruptCompletions || this.alternate instanceof PossiblyNormalCompletion) {
      if (this.alternate.containsBreakOrContinue()) return true;
    }
    return false;
  }
}
exports.PossiblyNormalCompletion = PossiblyNormalCompletion;

/***/ }),
/* 4 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;
exports.createTypeAnnotationBasedOnTypeof = exports.removeTypeDuplicates = exports.createUnionTypeAnnotation = exports.valueToNode = exports.toBlock = exports.toExpression = exports.toStatement = exports.toBindingIdentifierName = exports.toIdentifier = exports.toKeyAlias = exports.toSequenceExpression = exports.toComputedKey = exports.isNodesEquivalent = exports.isImmutable = exports.isScope = exports.isSpecifierDefault = exports.isVar = exports.isBlockScoped = exports.isLet = exports.isValidIdentifier = exports.isReferenced = exports.isBinding = exports.getOuterBindingIdentifiers = exports.getBindingIdentifiers = exports.TYPES = exports.react = exports.DEPRECATED_KEYS = exports.BUILDER_KEYS = exports.NODE_FIELDS = exports.ALIAS_KEYS = exports.VISITOR_KEYS = exports.NOT_LOCAL_BINDING = exports.BLOCK_SCOPED_SYMBOL = exports.INHERIT_KEYS = exports.UNARY_OPERATORS = exports.STRING_UNARY_OPERATORS = exports.NUMBER_UNARY_OPERATORS = exports.BOOLEAN_UNARY_OPERATORS = exports.BINARY_OPERATORS = exports.NUMBER_BINARY_OPERATORS = exports.BOOLEAN_BINARY_OPERATORS = exports.COMPARISON_BINARY_OPERATORS = exports.EQUALITY_BINARY_OPERATORS = exports.BOOLEAN_NUMBER_BINARY_OPERATORS = exports.UPDATE_OPERATORS = exports.LOGICAL_OPERATORS = exports.COMMENT_KEYS = exports.FOR_INIT_KEYS = exports.FLATTENABLE_KEYS = exports.STATEMENT_OR_BLOCK_KEYS = undefined;

var _getOwnPropertySymbols = __webpack_require__(787);

var _getOwnPropertySymbols2 = _interopRequireDefault(_getOwnPropertySymbols);

var _getIterator2 = __webpack_require__(13);

var _getIterator3 = _interopRequireDefault(_getIterator2);

var _keys = __webpack_require__(91);

var _keys2 = _interopRequireDefault(_keys);

var _stringify = __webpack_require__(108);

var _stringify2 = _interopRequireDefault(_stringify);

var _constants = __webpack_require__(214);

Object.defineProperty(exports, "STATEMENT_OR_BLOCK_KEYS", {
  enumerable: true,
  get: function get() {
    return _constants.STATEMENT_OR_BLOCK_KEYS;
  }
});
Object.defineProperty(exports, "FLATTENABLE_KEYS", {
  enumerable: true,
  get: function get() {
    return _constants.FLATTENABLE_KEYS;
  }
});
Object.defineProperty(exports, "FOR_INIT_KEYS", {
  enumerable: true,
  get: function get() {
    return _constants.FOR_INIT_KEYS;
  }
});
Object.defineProperty(exports, "COMMENT_KEYS", {
  enumerable: true,
  get: function get() {
    return _constants.COMMENT_KEYS;
  }
});
Object.defineProperty(exports, "LOGICAL_OPERATORS", {
  enumerable: true,
  get: function get() {
    return _constants.LOGICAL_OPERATORS;
  }
});
Object.defineProperty(exports, "UPDATE_OPERATORS", {
  enumerable: true,
  get: function get() {
    return _constants.UPDATE_OPERATORS;
  }
});
Object.defineProperty(exports, "BOOLEAN_NUMBER_BINARY_OPERATORS", {
  enumerable: true,
  get: function get() {
    return _constants.BOOLEAN_NUMBER_BINARY_OPERATORS;
  }
});
Object.defineProperty(exports, "EQUALITY_BINARY_OPERATORS", {
  enumerable: true,
  get: function get() {
    return _constants.EQUALITY_BINARY_OPERATORS;
  }
});
Object.defineProperty(exports, "COMPARISON_BINARY_OPERATORS", {
  enumerable: true,
  get: function get() {
    return _constants.COMPARISON_BINARY_OPERATORS;
  }
});
Object.defineProperty(exports, "BOOLEAN_BINARY_OPERATORS", {
  enumerable: true,
  get: function get() {
    return _constants.BOOLEAN_BINARY_OPERATORS;
  }
});
Object.defineProperty(exports, "NUMBER_BINARY_OPERATORS", {
  enumerable: true,
  get: function get() {
    return _constants.NUMBER_BINARY_OPERATORS;
  }
});
Object.defineProperty(exports, "BINARY_OPERATORS", {
  enumerable: true,
  get: function get() {
    return _constants.BINARY_OPERATORS;
  }
});
Object.defineProperty(exports, "BOOLEAN_UNARY_OPERATORS", {
  enumerable: true,
  get: function get() {
    return _constants.BOOLEAN_UNARY_OPERATORS;
  }
});
Object.defineProperty(exports, "NUMBER_UNARY_OPERATORS", {
  enumerable: true,
  get: function get() {
    return _constants.NUMBER_UNARY_OPERATORS;
  }
});
Object.defineProperty(exports, "STRING_UNARY_OPERATORS", {
  enumerable: true,
  get: function get() {
    return _constants.STRING_UNARY_OPERATORS;
  }
});
Object.defineProperty(exports, "UNARY_OPERATORS", {
  enumerable: true,
  get: function get() {
    return _constants.UNARY_OPERATORS;
  }
});
Object.defineProperty(exports, "INHERIT_KEYS", {
  enumerable: true,
  get: function get() {
    return _constants.INHERIT_KEYS;
  }
});
Object.defineProperty(exports, "BLOCK_SCOPED_SYMBOL", {
  enumerable: true,
  get: function get() {
    return _constants.BLOCK_SCOPED_SYMBOL;
  }
});
Object.defineProperty(exports, "NOT_LOCAL_BINDING", {
  enumerable: true,
  get: function get() {
    return _constants.NOT_LOCAL_BINDING;
  }
});
exports.is = is;
exports.isType = isType;
exports.validate = validate;
exports.shallowEqual = shallowEqual;
exports.appendToMemberExpression = appendToMemberExpression;
exports.prependToMemberExpression = prependToMemberExpression;
exports.ensureBlock = ensureBlock;
exports.clone = clone;
exports.cloneWithoutLoc = cloneWithoutLoc;
exports.cloneDeep = cloneDeep;
exports.buildMatchMemberExpression = buildMatchMemberExpression;
exports.removeComments = removeComments;
exports.inheritsComments = inheritsComments;
exports.inheritTrailingComments = inheritTrailingComments;
exports.inheritLeadingComments = inheritLeadingComments;
exports.inheritInnerComments = inheritInnerComments;
exports.inherits = inherits;
exports.assertNode = assertNode;
exports.isNode = isNode;
exports.traverseFast = traverseFast;
exports.removeProperties = removeProperties;
exports.removePropertiesDeep = removePropertiesDeep;

var _retrievers = __webpack_require__(347);

Object.defineProperty(exports, "getBindingIdentifiers", {
  enumerable: true,
  get: function get() {
    return _retrievers.getBindingIdentifiers;
  }
});
Object.defineProperty(exports, "getOuterBindingIdentifiers", {
  enumerable: true,
  get: function get() {
    return _retrievers.getOuterBindingIdentifiers;
  }
});

var _validators = __webpack_require__(791);

Object.defineProperty(exports, "isBinding", {
  enumerable: true,
  get: function get() {
    return _validators.isBinding;
  }
});
Object.defineProperty(exports, "isReferenced", {
  enumerable: true,
  get: function get() {
    return _validators.isReferenced;
  }
});
Object.defineProperty(exports, "isValidIdentifier", {
  enumerable: true,
  get: function get() {
    return _validators.isValidIdentifier;
  }
});
Object.defineProperty(exports, "isLet", {
  enumerable: true,
  get: function get() {
    return _validators.isLet;
  }
});
Object.defineProperty(exports, "isBlockScoped", {
  enumerable: true,
  get: function get() {
    return _validators.isBlockScoped;
  }
});
Object.defineProperty(exports, "isVar", {
  enumerable: true,
  get: function get() {
    return _validators.isVar;
  }
});
Object.defineProperty(exports, "isSpecifierDefault", {
  enumerable: true,
  get: function get() {
    return _validators.isSpecifierDefault;
  }
});
Object.defineProperty(exports, "isScope", {
  enumerable: true,
  get: function get() {
    return _validators.isScope;
  }
});
Object.defineProperty(exports, "isImmutable", {
  enumerable: true,
  get: function get() {
    return _validators.isImmutable;
  }
});
Object.defineProperty(exports, "isNodesEquivalent", {
  enumerable: true,
  get: function get() {
    return _validators.isNodesEquivalent;
  }
});

var _converters = __webpack_require__(794);

Object.defineProperty(exports, "toComputedKey", {
  enumerable: true,
  get: function get() {
    return _converters.toComputedKey;
  }
});
Object.defineProperty(exports, "toSequenceExpression", {
  enumerable: true,
  get: function get() {
    return _converters.toSequenceExpression;
  }
});
Object.defineProperty(exports, "toKeyAlias", {
  enumerable: true,
  get: function get() {
    return _converters.toKeyAlias;
  }
});
Object.defineProperty(exports, "toIdentifier", {
  enumerable: true,
  get: function get() {
    return _converters.toIdentifier;
  }
});
Object.defineProperty(exports, "toBindingIdentifierName", {
  enumerable: true,
  get: function get() {
    return _converters.toBindingIdentifierName;
  }
});
Object.defineProperty(exports, "toStatement", {
  enumerable: true,
  get: function get() {
    return _converters.toStatement;
  }
});
Object.defineProperty(exports, "toExpression", {
  enumerable: true,
  get: function get() {
    return _converters.toExpression;
  }
});
Object.defineProperty(exports, "toBlock", {
  enumerable: true,
  get: function get() {
    return _converters.toBlock;
  }
});
Object.defineProperty(exports, "valueToNode", {
  enumerable: true,
  get: function get() {
    return _converters.valueToNode;
  }
});

var _flow = __webpack_require__(801);

Object.defineProperty(exports, "createUnionTypeAnnotation", {
  enumerable: true,
  get: function get() {
    return _flow.createUnionTypeAnnotation;
  }
});
Object.defineProperty(exports, "removeTypeDuplicates", {
  enumerable: true,
  get: function get() {
    return _flow.removeTypeDuplicates;
  }
});
Object.defineProperty(exports, "createTypeAnnotationBasedOnTypeof", {
  enumerable: true,
  get: function get() {
    return _flow.createTypeAnnotationBasedOnTypeof;
  }
});

var _toFastProperties = __webpack_require__(802);

var _toFastProperties2 = _interopRequireDefault(_toFastProperties);

var _clone = __webpack_require__(350);

var _clone2 = _interopRequireDefault(_clone);

var _uniq = __webpack_require__(825);

var _uniq2 = _interopRequireDefault(_uniq);

__webpack_require__(833);

var _definitions = __webpack_require__(68);

var _react2 = __webpack_require__(840);

var _react = _interopRequireWildcard(_react2);

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var t = exports;

function registerType(type) {
  var is = t["is" + type];
  if (!is) {
    is = t["is" + type] = function (node, opts) {
      return t.is(type, node, opts);
    };
  }

  t["assert" + type] = function (node, opts) {
    opts = opts || {};
    if (!is(node, opts)) {
      throw new Error("Expected type " + (0, _stringify2.default)(type) + " with option " + (0, _stringify2.default)(opts));
    }
  };
}

exports.VISITOR_KEYS = _definitions.VISITOR_KEYS;
exports.ALIAS_KEYS = _definitions.ALIAS_KEYS;
exports.NODE_FIELDS = _definitions.NODE_FIELDS;
exports.BUILDER_KEYS = _definitions.BUILDER_KEYS;
exports.DEPRECATED_KEYS = _definitions.DEPRECATED_KEYS;
exports.react = _react;


for (var type in t.VISITOR_KEYS) {
  registerType(type);
}

t.FLIPPED_ALIAS_KEYS = {};

(0, _keys2.default)(t.ALIAS_KEYS).forEach(function (type) {
  t.ALIAS_KEYS[type].forEach(function (alias) {
    var types = t.FLIPPED_ALIAS_KEYS[alias] = t.FLIPPED_ALIAS_KEYS[alias] || [];
    types.push(type);
  });
});

(0, _keys2.default)(t.FLIPPED_ALIAS_KEYS).forEach(function (type) {
  t[type.toUpperCase() + "_TYPES"] = t.FLIPPED_ALIAS_KEYS[type];
  registerType(type);
});

var TYPES = exports.TYPES = (0, _keys2.default)(t.VISITOR_KEYS).concat((0, _keys2.default)(t.FLIPPED_ALIAS_KEYS)).concat((0, _keys2.default)(t.DEPRECATED_KEYS));

function is(type, node, opts) {
  if (!node) return false;

  var matches = isType(node.type, type);
  if (!matches) return false;

  if (typeof opts === "undefined") {
    return true;
  } else {
    return t.shallowEqual(node, opts);
  }
}

function isType(nodeType, targetType) {
  if (nodeType === targetType) return true;

  if (t.ALIAS_KEYS[targetType]) return false;

  var aliases = t.FLIPPED_ALIAS_KEYS[targetType];
  if (aliases) {
    if (aliases[0] === nodeType) return true;

    for (var _iterator = aliases, _isArray = Array.isArray(_iterator), _i = 0, _iterator = _isArray ? _iterator : (0, _getIterator3.default)(_iterator);;) {
      var _ref;

      if (_isArray) {
        if (_i >= _iterator.length) break;
        _ref = _iterator[_i++];
      } else {
        _i = _iterator.next();
        if (_i.done) break;
        _ref = _i.value;
      }

      var alias = _ref;

      if (nodeType === alias) return true;
    }
  }

  return false;
}

(0, _keys2.default)(t.BUILDER_KEYS).forEach(function (type) {
  var keys = t.BUILDER_KEYS[type];

  function builder() {
    if (arguments.length > keys.length) {
      throw new Error("t." + type + ": Too many arguments passed. Received " + arguments.length + " but can receive " + ("no more than " + keys.length));
    }

    var node = {};
    node.type = type;

    var i = 0;

    for (var _iterator2 = keys, _isArray2 = Array.isArray(_iterator2), _i2 = 0, _iterator2 = _isArray2 ? _iterator2 : (0, _getIterator3.default)(_iterator2);;) {
      var _ref2;

      if (_isArray2) {
        if (_i2 >= _iterator2.length) break;
        _ref2 = _iterator2[_i2++];
      } else {
        _i2 = _iterator2.next();
        if (_i2.done) break;
        _ref2 = _i2.value;
      }

      var _key = _ref2;

      var field = t.NODE_FIELDS[type][_key];

      var arg = arguments[i++];
      if (arg === undefined) arg = (0, _clone2.default)(field.default);

      node[_key] = arg;
    }

    for (var key in node) {
      validate(node, key, node[key]);
    }

    return node;
  }

  t[type] = builder;
  t[type[0].toLowerCase() + type.slice(1)] = builder;
});

var _loop = function _loop(_type) {
  var newType = t.DEPRECATED_KEYS[_type];

  function proxy(fn) {
    return function () {
      console.trace("The node type " + _type + " has been renamed to " + newType);
      return fn.apply(this, arguments);
    };
  }

  t[_type] = t[_type[0].toLowerCase() + _type.slice(1)] = proxy(t[newType]);
  t["is" + _type] = proxy(t["is" + newType]);
  t["assert" + _type] = proxy(t["assert" + newType]);
};

for (var _type in t.DEPRECATED_KEYS) {
  _loop(_type);
}

function validate(node, key, val) {
  if (!node) return;

  var fields = t.NODE_FIELDS[node.type];
  if (!fields) return;

  var field = fields[key];
  if (!field || !field.validate) return;
  if (field.optional && val == null) return;

  field.validate(node, key, val);
}

function shallowEqual(actual, expected) {
  var keys = (0, _keys2.default)(expected);

  for (var _iterator3 = keys, _isArray3 = Array.isArray(_iterator3), _i3 = 0, _iterator3 = _isArray3 ? _iterator3 : (0, _getIterator3.default)(_iterator3);;) {
    var _ref3;

    if (_isArray3) {
      if (_i3 >= _iterator3.length) break;
      _ref3 = _iterator3[_i3++];
    } else {
      _i3 = _iterator3.next();
      if (_i3.done) break;
      _ref3 = _i3.value;
    }

    var key = _ref3;

    if (actual[key] !== expected[key]) {
      return false;
    }
  }

  return true;
}

function appendToMemberExpression(member, append, computed) {
  member.object = t.memberExpression(member.object, member.property, member.computed);
  member.property = append;
  member.computed = !!computed;
  return member;
}

function prependToMemberExpression(member, prepend) {
  member.object = t.memberExpression(prepend, member.object);
  return member;
}

function ensureBlock(node) {
  var key = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : "body";

  return node[key] = t.toBlock(node[key], node);
}

function clone(node) {
  if (!node) return node;
  var newNode = {};
  for (var key in node) {
    if (key[0] === "_") continue;
    newNode[key] = node[key];
  }
  return newNode;
}

function cloneWithoutLoc(node) {
  var newNode = clone(node);
  delete newNode.loc;
  return newNode;
}

function cloneDeep(node) {
  if (!node) return node;
  var newNode = {};

  for (var key in node) {
    if (key[0] === "_") continue;

    var val = node[key];

    if (val) {
      if (val.type) {
        val = t.cloneDeep(val);
      } else if (Array.isArray(val)) {
        val = val.map(t.cloneDeep);
      }
    }

    newNode[key] = val;
  }

  return newNode;
}

function buildMatchMemberExpression(match, allowPartial) {
  var parts = match.split(".");

  return function (member) {
    if (!t.isMemberExpression(member)) return false;

    var search = [member];
    var i = 0;

    while (search.length) {
      var node = search.shift();

      if (allowPartial && i === parts.length) {
        return true;
      }

      if (t.isIdentifier(node)) {
        if (parts[i] !== node.name) return false;
      } else if (t.isStringLiteral(node)) {
        if (parts[i] !== node.value) return false;
      } else if (t.isMemberExpression(node)) {
        if (node.computed && !t.isStringLiteral(node.property)) {
          return false;
        } else {
          search.push(node.object);
          search.push(node.property);
          continue;
        }
      } else {
        return false;
      }

      if (++i > parts.length) {
        return false;
      }
    }

    return true;
  };
}

function removeComments(node) {
  for (var _iterator4 = t.COMMENT_KEYS, _isArray4 = Array.isArray(_iterator4), _i4 = 0, _iterator4 = _isArray4 ? _iterator4 : (0, _getIterator3.default)(_iterator4);;) {
    var _ref4;

    if (_isArray4) {
      if (_i4 >= _iterator4.length) break;
      _ref4 = _iterator4[_i4++];
    } else {
      _i4 = _iterator4.next();
      if (_i4.done) break;
      _ref4 = _i4.value;
    }

    var key = _ref4;

    delete node[key];
  }
  return node;
}

function inheritsComments(child, parent) {
  inheritTrailingComments(child, parent);
  inheritLeadingComments(child, parent);
  inheritInnerComments(child, parent);
  return child;
}

function inheritTrailingComments(child, parent) {
  _inheritComments("trailingComments", child, parent);
}

function inheritLeadingComments(child, parent) {
  _inheritComments("leadingComments", child, parent);
}

function inheritInnerComments(child, parent) {
  _inheritComments("innerComments", child, parent);
}

function _inheritComments(key, child, parent) {
  if (child && parent) {
    child[key] = (0, _uniq2.default)([].concat(child[key], parent[key]).filter(Boolean));
  }
}

function inherits(child, parent) {
  if (!child || !parent) return child;

  for (var _iterator5 = t.INHERIT_KEYS.optional, _isArray5 = Array.isArray(_iterator5), _i5 = 0, _iterator5 = _isArray5 ? _iterator5 : (0, _getIterator3.default)(_iterator5);;) {
    var _ref5;

    if (_isArray5) {
      if (_i5 >= _iterator5.length) break;
      _ref5 = _iterator5[_i5++];
    } else {
      _i5 = _iterator5.next();
      if (_i5.done) break;
      _ref5 = _i5.value;
    }

    var _key2 = _ref5;

    if (child[_key2] == null) {
      child[_key2] = parent[_key2];
    }
  }

  for (var key in parent) {
    if (key[0] === "_") child[key] = parent[key];
  }

  for (var _iterator6 = t.INHERIT_KEYS.force, _isArray6 = Array.isArray(_iterator6), _i6 = 0, _iterator6 = _isArray6 ? _iterator6 : (0, _getIterator3.default)(_iterator6);;) {
    var _ref6;

    if (_isArray6) {
      if (_i6 >= _iterator6.length) break;
      _ref6 = _iterator6[_i6++];
    } else {
      _i6 = _iterator6.next();
      if (_i6.done) break;
      _ref6 = _i6.value;
    }

    var _key3 = _ref6;

    child[_key3] = parent[_key3];
  }

  t.inheritsComments(child, parent);

  return child;
}

function assertNode(node) {
  if (!isNode(node)) {
    throw new TypeError("Not a valid node " + (node && node.type));
  }
}

function isNode(node) {
  return !!(node && _definitions.VISITOR_KEYS[node.type]);
}

(0, _toFastProperties2.default)(t);
(0, _toFastProperties2.default)(t.VISITOR_KEYS);

function traverseFast(node, enter, opts) {
  if (!node) return;

  var keys = t.VISITOR_KEYS[node.type];
  if (!keys) return;

  opts = opts || {};
  enter(node, opts);

  for (var _iterator7 = keys, _isArray7 = Array.isArray(_iterator7), _i7 = 0, _iterator7 = _isArray7 ? _iterator7 : (0, _getIterator3.default)(_iterator7);;) {
    var _ref7;

    if (_isArray7) {
      if (_i7 >= _iterator7.length) break;
      _ref7 = _iterator7[_i7++];
    } else {
      _i7 = _iterator7.next();
      if (_i7.done) break;
      _ref7 = _i7.value;
    }

    var key = _ref7;

    var subNode = node[key];

    if (Array.isArray(subNode)) {
      for (var _iterator8 = subNode, _isArray8 = Array.isArray(_iterator8), _i8 = 0, _iterator8 = _isArray8 ? _iterator8 : (0, _getIterator3.default)(_iterator8);;) {
        var _ref8;

        if (_isArray8) {
          if (_i8 >= _iterator8.length) break;
          _ref8 = _iterator8[_i8++];
        } else {
          _i8 = _iterator8.next();
          if (_i8.done) break;
          _ref8 = _i8.value;
        }

        var _node = _ref8;

        traverseFast(_node, enter, opts);
      }
    } else {
      traverseFast(subNode, enter, opts);
    }
  }
}

var CLEAR_KEYS = ["tokens", "start", "end", "loc", "raw", "rawValue"];

var CLEAR_KEYS_PLUS_COMMENTS = t.COMMENT_KEYS.concat(["comments"]).concat(CLEAR_KEYS);

function removeProperties(node, opts) {
  opts = opts || {};
  var map = opts.preserveComments ? CLEAR_KEYS : CLEAR_KEYS_PLUS_COMMENTS;
  for (var _iterator9 = map, _isArray9 = Array.isArray(_iterator9), _i9 = 0, _iterator9 = _isArray9 ? _iterator9 : (0, _getIterator3.default)(_iterator9);;) {
    var _ref9;

    if (_isArray9) {
      if (_i9 >= _iterator9.length) break;
      _ref9 = _iterator9[_i9++];
    } else {
      _i9 = _iterator9.next();
      if (_i9.done) break;
      _ref9 = _i9.value;
    }

    var _key4 = _ref9;

    if (node[_key4] != null) node[_key4] = undefined;
  }

  for (var key in node) {
    if (key[0] === "_" && node[key] != null) node[key] = undefined;
  }

  var syms = (0, _getOwnPropertySymbols2.default)(node);
  for (var _iterator10 = syms, _isArray10 = Array.isArray(_iterator10), _i10 = 0, _iterator10 = _isArray10 ? _iterator10 : (0, _getIterator3.default)(_iterator10);;) {
    var _ref10;

    if (_isArray10) {
      if (_i10 >= _iterator10.length) break;
      _ref10 = _iterator10[_i10++];
    } else {
      _i10 = _iterator10.next();
      if (_i10.done) break;
      _ref10 = _i10.value;
    }

    var sym = _ref10;

    node[sym] = null;
  }
}

function removePropertiesDeep(tree, opts) {
  traverseFast(tree, removeProperties, opts);
  return tree;
}

/***/ }),
/* 5 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _abstract = __webpack_require__(19);

Object.keys(_abstract).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _abstract[key];
    }
  });
});

var _call = __webpack_require__(20);

Object.keys(_call).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _call[key];
    }
  });
});

var _construct = __webpack_require__(35);

Object.keys(_construct).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _construct[key];
    }
  });
});

var _date = __webpack_require__(358);

Object.keys(_date).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _date[key];
    }
  });
});

var _descriptor = __webpack_require__(853);

Object.keys(_descriptor).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _descriptor[key];
    }
  });
});

var _get = __webpack_require__(11);

Object.keys(_get).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _get[key];
    }
  });
});

var _has = __webpack_require__(27);

Object.keys(_has).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _has[key];
    }
  });
});

var _hash = __webpack_require__(854);

Object.keys(_hash).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _hash[key];
    }
  });
});

var _integrity = __webpack_require__(356);

Object.keys(_integrity).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _integrity[key];
    }
  });
});

var _is = __webpack_require__(9);

Object.keys(_is).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _is[key];
    }
  });
});

var _iterator = __webpack_require__(76);

Object.keys(_iterator).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _iterator[key];
    }
  });
});

var _own = __webpack_require__(359);

Object.keys(_own).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _own[key];
    }
  });
});

var _destructuring = __webpack_require__(855);

Object.keys(_destructuring).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _destructuring[key];
    }
  });
});

var _regexp = __webpack_require__(159);

Object.keys(_regexp).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _regexp[key];
    }
  });
});

var _promise = __webpack_require__(220);

Object.keys(_promise).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _promise[key];
    }
  });
});

var _arraybuffer = __webpack_require__(92);

Object.keys(_arraybuffer).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _arraybuffer[key];
    }
  });
});

/***/ }),
/* 6 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});


// This is the error format used to report errors to the caller-supplied
// error-handler
/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 */

class CompilerDiagnostic extends Error {
  constructor(message, location, errorCode, severity) {
    super(message);

    this.location = location;
    this.severity = severity;
    this.errorCode = errorCode;
  }

}

exports.CompilerDiagnostic = CompilerDiagnostic; // This error is thrown to exit Prepack when an ErrorHandler returns 'FatalError'
// This should just be a class but Babel classes doesn't work with
// built-in super classes.

class FatalError extends Error {
  constructor(message) {
    super(message || "A fatal error occurred while prepacking.");
  }
}

exports.FatalError = FatalError;

/***/ }),
/* 7 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Realm = exports.ExecutionContext = exports.Tracer = undefined;
exports.construct_empty_effects = construct_empty_effects;

var _errors = __webpack_require__(6);

var _index = __webpack_require__(0);

var _environment = __webpack_require__(8);

var _index2 = __webpack_require__(5);

var _completions = __webpack_require__(3);

var _invariant = __webpack_require__(1);

var _invariant2 = _interopRequireDefault(_invariant);

var _seedrandom = __webpack_require__(371);

var _seedrandom2 = _interopRequireDefault(_seedrandom);

var _generator = __webpack_require__(23);

var _internalizer = __webpack_require__(93);

var _singletons = __webpack_require__(2);

var _babelTypes = __webpack_require__(4);

var t = _interopRequireWildcard(_babelTypes);

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 */

class Tracer {
  beginEvaluateForEffects(state) {}
  endEvaluateForEffects(state, effects) {}
  detourCall(F, thisArgument, argumentsList, newTarget, performCall) {}
  beforeCall(F, thisArgument, argumentsList, newTarget) {}
  afterCall(F, thisArgument, argumentsList, newTarget, result) {}
}

exports.Tracer = Tracer;
class ExecutionContext {

  setCaller(context) {
    this.caller = context;
  }

  setFunction(F) {
    if (F instanceof _index.ECMAScriptSourceFunctionValue) this.isStrict = F.$Strict;
    this.function = F;
  }

  setLocation(loc) {
    if (!loc) return;
    this.loc = loc;
  }

  setRealm(realm) {
    this.realm = realm;
  }

  /*
   Read-only envs disallow:
   - creating bindings in their scope
   - creating or modifying objects when they are current running context
  */
  setReadOnly(value) {
    let oldReadOnly = this.isReadOnly;
    if (this.variableEnvironment) this.variableEnvironment.environmentRecord.isReadOnly = value;
    if (this.lexicalEnvironment) this.lexicalEnvironment.environmentRecord.isReadOnly = value;
    this.isReadOnly = value;
    return oldReadOnly;
  }

  suspend() {
    // TODO #712: suspend
  }

  resume() {
    // TODO #712: resume
    return this.realm.intrinsics.undefined;
  }
}

exports.ExecutionContext = ExecutionContext;
function construct_empty_effects(realm) {
  return [realm.intrinsics.empty, new _generator.Generator(realm), new Map(), new Map(), new Set()];
}

class Realm {
  constructor(opts) {
    this.contextStack = [];
    this.MOBILE_JSC_VERSION = "jsc-600-1-4-17";
    this.objectCount = 0;
    this.symbolCount = 867501803871088;
    this.functionBodyUniqueTagSeed = 1;
    this.nextGeneratorId = 0;

    this.isReadOnly = false;
    this.useAbstractInterpretation = !!opts.serialize || !!opts.residual || !!opts.check;
    this.trackLeaks = !!opts.abstractEffectsInAdditionalFunctions;
    this.ignoreLeakLogic = false;
    this.isInPureTryStatement = false;
    if (opts.mathRandomSeed !== undefined) {
      this.mathRandomGenerator = (0, _seedrandom2.default)(opts.mathRandomSeed);
    }
    this.strictlyMonotonicDateNow = !!opts.strictlyMonotonicDateNow;

    this.timeout = opts.timeout;
    if (this.timeout) {
      // We'll call Date.now for every this.timeoutCounterThreshold'th AST node.
      // The threshold is there to reduce the cost of the surprisingly expensive Date.now call.
      this.timeoutCounter = this.timeoutCounterThreshold = 1024;
    }

    this.start = Date.now();
    this.compatibility = opts.compatibility || "browser";
    this.maxStackDepth = opts.maxStackDepth || 225;
    this.omitInvariants = !!opts.omitInvariants;
    this.emitConcreteModel = !!opts.emitConcreteModel;

    this.$TemplateMap = [];

    if (this.useAbstractInterpretation) {
      this.preludeGenerator = new _generator.PreludeGenerator(opts.debugNames, opts.uniqueSuffix);
      this.pathConditions = [];
      _index.ObjectValue.setupTrackedPropertyAccessors(_index.ObjectValue.trackedPropertyNames);
      _index.ObjectValue.setupTrackedPropertyAccessors(_index.NativeFunctionValue.trackedPropertyNames);
      _index.ObjectValue.setupTrackedPropertyAccessors(_index.ProxyValue.trackedPropertyNames);
    }

    this.tracers = [];

    // These get initialized in construct_realm to avoid the dependency
    this.intrinsics = {};
    this.$GlobalObject = {};
    this.evaluators = Object.create(null);
    this.partialEvaluators = Object.create(null);
    this.$GlobalEnv = undefined;

    this.react = {
      abstractHints: new WeakMap(),
      classComponentMetadata: new Map(),
      currentOwner: undefined,
      enabled: opts.reactEnabled || false,
      output: opts.reactOutput || "create-element",
      hoistableFunctions: new WeakMap(),
      hoistableReactElements: new WeakMap(),
      reactElements: new WeakSet(),
      symbols: new Map()
    };

    this.stripFlow = opts.stripFlow || false;

    this.fbLibraries = {
      other: new Map(),
      react: undefined,
      reactRelay: undefined
    };

    this.errorHandler = opts.errorHandler;

    this.globalSymbolRegistry = [];
    this.activeLexicalEnvironments = new Set();
    this._abstractValuesDefined = new Set(); // A set of nameStrings to ensure abstract values have unique names
    this.debugNames = opts.debugNames;
  } // TODO(1264): Remove this once we implement proper exception handling in abstract calls.


  // A list of abstract conditions that are known to be true in the current execution path.
  // For example, the abstract condition of an if statement is known to be true inside its true branch.

  // Unique tag for identifying function body ast node. It is neeeded
  // instead of ast node itself because we may perform ast tree deep clone
  // during serialization which changes the ast identity.


  // to force flow to type the annotations
  isCompatibleWith(compatibility) {
    return compatibility === this.compatibility;
  }

  // Checks if there is a let binding at global scope with the given name
  // returning it if so
  getGlobalLetBinding(key) {
    let globrec = this.$GlobalEnv.environmentRecord;
    // GlobalEnv should have a GlobalEnvironmentRecord
    (0, _invariant2.default)(globrec instanceof _environment.GlobalEnvironmentRecord);
    let dclrec = globrec.$DeclarativeRecord;

    try {
      return dclrec.HasBinding(key) ? dclrec.GetBindingValue(key, false) : undefined;
    } catch (e) {
      if (e instanceof _errors.FatalError) return undefined;
      throw e;
    }
  }

  /*
   Read only realms disallow:
   - using console.log
   - creating bindings in any existing scopes
   - modifying object properties in any existing scopes
   Setting a realm read-only sets all contained environments to read-only, but
   all new environments (e.g. new ExecutionContexts) will be writeable.
   */
  setReadOnly(readOnlyValue) {
    this.isReadOnly = readOnlyValue;
    this.$GlobalEnv.environmentRecord.isReadOnly = readOnlyValue;
    this.contextStack.forEach(ctx => {
      ctx.setReadOnly(readOnlyValue);
    });
  }

  testTimeout() {
    let timeout = this.timeout;
    if (timeout && ! --this.timeoutCounter) {
      this.timeoutCounter = this.timeoutCounterThreshold;
      let total = Date.now() - this.start;
      if (total > timeout) {
        throw new _errors.FatalError("Timed out");
      }
    }
  }

  hasRunningContext() {
    return this.contextStack.length !== 0;
  }

  getRunningContext() {
    let context = this.contextStack[this.contextStack.length - 1];
    (0, _invariant2.default)(context, "There's no running execution context");
    return context;
  }

  clearBlockBindings(modifiedBindings, environmentRecord) {
    if (modifiedBindings === undefined) return;
    for (let b of modifiedBindings.keys()) if (environmentRecord.bindings[b.name] && environmentRecord.bindings[b.name] === b) modifiedBindings.delete(b);
  }

  clearBlockBindingsFromCompletion(completion, environmentRecord) {
    if (completion instanceof _completions.PossiblyNormalCompletion) {
      this.clearBlockBindings(completion.alternateEffects[2], environmentRecord);
      this.clearBlockBindings(completion.consequentEffects[2], environmentRecord);
      if (completion.savedEffects !== undefined) this.clearBlockBindings(completion.savedEffects[2], environmentRecord);
      if (completion.alternate instanceof _completions.Completion) this.clearBlockBindingsFromCompletion(completion.alternate, environmentRecord);
      if (completion.consequent instanceof _completions.Completion) this.clearBlockBindingsFromCompletion(completion.consequent, environmentRecord);
    } else if (completion instanceof _completions.JoinedAbruptCompletions) {
      this.clearBlockBindings(completion.alternateEffects[2], environmentRecord);
      this.clearBlockBindings(completion.consequentEffects[2], environmentRecord);
      if (completion.alternate instanceof _completions.Completion) this.clearBlockBindingsFromCompletion(completion.alternate, environmentRecord);
      if (completion.consequent instanceof _completions.Completion) this.clearBlockBindingsFromCompletion(completion.consequent, environmentRecord);
    }
  }

  // Call when a scope falls out of scope and should be destroyed.
  // Clears the Bindings corresponding to the disappearing Scope from ModifiedBindings
  onDestroyScope(lexicalEnvironment) {
    (0, _invariant2.default)(this.activeLexicalEnvironments.has(lexicalEnvironment));
    let modifiedBindings = this.modifiedBindings;
    if (modifiedBindings) {
      // Don't undo things to global scope because it's needed past its destruction point (for serialization)
      let environmentRecord = lexicalEnvironment.environmentRecord;
      if (environmentRecord instanceof _environment.DeclarativeEnvironmentRecord) {
        this.clearBlockBindings(modifiedBindings, environmentRecord);
        if (this.savedCompletion !== undefined) this.clearBlockBindingsFromCompletion(this.savedCompletion, environmentRecord);
      }
    }

    // Ensures if we call onDestroyScope too early, there will be a failure.
    this.activeLexicalEnvironments.delete(lexicalEnvironment);
    lexicalEnvironment.destroy();
  }

  pushContext(context) {
    if (this.contextStack.length >= this.maxStackDepth) {
      throw new _errors.FatalError("Maximum stack depth exceeded");
    }
    this.contextStack.push(context);
  }

  clearFunctionBindings(modifiedBindings, funcVal) {
    if (modifiedBindings === undefined) return;
    for (let b of modifiedBindings.keys()) {
      if (b.environment.$FunctionObject === funcVal) modifiedBindings.delete(b);
    }
  }

  clearFunctionBindingsFromCompletion(completion, funcVal) {
    if (completion instanceof _completions.PossiblyNormalCompletion) {
      this.clearFunctionBindings(completion.alternateEffects[2], funcVal);
      this.clearFunctionBindings(completion.consequentEffects[2], funcVal);
      if (completion.savedEffects !== undefined) this.clearFunctionBindings(completion.savedEffects[2], funcVal);
      if (completion.alternate instanceof _completions.Completion) this.clearFunctionBindingsFromCompletion(completion.alternate, funcVal);
      if (completion.consequent instanceof _completions.Completion) this.clearFunctionBindingsFromCompletion(completion.consequent, funcVal);
    } else if (completion instanceof _completions.JoinedAbruptCompletions) {
      this.clearFunctionBindings(completion.alternateEffects[2], funcVal);
      this.clearFunctionBindings(completion.consequentEffects[2], funcVal);
      if (completion.alternate instanceof _completions.Completion) this.clearFunctionBindingsFromCompletion(completion.alternate, funcVal);
      if (completion.consequent instanceof _completions.Completion) this.clearFunctionBindingsFromCompletion(completion.consequent, funcVal);
    }
  }

  popContext(context) {
    let funcVal = context.function;
    if (funcVal) {
      this.clearFunctionBindings(this.modifiedBindings, funcVal);
      if (this.savedCompletion !== undefined) this.clearFunctionBindingsFromCompletion(this.savedCompletion, funcVal);
    }
    let c = this.contextStack.pop();
    (0, _invariant2.default)(c === context);
  }

  wrapInGlobalEnv(callback) {
    let context = new ExecutionContext();
    context.isStrict = this.isStrict;
    context.lexicalEnvironment = this.$GlobalEnv;
    context.variableEnvironment = this.$GlobalEnv;
    context.realm = this;

    this.pushContext(context);
    try {
      return callback();
    } finally {
      this.popContext(context);
    }
  }

  assignToGlobal(name, value) {
    this.wrapInGlobalEnv(() => this.$GlobalEnv.assignToGlobal(name, value));
  }

  deleteGlobalBinding(name) {
    this.$GlobalEnv.environmentRecord.DeleteBinding(name);
  }

  // Evaluate a context as if it won't have any side-effects outside of any objects
  // that it created itself. This promises that any abstract functions inside of it
  // also won't have effects on any objects or bindings that weren't created in this
  // call.
  evaluatePure(f) {
    if (!this.trackLeaks) {
      return f();
    }
    let saved_createdObjectsTrackedForLeaks = this.createdObjectsTrackedForLeaks;
    // Track all objects (including function closures) created during
    // this call. This will be used to make the assumption that every
    // *other* object is unchanged (pure). These objects are marked
    // as leaked if they're passed to abstract functions.
    this.createdObjectsTrackedForLeaks = new Set();
    try {
      return f();
    } finally {
      this.createdObjectsTrackedForLeaks = saved_createdObjectsTrackedForLeaks;
    }
  }

  isInPureScope() {
    return !!this.createdObjectsTrackedForLeaks;
  }

  evaluateWithoutLeakLogic(f) {
    (0, _invariant2.default)(!this.ignoreLeakLogic, "Nesting evaluateWithoutLeakLogic() calls is not supported.");
    this.ignoreLeakLogic = true;
    try {
      return f();
    } finally {
      this.ignoreLeakLogic = false;
    }
  }

  // Evaluate some code that might generate temporal values knowing that it might end in an abrupt
  // completion. We only need to support ThrowCompletion for now but this can be expanded to support other
  // abrupt completions.
  evaluateWithPossibleThrowCompletion(f, thrownTypes, thrownValues) {
    // The cases when we need this are only when we might invoke unknown code such as abstract
    // funtions, getters, custom coercion etc. It is possible we can use this in other cases
    // where something might throw a built-in error but can never issue arbitrary code such as
    // calling something that might not be a function. For now we only use it in pure functions.
    (0, _invariant2.default)(this.isInPureScope(), "only abstract abrupt completion in pure functions");

    // TODO(1264): We should create a new generator for this scope and wrap it in a try/catch.
    // We could use the outcome of that as the join condition for a PossiblyNormalCompletion.
    // We should then compose that with the saved completion and move on to the normal route.
    // Currently we just issue a recoverable error instead if this might matter.
    let value = f();
    if (this.isInPureTryStatement) {
      let diag = new _errors.CompilerDiagnostic("Possible throw inside try/catch is not yet supported", this.currentLocation, "PP0021", "RecoverableError");
      if (this.handleError(diag) !== "Recover") throw new _errors.FatalError();
    }
    return value;
  }

  // Evaluate the given ast in a sandbox and return the evaluation results
  // in the form of a completion, a code generator, a map of changed variable
  // bindings and a map of changed property bindings.
  evaluateNodeForEffects(ast, strictCode, env, state, generatorName) {
    return this.evaluateForEffects(() => env.evaluateCompletionDeref(ast, strictCode), state, generatorName);
  }

  evaluateForEffectsInGlobalEnv(func, state, generatorName) {
    return this.wrapInGlobalEnv(() => this.evaluateForEffects(func, state, generatorName));
  }

  // NB: does not apply generators because there's no way to cleanly revert them.
  // func should not return undefined
  withEffectsAppliedInGlobalEnv(func, effects) {
    let result;
    this.evaluateForEffectsInGlobalEnv(() => {
      try {
        this.applyEffects(effects);
        result = func(effects);
        return this.intrinsics.undefined;
      } finally {
        this.restoreBindings(effects[2]);
        this.restoreProperties(effects[3]);
      }
    });
    (0, _invariant2.default)(result !== undefined, "If we get here, func must have returned undefined.");
    return result;
  }

  evaluateNodeForEffectsInGlobalEnv(node, state, generatorName) {
    return this.wrapInGlobalEnv(() => this.evaluateNodeForEffects(node, false, this.$GlobalEnv, state, generatorName));
  }

  partiallyEvaluateNodeForEffects(ast, strictCode, env) {
    let nodeAst, nodeIO;
    function partialEval() {
      let result;
      [result, nodeAst, nodeIO] = env.partiallyEvaluateCompletionDeref(ast, strictCode);
      return result;
    }
    let effects = this.evaluateForEffects(partialEval);
    (0, _invariant2.default)(nodeAst !== undefined && nodeIO !== undefined);
    return [effects, nodeAst, nodeIO];
  }

  evaluateForEffects(f, state, generatorName) {
    // Save old state and set up empty state for ast
    let [savedBindings, savedProperties] = this.getAndResetModifiedMaps();
    let saved_generator = this.generator;
    let saved_createdObjects = this.createdObjects;
    let saved_completion = this.savedCompletion;
    this.generator = new _generator.Generator(this, generatorName);
    this.createdObjects = new Set();
    this.savedCompletion = undefined; // while in this call, we only explore the normal path.

    let result;
    try {
      for (let t1 of this.tracers) t1.beginEvaluateForEffects(state);

      let c;
      try {
        try {
          c = f();
          if (c instanceof _environment.Reference) c = _singletons.Environment.GetValue(this, c);
        } catch (e) {
          if (e instanceof _completions.AbruptCompletion) c = e;else throw e;
        }
        // This is a join point for the normal branch of a PossiblyNormalCompletion.
        if (c instanceof _index.Value || c instanceof _completions.AbruptCompletion) c = _singletons.Functions.incorporateSavedCompletion(this, c);
        (0, _invariant2.default)(c !== undefined);
        if (c instanceof _completions.PossiblyNormalCompletion) {
          // The current state may have advanced since the time control forked into the various paths recorded in c.
          // Update the normal path and restore the global state to what it was at the time of the fork.
          let subsequentEffects = this.getCapturedEffects(c, c.value);
          (0, _invariant2.default)(subsequentEffects !== undefined);
          this.stopEffectCaptureAndUndoEffects(c);
          _singletons.Join.updatePossiblyNormalCompletionWithSubsequentEffects(this, c, subsequentEffects);
          this.savedCompletion = undefined;
        }

        (0, _invariant2.default)(this.generator !== undefined);
        (0, _invariant2.default)(this.modifiedBindings !== undefined);
        (0, _invariant2.default)(this.modifiedProperties !== undefined);
        (0, _invariant2.default)(this.createdObjects !== undefined);
        let astGenerator = this.generator;
        let astBindings = this.modifiedBindings;
        let astProperties = this.modifiedProperties;
        let astCreatedObjects = this.createdObjects;

        // Return the captured state changes and evaluation result
        result = [c, astGenerator, astBindings, astProperties, astCreatedObjects];
        return result;
      } finally {
        // Roll back the state changes
        if (this.savedCompletion !== undefined) this.stopEffectCaptureAndUndoEffects(this.savedCompletion);
        if (result !== undefined) {
          this.restoreBindings(result[2]);
          this.restoreProperties(result[3]);
        } else {
          this.restoreBindings(this.modifiedBindings);
          this.restoreProperties(this.modifiedProperties);
        }
        this.generator = saved_generator;
        this.modifiedBindings = savedBindings;
        this.modifiedProperties = savedProperties;
        this.createdObjects = saved_createdObjects;
        this.savedCompletion = saved_completion;
      }
    } finally {
      for (let t2 of this.tracers) t2.endEvaluateForEffects(state, result);
    }
  }

  evaluateWithUndo(f, defaultValue = this.intrinsics.undefined) {
    if (!this.useAbstractInterpretation) return f();
    let oldErrorHandler = this.errorHandler;
    this.errorHandler = d => {
      if (d.severity === "Information" || d.severity === "Warning") return "Recover";
      return "Fail";
    };
    try {
      let effects = this.evaluateForEffects(() => {
        try {
          return f();
        } catch (e) {
          if (e instanceof _completions.Completion) {
            return defaultValue;
          } else if (e instanceof _errors.FatalError) {
            return defaultValue;
          } else {
            throw e;
          }
        }
      });
      return effects[0] instanceof _index.Value ? effects[0] : defaultValue;
    } finally {
      this.errorHandler = oldErrorHandler;
    }
  }

  evaluateWithUndoForDiagnostic(f) {
    if (!this.useAbstractInterpretation) return f();
    let savedHandler = this.errorHandler;
    let diagnostic;
    try {
      this.errorHandler = d => {
        diagnostic = d;
        return "Fail";
      };
      let effects = this.evaluateForEffects(f);
      this.applyEffects(effects);
      let resultVal = effects[0];
      if (resultVal instanceof _completions.AbruptCompletion) throw resultVal;
      if (resultVal instanceof _completions.PossiblyNormalCompletion) {
        // in this case one of the branches may complete abruptly, which means that
        // not all control flow branches join into one flow at this point.
        // Consequently we have to continue tracking changes until the point where
        // all the branches come together into one.
        resultVal = this.composeWithSavedCompletion(resultVal);
      }
      (0, _invariant2.default)(resultVal instanceof _index.Value);
      return resultVal;
    } catch (e) {
      if (diagnostic !== undefined) return diagnostic;
      throw e;
    } finally {
      this.errorHandler = savedHandler;
    }
  }

  evaluateForFixpointEffects(loopContinueTest, loopBody) {
    try {
      let effects1 = this.evaluateForEffects(loopBody);
      while (true) {
        this.restoreBindings(effects1[2]);
        this.restoreProperties(effects1[3]);
        let effects2 = this.evaluateForEffects(() => {
          let test = loopContinueTest();
          if (!(test instanceof _index.AbstractValue)) throw new _errors.FatalError("loop terminates before fixed point");
          return loopBody();
        });
        this.restoreBindings(effects1[2]);
        this.restoreProperties(effects1[3]);
        if (_singletons.Widen.containsEffects(effects1, effects2)) {
          // effects1 includes every value present in effects2, so doing another iteration using effects2 will not
          // result in any more values being added to abstract domains and hence a fixpoint has been reached.
          let [, gen, bindings2, pbindings2] = effects2;
          this._emitPropertAssignments(gen, pbindings2);
          this._emitLocalAssignments(gen, bindings2);
          return [effects1, effects2];
        }
        effects1 = _singletons.Widen.widenEffects(this, effects1, effects2);
      }
    } catch (e) {
      return undefined;
    }
  }

  // populate the loop body generator with assignments that will update the phiNodes
  _emitLocalAssignments(gen, bindings) {
    let tvalFor = new Map();
    bindings.forEach((binding, key, map) => {
      let val = binding.value;
      if (val instanceof _index.AbstractValue) {
        (0, _invariant2.default)(val._buildNode !== undefined);
        let tval = gen.derive(val.types, val.values, [val], ([n]) => n, {
          skipInvariant: true
        });
        tvalFor.set(key, tval);
      }
    });
    bindings.forEach((binding, key, map) => {
      let val = binding.value;
      if (val instanceof _index.AbstractValue) {
        let phiNode = key.phiNode;
        let tval = tvalFor.get(key);
        (0, _invariant2.default)(tval !== undefined);
        gen.emitStatement([tval], ([v]) => {
          (0, _invariant2.default)(phiNode !== undefined);
          let id = phiNode.buildNode([]);
          return t.expressionStatement(t.assignmentExpression("=", id, v));
        });
      }
    });
  }

  // populate the loop body generator with assignments that will update properties modified inside the loop
  _emitPropertAssignments(gen, pbindings) {
    function isSelfReferential(value, pathNode) {
      if (value === pathNode) return true;
      if (value instanceof _index.AbstractValue && pathNode !== undefined) {
        for (let v of value.args) {
          if (isSelfReferential(v, pathNode)) return true;
        }
      }
      return false;
    }

    let tvalFor = new Map();
    pbindings.forEach((val, key, map) => {
      let value = val && val.value;
      if (value instanceof _index.AbstractValue) {
        (0, _invariant2.default)(value._buildNode !== undefined);
        let tval = gen.derive(value.types, value.values, [key.object, value], ([o, n]) => {
          (0, _invariant2.default)(value instanceof _index.Value);
          if (typeof key.key === "string" && value.mightHaveBeenDeleted() && isSelfReferential(value, key.pathNode)) {
            let inTest = t.binaryExpression("in", t.stringLiteral(key.key), o);
            let addEmpty = t.conditionalExpression(inTest, n, _internalizer.emptyExpression);
            n = t.logicalExpression("||", n, addEmpty);
          }
          return n;
        }, {
          skipInvariant: true
        });
        tvalFor.set(key, tval);
      }
    });
    pbindings.forEach((val, key, map) => {
      let path = key.pathNode;
      let tval = tvalFor.get(key);
      (0, _invariant2.default)(val !== undefined);
      let value = val.value;
      (0, _invariant2.default)(value instanceof _index.Value);
      let mightHaveBeenDeleted = value.mightHaveBeenDeleted();
      let mightBeUndefined = value.mightBeUndefined();
      if (typeof key.key === "string") {
        gen.emitStatement([key.object, tval || value, this.intrinsics.empty], ([o, v, e]) => {
          (0, _invariant2.default)(path !== undefined);
          let lh = path.buildNode([o, t.identifier(key.key)]);
          let r = t.expressionStatement(t.assignmentExpression("=", lh, v));
          if (mightHaveBeenDeleted) {
            // If v === __empty || (v === undefined  && !(key.key in o))  then delete it
            let emptyTest = t.binaryExpression("===", v, e);
            let undefinedTest = t.binaryExpression("===", v, _internalizer.voidExpression);
            let inTest = t.unaryExpression("!", t.binaryExpression("in", t.stringLiteral(key.key), o));
            let guard = t.logicalExpression("||", emptyTest, t.logicalExpression("&&", undefinedTest, inTest));
            let deleteIt = t.expressionStatement(t.unaryExpression("delete", lh));
            return t.ifStatement(mightBeUndefined ? emptyTest : guard, deleteIt, r);
          }
          return r;
        });
      } else {
        gen.emitStatement([key.object, key.key, tval || value, this.intrinsics.empty], ([o, p, v, e]) => {
          (0, _invariant2.default)(path !== undefined);
          let lh = path.buildNode([o, p]);
          return t.expressionStatement(t.assignmentExpression("=", lh, v));
        });
      }
    });
  }

  composeEffects(priorEffects, subsequentEffects) {
    let [, pg, pb, pp, po] = priorEffects;
    let [sc, sg, sb, sp, so] = subsequentEffects;
    let result = construct_empty_effects(this);
    let [,, rb, rp, ro] = result;

    result[0] = sc;

    result[1] = _singletons.Join.composeGenerators(this, pg || result[1], sg);

    if (pb) {
      pb.forEach((val, key, m) => rb.set(key, val));
    }
    sb.forEach((val, key, m) => rb.set(key, val));

    if (pp) {
      pp.forEach((desc, propertyBinding, m) => rp.set(propertyBinding, desc));
    }
    sp.forEach((val, key, m) => rp.set(key, val));

    if (po) {
      po.forEach((ob, a) => ro.add(ob));
    }
    so.forEach((ob, a) => ro.add(ob));

    return result;
  }

  updateAbruptCompletions(priorEffects, c) {
    if (c.consequent instanceof _completions.AbruptCompletion) {
      c.consequentEffects = this.composeEffects(priorEffects, c.consequentEffects);
      let alternate = c.alternate;
      if (alternate instanceof _completions.PossiblyNormalCompletion) this.updateAbruptCompletions(priorEffects, alternate);
    } else {
      (0, _invariant2.default)(c.alternate instanceof _completions.AbruptCompletion);
      c.alternateEffects = this.composeEffects(priorEffects, c.alternateEffects);
      let consequent = c.consequent;
      if (consequent instanceof _completions.PossiblyNormalCompletion) this.updateAbruptCompletions(priorEffects, consequent);
    }
  }

  composeWithSavedCompletion(completion) {
    if (this.savedCompletion === undefined) {
      this.savedCompletion = completion;
      this.savedCompletion.savedPathConditions = this.pathConditions;
      this.captureEffects(completion);
    } else {
      this.savedCompletion = _singletons.Join.composePossiblyNormalCompletions(this, this.savedCompletion, completion);
    }
    if (completion.consequent instanceof _completions.AbruptCompletion) {
      _singletons.Path.pushInverseAndRefine(completion.joinCondition);
      if (completion.alternate instanceof _completions.PossiblyNormalCompletion) {
        completion.alternate.pathConditions.forEach(_singletons.Path.pushAndRefine);
      }
    } else if (completion.alternate instanceof _completions.AbruptCompletion) {
      _singletons.Path.pushAndRefine(completion.joinCondition);
      if (completion.consequent instanceof _completions.PossiblyNormalCompletion) {
        completion.consequent.pathConditions.forEach(_singletons.Path.pushAndRefine);
      }
    }
    return completion.value;
  }

  incorporatePriorSavedCompletion(priorCompletion) {
    if (priorCompletion === undefined) return;
    if (this.savedCompletion === undefined) {
      this.savedCompletion = priorCompletion;
      this.captureEffects(priorCompletion);
    } else {
      (0, _invariant2.default)(priorCompletion.savedEffects !== undefined);
      let savedEffects = this.savedCompletion.savedEffects;
      (0, _invariant2.default)(savedEffects !== undefined);
      this.restoreBindings(savedEffects[2]);
      this.restoreProperties(savedEffects[3]);
      _singletons.Join.updatePossiblyNormalCompletionWithSubsequentEffects(this, priorCompletion, savedEffects);
      this.restoreBindings(savedEffects[2]);
      this.restoreProperties(savedEffects[3]);
      (0, _invariant2.default)(this.savedCompletion !== undefined);
      this.savedCompletion.savedEffects = undefined;
      this.savedCompletion = _singletons.Join.composePossiblyNormalCompletions(this, priorCompletion, this.savedCompletion);
    }
  }

  captureEffects(completion) {
    if (completion.savedEffects !== undefined) {
      // Already called captureEffects, just carry on
      return;
    }
    completion.savedEffects = [this.intrinsics.undefined, this.generator, this.modifiedBindings, this.modifiedProperties, this.createdObjects];
    this.generator = new _generator.Generator(this);
    this.modifiedBindings = new Map();
    this.modifiedProperties = new Map();
    this.createdObjects = new Set();
  }

  getCapturedEffects(completion, v) {
    if (completion.savedEffects === undefined) return undefined;
    if (v === undefined) v = this.intrinsics.undefined;
    (0, _invariant2.default)(this.generator !== undefined);
    (0, _invariant2.default)(this.modifiedBindings !== undefined);
    (0, _invariant2.default)(this.modifiedProperties !== undefined);
    (0, _invariant2.default)(this.createdObjects !== undefined);
    return [v, this.generator, this.modifiedBindings, this.modifiedProperties, this.createdObjects];
  }

  stopEffectCapture(completion) {
    let e = this.getCapturedEffects(completion);
    if (e !== undefined) {
      this.stopEffectCaptureAndUndoEffects(completion);
      this.applyEffects(e);
    }
  }

  stopEffectCaptureAndUndoEffects(completion) {
    // Roll back the state changes
    this.restoreBindings(this.modifiedBindings);
    this.restoreProperties(this.modifiedProperties);

    // Restore saved state
    if (completion.savedEffects !== undefined) {
      let [c, g, b, p, o] = completion.savedEffects;
      c;
      completion.savedEffects = undefined;
      this.generator = g;
      this.modifiedBindings = b;
      this.modifiedProperties = p;
      this.createdObjects = o;
    } else {
      (0, _invariant2.default)(false);
    }
  }

  // Apply the given effects to the global state
  applyEffects(effects, leadingComment = "") {
    let [, generator, bindings, properties, createdObjects] = effects;

    // Add generated code for property modifications
    this.appendGenerator(generator, leadingComment);

    // Restore bindings
    this.restoreBindings(bindings);
    this.restoreProperties(properties);

    // track bindings
    let realmModifiedBindings = this.modifiedBindings;
    if (realmModifiedBindings !== undefined) {
      bindings.forEach((val, key, m) => {
        (0, _invariant2.default)(realmModifiedBindings !== undefined);
        if (!realmModifiedBindings.has(key)) {
          realmModifiedBindings.set(key, val);
        }
      });
    }
    let realmModifiedProperties = this.modifiedProperties;
    if (realmModifiedProperties !== undefined) {
      properties.forEach((desc, propertyBinding, m) => {
        (0, _invariant2.default)(realmModifiedProperties !== undefined);
        if (!realmModifiedProperties.has(propertyBinding)) {
          realmModifiedProperties.set(propertyBinding, desc);
        }
      });
    }

    // add created objects
    if (createdObjects.size > 0) {
      let realmCreatedObjects = this.createdObjects;
      if (realmCreatedObjects === undefined) this.createdObjects = new Set(createdObjects);else {
        createdObjects.forEach((ob, a) => {
          (0, _invariant2.default)(realmCreatedObjects !== undefined);
          realmCreatedObjects.add(ob);
        });
      }
    }
  }

  outputToConsole(method, args) {
    if (this.isReadOnly) {
      // This only happens during speculative execution and is reported elsewhere
      throw new _errors.FatalError("Trying to create console output in read-only realm");
    }
    if (this.useAbstractInterpretation) {
      (0, _invariant2.default)(this.generator !== undefined);
      this.generator.emitConsoleLog(method, args);
    } else {
      console[method](getString(this, args));
    }

    function getString(realm, values) {
      let res = "";
      while (values.length) {
        let next = values.shift();
        let nextString = _singletons.To.ToString(realm, next);
        res += nextString;
      }
      return res;
    }
  }

  // Record the current value of binding in this.modifiedBindings unless
  // there is already an entry for binding.
  recordModifiedBinding(binding) {
    if (binding.environment.isReadOnly) {
      // This only happens during speculative execution and is reported elsewhere
      throw new _errors.FatalError("Trying to modify a binding in read-only realm");
    }
    if (this.modifiedBindings !== undefined && !this.modifiedBindings.has(binding)) this.modifiedBindings.set(binding, {
      hasLeaked: binding.hasLeaked,
      value: binding.value
    });
    return binding;
  }

  callReportObjectGetOwnProperties(ob) {
    if (this.reportObjectGetOwnProperties !== undefined) {
      this.reportObjectGetOwnProperties(ob);
    }
  }

  callReportPropertyAccess(binding) {
    if (this.reportPropertyAccess !== undefined) {
      this.reportPropertyAccess(binding);
    }
  }

  // Record the current value of binding in this.modifiedProperties unless
  // there is already an entry for binding.
  recordModifiedProperty(binding) {
    if (binding === undefined) return;
    if (this.isReadOnly && (this.getRunningContext().isReadOnly || !this.isNewObject(binding.object))) {
      // This only happens during speculative execution and is reported elsewhere
      throw new _errors.FatalError("Trying to modify a property in read-only realm");
    }
    this.callReportPropertyAccess(binding);
    if (this.modifiedProperties !== undefined && !this.modifiedProperties.has(binding)) {
      this.modifiedProperties.set(binding, (0, _index2.cloneDescriptor)(binding.descriptor));
    }
  }

  isNewObject(object) {
    if (object instanceof _index.AbstractObjectValue) return false;
    return this.createdObjects === undefined || this.createdObjects.has(object);
  }

  recordNewObject(object) {
    if (this.createdObjects !== undefined) {
      this.createdObjects.add(object);
    }
    if (this.createdObjectsTrackedForLeaks !== undefined) {
      this.createdObjectsTrackedForLeaks.add(object);
    }
  }

  // Returns the current values of modifiedBindings and modifiedProperties
  // and then assigns new empty maps to them.
  getAndResetModifiedMaps() {
    let result = [this.modifiedBindings, this.modifiedProperties];
    this.modifiedBindings = new Map();
    this.modifiedProperties = new Map();
    return result;
  }

  // Restores each Binding in the given map to the value it
  // had when it was entered into the map and updates the map to record
  // the value the Binding had just before the call to this method.
  restoreBindings(modifiedBindings) {
    if (modifiedBindings === undefined) return;
    modifiedBindings.forEach(({ hasLeaked, value }, binding, m) => {
      let l = binding.hasLeaked;
      let v = binding.value;
      binding.hasLeaked = hasLeaked;
      binding.value = value;
      m.set(binding, {
        hasLeaked: l,
        value: v
      });
    });
  }

  // Restores each PropertyBinding in the given map to the value it
  // had when it was entered into the map and updates the map to record
  // the value the Binding had just before the call to this method.
  restoreProperties(modifiedProperties) {
    if (modifiedProperties === undefined) return;
    modifiedProperties.forEach((desc, propertyBinding, m) => {
      let d = propertyBinding.descriptor;
      propertyBinding.descriptor = desc;
      m.set(propertyBinding, d);
    });
  }

  // Provide the realm with maps in which to track modifications.
  // A map can be set to undefined if no tracking is required.
  setModifiedMaps(modifiedBindings, modifiedProperties) {
    this.modifiedBindings = modifiedBindings;
    this.modifiedProperties = modifiedProperties;
  }

  rebuildObjectProperty(object, key, propertyValue, path) {
    if (!(propertyValue instanceof _index.AbstractValue)) return;
    if (propertyValue.kind === "abstractConcreteUnion") {
      let absVal = propertyValue.args.find(e => e instanceof _index.AbstractValue);
      (0, _invariant2.default)(absVal instanceof _index.AbstractValue);
      propertyValue = absVal;
    }
    if (!propertyValue.isIntrinsic()) {
      propertyValue.intrinsicName = `${path}.${key}`;
      propertyValue.kind = "rebuiltProperty";
      propertyValue.args = [object];
      propertyValue._buildNode = ([node]) => t.memberExpression(node, t.identifier(key));
      this.rebuildNestedProperties(propertyValue, propertyValue.intrinsicName);
    }
  }

  rebuildNestedProperties(abstractValue, path) {
    if (!(abstractValue instanceof _index.AbstractObjectValue)) return;
    if (abstractValue.values.isTop()) return;
    let template = abstractValue.getTemplate();
    (0, _invariant2.default)(!template.intrinsicName || template.intrinsicName === path);
    template.intrinsicName = path;
    template.intrinsicNameGenerated = true;
    for (let [key, binding] of template.properties) {
      if (binding === undefined || binding.descriptor === undefined) continue; // deleted
      (0, _invariant2.default)(binding.descriptor !== undefined);
      let value = binding.descriptor.value;
      _singletons.Properties.ThrowIfMightHaveBeenDeleted(value);
      if (value === undefined) {
        _index.AbstractValue.reportIntrospectionError(abstractValue, key);
        throw new _errors.FatalError();
      }
      (0, _invariant2.default)(value instanceof _index.Value);
      this.rebuildObjectProperty(abstractValue, key, value, path);
    }
  }

  createExecutionContext() {
    let context = new ExecutionContext();

    let loc = this.nextContextLocation;
    if (loc) {
      context.setLocation(loc);
      this.nextContextLocation = null;
    }

    return context;
  }

  setNextExecutionContextLocation(loc) {
    if (!loc) return;

    //if (this.nextContextLocation) {
    //  throw new ThrowCompletion(
    //    Construct(this, this.intrinsics.TypeError, [new StringValue(this, "Already have a context location that we haven't used yet")])
    //  );
    //} else {
    this.nextContextLocation = loc;
    //}
  }

  reportIntrospectionError(message) {
    if (message === undefined) message = "";
    if (typeof message === "string") message = new _index.StringValue(this, message);
    (0, _invariant2.default)(message instanceof _index.StringValue);
    this.nextContextLocation = this.currentLocation;
    let error = new _errors.CompilerDiagnostic(message.value, this.currentLocation, "PP0001", "FatalError");
    this.handleError(error);
  }

  createErrorThrowCompletion(type, message) {
    (0, _invariant2.default)(type !== this.intrinsics.__IntrospectionError);
    if (message === undefined) message = "";
    if (typeof message === "string") message = new _index.StringValue(this, message);
    (0, _invariant2.default)(message instanceof _index.StringValue);
    this.nextContextLocation = this.currentLocation;
    return new _completions.ThrowCompletion((0, _index2.Construct)(this, type, [message]), this.currentLocation);
  }

  appendGenerator(generator, leadingComment = "") {
    let realmGenerator = this.generator;
    if (realmGenerator === undefined) {
      (0, _invariant2.default)(generator.empty());
      return;
    }
    realmGenerator.appendGenerator(generator, leadingComment);
  }

  // Pass the error to the realm's error-handler
  // Return value indicates whether the caller should try to recover from the error or not.
  handleError(diagnostic) {
    if (!diagnostic.callStack && this.contextStack.length > 0) {
      let error = (0, _index2.Construct)(this, this.intrinsics.Error);
      let stack = error.$Get("stack", error);
      if (stack instanceof _index.StringValue) diagnostic.callStack = stack.value;
    }
    // Default behaviour is to bail on the first error
    let errorHandler = this.errorHandler;
    if (!errorHandler) {
      let msg = `${diagnostic.errorCode}: ${diagnostic.message}`;
      if (diagnostic.location) {
        let loc_start = diagnostic.location.start;
        let loc_end = diagnostic.location.end;
        msg += ` at ${loc_start.line}:${loc_start.column} to ${loc_end.line}:${loc_end.column}`;
      }
      try {
        switch (diagnostic.severity) {
          case "Information":
            console.log(`Info: ${msg}`);
            return "Recover";
          case "Warning":
            console.warn(`Warn: ${msg}`);
            return "Recover";
          case "RecoverableError":
            console.error(`Error: ${msg}`);
            return "Fail";
          case "FatalError":
            console.error(`Fatal Error: ${msg}`);
            return "Fail";
          default:
            (0, _invariant2.default)(false, "Unexpected error type");
        }
      } finally {
        console.log(diagnostic.callStack);
      }
    }
    return errorHandler(diagnostic);
  }

  saveNameString(nameString) {
    this._abstractValuesDefined.add(nameString);
  }

  isNameStringUnique(nameString) {
    return !this._abstractValuesDefined.has(nameString);
  }
}
exports.Realm = Realm;

/***/ }),
/* 8 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Reference = exports.LexicalEnvironment = exports.GlobalEnvironmentRecord = exports.FunctionEnvironmentRecord = exports.ObjectEnvironmentRecord = exports.DeclarativeEnvironmentRecord = exports.EnvironmentRecord = undefined;
exports.havocBinding = havocBinding;
exports.mightBecomeAnObject = mightBecomeAnObject;

var _completions = __webpack_require__(3);

var _errors = __webpack_require__(6);

var _options = __webpack_require__(302);

var _realm = __webpack_require__(7);

var _index = __webpack_require__(0);

var _babelGenerator = __webpack_require__(303);

var _babelGenerator2 = _interopRequireDefault(_babelGenerator);

var _parse = __webpack_require__(158);

var _parse2 = _interopRequireDefault(_parse);

var _invariant = __webpack_require__(1);

var _invariant2 = _interopRequireDefault(_invariant);

var _traverseFast = __webpack_require__(77);

var _traverseFast2 = _interopRequireDefault(_traverseFast);

var _index2 = __webpack_require__(5);

var _singletons = __webpack_require__(2);

var _babelTypes = __webpack_require__(4);

var t = _interopRequireWildcard(_babelTypes);

var _index3 = __webpack_require__(24);

var _PrimitiveValue = __webpack_require__(301);

var _PrimitiveValue2 = _interopRequireDefault(_PrimitiveValue);

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const sourceMap = __webpack_require__(313); /**
                                          * Copyright (c) 2017-present, Facebook, Inc.
                                          * All rights reserved.
                                          *
                                          * This source code is licensed under the BSD-style license found in the
                                          * LICENSE file in the root directory of this source tree. An additional grant
                                          * of patent rights can be found in the PATENTS file in the same directory.
                                          */

function deriveGetBinding(realm, binding) {
  let types = _index3.TypesDomain.topVal;
  let values = _index3.ValuesDomain.topVal;
  (0, _invariant2.default)(realm.generator !== undefined);
  return realm.generator.derive(types, values, [], (_, context) => context.serializeBinding(binding));
}

function havocBinding(binding) {
  let realm = binding.environment.realm;
  if (!binding.hasLeaked) {
    realm.recordModifiedBinding(binding).hasLeaked = true;
  }
}

// ECMA262 8.1.1
class EnvironmentRecord {

  constructor(realm) {
    (0, _invariant2.default)(realm, "expected realm");
    this.realm = realm;
    this.isReadOnly = false;
  }

}

exports.EnvironmentRecord = EnvironmentRecord;


// ECMA262 8.1.1.1
class DeclarativeEnvironmentRecord extends EnvironmentRecord {
  constructor(realm) {
    super(realm);
    this.bindings = Object.create(null);
    this.frozen = false;
  }
  // Frozen Records cannot have bindings created or deleted but can have bindings updated


  // ECMA262 8.1.1.1.1
  HasBinding(N) {
    // 1. Let envRec be the declarative Environment Record for which the method was invoked.
    let envRec = this;

    // 2. If envRec has a binding for the name that is the value of N, return true.
    if (envRec.bindings[N]) return true;

    // 3. Return false.
    return false;
  }

  // ECMA262 8.1.1.1.2
  CreateMutableBinding(N, D, isGlobal = false) {
    (0, _invariant2.default)(!this.frozen);
    let realm = this.realm;

    // 1. Let envRec be the declarative Environment Record for which the method was invoked.
    let envRec = this;

    // 2. Assert: envRec does not already have a binding for N.
    (0, _invariant2.default)(!envRec.bindings[N], `shouldn't have the binding ${N}`);

    // 3. Create a mutable binding in envRec for N and record that it is uninitialized. If D is true, record that the newly created binding may be deleted by a subsequent DeleteBinding call.
    this.bindings[N] = realm.recordModifiedBinding({
      initialized: false,
      mutable: true,
      deletable: D,
      environment: envRec,
      name: N,
      isGlobal: isGlobal,
      hasLeaked: false
    });

    // 4. Return NormalCompletion(empty).
    return realm.intrinsics.undefined;
  }

  // ECMA262 8.1.1.1.3
  CreateImmutableBinding(N, S, isGlobal = false) {
    (0, _invariant2.default)(!this.frozen);
    let realm = this.realm;

    // 1. Let envRec be the declarative Environment Record for which the method was invoked.
    let envRec = this;

    // 2. Assert: envRec does not already have a binding for N.
    (0, _invariant2.default)(!envRec.bindings[N], `shouldn't have the binding ${N}`);

    // 3. Create an immutable binding in envRec for N and record that it is uninitialized. If S is true, record that the newly created binding is a strict binding.
    this.bindings[N] = realm.recordModifiedBinding({
      initialized: false,
      strict: S,
      deletable: false,
      environment: envRec,
      name: N,
      isGlobal: isGlobal,
      hasLeaked: false
    });

    // 4. Return NormalCompletion(empty).
    return realm.intrinsics.undefined;
  }

  // ECMA262 8.1.1.1.4
  InitializeBinding(N, V) {
    // 1. Let envRec be the declarative Environment Record for which the method was invoked.
    let envRec = this;

    let binding = envRec.bindings[N];

    // 2. Assert: envRec must have an uninitialized binding for N.
    (0, _invariant2.default)(binding && !binding.initialized, `shouldn't have the binding ${N}`);

    // 3. Set the bound value for N in envRec to V.
    this.realm.recordModifiedBinding(binding).value = V;

    // 4. Record that the binding for N in envRec has been initialized.
    binding.initialized = true;

    // 5. Return NormalCompletion(empty).
    return this.realm.intrinsics.empty;
  }

  // ECMA262 8.1.1.1.5
  SetMutableBinding(N, V, S) {
    // We can mutate frozen bindings because of captured bindings.
    let realm = this.realm;

    // 1. Let envRec be the declarative Environment Record for which the method was invoked.
    let envRec = this;

    let binding = envRec.bindings[N];

    // 2. If envRec does not have a binding for N, then
    if (!binding) {
      // a. If S is true, throw a ReferenceError exception.
      if (S) {
        throw realm.createErrorThrowCompletion(realm.intrinsics.ReferenceError, `${N} not found`);
      }

      // b. Perform envRec.CreateMutableBinding(N, true).
      envRec.CreateMutableBinding(N, true);

      // c. Perform envRec.InitializeBinding(N, V).
      envRec.InitializeBinding(N, V);

      // d. Return NormalCompletion(empty).
      return this.realm.intrinsics.empty;
    }

    // 3. If the binding for N in envRec is a strict binding, let S be true.
    if (binding.strict) S = true;

    // 4. If the binding for N in envRec has not yet been initialized, throw a ReferenceError exception.
    if (!binding.initialized) {
      throw realm.createErrorThrowCompletion(realm.intrinsics.ReferenceError, `${N} has not yet been initialized`);
    } else if (binding.mutable) {
      // 5. Else if the binding for N in envRec is a mutable binding, change its bound value to V.
      if (binding.hasLeaked) {
        _singletons.Havoc.value(realm, V);
        (0, _invariant2.default)(realm.generator);
        realm.generator.emitBindingAssignment(binding, V);
      } else {
        realm.recordModifiedBinding(binding).value = V;
      }
    } else {
      // 6. Else,
      // a. Assert: This is an attempt to change the value of an immutable binding.

      // b. If S is true, throw a TypeError exception.
      if (S) {
        throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "attempt to change immutable binding");
      }
    }

    // 7. Return NormalCompletion(empty).
    return this.realm.intrinsics.empty;
  }

  // ECMA262 8.1.1.1.6
  GetBindingValue(N, S) {
    let realm = this.realm;

    // 1. Let envRec be the declarative Environment Record for which the method was invoked.
    let envRec = this;

    let binding = envRec.bindings[N];

    // 2. Assert: envRec has a binding for N.
    (0, _invariant2.default)(binding, "expected binding");

    // 3. If the binding for N in envRec is an uninitialized binding, throw a ReferenceError exception.
    if (!binding.initialized) {
      throw realm.createErrorThrowCompletion(realm.intrinsics.ReferenceError);
    }

    // 4. Return the value currently bound to N in envRec.
    if (binding.hasLeaked) {
      return deriveGetBinding(realm, binding);
    }
    (0, _invariant2.default)(binding.value);
    return binding.value;
  }

  // ECMA262 8.1.1.1.7
  DeleteBinding(N) {
    (0, _invariant2.default)(!this.frozen);
    // 1. Let envRec be the declarative Environment Record for which the method was invoked.
    let envRec = this;

    // 2. Assert: envRec has a binding for the name that is the value of N.
    (0, _invariant2.default)(envRec.bindings[N], "expected binding to exist");

    // 3. If the binding for N in envRec cannot be deleted, return false.
    if (!envRec.bindings[N].deletable) return false;

    // 4. Remove the binding for N from envRec.
    this.realm.recordModifiedBinding(envRec.bindings[N]).value = undefined;
    delete envRec.bindings[N];

    // 5. Return true.
    return true;
  }

  // ECMA262 8.1.1.1.8
  HasThisBinding() {
    // 1. Return false.
    return false;
  }

  // ECMA262 8.1.1.1.9
  HasSuperBinding() {
    // 1. Return false.
    return false;
  }

  // ECMA262 8.1.1.1.10
  WithBaseObject() {
    // 1. Return undefined.
    return this.realm.intrinsics.undefined;
  }
}

exports.DeclarativeEnvironmentRecord = DeclarativeEnvironmentRecord; // ECMA262 8.1.1.2

class ObjectEnvironmentRecord extends EnvironmentRecord {

  constructor(realm, obj) {
    super(realm);
    this.object = obj;
  }

  // ECMA262 8.1.1.2.1
  HasBinding(N) {
    let realm = this.realm;

    // 1. Let envRec be the object Environment Record for which the method was invoked.
    let envRec = this;

    // 2. Let bindings be the binding object for envRec.
    let bindings = this.object;

    // 3. Let foundBinding be ? HasProperty(bindings, N).
    let foundBinding = (0, _index2.HasProperty)(realm, bindings, N);

    // 4. If foundBinding is false, return false.
    if (!foundBinding) return false;

    // 5. If the withEnvironment flag of envRec is false, return true.
    if (!envRec.withEnvironment) return true;

    // 6. Let unscopables be ? Get(bindings, @@unscopables).
    let unscopables = (0, _index2.Get)(realm, bindings, realm.intrinsics.SymbolUnscopables);

    // 7. If Type(unscopables) is Object, then
    if (unscopables instanceof _index.ObjectValue || unscopables instanceof _index.AbstractObjectValue) {
      // a. Let blocked be ToBoolean(? Get(unscopables, N)).
      let blocked = _singletons.To.ToBooleanPartial(realm, (0, _index2.Get)(realm, unscopables, N));

      // b. If blocked is true, return false.
      if (blocked) return false;
    }
    unscopables.throwIfNotConcrete();

    // 8. Return true.
    return true;
  }

  // ECMA262 8.1.1.2.2
  CreateMutableBinding(N, D) {
    let realm = this.realm;

    // 1. Let envRec be the object Environment Record for which the method was invoked.
    let envRec = this;

    // 2. Let bindings be the binding object for envRec.
    let bindings = envRec.object;

    // 3. If D is true, let configValue be true; otherwise let configValue be false.
    let configValue = D ? true : false;

    // 4. Return ? DefinePropertyOrThrow(bindings, N, PropertyDescriptor{[[Value]]: undefined, [[Writable]]: true, [[Enumerable]]: true, [[Configurable]]: configValue}).
    return new _index.BooleanValue(realm, _singletons.Properties.DefinePropertyOrThrow(realm, bindings, N, {
      value: realm.intrinsics.undefined,
      writable: true,
      enumerable: true,
      configurable: configValue
    }));
  }

  // ECMA262 8.1.1.2.3
  CreateImmutableBinding(N, S) {
    // The concrete Environment Record method CreateImmutableBinding is never used within this specification in association with object Environment Records.
    (0, _invariant2.default)(false);
  }

  // ECMA262 8.1.1.2.4
  InitializeBinding(N, V) {
    // 1. Let envRec be the object Environment Record for which the method was invoked.
    let envRec = this;

    // 2. Assert: envRec must have an uninitialized binding for N.
    // 3. Record that the binding for N in envRec has been initialized.

    // 4. Return ? envRec.SetMutableBinding(N, V, false).
    return envRec.SetMutableBinding(N, V, false);
  }

  // ECMA262 8.1.1.2.5
  SetMutableBinding(N, V, S) {
    let realm = this.realm;

    // 1. Let envRec be the object Environment Record for which the method was invoked.
    let envRec = this;

    // 2. Let bindings be the binding object for envRec.
    let bindings = envRec.object;

    // 3. Return ? Set(bindings, N, V, S).
    return new _index.BooleanValue(realm, _singletons.Properties.Set(realm, bindings, N, V, S));
  }

  // ECMA262 8.1.1.2.6
  GetBindingValue(N, S) {
    let realm = this.realm;

    // 1. Let envRec be the object Environment Record for which the method was invoked.
    let envRec = this;

    // 2. Let bindings be the binding object for envRec.
    let bindings = envRec.object;

    // 3. Let value be ? HasProperty(bindings, N).
    let value = (0, _index2.HasProperty)(realm, bindings, N);

    // 4. If value is false, then
    if (!value) {
      // a. If S is false, return the value undefined; otherwise throw a ReferenceError exception.
      if (!S) {
        return realm.intrinsics.undefined;
      } else {
        throw realm.createErrorThrowCompletion(realm.intrinsics.ReferenceError);
      }
    }

    // 5. Return ? Get(bindings, N).
    return (0, _index2.Get)(realm, bindings, N);
  }

  // ECMA262 8.1.1.2.7
  DeleteBinding(N) {
    // 1. Let envRec be the object Environment Record for which the method was invoked.
    let envRec = this;

    // 2. Let bindings be the binding object for envRec.
    let bindings = envRec.object;

    // 3. Return ? bindings.[[Delete]](N).
    return bindings.$Delete(N);
  }

  // ECMA262 8.1.1.2.8
  HasThisBinding() {
    // 1. Return false.
    return false;
  }

  // ECMA262 8.1.1.2.9
  HasSuperBinding() {
    // 1. Return false.
    return false;
  }

  // ECMA262 8.1.1.2.10
  WithBaseObject() {
    // 1. Let envRec be the object Environment Record for which the method was invoked.
    let envRec = this;

    // 2. If the withEnvironment flag of envRec is true, return the binding object for envRec.
    if (envRec.withEnvironment) return envRec.object;

    // 3. Otherwise, return undefined.
    return this.realm.intrinsics.undefined;
  }
}

exports.ObjectEnvironmentRecord = ObjectEnvironmentRecord; // ECMA262 8.1.1.3

class FunctionEnvironmentRecord extends DeclarativeEnvironmentRecord {

  // ECMA262 8.1.1.3.1
  BindThisValue(V) {
    let realm = this.realm;

    // 1. Let envRec be the function Environment Record for which the method was invoked.
    let envRec = this;

    // 2. Assert: envRec.[[ThisBindingStatus]] is not "lexical".
    (0, _invariant2.default)(envRec.$ThisBindingStatus !== "lexical", "this binding status shouldn't be lexical");

    // 3. If envRec.[[ThisBindingStatus]] is "initialized", throw a ReferenceError exception.
    if (envRec.$ThisBindingStatus === "initialized") {
      throw realm.createErrorThrowCompletion(realm.intrinsics.ReferenceError);
    }

    // 4. Set envRec.[[ThisValue]] to V.
    envRec.$ThisValue = V;

    // 5. Set envRec.[[ThisBindingStatus]] to "initialized".
    envRec.$ThisBindingStatus = "initialized";

    // 6. Return V.
    return V;
  }

  // ECMA262 8.1.1.3.2
  HasThisBinding() {
    // 1. Let envRec be the function Environment Record for which the method was invoked.
    let envRec = this;

    // 2. If envRec.[[ThisBindingStatus]] is "lexical", return false; otherwise, return true.
    return envRec.$ThisBindingStatus === "lexical" ? false : true;
  }

  // ECMA262 8.1.1.3.3
  HasSuperBinding() {
    // 1. Let envRec be the function Environment Record for which the method was invoked.
    let envRec = this;

    // 2. If envRec.[[ThisBindingStatus]] is "lexical", return false.
    if (envRec.$ThisBindingStatus === "lexical") return false;

    // 3. If envRec.[[HomeObject]] has the value undefined, return false; otherwise, return true.
    if (envRec.$HomeObject === undefined) {
      return false;
    } else {
      return true;
    }
  }

  // ECMA262 8.1.1.3.4
  GetThisBinding() {
    let realm = this.realm;

    // 1. Let envRec be the function Environment Record for which the method was invoked.
    let envRec = this;

    // 2. Assert: envRec.[[ThisBindingStatus]] is not "lexical".
    (0, _invariant2.default)(envRec.$ThisBindingStatus !== "lexical", "this binding status shouldn't be lexical");

    // 3. If envRec.[[ThisBindingStatus]] is "uninitialized", throw a ReferenceError exception.
    if (envRec.$ThisBindingStatus === "uninitialized") {
      throw realm.createErrorThrowCompletion(realm.intrinsics.ReferenceError);
    }

    // 4. Return envRec.[[ThisValue]].
    return envRec.$ThisValue;
  }

  // ECMA262 8.1.1.3.5
  GetSuperBase() {
    // 1. Let envRec be the function Environment Record for which the method was invoked.
    let envRec = this;

    // 2. Let home be the value of envRec.[[HomeObject]].
    let home = envRec.$HomeObject;

    // 3. If home has the value undefined, return undefined.
    if (home === undefined) return this.realm.intrinsics.undefined;

    // 4. Assert: Type(home) is Object.
    (0, _invariant2.default)(home instanceof _index.ObjectValue, "expected object value");

    // 5. Return ? home.[[GetPrototypeOf]]().
    return home.$GetPrototypeOf();
  }
}

exports.FunctionEnvironmentRecord = FunctionEnvironmentRecord; // ECMA262 8.1.1.4

class GlobalEnvironmentRecord extends EnvironmentRecord {

  // ECMA262 8.1.1.4.1
  HasBinding(N) {
    // 1. Let envRec be the global Environment Record for which the method was invoked.
    let envRec = this;

    // 2. Let DclRec be envRec.[[DeclarativeRecord]].
    let DclRec = envRec.$DeclarativeRecord;

    // 3. If DclRec.HasBinding(N) is true, return true.
    if (DclRec.HasBinding(N)) return true;

    // 4. Let ObjRec be envRec.[[ObjectRecord]].
    let ObjRec = envRec.$ObjectRecord;

    // 5. Return ? ObjRec.HasBinding(N).
    return ObjRec.HasBinding(N);
  }

  // ECMA262 8.1.1.4.2
  CreateMutableBinding(N, D) {
    let realm = this.realm;

    // 1. Let envRec be the global Environment Record for which the method was invoked.
    let envRec = this;

    // 2. Let DclRec be envRec.[[DeclarativeRecord]].
    let DclRec = envRec.$DeclarativeRecord;

    // 3. If DclRec.HasBinding(N) is true, throw a TypeError exception.
    if (DclRec.HasBinding(N)) {
      throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError);
    }

    // 4. Return DclRec.CreateMutableBinding(N, D).
    return DclRec.CreateMutableBinding(N, D, true);
  }

  // ECMA262 8.1.1.4.3
  CreateImmutableBinding(N, S) {
    let realm = this.realm;

    // 1. Let envRec be the global Environment Record for which the method was invoked.
    let envRec = this;

    // 2. Let DclRec be envRec.[[DeclarativeRecord]].
    let DclRec = envRec.$DeclarativeRecord;

    // 3. If DclRec.HasBinding(N) is true, throw a TypeError exception.
    if (DclRec.HasBinding(N)) {
      throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError);
    }

    // 4. Return DclRec.CreateImmutableBinding(N, S).
    return DclRec.CreateImmutableBinding(N, S, true);
  }

  // ECMA262 8.1.1.4.4
  InitializeBinding(N, V) {
    // 1. Let envRec be the global Environment Record for which the method was invoked.
    let envRec = this;

    // 2. Let DclRec be envRec.[[DeclarativeRecord]].
    let DclRec = envRec.$DeclarativeRecord;

    // 3. If DclRec.HasBinding(N) is true, then
    if (DclRec.HasBinding(N)) {
      // a. Return DclRec.InitializeBinding(N, V).
      return DclRec.InitializeBinding(N, V);
    }

    // 4. Assert: If the binding exists, it must be in the object Environment Record.

    // 5. Let ObjRec be envRec.[[ObjectRecord]].
    let ObjRec = envRec.$ObjectRecord;

    // 6. Return ? ObjRec.InitializeBinding(N, V).
    return ObjRec.InitializeBinding(N, V);
  }

  // ECMA262 8.1.1.4.5
  SetMutableBinding(N, V, S) {
    // 1. Let envRec be the global Environment Record for which the method was invoked.
    let envRec = this;

    // 2. Let DclRec be envRec.[[DeclarativeRecord]].
    let DclRec = envRec.$DeclarativeRecord;

    // 3. If DclRec.HasBinding(N) is true, then
    if (DclRec.HasBinding(N)) {
      // a. Return DclRec.SetMutableBinding(N, V, S).
      return DclRec.SetMutableBinding(N, V, S);
    }

    // 4. Let ObjRec be envRec.[[ObjectRecord]].
    let ObjRec = envRec.$ObjectRecord;

    // 5. Return ? ObjRec.SetMutableBinding(N, V, S).
    return ObjRec.SetMutableBinding(N, V, S);
  }

  // ECMA262 8.1.1.4.6
  GetBindingValue(N, S) {
    // 1. Let envRec be the global Environment Record for which the method was invoked.
    let envRec = this;

    // 2. Let DclRec be envRec.[[DeclarativeRecord]].
    let DclRec = envRec.$DeclarativeRecord;

    // 3. If DclRec.HasBinding(N) is true, then
    if (DclRec.HasBinding(N)) {
      // a. Return DclRec.GetBindingValue(N, S).
      return DclRec.GetBindingValue(N, S);
    }

    // 4. Let ObjRec be envRec.[[ObjectRecord]].
    let ObjRec = envRec.$ObjectRecord;

    // 5. Return ? ObjRec.GetBindingValue(N, S).
    return ObjRec.GetBindingValue(N, S);
  }

  // ECMA262 8.1.1.4.7
  DeleteBinding(N) {
    let realm = this.realm;

    // 1. Let envRec be the global Environment Record for which the method was invoked.
    let envRec = this;

    // 2. Let DclRec be envRec.[[DeclarativeRecord]].
    let DclRec = envRec.$DeclarativeRecord;

    // 3. If DclRec.HasBinding(N) is true, then
    if (DclRec.HasBinding(N)) {
      // a. Return DclRec.DeleteBinding(N).
      return DclRec.DeleteBinding(N);
    }

    // 4. Let ObjRec be envRec.[[ObjectRecord]].
    let ObjRec = envRec.$ObjectRecord;

    // 5. Let globalObject be the binding object for ObjRec.
    let globalObject = ObjRec.object;

    // 6. Let existingProp be ? HasOwnProperty(globalObject, N).
    let existingProp = (0, _index2.HasOwnProperty)(realm, globalObject, N);

    // 7. If existingProp is true, then
    if (existingProp) {
      // a. Let status be ? ObjRec.DeleteBinding(N).
      let status = ObjRec.DeleteBinding(N);

      // b. If status is true, then
      if (status) {
        // i. Let varNames be envRec.[[VarNames]].
        let varNames = envRec.$VarNames;

        // ii. If N is an element of varNames, remove that element from the varNames.
        if (varNames.indexOf(N) >= 0) {
          varNames.splice(varNames.indexOf(N), 1);
        }
      }

      // c. Return status.
      return status;
    }

    // 8. Return true.
    return true;
  }

  // ECMA262 8.1.1.4.8
  HasThisBinding() {
    // 1. Return true.
    return true;
  }

  // ECMA262 8.1.1.4.9
  HasSuperBinding() {
    // 1. Return true.
    return true;
  }

  // ECMA262 8.1.1.4.10
  WithBaseObject() {
    // 1. Return undefined.
    return this.realm.intrinsics.undefined;
  }

  // ECMA262 8.1.1.4.11
  GetThisBinding() {
    // 1. Let envRec be the global Environment Record for which the method was invoked.
    let envRec = this;

    (0, _invariant2.default)(envRec.$GlobalThisValue);
    // 2. Return envRec.[[GlobalThisValue]].
    return envRec.$GlobalThisValue;
  }

  // ECMA262 8.1.1.4.12
  HasVarDeclaration(N) {
    // 1. Let envRec be the global Environment Record for which the method was invoked.
    let envRec = this;

    // 2. Let varDeclaredNames be envRec.[[VarNames]].
    let varDeclaredNames = envRec.$VarNames;

    // 3. If varDeclaredNames contains the value of N, return true.
    if (varDeclaredNames.indexOf(N) >= 0) return true;

    // 4. Return false.
    return false;
  }

  // ECMA262 8.1.1.4.13
  HasLexicalDeclaration(N) {
    // 1. Let envRec be the global Environment Record for which the method was invoked.
    let envRec = this;

    // 2. Let DclRec be envRec.[[DeclarativeRecord]].
    let DclRec = envRec.$DeclarativeRecord;

    // 3. Return DclRec.HasBinding(N).
    return DclRec.HasBinding(N);
  }

  // ECMA262 8.1.1.4.14
  HasRestrictedGlobalProperty(N) {
    // 1. Let envRec be the global Environment Record for which the method was invoked.
    let envRec = this;

    // 2. Let ObjRec be envRec.[[ObjectRecord]].
    let ObjRec = envRec.$ObjectRecord;

    // 3. Let globalObject be the binding object for ObjRec.
    let globalObject = ObjRec.object;

    // 4. Let existingProp be ? globalObject.[[GetOwnProperty]](N).
    let existingProp = globalObject.$GetOwnProperty(N);

    // 5. If existingProp is undefined, return false.
    if (!existingProp) return false;
    _singletons.Properties.ThrowIfMightHaveBeenDeleted(existingProp.value);

    // 6. If existingProp.[[Configurable]] is true, return false.
    if (existingProp.configurable) return false;

    // 7. Return true.
    return true;
  }

  // ECMA262 8.1.1.4.15
  CanDeclareGlobalVar(N) {
    let realm = this.realm;

    // 1. Let envRec be the global Environment Record for which the method was invoked.
    let envRec = this;

    // 2. Let ObjRec be envRec.[[ObjectRecord]].
    let ObjRec = envRec.$ObjectRecord;

    // 3. Let globalObject be the binding object for ObjRec.
    let globalObject = ObjRec.object;

    // 4. Let hasProperty be ? HasOwnProperty(globalObject, N).
    let hasProperty = (0, _index2.HasOwnProperty)(realm, globalObject, N);

    // 5. If hasProperty is true, return true.
    if (hasProperty) return true;

    // 6. Return ? IsExtensible(globalObject).
    return (0, _index2.IsExtensible)(realm, globalObject);
  }

  // ECMA262 8.1.1.4.16
  CanDeclareGlobalFunction(N) {
    let realm = this.realm;

    // 1. Let envRec be the global Environment Record for which the method was invoked.
    let envRec = this;

    // 2. Let ObjRec be envRec.[[ObjectRecord]].
    let ObjRec = envRec.$ObjectRecord;

    // 3. Let globalObject be the binding object for ObjRec.
    let globalObject = ObjRec.object;

    // 4. Let existingProp be ? globalObject.[[GetOwnProperty]](N).
    let existingProp = globalObject.$GetOwnProperty(N);

    // 5. If existingProp is undefined, return ? IsExtensible(globalObject).
    if (!existingProp) return (0, _index2.IsExtensible)(realm, globalObject);
    _singletons.Properties.ThrowIfMightHaveBeenDeleted(existingProp.value);

    // 6. If existingProp.[[Configurable]] is true, return true.
    if (existingProp.configurable) return true;

    // 7. If IsDataDescriptor(existingProp) is true and existingProp has attribute values {[[Writable]]: true, [[Enumerable]]: true}, return true.
    if ((0, _index2.IsDataDescriptor)(realm, existingProp) && existingProp.writable && existingProp.enumerable) {
      return true;
    }

    // 8. Return false.
    return false;
  }

  // ECMA262 8.1.1.4.17
  CreateGlobalVarBinding(N, D) {
    let realm = this.realm;

    // 1. Let envRec be the global Environment Record for which the method was invoked.
    let envRec = this;

    // 2. Let ObjRec be envRec.[[ObjectRecord]].
    let ObjRec = envRec.$ObjectRecord;

    // 3. Let globalObject be the binding object for ObjRec.
    let globalObject = ObjRec.object;

    // 4. Let hasProperty be ? HasOwnProperty(globalObject, N).
    let hasProperty = (0, _index2.HasOwnProperty)(realm, globalObject, N);

    // 5. Let extensible be ? IsExtensible(globalObject).
    let extensible = (0, _index2.IsExtensible)(realm, globalObject);

    // 6. If hasProperty is false and extensible is true, then
    if (!hasProperty && extensible) {
      // a. Perform ? ObjRec.CreateMutableBinding(N, D).
      ObjRec.CreateMutableBinding(N, D);

      // b. Perform ? ObjRec.InitializeBinding(N, undefined).
      ObjRec.InitializeBinding(N, this.realm.intrinsics.undefined);
    }

    // 7. Let varDeclaredNames be envRec.[[VarNames]].
    let varDeclaredNames = envRec.$VarNames;

    // 8. If varDeclaredNames does not contain the value of N, then
    if (varDeclaredNames.indexOf(N) < 0) {
      // a. Append N to varDeclaredNames.
      varDeclaredNames.push(N);
    }

    // 9. Return NormalCompletion(empty).
  }

  // ECMA262 8.1.1.4.18
  CreateGlobalFunctionBinding(N, V, D) {
    // 1. Let envRec be the global Environment Record for which the method was invoked.
    let envRec = this;

    // 2. Let ObjRec be envRec.[[ObjectRecord]].
    let ObjRec = envRec.$ObjectRecord;

    // 3. Let globalObject be the binding object for ObjRec.
    let globalObject = ObjRec.object;

    // 4. Let existingProp be ? globalObject.[[GetOwnProperty]](N).
    let existingProp = globalObject.$GetOwnProperty(N);

    // 5. If existingProp is undefined or existingProp.[[Configurable]] is true, then
    let desc;
    if (!existingProp || existingProp.configurable) {
      // a. Let desc be the PropertyDescriptor{[[Value]]: V, [[Writable]]: true, [[Enumerable]]: true, [[Configurable]]: D}.
      desc = { value: V, writable: true, enumerable: true, configurable: D };
    } else {
      // 6. Else,
      _singletons.Properties.ThrowIfMightHaveBeenDeleted(existingProp.value);
      // a. Let desc be the PropertyDescriptor{[[Value]]: V }.
      desc = { value: V };
    }

    // 7. Perform ? DefinePropertyOrThrow(globalObject, N, desc).
    _singletons.Properties.DefinePropertyOrThrow(this.realm, globalObject, N, desc);

    // 8. Record that the binding for N in ObjRec has been initialized.

    // 9. Perform ? Set(globalObject, N, V, false).
    _singletons.Properties.Set(this.realm, globalObject, N, V, false);

    // 10. Let varDeclaredNames be envRec.[[VarNames]].
    let varDeclaredNames = envRec.$VarNames;

    // 11. If varDeclaredNames does not contain the value of N, then
    if (varDeclaredNames.indexOf(N) < 0) {
      // a. Append N to varDeclaredNames.
      varDeclaredNames.push(N);
    }

    // 12. Return NormalCompletion(empty).
  }
}

exports.GlobalEnvironmentRecord = GlobalEnvironmentRecord; // ECMA262 8.1

let uid = 0;
class LexicalEnvironment {
  constructor(realm) {
    (0, _invariant2.default)(realm, "expected realm");
    this.realm = realm;
    this.destroyed = false;
    this._uid = uid++;
  }

  // For debugging it is convenient to have an ID for each of these.


  destroy() {
    this.destroyed = true;
    // Once the containing environment is destroyed, we can no longer add or remove entries from the environmentRecord
    // (but we can update existing values).
    if (this.environmentRecord instanceof DeclarativeEnvironmentRecord) {
      this.environmentRecord.frozen = true;
    }
  }

  assignToGlobal(globalAst, rvalue) {
    let globalValue = this.evaluate(globalAst, false);
    _singletons.Properties.PutValue(this.realm, globalValue, rvalue);
  }

  partiallyEvaluateCompletionDeref(ast, strictCode, metadata) {
    let [result, partial_ast, partial_io] = this.partiallyEvaluateCompletion(ast, strictCode, metadata);
    if (result instanceof Reference) {
      result = _singletons.Environment.GetValue(this.realm, result);
    }
    return [result, partial_ast, partial_io];
  }

  partiallyEvaluateCompletion(ast, strictCode, metadata) {
    try {
      return this.partiallyEvaluate(ast, strictCode, metadata);
    } catch (err) {
      if (err instanceof _completions.Completion) return [err, ast, []];
      if (err instanceof Error)
        // rethrowing Error should preserve stack trace
        throw err;
      // let's wrap into a proper Error to create stack trace
      throw new _errors.FatalError(err);
    }
  }

  evaluateCompletionDeref(ast, strictCode, metadata) {
    let result = this.evaluateCompletion(ast, strictCode, metadata);
    if (result instanceof Reference) result = _singletons.Environment.GetValue(this.realm, result);
    return result;
  }

  evaluateCompletion(ast, strictCode, metadata) {
    try {
      return this.evaluate(ast, strictCode, metadata);
    } catch (err) {
      if ((err instanceof _completions.JoinedAbruptCompletions || err instanceof _completions.PossiblyNormalCompletion) && err.containsBreakOrContinue()) {
        _index.AbstractValue.reportIntrospectionError(err.joinCondition);
        throw new _errors.FatalError();
      }
      if (err instanceof _completions.AbruptCompletion) return err;
      if (err instanceof Error)
        // rethrowing Error should preserve stack trace
        throw err;
      // let's wrap into a proper Error to create stack trace
      throw new _errors.FatalError(err);
    }
  }

  evaluateAbstractCompletion(ast, strictCode, metadata) {
    try {
      return this.evaluateAbstract(ast, strictCode, metadata);
    } catch (err) {
      if (err instanceof _completions.Completion) return err;
      if (err instanceof Error)
        // rethrowing Error should preserve stack trace
        throw err;
      // let's wrap into a proper Error to create stack trace
      if (err instanceof Object) throw new _errors.FatalError(err.constructor.name + ": " + err);
      throw new _errors.FatalError(err);
    }
  }

  concatenateAndParse(sources, sourceType = "script") {
    let asts = [];
    let code = {};
    let directives = [];
    for (let source of sources) {
      try {
        let node = (0, _parse2.default)(this.realm, source.fileContents, source.filePath, sourceType);
        if (source.sourceMapContents && source.sourceMapContents.length > 0) this.fixup_source_locations(node, source.sourceMapContents);
        this.fixup_filenames(node);
        asts = asts.concat(node.program.body);
        code[source.filePath] = source.fileContents;
        directives = directives.concat(node.program.directives);
      } catch (e) {
        if (e instanceof _completions.ThrowCompletion) {
          let error = e.value;
          if (error instanceof _index.ObjectValue) {
            let message = error.$Get("message", error);
            message.value = `Syntax error: ${message.value}`;
            e.location.source = source.filePath;
            // the position was not located properly on the
            // syntax errors happen on one given position, so start position = end position
            e.location.start = { line: e.location.line, column: e.location.column };
            e.location.end = { line: e.location.line, column: e.location.column };
            let diagnostic = new _errors.CompilerDiagnostic(message.value, e.location, "PP1004", "FatalError");
            this.realm.handleError(diagnostic);
            throw new _errors.FatalError(message.value);
          }
        }
        throw e;
      }
    }
    return [t.file(t.program(asts, directives)), code];
  }

  executeSources(sources, sourceType = "script", onParse = undefined) {
    let context = new _realm.ExecutionContext();
    context.lexicalEnvironment = this;
    context.variableEnvironment = this;
    context.realm = this.realm;
    this.realm.pushContext(context);
    let res, code;
    try {
      let ast;
      [ast, code] = this.concatenateAndParse(sources, sourceType);
      if (onParse) onParse(ast);
      res = this.evaluateCompletion(ast, false);
    } finally {
      this.realm.popContext(context);
      this.realm.onDestroyScope(context.lexicalEnvironment);
      if (!this.destroyed) this.realm.onDestroyScope(this);
      (0, _invariant2.default)(this.realm.activeLexicalEnvironments.size === 0);
    }
    if (res instanceof _completions.AbruptCompletion) return [res, code];

    return [_singletons.Environment.GetValue(this.realm, res), code];
  }

  executePartialEvaluator(sources, options = _options.defaultOptions, sourceType = "script") {
    let [ast, code] = this.concatenateAndParse(sources, sourceType);
    let context = new _realm.ExecutionContext();
    context.lexicalEnvironment = this;
    context.variableEnvironment = this;
    context.realm = this.realm;
    this.realm.pushContext(context);
    let partialAST;
    try {
      [, partialAST] = this.partiallyEvaluateCompletionDeref(ast, false);
    } finally {
      this.realm.popContext(context);
      this.realm.onDestroyScope(context.lexicalEnvironment);
      if (!this.destroyed) this.realm.onDestroyScope(this);
      (0, _invariant2.default)(this.realm.activeLexicalEnvironments.size === 0);
    }
    (0, _invariant2.default)(partialAST.type === "File");
    let fileAst = partialAST;
    let prog = t.program(fileAst.program.body, ast.program.directives);
    this.fixup_filenames(prog);
    // The type signature for generate is not complete, hence the any
    return (0, _babelGenerator2.default)(prog, { sourceMaps: options.sourceMaps }, code);
  }

  execute(code, filename, map = "", sourceType = "script", onParse = undefined) {
    let context = new _realm.ExecutionContext();
    context.lexicalEnvironment = this;
    context.variableEnvironment = this;
    context.realm = this.realm;

    this.realm.pushContext(context);

    let ast, res;
    try {
      try {
        ast = (0, _parse2.default)(this.realm, code, filename, sourceType);
      } catch (e) {
        if (e instanceof _completions.ThrowCompletion) return e;
        throw e;
      }
      if (onParse) onParse(ast);
      if (map.length > 0) this.fixup_source_locations(ast, map);
      this.fixup_filenames(ast);
      res = this.evaluateCompletion(ast, false);
    } finally {
      this.realm.popContext(context);
      // Avoid destroying "this" scope as execute may be called many times.
      if (context.lexicalEnvironment !== this) this.realm.onDestroyScope(context.lexicalEnvironment);
      (0, _invariant2.default)(this.realm.activeLexicalEnvironments.size === 1);
    }
    if (res instanceof _completions.AbruptCompletion) return res;

    return _singletons.Environment.GetValue(this.realm, res);
  }

  fixup_source_locations(ast, map) {
    const smc = new sourceMap.SourceMapConsumer(map);
    (0, _traverseFast2.default)(ast, node => {
      let loc = node.loc;
      if (!loc) return false;
      fixup(loc, loc.start);
      fixup(loc, loc.end);
      fixup_comments(node.leadingComments);
      fixup_comments(node.innerComments);
      fixup_comments(node.trailingComments);
      return false;

      function fixup(new_loc, new_pos) {
        let old_pos = smc.originalPositionFor({ line: new_pos.line, column: new_pos.column });
        if (old_pos.source === null) return;
        new_pos.line = old_pos.line;
        new_pos.column = old_pos.column;
        new_loc.source = old_pos.source;
      }

      function fixup_comments(comments) {
        if (!comments) return;
        for (let c of comments) {
          let cloc = c.loc;
          if (!cloc) continue;
          fixup(cloc, cloc.start);
          fixup(cloc, cloc.end);
        }
      }
    });
  }

  fixup_filenames(ast) {
    (0, _traverseFast2.default)(ast, node => {
      let loc = node.loc;
      if (!loc || !loc.source) {
        node.leadingComments = null;
        node.innerComments = null;
        node.trailingComments = null;
        node.loc = null;
      } else {
        let filename = loc.source;
        loc.filename = filename;
        fixup_comments(node.leadingComments, filename);
        fixup_comments(node.innerComments, filename);
        fixup_comments(node.trailingComments, filename);
      }
      return false;

      function fixup_comments(comments, filename) {
        if (!comments) return;
        for (let c of comments) {
          if (c.loc) {
            c.loc.filename = filename;
            c.loc.source = filename;
          }
        }
      }
    });
  }

  evaluate(ast, strictCode, metadata) {
    if (this.realm.debuggerInstance) {
      this.realm.debuggerInstance.checkForActions(ast);
    }
    let res = this.evaluateAbstract(ast, strictCode, metadata);
    (0, _invariant2.default)(res instanceof _index.Value || res instanceof Reference, ast.type);
    return res;
  }

  evaluateAbstract(ast, strictCode, metadata) {
    this.realm.currentLocation = ast.loc;
    this.realm.testTimeout();

    let evaluator = this.realm.evaluators[ast.type];
    if (evaluator) {
      let result = evaluator(ast, strictCode, this, this.realm, metadata);
      return result;
    }

    throw new TypeError(`Unsupported node type ${ast.type}`);
  }

  partiallyEvaluate(ast, strictCode, metadata) {
    let partialEvaluator = this.realm.partialEvaluators[ast.type];
    if (partialEvaluator) {
      return partialEvaluator(ast, strictCode, this, this.realm, metadata);
    }

    let err = new TypeError(`Unsupported node type ${ast.type}`);
    throw err;
  }
}

exports.LexicalEnvironment = LexicalEnvironment; // ECMA262 6.2.3
// A Reference is a resolved name or property binding. A Reference consists of three components, the base value,
// the referenced name and the Boolean valued strict reference flag. The base value is either undefined, an Object,
// a Boolean, a String, a Symbol, a Number, or an Environment Record. A base value of undefined indicates that the
// Reference could not be resolved to a binding. The referenced name is a String or Symbol value.

function mightBecomeAnObject(base) {
  let type = base.getType();
  // The top Value type might be able to become an object. We let it
  // pass and error later if it can't.
  return type === _index.Value || type === _PrimitiveValue2.default || type === _index.BooleanValue || type === _index.StringValue || type === _index.SymbolValue || type === _index.NumberValue || type === _index.IntegralValue;
}

class Reference {

  constructor(base, refName, strict, thisValue) {
    (0, _invariant2.default)(base instanceof _index.AbstractObjectValue || base === undefined || base instanceof _index.ObjectValue || base instanceof EnvironmentRecord || mightBecomeAnObject(base));
    this.base = base;
    this.referencedName = refName;
    (0, _invariant2.default)(!(refName instanceof _index.AbstractValue) || !(refName.mightNotBeString() && refName.mightNotBeNumber() && !refName.isSimpleObject() &&
    // if the base is a simple abstract object but
    // the refName is not simple, this is also okay
    base instanceof _index.AbstractValue && !base.isSimpleObject()));
    this.strict = strict;
    this.thisValue = thisValue;
    (0, _invariant2.default)(thisValue === undefined || !(base instanceof EnvironmentRecord));
  }
}
exports.Reference = Reference;

/***/ }),
/* 9 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IsConcatSpreadable = IsConcatSpreadable;
exports.IsGenericDescriptor = IsGenericDescriptor;
exports.IsAccessorDescriptor = IsAccessorDescriptor;
exports.IsDataDescriptor = IsDataDescriptor;
exports.OrdinaryIsExtensible = OrdinaryIsExtensible;
exports.IsExtensible = IsExtensible;
exports.IsCallable = IsCallable;
exports.IsConstructor = IsConstructor;
exports.IsInteger = IsInteger;
exports.IsPropertyKey = IsPropertyKey;
exports.IsArray = IsArray;
exports.IsInTailPosition = IsInTailPosition;
exports.IsRegExp = IsRegExp;
exports.IsIdentifierRef = IsIdentifierRef;
exports.IsFunctionDefinition = IsFunctionDefinition;
exports.IsAnonymousFunctionDefinition = IsAnonymousFunctionDefinition;
exports.IsArrayIndex = IsArrayIndex;
exports.IsPromise = IsPromise;
exports.IsDetachedBuffer = IsDetachedBuffer;
exports.IsIntrospectionError = IsIntrospectionError;
exports.IsStatic = IsStatic;
exports.IsStatement = IsStatement;

var _errors = __webpack_require__(6);

var _get = __webpack_require__(11);

var _index = __webpack_require__(0);

var _singletons = __webpack_require__(2);

var _invariant = __webpack_require__(1);

var _invariant2 = _interopRequireDefault(_invariant);

var _has = __webpack_require__(27);

var _babelTypes = __webpack_require__(4);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// ECMA262 22.1.3.1.1
/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 */

function IsConcatSpreadable(realm, O) {
  // 1. If Type(O) is not Object, return false.
  if (!O.mightBeObject()) return false;
  O = O.throwIfNotObject();

  // 2. Let spreadable be ? Get(O, @@isConcatSpreadable).
  let spreadable = (0, _get.Get)(realm, O, realm.intrinsics.SymbolIsConcatSpreadable);

  // 3. If spreadable is not undefined, return ToBoolean(spreadable).
  if (!spreadable.mightBeUndefined()) return _singletons.To.ToBooleanPartial(realm, spreadable);
  spreadable.throwIfNotConcrete();

  // 4. Return ? IsArray(O).
  return IsArray(realm, O);
}

// ECMA262 6.2.4.3
function IsGenericDescriptor(realm, Desc) {
  // 1. If Desc is undefined, return false.
  if (!Desc) return false;

  // 2. If IsAccessorDescriptor(Desc) and IsDataDescriptor(Desc) are both false, return true.
  if (!IsAccessorDescriptor(realm, Desc) && !IsDataDescriptor(realm, Desc)) return true;

  // 3. Return false.
  return false;
}

// ECMA262 6.2.4.1
function IsAccessorDescriptor(realm, Desc) {
  // 1. If Desc is undefined, return false.
  if (!Desc) return false;

  // 2. If both Desc.[[Get]] and Desc.[[Set]] are absent, return false.
  if (!("get" in Desc) && !("set" in Desc)) return false;

  // 3. Return true.
  return true;
}

// ECMA262 6.2.4.2
function IsDataDescriptor(realm, Desc) {
  // If Desc is undefined, return false.
  if (!Desc) return false;

  // If both Desc.[[Value]] and Desc.[[Writable]] are absent, return false.
  if (!("value" in Desc) && !("writable" in Desc)) return false;

  // Return true.
  return true;
}

// ECMA262 9.1.3.1
function OrdinaryIsExtensible(realm, O) {
  // 1. Return the value of the [[Extensible]] internal slot of O.
  return O.getExtensible();
}

// ECMA262 7.2.5
function IsExtensible(realm, O) {
  // 1. Assert: Type(O) is Object.

  // 2. Return ? O.[[IsExtensible]]().
  return O.$IsExtensible();
}

// ECMA262 7.2.3
function IsCallable(realm, func) {
  // 1. If Type(argument) is not Object, return false.
  if (!func.mightBeObject()) return false;
  if ((0, _has.HasCompatibleType)(func, _index.FunctionValue)) return true;
  if (func.isSimpleObject()) return false;

  // 2. If argument has a [[Call]] internal method, return true.
  func = func.throwIfNotConcreteObject();
  if (func.$Call) return true;

  // 3. Return false.
  return false;
}

// ECMA262 7.2.4
function IsConstructor(realm, argument) {
  // 1. If Type(argument) is not Object, return false.
  if (!argument.mightBeObject()) return false;

  // 2. If argument has a [[Construct]] internal method, return true.
  argument = argument.throwIfNotConcreteObject();
  if (argument.$Construct) return true;

  // 3. Return false.
  return false;
}

// ECMA262 7.2.6
function IsInteger(realm, argument) {
  // 1. If Type(argument) is not Number, return false.
  (0, _invariant2.default)(typeof argument === "number", "Type(argument) is not number");

  // 2. If argument is NaN, +∞, or -∞, return false.
  if (isNaN(argument) || argument === +Infinity || argument === -Infinity) return false;

  // 3. If floor(abs(argument)) ≠ abs(argument), return false.
  if (Math.floor(Math.abs(argument)) !== Math.abs(argument)) return false;

  // 4. Return true.
  return true;
}

// ECMA262 7.2.7
function IsPropertyKey(realm, arg) {
  // We allow native strings to be passed around to avoid constructing a StringValue
  if (typeof arg === "string") return true;

  // 1. If Type(argument) is String, return true.
  if (arg instanceof _index.StringValue) return true;

  // 2. If Type(argument) is Symbol, return true.
  if (arg instanceof _index.SymbolValue) return true;

  if (arg instanceof _index.AbstractValue) {
    _index.AbstractValue.reportIntrospectionError(arg);
    throw new _errors.FatalError();
  }

  // 3. Return false.
  return false;
}

// ECMA262 7.2.2
function IsArray(realm, argument) {
  // 1. If Type(argument) is not Object, return false.
  if (!argument.mightBeObject()) return false;

  // 2. If argument is an Array exotic object, return true.
  if (argument instanceof _index.ArrayValue || argument === realm.intrinsics.ArrayPrototype) return true;

  // 3. If argument is a Proxy exotic object, then
  if (argument instanceof _index.ProxyValue) {
    // a. If the value of the [[ProxyHandler]] internal slot of argument is null, throw a TypeError exception.
    if (!argument.$ProxyHandler || argument.$ProxyHandler instanceof _index.NullValue) {
      throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError);
    }

    // b. Let target be the value of the [[ProxyTarget]] internal slot of argument.
    let target = argument.$ProxyTarget;

    // c. Return ? IsArray(target).
    return IsArray(realm, target);
  }

  // 4. Return false.
  if (!argument.isSimpleObject()) argument.throwIfNotConcrete();
  return false;
}

// ECMA262 14.6.1
function IsInTailPosition(realm, node) {
  // TODO #1008: implement tail calls
  return false;
}

// ECMA262 7.2.8
function IsRegExp(realm, argument) {
  // 1. If Type(argument) is not Object, return false.
  if (!argument.mightBeObject()) return false;
  argument = argument.throwIfNotObject();

  // 2. Let isRegExp be ? Get(argument, @@match).
  let isRegExp = (0, _get.Get)(realm, argument, realm.intrinsics.SymbolMatch);

  // 3. If isRegExp is not undefined, return ToBoolean(isRegExp).
  if (isRegExp !== undefined) return _singletons.To.ToBooleanPartial(realm, isRegExp) === true;

  // 4. If argument has a [[RegExpMatcher]] internal slot, return true.
  if (argument.$RegExpMatcher) return true;

  // 5. Return false.
  return false;
}

// ECMA262 12.2.1.4 Static Semantics: IsIdentifierRef
// ECMA262 12.3.1.4 Static Semantics: IsIdentifierRef
function IsIdentifierRef(realm, node) {
  switch (node.type) {
    // ECMA262 12.2.1.4 Static Semantics: IsIdentifierRef
    case "Identifier":
      return true;
    // ECMA262 12.3.1.4 Static Semantics: IsIdentifierRef
    case "MemberExpression":
      return false;
    default:
      throw Error("Unexpected AST form : " + node.type);
  }
}

// 12.2.1.3 Static Semantics: IsFunctionDefinition
// 12.2.1.3 Static Semantics: IsFunctionDefinition
// 12.13 Binary Logical Operators
// 12.3.1.2 Static Semantics: IsFunctionDefinition
// 12.15.2 Static Semantics: IsFunctionDefinition
function IsFunctionDefinition(realm, node) {
  switch (node.type) {
    // 12.2.1.3 Static Semantics: IsFunctionDefinition
    case "ThisExpression":
    case "Identifier":
    case "StringLiteral":
    case "NumericLiteral":
    case "BooleanLiteral":
    case "NullLiteral":
    case "RegExpLiteral":
    case "ArrayExpression":
    case "ObjectExpression":
    case "TemplateLiteral":
    case "ConditionalExpression":
      return false;
    // 12.2.1.3 Static Semantics: IsFunctionDefinition
    case "UpdateExpression":
      return false;
    // 12.13 Binary Logical Operators
    case "BinaryExpression":
    case "LogicalExpression":
      return false;
    // 12.3.1.2 Static Semantics: IsFunctionDefinition
    case "MemberExpression":
    case "CallExpression":
    case "NewExpression":
    case "MetaProperty":
    case "TaggedTemplateExpression":
      return false;
    //12.5.1 Static Semantics: IsFunctionDefinition
    case "UnaryExpression":
      return false;
    //12.15.2 Static Semantics: IsFunctionDefinition
    case "AssignmentExpression":
      return false;
    //12.16.1 Static Semantics: IsFunctionDefinition
    case "SequenceExpression":
      return false;
    case "ArrowFunctionExpression":
    case "FunctionExpression":
      return true;
    // 14.5.8 Static Semantics: IsFunctionDefinition
    case "ClassExpression":
      return true;
    // JSX Extensions: http://facebook.github.io/jsx/
    case "JSXElement":
      return false;
    default:
      throw Error("Unexpected AST form : " + node.type);
  }
}

// ECMA262 14.1.10
function IsAnonymousFunctionDefinition(realm, node) {
  // 1. If IsFunctionDefinition of production is false, return false.
  if (!IsFunctionDefinition(realm, node)) return false;

  // 2. Let hasName be the result of HasName of production.
  let hasName = (0, _has.HasName)(realm, node);

  // 3. If hasName is true, return false.
  if (hasName === true) return false;

  // 4. Return true.
  return true;
}

// ECMA262 9.4.2
function IsArrayIndex(realm, P) {
  let key;
  if (typeof P === "string") {
    key = P;
  } else if (P instanceof _index.StringValue) {
    key = P.value;
  } else {
    return false;
  }

  let i = _singletons.To.ToUint32(realm, new _index.StringValue(realm, key));
  return i !== Math.pow(2, 32) - 1 && _singletons.To.ToString(realm, new _index.NumberValue(realm, i)) === key;
}

// ECMA262 25.4.1.6
function IsPromise(realm, x) {
  // 1. If Type(x) is not Object, return false.
  if (!x.mightBeObject()) return false;

  // 2. If x does not have a [[PromiseState]] internal slot, return false.
  x = x.throwIfNotConcreteObject();
  if (!x.$PromiseState) return false;

  // 3. Return true.
  return true;
}

// ECMA262 24.1.1.2
function IsDetachedBuffer(realm, arrayBuffer) {
  // 1. Assert: Type(arrayBuffer) is Object and it has an [[ArrayBufferData]] internal slot.
  (0, _invariant2.default)(arrayBuffer instanceof _index.ObjectValue && "$ArrayBufferData" in arrayBuffer);

  // 2. If arrayBuffer's [[ArrayBufferData]] internal slot is null, return true.
  if (arrayBuffer.$ArrayBufferData === null) return true;

  // 3. Return false.
  return false;
}

function IsIntrospectionError(realm, value) {
  if (!value.mightBeObject()) return false;
  value = value.throwIfNotConcreteObject();
  return value.$GetPrototypeOf() === realm.intrinsics.__IntrospectionErrorPrototype;
}

function IsStatic(classElement) {
  // $FlowFixMe need to backport static property to BabelNodeClassMethod
  return classElement.static;
}

function IsStatement(node) {
  switch (node.type) {
    case "BlockStatement":
    case "BreakStatement":
    case "ContinueStatement":
    case "DebuggerStatement":
    case "DoWhileStatement":
    case "EmptyStatement":
    case "ExpressionStatement":
    case "ForInStatement":
    case "ForStatement":
    case "FunctionDeclaration":
    case "IfStatement":
    case "LabeledStatement":
    case "ReturnStatement":
    case "SwitchStatement":
    case "ThrowStatement":
    case "TryStatement":
    case "VariableDeclaration":
    case "WhileStatement":
    case "WithStatement":
    case "ClassDeclaration":
    case "ExportAllDeclaration":
    case "ExportDefaultDeclaration":
    case "ExportNamedDeclaration":
    case "ForOfStatement":
    case "ImportDeclaration":
    case "DeclareClass":
    case "DeclareFunction":
    case "DeclareInterface":
    case "DeclareModule":
    case "DeclareModuleExports":
    case "DeclareTypeAlias":
    case "DeclareVariable":
    case "InterfaceDeclaration":
    case "TypeAlias":
    case "ForAwaitStatement":
      return true;
    default:
      return false;
  }
}

/***/ }),
/* 10 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

exports.matchesAst = matchesAst;
exports.isAstMatch = isAstMatch;
exports.extract = extract;
exports.matchesLength = matchesLength;

var _fp = __webpack_require__(14);

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/**
 * Creates a function that matches AST against the given pattern,
 *
 * See: isAstMatch()
 *
 * @param  {Object} pattern Pattern to test against
 * @return {Function} Function that returns an object with
 * extracted fields or false when no match found.
 */
function matchesAst(pattern) {
  return function (ast) {
    return isAstMatch(ast, pattern);
  };
}

/**
 * Matches AST against the given pattern,
 *
 * Similar to LoDash.isMatch(), but with the addition that a Function
 * can be provided to assert various conditions e.g. checking that
 * number is within a certain range.
 *
 * Additionally there are utility functions:
 *
 * - extract() can be used to give names to the parts of AST -
 *   these are then returned as a map of key-value pairs.
 *
 * - matchesLength() ensures the exact array length is respected.
 *
 * @param  {Object} ast The AST node to test
 * @param {Object} pattern Pattern to test against
 * @return {Object/Boolean} an object with extracted fields
 * or false when no match found.
 */
function isAstMatch(ast, pattern) {
  var extractedFields = {};

  var matches = (0, _fp.isMatchWith)(function (value, matcher) {
    if (typeof matcher === 'function') {
      var result = matcher(value);
      if ((typeof result === 'undefined' ? 'undefined' : _typeof(result)) === 'object') {
        Object.assign(extractedFields, result);
      }
      return result;
    }
  }, pattern, ast);

  if (matches) {
    return extractedFields;
  } else {
    return false;
  }
}

/**
 * Utility for extracting values during matching with matchesAst()
 *
 * @param {String} fieldName The name to give for the value
 * @param {Function|Object} matcher Optional matching function or pattern for matchesAst()
 * @return {Function}
 */
function extract(fieldName, matcher) {
  return function (ast) {
    var extractedFields = _defineProperty({}, fieldName, ast);

    if ((typeof matcher === 'undefined' ? 'undefined' : _typeof(matcher)) === 'object') {
      matcher = matchesAst(matcher);
    }

    if (typeof matcher === 'function') {
      var result = matcher(ast);
      if ((typeof result === 'undefined' ? 'undefined' : _typeof(result)) === 'object') {
        return Object.assign(extractedFields, result);
      }
      if (!result) {
        return false;
      }
    }

    return extractedFields;
  };
}

/**
 * Utility for asserting that AST also matches the exact length
 * of the specified array pattern (in addition to matching
 * the first items in the array).
 *
 * @param {Array} pattern
 * @return {Function}
 */
function matchesLength(pattern) {
  var matcher = matchesAst(pattern);

  return function (ast) {
    if (ast.length !== pattern.length) {
      return false;
    }
    return matcher(ast);
  };
}

exports.default = matchesAst;

/***/ }),
/* 11 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GetFunctionRealm = GetFunctionRealm;
exports.OrdinaryGet = OrdinaryGet;
exports.GetGlobalObject = GetGlobalObject;
exports.GetSubstitution = GetSubstitution;
exports.GetMethod = GetMethod;
exports.GetPrototypeFromConstructor = GetPrototypeFromConstructor;
exports.Get = Get;
exports.GetV = GetV;
exports.GetThisValue = GetThisValue;
exports.GetNewTarget = GetNewTarget;
exports.GetTemplateObject = GetTemplateObject;

var _completions = __webpack_require__(3);

var _realm = __webpack_require__(7);

var _index = __webpack_require__(0);

var _environment = __webpack_require__(8);

var _errors = __webpack_require__(6);

var _integrity = __webpack_require__(356);

var _index2 = __webpack_require__(5);

var _singletons = __webpack_require__(2);

var _invariant = __webpack_require__(1);

var _invariant2 = _interopRequireDefault(_invariant);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// ECMA262 7.3.22
function GetFunctionRealm(realm, obj) {
  // 1. Assert: obj is a callable object.
  (0, _invariant2.default)((0, _index2.IsCallable)(realm, obj), "expected callable object");

  // ProxyValue moved to realm before
  // https://github.com/facebook/prepack/pull/1351

  // 4. If obj is a Proxy exotic object, then
  if (obj instanceof _index.ProxyValue) {
    // a. If the value of the [[ProxyHandler]] internal slot of obj is null, throw a TypeError exception.
    if (obj.$ProxyHandler instanceof _index.NullValue) {
      throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "proxy handler is null");
    }
    (0, _invariant2.default)(obj.$ProxyTarget instanceof _index.ObjectValue);

    // b. Let proxyTarget be the value of obj's [[ProxyTarget]] internal slot.
    let proxyTarget = obj.$ProxyTarget;

    // c. Return ? GetFunctionRealm(proxyTarget).
    return GetFunctionRealm(realm, proxyTarget);
  }

  // 2. If obj has a [[Realm]] internal slot, then
  if (obj.$Realm) {
    // a. Return obj's [[Realm]] internal slot.
    return obj.$Realm;
  }

  // 3. If obj is a Bound Function exotic object, then
  if (obj instanceof _index.BoundFunctionValue) {
    // a. Let target be obj's [[BoundTargetFunction]] internal slot.
    let target = obj.$BoundTargetFunction;

    // b. Return ? GetFunctionRealm(target).
    return GetFunctionRealm(realm, target);
  }

  // 5. Return the current Realm Record.
  return realm;
}

// ECMA262 9.1.8.1
/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 */

function OrdinaryGet(realm, O, P, Receiver, dataOnly) {
  // 1. Assert: IsPropertyKey(P) is true.
  (0, _invariant2.default)((0, _index2.IsPropertyKey)(realm, P), "expected property key");

  // 2. Let desc be ? O.[[GetOwnProperty]](P).
  let desc = O.$GetOwnProperty(P);
  if (desc !== undefined && desc.joinCondition !== undefined) {
    // joined descriptors need special treatment
    let joinCondition = desc.joinCondition;
    if (joinCondition !== undefined) {
      let descriptor2 = desc.descriptor2;
      desc = desc.descriptor1;
      let [compl1, gen1, bindings1, properties1, createdObj1] = _singletons.Path.withCondition(joinCondition, () => {
        return desc !== undefined ? realm.evaluateForEffects(() => OrdinaryGetHelper()) : (0, _realm.construct_empty_effects)(realm);
      });
      desc = descriptor2;
      let [compl2, gen2, bindings2, properties2, createdObj2] = _singletons.Path.withInverseCondition(joinCondition, () => {
        return desc !== undefined ? realm.evaluateForEffects(() => OrdinaryGetHelper()) : (0, _realm.construct_empty_effects)(realm);
      });

      // Join the effects, creating an abstract view of what happened, regardless
      // of the actual value of ownDesc.joinCondition.
      let joinedEffects = _singletons.Join.joinEffects(realm, joinCondition, [compl1, gen1, bindings1, properties1, createdObj1], [compl2, gen2, bindings2, properties2, createdObj2]);
      let completion = joinedEffects[0];
      if (completion instanceof _completions.PossiblyNormalCompletion) {
        // in this case one of the branches may complete abruptly, which means that
        // not all control flow branches join into one flow at this point.
        // Consequently we have to continue tracking changes until the point where
        // all the branches come together into one.
        completion = realm.composeWithSavedCompletion(completion);
      }
      // Note that the effects of (non joining) abrupt branches are not included
      // in joinedEffects, but are tracked separately inside completion.
      realm.applyEffects(joinedEffects);

      // return or throw completion
      if (completion instanceof _completions.AbruptCompletion) throw completion;
      (0, _invariant2.default)(completion instanceof _index.Value);
      return completion;
    }
  }

  return OrdinaryGetHelper();

  function OrdinaryGetHelper() {
    let descValue = !desc ? realm.intrinsics.undefined : desc.value === undefined ? realm.intrinsics.undefined : desc.value;
    (0, _invariant2.default)(descValue instanceof _index.Value);

    // 3. If desc is undefined, then
    if (!desc || descValue.mightHaveBeenDeleted()) {
      // a. Let parent be ? O.[[GetPrototypeOf]]().
      let parent = O.$GetPrototypeOf();

      // b. If parent is null, return undefined.
      if (parent instanceof _index.NullValue) {
        // Return the property value since it is now known to be the right value
        // even in the case when it is empty.
        return descValue;
      }

      // c. Return ? parent.[[Get]](P, Receiver).
      if (descValue.mightHaveBeenDeleted() && descValue instanceof _index.AbstractValue) {
        // We don't know for sure that O.P does not exist.
        let parentVal = OrdinaryGet(realm, parent, P, descValue, true);
        if (parentVal instanceof _index.UndefinedValue)
          // even O.P returns undefined it is still the right value.
          return descValue;
        // Join with parent value with descValue because the actual value will be
        // descValue unless it is empty.
        // Only get the parent value if it does not involve a getter call.
        // Use a property get for the joined value since it does the check for empty.
        let cond = _index.AbstractValue.createFromBinaryOp(realm, "!==", descValue, realm.intrinsics.empty);
        return _singletons.Join.joinValuesAsConditional(realm, cond, descValue, parentVal);
      }
      (0, _invariant2.default)(!desc || descValue instanceof _index.EmptyValue);
      return parent.$Get(P, Receiver);
    }

    // 4. If IsDataDescriptor(desc) is true, return desc.[[Value]].
    if ((0, _index2.IsDataDescriptor)(realm, desc)) return descValue;
    if (dataOnly) {
      (0, _invariant2.default)(descValue instanceof _index.AbstractValue);
      _index.AbstractValue.reportIntrospectionError(descValue);
      throw new _errors.FatalError();
    }

    // 5. Assert: IsAccessorDescriptor(desc) is true.
    (0, _invariant2.default)((0, _index2.IsAccessorDescriptor)(realm, desc), "expected accessor descriptor");

    // 6. Let getter be desc.[[Get]].
    let getter = desc.get;

    // 7. If getter is undefined, return undefined.
    if (!getter || getter instanceof _index.UndefinedValue) return realm.intrinsics.undefined;

    // 8. Return ? Call(getter, Receiver).
    return (0, _index2.Call)(realm, getter, Receiver);
  }
}

// ECMA262 8.3.6
function GetGlobalObject(realm) {
  // 1. Let ctx be the running execution context.
  let ctx = realm.getRunningContext();

  // 2. Let currentRealm be ctx's Realm.
  let currentRealm = ctx.realm;

  // 3. Return currentRealm.[[GlobalObject]].
  return currentRealm.$GlobalObject;
}

// ECMA262 21.1.3.14.1
function GetSubstitution(realm, matched, str, position, captures, replacement) {
  // 1. Assert: Type(matched) is String.
  (0, _invariant2.default)(typeof matched === "string", "expected matched to be a stirng");

  // 2. Let matchLength be the number of code units in matched.
  let matchLength = matched.length;

  // 3. Assert: Type(str) is String.
  (0, _invariant2.default)(typeof str === "string", "expected matched to be a stirng");

  // 4. Let stringLength be the number of code units in str.
  let stringLength = str.length;

  // 5. Assert: position is a nonnegative integer.
  (0, _invariant2.default)(position >= 0, "expected position to be a nonegative integer");

  // 6. Assert: position ≤ stringLength.
  (0, _invariant2.default)(position <= stringLength, "expected position to be less than string length");

  // 7. Assert: captures is a possibly empty List of Strings.
  (0, _invariant2.default)(Array.isArray(captures), "expected captures to be an array");

  // 8. Assert: Type(replacement) is String.
  (0, _invariant2.default)(typeof replacement === "string", "expected replacement to be a stirng");

  // 9. Let tailPos be position + matchLength.
  let tailPos = position + matchLength;

  // 10. Let m be the number of elements in captures.
  let m = captures.length;

  // 11. Let result be a String value derived from replacement by copying code unit elements
  //     from replacement to result while performing replacements as specified in Table 46.
  //     These $ replacements are done left-to-right, and, once such a replacement is performed,
  //     the new replacement text is not subject to further replacements.
  let result = "";
  for (let i = 0; i < replacement.length; ++i) {
    let ch = replacement.charAt(i);
    if (ch !== "$" || i + 1 >= replacement.length) {
      result += ch;
      continue;
    }
    let peek = replacement.charAt(i + 1);
    if (peek === "&") {
      result += matched;
    } else if (peek === "$") {
      result += "$";
    } else if (peek === "`") {
      result += str.substr(0, position);
    } else if (peek === "'") {
      result += str.substr(tailPos);
    } else if (peek >= "0" && peek <= "9") {
      let idx = peek.charCodeAt(0) - "0".charCodeAt(0);
      if (i + 2 < replacement.length) {
        let peek2 = replacement.charAt(i + 2);
        if (peek2 >= "0" && peek2 <= "9") {
          let newIdx = idx * 10 + (peek2.charCodeAt(0) - "0".charCodeAt(0));
          if (newIdx <= m) {
            idx = newIdx;
            i += 1;
          }
        }
      }
      if (idx > 0 && idx <= m) {
        result += captures[idx - 1] || "";
      } else {
        result += "$" + idx;
      }
    } else {
      result += "$" + peek;
    }
    i += 1;
  }

  // 12. Return result.
  return result;
}

// ECMA262 7.3.9
function GetMethod(realm, V, P) {
  // 1. Assert: IsPropertyKey(P) is true.
  (0, _invariant2.default)((0, _index2.IsPropertyKey)(realm, P), "expected property key");

  // 2. Let func be ? GetV(V, P).
  let func = GetV(realm, V, P);

  // 3. If func is either undefined or null, return undefined.
  if ((0, _index2.HasSomeCompatibleType)(func, _index.NullValue, _index.UndefinedValue)) {
    return realm.intrinsics.undefined;
  }

  // 4. If IsCallable(func) is false, throw a TypeError exception.
  if (!(0, _index2.IsCallable)(realm, func)) {
    throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "not callable");
  }

  // 5. Return func.
  return func;
}

// ECMA262 9.1.14
function GetPrototypeFromConstructor(realm, constructor, intrinsicDefaultProto) {
  // 1. Assert: intrinsicDefaultProto is a String value that is this specification's name of an intrinsic
  //   object. The corresponding object must be an intrinsic that is intended to be used as the [[Prototype]]
  //   value of an object.
  (0, _invariant2.default)(realm.intrinsics[intrinsicDefaultProto], "not a valid proto ref");

  // 2. Assert: IsCallable(constructor) is true.
  (0, _invariant2.default)((0, _index2.IsCallable)(realm, constructor) === true, "expected constructor to be callable");

  // 3. Let proto be ? Get(constructor, "prototype").
  let proto = Get(realm, constructor, new _index.StringValue(realm, "prototype"));

  // 4. If Type(proto) is not Object, then
  if (!(proto instanceof _index.ObjectValue)) {
    // a. Let realm be ? GetFunctionRealm(constructor).
    realm = GetFunctionRealm(realm, constructor);

    // b. Let proto be realm's intrinsic object named intrinsicDefaultProto.
    proto = realm.intrinsics[intrinsicDefaultProto];
  }

  // 5. Return proto.
  return proto;
}

// ECMA262 7.3.1
function Get(realm, O, P) {
  // 1. Assert: Type(O) is Object.
  (0, _invariant2.default)(O instanceof _index.ObjectValue || O instanceof _index.AbstractObjectValue, "Not an object value");

  // 2. Assert: IsPropertyKey(P) is true.
  (0, _invariant2.default)((0, _index2.IsPropertyKey)(realm, P), "Not a valid property key");

  // 3. Return ? O.[[Get]](P, O).
  return O.$Get(P, O);
}

// ECMA262 7.3.2
function GetV(realm, V, P) {
  // 1. Assert: IsPropertyKey(P) is true.
  (0, _invariant2.default)((0, _index2.IsPropertyKey)(realm, P), "Not a valid property key");

  // 2. Let O be ? ToObject(V).
  let O = _singletons.To.ToObjectPartial(realm, V);

  // 3. Return ? O.[[Get]](P, V).
  return O.$Get(P, V);
}

// ECMA262 6.2.3.3
function GetThisValue(realm, V) {
  // 1. Assert: IsPropertyReference(V) is true.
  (0, _invariant2.default)(_singletons.Environment.IsPropertyReference(realm, V), "expected property reference");

  // 2. If IsSuperReference(V) is true, then
  if (_singletons.Environment.IsSuperReference(realm, V)) {
    (0, _invariant2.default)(V.thisValue !== undefined);
    // a. Return the value of the thisValue component of the reference V.
    return V.thisValue;
  }

  // 3. Return GetBase(V).
  let result = _singletons.Environment.GetBase(realm, V);
  (0, _invariant2.default)(result instanceof _index.Value);
  return result;
}

// ECMA262 8.3.5
function GetNewTarget(realm) {
  // 1. Let envRec be GetThisEnvironment( ).
  let envRec = _singletons.Environment.GetThisEnvironment(realm);

  // 2. Assert: envRec has a [[NewTarget]] field.
  if (!("$NewTarget" in envRec)) {
    // In the spec we should not get here because earlier static checks are supposed to prevent it.
    // However, we do not have an appropriate place to do this check earlier.
    throw realm.createErrorThrowCompletion(realm.intrinsics.SyntaxError, "new.target not allowed here");
  }

  // 3. Return envRec.[[NewTarget]].
  return envRec.$NewTarget || realm.intrinsics.undefined;
}

function GetTemplateObject(realm, templateLiteral) {
  // 1. Let rawStrings be TemplateStrings of templateLiteral with argument true.
  let rawStrings = templateLiteral.quasis.map(quasi => quasi.value.raw);

  // 2. Let realm be the current Realm Record.
  realm;

  // 3. Let templateRegistry be realm.[[TemplateMap]].
  let templateRegistry = realm.$TemplateMap;

  // 4. For each element e of templateRegistry, do
  for (let e of templateRegistry) {
    let same;
    if (e.$Strings.length === rawStrings.length) {
      same = true;
      for (let i = 0; i < rawStrings.length; ++i) {
        if (e.$Strings[i] !== rawStrings[i]) {
          same = false;
          break;
        }
      }
    } else {
      same = false;
    }

    // a. If e.[[Strings]] and rawStrings contain the same values in the same order, then
    if (same) {
      // i. Return e.[[Array]].
      return e.$Array;
    }
  }

  // 5. Let cookedStrings be TemplateStrings of templateLiteral with argument false.
  let cookedStrings = templateLiteral.quasis.map(quasi => quasi.value.cooked);

  // 6. Let count be the number of elements in the List cookedStrings.
  let count = cookedStrings.length;

  // 7. Let template be ArrayCreate(count).
  let template = _singletons.Create.ArrayCreate(realm, count);

  // 8. Let rawObj be ArrayCreate(count).
  let rawObj = _singletons.Create.ArrayCreate(realm, count);

  // 9. Let index be 0.
  let index = 0;

  // 10. Repeat while index < count
  while (index < count) {
    // a. Let prop be ! ToString(index).
    let prop = _singletons.To.ToString(realm, new _index.NumberValue(realm, index));

    // b. Let cookedValue be the String value cookedStrings[index].
    let cookedValue = new _index.StringValue(realm, cookedStrings[index]);

    // c. Call template.[[DefineOwnProperty]](prop, PropertyDescriptor{[[Value]]: cookedValue, [[Writable]]: false, [[Enumerable]]: true, [[Configurable]]: false}).
    template.$DefineOwnProperty(prop, {
      value: cookedValue,
      writable: false,
      enumerable: true,
      configurable: false
    });

    // d. Let rawValue be the String value rawStrings[index].
    let rawValue = new _index.StringValue(realm, rawStrings[index]);

    // e. Call rawObj.[[DefineOwnProperty]](prop, PropertyDescriptor{[[Value]]: rawValue, [[Writable]]: false, [[Enumerable]]: true, [[Configurable]]: false}).
    rawObj.$DefineOwnProperty(prop, {
      value: rawValue,
      writable: false,
      enumerable: true,
      configurable: false
    });

    // f. Let index be index+1.
    index = index + 1;
  }

  // 11. Perform SetIntegrityLevel(rawObj, "frozen").
  (0, _integrity.SetIntegrityLevel)(realm, rawObj, "frozen");

  // 12. Call template.[[DefineOwnProperty]]("raw", PropertyDescriptor{[[Value]]: rawObj, [[Writable]]: false, [[Enumerable]]: false, [[Configurable]]: false}).
  template.$DefineOwnProperty("raw", {
    value: rawObj,
    writable: false,
    enumerable: false,
    configurable: false
  });

  // 13. Perform SetIntegrityLevel(template, "frozen").
  (0, _integrity.SetIntegrityLevel)(realm, template, "frozen");

  // 14. Append the Record{[[Strings]]: rawStrings, [[Array]]: template} to templateRegistry.
  templateRegistry.push({ $Strings: rawStrings, $Array: template });

  // 15. Return template.
  return template;
}

/***/ }),
/* 12 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _fp = __webpack_require__(14);

var _estraverse = __webpack_require__(99);

var _estraverse2 = _interopRequireDefault(_estraverse);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// JSX AST types, as documented in:
// https://github.com/facebook/jsx/blob/master/AST.md
var jsxExtensionKeys = {
  JSXIdentifier: [],
  JSXMemberExpression: ['object', 'property'],
  JSXNamespacedName: ['namespace', 'name'],
  JSXEmptyExpression: [],
  JSXExpressionContainer: ['expression'],
  JSXOpeningElement: ['name', 'attributes'],
  JSXClosingElement: ['name'],
  JSXAttribute: ['name', 'value'],
  JSXSpreadAttribute: ['argument'],
  JSXElement: ['openingElement', 'closingElement', 'children']
};

var experimentalExtensionKeys = {
  ExperimentalRestProperty: ['argument'],
  ExperimentalSpreadProperty: ['argument']
};

var extensions = {
  keys: Object.assign({}, jsxExtensionKeys, experimentalExtensionKeys)
};

/**
 * Proxy for ESTraverse.
 * Providing a single place to easily extend its functionality.
 *
 * Exposes the traverse() and replace() methods just like ESTraverse,
 * plus some custom helpers.
 */
exports.default = {
  /**
   * Traverses AST like ESTraverse.traverse()
   * @param  {Object} tree
   * @param  {Object} cfg Object with optional enter() and leave() methods.
   * @return {Object} The transformed tree
   */
  traverse: function traverse(tree, cfg) {
    return _estraverse2.default.traverse(tree, Object.assign(cfg, extensions));
  },


  /**
   * Traverses AST like ESTraverse.replace()
   * @param  {Object} tree
   * @param  {Object} cfg Object with optional enter() and leave() methods.
   * @return {Object} The transformed tree
   */
  replace: function replace(tree, cfg) {
    return _estraverse2.default.replace(tree, Object.assign(cfg, extensions));
  },


  /**
   * Constants to return from enter()/leave() to control traversal:
   *
   * - Skip - skips walking child nodes
   * - Break - ends it all
   * - Remove - removes the current node (only with replace())
   */
  VisitorOption: _estraverse2.default.VisitorOption,

  /**
   * Searches in AST tree for node which satisfies the predicate.
   * @param  {Object} tree
   * @param  {Function|String} query Search function called with `node` and `parent`
   *   Alternatively it can be string: the node type to search for.
   * @param  {String[]} opts.skipTypes List of node types to skip (not traversing into these nodes)
   * @return {Object} The found node or undefined when not found
   */
  find: function find(tree, query) {
    var _ref = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {},
        _ref$skipTypes = _ref.skipTypes,
        skipTypes = _ref$skipTypes === undefined ? [] : _ref$skipTypes;

    var predicate = this.createFindPredicate(query);
    var found = void 0;

    this.traverse(tree, {
      enter: function enter(node, parent) {
        if ((0, _fp.includes)(node.type, skipTypes)) {
          return _estraverse2.default.VisitorOption.Skip;
        }
        if (predicate(node, parent)) {
          found = node;
          return _estraverse2.default.VisitorOption.Break;
        }
      }
    });

    return found;
  },
  createFindPredicate: function createFindPredicate(query) {
    if ((0, _fp.isString)(query)) {
      return function (node) {
        return node.type === query;
      };
    } else {
      return query;
    }
  }
};
module.exports = exports['default'];

/***/ }),
/* 13 */
/***/ (function(module, exports, __webpack_require__) {

module.exports = { "default": __webpack_require__(699), __esModule: true };

/***/ }),
/* 14 */
/***/ (function(module, exports, __webpack_require__) {

var _ = __webpack_require__(537).runInContext();
module.exports = __webpack_require__(538)(_, _);


/***/ }),
/* 15 */
/***/ (function(module, exports) {

var core = module.exports = { version: '2.5.7' };
if (typeof __e == 'number') __e = core; // eslint-disable-line no-undef


/***/ }),
/* 16 */
/***/ (function(module, exports) {

module.exports = function(module) {
	if(!module.webpackPolyfill) {
		module.deprecate = function() {};
		module.paths = [];
		// module.parent = undefined by default
		if(!module.children) module.children = [];
		Object.defineProperty(module, "loaded", {
			enumerable: true,
			get: function() {
				return module.l;
			}
		});
		Object.defineProperty(module, "id", {
			enumerable: true,
			get: function() {
				return module.i;
			}
		});
		module.webpackPolyfill = 1;
	}
	return module;
};


/***/ }),
/* 17 */
/***/ (function(module, exports) {

module.exports = function() {
	throw new Error("define cannot be used indirect");
};


/***/ }),
/* 18 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isReactElement = isReactElement;
exports.getReactSymbol = getReactSymbol;
exports.isTagName = isTagName;
exports.isReactComponent = isReactComponent;
exports.valueIsClassComponent = valueIsClassComponent;
exports.valueIsKnownReactAbstraction = valueIsKnownReactAbstraction;
exports.valueIsReactLibraryObject = valueIsReactLibraryObject;
exports.valueIsLegacyCreateClassComponent = valueIsLegacyCreateClassComponent;
exports.valueIsFactoryClassComponent = valueIsFactoryClassComponent;
exports.addKeyToReactElement = addKeyToReactElement;
exports.getUniqueReactElementKey = getUniqueReactElementKey;
exports.forEachArrayValue = forEachArrayValue;
exports.convertSimpleClassComponentToFunctionalComponent = convertSimpleClassComponentToFunctionalComponent;
exports.convertFunctionalComponentToComplexClassComponent = convertFunctionalComponentToComplexClassComponent;
exports.normalizeFunctionalComponentParamaters = normalizeFunctionalComponentParamaters;
exports.createReactHintObject = createReactHintObject;
exports.getComponentTypeFromRootValue = getComponentTypeFromRootValue;
exports.deleteRefAndKeyFromProps = deleteRefAndKeyFromProps;
exports.objectHasNoPartialKeyAndRef = objectHasNoPartialKeyAndRef;
exports.flattenChildren = flattenChildren;
exports.evaluateComponentTreeBranch = evaluateComponentTreeBranch;
exports.getProperty = getProperty;
exports.isRenderPropFunctionSelfContained = isRenderPropFunctionSelfContained;
exports.createReactEvaluatedNode = createReactEvaluatedNode;
exports.getComponentName = getComponentName;
exports.convertConfigObjectToReactComponentTreeConfig = convertConfigObjectToReactComponentTreeConfig;
exports.getValueFromRenderCall = getValueFromRenderCall;
exports.sanitizeReactElementForFirstRenderOnly = sanitizeReactElementForFirstRenderOnly;

var _realm = __webpack_require__(7);

var _environment = __webpack_require__(8);

var _completions = __webpack_require__(3);

var _index = __webpack_require__(0);

var _generator = __webpack_require__(23);

var _index2 = __webpack_require__(5);

var _BinaryExpression = __webpack_require__(78);

var _invariant = __webpack_require__(1);

var _invariant2 = _interopRequireDefault(_invariant);

var _singletons = __webpack_require__(2);

var _babelTraverse = __webpack_require__(43);

var _babelTraverse2 = _interopRequireDefault(_babelTraverse);

var _babelTypes = __webpack_require__(4);

var t = _interopRequireWildcard(_babelTypes);

var _errors = __webpack_require__(6);

var _AbstractValue = __webpack_require__(368);

var _AbstractValue2 = _interopRequireDefault(_AbstractValue);

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 */

function isReactElement(val) {
  if (!(val instanceof _index.ObjectValue)) {
    return false;
  }
  let realm = val.$Realm;
  if (!realm.react.enabled) {
    return false;
  }
  if (realm.react.reactElements.has(val)) {
    return true;
  }
  if (val.properties.has("$$typeof")) {
    let $$typeof = (0, _index2.Get)(realm, val, "$$typeof");
    let globalObject = realm.$GlobalObject;
    let globalSymbolValue = (0, _index2.Get)(realm, globalObject, "Symbol");

    if (globalSymbolValue === realm.intrinsics.undefined) {
      if ($$typeof instanceof _index.NumberValue) {
        return $$typeof.value === 0xeac7;
      }
    } else if ($$typeof instanceof _index.SymbolValue) {
      let symbolFromRegistry = realm.globalSymbolRegistry.find(e => e.$Symbol === $$typeof);
      let _isReactElement = symbolFromRegistry !== undefined && symbolFromRegistry.$Key === "react.element";
      if (_isReactElement) {
        // add to Set to speed up future lookups
        realm.react.reactElements.add(val);
        return true;
      }
    }
  }
  return false;
}

function getReactSymbol(symbolKey, realm) {
  let reactSymbol = realm.react.symbols.get(symbolKey);
  if (reactSymbol !== undefined) {
    return reactSymbol;
  }
  let SymbolFor = realm.intrinsics.Symbol.properties.get("for");
  if (SymbolFor !== undefined) {
    let SymbolForDescriptor = SymbolFor.descriptor;

    if (SymbolForDescriptor !== undefined) {
      let SymbolForValue = SymbolForDescriptor.value;
      if (SymbolForValue !== undefined && typeof SymbolForValue.$Call === "function") {
        reactSymbol = SymbolForValue.$Call(realm.intrinsics.Symbol, [new _index.StringValue(realm, symbolKey)]);
        realm.react.symbols.set(symbolKey, reactSymbol);
      }
    }
  }
  (0, _invariant2.default)(reactSymbol instanceof _index.SymbolValue, `Symbol("${symbolKey}") could not be found in realm`);
  return reactSymbol;
}

function isTagName(ast) {
  return ast.type === "JSXIdentifier" && /^[a-z]|\-/.test(ast.name);
}

function isReactComponent(name) {
  return name.length > 0 && name[0] === name[0].toUpperCase();
}

function valueIsClassComponent(realm, value) {
  if (!(value instanceof _index.FunctionValue)) {
    return false;
  }
  let prototype = (0, _index2.Get)(realm, value, "prototype");

  if (prototype instanceof _index.ObjectValue) {
    return _singletons.To.ToBooleanPartial(realm, (0, _index2.Get)(realm, prototype, "isReactComponent"));
  }
  return false;
}

function valueIsKnownReactAbstraction(realm, value) {
  return value instanceof _index.AbstractObjectValue && realm.react.abstractHints.has(value);
}

// logger isn't typed otherwise it will increase flow cycle length :()
function valueIsReactLibraryObject(realm, value, logger) {
  if (realm.fbLibraries.react === value) {
    return true;
  }
  // we check that the object is the React or React-like library by checking for
  // core properties that should exist on it
  let reactVersion = logger.tryQuery(() => (0, _index2.Get)(realm, value, "version"), undefined);
  if (!(reactVersion instanceof _index.StringValue)) {
    return false;
  }
  let reactCreateElement = logger.tryQuery(() => (0, _index2.Get)(realm, value, "createElement"), undefined);
  if (!(reactCreateElement instanceof _index.FunctionValue)) {
    return false;
  }
  let reactCloneElement = logger.tryQuery(() => (0, _index2.Get)(realm, value, "cloneElement"), undefined);
  if (!(reactCloneElement instanceof _index.FunctionValue)) {
    return false;
  }
  let reactIsValidElement = logger.tryQuery(() => (0, _index2.Get)(realm, value, "isValidElement"), undefined);
  if (!(reactIsValidElement instanceof _index.FunctionValue)) {
    return false;
  }
  let reactComponent = logger.tryQuery(() => (0, _index2.Get)(realm, value, "Component"), undefined);
  if (!(reactComponent instanceof _index.FunctionValue)) {
    return false;
  }
  let reactChildren = logger.tryQuery(() => (0, _index2.Get)(realm, value, "Children"), undefined);
  if (!(reactChildren instanceof _index.ObjectValue)) {
    return false;
  }
  return false;
}

function valueIsLegacyCreateClassComponent(realm, value) {
  if (!(value instanceof _index.FunctionValue)) {
    return false;
  }
  let prototype = (0, _index2.Get)(realm, value, "prototype");

  if (prototype instanceof _index.ObjectValue) {
    return prototype.properties.has("__reactAutoBindPairs");
  }
  return false;
}

function valueIsFactoryClassComponent(realm, value) {
  if (value instanceof _index.ObjectValue) {
    return _singletons.To.ToBooleanPartial(realm, (0, _index2.Get)(realm, value, "render"));
  }
  return false;
}

function addKeyToReactElement(realm, reactSerializerState, reactElement) {
  // we need to apply a key when we're branched
  let currentKeyValue = (0, _index2.Get)(realm, reactElement, "key") || realm.intrinsics.null;
  let uniqueKey = getUniqueReactElementKey("", reactSerializerState.usedReactElementKeys);
  let newKeyValue = new _index.StringValue(realm, uniqueKey);
  if (currentKeyValue !== realm.intrinsics.null) {
    newKeyValue = (0, _BinaryExpression.computeBinary)(realm, "+", currentKeyValue, newKeyValue);
  }
  // TODO: This might not be safe in DEV because these objects are frozen (Object.freeze).
  // We should probably go behind the scenes in this case to by-pass that.
  reactElement.$Set("key", newKeyValue, reactElement);
}
// we create a unique key for each JSXElement to prevent collisions
// otherwise React will detect a missing/conflicting key at runtime and
// this can break the reconcilation of JSXElements in arrays
function getUniqueReactElementKey(index, usedReactElementKeys) {
  let key;
  do {
    key = Math.random().toString(36).replace(/[^a-z]+/g, "").substring(0, 2);
  } while (usedReactElementKeys.has(key));
  usedReactElementKeys.add(key);
  if (index !== undefined) {
    return `${key}${index}`;
  }
  return key;
}

// a helper function to loop over ArrayValues
function forEachArrayValue(realm, array, mapFunc) {
  let lengthValue = (0, _index2.Get)(realm, array, "length");
  (0, _invariant2.default)(lengthValue instanceof _index.NumberValue, "Invalid length on ArrayValue during reconcilation");
  let length = lengthValue.value;
  for (let i = 0; i < length; i++) {
    let elementProperty = array.properties.get("" + i);
    let elementPropertyDescriptor = elementProperty && elementProperty.descriptor;
    (0, _invariant2.default)(elementPropertyDescriptor, `Invalid ArrayValue[${i}] descriptor`);
    let elementValue = elementPropertyDescriptor.value;
    if (elementValue instanceof _index.Value) {
      mapFunc(elementValue, elementPropertyDescriptor);
    }
  }
}

function GetDescriptorForProperty(value, propertyName) {
  let object = value.properties.get(propertyName);
  (0, _invariant2.default)(object);
  return object.descriptor;
}

function convertSimpleClassComponentToFunctionalComponent(realm, complexComponentType, additionalFunctionEffects) {
  let prototype = complexComponentType.properties.get("prototype");
  (0, _invariant2.default)(prototype);
  (0, _invariant2.default)(prototype.descriptor);
  prototype.descriptor.configurable = true;
  _singletons.Properties.DeletePropertyOrThrow(realm, complexComponentType, "prototype");

  // fix the length as we've changed the arguments
  let lengthProperty = GetDescriptorForProperty(complexComponentType, "length");
  (0, _invariant2.default)(lengthProperty);
  lengthProperty.writable = false;
  lengthProperty.enumerable = false;
  lengthProperty.configurable = true;
  // ensure the length value is set to the new value
  let lengthValue = (0, _index2.Get)(realm, complexComponentType, "length");
  (0, _invariant2.default)(lengthValue instanceof _index.NumberValue);
  lengthValue.value = 2;

  // change the function kind
  complexComponentType.$FunctionKind = "normal";
  // set the prototype back to an object
  complexComponentType.$Prototype = realm.intrinsics.FunctionPrototype;
  // give the function the functional components params
  complexComponentType.$FormalParameters = [t.identifier("props"), t.identifier("context")];
  // add a transform to occur after the additional function has serialized the body of the class
  additionalFunctionEffects.transforms.push(body => {
    // as this was a class before and is now a functional component, we need to replace
    // this.props and this.context to props and context, via the function arugments
    let funcNode = t.functionExpression(null, [], t.blockStatement(body));

    (0, _babelTraverse2.default)(t.file(t.program([t.expressionStatement(funcNode)])), {
      "Identifier|ThisExpression"(path) {
        let node = path.node;
        if (t.isIdentifier(node) && node.name === "this" || t.isThisExpression(node)) {
          let parentPath = path.parentPath;
          let parentNode = parentPath.node;

          if (t.isMemberExpression(parentNode)) {
            // remove the "this" from the member
            parentPath.replaceWith(parentNode.property);
          } else {
            throw new _errors.FatalError(`conversion of a simple class component to functional component failed due to "this" not being replaced`);
          }
        }
      }
    }, undefined, undefined, undefined);
  });
}

function createBinding(descriptor, key, object) {
  return {
    descriptor,
    key,
    object
  };
}

function cloneProperties(realm, properties, object) {
  let newProperties = new Map();
  for (let [propertyName, { descriptor }] of properties) {
    newProperties.set(propertyName, createBinding((0, _index2.cloneDescriptor)(descriptor), propertyName, object));
  }
  return newProperties;
}

function cloneSymbols(realm, symbols, object) {
  let newSymbols = new Map();
  for (let [symbol, { descriptor }] of symbols) {
    newSymbols.set(symbol, createBinding((0, _index2.cloneDescriptor)(descriptor), symbol, object));
  }
  return newSymbols;
}

function cloneValue(realm, originalValue, _prototype, copyToObject) {
  if (originalValue instanceof _index.FunctionValue) {
    return cloneFunction(realm, originalValue, _prototype, copyToObject);
  }
  (0, _invariant2.default)(false, "TODO: add support to cloneValue() for more value types");
}

function cloneFunction(realm, originalValue, _prototype, copyToObject) {
  let newValue;
  if (originalValue instanceof _index.ECMAScriptSourceFunctionValue) {
    newValue = copyToObject || new _index.ECMAScriptSourceFunctionValue(realm, originalValue.intrinsicName);
    (0, _invariant2.default)(newValue instanceof _index.ECMAScriptSourceFunctionValue);
    // $FlowFixMe: complains about Object.assign
    Object.assign(newValue, originalValue);
    let properties = cloneProperties(realm, originalValue.properties, newValue);
    newValue.properties = properties;
    let symbols = cloneSymbols(realm, originalValue.symbols, newValue);
    newValue.symbols = symbols;

    // handle home object + prototype
    let originalPrototype = originalValue.$HomeObject;
    (0, _invariant2.default)(originalPrototype instanceof _index.ObjectValue);
    let prototype = _prototype || clonePrototype(realm, originalPrototype);
    newValue.$HomeObject = prototype;
    if (originalPrototype.properties.has("constructor")) {
      _singletons.Properties.Set(realm, prototype, "constructor", newValue, false);
    }
    if (originalValue.properties.has("prototype")) {
      _singletons.Properties.Set(realm, newValue, "prototype", prototype, false);
    }
  }
  (0, _invariant2.default)(newValue instanceof _index.FunctionValue, "TODO: add support to cloneValue() for more function types");
  return newValue;
}

function clonePrototype(realm, prototype) {
  (0, _invariant2.default)(prototype instanceof _index.ObjectValue);
  let newPrototype = new _index.ObjectValue(realm, realm.intrinsics.ObjectPrototype, prototype.intrinsicName);

  Object.assign(newPrototype, prototype);
  for (let [propertyName] of prototype.properties) {
    if (propertyName !== "constructor") {
      let originalValue = (0, _index2.Get)(realm, prototype, propertyName);
      let newValue = cloneValue(realm, originalValue, prototype);
      _singletons.Properties.Set(realm, newPrototype, propertyName, newValue, false);
    }
  }
  for (let [symbol] of prototype.symbols) {
    let originalValue = (0, _index2.Get)(realm, prototype, symbol);
    let newValue = cloneValue(realm, originalValue, prototype);
    _singletons.Properties.Set(realm, newPrototype, symbol, newValue, false);
  }
  return newPrototype;
}

const skipFunctionProperties = new Set(["length", "prototype", "arguments", "name", "caller"]);

function convertFunctionalComponentToComplexClassComponent(realm, functionalComponentType, complexComponentType, additionalFunctionEffects) {
  (0, _invariant2.default)(complexComponentType instanceof _index.ECMAScriptSourceFunctionValue);
  // get all properties on the functional component that were added in user-code
  // we add defaultProps as undefined, as merging a class component's defaultProps on to
  // a differnet component isn't right, we can discard defaultProps instead via folding
  // we also don't want propTypes from the class component, so we remove that too
  let userCodePropertiesToAdd = new Map([["defaultProps", createBinding(undefined, "defaultProps", functionalComponentType)], ["propTypes", createBinding(undefined, "propTypes", functionalComponentType)]]);
  let userCodeSymbolsToAdd = new Map();

  for (let [propertyName, binding] of functionalComponentType.properties) {
    if (!skipFunctionProperties.has(propertyName)) {
      userCodePropertiesToAdd.set(propertyName, binding);
    }
  }
  for (let [symbol, binding] of functionalComponentType.symbols) {
    userCodeSymbolsToAdd.set(symbol, binding);
  }

  cloneValue(realm, complexComponentType, null, functionalComponentType);
  // then copy back and properties that were on the original functional component
  // ensuring we overwrite any existing ones
  for (let [propertyName, binding] of userCodePropertiesToAdd) {
    functionalComponentType.properties.set(propertyName, binding);
  }
  for (let [symbol, binding] of userCodeSymbolsToAdd) {
    functionalComponentType.symbols.set(symbol, binding);
  }
  // add a transform to occur after the additional function has serialized the body of the class
  additionalFunctionEffects.transforms.push(body => {
    // as we've converted a functional component to a complex one, we are going to have issues with
    // "props" and "context" references, as they're now going to be "this.props" and "this.context".
    // we simply need a to add to vars to beginning of the body to get around this
    // if they're not used, any DCE tool post-Prepack (GCC or Uglify) will remove them
    body.unshift(t.variableDeclaration("var", [t.variableDeclarator(t.identifier("props"), t.memberExpression(t.thisExpression(), t.identifier("props"))), t.variableDeclarator(t.identifier("context"), t.memberExpression(t.thisExpression(), t.identifier("context")))]));
  });
}

function normalizeFunctionalComponentParamaters(func) {
  func.$FormalParameters = func.$FormalParameters.map((param, i) => {
    if (i === 0) {
      return t.isIdentifier(param) ? param : t.identifier("props");
    } else {
      return t.isIdentifier(param) ? param : t.identifier("context");
    }
  });
}

function createReactHintObject(object, propertyName, args) {
  return {
    object,
    propertyName,
    args
  };
}

function getComponentTypeFromRootValue(realm, value) {
  let _valueIsKnownReactAbstraction = valueIsKnownReactAbstraction(realm, value);
  if (!(value instanceof _index.ECMAScriptSourceFunctionValue || _valueIsKnownReactAbstraction)) {
    return null;
  }
  if (_valueIsKnownReactAbstraction) {
    (0, _invariant2.default)(value instanceof _AbstractValue2.default);
    let reactHint = realm.react.abstractHints.get(value);

    (0, _invariant2.default)(reactHint);
    if (typeof reactHint !== "string" && reactHint.object === realm.fbLibraries.reactRelay) {
      switch (reactHint.propertyName) {
        case "createFragmentContainer":
        case "createPaginationContainer":
        case "createRefetchContainer":
          (0, _invariant2.default)(Array.isArray(reactHint.args));
          // componentType is the 1st argument of a ReactRelay container
          let componentType = reactHint.args[0];
          (0, _invariant2.default)(componentType instanceof _index.ECMAScriptSourceFunctionValue);
          return componentType;
        default:
          (0, _invariant2.default)(false, `unsupported known React abstraction - ReactRelay property "${reactHint.propertyName}" not supported`);
      }
    }
    (0, _invariant2.default)(false, "unsupported known React abstraction");
  } else {
    (0, _invariant2.default)(value instanceof _index.ECMAScriptSourceFunctionValue);
    return value;
  }
}

// props should never have "ref" or "key" properties, as they're part of ReactElement
// object instead. to ensure that we can give this hint, we create them and then
// delete them, so their descriptor is left undefined. we use this knowledge later
// to ensure that when dealing with creating ReactElements with partial config,
// we don't have to bail out becuase "config" may or may not have "key" or/and "ref"
function deleteRefAndKeyFromProps(realm, props) {
  let objectValue;
  if (props instanceof _index.AbstractObjectValue) {
    let elements = props.values.getElements();
    if (elements && elements.size > 0) {
      objectValue = Array.from(elements)[0];
    }
    // we don't want to serialize in the output that we're making these deletes
    (0, _invariant2.default)(objectValue instanceof _index.ObjectValue);
    objectValue.refuseSerialization = true;
  }
  _singletons.Properties.Set(realm, props, "ref", realm.intrinsics.undefined, true);
  props.$Delete("ref");
  _singletons.Properties.Set(realm, props, "key", realm.intrinsics.undefined, true);
  props.$Delete("key");
  if (props instanceof _index.AbstractObjectValue) {
    (0, _invariant2.default)(objectValue instanceof _index.ObjectValue);
    objectValue.refuseSerialization = false;
  }
}

function objectHasNoPartialKeyAndRef(realm, object) {
  if (object instanceof _AbstractValue2.default) {
    return true;
  }
  return !((0, _index2.Get)(realm, object, "key") instanceof _AbstractValue2.default || (0, _index2.Get)(realm, object, "ref") instanceof _AbstractValue2.default);
}

function recursivelyFlattenArray(realm, array, targetArray) {
  forEachArrayValue(realm, array, item => {
    if (item instanceof _index.ArrayValue) {
      recursivelyFlattenArray(realm, item, targetArray);
    } else {
      let lengthValue = (0, _index2.Get)(realm, targetArray, "length");
      (0, _invariant2.default)(lengthValue instanceof _index.NumberValue);
      _singletons.Properties.Set(realm, targetArray, "" + lengthValue.value, item, true);
    }
  });
}

function flattenChildren(realm, array) {
  let flattenedChildren = _singletons.Create.ArrayCreate(realm, 0);
  recursivelyFlattenArray(realm, array, flattenedChildren);
  return flattenedChildren;
}

function evaluateComponentTreeBranch(realm, effects, nested, f) {
  let [value, generator, modifiedBindings, modifiedProperties, createdObjects] = effects;
  if (nested) {
    realm.applyEffects([value, new _generator.Generator(realm), modifiedBindings, modifiedProperties, createdObjects]);
  }
  try {
    return f(generator, value);
  } finally {
    if (nested) {
      realm.restoreBindings(modifiedBindings);
      realm.restoreProperties(modifiedProperties);
    }
  }
}

function getProperty(realm, object, property) {
  let binding;
  if (typeof property === "string") {
    binding = object.properties.get(property);
  } else {
    binding = object.symbols.get(property);
  }
  if (!binding) {
    return realm.intrinsics.undefined;
  }
  let descriptor = binding.descriptor;

  if (!descriptor) {
    return realm.intrinsics.undefined;
  }
  let value;
  if (descriptor.value) {
    value = descriptor.value;
  } else if (descriptor.get || descriptor.set) {
    _AbstractValue2.default.reportIntrospectionError(object, `react/utils/getProperty unsupported getter/setter property`);
    throw new _errors.FatalError();
  }
  (0, _invariant2.default)(value instanceof _index.Value, `react/utils/getProperty should not be called on internal properties`);
  return value;
}

function visitName(path, state, name, read, write) {
  // Is the name bound to some local identifier? If so, we don't need to do anything
  if (path.scope.hasBinding(name, /*noGlobals*/true)) return;

  // Otherwise, let's record that there's an unbound identifier
  if (read) state.unboundReads.add(name);
  if (write) state.unboundWrites.add(name);
}

function ignorePath(path) {
  let parent = path.parent;
  return t.isLabeledStatement(parent) || t.isBreakStatement(parent) || t.isContinueStatement(parent);
}

let LeakedClosureRefVisitor = {
  ReferencedIdentifier(path, state) {
    if (ignorePath(path)) return;

    let innerName = path.node.name;
    if (innerName === "arguments") {
      return;
    }
    visitName(path, state, innerName, true, false);
  },

  "AssignmentExpression|UpdateExpression"(path, state) {
    let doesRead = path.node.operator !== "=";
    for (let name in path.getBindingIdentifiers()) {
      visitName(path, state, name, doesRead, true);
    }
  }
};

function getFunctionBindingInfo(value) {
  (0, _invariant2.default)(value instanceof _index.ECMAScriptSourceFunctionValue);
  (0, _invariant2.default)(value.constructor === _index.ECMAScriptSourceFunctionValue);
  let functionInfo = {
    unboundReads: new Set(),
    unboundWrites: new Set()
  };
  let formalParameters = value.$FormalParameters;
  (0, _invariant2.default)(formalParameters != null);
  let code = value.$ECMAScriptCode;
  (0, _invariant2.default)(code != null);

  (0, _babelTraverse2.default)(t.file(t.program([t.expressionStatement(t.functionExpression(null, formalParameters, code))])), LeakedClosureRefVisitor, null, functionInfo);
  return functionInfo;
}

// if a render prop function (a nested additional function) makes
// no accesses to bindings in the parent additional function scope
// we can determine if the function is self contained
function isRenderPropFunctionSelfContained(realm, parentFunc, renderProp, logger // otherwise Flow cycles increases
) {
  let { unboundReads, unboundWrites } = getFunctionBindingInfo(renderProp);
  let bindings = Array.from(unboundReads).concat(Array.from(unboundWrites));

  for (let name of bindings) {
    let reference = logger.tryQuery(() => _singletons.Environment.ResolveBinding(realm, name, true, renderProp.$Environment), undefined);
    if (!reference) {
      return false;
    }
    if (reference.base instanceof _environment.FunctionEnvironmentRecord && reference.base.$FunctionObject === parentFunc) {
      return false;
    }
  }
  return true;
}

function createReactEvaluatedNode(status, name) {
  return {
    children: [],
    message: "",
    name,
    status
  };
}

function getComponentName(realm, componentType) {
  (0, _invariant2.default)(componentType instanceof _index.ECMAScriptSourceFunctionValue || componentType instanceof _index.AbstractObjectValue || componentType instanceof _AbstractValue2.default);
  if (componentType.__originalName) {
    return componentType.__originalName;
  }
  if (realm.fbLibraries.reactRelay !== undefined) {
    if (componentType === (0, _index2.Get)(realm, realm.fbLibraries.reactRelay, "QueryRenderer")) {
      return "QueryRenderer";
    }
  }
  if (componentType instanceof _index.ECMAScriptSourceFunctionValue) {
    let name = (0, _index2.Get)(realm, componentType, "name");

    if (name instanceof _index.StringValue) {
      return name.value;
    }
  }
  return "Unknown";
}

function convertConfigObjectToReactComponentTreeConfig(realm, config) {
  // defaults
  let firstRenderOnly = false;

  if (!(config instanceof _index.UndefinedValue)) {
    for (let [key] of config.properties) {
      let propValue = getProperty(realm, config, key);
      if (propValue instanceof _index.StringValue || propValue instanceof _index.NumberValue || propValue instanceof _index.BooleanValue) {
        let value = propValue.value;

        // boolean options
        if (typeof value === "boolean") {
          if (key === "firstRenderOnly") {
            firstRenderOnly = value;
          }
        }
      } else {
        let diagnostic = new _errors.CompilerDiagnostic("__optimizeReactComponentTree(rootComponent, config) has been called with invalid arguments", realm.currentLocation, "PP0024", "FatalError");
        realm.handleError(diagnostic);
        if (realm.handleError(diagnostic) === "Fail") throw new _errors.FatalError();
      }
    }
  }
  return {
    firstRenderOnly
  };
}

function getValueFromRenderCall(realm, renderFunction, instance, args) {
  (0, _invariant2.default)(renderFunction.$Call, "Expected render function to be a FunctionValue with $Call method");
  let funcCall = renderFunction.$Call;
  let effects;
  try {
    effects = realm.evaluateForEffects(() => funcCall(instance, args));
  } catch (error) {
    throw error;
  }
  let completion = effects[0];
  if (completion instanceof _completions.PossiblyNormalCompletion) {
    // in this case one of the branches may complete abruptly, which means that
    // not all control flow branches join into one flow at this point.
    // Consequently we have to continue tracking changes until the point where
    // all the branches come together into one.
    completion = realm.composeWithSavedCompletion(completion);
  }
  // Note that the effects of (non joining) abrupt branches are not included
  // in joinedEffects, but are tracked separately inside completion.
  realm.applyEffects(effects);
  // return or throw completion
  if (completion instanceof _completions.AbruptCompletion) throw completion;
  (0, _invariant2.default)(completion instanceof _index.Value);
  return completion;
}

function sanitizeReactElementForFirstRenderOnly(realm, reactElement) {
  let typeValue = (0, _index2.Get)(realm, reactElement, "type");

  // ensure ref is null, as we don't use that on first render
  _singletons.Properties.Set(realm, reactElement, "ref", realm.intrinsics.null, false);
  // when dealing with host nodes, we want to sanitize them futher
  if (typeValue instanceof _index.StringValue) {
    let propsValue = (0, _index2.Get)(realm, reactElement, "props");
    if (propsValue instanceof _index.ObjectValue) {
      // remove all values apart from string/number/boolean
      for (let [propName] of propsValue.properties) {
        (0, _invariant2.default)(propsValue instanceof _index.ObjectValue);
        let value = getProperty(realm, propsValue, propName);

        // skip children and style
        if (propName === "children" || propName === "style") {
          continue;
        }
        if (!(value instanceof _index.StringValue || value instanceof _index.NumberValue || value instanceof _index.BooleanValue)) {
          propsValue.$Delete(propName);
        }
      }
    }
  }
  return reactElement;
}

/***/ }),
/* 19 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.URIUnescaped = exports.URIMark = exports.DecimalDigit = exports.URIAlpha = exports.URIReserved = undefined;
exports.SplitMatch = SplitMatch;
exports.RequireObjectCoercible = RequireObjectCoercible;
exports.HasSameType = HasSameType;
exports.AbstractRelationalComparison = AbstractRelationalComparison;
exports.AbstractEqualityComparison = AbstractEqualityComparison;
exports.StrictEqualityComparison = StrictEqualityComparison;
exports.StrictEqualityComparisonPartial = StrictEqualityComparisonPartial;
exports.SameValueZero = SameValueZero;
exports.SameValueZeroPartial = SameValueZeroPartial;
exports.SameValue = SameValue;
exports.SameValuePartial = SameValuePartial;
exports.SameValueNonNumber = SameValueNonNumber;
exports.SamePropertyKey = SamePropertyKey;
exports.Add = Add;
exports.InstanceofOperator = InstanceofOperator;
exports.OrdinaryHasInstance = OrdinaryHasInstance;
exports.Type = Type;
exports.SymbolDescriptiveString = SymbolDescriptiveString;
exports.UpdateEmpty = UpdateEmpty;

var _errors = __webpack_require__(6);

var _index = __webpack_require__(0);

var _call = __webpack_require__(20);

var _is = __webpack_require__(9);

var _completions = __webpack_require__(3);

var _get = __webpack_require__(11);

var _has = __webpack_require__(27);

var _singletons = __webpack_require__(2);

var _invariant = __webpack_require__(1);

var _invariant2 = _interopRequireDefault(_invariant);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const URIReserved = exports.URIReserved = ";/?:@&=+$,"; /**
                                                         * Copyright (c) 2017-present, Facebook, Inc.
                                                         * All rights reserved.
                                                         *
                                                         * This source code is licensed under the BSD-style license found in the
                                                         * LICENSE file in the root directory of this source tree. An additional grant
                                                         * of patent rights can be found in the PATENTS file in the same directory.
                                                         */

const URIAlpha = exports.URIAlpha = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
const DecimalDigit = exports.DecimalDigit = "0123456789";
const URIMark = exports.URIMark = "-_.!~*'()";
const URIUnescaped = exports.URIUnescaped = URIAlpha + DecimalDigit + URIMark;

// ECMA262 21.1.3.17.1
function SplitMatch(realm, S, q, R) {
  // 1. Assert: Type(R) is String.
  (0, _invariant2.default)(typeof R === "string", "expected a string");

  // 2. Let r be the number of code units in R.
  let r = R.length;

  // 3. Let s be the number of code units in S.
  let s = S.length;

  // 4. If q+r > s, return false.
  if (q + r > s) return false;

  // 5. If there exists an integer i between 0 (inclusive) and r (exclusive) such that the code unit at index
  //    q+i of S is different from the code unit at index i of R, return false.
  for (let i = 0; i < r; i++) {
    if (S[q + i] !== R[i]) {
      return false;
    }
  }

  // 6. Return q+r.
  return q + r;
}

// ECMA262 7.2.1
function RequireObjectCoercible(realm, arg, argLoc) {
  if (arg instanceof _index.AbstractValue && (arg.mightBeNull() || arg.mightBeUndefined())) {
    if (realm.isInPureScope()) {
      // In a pure function it is ok to throw if this happens to be null or undefined.
      return arg;
    }
    if (argLoc) {
      let error = new _errors.CompilerDiagnostic(`member expression object ${_index.AbstractValue.describe(arg)} is unknown`, argLoc, "PP0012", "FatalError");
      realm.handleError(error);
      throw new _errors.FatalError();
    }
    arg.throwIfNotConcrete();
  }
  if (arg instanceof _index.NullValue || arg instanceof _index.UndefinedValue) {
    throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "null or undefined");
  } else {
    return arg;
  }
}

function HasSameType(x, y) {
  const xType = x.getType();
  const yType = y.getType();
  return xType === yType || (xType === _index.IntegralValue || xType === _index.NumberValue) && (yType === _index.IntegralValue || yType === _index.NumberValue);
}

// ECMA262 7.2.12 Abstract Relational Comparison
function AbstractRelationalComparison(realm, x, y, LeftFirst) {
  let px, py;

  // 1. If the LeftFirst flag is true, then
  if (LeftFirst) {
    // a. Let px be ? ToPrimitive(x, hint Number).
    px = _singletons.To.ToPrimitive(realm, x, "number");

    // b. Let py be ? ToPrimitive(y, hint Number).
    py = _singletons.To.ToPrimitive(realm, y, "number");
  } else {
    // 2. Else the order of evaluation needs to be reversed to preserve left to right evaluation
    // a. Let py be ? ToPrimitive(y, hint Number).
    py = _singletons.To.ToPrimitive(realm, y, "number");

    // b. Let px be ? ToPrimitive(x, hint Number).
    px = _singletons.To.ToPrimitive(realm, x, "number");
  }

  // 3. If both px and py are Strings, then
  if (px instanceof _index.StringValue && py instanceof _index.StringValue) {
    // a. If py is a prefix of px, return false. (A String value p is a prefix of String value q if q can be the result of concatenating p and some other String r. Note that any String is a prefix of itself, because r may be the empty String.)
    if (px.value.startsWith(py.value)) return realm.intrinsics.false;

    // b. If px is a prefix of py, return true.
    if (py.value.startsWith(px.value)) return realm.intrinsics.true;

    // c. Let k be the smallest nonnegative integer such that the code unit at index k within px is different from the code unit at index k within py. (There must be such a k, for neither String is a prefix of the other.)
    let k = 0;
    while (px.value.charCodeAt(k) === py.value.charCodeAt(k)) {
      k += 1;
    }

    // d. Let m be the integer that is the code unit value at index k within px.
    let m = px.value.charCodeAt(k);

    // e. Let n be the integer that is the code unit value at index k within py.
    let n = py.value.charCodeAt(k);

    // f. If m < n, return true. Otherwise, return false.
    return m < n ? realm.intrinsics.true : realm.intrinsics.false;
  } else {
    // 4. Else,
    // a. Let nx be ? ToNumber(px). Because px and py are primitive values evaluation order is not important.
    let nx = _singletons.To.ToNumber(realm, px);

    // b. Let ny be ? ToNumber(py).
    let ny = _singletons.To.ToNumber(realm, py);

    // c. If nx is NaN, return undefined.
    if (isNaN(nx)) return realm.intrinsics.undefined;

    // d. If ny is NaN, return undefined.
    if (isNaN(ny)) return realm.intrinsics.undefined;

    // e. If nx and ny are the same Number value, return false.
    if (Object.is(nx, ny)) {
      return realm.intrinsics.false;
    }

    // f. If nx is +0 and ny is -0, return false.
    if (Object.is(nx, +0) && Object.is(ny, -0)) {
      return realm.intrinsics.false;
    }

    // g. If nx is -0 and ny is +0, return false.
    if (Object.is(nx, -0) && Object.is(ny, +0)) {
      return realm.intrinsics.false;
    }

    // h. If nx is +∞, return false.
    // i. If ny is +∞, return true.
    // j. If ny is -∞, return false.
    // k. If nx is -∞, return true.

    // i. If the mathematical value of nx is less than the mathematical value of ny —note that these
    //    mathematical values are both finite and not both zero—return true. Otherwise, return false.
    if (nx < ny) {
      return realm.intrinsics.true;
    } else {
      return realm.intrinsics.false;
    }
  }
}

// ECMA262 7.2.13
function AbstractEqualityComparison(realm, x, y) {
  // 1. If Type(x) is the same as Type(y), then
  if (HasSameType(x, y)) {
    // a. Return the result of performing Strict Equality Comparison x === y.
    return StrictEqualityComparison(realm, x, y);
  }

  // 2. If x is null and y is undefined, return true.
  if (x instanceof _index.NullValue && y instanceof _index.UndefinedValue) {
    return true;
  }

  // 3. If x is undefined and y is null, return true.
  if (x instanceof _index.UndefinedValue && y instanceof _index.NullValue) {
    return true;
  }

  // 4. If Type(x) is Number and Type(y) is String, return the result of the comparison x == ToNumber(y).
  if (x instanceof _index.NumberValue && y instanceof _index.StringValue) {
    return AbstractEqualityComparison(realm, x, new _index.NumberValue(realm, _singletons.To.ToNumber(realm, y)));
  }

  // 5. If Type(x) is String and Type(y) is Number, return the result of the comparison ToNumber(x) == y.
  if (x instanceof _index.StringValue && y instanceof _index.NumberValue) {
    return AbstractEqualityComparison(realm, new _index.NumberValue(realm, _singletons.To.ToNumber(realm, x)), y);
  }

  // 6. If Type(x) is Boolean, return the result of the comparison ToNumber(x) == y.
  if (x instanceof _index.BooleanValue) {
    return AbstractEqualityComparison(realm, new _index.NumberValue(realm, _singletons.To.ToNumber(realm, x)), y);
  }

  // 7. If Type(y) is Boolean, return the result of the comparison x == ToNumber(y).
  if (y instanceof _index.BooleanValue) {
    return AbstractEqualityComparison(realm, x, new _index.NumberValue(realm, _singletons.To.ToNumber(realm, y)));
  }

  // 8. If Type(x) is either String, Number, or Symbol and Type(y) is Object, return the result of the comparison x == ToPrimitive(y).
  if ((x instanceof _index.StringValue || x instanceof _index.NumberValue || x instanceof _index.SymbolValue) && y instanceof _index.ObjectValue) {
    return AbstractEqualityComparison(realm, x, _singletons.To.ToPrimitive(realm, y));
  }

  // 9. If Type(x) is Object and Type(y) is either String, Number, or Symbol, return the result of the comparison ToPrimitive(x) == y.
  if (x instanceof _index.ObjectValue && (y instanceof _index.StringValue || y instanceof _index.NumberValue || y instanceof _index.SymbolValue)) {
    return AbstractEqualityComparison(realm, _singletons.To.ToPrimitive(realm, x), y);
  }

  // 10. Return false.
  return false;
}

// ECMA262 7.2.14 Strict Equality Comparison
function StrictEqualityComparison(realm, x, y) {
  // 1. If Type(x) is different from Type(y), return false.
  if (!HasSameType(x, y)) {
    return false;
  }

  // 2. If Type(x) is Number, then
  if (x instanceof _index.NumberValue && y instanceof _index.NumberValue) {
    // a. If x is NaN, return false.
    if (isNaN(x.value)) return false;

    // b. If y is NaN, return false.
    if (isNaN(y.value)) return false;

    // c. If x is the same Number value as y, return true.
    // d. If x is +0 and y is -0, return true. (handled by c)
    // e. If x is -0 and y is +0, return true. (handled by c)
    if (x.value === y.value) return true;

    // f. Return false.
    return false;
  }

  // 3. Return SameValueNonNumber(x, y).
  return SameValueNonNumber(realm, x, y);
}

function StrictEqualityComparisonPartial(realm, x, y) {
  return StrictEqualityComparison(realm, x.throwIfNotConcrete(), y.throwIfNotConcrete());
}

// ECMA262 7.2.10
function SameValueZero(realm, x, y) {
  // 1. If Type(x) is different from Type(y), return false.
  if (!HasSameType(x, y)) {
    return false;
  }

  // 2. If Type(x) is Number, then
  if (x instanceof _index.NumberValue) {
    (0, _invariant2.default)(y instanceof _index.NumberValue);

    // a. If x is NaN and y is NaN, return true.
    if (isNaN(x.value) && isNaN(y.value)) return true;

    // b. If x is +0 and y is -0, return true.
    if (Object.is(x.value, +0) && Object.is(y.value, -0)) return true;

    // c. If x is -0 and y is +0, return true.
    if (Object.is(x.value, -0) && Object.is(y.value, +0)) return true;

    // d. If x is the same Number value as y, return true.
    if (x.value === y.value) return true;

    // e. Return false.
    return false;
  }

  // 3. Return SameValueNonNumber(x, y).
  return SameValueNonNumber(realm, x, y);
}

function SameValueZeroPartial(realm, x, y) {
  return SameValueZero(realm, x.throwIfNotConcrete(), y.throwIfNotConcrete());
}

// ECMA262 7.2.9
function SameValue(realm, x, y) {
  // 1. If Type(x) is different from Type(y), return false.
  if (!HasSameType(x, y)) {
    return false;
  }

  // 2. If Type(x) is Number, then
  if (x instanceof _index.NumberValue && y instanceof _index.NumberValue) {
    // a. If x is NaN and y is NaN, return true.
    if (isNaN(x.value) && isNaN(y.value)) return true;

    // b. If x is +0 and y is -0, return false.
    if (Object.is(x.value, +0) && Object.is(y.value, -0)) return false;

    // c. If x is -0 and y is +0, return false.
    if (Object.is(x.value, -0) && Object.is(y.value, +0)) return false;

    // d. If x is the same Number value as y, return true.
    if (x.value === y.value) return true;

    // e. Return false.
    return false;
  }

  // 3. Return SameValueNonNumber(x, y).
  return SameValueNonNumber(realm, x, y);
}

function SameValuePartial(realm, x, y) {
  return SameValue(realm, x.throwIfNotConcrete(), y.throwIfNotConcrete());
}

// ECMA262 7.2.11
function SameValueNonNumber(realm, x, y) {
  // 1. Assert: Type(x) is not Number.
  (0, _invariant2.default)(!(x instanceof _index.NumberValue), "numbers not allowed");

  // 2. Assert: Type(x) is the same as Type(y).
  (0, _invariant2.default)(x.getType() === y.getType(), "must be same type");

  // 3. If Type(x) is Undefined, return true.
  if (x instanceof _index.UndefinedValue) return true;

  // 4. If Type(x) is Null, return true.
  if (x instanceof _index.NullValue) return true;

  // 5. If Type(x) is String, then
  if (x instanceof _index.StringValue && y instanceof _index.StringValue) {
    // a. If x and y are exactly the same sequence of code units (same length and same code units at corresponding indices), return true; otherwise, return false.
    return x.value === y.value;
  }

  // 6. If Type(x) is Boolean, then
  if (x instanceof _index.BooleanValue && y instanceof _index.BooleanValue) {
    // a. If x and y are both true or both false, return true; otherwise, return false.
    return x.value === y.value;
  }

  // 7. If Type(x) is Symbol, then
  if (x instanceof _index.SymbolValue) {
    // a. If x and y are both the same Symbol value, return true; otherwise, return false.
    return x === y;
  }

  // 8. Return true if x and y are the same Object value. Otherwise, return false.
  return x === y;
}

// Checks if two property keys are identical.
function SamePropertyKey(realm, x, y) {
  if (typeof x === "string" && typeof y === "string") {
    return x === y;
  }
  if (x instanceof _index.StringValue && y instanceof _index.StringValue) {
    return x.value === y.value;
  }
  if (x instanceof _index.SymbolValue && y instanceof _index.SymbolValue) {
    return x === y;
  }
  return false;
}

// ECMA262 12.8.5 Applying the Additive Operators to Numbers
function Add(realm, a, b, subtract = false) {
  // If either operand is NaN, the result is NaN.
  if (isNaN(a) || isNaN(b)) {
    return realm.intrinsics.NaN;
  }

  // The sum of two infinities of opposite sign is NaN.
  // The sum of two infinities of the same sign is the infinity of that sign.
  // The sum of an infinity and a finite value is equal to the infinite operand.
  // The sum of two negative zeroes is -0. The sum of two positive zeroes, or of two zeroes of opposite sign, is +0.
  // The sum of a zero and a nonzero finite value is equal to the nonzero operand.
  // The sum of two nonzero finite values of the same magnitude and opposite sign is +0.

  let anum = a;
  let bnum = b;

  // The - operator performs subtraction when applied to two operands of numeric type,
  // producing the difference of its operands; the left operand is the minuend and the right
  // operand is the subtrahend. Given numeric operands a and b, it is always the case that
  // a-b produces the same result as a+(-b).
  if (subtract) {
    bnum = -bnum;
  }

  return _index.IntegralValue.createFromNumberValue(realm, anum + bnum);
}

// ECMA262 12.10.4
function InstanceofOperator(realm, O, C) {
  // 1. If Type(C) is not Object, throw a TypeError exception.
  if (!C.mightBeObject()) {
    throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "Expecting a function in instanceof check");
  }

  // 2. Let instOfHandler be ? GetMethod(C, @@hasInstance).
  let instOfHandler = (0, _get.GetMethod)(realm, C, realm.intrinsics.SymbolHasInstance);

  // 3. If instOfHandler is not undefined, then
  if (!(instOfHandler instanceof _index.UndefinedValue)) {
    // a. Return ToBoolean(? Call(instOfHandler, C, « O »)).
    return _singletons.To.ToBooleanPartial(realm, (0, _call.Call)(realm, instOfHandler, C, [O]));
  }

  // 4. If IsCallable(C) is false, throw a TypeError exception.
  if ((0, _is.IsCallable)(realm, C) === false) {
    throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "Expecting a function in instanceof check");
  }

  // 5. Return ? OrdinaryHasInstance(C, O).
  return OrdinaryHasInstance(realm, C, O);
}

// ECMA262 7.3.19
function OrdinaryHasInstance(realm, C, O) {
  // 1. If IsCallable(C) is false, return false.
  if ((0, _is.IsCallable)(realm, C) === false) return false;
  (0, _invariant2.default)(C instanceof _index.ObjectValue);

  // 2. If C has a [[BoundTargetFunction]] internal slot, then
  if (C instanceof _index.BoundFunctionValue) {
    // a. Let BC be the value of C's [[BoundTargetFunction]] internal slot.
    let BC = C.$BoundTargetFunction;

    // b. Return ? InstanceofOperator(O, BC).
    return InstanceofOperator(realm, O, BC);
  }

  // 3. If Type(O) is not Object, return false.
  O = O.throwIfNotConcrete();
  if (!(O instanceof _index.ObjectValue)) return false;

  // 4. Let P be ? Get(C, "prototype").
  let P = (0, _get.Get)(realm, C, "prototype").throwIfNotConcrete();

  // 5. If Type(P) is not Object, throw a TypeError exception.
  if (!(P instanceof _index.ObjectValue)) {
    throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "Type(P) is not Object");
  }

  // 6. Repeat
  while (true) {
    // a. Let O be ? O.[[GetPrototypeOf]]().
    O = O.$GetPrototypeOf();

    // b. If O is null, return false.
    if (O instanceof _index.NullValue) return false;

    // c. If SameValue(P, O) is true, return true.
    if (SameValue(realm, P, O) === true) return true;
  }

  return false;
}

//
function Type(realm, val) {
  if (val instanceof _index.UndefinedValue) {
    return "Undefined";
  } else if (val instanceof _index.NullValue) {
    return "Null";
  } else if ((0, _has.HasCompatibleType)(val, _index.BooleanValue)) {
    return "Boolean";
  } else if ((0, _has.HasCompatibleType)(val, _index.StringValue)) {
    return "String";
  } else if ((0, _has.HasCompatibleType)(val, _index.SymbolValue)) {
    return "Symbol";
  } else if ((0, _has.HasCompatibleType)(val, _index.IntegralValue)) {
    return "Number";
  } else if ((0, _has.HasCompatibleType)(val, _index.NumberValue)) {
    return "Number";
  } else if (!val.mightNotBeObject()) {
    return "Object";
  } else {
    (0, _invariant2.default)(val instanceof _index.AbstractValue);
    _index.AbstractValue.reportIntrospectionError(val);
    throw new _errors.FatalError();
  }
}

// ECMA262 19.4.3.2.1
function SymbolDescriptiveString(realm, sym) {
  // 1. Assert: Type(sym) is Symbol.
  (0, _invariant2.default)(sym instanceof _index.SymbolValue, "expected symbol");

  // 2. Let desc be sym's [[Description]] value.
  let desc = sym.$Description;

  // 3. If desc is undefined, let desc be the empty string.
  if (!desc) desc = "";else desc = desc.throwIfNotConcreteString().value;

  // 4. Assert: Type(desc) is String.
  (0, _invariant2.default)(typeof desc === "string", "expected string");

  // 5. Return the result of concatenating the strings "Symbol(", desc, and ")".
  return `Symbol(${desc})`;
}

// ECMA262 6.2.2.5
function UpdateEmpty(realm, completionRecord, value) {
  // 1. Assert: If completionRecord.[[Type]] is either return or throw, then completionRecord.[[Value]] is not empty.
  if (completionRecord instanceof _completions.ReturnCompletion || completionRecord instanceof _completions.ThrowCompletion) {
    (0, _invariant2.default)(completionRecord.value, "expected completion record to have a value");
  }

  // 2. If completionRecord.[[Value]] is not empty, return Completion(completionRecord).
  if (completionRecord instanceof _index.EmptyValue) return value;
  if (completionRecord instanceof _index.Value || completionRecord.value && !(completionRecord.value instanceof _index.EmptyValue)) return completionRecord;

  // 3. Return Completion{[[Type]]: completionRecord.[[Type]], [[Value]]: value, [[Target]]: completionRecord.[[Target]] }.'
  completionRecord.value = value;
  return completionRecord;
}

/***/ }),
/* 20 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ArgumentListEvaluation = ArgumentListEvaluation;
exports.Invoke = Invoke;
exports.EvaluateCall = EvaluateCall;
exports.PrepareForOrdinaryCall = PrepareForOrdinaryCall;
exports.OrdinaryCallBindThis = OrdinaryCallBindThis;
exports.OrdinaryCallEvaluateBody = OrdinaryCallEvaluateBody;
exports.EvaluateDirectCall = EvaluateDirectCall;
exports.EvaluateDirectCallWithArgList = EvaluateDirectCallWithArgList;
exports.PrepareForTailCall = PrepareForTailCall;
exports.Call = Call;

var _environment = __webpack_require__(8);

var _errors = __webpack_require__(6);

var _realm = __webpack_require__(7);

var _Value = __webpack_require__(300);

var _Value2 = _interopRequireDefault(_Value);

var _index = __webpack_require__(0);

var _index2 = __webpack_require__(5);

var _generator = __webpack_require__(357);

var _completions = __webpack_require__(3);

var _get = __webpack_require__(11);

var _singletons = __webpack_require__(2);

var _invariant = __webpack_require__(1);

var _invariant2 = _interopRequireDefault(_invariant);

var _babelTypes = __webpack_require__(4);

var t = _interopRequireWildcard(_babelTypes);

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// ECMA262 12.3.6.1
function ArgumentListEvaluation(realm, strictCode, env, argNodes) {
  if (Array.isArray(argNodes)) {
    let args = [];
    for (let node_ of argNodes) {
      if (node_.type === "SpreadElement") {
        let node = node_;
        // 1. Let list be a new empty List.
        let list = args;

        // 2. Let spreadRef be the result of evaluating AssignmentExpression.
        let spreadRef = env.evaluate(node.argument, strictCode);

        // 3. Let spreadObj be ? GetValue(spreadRef).
        let spreadObj = _singletons.Environment.GetValue(realm, spreadRef);

        // 4. Let iterator be ? GetIterator(spreadObj).
        let iterator = (0, _index2.GetIterator)(realm, spreadObj);

        // 5. Repeat
        while (true) {
          // a. Let next be ? IteratorStep(iterator).
          let next = (0, _index2.IteratorStep)(realm, iterator);

          // b. If next is false, return list.
          if (!next) {
            break;
          }

          // c. Let nextArg be ? IteratorValue(next).
          let nextArg = (0, _index2.IteratorValue)(realm, next);

          // d. Append nextArg as the last element of list.
          list.push(nextArg);
        }
      } else {
        let ref = env.evaluate(node_, strictCode);
        let expr = _singletons.Environment.GetValue(realm, ref);
        args.push(expr);
      }
    }
    return args;
  } else {
    let node = argNodes;
    if (node.expressions.length === 0) {
      // 1. Let templateLiteral be this TemplateLiteral.
      let templateLiteral = node;

      // 2. Let siteObj be GetTemplateObject(templateLiteral).
      let siteObj = (0, _get.GetTemplateObject)(realm, templateLiteral);

      // 3. Return a List containing the one element which is siteObj.
      return [siteObj];
    } else {
      // 1. Let templateLiteral be this TemplateLiteral.
      let templateLiteral = node;

      // 2. Let siteObj be GetTemplateObject(templateLiteral).
      let siteObj = (0, _get.GetTemplateObject)(realm, templateLiteral);

      // 3. Let firstSubRef be the result of evaluating Expression.
      let firstSubRef = env.evaluate(node.expressions[0], strictCode);

      // 4. Let firstSub be ? GetValue(firstSubRef).
      let firstSub = _singletons.Environment.GetValue(realm, firstSubRef);

      // 5. Let restSub be SubstitutionEvaluation of TemplateSpans.
      let restSub = node.expressions.slice(1, node.expressions.length).map(expr => {
        return _singletons.Environment.GetValue(realm, env.evaluate(expr, strictCode));
      });

      // 6. ReturnIfAbrupt(restSub).

      // 7. Assert: restSub is a List.
      (0, _invariant2.default)(restSub.constructor === Array, "restSub is a List");

      // 8. Return a List whose first element is siteObj, whose second elements is firstSub, and whose subsequent elements are the elements of restSub, in order. restSub may contain no elements.
      return [siteObj, firstSub, ...restSub];
    }
  }
}

// ECMA262 7.3.18
/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 */

function Invoke(realm, V, P, argumentsList) {
  // 1. Assert: IsPropertyKey(P) is true.
  (0, _invariant2.default)((0, _index2.IsPropertyKey)(realm, P), "expected property key");

  // 2. If argumentsList was not passed, let argumentsList be a new empty List.
  if (!argumentsList) argumentsList = [];

  // 3. Let func be ? GetV(V, P).
  let func = (0, _get.GetV)(realm, V, P);

  // 4. Return ? Call(func, V, argumentsList).
  return Call(realm, func, V, argumentsList);
}

// ECMA262 12.3.4.2
function EvaluateCall(realm, strictCode, env, ref, args) {
  let thisValue;

  // 1. Let func be ? GetValue(ref).
  let func = _singletons.Environment.GetValue(realm, ref);

  // 2. If Type(ref) is Reference, then
  if (ref instanceof _environment.Reference) {
    // a. If IsPropertyReference(ref) is true, then
    if (_singletons.Environment.IsPropertyReference(realm, ref)) {
      // i. Let thisValue be GetThisValue(ref).
      thisValue = (0, _get.GetThisValue)(realm, ref);
    } else {
      // b. Else, the base of ref is an Environment Record
      // i. Let refEnv be GetBase(ref).
      let refEnv = _singletons.Environment.GetBase(realm, ref);
      (0, _invariant2.default)(refEnv instanceof _environment.EnvironmentRecord);

      // ii. Let thisValue be refEnv.WithBaseObject().
      thisValue = refEnv.WithBaseObject();
    }
  } else {
    // 3. Else Type(ref) is not Reference,
    // a. Let thisValue be undefined.
    thisValue = realm.intrinsics.undefined;
  }

  // 4. Return ? EvaluateDirectCall(func, thisValue, arguments, tailPosition).
  return EvaluateDirectCall(realm, strictCode, env, ref, func, thisValue, args);
}

// ECMA262 9.2.1.1
function PrepareForOrdinaryCall(realm, F, newTarget) {
  // 1. Assert: Type(newTarget) is Undefined or Object.
  (0, _invariant2.default)(newTarget === undefined || newTarget instanceof _index.ObjectValue, "expected undefined or object value for new target");

  // 2. Let callerContext be the running execution context.
  let callerContext = realm.getRunningContext();

  // 3. Let calleeContext be a new ECMAScript code execution context.
  let calleeContext = realm.createExecutionContext();

  // 4. Set the Function of calleeContext to F.
  calleeContext.setFunction(F);
  calleeContext.setCaller(realm.getRunningContext());

  // 5. Let calleeRealm be the value of F's [[Realm]] internal slot.
  let calleeRealm = realm;

  // 6. Set the Realm of calleeContext to calleeRealm.
  calleeContext.realm = calleeRealm;

  // 7. Set the ScriptOrModule of calleeContext to the value of F's [[ScriptOrModule]] internal slot.
  calleeContext.ScriptOrModule = F.$ScriptOrModule;

  // 8. Let localEnv be NewFunctionEnvironment(F, newTarget).
  let localEnv = _singletons.Environment.NewFunctionEnvironment(realm, F, newTarget);

  // 9. Set the LexicalEnvironment of calleeContext to localEnv.
  calleeContext.lexicalEnvironment = localEnv;

  // 10. Set the VariableEnvironment of calleeContext to localEnv.
  calleeContext.variableEnvironment = localEnv;

  // 11. If callerContext is not already suspended, suspend callerContext.
  callerContext.suspend();

  // 12. Push calleeContext onto the execution context stack; calleeContext is now the running execution context.
  realm.pushContext(calleeContext);

  // 13. NOTE Any exception objects produced after this point are associated with calleeRealm.

  // 14. Return calleeContext.
  return calleeContext;
}

// ECMA262 9.2.1.2
function OrdinaryCallBindThis(realm, F, calleeContext, thisArgument) {
  // 1. Let thisMode be the value of F's [[ThisMode]] internal slot.
  let thisMode = F.$ThisMode;

  // 2. If thisMode is lexical, return NormalCompletion(undefined).
  if (thisMode === "lexical") return realm.intrinsics.undefined;

  // 3. Let calleeRealm be the value of F's [[Realm]] internal slot.
  let calleeRealm = F.$Realm;

  // 4. Let localEnv be the LexicalEnvironment of calleeContext.
  let localEnv = calleeContext.lexicalEnvironment;

  let thisValue;
  // 5. If thisMode is strict, let thisValue be thisArgument.
  if (thisMode === "strict") {
    thisValue = thisArgument;
  } else {
    // 6. Else,
    // a. If thisArgument is null or undefined, then
    if ((0, _index2.HasSomeCompatibleType)(thisArgument, _index.NullValue, _index.UndefinedValue)) {
      // i. Let globalEnv be calleeRealm.[[GlobalEnv]].
      let globalEnv = realm.$GlobalEnv;

      // ii. Let globalEnvRec be globalEnv's EnvironmentRecord.
      let globalEnvRec = globalEnv.environmentRecord;
      (0, _invariant2.default)(globalEnvRec instanceof _environment.GlobalEnvironmentRecord);

      // iii. Let thisValue be globalEnvRec.[[GlobalThisValue]].
      thisValue = globalEnvRec.$GlobalThisValue;
    } else {
      //  b. Else,
      // i. Let thisValue be ! ToObject(thisArgument).
      thisValue = _singletons.To.ToObjectPartial(calleeRealm, thisArgument);

      // ii. NOTE ToObject produces wrapper objects using calleeRealm.
    }
  }

  // 7. Let envRec be localEnv's EnvironmentRecord.
  (0, _invariant2.default)(localEnv !== undefined);
  let envRec = localEnv.environmentRecord;

  // 8. Assert: The next step never returns an abrupt completion because envRec.[[ThisBindingStatus]] is not "initialized".

  // 9. Return envRec.BindThisValue(thisValue).
  return envRec.BindThisValue(thisValue);
}

// ECMA262 9.2.1.3
function OrdinaryCallEvaluateBody(realm, f, argumentsList) {
  if (f instanceof _index.NativeFunctionValue) {
    let env = realm.getRunningContext().lexicalEnvironment;
    try {
      return f.callCallback(env.environmentRecord.GetThisBinding(), argumentsList, env.environmentRecord.$NewTarget);
    } catch (err) {
      if (err instanceof _completions.AbruptCompletion) {
        return err;
      } else if (err instanceof Error) {
        throw err;
      } else {
        throw new _errors.FatalError(err);
      }
    }
  } else {
    (0, _invariant2.default)(f instanceof _index.ECMAScriptSourceFunctionValue);
    let F = f;
    if (F.$FunctionKind === "generator") {
      // 1. Perform ? FunctionDeclarationInstantiation(functionObject, argumentsList).
      _singletons.Functions.FunctionDeclarationInstantiation(realm, F, argumentsList);

      // 2. Let G be ? OrdinaryCreateFromConstructor(functionObject, "%GeneratorPrototype%", « [[GeneratorState]], [[GeneratorContext]] »).
      let G = _singletons.Create.OrdinaryCreateFromConstructor(realm, F, "GeneratorPrototype", {
        $GeneratorState: undefined,
        $GeneratorContext: undefined
      });

      // 3. Perform GeneratorStart(G, FunctionBody).
      let code = F.$ECMAScriptCode;
      (0, _invariant2.default)(code !== undefined);
      (0, _generator.GeneratorStart)(realm, G, code);

      // 4. Return Completion{[[Type]]: return, [[Value]]: G, [[Target]]: empty}.
      return new _completions.ReturnCompletion(G, realm.currentLocation);
    } else {
      if (!realm.useAbstractInterpretation || realm.pathConditions.length === 0) return normalCall();
      let savedIsSelfRecursive = F.isSelfRecursive;
      try {
        F.isSelfRecursive = false;
        let effects = realm.evaluateForEffects(guardedCall);
        if (F.isSelfRecursive) {
          _index.AbstractValue.reportIntrospectionError(F, "call to function that calls itself");
          throw new _errors.FatalError();
          //todo: need to emit a specialized function that temporally captures the heap state at this point
        } else {
          realm.applyEffects(effects);
          let c = effects[0];
          return processResult(() => {
            (0, _invariant2.default)(c instanceof _Value2.default || c instanceof _completions.AbruptCompletion);
            return c;
          });
        }
      } finally {
        F.isSelfRecursive = savedIsSelfRecursive;
      }

      function guardedCall() {
        let currentLocation = realm.currentLocation;
        if (F.activeArguments !== undefined && F.activeArguments.has(currentLocation)) {
          let [previousPathLength, previousArguments] = F.activeArguments.get(currentLocation);
          if (realm.pathConditions.length > previousPathLength) {
            (0, _invariant2.default)(previousArguments !== undefined);
            // F is being called recursively while a call to it is still active
            F.isSelfRecursive = true;
            let widenedArgumentsList = _singletons.Widen.widenValues(realm, previousArguments, argumentsList);
            if (_singletons.Widen.containsArraysOfValue(realm, previousArguments, widenedArgumentsList)) {
              // Reached a fixed point. Executing this call will not add any knowledge
              // about the effects of the original call.
              return _index.AbstractValue.createFromType(realm, _Value2.default, "widened return result");
            } else {
              argumentsList = widenedArgumentsList;
            }
          }
        }
        try {
          if (F.activeArguments === undefined) F.activeArguments = new Map();
          F.activeArguments.set(currentLocation, [realm.pathConditions.length, argumentsList]);
          return normalCall();
        } finally {
          F.activeArguments.delete(currentLocation);
        }
      }

      function normalCall() {
        // 1. Perform ? FunctionDeclarationInstantiation(F, argumentsList).
        _singletons.Functions.FunctionDeclarationInstantiation(realm, F, argumentsList);

        // 2. Return the result of EvaluateBody of the parsed code that is the value of F's
        //    [[ECMAScriptCode]] internal slot passing F as the argument.
        let code = F.$ECMAScriptCode;
        (0, _invariant2.default)(code !== undefined);
        let context = realm.getRunningContext();
        return processResult(() => context.lexicalEnvironment.evaluateCompletionDeref(code, F.$Strict));
      }

      function processResult(getCompletion) {
        let priorSavedCompletion = realm.savedCompletion;
        try {
          realm.savedCompletion = undefined;
          let c = getCompletion();
          // We are about the leave this function and this presents a join point where all non exeptional control flows
          // converge into a single flow using the joined effects as the new state.
          c = _singletons.Functions.incorporateSavedCompletion(realm, c);
          let joinedEffects;
          if (c instanceof _completions.PossiblyNormalCompletion) {
            let e = realm.getCapturedEffects(c);
            if (e !== undefined) {
              // There were earlier, conditional exits from the function
              // We join together the current effects with the effects of any earlier returns that are tracked in c.
              realm.stopEffectCaptureAndUndoEffects(c);
            } else {
              e = (0, _realm.construct_empty_effects)(realm);
            }
            joinedEffects = _singletons.Join.joinEffectsAndPromoteNestedReturnCompletions(realm, c, e);
          } else if (c instanceof _completions.JoinedAbruptCompletions) {
            joinedEffects = _singletons.Join.joinEffectsAndPromoteNestedReturnCompletions(realm, c, (0, _realm.construct_empty_effects)(realm));
          }
          if (joinedEffects !== undefined) {
            let result = joinedEffects[0];
            if (result instanceof _completions.ReturnCompletion) {
              realm.applyEffects(joinedEffects);
              return result;
            }
            (0, _invariant2.default)(result instanceof _completions.JoinedAbruptCompletions);
            if (!(result.consequent instanceof _completions.ReturnCompletion || result.alternate instanceof _completions.ReturnCompletion)) {
              realm.applyEffects(joinedEffects);
              throw result;
            }
            // There is a normal return exit, but also one or more throw completions.
            // The throw completions must be extracted into a saved possibly normal completion
            // so that the caller can pick them up in its next completion.
            joinedEffects = extractAndSavePossiblyNormalCompletion(result);
            result = joinedEffects[0];
            (0, _invariant2.default)(result instanceof _completions.ReturnCompletion);
            realm.applyEffects(joinedEffects);
            return result;
          } else {
            (0, _invariant2.default)(c instanceof _Value2.default || c instanceof _completions.AbruptCompletion);
            return c;
          }
        } finally {
          realm.incorporatePriorSavedCompletion(priorSavedCompletion);
        }
      }
    }
  }

  function extractAndSavePossiblyNormalCompletion(c) {
    // There are throw completions that conditionally escape from the the call.
    // We need to carry on in normal mode (after arranging to capturing effects)
    // while stashing away the throw completions so that the next completion we return
    let [joinedEffects, possiblyNormalCompletion] = _singletons.Join.unbundleReturnCompletion(realm, c);
    realm.composeWithSavedCompletion(possiblyNormalCompletion);
    return joinedEffects;
  }
}

// ECMA262 12.3.4.3
function EvaluateDirectCall(realm, strictCode, env, ref, func, thisValue, args, tailPosition) {
  // 1. Let argList be ? ArgumentListEvaluation(arguments).
  let argList = ArgumentListEvaluation(realm, strictCode, env, args);

  return EvaluateDirectCallWithArgList(realm, strictCode, env, ref, func, thisValue, argList, tailPosition);
}

function EvaluateDirectCallWithArgList(realm, strictCode, env, ref, func, thisValue, argList, tailPosition) {
  if (func instanceof _index.AbstractObjectValue && _Value2.default.isTypeCompatibleWith(func.getType(), _index.FunctionValue)) {
    return _index.AbstractValue.createTemporalFromBuildFunction(realm, func.functionResultType || _Value2.default, [func].concat(argList), nodes => {
      let fun_args = nodes.slice(1);
      return t.callExpression(nodes[0], fun_args);
    });
  }
  func = func.throwIfNotConcrete();

  // 2. If Type(func) is not Object, throw a TypeError exception.
  if (!(func instanceof _index.ObjectValue)) {
    throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "not an object");
  }

  // 3. If IsCallable(func) is false, throw a TypeError exception.
  if (!(0, _index2.IsCallable)(realm, func)) {
    throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "not callable");
  }

  // 4. If tailPosition is true, perform PrepareForTailCall().
  if (tailPosition === true) PrepareForTailCall(realm);

  // 5. Let result be Call(func, thisValue, argList).
  let result = Call(realm, func, thisValue, argList);

  // 6. Assert: If tailPosition is true, the above call will not return here, but instead
  //    evaluation will continue as if the following return has already occurred.

  // 7. Assert: If result is not an abrupt completion, then Type(result) is an ECMAScript language type.
  (0, _invariant2.default)(result instanceof _Value2.default, "expected language value type");

  // 8. Return result.
  return result;
}

// ECMA262 14.6.3
function PrepareForTailCall(realm) {
  // 1. Let leafContext be the running execution context.
  let leafContext = realm.getRunningContext();

  // 2. Suspend leafContext.
  leafContext.suspend();

  // 3. Pop leafContext from the execution context stack. The execution context now on the
  //    top of the stack becomes the running execution context.
  realm.onDestroyScope(leafContext.lexicalEnvironment);
  realm.popContext(leafContext);

  // TODO #1008 4. Assert: leafContext has no further use. It will never be activated as the running execution context.
}

// ECMA262 7.3.12
function Call(realm, F, V, argsList) {
  // 1. If argumentsList was not passed, let argumentsList be a new empty List.
  argsList = argsList || [];

  // 2. If IsCallable(F) is false, throw a TypeError exception.
  if ((0, _index2.IsCallable)(realm, F) === false) {
    throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "not callable");
  }
  if (F instanceof _index.AbstractValue && _Value2.default.isTypeCompatibleWith(F.getType(), _index.FunctionValue)) {
    _singletons.Havoc.value(realm, V);
    for (let arg of argsList) {
      _singletons.Havoc.value(realm, arg);
    }
    if (V === realm.intrinsics.undefined) {
      let fullArgs = [F].concat(argsList);
      return _index.AbstractValue.createTemporalFromBuildFunction(realm, _Value2.default, fullArgs, nodes => {
        let fun_args = nodes.slice(1);
        return t.callExpression(nodes[0], fun_args);
      });
    } else {
      let fullArgs = [F, V].concat(argsList);
      return _index.AbstractValue.createTemporalFromBuildFunction(realm, _Value2.default, fullArgs, nodes => {
        let fun_args = nodes.slice(1);
        return t.callExpression(t.memberExpression(nodes[0], t.identifier("call")), fun_args);
      });
    }
  }
  (0, _invariant2.default)(F instanceof _index.ObjectValue);

  // 3. Return ? F.[[Call]](V, argumentsList).
  (0, _invariant2.default)(F.$Call, "no call method on this value");
  return F.$Call(V, argsList);
}

/***/ }),
/* 21 */
/***/ (function(module, exports) {

var g;

// This works in non-strict mode
g = (function() {
	return this;
})();

try {
	// This works if eval is allowed (see CSP)
	g = g || Function("return this")() || (1,eval)("this");
} catch(e) {
	// This works if the window reference is available
	if(typeof window === "object")
		g = window;
}

// g can still be undefined, but nothing to do about it...
// We return undefined, instead of nothing here, so it's
// easier to handle this case. if(!global) { ...}

module.exports = g;


/***/ }),
/* 22 */
/***/ (function(module, exports) {

var Ap = Array.prototype;
var slice = Ap.slice;
var map = Ap.map;
var each = Ap.forEach;
var Op = Object.prototype;
var objToStr = Op.toString;
var funObjStr = objToStr.call(function(){});
var strObjStr = objToStr.call("");
var hasOwn = Op.hasOwnProperty;

module.exports = function () {

    var exports = {};

    // A type is an object with a .check method that takes a value and returns
    // true or false according to whether the value matches the type.

    function Type(check, name) {
        var self = this;
        if (!(self instanceof Type)) {
            throw new Error("Type constructor cannot be invoked without 'new'");
        }

        // Unfortunately we can't elegantly reuse isFunction and isString,
        // here, because this code is executed while defining those types.
        if (objToStr.call(check) !== funObjStr) {
            throw new Error(check + " is not a function");
        }

        // The `name` parameter can be either a function or a string.
        var nameObjStr = objToStr.call(name);
        if (!(nameObjStr === funObjStr ||
          nameObjStr === strObjStr)) {
            throw new Error(name + " is neither a function nor a string");
        }

        Object.defineProperties(self, {
            name: {value: name},
            check: {
                value: function (value, deep) {
                    var result = check.call(self, value, deep);
                    if (!result && deep && objToStr.call(deep) === funObjStr)
                        deep(self, value);
                    return result;
                }
            }
        });
    }

    var Tp = Type.prototype;

    // Throughout this file we use Object.defineProperty to prevent
    // redefinition of exported properties.
    exports.Type = Type;

    // Like .check, except that failure triggers an AssertionError.
    Tp.assert = function (value, deep) {
        if (!this.check(value, deep)) {
            var str = shallowStringify(value);
            throw new Error(str + " does not match type " + this);
        }
        return true;
    };

    function shallowStringify(value) {
        if (isObject.check(value))
            return "{" + Object.keys(value).map(function (key) {
                  return key + ": " + value[key];
              }).join(", ") + "}";

        if (isArray.check(value))
            return "[" + value.map(shallowStringify).join(", ") + "]";

        return JSON.stringify(value);
    }

    Tp.toString = function () {
        var name = this.name;

        if (isString.check(name))
            return name;

        if (isFunction.check(name))
            return name.call(this) + "";

        return name + " type";
    };

    var builtInCtorFns = [];
    var builtInCtorTypes = [];
    var builtInTypes = {};
    exports.builtInTypes = builtInTypes;

    function defBuiltInType(example, name) {
        var objStr = objToStr.call(example);

        var type = new Type(function (value) {
            return objToStr.call(value) === objStr;
        }, name);

        builtInTypes[name] = type;

        if (example && typeof example.constructor === "function") {
            builtInCtorFns.push(example.constructor);
            builtInCtorTypes.push(type);
        }

        return type;
    }

    // These types check the underlying [[Class]] attribute of the given
    // value, rather than using the problematic typeof operator. Note however
    // that no subtyping is considered; so, for instance, isObject.check
    // returns false for [], /./, new Date, and null.
    var isString = defBuiltInType("truthy", "string");
    var isFunction = defBuiltInType(function () {}, "function");
    var isArray = defBuiltInType([], "array");
    var isObject = defBuiltInType({}, "object");
    var isRegExp = defBuiltInType(/./, "RegExp");
    var isDate = defBuiltInType(new Date, "Date");
    var isNumber = defBuiltInType(3, "number");
    var isBoolean = defBuiltInType(true, "boolean");
    var isNull = defBuiltInType(null, "null");
    var isUndefined = defBuiltInType(void 0, "undefined");

    // There are a number of idiomatic ways of expressing types, so this
    // function serves to coerce them all to actual Type objects. Note that
    // providing the name argument is not necessary in most cases.
    function toType(from, name) {
        // The toType function should of course be idempotent.
        if (from instanceof Type)
            return from;

        // The Def type is used as a helper for constructing compound
        // interface types for AST nodes.
        if (from instanceof Def)
            return from.type;

        // Support [ElemType] syntax.
        if (isArray.check(from))
            return Type.fromArray(from);

        // Support { someField: FieldType, ... } syntax.
        if (isObject.check(from))
            return Type.fromObject(from);

        if (isFunction.check(from)) {
            var bicfIndex = builtInCtorFns.indexOf(from);
            if (bicfIndex >= 0) {
                return builtInCtorTypes[bicfIndex];
            }

            // If isFunction.check(from), and from is not a built-in
            // constructor, assume from is a binary predicate function we can
            // use to define the type.
            return new Type(from, name);
        }

        // As a last resort, toType returns a type that matches any value that
        // is === from. This is primarily useful for literal values like
        // toType(null), but it has the additional advantage of allowing
        // toType to be a total function.
        return new Type(function (value) {
            return value === from;
        }, isUndefined.check(name) ? function () {
            return from + "";
        } : name);
    }

    // Returns a type that matches the given value iff any of type1, type2,
    // etc. match the value.
    Type.or = function (/* type1, type2, ... */) {
        var types = [];
        var len = arguments.length;
        for (var i = 0; i < len; ++i)
            types.push(toType(arguments[i]));

        return new Type(function (value, deep) {
            for (var i = 0; i < len; ++i)
                if (types[i].check(value, deep))
                    return true;
            return false;
        }, function () {
            return types.join(" | ");
        });
    };

    Type.fromArray = function (arr) {
        if (!isArray.check(arr)) {
            throw new Error("");
        }
        if (arr.length !== 1) {
            throw new Error("only one element type is permitted for typed arrays");
        }
        return toType(arr[0]).arrayOf();
    };

    Tp.arrayOf = function () {
        var elemType = this;
        return new Type(function (value, deep) {
            return isArray.check(value) && value.every(function (elem) {
                  return elemType.check(elem, deep);
              });
        }, function () {
            return "[" + elemType + "]";
        });
    };

    Type.fromObject = function (obj) {
        var fields = Object.keys(obj).map(function (name) {
            return new Field(name, obj[name]);
        });

        return new Type(function (value, deep) {
            return isObject.check(value) && fields.every(function (field) {
                  return field.type.check(value[field.name], deep);
              });
        }, function () {
            return "{ " + fields.join(", ") + " }";
        });
    };

    function Field(name, type, defaultFn, hidden) {
        var self = this;

        if (!(self instanceof Field)) {
            throw new Error("Field constructor cannot be invoked without 'new'");
        }
        isString.assert(name);

        type = toType(type);

        var properties = {
            name: {value: name},
            type: {value: type},
            hidden: {value: !!hidden}
        };

        if (isFunction.check(defaultFn)) {
            properties.defaultFn = {value: defaultFn};
        }

        Object.defineProperties(self, properties);
    }

    var Fp = Field.prototype;

    Fp.toString = function () {
        return JSON.stringify(this.name) + ": " + this.type;
    };

    Fp.getValue = function (obj) {
        var value = obj[this.name];

        if (!isUndefined.check(value))
            return value;

        if (this.defaultFn)
            value = this.defaultFn.call(obj);

        return value;
    };

    // Define a type whose name is registered in a namespace (the defCache) so
    // that future definitions will return the same type given the same name.
    // In particular, this system allows for circular and forward definitions.
    // The Def object d returned from Type.def may be used to configure the
    // type d.type by calling methods such as d.bases, d.build, and d.field.
    Type.def = function (typeName) {
        isString.assert(typeName);
        return hasOwn.call(defCache, typeName)
          ? defCache[typeName]
          : defCache[typeName] = new Def(typeName);
    };

    // In order to return the same Def instance every time Type.def is called
    // with a particular name, those instances need to be stored in a cache.
    var defCache = Object.create(null);

    function Def(typeName) {
        var self = this;
        if (!(self instanceof Def)) {
            throw new Error("Def constructor cannot be invoked without 'new'");
        }

        Object.defineProperties(self, {
            typeName: {value: typeName},
            baseNames: {value: []},
            ownFields: {value: Object.create(null)},

            // These two are populated during finalization.
            allSupertypes: {value: Object.create(null)}, // Includes own typeName.
            supertypeList: {value: []}, // Linear inheritance hierarchy.
            allFields: {value: Object.create(null)}, // Includes inherited fields.
            fieldNames: {value: []}, // Non-hidden keys of allFields.

            type: {
                value: new Type(function (value, deep) {
                    return self.check(value, deep);
                }, typeName)
            }
        });
    }

    Def.fromValue = function (value) {
        if (value && typeof value === "object") {
            var type = value.type;
            if (typeof type === "string" &&
              hasOwn.call(defCache, type)) {
                var d = defCache[type];
                if (d.finalized) {
                    return d;
                }
            }
        }

        return null;
    };

    var Dp = Def.prototype;

    Dp.isSupertypeOf = function (that) {
        if (that instanceof Def) {
            if (this.finalized !== true ||
              that.finalized !== true) {
                throw new Error("");
            }
            return hasOwn.call(that.allSupertypes, this.typeName);
        } else {
            throw new Error(that + " is not a Def");
        }
    };

    // Note that the list returned by this function is a copy of the internal
    // supertypeList, *without* the typeName itself as the first element.
    exports.getSupertypeNames = function (typeName) {
        if (!hasOwn.call(defCache, typeName)) {
            throw new Error("");
        }
        var d = defCache[typeName];
        if (d.finalized !== true) {
            throw new Error("");
        }
        return d.supertypeList.slice(1);
    };

    // Returns an object mapping from every known type in the defCache to the
    // most specific supertype whose name is an own property of the candidates
    // object.
    exports.computeSupertypeLookupTable = function (candidates) {
        var table = {};
        var typeNames = Object.keys(defCache);
        var typeNameCount = typeNames.length;

        for (var i = 0; i < typeNameCount; ++i) {
            var typeName = typeNames[i];
            var d = defCache[typeName];
            if (d.finalized !== true) {
                throw new Error("" + typeName);
            }
            for (var j = 0; j < d.supertypeList.length; ++j) {
                var superTypeName = d.supertypeList[j];
                if (hasOwn.call(candidates, superTypeName)) {
                    table[typeName] = superTypeName;
                    break;
                }
            }
        }

        return table;
    };

    Dp.checkAllFields = function (value, deep) {
        var allFields = this.allFields;
        if (this.finalized !== true) {
            throw new Error("" + this.typeName);
        }

        function checkFieldByName(name) {
            var field = allFields[name];
            var type = field.type;
            var child = field.getValue(value);
            return type.check(child, deep);
        }

        return isObject.check(value)
          && Object.keys(allFields).every(checkFieldByName);
    };

    Dp.check = function (value, deep) {
        if (this.finalized !== true) {
            throw new Error(
              "prematurely checking unfinalized type " + this.typeName
            );
        }

        // A Def type can only match an object value.
        if (!isObject.check(value))
            return false;

        var vDef = Def.fromValue(value);
        if (!vDef) {
            // If we couldn't infer the Def associated with the given value,
            // and we expected it to be a SourceLocation or a Position, it was
            // probably just missing a "type" field (because Esprima does not
            // assign a type property to such nodes). Be optimistic and let
            // this.checkAllFields make the final decision.
            if (this.typeName === "SourceLocation" ||
              this.typeName === "Position") {
                return this.checkAllFields(value, deep);
            }

            // Calling this.checkAllFields for any other type of node is both
            // bad for performance and way too forgiving.
            return false;
        }

        // If checking deeply and vDef === this, then we only need to call
        // checkAllFields once. Calling checkAllFields is too strict when deep
        // is false, because then we only care about this.isSupertypeOf(vDef).
        if (deep && vDef === this)
            return this.checkAllFields(value, deep);

        // In most cases we rely exclusively on isSupertypeOf to make O(1)
        // subtyping determinations. This suffices in most situations outside
        // of unit tests, since interface conformance is checked whenever new
        // instances are created using builder functions.
        if (!this.isSupertypeOf(vDef))
            return false;

        // The exception is when deep is true; then, we recursively check all
        // fields.
        if (!deep)
            return true;

        // Use the more specific Def (vDef) to perform the deep check, but
        // shallow-check fields defined by the less specific Def (this).
        return vDef.checkAllFields(value, deep)
          && this.checkAllFields(value, false);
    };

    Dp.bases = function () {
        var args = slice.call(arguments);
        var bases = this.baseNames;

        if (this.finalized) {
            if (args.length !== bases.length) {
                throw new Error("");
            }
            for (var i = 0; i < args.length; i++) {
                if (args[i] !== bases[i]) {
                    throw new Error("");
                }
            }
            return this;
        }

        args.forEach(function (baseName) {
            isString.assert(baseName);

            // This indexOf lookup may be O(n), but the typical number of base
            // names is very small, and indexOf is a native Array method.
            if (bases.indexOf(baseName) < 0)
                bases.push(baseName);
        });

        return this; // For chaining.
    };

    // False by default until .build(...) is called on an instance.
    Object.defineProperty(Dp, "buildable", {value: false});

    var builders = {};
    exports.builders = builders;

    // This object is used as prototype for any node created by a builder.
    var nodePrototype = {};

    // Call this function to define a new method to be shared by all AST
     // nodes. The replaced method (if any) is returned for easy wrapping.
    exports.defineMethod = function (name, func) {
        var old = nodePrototype[name];

        // Pass undefined as func to delete nodePrototype[name].
        if (isUndefined.check(func)) {
            delete nodePrototype[name];

        } else {
            isFunction.assert(func);

            Object.defineProperty(nodePrototype, name, {
                enumerable: true, // For discoverability.
                configurable: true, // For delete proto[name].
                value: func
            });
        }

        return old;
    };

    var isArrayOfString = isString.arrayOf();

    // Calling the .build method of a Def simultaneously marks the type as
    // buildable (by defining builders[getBuilderName(typeName)]) and
    // specifies the order of arguments that should be passed to the builder
    // function to create an instance of the type.
    Dp.build = function (/* param1, param2, ... */) {
        var self = this;

        var newBuildParams = slice.call(arguments);
        isArrayOfString.assert(newBuildParams);

        // Calling Def.prototype.build multiple times has the effect of merely
        // redefining this property.
        Object.defineProperty(self, "buildParams", {
            value: newBuildParams,
            writable: false,
            enumerable: false,
            configurable: true
        });

        if (self.buildable) {
            // If this Def is already buildable, update self.buildParams and
            // continue using the old builder function.
            return self;
        }

        // Every buildable type will have its "type" field filled in
        // automatically. This includes types that are not subtypes of Node,
        // like SourceLocation, but that seems harmless (TODO?).
        self.field("type", String, function () { return self.typeName });

        // Override Dp.buildable for this Def instance.
        Object.defineProperty(self, "buildable", {value: true});

        Object.defineProperty(builders, getBuilderName(self.typeName), {
            enumerable: true,

            value: function () {
                var args = arguments;
                var argc = args.length;
                var built = Object.create(nodePrototype);

                if (!self.finalized) {
                    throw new Error(
                      "attempting to instantiate unfinalized type " +
                      self.typeName
                    );
                }

                function add(param, i) {
                    if (hasOwn.call(built, param))
                        return;

                    var all = self.allFields;
                    if (!hasOwn.call(all, param)) {
                        throw new Error("" + param);
                    }

                    var field = all[param];
                    var type = field.type;
                    var value;

                    if (isNumber.check(i) && i < argc) {
                        value = args[i];
                    } else if (field.defaultFn) {
                        // Expose the partially-built object to the default
                        // function as its `this` object.
                        value = field.defaultFn.call(built);
                    } else {
                        var message = "no value or default function given for field " +
                          JSON.stringify(param) + " of " + self.typeName + "(" +
                          self.buildParams.map(function (name) {
                              return all[name];
                          }).join(", ") + ")";
                        throw new Error(message);
                    }

                    if (!type.check(value)) {
                        throw new Error(
                          shallowStringify(value) +
                          " does not match field " + field +
                          " of type " + self.typeName
                        );
                    }

                    // TODO Could attach getters and setters here to enforce
                    // dynamic type safety.
                    built[param] = value;
                }

                self.buildParams.forEach(function (param, i) {
                    add(param, i);
                });

                Object.keys(self.allFields).forEach(function (param) {
                    add(param); // Use the default value.
                });

                // Make sure that the "type" field was filled automatically.
                if (built.type !== self.typeName) {
                    throw new Error("");
                }

                return built;
            }
        });

        return self; // For chaining.
    };

    function getBuilderName(typeName) {
        return typeName.replace(/^[A-Z]+/, function (upperCasePrefix) {
            var len = upperCasePrefix.length;
            switch (len) {
                case 0: return "";
                // If there's only one initial capital letter, just lower-case it.
                case 1: return upperCasePrefix.toLowerCase();
                default:
                    // If there's more than one initial capital letter, lower-case
                    // all but the last one, so that XMLDefaultDeclaration (for
                    // example) becomes xmlDefaultDeclaration.
                    return upperCasePrefix.slice(
                        0, len - 1).toLowerCase() +
                      upperCasePrefix.charAt(len - 1);
            }
        });
    }
    exports.getBuilderName = getBuilderName;

    function getStatementBuilderName(typeName) {
        typeName = getBuilderName(typeName);
        return typeName.replace(/(Expression)?$/, "Statement");
    }
    exports.getStatementBuilderName = getStatementBuilderName;

    // The reason fields are specified using .field(...) instead of an object
    // literal syntax is somewhat subtle: the object literal syntax would
    // support only one key and one value, but with .field(...) we can pass
    // any number of arguments to specify the field.
    Dp.field = function (name, type, defaultFn, hidden) {
        if (this.finalized) {
            console.error("Ignoring attempt to redefine field " +
              JSON.stringify(name) + " of finalized type " +
              JSON.stringify(this.typeName));
            return this;
        }
        this.ownFields[name] = new Field(name, type, defaultFn, hidden);
        return this; // For chaining.
    };

    var namedTypes = {};
    exports.namedTypes = namedTypes;

    // Like Object.keys, but aware of what fields each AST type should have.
    function getFieldNames(object) {
        var d = Def.fromValue(object);
        if (d) {
            return d.fieldNames.slice(0);
        }

        if ("type" in object) {
            throw new Error(
              "did not recognize object of type " +
              JSON.stringify(object.type)
            );
        }

        return Object.keys(object);
    }
    exports.getFieldNames = getFieldNames;

    // Get the value of an object property, taking object.type and default
    // functions into account.
    function getFieldValue(object, fieldName) {
        var d = Def.fromValue(object);
        if (d) {
            var field = d.allFields[fieldName];
            if (field) {
                return field.getValue(object);
            }
        }

        return object && object[fieldName];
    }
    exports.getFieldValue = getFieldValue;

    // Iterate over all defined fields of an object, including those missing
    // or undefined, passing each field name and effective value (as returned
    // by getFieldValue) to the callback. If the object has no corresponding
    // Def, the callback will never be called.
    exports.eachField = function (object, callback, context) {
        getFieldNames(object).forEach(function (name) {
            callback.call(this, name, getFieldValue(object, name));
        }, context);
    };

    // Similar to eachField, except that iteration stops as soon as the
    // callback returns a truthy value. Like Array.prototype.some, the final
    // result is either true or false to indicates whether the callback
    // returned true for any element or not.
    exports.someField = function (object, callback, context) {
        return getFieldNames(object).some(function (name) {
            return callback.call(this, name, getFieldValue(object, name));
        }, context);
    };

    // This property will be overridden as true by individual Def instances
    // when they are finalized.
    Object.defineProperty(Dp, "finalized", {value: false});

    Dp.finalize = function () {
        var self = this;

        // It's not an error to finalize a type more than once, but only the
        // first call to .finalize does anything.
        if (!self.finalized) {
            var allFields = self.allFields;
            var allSupertypes = self.allSupertypes;

            self.baseNames.forEach(function (name) {
                var def = defCache[name];
                if (def instanceof Def) {
                    def.finalize();
                    extend(allFields, def.allFields);
                    extend(allSupertypes, def.allSupertypes);
                } else {
                    var message = "unknown supertype name " +
                      JSON.stringify(name) +
                      " for subtype " +
                      JSON.stringify(self.typeName);
                    throw new Error(message);
                }
            });

            // TODO Warn if fields are overridden with incompatible types.
            extend(allFields, self.ownFields);
            allSupertypes[self.typeName] = self;

            self.fieldNames.length = 0;
            for (var fieldName in allFields) {
                if (hasOwn.call(allFields, fieldName) &&
                    !allFields[fieldName].hidden) {
                        self.fieldNames.push(fieldName);
                }
            }

            // Types are exported only once they have been finalized.
            Object.defineProperty(namedTypes, self.typeName, {
                enumerable: true,
                value: self.type
            });

            Object.defineProperty(self, "finalized", {value: true});

            // A linearization of the inheritance hierarchy.
            populateSupertypeList(self.typeName, self.supertypeList);

            if (self.buildable && self.supertypeList.lastIndexOf("Expression") >= 0) {
                wrapExpressionBuilderWithStatement(self.typeName);
            }
        }
    };

    // Adds an additional builder for Expression subtypes
    // that wraps the built Expression in an ExpressionStatements.
    function wrapExpressionBuilderWithStatement(typeName) {
        var wrapperName = getStatementBuilderName(typeName);

        // skip if the builder already exists
        if (builders[wrapperName]) return;

        // the builder function to wrap with builders.ExpressionStatement
        var wrapped = builders[getBuilderName(typeName)];

        // skip if there is nothing to wrap
        if (!wrapped) return;

        builders[wrapperName] = function () {
            return builders.expressionStatement(wrapped.apply(builders, arguments));
        };
    }

    function populateSupertypeList(typeName, list) {
        list.length = 0;
        list.push(typeName);

        var lastSeen = Object.create(null);

        for (var pos = 0; pos < list.length; ++pos) {
            typeName = list[pos];
            var d = defCache[typeName];
            if (d.finalized !== true) {
                throw new Error("");
            }

            // If we saw typeName earlier in the breadth-first traversal,
            // delete the last-seen occurrence.
            if (hasOwn.call(lastSeen, typeName)) {
                delete list[lastSeen[typeName]];
            }

            // Record the new index of the last-seen occurrence of typeName.
            lastSeen[typeName] = pos;

            // Enqueue the base names of this type.
            list.push.apply(list, d.baseNames);
        }

        // Compaction loop to remove array holes.
        for (var to = 0, from = to, len = list.length; from < len; ++from) {
            if (hasOwn.call(list, from)) {
                list[to++] = list[from];
            }
        }

        list.length = to;
    }

    function extend(into, from) {
        Object.keys(from).forEach(function (name) {
            into[name] = from[name];
        });

        return into;
    };

    exports.finalize = function () {
        Object.keys(defCache).forEach(function (name) {
            defCache[name].finalize();
        });
    };

    return exports;
};


/***/ }),
/* 23 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PreludeGenerator = exports.NameGenerator = exports.Generator = undefined;

var _index = __webpack_require__(0);

var _index2 = __webpack_require__(5);

var _index3 = __webpack_require__(24);

var _babelTypes = __webpack_require__(4);

var t = _interopRequireWildcard(_babelTypes);

var _invariant = __webpack_require__(1);

var _invariant2 = _interopRequireDefault(_invariant);

var _internalizer = __webpack_require__(93);

var _singletons = __webpack_require__(2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

function serializeBody(generator, context) {
  let statements = context.serializeGenerator(generator);
  if (statements.length === 1 && statements[0].type === "BlockStatement") return statements[0];
  return t.blockStatement(statements);
} /**
   * Copyright (c) 2017-present, Facebook, Inc.
   * All rights reserved.
   *
   * This source code is licensed under the BSD-style license found in the
   * LICENSE file in the root directory of this source tree. An additional grant
   * of patent rights can be found in the PATENTS file in the same directory.
   */

class Generator {
  constructor(realm, name) {
    (0, _invariant2.default)(realm.useAbstractInterpretation);
    let realmPreludeGenerator = realm.preludeGenerator;
    (0, _invariant2.default)(realmPreludeGenerator);
    this.preludeGenerator = realmPreludeGenerator;
    this.realm = realm;
    this._entries = [];
    this.id = realm.nextGeneratorId++;
    this._name = name;
  }

  getName() {
    return this._name || `#${this.id}`;
  }

  getAsPropertyNameExpression(key, canBeIdentifier = true) {
    // If key is a non-negative numeric string literal, parse it and set it as a numeric index instead.
    let index = Number.parseInt(key, 10);
    if (index >= 0 && index.toString() === key) {
      return t.numericLiteral(index);
    }

    if (canBeIdentifier) {
      // TODO #1020: revert this when Unicode identifiers are supported by all targetted JavaScript engines
      let keyIsAscii = /^[\u0000-\u007f]*$/.test(key);
      if (t.isValidIdentifier(key) && keyIsAscii) return t.identifier(key);
    }

    return t.stringLiteral(key);
  }

  empty() {
    return this._entries.length === 0;
  }

  emitGlobalDeclaration(key, value) {
    this.preludeGenerator.declaredGlobals.add(key);
    if (!(value instanceof _index.UndefinedValue)) this.emitGlobalAssignment(key, value, true);
  }

  emitGlobalAssignment(key, value, strictMode) {
    this._addEntry({
      args: [value],
      buildNode: ([valueNode]) => t.expressionStatement(t.assignmentExpression("=", this.preludeGenerator.globalReference(key, !strictMode), valueNode))
    });
  }

  emitConcreteModel(key, value) {
    this._addEntry({
      args: [(0, _singletons.concretize)(this.realm, value)],
      buildNode: ([valueNode]) => t.expressionStatement(t.assignmentExpression("=", this.preludeGenerator.globalReference(key, false), valueNode))
    });
  }

  emitGlobalDelete(key, strictMode) {
    this._addEntry({
      args: [],
      buildNode: ([]) => t.expressionStatement(t.unaryExpression("delete", this.preludeGenerator.globalReference(key, !strictMode)))
    });
  }

  emitBindingAssignment(binding, value) {
    this._addEntry({
      args: [value],
      buildNode: ([valueNode], context) => t.expressionStatement(t.assignmentExpression("=", context.serializeBinding(binding), valueNode))
    });
  }

  emitPropertyAssignment(object, key, value) {
    if (object.refuseSerialization) return;
    let propName = this.getAsPropertyNameExpression(key);
    this._addEntry({
      args: [object, value],
      buildNode: ([objectNode, valueNode]) => t.expressionStatement(t.assignmentExpression("=", t.memberExpression(objectNode, propName, !t.isIdentifier(propName)), valueNode))
    });
  }

  emitDefineProperty(object, key, desc, isDescChanged = true) {
    if (object.refuseSerialization) return;
    if (desc.enumerable && desc.configurable && desc.writable && desc.value && !isDescChanged) {
      let descValue = desc.value;
      (0, _invariant2.default)(descValue instanceof _index.Value);
      this.emitPropertyAssignment(object, key, descValue);
    } else {
      desc = Object.assign({}, desc);
      let descValue = desc.value || object.$Realm.intrinsics.undefined;
      (0, _invariant2.default)(descValue instanceof _index.Value);
      this._addEntry({
        args: [object, descValue, desc.get || object.$Realm.intrinsics.undefined, desc.set || object.$Realm.intrinsics.undefined],
        buildNode: (_, context) => context.emitDefinePropertyBody(object, key, desc)
      });
    }
  }

  emitPropertyDelete(object, key) {
    if (object.refuseSerialization) return;
    let propName = this.getAsPropertyNameExpression(key);
    this._addEntry({
      args: [object],
      buildNode: ([objectNode]) => t.expressionStatement(t.unaryExpression("delete", t.memberExpression(objectNode, propName, !t.isIdentifier(propName))))
    });
  }

  emitCall(createCallee, args) {
    this._addEntry({
      args,
      buildNode: values => t.expressionStatement(t.callExpression(createCallee(), [...values]))
    });
  }

  emitConsoleLog(method, args) {
    this.emitCall(() => t.memberExpression(t.identifier("console"), t.identifier(method)), args.map(v => typeof v === "string" ? new _index.StringValue(this.realm, v) : v));
  }

  // test must be a temporal value, which means that it must have a defined intrinsicName
  emitDoWhileStatement(test, body) {
    this._addEntry({
      args: [],
      buildNode: function ([], context) {
        let testId = test.intrinsicName;
        (0, _invariant2.default)(testId !== undefined);
        let statements = context.serializeGenerator(body);
        let block = t.blockStatement(statements);
        return t.doWhileStatement(t.identifier(testId), block);
      },
      dependencies: [body]
    });
  }

  // Checks the full set of possible concrete values as well as typeof
  // for any AbstractValues
  // e.g: (obj.property !== undefined && typeof obj.property !== "object")
  // NB: if the type of the AbstractValue is top, skips the invariant
  emitFullInvariant(object, key, value) {
    let propertyIdentifier = this.getAsPropertyNameExpression(key);
    let computed = !t.isIdentifier(propertyIdentifier);
    let accessedPropertyOf = objectNode => t.memberExpression(objectNode, propertyIdentifier, computed);
    let condition;
    if (value instanceof _index.AbstractValue) {
      let isTop = false;
      let concreteComparisons = [];
      let typeComparisons = new Set();

      function populateComparisonsLists(absValue) {
        if (absValue.kind === "abstractConcreteUnion") {
          // recurse
          for (let nestedValue of absValue.args) if (nestedValue instanceof _index.ConcreteValue) {
            concreteComparisons.push(nestedValue);
          } else {
            (0, _invariant2.default)(nestedValue instanceof _index.AbstractValue);
            populateComparisonsLists(nestedValue);
          }
        } else if (absValue.getType().isTop || absValue.getType() === _index.Value) {
          isTop = true;
        } else {
          typeComparisons.add(absValue.getType());
        }
      }
      populateComparisonsLists(value);

      // No point in doing the invariant if we don't know the type
      // of one of the nested abstract values
      if (isTop) {
        return;
      } else {
        condition = ([valueNode]) => {
          // Create `object.property !== concreteValue`
          let checks = concreteComparisons.map(concreteValue => t.binaryExpression("!==", valueNode, t.valueToNode(concreteValue.serialize())));
          // Create `typeof object.property !== typeValue`
          checks = checks.concat([...typeComparisons].map(typeValue => {
            let typeString = _singletons.Utils.typeToString(typeValue);
            (0, _invariant2.default)(typeString !== undefined, typeValue);
            return t.binaryExpression("!==", t.unaryExpression("typeof", valueNode, true), t.stringLiteral(typeString));
          }));
          return checks.reduce((expr, newCondition) => t.logicalExpression("&&", expr, newCondition));
        };
        this.emitInvariant([value, value], condition, valueNode => valueNode);
      }
    } else {
      condition = ([objectNode, valueNode]) => t.binaryExpression("!==", accessedPropertyOf(objectNode), valueNode);
      this.emitInvariant([object, value, object], condition, objnode => accessedPropertyOf(objnode));
    }
  }

  emitInvariant(args, violationConditionFn, appendLastToInvariantFn) {
    if (this.realm.omitInvariants) return;
    this._addEntry({
      args,
      buildNode: nodes => {
        let throwString = t.stringLiteral("Prepack model invariant violation");
        if (appendLastToInvariantFn) {
          let last = nodes.pop();
          throwString = t.binaryExpression("+", t.stringLiteral("Prepack model invariant violation: "), appendLastToInvariantFn(last));
        }
        let condition = violationConditionFn(nodes);
        let throwblock = t.blockStatement([t.throwStatement(t.newExpression(t.identifier("Error"), [throwString]))]);
        return t.ifStatement(condition, throwblock);
      }
    });
  }

  emitCallAndCaptureResult(types, values, createCallee, args, kind) {
    return this.derive(types, values, args, nodes => t.callExpression(createCallee(), nodes));
  }

  emitStatement(args, buildNode_) {
    this._addEntry({
      args,
      buildNode: buildNode_
    });
  }

  emitVoidExpression(types, values, args, buildNode_) {
    this._addEntry({
      args,
      buildNode: nodes => t.expressionStatement(buildNode_ instanceof Function ? buildNode_(nodes) : buildNode_)
    });
    return this.realm.intrinsics.undefined;
  }

  emitForInStatement(o, lh, sourceObject, targetObject, boundName) {
    this._addEntry({
      // duplicate args to ensure refcount > 1
      args: [o, targetObject, sourceObject, targetObject, sourceObject],
      buildNode: ([obj, tgt, src, obj1, tgt1, src1]) => {
        return t.forInStatement(lh, obj, t.blockStatement([t.expressionStatement(t.assignmentExpression("=", t.memberExpression(tgt, boundName, true), t.memberExpression(src, boundName, true)))]));
      }
    });
  }

  derive(types, values, args, buildNode_, optionalArgs) {
    (0, _invariant2.default)(buildNode_ instanceof Function || args.length === 0);
    let id = t.identifier(this.preludeGenerator.nameGenerator.generate("derived"));
    this.preludeGenerator.derivedIds.set(id.name, args);
    let options = {};
    if (optionalArgs && optionalArgs.kind) options.kind = optionalArgs.kind;
    let Constructor = _index.Value.isTypeCompatibleWith(types.getType(), _index.ObjectValue) ? _index.AbstractObjectValue : _index.AbstractValue;
    let res = new Constructor(this.realm, types, values, (0, _index2.hashString)(id.name), [], id, options);
    this._addEntry({
      isPure: optionalArgs ? optionalArgs.isPure : undefined,
      declared: res,
      args,
      buildNode: (nodes, context) => {
        return t.variableDeclaration("var", [t.variableDeclarator(id, buildNode_ instanceof Function ? buildNode_(nodes, context) : buildNode_)]);
      }
    });
    let type = types.getType();
    res.intrinsicName = id.name;
    if (optionalArgs && optionalArgs.skipInvariant) return res;
    let typeofString;
    if (type instanceof _index.FunctionValue) typeofString = "function";else if (type === _index.UndefinedValue) (0, _invariant2.default)(false);else if (type === _index.NullValue) (0, _invariant2.default)(false);else if (type === _index.StringValue) typeofString = "string";else if (type === _index.BooleanValue) typeofString = "boolean";else if (type === _index.NumberValue) typeofString = "number";else if (type === _index.IntegralValue) typeofString = "number";else if (type === _index.SymbolValue) typeofString = "symbol";else if (type === _index.ObjectValue) typeofString = "object";
    if (typeofString !== undefined) {
      // Verify that the types are as expected, a failure of this invariant
      // should mean the model is wrong.
      this.emitInvariant([res, res], nodes => {
        (0, _invariant2.default)(typeofString !== undefined);
        let condition = t.binaryExpression("!==", t.unaryExpression("typeof", nodes[0]), t.stringLiteral(typeofString));
        if (typeofString === "object") {
          condition = t.logicalExpression("&&", condition, t.binaryExpression("!==", t.unaryExpression("typeof", nodes[0]), t.stringLiteral("function")));
          condition = t.logicalExpression("||", condition, t.binaryExpression("===", nodes[0], _internalizer.nullExpression));
        }
        return condition;
      }, node => node);
    }

    return res;
  }

  serialize(context) {
    for (let entry of this._entries) {
      if (!entry.isPure || !entry.declared || !context.canOmit(entry.declared)) {
        let nodes = entry.args.map((boundArg, i) => context.serializeValue(boundArg));
        if (entry.buildNode) {
          let node = entry.buildNode(nodes, context);
          if (node.type === "BlockStatement") {
            let block = node;
            let statements = block.body;
            if (statements.length === 0) continue;
            if (statements.length === 1) {
              node = statements[0];
            }
          }
          context.emit(node);
        }
        if (entry.declared !== undefined) context.declare(entry.declared);
      }
    }
  }

  visitEntry(entry, callbacks) {
    if (entry.isPure && entry.declared && callbacks.canSkip(entry.declared)) {
      callbacks.recordDelayedEntry(this, entry);
    } else {
      if (entry.declared) callbacks.recordDeclaration(entry.declared);
      callbacks.visitValues(entry.args);
      if (entry.dependencies) for (let dependency of entry.dependencies) callbacks.visitGenerator(dependency, this);
    }
  }

  visit(callbacks) {
    for (let entry of this._entries) this.visitEntry(entry, callbacks);
  }

  _addEntry(entry) {
    this._entries.push(entry);
  }

  appendGenerator(other, leadingComment) {
    if (other.empty()) return;
    this._addEntry({
      args: [],
      buildNode: function (args, context) {
        let statements = context.serializeGenerator(other);
        if (statements.length === 1) {
          let statement = statements[0];
          if (leadingComment.length > 0) statement.leadingComments = [{ type: "BlockComment", value: leadingComment }];
          return statement;
        }
        let block = t.blockStatement(statements);
        if (leadingComment.length > 0) block.leadingComments = [{ type: "BlockComment", value: leadingComment }];
        return block;
      },
      dependencies: [other]
    });
  }

  composeGenerators(generator1, generator2) {
    this._addEntry({
      args: [],
      buildNode: function ([], context) {
        let statements1 = generator1.empty() ? [] : context.serializeGenerator(generator1);
        let statements2 = generator2.empty() ? [] : context.serializeGenerator(generator2);
        let statements = statements1.concat(statements2);
        if (statements.length === 1) return statements[0];
        return t.blockStatement(statements);
      },
      dependencies: [generator1, generator2]
    });
  }

  joinGenerators(joinCondition, generator1, generator2) {
    this._addEntry({
      args: [joinCondition],
      buildNode: function ([cond], context) {
        let block1 = generator1.empty() ? null : serializeBody(generator1, context);
        let block2 = generator2.empty() ? null : serializeBody(generator2, context);
        if (block1) return t.ifStatement(cond, block1, block2);
        (0, _invariant2.default)(block2);
        return t.ifStatement(t.unaryExpression("!", cond), block2);
      },
      dependencies: [generator1, generator2]
    });
  }
}

exports.Generator = Generator; // some characters are invalid within a JavaScript identifier,
// such as: . , : ( ) ' " ` [ ] -
// so we replace these character instances with an underscore

function replaceInvalidCharactersWithUnderscore(string) {
  return string.replace(/[.,:\(\)\"\'\`\[\]\-]/g, "_");
}

const base62characters = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
function base62encode(n) {
  (0, _invariant2.default)((n | 0) === n && n >= 0);
  if (n === 0) return "0";
  let s = "";
  while (n > 0) {
    let f = n % base62characters.length;
    s = base62characters[f] + s;
    n = (n - f) / base62characters.length;
  }
  return s;
}

class NameGenerator {
  constructor(forbiddenNames, debugNames, uniqueSuffix, prefix) {
    this.prefix = prefix;
    this.uidCounter = 0;
    this.debugNames = debugNames;
    this.forbiddenNames = forbiddenNames;
    this.uniqueSuffix = uniqueSuffix;
  }

  generate(debugSuffix) {
    let id;
    do {
      id = this.prefix + base62encode(this.uidCounter++);
      if (this.uniqueSuffix.length > 0) id += this.uniqueSuffix;
      if (this.debugNames) {
        if (debugSuffix) id += "_" + replaceInvalidCharactersWithUnderscore(debugSuffix);else id += "_";
      }
    } while (this.forbiddenNames.has(id));
    return id;
  }
}

exports.NameGenerator = NameGenerator;
class PreludeGenerator {
  constructor(debugNames, uniqueSuffix) {
    this.prelude = [];
    this.derivedIds = new Map();
    this.memoizedRefs = new Map();
    this.nameGenerator = new NameGenerator(new Set(), !!debugNames, uniqueSuffix || "", "_$");
    this.usesThis = false;
    this.declaredGlobals = new Set();
  }

  createNameGenerator(prefix) {
    return new NameGenerator(this.nameGenerator.forbiddenNames, this.nameGenerator.debugNames, this.nameGenerator.uniqueSuffix, prefix);
  }

  convertStringToMember(str) {
    return str.split(".").map(name => {
      if (name === "global") {
        return this.memoizeReference(name);
      } else if (name === "this") {
        return t.thisExpression();
      } else {
        return t.identifier(name);
      }
    }).reduce((obj, prop) => t.memberExpression(obj, prop));
  }

  globalReference(key, globalScope = false) {
    if (globalScope && t.isValidIdentifier(key)) return t.identifier(key);
    let keyNode = t.isValidIdentifier(key) ? t.identifier(key) : t.stringLiteral(key);
    return t.memberExpression(this.memoizeReference("global"), keyNode, !t.isIdentifier(keyNode));
  }

  memoizeReference(key) {
    let ref = this.memoizedRefs.get(key);
    if (ref) return ref;

    let init;
    if (key.includes("(") || key.includes("[")) {
      // Horrible but effective hack:
      // Some internal object have intrinsic names such as
      //    ([][Symbol.iterator]().__proto__.__proto__)
      // and
      //    RegExp.prototype[Symbol.match]
      // which get turned into a babel node here.
      // TODO: We should properly parse such a string, and memoize all references in it separately.
      // Instead, we just turn it into a funky identifier, which Babel seems to accept.
      init = t.identifier(key);
    } else if (key === "global") {
      this.usesThis = true;
      init = t.thisExpression();
    } else {
      let i = key.lastIndexOf(".");
      if (i === -1) {
        init = t.memberExpression(this.memoizeReference("global"), t.identifier(key));
      } else {
        init = t.memberExpression(this.memoizeReference(key.substr(0, i)), t.identifier(key.substr(i + 1)));
      }
    }
    ref = t.identifier(this.nameGenerator.generate(key));
    this.prelude.push(t.variableDeclaration("var", [t.variableDeclarator(ref, init)]));
    this.memoizedRefs.set(key, ref);
    return ref;
  }
}
exports.PreludeGenerator = PreludeGenerator;

/***/ }),
/* 24 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _TypesDomain = __webpack_require__(856);

Object.defineProperty(exports, "TypesDomain", {
  enumerable: true,
  get: function () {
    return _interopRequireDefault(_TypesDomain).default;
  }
});

var _ValuesDomain = __webpack_require__(857);

Object.defineProperty(exports, "ValuesDomain", {
  enumerable: true,
  get: function () {
    return _interopRequireDefault(_ValuesDomain).default;
  }
});

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/***/ }),
/* 25 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(global) {

// compare and isBuffer taken from https://github.com/feross/buffer/blob/680e9e5e488f22aac27599a57dc844a6315928dd/index.js
// original notice:

/*!
 * The buffer module from node.js, for the browser.
 *
 * @author   Feross Aboukhadijeh <feross@feross.org> <http://feross.org>
 * @license  MIT
 */
function compare(a, b) {
  if (a === b) {
    return 0;
  }

  var x = a.length;
  var y = b.length;

  for (var i = 0, len = Math.min(x, y); i < len; ++i) {
    if (a[i] !== b[i]) {
      x = a[i];
      y = b[i];
      break;
    }
  }

  if (x < y) {
    return -1;
  }
  if (y < x) {
    return 1;
  }
  return 0;
}
function isBuffer(b) {
  if (global.Buffer && typeof global.Buffer.isBuffer === 'function') {
    return global.Buffer.isBuffer(b);
  }
  return !!(b != null && b._isBuffer);
}

// based on node assert, original notice:

// http://wiki.commonjs.org/wiki/Unit_Testing/1.0
//
// THIS IS NOT TESTED NOR LIKELY TO WORK OUTSIDE V8!
//
// Originally from narwhal.js (http://narwhaljs.org)
// Copyright (c) 2009 Thomas Robinson <280north.com>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the 'Software'), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED 'AS IS', WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
// ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

var util = __webpack_require__(164);
var hasOwn = Object.prototype.hasOwnProperty;
var pSlice = Array.prototype.slice;
var functionsHaveNames = (function () {
  return function foo() {}.name === 'foo';
}());
function pToString (obj) {
  return Object.prototype.toString.call(obj);
}
function isView(arrbuf) {
  if (isBuffer(arrbuf)) {
    return false;
  }
  if (typeof global.ArrayBuffer !== 'function') {
    return false;
  }
  if (typeof ArrayBuffer.isView === 'function') {
    return ArrayBuffer.isView(arrbuf);
  }
  if (!arrbuf) {
    return false;
  }
  if (arrbuf instanceof DataView) {
    return true;
  }
  if (arrbuf.buffer && arrbuf.buffer instanceof ArrayBuffer) {
    return true;
  }
  return false;
}
// 1. The assert module provides functions that throw
// AssertionError's when particular conditions are not met. The
// assert module must conform to the following interface.

var assert = module.exports = ok;

// 2. The AssertionError is defined in assert.
// new assert.AssertionError({ message: message,
//                             actual: actual,
//                             expected: expected })

var regex = /\s*function\s+([^\(\s]*)\s*/;
// based on https://github.com/ljharb/function.prototype.name/blob/adeeeec8bfcc6068b187d7d9fb3d5bb1d3a30899/implementation.js
function getName(func) {
  if (!util.isFunction(func)) {
    return;
  }
  if (functionsHaveNames) {
    return func.name;
  }
  var str = func.toString();
  var match = str.match(regex);
  return match && match[1];
}
assert.AssertionError = function AssertionError(options) {
  this.name = 'AssertionError';
  this.actual = options.actual;
  this.expected = options.expected;
  this.operator = options.operator;
  if (options.message) {
    this.message = options.message;
    this.generatedMessage = false;
  } else {
    this.message = getMessage(this);
    this.generatedMessage = true;
  }
  var stackStartFunction = options.stackStartFunction || fail;
  if (Error.captureStackTrace) {
    Error.captureStackTrace(this, stackStartFunction);
  } else {
    // non v8 browsers so we can have a stacktrace
    var err = new Error();
    if (err.stack) {
      var out = err.stack;

      // try to strip useless frames
      var fn_name = getName(stackStartFunction);
      var idx = out.indexOf('\n' + fn_name);
      if (idx >= 0) {
        // once we have located the function frame
        // we need to strip out everything before it (and its line)
        var next_line = out.indexOf('\n', idx + 1);
        out = out.substring(next_line + 1);
      }

      this.stack = out;
    }
  }
};

// assert.AssertionError instanceof Error
util.inherits(assert.AssertionError, Error);

function truncate(s, n) {
  if (typeof s === 'string') {
    return s.length < n ? s : s.slice(0, n);
  } else {
    return s;
  }
}
function inspect(something) {
  if (functionsHaveNames || !util.isFunction(something)) {
    return util.inspect(something);
  }
  var rawname = getName(something);
  var name = rawname ? ': ' + rawname : '';
  return '[Function' +  name + ']';
}
function getMessage(self) {
  return truncate(inspect(self.actual), 128) + ' ' +
         self.operator + ' ' +
         truncate(inspect(self.expected), 128);
}

// At present only the three keys mentioned above are used and
// understood by the spec. Implementations or sub modules can pass
// other keys to the AssertionError's constructor - they will be
// ignored.

// 3. All of the following functions must throw an AssertionError
// when a corresponding condition is not met, with a message that
// may be undefined if not provided.  All assertion methods provide
// both the actual and expected values to the assertion error for
// display purposes.

function fail(actual, expected, message, operator, stackStartFunction) {
  throw new assert.AssertionError({
    message: message,
    actual: actual,
    expected: expected,
    operator: operator,
    stackStartFunction: stackStartFunction
  });
}

// EXTENSION! allows for well behaved errors defined elsewhere.
assert.fail = fail;

// 4. Pure assertion tests whether a value is truthy, as determined
// by !!guard.
// assert.ok(guard, message_opt);
// This statement is equivalent to assert.equal(true, !!guard,
// message_opt);. To test strictly for the value true, use
// assert.strictEqual(true, guard, message_opt);.

function ok(value, message) {
  if (!value) fail(value, true, message, '==', assert.ok);
}
assert.ok = ok;

// 5. The equality assertion tests shallow, coercive equality with
// ==.
// assert.equal(actual, expected, message_opt);

assert.equal = function equal(actual, expected, message) {
  if (actual != expected) fail(actual, expected, message, '==', assert.equal);
};

// 6. The non-equality assertion tests for whether two objects are not equal
// with != assert.notEqual(actual, expected, message_opt);

assert.notEqual = function notEqual(actual, expected, message) {
  if (actual == expected) {
    fail(actual, expected, message, '!=', assert.notEqual);
  }
};

// 7. The equivalence assertion tests a deep equality relation.
// assert.deepEqual(actual, expected, message_opt);

assert.deepEqual = function deepEqual(actual, expected, message) {
  if (!_deepEqual(actual, expected, false)) {
    fail(actual, expected, message, 'deepEqual', assert.deepEqual);
  }
};

assert.deepStrictEqual = function deepStrictEqual(actual, expected, message) {
  if (!_deepEqual(actual, expected, true)) {
    fail(actual, expected, message, 'deepStrictEqual', assert.deepStrictEqual);
  }
};

function _deepEqual(actual, expected, strict, memos) {
  // 7.1. All identical values are equivalent, as determined by ===.
  if (actual === expected) {
    return true;
  } else if (isBuffer(actual) && isBuffer(expected)) {
    return compare(actual, expected) === 0;

  // 7.2. If the expected value is a Date object, the actual value is
  // equivalent if it is also a Date object that refers to the same time.
  } else if (util.isDate(actual) && util.isDate(expected)) {
    return actual.getTime() === expected.getTime();

  // 7.3 If the expected value is a RegExp object, the actual value is
  // equivalent if it is also a RegExp object with the same source and
  // properties (`global`, `multiline`, `lastIndex`, `ignoreCase`).
  } else if (util.isRegExp(actual) && util.isRegExp(expected)) {
    return actual.source === expected.source &&
           actual.global === expected.global &&
           actual.multiline === expected.multiline &&
           actual.lastIndex === expected.lastIndex &&
           actual.ignoreCase === expected.ignoreCase;

  // 7.4. Other pairs that do not both pass typeof value == 'object',
  // equivalence is determined by ==.
  } else if ((actual === null || typeof actual !== 'object') &&
             (expected === null || typeof expected !== 'object')) {
    return strict ? actual === expected : actual == expected;

  // If both values are instances of typed arrays, wrap their underlying
  // ArrayBuffers in a Buffer each to increase performance
  // This optimization requires the arrays to have the same type as checked by
  // Object.prototype.toString (aka pToString). Never perform binary
  // comparisons for Float*Arrays, though, since e.g. +0 === -0 but their
  // bit patterns are not identical.
  } else if (isView(actual) && isView(expected) &&
             pToString(actual) === pToString(expected) &&
             !(actual instanceof Float32Array ||
               actual instanceof Float64Array)) {
    return compare(new Uint8Array(actual.buffer),
                   new Uint8Array(expected.buffer)) === 0;

  // 7.5 For all other Object pairs, including Array objects, equivalence is
  // determined by having the same number of owned properties (as verified
  // with Object.prototype.hasOwnProperty.call), the same set of keys
  // (although not necessarily the same order), equivalent values for every
  // corresponding key, and an identical 'prototype' property. Note: this
  // accounts for both named and indexed properties on Arrays.
  } else if (isBuffer(actual) !== isBuffer(expected)) {
    return false;
  } else {
    memos = memos || {actual: [], expected: []};

    var actualIndex = memos.actual.indexOf(actual);
    if (actualIndex !== -1) {
      if (actualIndex === memos.expected.indexOf(expected)) {
        return true;
      }
    }

    memos.actual.push(actual);
    memos.expected.push(expected);

    return objEquiv(actual, expected, strict, memos);
  }
}

function isArguments(object) {
  return Object.prototype.toString.call(object) == '[object Arguments]';
}

function objEquiv(a, b, strict, actualVisitedObjects) {
  if (a === null || a === undefined || b === null || b === undefined)
    return false;
  // if one is a primitive, the other must be same
  if (util.isPrimitive(a) || util.isPrimitive(b))
    return a === b;
  if (strict && Object.getPrototypeOf(a) !== Object.getPrototypeOf(b))
    return false;
  var aIsArgs = isArguments(a);
  var bIsArgs = isArguments(b);
  if ((aIsArgs && !bIsArgs) || (!aIsArgs && bIsArgs))
    return false;
  if (aIsArgs) {
    a = pSlice.call(a);
    b = pSlice.call(b);
    return _deepEqual(a, b, strict);
  }
  var ka = objectKeys(a);
  var kb = objectKeys(b);
  var key, i;
  // having the same number of owned properties (keys incorporates
  // hasOwnProperty)
  if (ka.length !== kb.length)
    return false;
  //the same set of keys (although not necessarily the same order),
  ka.sort();
  kb.sort();
  //~~~cheap key test
  for (i = ka.length - 1; i >= 0; i--) {
    if (ka[i] !== kb[i])
      return false;
  }
  //equivalent values for every corresponding key, and
  //~~~possibly expensive deep test
  for (i = ka.length - 1; i >= 0; i--) {
    key = ka[i];
    if (!_deepEqual(a[key], b[key], strict, actualVisitedObjects))
      return false;
  }
  return true;
}

// 8. The non-equivalence assertion tests for any deep inequality.
// assert.notDeepEqual(actual, expected, message_opt);

assert.notDeepEqual = function notDeepEqual(actual, expected, message) {
  if (_deepEqual(actual, expected, false)) {
    fail(actual, expected, message, 'notDeepEqual', assert.notDeepEqual);
  }
};

assert.notDeepStrictEqual = notDeepStrictEqual;
function notDeepStrictEqual(actual, expected, message) {
  if (_deepEqual(actual, expected, true)) {
    fail(actual, expected, message, 'notDeepStrictEqual', notDeepStrictEqual);
  }
}


// 9. The strict equality assertion tests strict equality, as determined by ===.
// assert.strictEqual(actual, expected, message_opt);

assert.strictEqual = function strictEqual(actual, expected, message) {
  if (actual !== expected) {
    fail(actual, expected, message, '===', assert.strictEqual);
  }
};

// 10. The strict non-equality assertion tests for strict inequality, as
// determined by !==.  assert.notStrictEqual(actual, expected, message_opt);

assert.notStrictEqual = function notStrictEqual(actual, expected, message) {
  if (actual === expected) {
    fail(actual, expected, message, '!==', assert.notStrictEqual);
  }
};

function expectedException(actual, expected) {
  if (!actual || !expected) {
    return false;
  }

  if (Object.prototype.toString.call(expected) == '[object RegExp]') {
    return expected.test(actual);
  }

  try {
    if (actual instanceof expected) {
      return true;
    }
  } catch (e) {
    // Ignore.  The instanceof check doesn't work for arrow functions.
  }

  if (Error.isPrototypeOf(expected)) {
    return false;
  }

  return expected.call({}, actual) === true;
}

function _tryBlock(block) {
  var error;
  try {
    block();
  } catch (e) {
    error = e;
  }
  return error;
}

function _throws(shouldThrow, block, expected, message) {
  var actual;

  if (typeof block !== 'function') {
    throw new TypeError('"block" argument must be a function');
  }

  if (typeof expected === 'string') {
    message = expected;
    expected = null;
  }

  actual = _tryBlock(block);

  message = (expected && expected.name ? ' (' + expected.name + ').' : '.') +
            (message ? ' ' + message : '.');

  if (shouldThrow && !actual) {
    fail(actual, expected, 'Missing expected exception' + message);
  }

  var userProvidedMessage = typeof message === 'string';
  var isUnwantedException = !shouldThrow && util.isError(actual);
  var isUnexpectedException = !shouldThrow && actual && !expected;

  if ((isUnwantedException &&
      userProvidedMessage &&
      expectedException(actual, expected)) ||
      isUnexpectedException) {
    fail(actual, expected, 'Got unwanted exception' + message);
  }

  if ((shouldThrow && actual && expected &&
      !expectedException(actual, expected)) || (!shouldThrow && actual)) {
    throw actual;
  }
}

// 11. Expected to throw an error:
// assert.throws(block, Error_opt, message_opt);

assert.throws = function(block, /*optional*/error, /*optional*/message) {
  _throws(true, block, error, message);
};

// EXTENSION! This is annoying to write outside this module.
assert.doesNotThrow = function(block, /*optional*/error, /*optional*/message) {
  _throws(false, block, error, message);
};

assert.ifError = function(err) { if (err) throw err; };

var objectKeys = Object.keys || function (obj) {
  var keys = [];
  for (var key in obj) {
    if (hasOwn.call(obj, key)) keys.push(key);
  }
  return keys;
};

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(21)))

/***/ }),
/* 26 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

exports.default = function (instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
};

/***/ }),
/* 27 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HasName = HasName;
exports.HasProperty = HasProperty;
exports.HasOwnProperty = HasOwnProperty;
exports.OrdinaryHasProperty = OrdinaryHasProperty;
exports.HasCompatibleType = HasCompatibleType;
exports.HasSomeCompatibleType = HasSomeCompatibleType;

var _errors = __webpack_require__(6);

var _index = __webpack_require__(5);

var _index2 = __webpack_require__(0);

var _singletons = __webpack_require__(2);

var _invariant = __webpack_require__(1);

var _invariant2 = _interopRequireDefault(_invariant);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// 12.2.1.2 Static Semantics: HasName
// 14.1.9 Static Semantics: HasName
// 14.2.7 Static Semantics: HasName
// 14.5.6 Static Semantics: HasName
// 14.2.7 Static Semantics: HasName

function HasName(realm, ast) {
  // 12.2.1.2 Static Semantics: HasName
  // CoverParenthesizedExpressionAndArrowParameterList

  // 14.2.7 Static Semantics: HasName
  if (ast.type === "ArrowFunctionExpression") return false;

  // 14.1.9 Static Semantics: HasName
  if (ast.type === "FunctionExpression") {
    // FunctionExpression: function (FormalParameters) {FunctionBody}
    if (ast.id === null)
      // 1. Return false.
      return false;
    // FunctionExpression: functionBindingIdentifier (FormalParameters) {FunctionBody}
    if (ast.id !== null)
      // 2. Return true
      return true;
  }

  // 14.5.6 Static Semantics: HasName
  if (ast.type === "ClassExpression") {
    // ClassExpression : class ClassTail
    if (ast.id === null)
      //1. Return false.
      return false;
    // ClassExpression : class BindingIdentifier ClassTail
    if (ast.id !== null)
      //1. return true;
      return true;
  }
  // 14.4.7 Static Semantics: HasName
  // GeneratorExpression
  throw Error("Unexpected AST node type  : " + ast.type);
}

// ECMA262 7.3.10
/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 */

function HasProperty(realm, O, P) {
  // 1. Assert: Type(O) is Object.

  // 2. Assert: IsPropertyKey(P) is true.
  (0, _invariant2.default)((0, _index.IsPropertyKey)(realm, P), "expected property key");

  // 3. Return ? O.[[HasProperty]](P).
  return O.$HasProperty(P);
}

// ECMA262 7.3.11
function HasOwnProperty(realm, O, P) {
  // 1. Assert: Type(O) is Object.

  // 2. Assert: IsPropertyKey(P) is true.
  (0, _invariant2.default)((0, _index.IsPropertyKey)(realm, P), "not a valid property key");

  // 3. Let desc be ? O.[[GetOwnProperty]](P).
  let desc = O.$GetOwnProperty(P);

  // 4. If desc is undefined, return false.
  if (desc === undefined) return false;
  _singletons.Properties.ThrowIfMightHaveBeenDeleted(desc.value);

  // 5. Return true.
  return true;
}

// ECMA262 9.1.7.1
function OrdinaryHasProperty(realm, O, P) {
  // 1. Assert: IsPropertyKey(P) is true.
  (0, _invariant2.default)(typeof P === "string" || (0, _index.IsPropertyKey)(realm, P), "expected property key");

  // 2. Let hasOwn be ? O.[[GetOwnProperty]](P).
  let hasOwn = O.$GetOwnProperty(P);

  // 3. If hasOwn is not undefined, return true.
  if (hasOwn !== undefined) {
    _singletons.Properties.ThrowIfMightHaveBeenDeleted(hasOwn.value);
    return true;
  }

  // 4. Let parent be ? O.[[GetPrototypeOf]]().
  let parent = O.$GetPrototypeOf();

  // 5. If parent is not null, then
  if (!(parent instanceof _index2.NullValue)) {
    (0, _invariant2.default)(parent instanceof _index2.ObjectValue);

    // a. Return ? parent.[[HasProperty]](P).
    return parent.$HasProperty(P);
  }

  // 6. Return false.
  return false;
}

// Checks if the given value is equal to or a subtype of the given type.
// If the value is an abstract value without precise type information,
// an introspection error is thrown.
function HasCompatibleType(value, type) {
  let valueType = value.getType();
  if (valueType === _index2.Value) {
    (0, _invariant2.default)(value instanceof _index2.AbstractValue);
    _index2.AbstractValue.reportIntrospectionError(value);
    throw new _errors.FatalError();
  }
  return _index2.Value.isTypeCompatibleWith(valueType, type);
}

function HasSomeCompatibleType(value, ...manyTypes) {
  let valueType = value.getType();
  if (valueType === _index2.Value) {
    (0, _invariant2.default)(value instanceof _index2.AbstractValue);
    _index2.AbstractValue.reportIntrospectionError(value);
    throw new _errors.FatalError();
  }
  return manyTypes.some(_index2.Value.isTypeCompatibleWith.bind(null, valueType));
}

/***/ }),
/* 28 */
/***/ (function(module, exports) {

// shim for using process in browser
var process = module.exports = {};

// cached from whatever global is present so that test runners that stub it
// don't break things.  But we need to wrap it in a try catch in case it is
// wrapped in strict mode code which doesn't define any globals.  It's inside a
// function because try/catches deoptimize in certain engines.

var cachedSetTimeout;
var cachedClearTimeout;

function defaultSetTimout() {
    throw new Error('setTimeout has not been defined');
}
function defaultClearTimeout () {
    throw new Error('clearTimeout has not been defined');
}
(function () {
    try {
        if (typeof setTimeout === 'function') {
            cachedSetTimeout = setTimeout;
        } else {
            cachedSetTimeout = defaultSetTimout;
        }
    } catch (e) {
        cachedSetTimeout = defaultSetTimout;
    }
    try {
        if (typeof clearTimeout === 'function') {
            cachedClearTimeout = clearTimeout;
        } else {
            cachedClearTimeout = defaultClearTimeout;
        }
    } catch (e) {
        cachedClearTimeout = defaultClearTimeout;
    }
} ())
function runTimeout(fun) {
    if (cachedSetTimeout === setTimeout) {
        //normal enviroments in sane situations
        return setTimeout(fun, 0);
    }
    // if setTimeout wasn't available but was latter defined
    if ((cachedSetTimeout === defaultSetTimout || !cachedSetTimeout) && setTimeout) {
        cachedSetTimeout = setTimeout;
        return setTimeout(fun, 0);
    }
    try {
        // when when somebody has screwed with setTimeout but no I.E. maddness
        return cachedSetTimeout(fun, 0);
    } catch(e){
        try {
            // When we are in I.E. but the script has been evaled so I.E. doesn't trust the global object when called normally
            return cachedSetTimeout.call(null, fun, 0);
        } catch(e){
            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error
            return cachedSetTimeout.call(this, fun, 0);
        }
    }


}
function runClearTimeout(marker) {
    if (cachedClearTimeout === clearTimeout) {
        //normal enviroments in sane situations
        return clearTimeout(marker);
    }
    // if clearTimeout wasn't available but was latter defined
    if ((cachedClearTimeout === defaultClearTimeout || !cachedClearTimeout) && clearTimeout) {
        cachedClearTimeout = clearTimeout;
        return clearTimeout(marker);
    }
    try {
        // when when somebody has screwed with setTimeout but no I.E. maddness
        return cachedClearTimeout(marker);
    } catch (e){
        try {
            // When we are in I.E. but the script has been evaled so I.E. doesn't  trust the global object when called normally
            return cachedClearTimeout.call(null, marker);
        } catch (e){
            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error.
            // Some versions of I.E. have different rules for clearTimeout vs setTimeout
            return cachedClearTimeout.call(this, marker);
        }
    }



}
var queue = [];
var draining = false;
var currentQueue;
var queueIndex = -1;

function cleanUpNextTick() {
    if (!draining || !currentQueue) {
        return;
    }
    draining = false;
    if (currentQueue.length) {
        queue = currentQueue.concat(queue);
    } else {
        queueIndex = -1;
    }
    if (queue.length) {
        drainQueue();
    }
}

function drainQueue() {
    if (draining) {
        return;
    }
    var timeout = runTimeout(cleanUpNextTick);
    draining = true;

    var len = queue.length;
    while(len) {
        currentQueue = queue;
        queue = [];
        while (++queueIndex < len) {
            if (currentQueue) {
                currentQueue[queueIndex].run();
            }
        }
        queueIndex = -1;
        len = queue.length;
    }
    currentQueue = null;
    draining = false;
    runClearTimeout(timeout);
}

process.nextTick = function (fun) {
    var args = new Array(arguments.length - 1);
    if (arguments.length > 1) {
        for (var i = 1; i < arguments.length; i++) {
            args[i - 1] = arguments[i];
        }
    }
    queue.push(new Item(fun, args));
    if (queue.length === 1 && !draining) {
        runTimeout(drainQueue);
    }
};

// v8 likes predictible objects
function Item(fun, array) {
    this.fun = fun;
    this.array = array;
}
Item.prototype.run = function () {
    this.fun.apply(null, this.array);
};
process.title = 'browser';
process.browser = true;
process.env = {};
process.argv = [];
process.version = ''; // empty string to avoid regexp issues
process.versions = {};

function noop() {}

process.on = noop;
process.addListener = noop;
process.once = noop;
process.off = noop;
process.removeListener = noop;
process.removeAllListeners = noop;
process.emit = noop;
process.prependListener = noop;
process.prependOnceListener = noop;

process.listeners = function (name) { return [] }

process.binding = function (name) {
    throw new Error('process.binding is not supported');
};

process.cwd = function () { return '/' };
process.chdir = function (dir) {
    throw new Error('process.chdir is not supported');
};
process.umask = function() { return 0; };


/***/ }),
/* 29 */
/***/ (function(module, exports, __webpack_require__) {

var store = __webpack_require__(257)('wks');
var uid = __webpack_require__(129);
var Symbol = __webpack_require__(49).Symbol;
var USE_SYMBOL = typeof Symbol == 'function';

var $exports = module.exports = function (name) {
  return store[name] || (store[name] =
    USE_SYMBOL && Symbol[name] || (USE_SYMBOL ? Symbol : uid)('Symbol.' + name));
};

$exports.store = store;


/***/ }),
/* 30 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var isValue = __webpack_require__(88);

module.exports = function (value) {
	if (!isValue(value)) throw new TypeError("Cannot use null or undefined");
	return value;
};


/***/ }),
/* 31 */
/***/ (function(module, exports, __webpack_require__) {

var global = __webpack_require__(40);
var core = __webpack_require__(15);
var ctx = __webpack_require__(89);
var hide = __webpack_require__(61);
var has = __webpack_require__(63);
var PROTOTYPE = 'prototype';

var $export = function (type, name, source) {
  var IS_FORCED = type & $export.F;
  var IS_GLOBAL = type & $export.G;
  var IS_STATIC = type & $export.S;
  var IS_PROTO = type & $export.P;
  var IS_BIND = type & $export.B;
  var IS_WRAP = type & $export.W;
  var exports = IS_GLOBAL ? core : core[name] || (core[name] = {});
  var expProto = exports[PROTOTYPE];
  var target = IS_GLOBAL ? global : IS_STATIC ? global[name] : (global[name] || {})[PROTOTYPE];
  var key, own, out;
  if (IS_GLOBAL) source = name;
  for (key in source) {
    // contains in native
    own = !IS_FORCED && target && target[key] !== undefined;
    if (own && has(exports, key)) continue;
    // export native or passed
    out = own ? target[key] : source[key];
    // prevent global pollution for namespaces
    exports[key] = IS_GLOBAL && typeof target[key] != 'function' ? source[key]
    // bind timers to global for call from export context
    : IS_BIND && own ? ctx(out, global)
    // wrap global constructors for prevent change them in library
    : IS_WRAP && target[key] == out ? (function (C) {
      var F = function (a, b, c) {
        if (this instanceof C) {
          switch (arguments.length) {
            case 0: return new C();
            case 1: return new C(a);
            case 2: return new C(a, b);
          } return new C(a, b, c);
        } return C.apply(this, arguments);
      };
      F[PROTOTYPE] = C[PROTOTYPE];
      return F;
    // make static versions for prototype methods
    })(out) : IS_PROTO && typeof out == 'function' ? ctx(Function.call, out) : out;
    // export proto methods to core.%CONSTRUCTOR%.methods.%NAME%
    if (IS_PROTO) {
      (exports.virtual || (exports.virtual = {}))[key] = out;
      // export proto methods to core.%CONSTRUCTOR%.prototype.%NAME%
      if (type & $export.R && expProto && !expProto[key]) hide(expProto, key, out);
    }
  }
};
// type bitmap
$export.F = 1;   // forced
$export.G = 2;   // global
$export.S = 4;   // static
$export.P = 8;   // proto
$export.B = 16;  // bind
$export.W = 32;  // wrap
$export.U = 64;  // safe
$export.R = 128; // real proto method for `library`
module.exports = $export;


/***/ }),
/* 32 */
/***/ (function(module, exports) {

module.exports = function (it) {
  return typeof it === 'object' ? it !== null : typeof it === 'function';
};


/***/ }),
/* 33 */
/***/ (function(module, exports, __webpack_require__) {

var store = __webpack_require__(189)('wks');
var uid = __webpack_require__(140);
var Symbol = __webpack_require__(40).Symbol;
var USE_SYMBOL = typeof Symbol == 'function';

var $exports = module.exports = function (name) {
  return store[name] || (store[name] =
    USE_SYMBOL && Symbol[name] || (USE_SYMBOL ? Symbol : uid)('Symbol.' + name));
};

$exports.store = store;


/***/ }),
/* 34 */
/***/ (function(module, exports) {

/**
 * Checks if `value` is classified as an `Array` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an array, else `false`.
 * @example
 *
 * _.isArray([1, 2, 3]);
 * // => true
 *
 * _.isArray(document.body.children);
 * // => false
 *
 * _.isArray('abc');
 * // => false
 *
 * _.isArray(_.noop);
 * // => false
 */
var isArray = Array.isArray;

module.exports = isArray;


/***/ }),
/* 35 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MakeConstructor = MakeConstructor;
exports.Construct = Construct;
exports.SpeciesConstructor = SpeciesConstructor;
exports.MakeClassConstructor = MakeClassConstructor;
exports.ConstructorMethod = ConstructorMethod;
exports.NonConstructorMethodDefinitions = NonConstructorMethodDefinitions;

var _index = __webpack_require__(0);

var _is = __webpack_require__(9);

var _get = __webpack_require__(11);

var _has = __webpack_require__(27);

var _singletons = __webpack_require__(2);

var _invariant = __webpack_require__(1);

var _invariant2 = _interopRequireDefault(_invariant);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// ECMA262 9.2.8
function MakeConstructor(realm, F, writablePrototype, prototype) {
  // 1. Assert: F is an ECMAScript function object.
  (0, _invariant2.default)(F instanceof _index.ECMAScriptSourceFunctionValue, "expected function value");

  // 2. Assert: F has a [[Construct]] internal method.
  (0, _invariant2.default)(F.$Construct !== undefined, "expected construct internal method");

  // 3. Assert: F is an extensible object that does not have a prototype own property.
  (0, _invariant2.default)(F.getExtensible(), "expected extensible object that doesn't have prototype own property");

  // 4. If the writablePrototype argument was not provided, let writablePrototype be true.
  if (writablePrototype === null || writablePrototype === undefined) {
    writablePrototype = true;
  }

  // 5. If the prototype argument was not provided, then
  if (!prototype) {
    // a. Let prototype be ObjectCreate(%ObjectPrototype%).
    prototype = _singletons.Create.ObjectCreate(realm, realm.intrinsics.ObjectPrototype);
    prototype.originalConstructor = F;

    // b. Perform ! DefinePropertyOrThrow(prototype, "constructor", PropertyDescriptor{[[Value]]: F, [[Writable]]: writablePrototype, [[Enumerable]]: false, [[Configurable]]: true }).
    _singletons.Properties.DefinePropertyOrThrow(realm, prototype, "constructor", {
      value: F,
      writable: writablePrototype,
      enumerable: false,
      configurable: true
    });
  }

  // 6. Perform ! DefinePropertyOrThrow(F, "prototype", PropertyDescriptor{[[Value]]: prototype, [[Writable]]: writablePrototype, [[Enumerable]]: false, [[Configurable]]: false}).
  _singletons.Properties.DefinePropertyOrThrow(realm, F, "prototype", {
    value: prototype,
    writable: writablePrototype,
    enumerable: false,
    configurable: false
  });

  // 7. Return NormalCompletion(undefined).
  return realm.intrinsics.undefined;
}

// ECMA262 7.3.13
/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 */

function Construct(realm, F, argumentsList, newTarget) {
  // If newTarget was not passed, let newTarget be F.
  if (!newTarget) newTarget = F;

  // If argumentsList was not passed, let argumentsList be a new empty List.
  if (!argumentsList) argumentsList = [];

  // Assert: IsConstructor(F) is true.
  (0, _invariant2.default)((0, _is.IsConstructor)(realm, F), "expected constructor");

  // Assert: IsConstructor(newTarget) is true.
  (0, _invariant2.default)((0, _is.IsConstructor)(realm, newTarget), "expected constructor");

  // Return ? F.[[Construct]](argumentsList, newTarget).
  (0, _invariant2.default)(F.$Construct !== undefined, "no construct method on realm value");
  return F.$Construct(argumentsList, newTarget);
}

// ECMA262 7.3.20
function SpeciesConstructor(realm, O, defaultConstructor) {
  // 1. Assert: Type(O) is Object.
  (0, _invariant2.default)(O instanceof _index.ObjectValue, "Type(O) is Object");

  // 2. Let C be ? Get(O, "constructor").
  let C = (0, _get.Get)(realm, O, "constructor");

  // 3. If C is undefined, return defaultConstructor.
  if (C instanceof _index.UndefinedValue) return defaultConstructor;

  // 4. If Type(C) is not Object, throw a TypeError exception.
  if (C.mightNotBeObject()) {
    if (C.mightBeObject()) C.throwIfNotConcrete();
    throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "Type(C) is not an object");
  }
  (0, _invariant2.default)(C instanceof _index.ObjectValue || C instanceof _index.AbstractObjectValue);

  // 5. Let S be ? Get(C, @@species).
  let S = (0, _get.Get)(realm, C, realm.intrinsics.SymbolSpecies);

  // 6. If S is either undefined or null, return defaultConstructor.
  if ((0, _has.HasSomeCompatibleType)(S, _index.UndefinedValue, _index.NullValue)) return defaultConstructor;

  // 7. If IsConstructor(S) is true, return S.
  if ((0, _is.IsConstructor)(realm, S)) {
    (0, _invariant2.default)(S instanceof _index.ObjectValue);
    return S;
  }

  // 8. Throw a TypeError exception.
  throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "Throw a TypeError exception");
}

// ECMA 9.2.9
function MakeClassConstructor(realm, F) {
  // 1. Assert: F is an ECMAScript function object.
  (0, _invariant2.default)(F instanceof _index.ECMAScriptSourceFunctionValue, "expected function value");

  // 2. Assert: F’s [[FunctionKind]] internal slot is "normal".
  (0, _invariant2.default)(F.$FunctionKind === "normal");

  // 3. Set F’s [[FunctionKind]] internal slot to "classConstructor".
  F.$FunctionKind = "classConstructor";

  // 4. Return NormalCompletion(undefined).
  return realm.intrinsics.undefined;
}

// ECMA 14.5.3
function ConstructorMethod(realm, ClassElementList) {
  let ClassElement;
  // ClassElementList : ClassElement
  if (ClassElementList.length === 1) {
    ClassElement = ClassElementList[0];
    // 1. If ClassElement is the production ClassElement : ; , return empty.
    // It looks like Babel parses out ClassElements that are only ;

    // 2. If IsStatic of ClassElement is true, return empty.
    if ((0, _is.IsStatic)(ClassElement)) {
      return realm.intrinsics.empty;
    }
    // 3. If PropName of ClassElement is not "constructor", return empty.
    if (ClassElement.key.name !== "constructor") {
      return realm.intrinsics.empty;
    }

    // 4. Return ClassElement.
    return ClassElement;
  } else {
    // ClassElementList : ClassElementList ClassElement
    // 1. Let head be ConstructorMethod of ClassElementList.
    let head = ConstructorMethod(realm, ClassElementList.slice(0, -1));
    // 2. If head is not empty, return head.
    if (!(head instanceof _index.EmptyValue)) {
      return head;
    }

    ClassElement = ClassElementList[ClassElementList.length - 1];
    // 3. If ClassElement is the production ClassElement : ; , return empty.
    // It looks like Babel parses out ClassElements that are only ;

    // 4. If IsStatic of ClassElement is true, return empty.
    if ((0, _is.IsStatic)(ClassElement)) {
      return realm.intrinsics.empty;
    }
    // If PropName of ClassElement is not "constructor", return empty.
    if (ClassElement.key.name !== "constructor") {
      return realm.intrinsics.empty;
    }

    // Return ClassElement.
    return ClassElement;
  }
}

// ECMA 14.5.10
function NonConstructorMethodDefinitions(realm, ClassElementList) {
  let ClassElement;
  // ClassElementList : ClassElement
  if (ClassElementList.length === 1) {
    ClassElement = ClassElementList[0];
    // If ClassElement is the production ClassElement : ; , return a new empty List.

    // If IsStatic of ClassElement is false and PropName of ClassElement is "constructor", return a new empty List.
    if (!(0, _is.IsStatic)(ClassElement) && ClassElement.key.name === "constructor") {
      return [];
    }
    // Return a List containing ClassElement.
    return [ClassElement];
  } else {
    // ClassElementList : ClassElementList ClassElement
    ClassElement = ClassElementList[ClassElementList.length - 1];

    // Let list be NonConstructorMethodDefinitions of ClassElementList.
    let list = NonConstructorMethodDefinitions(realm, ClassElementList.slice(0, -1));

    // If ClassElement is the production ClassElement : ; , return list.

    // If IsStatic of ClassElement is false and PropName of ClassElement is "constructor", return list.
    if (!(0, _is.IsStatic)(ClassElement) && ClassElement.key.name === "constructor") {
      return list;
    }

    // Append ClassElement to the end of list.
    list.push(ClassElement);

    // Return list.
    return list;
  }
}

/***/ }),
/* 36 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = buildExpressionTemplate;

var _babelTemplate = __webpack_require__(369);

var _babelTemplate2 = _interopRequireDefault(_babelTemplate);

var _invariant = __webpack_require__(1);

var _invariant2 = _interopRequireDefault(_invariant);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 */

function buildExpressionTemplate(code) {
  let template;
  return preludeGenerator => obj => {
    if (template === undefined) template = (0, _babelTemplate2.default)(code);
    if (preludeGenerator !== undefined && code.includes("global")) obj = Object.assign({
      global: preludeGenerator.memoizeReference("global")
    }, obj);
    let result = template(obj).expression;
    (0, _invariant2.default)(result !== undefined, "Code does not represent an expression: " + code);
    return result;
  };
}

/***/ }),
/* 37 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SerializerStatistics = exports.ReactStatistics = exports.TimingStatistics = exports.BodyReference = undefined;
exports.AreSameResidualBinding = AreSameResidualBinding;

var _environment = __webpack_require__(8);

var _index = __webpack_require__(0);

var _abstract = __webpack_require__(19);

var _realm = __webpack_require__(7);

var _invariant = __webpack_require__(1);

var _invariant2 = _interopRequireDefault(_invariant);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// TODO: add type for additional functions.
function AreSameResidualBinding(realm, x, y) {
  if (x.serializedValue === y.serializedValue) return true;
  if (x.value && x.value === y.value) return true;
  if (x.value instanceof _index.ConcreteValue && y.value instanceof _index.ConcreteValue) {
    return (0, _abstract.SameValue)(realm, x.value, y.value);
  }
  return false;
} /**
   * Copyright (c) 2017-present, Facebook, Inc.
   * All rights reserved.
   *
   * This source code is licensed under the BSD-style license found in the
   * LICENSE file in the root directory of this source tree. An additional grant
   * of patent rights can be found in the PATENTS file in the same directory.
   */

class BodyReference {
  constructor(body, index) {
    (0, _invariant2.default)(index >= 0);
    this.body = body;
    this.index = index;
  }
  isNotEarlierThan(other) {
    return this.body === other.body && this.index >= other.index;
  }
}

exports.BodyReference = BodyReference;
class TimingStatistics {
  constructor() {
    this.totalTime = 0;
    this.globalCodeTime = 0;
    this.initializeMoreModulesTime = 0;
    this.deepTraversalTime = 0;
    this.referenceCountsTime = 0;
    this.serializePassTime = 0;
  }
}

exports.TimingStatistics = TimingStatistics;
class ReactStatistics {
  constructor() {
    this.optimizedTrees = 0;
    this.inlinedComponents = 0;
    this.evaluatedRootNodes = [];
    this.componentsEvaluated = 0;
  }
}

exports.ReactStatistics = ReactStatistics;
class SerializerStatistics {
  constructor() {
    this.objects = 0;
    this.objectProperties = 0;
    this.functions = 0;
    this.functionClones = 0;
    this.referentialized = 0;
    this.valueIds = 0;
    this.valuesInlined = 0;
    this.delayedValues = 0;
    this.acceleratedModules = 0;
    this.delayedModules = 0;
  }


  log() {
    console.log(`=== serialization statistics`);
    console.log(`${this.objects} objects with ${this.objectProperties} properties`);
    console.log(`${this.functions} functions plus ${this.functionClones} clones due to captured variables; ${this.referentialized} captured mutable variables`);
    console.log(`${this.valueIds} eager and ${this.delayedValues} delayed value ids generated, and ${this.valuesInlined} values inlined`);
    console.log(`${this.acceleratedModules} accelerated and ${this.delayedModules} delayed modules.`);
  }
}

exports.SerializerStatistics = SerializerStatistics;

/***/ }),
/* 38 */
/***/ (function(module, exports, __webpack_require__) {

// Copyright 2017 the V8 project authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

const virtualfs = __webpack_require__(396);

// Setup the virtual file system.
const fs = new virtualfs.VirtualFS();
fs.mkdirpSync("third_party/todomvc/react");
fs.writeFileSync(
  "third_party/angular-material-1.1.8.css",
  __webpack_require__(397)
);
fs.writeFileSync(
  "third_party/backbone-1.1.0.js",
  __webpack_require__(398)
);
fs.writeFileSync(
  "third_party/bootstrap-4.0.0.css",
  __webpack_require__(399)
);
fs.writeFileSync(
  "third_party/foundation-6.4.2.css",
  __webpack_require__(400)
);
fs.writeFileSync(
  "third_party/jquery-3.2.1.js",
  __webpack_require__(401)
);
fs.writeFileSync(
  "third_party/coffeescript-lexer-2.0.1.coffee",
  __webpack_require__(402)
);
fs.writeFileSync(
  "third_party/lodash.core-4.17.4.js",
  __webpack_require__(403)
);
fs.writeFileSync(
  "third_party/lodash.min-4.17.4.js.map",
  __webpack_require__(404)
);
fs.writeFileSync(
  "third_party/mootools-core-1.6.0.js",
  __webpack_require__(405)
);
fs.writeFileSync(
  "third_party/preact-8.2.5.js",
  __webpack_require__(406)
);
fs.writeFileSync(
  "third_party/preact-8.2.5.js.map",
  __webpack_require__(407)
);
fs.writeFileSync(
  "third_party/redux.min-3.7.2.js",
  __webpack_require__(408)
);
fs.writeFileSync(
  "third_party/source-map.min-0.5.7.js.map",
  __webpack_require__(409)
);
fs.writeFileSync(
  "third_party/speedometer-es2015-test-2.0.js",
  __webpack_require__(410)
);
fs.writeFileSync(
  "third_party/todomvc/react/app.jsx",
  __webpack_require__(411)
);
fs.writeFileSync(
  "third_party/todomvc/react/footer.jsx",
  __webpack_require__(412)
);
fs.writeFileSync(
  "third_party/todomvc/react/todoItem.jsx",
  __webpack_require__(413)
);
fs.writeFileSync(
  "third_party/todomvc/typescript-angular.ts",
  __webpack_require__(414)
);
fs.writeFileSync(
  "third_party/underscore-1.8.3.js",
  __webpack_require__(415)
);
fs.writeFileSync(
  "third_party/underscore.min-1.8.3.js.map",
  __webpack_require__(416)
);
fs.writeFileSync(
  "third_party/vue.runtime.esm-nobuble-2.4.4.js",
  __webpack_require__(417)
);

module.exports = fs;


/***/ }),
/* 39 */
/***/ (function(module, exports) {

/*!
 * Chai - flag utility
 * Copyright(c) 2012-2014 Jake Luer <jake@alogicalparadox.com>
 * MIT Licensed
 */

/**
 * ### .flag(object, key, [value])
 *
 * Get or set a flag value on an object. If a
 * value is provided it will be set, else it will
 * return the currently set value or `undefined` if
 * the value is not set.
 *
 *     utils.flag(this, 'foo', 'bar'); // setter
 *     utils.flag(this, 'foo'); // getter, returns `bar`
 *
 * @param {Object} object constructed Assertion
 * @param {String} key
 * @param {Mixed} value (optional)
 * @namespace Utils
 * @name flag
 * @api private
 */

module.exports = function flag(obj, key, value) {
  var flags = obj.__flags || (obj.__flags = Object.create(null));
  if (arguments.length === 3) {
    flags[key] = value;
  } else {
    return flags[key];
  }
};


/***/ }),
/* 40 */
/***/ (function(module, exports) {

// https://github.com/zloirock/core-js/issues/86#issuecomment-115759028
var global = module.exports = typeof window != 'undefined' && window.Math == Math
  ? window : typeof self != 'undefined' && self.Math == Math ? self
  // eslint-disable-next-line no-new-func
  : Function('return this')();
if (typeof __g == 'number') __g = global; // eslint-disable-line no-undef


/***/ }),
/* 41 */
/***/ (function(module, exports, __webpack_require__) {

var freeGlobal = __webpack_require__(323);

/** Detect free variable `self`. */
var freeSelf = typeof self == 'object' && self && self.Object === Object && self;

/** Used as a reference to the global object. */
var root = freeGlobal || freeSelf || Function('return this')();

module.exports = root;


/***/ }),
/* 42 */
/***/ (function(module, exports) {

/**
 * Checks if `value` is object-like. A value is object-like if it's not `null`
 * and has a `typeof` result of "object".
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
 * @example
 *
 * _.isObjectLike({});
 * // => true
 *
 * _.isObjectLike([1, 2, 3]);
 * // => true
 *
 * _.isObjectLike(_.noop);
 * // => false
 *
 * _.isObjectLike(null);
 * // => false
 */
function isObjectLike(value) {
  return value != null && typeof value == 'object';
}

module.exports = isObjectLike;


/***/ }),
/* 43 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;
exports.visitors = exports.Hub = exports.Scope = exports.NodePath = undefined;

var _getIterator2 = __webpack_require__(13);

var _getIterator3 = _interopRequireDefault(_getIterator2);

var _path = __webpack_require__(79);

Object.defineProperty(exports, "NodePath", {
  enumerable: true,
  get: function get() {
    return _interopRequireDefault(_path).default;
  }
});

var _scope = __webpack_require__(222);

Object.defineProperty(exports, "Scope", {
  enumerable: true,
  get: function get() {
    return _interopRequireDefault(_scope).default;
  }
});

var _hub = __webpack_require__(367);

Object.defineProperty(exports, "Hub", {
  enumerable: true,
  get: function get() {
    return _interopRequireDefault(_hub).default;
  }
});
exports.default = traverse;

var _context = __webpack_require__(914);

var _context2 = _interopRequireDefault(_context);

var _visitors = __webpack_require__(915);

var visitors = _interopRequireWildcard(_visitors);

var _babelMessages = __webpack_require__(146);

var messages = _interopRequireWildcard(_babelMessages);

var _includes = __webpack_require__(223);

var _includes2 = _interopRequireDefault(_includes);

var _babelTypes = __webpack_require__(4);

var t = _interopRequireWildcard(_babelTypes);

var _cache = __webpack_require__(160);

var cache = _interopRequireWildcard(_cache);

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.visitors = visitors;
function traverse(parent, opts, scope, state, parentPath) {
  if (!parent) return;
  if (!opts) opts = {};

  if (!opts.noScope && !scope) {
    if (parent.type !== "Program" && parent.type !== "File") {
      throw new Error(messages.get("traverseNeedsParent", parent.type));
    }
  }

  visitors.explode(opts);

  traverse.node(parent, opts, scope, state, parentPath);
}

traverse.visitors = visitors;
traverse.verify = visitors.verify;
traverse.explode = visitors.explode;

traverse.NodePath = __webpack_require__(79);
traverse.Scope = __webpack_require__(222);
traverse.Hub = __webpack_require__(367);

traverse.cheap = function (node, enter) {
  return t.traverseFast(node, enter);
};

traverse.node = function (node, opts, scope, state, parentPath, skipKeys) {
  var keys = t.VISITOR_KEYS[node.type];
  if (!keys) return;

  var context = new _context2.default(scope, opts, state, parentPath);
  for (var _iterator = keys, _isArray = Array.isArray(_iterator), _i = 0, _iterator = _isArray ? _iterator : (0, _getIterator3.default)(_iterator);;) {
    var _ref;

    if (_isArray) {
      if (_i >= _iterator.length) break;
      _ref = _iterator[_i++];
    } else {
      _i = _iterator.next();
      if (_i.done) break;
      _ref = _i.value;
    }

    var key = _ref;

    if (skipKeys && skipKeys[key]) continue;
    if (context.visit(node, key)) return;
  }
};

traverse.clearNode = function (node, opts) {
  t.removeProperties(node, opts);

  cache.path.delete(node);
};

traverse.removeProperties = function (tree, opts) {
  t.traverseFast(tree, traverse.clearNode, opts);
  return tree;
};

function hasBlocklistedType(path, state) {
  if (path.node.type === state.type) {
    state.has = true;
    path.stop();
  }
}

traverse.hasType = function (tree, scope, type, blocklistTypes) {
  if ((0, _includes2.default)(blocklistTypes, tree.type)) return false;

  if (tree.type === type) return true;

  var state = {
    has: false,
    type: type
  };

  traverse(tree, {
    blocklist: blocklistTypes,
    enter: hasBlocklistedType
  }, scope, state);

  return state.has;
};

traverse.clearCache = function () {
  cache.clear();
};

traverse.clearCache.clearPath = cache.clearPath;
traverse.clearCache.clearScope = cache.clearScope;

traverse.copyCache = function (source, destination) {
  if (cache.path.has(source)) {
    cache.path.set(destination, cache.path.get(source));
  }
};

/***/ }),
/* 44 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Logger = undefined;

var _realm = __webpack_require__(7);

var _errors = __webpack_require__(6);

var _index = __webpack_require__(5);

var _completions = __webpack_require__(3);

var _index2 = __webpack_require__(0);

var _singletons = __webpack_require__(2);

var _invariant = __webpack_require__(1);

var _invariant2 = _interopRequireDefault(_invariant);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class Logger {
  constructor(realm, internalDebug) {
    this.realm = realm;
    this._hasErrors = false;
    this.internalDebug = internalDebug;
  }

  // Wraps a query that might potentially execute user code.
  tryQuery(f, defaultValue) {
    let realm = this.realm;
    let context = new _realm.ExecutionContext();
    context.isStrict = realm.isStrict;
    let env = realm.$GlobalEnv;
    context.lexicalEnvironment = env;
    context.variableEnvironment = env;
    context.realm = realm;
    realm.pushContext(context);
    // We use partial evaluation so that we can throw away any state mutations
    let oldErrorHandler = realm.errorHandler;
    realm.errorHandler = d => {
      if (d.severity === "Information" || d.severity === "Warning") return "Recover";
      return "Fail";
    };
    try {
      let result;
      let effects = realm.evaluateForEffects(() => {
        try {
          result = f();
        } catch (e) {
          if (e instanceof _completions.Completion) {
            result = defaultValue;
          } else if (e instanceof _errors.FatalError) {
            result = defaultValue;
          } else {
            throw e;
          }
        }
        return realm.intrinsics.undefined;
      });
      (0, _invariant2.default)(effects[0] === realm.intrinsics.undefined);
      return result;
    } finally {
      realm.errorHandler = oldErrorHandler;
      realm.popContext(context);
    }
  }

  logCompletion(res) {
    let realm = this.realm;
    let value = res.value;
    if (this.internalDebug) console.error(`=== ${res.constructor.name} ===`);
    if (this.tryQuery(() => value instanceof _index2.ObjectValue && (0, _index.InstanceofOperator)(realm, value, realm.intrinsics.Error), false)) {
      let object = value;
      try {
        let err = new _errors.FatalError(this.tryQuery(() => _singletons.To.ToStringPartial(realm, (0, _index.Get)(realm, object, "message")), "(unknown message)"));
        err.stack = this.tryQuery(() => _singletons.To.ToStringPartial(realm, (0, _index.Get)(realm, object, "stack")), "(unknown stack)");
        console.error(err.message);
        console.error(err.stack);
        if (this.internalDebug && res instanceof _completions.ThrowCompletion) console.error(res.nativeStack);
      } catch (err) {
        let message = object.properties.get("message");
        console.error(message && message.descriptor && message.descriptor.value instanceof _index2.StringValue ? message.descriptor.value.value : "(no message available)");
        console.error(err.stack);
        if (object.$ErrorData) {
          console.error(object.$ErrorData.contextStack);
        }
      }
    } else {
      try {
        value = _singletons.To.ToStringPartial(realm, value);
      } catch (err) {
        value = err.message;
      }
      console.error(value);
      if (this.internalDebug && res instanceof _completions.ThrowCompletion) console.error(res.nativeStack);
    }
    this._hasErrors = true;
  }

  logError(value, message) {
    this._log(value, message, "RecoverableError");
    this._hasErrors = true;
  }

  logWarning(value, message) {
    this._log(value, message, "Warning");
  }

  _log(value, message, severity) {
    let loc = value.expressionLocation;
    if (value.intrinsicName) {
      message = `${message}\nintrinsic name: ${value.intrinsicName}`;
    }
    let diagnostic = new _errors.CompilerDiagnostic(message, loc, "PP9000", severity);
    if (this.realm.handleError(diagnostic) === "Fail") throw new _errors.FatalError();
  }

  hasErrors() {
    return this._hasErrors;
  }
}
exports.Logger = Logger; /**
                          * Copyright (c) 2017-present, Facebook, Inc.
                          * All rights reserved.
                          *
                          * This source code is licensed under the BSD-style license found in the
                          * LICENSE file in the root directory of this source tree. An additional grant
                          * of patent rights can be found in the PATENTS file in the same directory.
                          */

/***/ }),
/* 45 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

exports.default = function (realm) {
  return build("Error", realm, false);
};

exports.describeLocation = describeLocation;
exports.build = build;

var _index = __webpack_require__(0);

var _index2 = __webpack_require__(5);

var _singletons = __webpack_require__(2);

var _invariant = __webpack_require__(1);

var _invariant2 = _interopRequireDefault(_invariant);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function describeLocation(realm, callerFn, env, loc) {
  let locString = "";
  let displayName = "";

  if (callerFn) {
    if (callerFn instanceof _index.NativeFunctionValue) {
      locString = "native";
    }

    let name = callerFn.$Get("name", callerFn);
    if (!name.mightBeUndefined()) displayName = _singletons.To.ToStringPartial(realm, name);else name.throwIfNotConcrete();

    if (env && env.$NewTarget) displayName = `new ${displayName}`;
  }

  if (!locString) {
    if (loc) {
      locString = `${loc.start.line}:${loc.start.column + 1}`;
      if (loc.source) locString = `${loc.source}:${locString}`;
    } else {
      locString = (loc ? loc.source : undefined) || "unknown";
      if (!displayName) return undefined;
    }
  }

  if (displayName) {
    return `at ${displayName} (${locString})`;
  } else {
    return `at ${locString}`;
  }
} /**
   * Copyright (c) 2017-present, Facebook, Inc.
   * All rights reserved.
   *
   * This source code is licensed under the BSD-style license found in the
   * LICENSE file in the root directory of this source tree. An additional grant
   * of patent rights can be found in the PATENTS file in the same directory.
   */

function buildStack(realm, context) {
  (0, _invariant2.default)(context.$ErrorData);

  let stack = context.$ErrorData.contextStack;
  if (!stack) return realm.intrinsics.undefined;

  let lines = [];
  let header = "";

  header += _singletons.To.ToStringPartial(realm, (0, _index2.Get)(realm, context, "name"));

  let msg = (0, _index2.Get)(realm, context, "message");
  if (!msg.mightBeUndefined()) {
    msg = _singletons.To.ToStringPartial(realm, msg);
    if (msg) header += `: ${msg}`;
  } else {
    msg.throwIfNotConcrete();
  }

  for (let executionContext of stack.reverse()) {
    let caller = executionContext.caller;
    let locString = describeLocation(realm, caller ? caller.function : undefined, caller ? caller.lexicalEnvironment : undefined, executionContext.loc);
    if (locString !== undefined) lines.push(locString);
  }

  return new _index.StringValue(realm, `${header}\n    ${lines.join("\n    ")}`);
}

function build(name, realm, inheritError = true) {
  let func = new _index.NativeFunctionValue(realm, name, name, 1, (context, [message], argLength, NewTarget) => {
    // 1. If NewTarget is undefined, let newTarget be the active function object, else let newTarget be NewTarget.
    let newTarget = NewTarget || func;

    // 2. Let O be ? OrdinaryCreateFromConstructor(newTarget, "%ErrorPrototype%", « [[ErrorData]] »).
    let O = _singletons.Create.OrdinaryCreateFromConstructor(realm, newTarget, `${name}Prototype`, { $ErrorData: undefined });
    O.$ErrorData = {
      contextStack: realm.contextStack.slice(1),
      locationData: undefined
    };

    // Build a text description of the stack.
    let stackDesc = {
      value: buildStack(realm, O),
      enumerable: false,
      configurable: true,
      writable: true
    };
    _singletons.Properties.DefinePropertyOrThrow(realm, O, "stack", stackDesc);

    // 3. If message is not undefined, then
    if (!message.mightBeUndefined()) {
      // a. Let msg be ? ToString(message).
      let msg = message.getType() === _index.StringValue ? message : _singletons.To.ToStringValue(realm, message);

      // b. Let msgDesc be the PropertyDescriptor{[[Value]]: msg, [[Writable]]: true, [[Enumerable]]: false, [[Configurable]]: true}.
      let msgDesc = {
        value: msg,
        writable: true,
        enumerable: false,
        configurable: true
      };

      // c. Perform ! DefinePropertyOrThrow(O, "message", msgDesc).
      _singletons.Properties.DefinePropertyOrThrow(realm, O, "message", msgDesc);
    } else {
      message.throwIfNotConcrete();
    }

    // 4. Return O.
    return O;
  });

  if (inheritError) {
    func.$Prototype = realm.intrinsics.Error;
  }

  return func;
}

/***/ }),
/* 46 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

exports.default = function (realm) {
  let func = new _index.NativeFunctionValue(realm, "TypedArray", "TypedArray", 0, context => {
    // 1. Throw a TypeError exception.
    throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "TypedArray");
  });

  // ECMA262 22.2.2.1
  func.defineNativeMethod("from", 1, (context, [source, mapfn, thisArg]) => {
    // 1. Let C be the this value.
    let C = context;

    // 2. If IsConstructor(C) is false, throw a TypeError exception.
    if ((0, _is.IsConstructor)(realm, C) === false) {
      throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "IsConstructor(C) is false");
    }
    (0, _invariant2.default)(C instanceof _index.ObjectValue);

    let mapping;
    // 3. If mapfn was supplied and mapfn is not undefined, then
    if (mapfn !== undefined && !mapfn.mightBeUndefined()) {
      // a. If IsCallable(mapfn) is false, throw a TypeError exception.
      if ((0, _is.IsCallable)(realm, mapfn) === false) {
        throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "IsConstructor(C) is false");
      }

      // b. Let mapping be true.
      mapping = true;
    } else {
      // 4. Else, let mapping be false.
      mapfn === undefined || mapfn.throwIfNotConcrete();
      mapping = false;
    }

    // 5. If thisArg was supplied, let T be thisArg; else let T be undefined.
    let T = thisArg !== undefined ? thisArg : realm.intrinsics.undefined;

    // 6. Let usingIterator be ? GetMethod(source, @@iterator).
    let usingIterator = (0, _get.GetMethod)(realm, source, realm.intrinsics.SymbolIterator);

    // 7. If usingIterator is not undefined, then
    if (!(usingIterator instanceof _index.UndefinedValue)) {
      // a. Let values be ? IterableToList(source, usingIterator).
      let values = (0, _iterator.IterableToList)(realm, source, usingIterator);

      // b. Let len be the number of elements in values.
      let len = values.length;

      // c. Let targetObj be ? TypedArrayCreate(C, «len»).
      let targetObj = (0, _typedarray.TypedArrayCreate)(realm, C, [new _index.NumberValue(realm, len)]);

      // d. Let k be 0.
      let k = 0;

      // e. Repeat, while k < len
      while (k < len) {
        // i. Let Pk be ! ToString(k).
        let Pk = _singletons.To.ToString(realm, new _index.NumberValue(realm, k));

        // ii. Let kValue be the first element of values and remove that element from values.
        let kValue = values.shift();

        let mappedValue;
        // iii. If mapping is true, then
        if (mapping === true) {
          // 1. Let mappedValue be ? Call(mapfn, T, « kValue, k »).
          mappedValue = (0, _call.Call)(realm, mapfn, T, [kValue, new _index.NumberValue(realm, k)]);
        } else {
          // iv. Else, let mappedValue be kValue.
          mappedValue = kValue;
        }

        // v. Perform ? Set(targetObj, Pk, mappedValue, true).
        _singletons.Properties.Set(realm, targetObj, Pk, mappedValue, true);

        // vi. Increase k by 1.
        k = k + 1;
      }

      // f. Assert: values is now an empty List.
      (0, _invariant2.default)(values.length === 0, "values is not an empty List");

      // g. Return targetObj.
      return targetObj;
    }

    // 8. NOTE: source is not an Iterable so assume it is already an array-like object.

    // 9. Let arrayLike be ! ToObject(source).
    let arrayLike = _singletons.To.ToObjectPartial(realm, source);

    // 10. Let len be ? ToLength(? Get(arrayLike, "length")).
    let len = _singletons.To.ToLength(realm, (0, _get.Get)(realm, arrayLike, "length"));

    // 11. Let targetObj be ? TypedArrayCreate(C, « len »).
    let targetObj = (0, _typedarray.TypedArrayCreate)(realm, C, [new _index.NumberValue(realm, len)]);

    // 12. Let k be 0.
    let k = 0;

    // 13. Repeat, while k < len
    while (k < len) {
      // a. Let Pk be ! ToString(k).
      let Pk = _singletons.To.ToString(realm, new _index.NumberValue(realm, k));

      // b. Let kValue be ? Get(arrayLike, Pk).
      let kValue = (0, _get.Get)(realm, arrayLike, Pk);

      let mappedValue;
      // c. If mapping is true, then
      if (mapping === true) {
        // i. Let mappedValue be ? Call(mapfn, T, « kValue, k »).
        mappedValue = (0, _call.Call)(realm, mapfn, T, [kValue, new _index.NumberValue(realm, k)]);
      } else {
        // d. Else, let mappedValue be kValue.
        mappedValue = kValue;
      }

      // e. Perform ? Set(targetObj, Pk, mappedValue, true).
      _singletons.Properties.Set(realm, targetObj, Pk, mappedValue, true);

      // f. Increase k by 1.
      k = k + 1;
    }

    // 14. Return targetObj.
    return targetObj;
  });

  // ECMA262 22.2.2.2
  func.defineNativeMethod("of", 0, (context, items, argCount) => {
    // 1. Let len be the actual number of arguments passed to this function.
    let len = argCount;

    // 2. Let items be the List of arguments passed to this function.
    items;

    // 3. Let C be the this value.
    let C = context;

    // 4. If IsConstructor(C) is false, throw a TypeError exception.
    if ((0, _is.IsConstructor)(realm, C) === false) {
      throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "IsConstructor(C) is false");
    }
    (0, _invariant2.default)(C instanceof _index.ObjectValue);

    // 5. Let newObj be ? TypedArrayCreate(C, « len »).
    let newObj = (0, _typedarray.TypedArrayCreate)(realm, C, [new _index.NumberValue(realm, len)]);

    // 6. Let k be 0.
    let k = 0;

    // 7. Repeat, while k < len
    while (k < len) {
      // a. Let kValue be items[k].
      let kValue = items[k];

      // b. Let Pk be ! ToString(k).
      let Pk = _singletons.To.ToString(realm, new _index.NumberValue(realm, k));

      // c. Perform ? Set(newObj, Pk, kValue, true).
      _singletons.Properties.Set(realm, newObj, Pk, kValue, true);

      // d. Increase k by 1.
      k = k + 1;
    }

    // 8. Return newObj.
    return newObj;
  });

  // ECMA262 22.2.2.4
  func.defineNativeGetter(realm.intrinsics.SymbolSpecies, context => {
    // 1. Return the this value
    return context;
  });

  return func;
};

exports.build = build;

var _types = __webpack_require__(221);

var _index = __webpack_require__(0);

var _typedarray = __webpack_require__(161);

var _construct = __webpack_require__(35);

var _get = __webpack_require__(11);

var _singletons = __webpack_require__(2);

var _iterator = __webpack_require__(76);

var _is = __webpack_require__(9);

var _call = __webpack_require__(20);

var _arraybuffer = __webpack_require__(92);

var _invariant = __webpack_require__(1);

var _invariant2 = _interopRequireDefault(_invariant);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// ECMA262 22.2 Table 50
/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 */

function getConstructorName(type) {
  switch (type) {
    case "Float32":
      return "Float32Array";
    case "Float64":
      return "Float64Array";
    case "Int8":
      return "Int8Array";
    case "Int16":
      return "Int16Array";
    case "Int32":
      return "Int32Array";
    case "Uint8":
      return "Uint8Array";
    case "Uint16":
      return "Uint16Array";
    case "Uint32":
      return "Uint32Array";
    case "Uint8Clamped":
      return "Uint8ClampedArray";
    default:
      (0, _invariant2.default)(false);
  }
}

function build(realm, type) {
  let func = new _index.NativeFunctionValue(realm, `${type}Array`, `${type}Array`, 3, (context, args, argCount, NewTarget) => {
    if (argCount === 0) {
      // ECMA262 22.2.4.1

      // 1. If NewTarget is undefined, throw a TypeError exception.
      if (!NewTarget) {
        throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "NewTarget is undefined");
      }

      // 2. Let constructorName be the String value of the Constructor Name value specified in Table 50 for this TypedArray constructor.
      let constructorName = getConstructorName(type);

      // 3. Return ? AllocateTypedArray(constructorName, NewTarget, "%TypedArrayPrototype%", 0).
      return (0, _typedarray.AllocateTypedArray)(realm, constructorName, NewTarget, `${type}ArrayPrototype`, 0);
    } else if (!(args[0] instanceof _index.ObjectValue)) {
      // ECMA262 22.2.4.2
      let length = args[0].throwIfNotConcrete();

      // 1. Assert: Type(length) is not Object.
      (0, _invariant2.default)(!(length instanceof _index.ObjectValue), "Type(length) is not Object");

      // 2. If NewTarget is undefined, throw a TypeError exception.
      if (!NewTarget) {
        throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "NewTarget is undefined");
      }

      // 3. Let elementLength be ? ToIndex(length).
      let elementLength = _singletons.To.ToIndexPartial(realm, length);

      // 4. Let constructorName be the String value of the Constructor Name value specified in Table 50 for this TypedArray constructor.
      let constructorName = getConstructorName(type);

      // 5. Return ? AllocateTypedArray(constructorName, NewTarget, "%TypedArrayPrototype%", elementLength).
      return (0, _typedarray.AllocateTypedArray)(realm, constructorName, NewTarget, `${type}ArrayPrototype`, elementLength);
    } else if ("$TypedArrayName" in args[0]) {
      // ECMA262 22.2.4.3
      let typedArray = args[0].throwIfNotConcrete();

      // 1. Assert: Type(typedArray) is Object and typedArray has a [[TypedArrayName]] internal slot.
      (0, _invariant2.default)(typedArray instanceof _index.ObjectValue && typeof typedArray.$TypedArrayName === "string");

      // 2. If NewTarget is undefined, throw a TypeError exception.
      if (!NewTarget) {
        throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "NewTarget is undefined");
      }

      // 3. Let constructorName be the String value of the Constructor Name value specified in Table 50 for this TypedArray constructor.
      let constructorName = getConstructorName(type);

      // 4. Let O be ? AllocateTypedArray(constructorName, NewTarget, "%TypedArrayPrototype%").
      let O = (0, _typedarray.AllocateTypedArray)(realm, constructorName, NewTarget, `${type}ArrayPrototype`);

      // 5. Let srcArray be typedArray.
      let srcArray = typedArray;

      // 6. Let srcData be srcArray.[[ViewedArrayBuffer]].
      let srcData = srcArray.$ViewedArrayBuffer;
      (0, _invariant2.default)(srcData);

      // 7. If IsDetachedBuffer(srcData) is true, throw a TypeError exception.
      if ((0, _is.IsDetachedBuffer)(realm, srcData) === true) {
        throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "IsDetachedBuffer(srcData) is true");
      }

      // 8. Let constructorName be the String value of O.[[TypedArrayName]].
      constructorName = O.$TypedArrayName;
      (0, _invariant2.default)(typeof constructorName === "string");

      // 9. Let elementType be the String value of the Element Type value in Table 50 for constructorName.
      let elementType = _typedarray.ArrayElementType[constructorName];

      // 10. Let elementLength be srcArray.[[ArrayLength]].
      let elementLength = srcArray.$ArrayLength;
      (0, _invariant2.default)(typeof elementLength === "number");

      // 11. Let srcName be the String value of srcArray.[[TypedArrayName]].
      let srcName = srcArray.$TypedArrayName;
      (0, _invariant2.default)(typeof srcName === "string");

      // 12. Let srcType be the String value of the Element Type value in Table 50 for srcName.
      let srcType = _typedarray.ArrayElementType[srcName];

      // 13. Let srcElementSize be the Element Size value in Table 50 for srcName.
      let srcElementSize = _typedarray.ArrayElementSize[srcName];

      // 14. Let srcByteOffset be srcArray.[[ByteOffset]].
      let srcByteOffset = srcArray.$ByteOffset;
      (0, _invariant2.default)(typeof srcByteOffset === "number");

      // 15. Let elementSize be the Element Size value in Table 50 for constructorName.
      let elementSize = _typedarray.ArrayElementSize[constructorName];

      // 16. Let byteLength be elementSize × elementLength.
      let byteLength = elementSize * elementLength;

      let data;
      // 17. If SameValue(elementType, srcType) is true, then
      if (elementType === srcType) {
        // a. Let data be ? CloneArrayBuffer(srcData, srcByteOffset).
        data = (0, _arraybuffer.CloneArrayBuffer)(realm, srcData, srcByteOffset);
      } else {
        // 18. Else,
        // a. Let bufferConstructor be ? SpeciesConstructor(srcData, %ArrayBuffer%).
        let bufferConstructor = (0, _construct.SpeciesConstructor)(realm, srcData, realm.intrinsics.ArrayBuffer);

        // b. Let data be ? AllocateArrayBuffer(bufferConstructor, byteLength).
        data = (0, _arraybuffer.AllocateArrayBuffer)(realm, bufferConstructor, byteLength);

        // c. If IsDetachedBuffer(srcData) is true, throw a TypeError exception.
        if ((0, _is.IsDetachedBuffer)(realm, srcData) === true) {
          throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "IsDetachedBuffer(srcData) is true");
        }

        // d. Let srcByteIndex be srcByteOffset.
        let srcByteIndex = srcByteOffset;

        // e. Let targetByteIndex be 0.
        let targetByteIndex = 0;

        // f. Let count be elementLength.
        let count = elementLength;

        // g. Repeat, while count > 0
        while (count > 0) {
          // i. Let value be GetValueFromBuffer(srcData, srcByteIndex, srcType).
          let value = (0, _arraybuffer.GetValueFromBuffer)(realm, srcData, srcByteIndex, srcType);

          // ii. Perform SetValueInBuffer(data, targetByteIndex, elementType, value).
          (0, _arraybuffer.SetValueInBuffer)(realm, data, targetByteIndex, elementType, value.value);

          // iii. Set srcByteIndex to srcByteIndex + srcElementSize.
          srcByteIndex = srcByteIndex + srcElementSize;

          // iv. Set targetByteIndex to targetByteIndex + elementSize.
          targetByteIndex = targetByteIndex + elementSize;

          // v. Decrement count by 1.
          count -= 1;
        }
      }

      // 19. Set O.[[ViewedArrayBuffer]] to data.
      O.$ViewedArrayBuffer = data;

      // 20. Set O.[[ByteLength]] to byteLength.
      O.$ByteLength = byteLength;

      // 21. Set O.[[ByteOffset]] to 0.
      O.$ByteOffset = 0;

      // 22. Set O.[[ArrayLength]] to elementLength.
      O.$ArrayLength = elementLength;

      // 23. Return O.
      return O;
    } else if (!("$ArrayBufferData" in args[0]) && !("$TypedArrayName" in args[0])) {
      // ECMA262 22.2.4.4
      let object = args[0].throwIfNotConcrete();

      // 1. Assert: Type(object) is Object and object does not have either a [[TypedArrayName]] or an [[ArrayBufferData]] internal slot.
      (0, _invariant2.default)(object instanceof _index.ObjectValue && typeof object.$TypedArrayName && !object.$ArrayBufferData);

      // 2. If NewTarget is undefined, throw a TypeError exception.
      if (!NewTarget) {
        throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "NewTarget is undefined");
      }

      // 3. Let constructorName be the String value of the Constructor Name value specified in Table 50 for this TypedArray constructor.
      let constructorName = getConstructorName(type);

      // 4. Let O be ? AllocateTypedArray(constructorName, NewTarget, "%TypedArrayPrototype%").
      let O = (0, _typedarray.AllocateTypedArray)(realm, constructorName, NewTarget, `${type}ArrayPrototype`);

      // 5. Let usingIterator be ? GetMethod(object, @@iterator).
      let usingIterator = (0, _get.GetMethod)(realm, object, realm.intrinsics.SymbolIterator);

      // 6. If usingIterator is not undefined, then
      if (!(usingIterator instanceof _index.UndefinedValue)) {
        // a. Let values be ? IterableToList(object, usingIterator).
        let values = (0, _iterator.IterableToList)(realm, object, usingIterator);

        // b. Let len be the number of elements in values.
        let len = values.length;

        // c. Perform ? AllocateTypedArrayBuffer(O, len).
        (0, _typedarray.AllocateTypedArrayBuffer)(realm, O, len);

        // d. Let k be 0.
        let k = 0;

        // e. Repeat, while k < len
        while (k < len) {
          // i. Let Pk be ! ToString(k).
          let Pk = new _index.StringValue(realm, _singletons.To.ToString(realm, new _index.NumberValue(realm, k)));

          // ii. Let kValue be the first element of values and remove that element from values.
          let kValue = values.shift();

          // iii. Perform ? Set(O, Pk, kValue, true).
          _singletons.Properties.Set(realm, O, Pk, kValue, true);

          // iv. Increase k by 1.
          k = k + 1;
        }

        // f. Assert: values is now an empty List.
        (0, _invariant2.default)(values.length === 0);

        // g. Return O.
        return O;
      }

      // 7. NOTE: object is not an Iterable so assume it is already an array-like object.

      // 8. Let arrayLike be object.
      let arrayLike = object;

      // 9. Let len be ? ToLength(? Get(arrayLike, "length")).
      let len = _singletons.To.ToLength(realm, (0, _get.Get)(realm, arrayLike, "length"));

      // 10. Perform ? AllocateTypedArrayBuffer(O, len).
      (0, _typedarray.AllocateTypedArrayBuffer)(realm, O, len);

      // 11. Let k be 0.
      let k = 0;

      // 12. Repeat, while k < len
      while (k < len) {
        // a. Let Pk be ! ToString(k).
        let Pk = new _index.StringValue(realm, _singletons.To.ToString(realm, new _index.NumberValue(realm, k)));

        // b. Let kValue be ? Get(arrayLike, Pk).
        let kValue = (0, _get.Get)(realm, arrayLike, Pk);

        // c. Perform ? Set(O, Pk, kValue, true).
        _singletons.Properties.Set(realm, O, Pk, kValue, true);

        // d. Increase k by 1.
        k += 1;
      }

      // 13. Return O.
      return O;
    } else {
      // ECMA262 22.2.4.5
      let buffer = args[0].throwIfNotConcrete(),
          byteOffset = args[1],
          length = args[2];

      // 1. Assert: Type(buffer) is Object and buffer has an [[ArrayBufferData]] internal slot.
      (0, _invariant2.default)(buffer instanceof _index.ObjectValue && "$ArrayBufferData" in buffer);

      // 2. If NewTarget is undefined, throw a TypeError exception.
      if (!NewTarget) {
        throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "NewTarget is undefined");
      }

      // 3. Let constructorName be the String value of the Constructor Name value specified in Table 50 for this TypedArray constructor.
      let constructorName = getConstructorName(type);

      // 4. Let O be ? AllocateTypedArray(constructorName, NewTarget, "%TypedArrayPrototype%").
      let O = (0, _typedarray.AllocateTypedArray)(realm, constructorName, NewTarget, `${type}ArrayPrototype`);

      // 5. Let constructorName be the String value of O.[[TypedArrayName]].
      constructorName = O.$TypedArrayName;
      (0, _invariant2.default)(constructorName);

      // 6. Let elementSize be the Number value of the Element Size value in Table 50 for constructorName.
      let elementSize = _typedarray.ArrayElementSize[constructorName];

      // 7. Let offset be ? ToIndex(byteOffset).
      let offset = _singletons.To.ToIndexPartial(realm, byteOffset);

      // 8. If offset modulo elementSize ≠ 0, throw a RangeError exception.
      if (offset % elementSize !== 0) {
        throw realm.createErrorThrowCompletion(realm.intrinsics.RangeError, "offset modulo elementSize ≠ 0");
      }

      // 9. If IsDetachedBuffer(buffer) is true, throw a TypeError exception.
      if ((0, _is.IsDetachedBuffer)(realm, buffer) === true) {
        throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "IsDetachedBuffer(buffer) is true");
      }

      // 10. Let bufferByteLength be buffer.[[ArrayBufferByteLength]].
      let bufferByteLength = buffer.$ArrayBufferByteLength;
      (0, _invariant2.default)(typeof bufferByteLength === "number");

      let newByteLength;
      // 11. If length is either not present or undefined, then
      if (!length || length instanceof _index.UndefinedValue) {
        // a. If bufferByteLength modulo elementSize ≠ 0, throw a RangeError exception.
        if (bufferByteLength % elementSize !== 0) {
          throw realm.createErrorThrowCompletion(realm.intrinsics.RangeError, "bufferByteLength modulo elementSize ≠ 0");
        }
        // b. Let newByteLength be bufferByteLength - offset.
        newByteLength = bufferByteLength - offset;

        // c. If newByteLength < 0, throw a RangeError exception.
        if (newByteLength < 0) {
          throw realm.createErrorThrowCompletion(realm.intrinsics.RangeError, "newByteLength < 0");
        }
      } else {
        // 12. Else,
        // a. Let newLength be ? ToIndex(length).
        let newLength = _singletons.To.ToIndexPartial(realm, length);

        // b. Let newByteLength be newLength × elementSize.
        newByteLength = newLength * elementSize;

        // c. If offset+newByteLength > bufferByteLength, throw a RangeError exception.
        if (offset + newByteLength > bufferByteLength) {
          throw realm.createErrorThrowCompletion(realm.intrinsics.RangeError, "offset+newByteLength > bufferByteLength");
        }
      }

      // 13. Set O.[[ViewedArrayBuffer]] to buffer.
      O.$ViewedArrayBuffer = buffer;

      // 14. Set O.[[ByteLength]] to newByteLength.
      O.$ByteLength = newByteLength;

      // 15. Set O.[[ByteOffset]] to offset.
      O.$ByteOffset = offset;

      // 16. Set O.[[ArrayLength]] to newByteLength / elementSize.
      O.$ArrayLength = newByteLength / elementSize;

      // 17. Return O.
      return O;
    }
  });

  // ECMA262 22.2.5
  func.$Prototype = realm.intrinsics.TypedArray;

  // ECMA262 22.2.5.1
  func.defineNativeConstant("BYTES_PER_ELEMENT", new _index.NumberValue(realm, _types.ElementSize[type]));

  return func;
}

/***/ }),
/* 47 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

exports.default = function (realm, obj) {
  // ECMA262 22.2.3.1
  obj.defineNativeGetter("buffer", context => {
    // 1. Let O be the this value.
    let O = context.throwIfNotConcrete();

    // 2. If Type(O) is not Object, return undefined.
    if (!(O instanceof _index.ObjectValue)) {
      throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "Type(O) is not Object");
    }

    // 3. If O does not have a [[TypedArrayName]] internal slot, throw a TypeError exception.
    if (!("$TypedArrayName" in O)) {
      throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "O does not have a [[TypedArrayName]] internal slot");
    }

    // 4. Assert: O has a [[ViewedArrayBuffer]] internal slot.
    (0, _invariant2.default)(O.$ViewedArrayBuffer, "O has a [[ViewedArrayBuffer]]");

    // 5. Let buffer be O.[[ViewedArrayBuffer]].
    let buffer = O.$ViewedArrayBuffer;

    // 6. Return buffer.
    return buffer;
  });

  // ECMA262 22.2.3.2
  obj.defineNativeGetter("byteLength", context => {
    // 1. Let O be the this value.
    let O = context.throwIfNotConcrete();

    // 2. If Type(O) is not Object, throw a TypeError exception.
    if (!(O instanceof _index.ObjectValue)) {
      throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "Type(O) is not Object");
    }

    // 3. If O does not have a [[TypedArrayName]] internal slot, throw a TypeError exception.
    if (!("$TypedArrayName" in O)) {
      throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "O does not have a [[TypedArrayName]] internal slot");
    }

    // 4. Assert: O has [[ViewedArrayBuffer]] and [[ArrayLength]] internal slots.
    (0, _invariant2.default)(O.$ViewedArrayBuffer, "O has a [[ViewedArrayBuffer]] internal slot");

    // 5. Let buffer be O.[[ViewedArrayBuffer]].
    let buffer = O.$ViewedArrayBuffer;
    (0, _invariant2.default)(buffer);

    // 6. If IsDetachedBuffer(buffer) is true, return 0.
    if ((0, _is.IsDetachedBuffer)(realm, buffer) === true) return realm.intrinsics.zero;

    // 7. Let size be O.[[ByteLength]].
    let size = O.$ByteLength;
    (0, _invariant2.default)(typeof size === "number");

    // 8. Return size.
    return new _index.NumberValue(realm, size);
  });

  // ECMA262 22.2.3.3
  obj.defineNativeGetter("byteOffset", context => {
    // 1. Let O be the this value.
    let O = context.throwIfNotConcrete();

    // 2. If Type(O) is not Object, throw a TypeError exception.
    if (!(O instanceof _index.ObjectValue)) {
      throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "Type(O) is not Object");
    }

    // 3. If O does not have a [[TypedArrayName]] internal slot, throw a TypeError exception.
    if (!("$TypedArrayName" in O)) {
      throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "O does not have a [[TypedArrayName]] internal slot");
    }

    // 4. Assert: O has [[ViewedArrayBuffer]] and [[ArrayLength]] internal slots.
    (0, _invariant2.default)(O.$ViewedArrayBuffer, "O has a [[ViewedArrayBuffer]] internal slot");

    // 5. Let buffer be O.[[ViewedArrayBuffer]].
    let buffer = O.$ViewedArrayBuffer;
    (0, _invariant2.default)(buffer);

    // 6. If IsDetachedBuffer(buffer) is true, return 0.
    if ((0, _is.IsDetachedBuffer)(realm, buffer) === true) return realm.intrinsics.zero;

    // 7. Let offset be O.[[ByteOffset]].
    let offset = O.$ByteOffset;
    (0, _invariant2.default)(typeof offset === "number");

    // 8. Return offset.
    return new _index.NumberValue(realm, offset);
  });

  // ECMA262 22.2.3.5
  obj.defineNativeMethod("copyWithin", 2, (context, [target, start, end]) => {
    // 1. Let O be ? ToObject(this value).
    let O = _singletons.To.ToObject(realm, context.throwIfNotConcrete());

    // 2. Perform ? ValidateTypedArray(O).
    (0, _typedarray.ValidateTypedArray)(realm, O);

    // 3. Let len be O.[[ArrayLength]].
    let len = O.$ArrayLength;
    (0, _invariant2.default)(typeof len === "number");

    // 4. Let relativeTarget be ? ToInteger(target).
    let relativeTarget = _singletons.To.ToInteger(realm, target);

    // 5. If relativeTarget < 0, let to be max((len + relativeTarget), 0); else let to be min(relativeTarget, len).
    let to = relativeTarget < 0 ? Math.max(len + relativeTarget, 0) : Math.min(relativeTarget, len);

    // 6. Let relativeStart be ? ToInteger(start).
    let relativeStart = _singletons.To.ToInteger(realm, start);

    // 7. If relativeStart < 0, let from be max((len + relativeStart), 0); else let from be min(relativeStart, len).
    let from = relativeStart < 0 ? Math.max(len + relativeStart, 0) : Math.min(relativeStart, len);

    // 8. If end is undefined, let relativeEnd be len; else let relativeEnd be ? ToInteger(end).
    let relativeEnd = !end || end instanceof _index.UndefinedValue ? len : _singletons.To.ToInteger(realm, end.throwIfNotConcrete());

    // 9. If relativeEnd < 0, let final be max((len + relativeEnd), 0); else let final be min(relativeEnd, len).
    let final = relativeEnd < 0 ? Math.max(len + relativeEnd, 0) : Math.min(relativeEnd, len);

    // 10. Let count be min(final-from, len-to).
    let count = Math.min(final - from, len - to);

    let direction;
    // 11. If from<to and to<from+count, then
    if (from < to && to < from + count) {
      // a. Let direction be -1.
      direction = -1;

      // b. Let from be from + count - 1.
      from = from + count - 1;

      // c. Let to be to + count - 1.
      to = to + count - 1;
    } else {
      // 12. Else,
      // a. Let direction be 1.
      direction = 1;
    }

    // 13. Repeat, while count > 0
    while (count > 0) {
      // a. Let fromKey be ! ToString(from).
      let fromKey = _singletons.To.ToString(realm, new _index.NumberValue(realm, from));

      // b. Let toKey be ! ToString(to).
      let toKey = _singletons.To.ToString(realm, new _index.NumberValue(realm, to));

      // c. Let fromPresent be ? HasProperty(O, fromKey).
      let fromPresent = (0, _has.HasProperty)(realm, O, fromKey);

      // d. If fromPresent is true, then
      if (fromPresent === true) {
        // i. Let fromVal be ? Get(O, fromKey).
        let fromVal = (0, _get.Get)(realm, O, fromKey);
        // ii. Perform ? Set(O, toKey, fromVal, true).
        _singletons.Properties.Set(realm, O, toKey, fromVal, true);
      } else {
        // e. Else fromPresent is false,
        // i. Perform ? DeletePropertyOrThrow(O, toKey).
        _singletons.Properties.DeletePropertyOrThrow(realm, O, toKey);
      }

      // f. Let from be from + direction.
      from = from + direction;

      // g. Let to be to + direction.
      to = to + direction;

      // h. Let count be count - 1.
      count = count - 1;
    }

    // 14. Return O.
    return O;
  });

  // ECMA262 22.2.3.6
  obj.defineNativeMethod("entries", 0, context => {
    // 1. Let O be the this value.
    let O = context;

    // 2. Perform ? ValidateTypedArray(O).
    (0, _typedarray.ValidateTypedArray)(realm, O);
    (0, _invariant2.default)(O instanceof _index.ObjectValue);

    // 3. Return CreateArrayIterator(O, "key+value").
    return _singletons.Create.CreateArrayIterator(realm, O, "key+value");
  });

  // ECMA262 22.2.3.7
  obj.defineNativeMethod("every", 1, (context, [callbackfn, thisArg]) => {
    // 1. Let O be ? ToObject(this value).
    let O = _singletons.To.ToObject(realm, context.throwIfNotConcrete());

    // 2. Perform ? ValidateTypedArray(O).
    (0, _typedarray.ValidateTypedArray)(realm, O);

    // 3. Let len be O.[[ArrayLength]].
    let len = O.$ArrayLength;
    (0, _invariant2.default)(typeof len === "number");

    // 4. If IsCallable(callbackfn) is false, throw a TypeError exception.
    if (!(0, _is.IsCallable)(realm, callbackfn)) {
      throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "not a function");
    }

    // 5. If thisArg was supplied, let T be thisArg; else let T be undefined.
    let T = thisArg || realm.intrinsics.undefined;

    // 6. Let k be 0.
    let k = 0;

    // 7. Repeat, while k < len
    while (k < len) {
      // a. Let Pk be ! ToString(k).
      let Pk = new _index.StringValue(realm, k + "");

      // b. Let kPresent be ? HasProperty(O, Pk).
      let kPresent = (0, _has.HasProperty)(realm, O, Pk);

      // c. If kPresent is true, then
      if (kPresent) {
        // i. Let kValue be ? Get(O, Pk).
        let kValue = (0, _get.Get)(realm, O, Pk);

        // ii. Let testResult be ToBoolean(? Call(callbackfn, T, « kValue, k, O »)).
        let testResult = _singletons.To.ToBooleanPartial(realm, (0, _call.Call)(realm, callbackfn, T, [kValue, new _index.NumberValue(realm, k), O]));

        // iii. If testResult is false, return false.
        if (!testResult) return realm.intrinsics.false;
      }

      // d. Increase k by 1.
      k++;
    }

    // 8. Return true.
    return realm.intrinsics.true;
  });

  // ECMA262 22.2.3.8
  obj.defineNativeMethod("fill", 1, (context, [value, start, end]) => {
    // 1. Let O be ? ToObject(this value).
    let O = _singletons.To.ToObject(realm, context.throwIfNotConcrete());

    // 2. Perform ? ValidateTypedArray(O).
    (0, _typedarray.ValidateTypedArray)(realm, O);

    // 3. Let len be O.[[ArrayLength]].
    let len = O.$ArrayLength;
    (0, _invariant2.default)(typeof len === "number");

    // 4. Let relativeStart be ? ToInteger(start).
    let relativeStart = _singletons.To.ToInteger(realm, start || realm.intrinsics.undefined);

    // 5. If relativeStart < 0, let k be max((len + relativeStart), 0); else let k be min(relativeStart, len).
    let k = relativeStart < 0 ? Math.max(len + relativeStart, 0) : Math.min(relativeStart, len);

    // 6. If end is undefined, let relativeEnd be len; else let relativeEnd be ? ToInteger(end).
    let relativeEnd = !end || end instanceof _index.UndefinedValue ? len : _singletons.To.ToInteger(realm, end.throwIfNotConcrete());

    // 7. If relativeEnd < 0, let final be max((len + relativeEnd), 0); else let final be min(relativeEnd, len).
    let final = relativeEnd < 0 ? Math.max(len + relativeEnd, 0) : Math.min(relativeEnd, len);

    // 8. Repeat, while k < final
    while (k < final) {
      // a. Let Pk be ! ToString(k).
      let Pk = new _index.StringValue(realm, k + "");

      // b. Perform ? Set(O, Pk, value, true).
      _singletons.Properties.Set(realm, O, Pk, value, true);

      // c. Increase k by 1.
      k++;
    }

    // 9. Return O.
    return O;
  });

  // ECMA262 22.2.3.9
  obj.defineNativeMethod("filter", 1, (context, [callbackfn, thisArg]) => {
    // 1. Let O be the this value.
    let O = context;

    // 2. Perform ? ValidateTypedArray(O).
    (0, _typedarray.ValidateTypedArray)(realm, O);
    (0, _invariant2.default)(O instanceof _index.ObjectValue);

    // 3. Let len be O.[[ArrayLength]].
    let len = O.$ArrayLength;
    (0, _invariant2.default)(typeof len === "number");

    // 4. If IsCallable(callbackfn) is false, throw a TypeError exception.
    if ((0, _is.IsCallable)(realm, callbackfn) === false) {
      throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "IsCallable(callbackfn) is false");
    }

    // 5. If thisArg was supplied, let T be thisArg; else let T be undefined.
    let T = thisArg ? thisArg : realm.intrinsics.undefined;

    // 6. Let kept be a new empty List.
    let kept = [];

    // 7. Let k be 0.
    let k = 0;

    // 8. Let captured be 0.
    let captured = 0;

    // 9. Repeat, while k < len
    while (k < len) {
      // a. Let Pk be ! ToString(k).
      let Pk = _singletons.To.ToString(realm, new _index.NumberValue(realm, k));

      // b. Let kValue be ? Get(O, Pk).
      let kValue = (0, _get.Get)(realm, O, Pk);

      // c. Let selected be ToBoolean(? Call(callbackfn, T, « kValue, k, O »)).
      let selected = _singletons.To.ToBooleanPartial(realm, (0, _call.Call)(realm, callbackfn, T, [kValue, new _index.NumberValue(realm, k), O]));

      // d. If selected is true, then
      if (selected === true) {
        // i. Append kValue to the end of kept.
        kept.push(kValue);

        // ii. Increase captured by 1.
        captured += 1;
      }

      // e. Increase k by 1.
      k += 1;
    }

    // 10. Let A be ? TypedArraySpeciesCreate(O, « captured »).
    let A = (0, _typedarray.TypedArraySpeciesCreate)(realm, O, [new _index.NumberValue(realm, captured)]);

    // 11. Let n be 0.
    let n = 0;

    // 12. For each element e of kept
    for (let e of kept) {
      // a. Perform ! Set(A, ! ToString(n), e, true).
      _singletons.Properties.Set(realm, A, new _index.StringValue(realm, _singletons.To.ToString(realm, new _index.NumberValue(realm, n))), e, true);

      // b. Increment n by 1.
      n = n + 1;
    }

    // 13. Return A.
    return A;
  });

  // ECMA262 22.2.3.10
  obj.defineNativeMethod("find", 1, (context, [predicate, thisArg]) => {
    // 1. Let O be ? ToObject(this value).
    let O = _singletons.To.ToObject(realm, context.throwIfNotConcrete());

    // 2. Perform ? ValidateTypedArray(O).
    (0, _typedarray.ValidateTypedArray)(realm, O);

    // 3. Let len be O.[[ArrayLength]].
    let len = O.$ArrayLength;
    (0, _invariant2.default)(typeof len === "number");

    // 4. If IsCallable(predicate) is false, throw a TypeError exception.
    if (!(0, _is.IsCallable)(realm, predicate)) {
      throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "not a function");
    }

    // 5. If thisArg was supplied, let T be thisArg; else let T be undefined.
    let T = thisArg || realm.intrinsics.undefined;

    // 6. Let k be 0.
    let k = 0;

    // 7. Repeat, while k < len
    while (k < len) {
      // a. Let Pk be ! ToString(k).
      let Pk = new _index.StringValue(realm, k + "");

      // b. Let kValue be ? Get(O, Pk).
      let kValue = (0, _get.Get)(realm, O, Pk);

      // c. Let testResult be ToBoolean(? Call(predicate, T, « kValue, k, O »)).
      let testResult = _singletons.To.ToBooleanPartial(realm, (0, _call.Call)(realm, predicate, T, [kValue, new _index.NumberValue(realm, k), O]));

      // d. If testResult is true, return kValue.
      if (testResult) return kValue;

      // e. Increase k by 1.
      k++;
    }

    // 8. Return undefined.
    return realm.intrinsics.undefined;
  });

  // ECMA262 22.2.3.11
  obj.defineNativeMethod("findIndex", 1, (context, [predicate, thisArg]) => {
    // 1. Let O be ? ToObject(this value).
    let O = _singletons.To.ToObject(realm, context.throwIfNotConcrete());

    // 2. Perform ? ValidateTypedArray(O).
    (0, _typedarray.ValidateTypedArray)(realm, O);

    // 3. Let len be O.[[ArrayLength]].
    let len = O.$ArrayLength;
    (0, _invariant2.default)(typeof len === "number");

    // 4. If IsCallable(predicate) is false, throw a TypeError exception.
    if ((0, _is.IsCallable)(realm, predicate) === false) {
      throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "not a function");
    }

    // 5. If thisArg was supplied, let T be thisArg; else let T be undefined.
    let T = thisArg ? thisArg : realm.intrinsics.undefined;

    // 6. Let k be 0.
    let k = 0;

    // 7. Repeat, while k < len
    while (k < len) {
      // a. Let Pk be ! ToString(k).
      let Pk = _singletons.To.ToString(realm, new _index.NumberValue(realm, k));

      // b. Let kValue be ? Get(O, Pk).
      let kValue = (0, _get.Get)(realm, O, new _index.StringValue(realm, Pk));

      // c. Let testResult be ToBoolean(? Call(predicate, T, « kValue, k, O »)).
      let testResult = _singletons.To.ToBooleanPartial(realm, (0, _call.Call)(realm, predicate, T, [kValue, new _index.NumberValue(realm, k), O]));

      // d. If testResult is true, return k.
      if (testResult === true) return new _index.NumberValue(realm, k);

      // e. Increase k by 1.
      k = k + 1;
    }

    // 8. Return -1.
    return new _index.NumberValue(realm, -1);
  });

  // ECMA262 22.2.3.12
  obj.defineNativeMethod("forEach", 1, (context, [callbackfn, thisArg]) => {
    // 1. Let O be ? ToObject(this value).
    let O = _singletons.To.ToObject(realm, context.throwIfNotConcrete());

    // 2. Perform ? ValidateTypedArray(O).
    (0, _typedarray.ValidateTypedArray)(realm, O);

    // 3. Let len be O.[[ArrayLength]].
    let len = O.$ArrayLength;
    (0, _invariant2.default)(typeof len === "number");

    // 4. If IsCallable(callbackfn) is false, throw a TypeError exception.
    if (!(0, _is.IsCallable)(realm, callbackfn)) {
      throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "not a function");
    }

    // 5. If thisArg was supplied, let T be thisArg; else let T be undefined.
    let T = thisArg || realm.intrinsics.undefined;

    // 6. Let k be 0.
    let k = 0;

    // 7. Repeat, while k < len
    while (k < len) {
      // a. Let Pk be ! ToString(k).
      let Pk = new _index.StringValue(realm, k + "");

      // b. Let kPresent be ? HasProperty(O, Pk).
      let kPresent = (0, _has.HasProperty)(realm, O, Pk);

      // c. If kPresent is true, then
      if (kPresent) {
        // i. Let kValue be ? Get(O, Pk).
        let kValue = (0, _get.Get)(realm, O, Pk);

        // ii. Perform ? Call(callbackfn, T, « kValue, k, O »).
        (0, _call.Call)(realm, callbackfn, T, [kValue, new _index.NumberValue(realm, k), O]);
      }

      // d. Increase k by 1.
      k++;
    }

    // 8. Return undefined.
    return realm.intrinsics.undefined;
  });

  // ECMA262 22.2.3.14
  obj.defineNativeMethod("includes", 1, (context, [searchElement, fromIndex]) => {
    // 1. Let O be ? ToObject(this value).
    let O = _singletons.To.ToObject(realm, context.throwIfNotConcrete());

    // 2. Perform ? ValidateTypedArray(O).
    (0, _typedarray.ValidateTypedArray)(realm, O);

    // 3. Let len be O.[[ArrayLength]].
    let len = O.$ArrayLength;
    (0, _invariant2.default)(typeof len === "number");

    // 4. If len is 0, return false.
    if (len === 0) return realm.intrinsics.false;

    // 5. Let n be ? ToInteger(fromIndex). (If fromIndex is undefined, this step produces the value 0.)
    let n = _singletons.To.ToInteger(realm, fromIndex || realm.intrinsics.undefined);

    let k;
    // 6. If n ≥ 0, then
    if (n >= 0) {
      // a. Let k be n.
      k = n;
    } else {
      // 7. Else n < 0,
      // a. Let k be len + n.
      k = len + n;
      // b. If k < 0, let k be 0.
      if (k < 0) k = 0;
    }

    // 8. Repeat, while k < len
    while (k < len) {
      // a. Let elementK be the result of ? Get(O, ! ToString(k)).
      let elementK = (0, _get.Get)(realm, O, _singletons.To.ToString(realm, new _index.NumberValue(realm, k)));

      // b. If SameValueZero(searchElement, elementK) is true, return true.
      if ((0, _abstract.SameValueZeroPartial)(realm, searchElement, elementK) === true) return realm.intrinsics.true;

      // c. Increase k by 1.
      k = k + 1;
    }

    // 9. Return false.
    return realm.intrinsics.false;
  });

  // ECMA262 22.2.3.14
  obj.defineNativeMethod("indexOf", 1, (context, [searchElement, fromIndex]) => {
    // 1. Let O be ? ToObject(this value).
    let O = _singletons.To.ToObject(realm, context.throwIfNotConcrete());

    // 2. Perform ? ValidateTypedArray(O).
    (0, _typedarray.ValidateTypedArray)(realm, O);

    // 3. Let len be O.[[ArrayLength]].
    let len = O.$ArrayLength;
    (0, _invariant2.default)(typeof len === "number");

    // 4. If len is 0, return -1.
    if (len === 0) return new _index.NumberValue(realm, -1);

    // 5. Let n be ? ToInteger(fromIndex). (If fromIndex is undefined, this step produces the value 0.)
    let n = fromIndex ? _singletons.To.ToInteger(realm, fromIndex) : 0;

    // 6. If n ≥ len, return -1.
    if (n >= len) return new _index.NumberValue(realm, -1);

    // 7. If n ≥ 0, then
    let k;
    if (n >= 0) {
      // a. If n is -0, let k be +0; else let k be n.
      k = Object.is(n, -0) ? +0 : n;
    } else {
      // 8. Else n < 0,
      // a. Let k be len + n.
      k = len + n;

      // b. If k < 0, let k be 0.
      if (k < 0) k = 0;
    }

    // 9. Repeat, while k < len
    while (k < len) {
      // a. Let kPresent be ? HasProperty(O, ! ToString(k)).
      let kPresent = (0, _has.HasProperty)(realm, O, k + "");

      // b. If kPresent is true, then
      if (kPresent === true) {
        // i. Let elementK be ? Get(O, ! ToString(k)).
        let elementK = (0, _get.Get)(realm, O, k + "");

        // ii. Let same be the result of performing Strict Equality Comparison searchElement === elementK.
        let same = (0, _abstract.StrictEqualityComparisonPartial)(realm, searchElement, elementK);

        // iii. If same is true, return k.
        if (same) return new _index.NumberValue(realm, k);
      }

      // c. Increase k by 1.
      k++;
    }

    // 10. Return -1.
    return new _index.NumberValue(realm, -1);
  });

  // ECMA262 22.2.3.15
  obj.defineNativeMethod("join", 1, (context, [separator]) => {
    // 1. Let O be ? ToObject(this value).
    let O = _singletons.To.ToObject(realm, context.throwIfNotConcrete());

    // 2. Perform ? ValidateTypedArray(O).
    (0, _typedarray.ValidateTypedArray)(realm, O);

    // 3. Let len be O.[[ArrayLength]].
    let len = O.$ArrayLength;
    (0, _invariant2.default)(typeof len === "number");

    // 4. If separator is undefined, let separator be the single-element String ",".
    if (!separator || separator instanceof _index.UndefinedValue) separator = new _index.StringValue(realm, ",");

    // 5. Let sep be ? ToString(separator).
    let sep = _singletons.To.ToStringPartial(realm, separator);

    // 6. If len is zero, return the empty String.
    if (len === 0) return realm.intrinsics.emptyString;

    // 7. Let element0 be Get(O, "0").
    let element0 = (0, _get.Get)(realm, O, "0");

    // 8. If element0 is undefined or null, let R be the empty String; otherwise, let R be ? ToString(element0).
    let R;
    if ((0, _has.HasSomeCompatibleType)(element0, _index.UndefinedValue, _index.NullValue)) {
      R = "";
    } else {
      R = _singletons.To.ToStringPartial(realm, element0);
    }

    // 9. Let k be 1.
    let k = 1;

    // 10. Repeat, while k < len
    while (k < len) {
      // a. Let S be the String value produced by concatenating R and sep.
      let S = R + sep;

      // b. Let element be ? Get(O, ! ToString(k)).
      let element = (0, _get.Get)(realm, O, new _index.StringValue(realm, k + ""));

      // c. If element is undefined or null, let next be the empty String; otherwise, let next be ? ToString(element).
      let next;
      if ((0, _has.HasSomeCompatibleType)(element, _index.UndefinedValue, _index.NullValue)) {
        next = "";
      } else {
        next = _singletons.To.ToStringPartial(realm, element);
      }

      // d. Let R be a String value produced by concatenating S and next.
      R = S + next;

      // e. Increase k by 1.
      k++;
    }

    // 11. Return R.
    return new _index.StringValue(realm, R + "");
  });

  // ECMA262 22.2.3.16
  obj.defineNativeMethod("keys", 0, context => {
    // 1. Let O be the this value.
    let O = context;

    // 2. Perform ? ValidateTypedArray(O).
    (0, _typedarray.ValidateTypedArray)(realm, O);
    (0, _invariant2.default)(O instanceof _index.ObjectValue);

    // 3. Return CreateArrayIterator(O, "key").
    return _singletons.Create.CreateArrayIterator(realm, O, "key");
  });

  // ECMA262 22.2.3.17
  obj.defineNativeMethod("lastIndexOf", 1, (context, [searchElement, fromIndex]) => {
    // 1. Let O be ? ToObject(this value).
    let O = _singletons.To.ToObject(realm, context.throwIfNotConcrete());

    // 2. Perform ? ValidateTypedArray(O).
    (0, _typedarray.ValidateTypedArray)(realm, O);

    // 3. Let len be O.[[ArrayLength]].
    let len = O.$ArrayLength;
    (0, _invariant2.default)(typeof len === "number");

    // 4. If len is 0, return -1.
    if (len === 0) return new _index.NumberValue(realm, -1);

    // 5. If argument fromIndex was passed, let n be ? ToInteger(fromIndex); else let n be len-1.
    let n = fromIndex ? _singletons.To.ToInteger(realm, fromIndex) : len - 1;

    // 6. If n ≥ 0, then
    let k;
    if (n >= 0) {
      // a. If n is -0, let k be +0; else let k be min(n, len - 1).
      k = Object.is(n, -0) ? +0 : Math.min(n, len - 1);
    } else {
      // 7. Else n < 0,
      // a. Let k be len + n.
      k = len + n;
    }

    // 8. Repeat, while k ≥ 0
    while (k >= 0) {
      // a. Let kPresent be ? HasProperty(O, ! ToString(k)).
      let kPresent = (0, _has.HasProperty)(realm, O, new _index.StringValue(realm, k + ""));

      // b. If kPresent is true, then
      if (kPresent) {
        // i. Let elementK be ? Get(O, ! ToString(k)).
        let elementK = (0, _get.Get)(realm, O, new _index.StringValue(realm, k + ""));

        // ii. Let same be the result of performing Strict Equality Comparison searchElement === elementK.
        let same = (0, _abstract.StrictEqualityComparisonPartial)(realm, searchElement, elementK);

        // iii. If same is true, return k.
        if (same) return new _index.NumberValue(realm, k);
      }

      // c. Decrease k by 1.
      k--;
    }

    // 9. Return -1.
    return new _index.NumberValue(realm, -1);
  });

  // ECMA262 22.2.3.18
  obj.defineNativeGetter("length", context => {
    // 1. Let O be the this value.
    let O = context.throwIfNotConcrete();

    // 2. If Type(O) is not Object, throw a TypeError exception.
    if (!(O instanceof _index.ObjectValue)) {
      throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "Type(O) is not Object");
    }

    // 3. If O does not have a [[TypedArrayName]] internal slot, throw a TypeError exception.
    if (!("$TypedArrayName" in O)) {
      throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "O does not have a [[TypedArrayName]] internal slot");
    }

    // 4. Assert: O has [[ViewedArrayBuffer]] and [[ArrayLength]] internal slots.
    (0, _invariant2.default)(O.$ViewedArrayBuffer, "O has a [[ViewedArrayBuffer]] internal slot");

    // 5. Let buffer be O.[[ViewedArrayBuffer]].
    let buffer = O.$ViewedArrayBuffer;
    (0, _invariant2.default)(buffer);

    // 6. If IsDetachedBuffer(buffer) is true, return 0.
    if ((0, _is.IsDetachedBuffer)(realm, buffer) === true) return realm.intrinsics.zero;

    // 7. Let length be O.[[ArrayLength]].
    let length = O.$ArrayLength;
    (0, _invariant2.default)(typeof length === "number");

    // 8. Return length.
    return new _index.NumberValue(realm, length);
  });

  // ECMA262 22.2.3.19
  obj.defineNativeMethod("map", 1, (context, [callbackfn, thisArg]) => {
    // 1. Let O be the this value.
    let O = context;

    // 2. Perform ? ValidateTypedArray(O).
    (0, _typedarray.ValidateTypedArray)(realm, O);
    (0, _invariant2.default)(O instanceof _index.ObjectValue);

    // 3. Let len be O.[[ArrayLength]].
    let len = O.$ArrayLength;
    (0, _invariant2.default)(typeof len === "number");

    // 4. If IsCallable(callbackfn) is false, throw a TypeError exception.
    if ((0, _is.IsCallable)(realm, callbackfn) === false) {
      throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "IsCallable(callbackfn) is false");
    }

    // 5. If thisArg was supplied, let T be thisArg; else let T be undefined.
    let T = thisArg ? thisArg : realm.intrinsics.undefined;

    // 6. Let A be ? TypedArraySpeciesCreate(O, « len »).
    let A = (0, _typedarray.TypedArraySpeciesCreate)(realm, O, [new _index.NumberValue(realm, len)]);

    // 7. Let k be 0.
    let k = 0;

    // 8. Repeat, while k < len
    while (k < len) {
      // a. Let Pk be ! ToString(k).
      let Pk = _singletons.To.ToString(realm, new _index.NumberValue(realm, k));

      // b. Let kValue be ? Get(O, Pk).
      let kValue = (0, _get.Get)(realm, O, Pk);

      // c. Let mappedValue be ? Call(callbackfn, T, « kValue, k, O »).
      let mappedValue = (0, _call.Call)(realm, callbackfn, T, [kValue, new _index.NumberValue(realm, k), O]);

      // d. Perform ? Set(A, Pk, mappedValue, true).
      _singletons.Properties.Set(realm, A, Pk, mappedValue, true);

      // e. Increase k by 1.
      k = k + 1;
    }

    // 9. Return A.
    return A;
  });

  // ECMA262 22.2.3.20
  obj.defineNativeMethod("reduce", 1, (context, [callbackfn, initialValue]) => {
    // 1. Let O be ? ToObject(this value).
    let O = _singletons.To.ToObject(realm, context.throwIfNotConcrete());

    // 2. Perform ? ValidateTypedArray(O).
    (0, _typedarray.ValidateTypedArray)(realm, O);

    // 3. Let len be O.[[ArrayLength]].
    let len = O.$ArrayLength;
    (0, _invariant2.default)(typeof len === "number");

    // 4. If IsCallable(callbackfn) is false, throw a TypeError exception.
    if (!(0, _is.IsCallable)(realm, callbackfn)) {
      throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "not a function");
    }

    // 5. If len is 0 and initialValue is not present, throw a TypeError exception.
    if (len === 0 && !initialValue) {
      throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "Array.prototype");
    }

    // 6. Let k be 0.
    let k = 0;

    // 7. If initialValue is present, then
    let accumulator;
    if (initialValue) {
      // a. Set accumulator to initialValue.
      accumulator = initialValue;
    } else {
      // 8. Else initialValue is not present,
      // a. Let kPresent be false.
      let kPresent = false;

      // b. Repeat, while kPresent is false and k < len
      while (kPresent === false && k < len) {
        // i. Let Pk be ! ToString(k).
        let Pk = new _index.StringValue(realm, k + "");

        // ii. Let kPresent be ? HasProperty(O, Pk).
        kPresent = (0, _has.HasProperty)(realm, O, Pk);

        // iv. If kPresent is true, then
        if (kPresent) {
          // 1. Let accumulator be ? Get(O, Pk).
          accumulator = (0, _get.Get)(realm, O, Pk);
        }

        // v. Increase k by 1.
        k++;
      }

      // c. If kPresent is false, throw a TypeError exception.
      if (!kPresent) {
        throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "kPresent is false");
      }

      (0, _invariant2.default)(accumulator);
    }

    // 9. Repeat, while k < len
    while (k < len) {
      // a. Let Pk be ! ToString(k).
      let Pk = new _index.StringValue(realm, k + "");

      // b. Let kPresent be ? HasProperty(O, Pk).
      let kPresent = (0, _has.HasProperty)(realm, O, Pk);

      // c. If kPresent is true, then
      if (kPresent) {
        // i. Let kValue be ? Get(O, Pk).
        let kValue = (0, _get.Get)(realm, O, Pk);

        // ii. Let accumulator be ? Call(callbackfn, undefined, « accumulator, kValue, k, O »).
        accumulator = (0, _call.Call)(realm, callbackfn, realm.intrinsics.undefined, [accumulator, kValue, new _index.NumberValue(realm, k), O]);
      }

      // d. Increase k by 1.
      k++;
    }

    // 10. Return accumulator.
    return accumulator;
  });

  // ECMA262 22.2.3.21
  obj.defineNativeMethod("reduceRight", 1, (context, [callbackfn, initialValue]) => {
    // 1. Let O be ? ToObject(this value).
    let O = _singletons.To.ToObject(realm, context.throwIfNotConcrete());

    // 2. Perform ? ValidateTypedArray(O).
    (0, _typedarray.ValidateTypedArray)(realm, O);

    // 3. Let len be O.[[ArrayLength]].
    let len = O.$ArrayLength;
    (0, _invariant2.default)(typeof len === "number");

    // 4. If IsCallable(callbackfn) is false, throw a TypeError exception.
    if (!(0, _is.IsCallable)(realm, callbackfn)) {
      throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "not a function");
    }

    // 5. If len is 0 and initialValue is not present, throw a TypeError exception.
    if (len === 0 && !initialValue) {
      throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "Array.prototype");
    }

    // 6. Let k be len-1.
    let k = len - 1;

    // 7. If initialValue is present, then
    let accumulator;
    if (initialValue) {
      // 1. Set accumulator to initialValue.
      accumulator = initialValue;
    } else {
      // 8. Else initialValue is not present,
      // a. Let kPresent be false.
      let kPresent = false;

      // b. Repeat, while kPresent is false and k ≥ 0
      while (!kPresent && k >= 0) {
        // i. Let Pk be ! ToString(k).
        let Pk = new _index.StringValue(realm, k + "");

        // ii. Let kPresent be ? HasProperty(O, Pk).
        kPresent = (0, _has.HasProperty)(realm, O, Pk);

        // iii. If kPresent is true, then
        if (kPresent) {
          // 1. Let accumulator be ? Get(O, Pk).
          accumulator = (0, _get.Get)(realm, O, Pk);
        }

        // iv. Decrease k by 1.
        k--;
      }

      // c. If kPresent is false, throw a TypeError exception.
      if (!kPresent || !accumulator) {
        throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "Array.prototype");
      }
    }

    // 9. Repeat, while k ≥ 0
    while (k >= 0) {
      // a. Let Pk be ! ToString(k).
      let Pk = new _index.StringValue(realm, k + "");

      // b. Let kPresent be ? HasProperty(O, Pk).
      let kPresent = (0, _has.HasProperty)(realm, O, Pk);

      // c. If kPresent is true, then
      if (kPresent) {
        // i. Let kValue be ? Get(O, Pk).
        let kValue = (0, _get.Get)(realm, O, Pk);

        // ii. Let accumulator be ? Call(callbackfn, undefined, « accumulator, kValue, k, O »).
        accumulator = (0, _call.Call)(realm, callbackfn, realm.intrinsics.undefined, [accumulator, kValue, new _index.NumberValue(realm, k), O]);
      }

      // d. Decrease k by 1.
      k--;
    }

    // 10. Return accumulator.
    return accumulator;
  });

  // ECMA262 22.2.3.21
  obj.defineNativeMethod("reverse", 0, context => {
    // 1. Let O be ? ToObject(this value).
    let O = _singletons.To.ToObject(realm, context.throwIfNotConcrete());

    // 2. Perform ? ValidateTypedArray(O).
    (0, _typedarray.ValidateTypedArray)(realm, O);

    // 3. Let len be O.[[ArrayLength]].
    let len = O.$ArrayLength;
    (0, _invariant2.default)(typeof len === "number");

    // 4. Let middle be floor(len/2).
    let middle = Math.floor(len / 2);

    // 5. Let lower be 0.
    let lower = 0;

    // 6. Repeat, while lower ≠ middle
    while (lower !== middle) {
      // a. Let upper be len - lower - 1.
      let upper = len - lower - 1;

      // b. Let upperP be ! ToString(upper).
      let upperP = new _index.StringValue(realm, upper + "");

      // c. Let lowerP be ! ToString(lower).
      let lowerP = new _index.StringValue(realm, lower + "");

      // d. Let lowerExists be ? HasProperty(O, lowerP).
      let lowerExists = (0, _has.HasProperty)(realm, O, lowerP);

      // e. If lowerExists is true, then
      let lowerValue;
      if (lowerExists) {
        // i. Let lowerValue be ? Get(O, lowerP).
        lowerValue = (0, _get.Get)(realm, O, lowerP);
      }

      // f. Let upperExists be ? HasProperty(O, upperP).
      let upperExists = (0, _has.HasProperty)(realm, O, upperP);

      // g. If upperExists is true, then
      let upperValue;
      if (upperExists) {
        // i. Let upperValue be ? Get(O, upperP).
        upperValue = (0, _get.Get)(realm, O, upperP);
      }

      // h. If lowerExists is true and upperExists is true, then
      if (lowerExists && upperExists) {
        (0, _invariant2.default)(lowerValue, "expected lower value to exist");
        (0, _invariant2.default)(upperValue, "expected upper value to exist");

        // i. Perform ? Set(O, lowerP, upperValue, true).
        _singletons.Properties.Set(realm, O, lowerP, upperValue, true);

        // ii. Perform ? Set(O, upperP, lowerValue, true).
        _singletons.Properties.Set(realm, O, upperP, lowerValue, true);
      } else if (!lowerExists && upperExists) {
        // i. Else if lowerExists is false and upperExists is true, then
        (0, _invariant2.default)(upperValue, "expected upper value to exist");

        // i. Perform ? Set(O, lowerP, upperValue, true).
        _singletons.Properties.Set(realm, O, lowerP, upperValue, true);

        // ii. Perform ? DeletePropertyOrThrow(O, upperP).
        _singletons.Properties.DeletePropertyOrThrow(realm, O, upperP);
      } else if (lowerExists && !upperExists) {
        // j. Else if lowerExists is true and upperExists is false, then
        (0, _invariant2.default)(lowerValue, "expected lower value to exist");

        // i. Perform ? DeletePropertyOrThrow(O, lowerP).
        _singletons.Properties.DeletePropertyOrThrow(realm, O, lowerP);

        // ii. Perform ? Set(O, upperP, lowerValue, true).
        _singletons.Properties.Set(realm, O, upperP, lowerValue, true);
      } else {}
      // k. Else both lowerExists and upperExists are false,
      // i. No action is required.


      // l. Increase lower by 1.
      lower++;
    }

    // 7. Return O.
    return O;
  });

  // ECMA262 22.2.3.23
  obj.defineNativeMethod("set", 1, (context, [overloaded, offset]) => {
    if (!overloaded.$TypedArrayName) {
      let array = overloaded;

      // 1. Assert: array is any ECMAScript language value other than an Object with a [[TypedArrayName]] internal slot. If it is such an Object, the definition in 22.2.3.23.2 applies.
      (0, _invariant2.default)(!(overloaded instanceof _index.ObjectValue && overloaded.$TypedArrayName));

      // 2. Let target be the this value.
      let target = context.throwIfNotConcrete();

      // 3. If Type(target) is not Object, throw a TypeError exception.
      if (!(target instanceof _index.ObjectValue)) {
        throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "Type(target) is not Object");
      }

      // 4. If target does not have a [[TypedArrayName]] internal slot, throw a TypeError exception.
      if (typeof target.$TypedArrayName !== "string") {
        throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "target does not have a [[TypedArrayName]] internal slot");
      }

      // 5. Assert: target has a [[ViewedArrayBuffer]] internal slot.
      (0, _invariant2.default)(target.$ViewedArrayBuffer, "target has a [[ViewedArrayBuffer]] internal slot");

      // 6. Let targetOffset be ? ToInteger(offset).
      let targetOffset = _singletons.To.ToInteger(realm, offset || realm.intrinsics.undefined);

      // 7. If targetOffset < 0, throw a RangeError exception.
      if (targetOffset < 0) {
        throw realm.createErrorThrowCompletion(realm.intrinsics.RangeError, "targetOffset < 0");
      }

      // 8. Let targetBuffer be target.[[ViewedArrayBuffer]].
      let targetBuffer = target.$ViewedArrayBuffer;
      (0, _invariant2.default)(targetBuffer instanceof _index.ObjectValue);

      // 9. If IsDetachedBuffer(targetBuffer) is true, throw a TypeError exception.
      if ((0, _is.IsDetachedBuffer)(realm, targetBuffer) === true) {
        throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "IsDetachedBuffer(targetBuffer) is true");
      }

      // 10. Let targetLength be target.[[ArrayLength]].
      let targetLength = target.$ArrayLength;
      (0, _invariant2.default)(typeof targetLength === "number");

      // 11. Let targetName be the String value of target.[[TypedArrayName]].
      let targetName = target.$TypedArrayName;
      (0, _invariant2.default)(typeof targetName === "string");

      // 12. Let targetElementSize be the Number value of the Element Size value specified in Table 50 for targetName.
      let targetElementSize = _typedarray.ArrayElementSize[targetName];

      // 13. Let targetType be the String value of the Element Type value in Table 50 for targetName.
      let targetType = _typedarray.ArrayElementType[targetName];

      // 14. Let targetByteOffset be target.[[ByteOffset]].
      let targetByteOffset = target.$ByteOffset;
      (0, _invariant2.default)(typeof targetByteOffset === "number");

      // 15. Let src be ? ToObject(array).
      let src = _singletons.To.ToObjectPartial(realm, array);

      // 16. Let srcLength be ? ToLength(? Get(src, "length")).
      let srcLength = _singletons.To.ToLength(realm, (0, _get.Get)(realm, src, "length"));

      // 17. If srcLength + targetOffset > targetLength, throw a RangeError exception.
      if (srcLength + targetOffset > targetLength) {
        throw realm.createErrorThrowCompletion(realm.intrinsics.RangeError, "srcLength + targetOffset > targetLength");
      }

      // 18. Let targetByteIndex be targetOffset × targetElementSize + targetByteOffset.
      let targetByteIndex = targetOffset * targetElementSize + targetByteOffset;

      // 19. Let k be 0.
      let k = 0;

      // 20. Let limit be targetByteIndex + targetElementSize × srcLength.
      let limit = targetByteIndex + targetElementSize * srcLength;

      // 21. Repeat, while targetByteIndex < limit
      while (targetByteIndex < limit) {
        // a. Let Pk be ! ToString(k).
        let Pk = _singletons.To.ToString(realm, new _index.NumberValue(realm, k));

        // b. Let kNumber be ? ToNumber(? Get(src, Pk)).
        let kNumber = _singletons.To.ToNumber(realm, (0, _get.Get)(realm, src, Pk));

        // c. If IsDetachedBuffer(targetBuffer) is true, throw a TypeError exception.
        if ((0, _is.IsDetachedBuffer)(realm, targetBuffer) === true) {
          throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "IsDetachedBuffer(targetBuffer) is true");
        }

        // d. Perform SetValueInBuffer(targetBuffer, targetByteIndex, targetType, kNumber).
        (0, _arraybuffer.SetValueInBuffer)(realm, targetBuffer, targetByteIndex, targetType, kNumber);

        // e. Set k to k + 1.
        k = k + 1;

        // f. Set targetByteIndex to targetByteIndex + targetElementSize.
        targetByteIndex = targetByteIndex + targetElementSize;
      }

      // 22. Return undefined.
      return realm.intrinsics.undefined;
    } else {
      let typedArray = overloaded;

      // 1. Assert: typedArray has a [[TypedArrayName]] internal slot. If it does not, the definition in 22.2.3.23.1 applies.
      (0, _invariant2.default)(typedArray instanceof _index.ObjectValue && typedArray.$TypedArrayName);

      // 2. Let target be the this value.
      let target = context.throwIfNotConcrete();

      // 3. If Type(target) is not Object, throw a TypeError exception.
      if (!(target instanceof _index.ObjectValue)) {
        throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "Type(target) is not Object");
      }

      // 4. If target does not have a [[TypedArrayName]] internal slot, throw a TypeError exception.
      if (typeof target.$TypedArrayName !== "string") {
        throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "target does not have a [[TypedArrayName]] internal slot");
      }

      // 5. Assert: target has a [[ViewedArrayBuffer]] internal slot.
      (0, _invariant2.default)(target.$ViewedArrayBuffer);

      // 6. Let targetOffset be ? ToInteger(offset).
      let targetOffset = _singletons.To.ToInteger(realm, offset || realm.intrinsics.undefined);

      // 7. If targetOffset < 0, throw a RangeError exception.
      if (targetOffset < 0) {
        throw realm.createErrorThrowCompletion(realm.intrinsics.RangeError, "targetOffset < 0");
      }

      // 8. Let targetBuffer be target.[[ViewedArrayBuffer]].
      let targetBuffer = target.$ViewedArrayBuffer;
      (0, _invariant2.default)(targetBuffer instanceof _index.ObjectValue);

      // 9. If IsDetachedBuffer(targetBuffer) is true, throw a TypeError exception.
      if ((0, _is.IsDetachedBuffer)(realm, targetBuffer) === true) {
        throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "IsDetachedBuffer(targetBuffer) is true");
      }

      // 10. Let targetLength be target.[[ArrayLength]].
      let targetLength = target.$ArrayLength;
      (0, _invariant2.default)(typeof targetLength === "number");

      // 11. Let srcBuffer be typedArray.[[ViewedArrayBuffer]].
      let srcBuffer = typedArray.$ViewedArrayBuffer;
      (0, _invariant2.default)(srcBuffer);

      // 12. If IsDetachedBuffer(srcBuffer) is true, throw a TypeError exception.
      if ((0, _is.IsDetachedBuffer)(realm, srcBuffer) === true) {
        throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "IsDetachedBuffer(srcBuffer) is true");
      }

      // 13. Let targetName be the String value of target.[[TypedArrayName]].
      let targetName = target.$TypedArrayName;
      (0, _invariant2.default)(typeof targetName === "string");

      // 14. Let targetType be the String value of the Element Type value in Table 50 for targetName.
      let targetType = _typedarray.ArrayElementType[targetName];

      // 15. Let targetElementSize be the Number value of the Element Size value specified in Table 50 for targetName.
      let targetElementSize = _typedarray.ArrayElementSize[targetName];

      // 16. Let targetByteOffset be target.[[ByteOffset]].
      let targetByteOffset = target.$ByteOffset;
      (0, _invariant2.default)(typeof targetByteOffset === "number");

      // 17. Let srcName be the String value of typedArray.[[TypedArrayName]].
      let srcName = typedArray.$TypedArrayName;
      (0, _invariant2.default)(typeof srcName === "string");

      // 18. Let srcType be the String value of the Element Type value in Table 50 for srcName.
      let srcType = _typedarray.ArrayElementType[srcName];

      // 19. Let srcElementSize be the Number value of the Element Size value specified in Table 50 for srcName.
      let srcElementSize = _typedarray.ArrayElementSize[srcName];

      // 20. Let srcLength be typedArray.[[ArrayLength]].
      let srcLength = typedArray.$ArrayLength;
      (0, _invariant2.default)(typeof srcLength === "number");

      // 21. Let srcByteOffset be typedArray.[[ByteOffset]].
      let srcByteOffset = typedArray.$ByteOffset;
      (0, _invariant2.default)(typeof srcByteOffset === "number");

      // 22. If srcLength + targetOffset > targetLength, throw a RangeError exception.
      if (srcLength + targetOffset > targetLength) {
        throw realm.createErrorThrowCompletion(realm.intrinsics.RangeError, "srcLength + targetOffset > targetLength");
      }

      let srcByteIndex;
      // 23. If SameValue(srcBuffer, targetBuffer) is true, then
      if ((0, _abstract.SameValue)(realm, srcBuffer, targetBuffer) === true) {
        // a. Let srcBuffer be ? CloneArrayBuffer(targetBuffer, srcByteOffset, %ArrayBuffer%).
        srcBuffer = (0, _arraybuffer.CloneArrayBuffer)(realm, targetBuffer, srcByteOffset, realm.intrinsics.ArrayBuffer);

        // b. NOTE: %ArrayBuffer% is used to clone srcBuffer because is it known to not have any observable side-effects.

        // c. Let srcByteIndex be 0.
        srcByteIndex = 0;
      } else {
        // 24. Else, let srcByteIndex be srcByteOffset.
        srcByteIndex = srcByteOffset;
      }

      // 25. Let targetByteIndex be targetOffset × targetElementSize + targetByteOffset.
      let targetByteIndex = targetOffset * targetElementSize + targetByteOffset;

      // 26. Let limit be targetByteIndex + targetElementSize × srcLength.
      let limit = targetByteIndex + targetElementSize * srcLength;

      // 27. If SameValue(srcType, targetType) is true, then
      if (srcType === targetType) {
        // a. NOTE: If srcType and targetType are the same, the transfer must be performed in a manner that preserves the bit-level encoding of the source data.

        // b. Repeat, while targetByteIndex < limit
        while (targetByteIndex < limit) {
          // i. Let value be GetValueFromBuffer(srcBuffer, srcByteIndex, "Uint8").
          let value = (0, _arraybuffer.GetValueFromBuffer)(realm, srcBuffer, srcByteIndex, "Uint8");

          // ii. Perform SetValueInBuffer(targetBuffer, targetByteIndex, "Uint8", value).
          (0, _arraybuffer.SetValueInBuffer)(realm, targetBuffer, targetByteIndex, "Uint8", value.value);

          // iii. Set srcByteIndex to srcByteIndex + 1.
          srcByteIndex += 1;

          // iv. Set targetByteIndex to targetByteIndex + 1.
          targetByteIndex += 1;
        }
      } else {
        // 28. Else,
        // a. Repeat, while targetByteIndex < limit
        while (targetByteIndex < limit) {
          // i. Let value be GetValueFromBuffer(srcBuffer, srcByteIndex, srcType).
          let value = (0, _arraybuffer.GetValueFromBuffer)(realm, srcBuffer, srcByteIndex, srcType);

          // ii. Perform SetValueInBuffer(targetBuffer, targetByteIndex, targetType, value).
          (0, _arraybuffer.SetValueInBuffer)(realm, targetBuffer, targetByteIndex, targetType, value.value);

          // iii. Set srcByteIndex to srcByteIndex + srcElementSize.
          srcByteIndex = srcByteIndex + srcElementSize;

          // iv. Set targetByteIndex to targetByteIndex + targetElementSize.
          targetByteIndex = targetByteIndex + targetElementSize;
        }
      }

      // 29. Return undefined.
      return realm.intrinsics.undefined;
    }
  });

  // ECMA262 22.2.3.24
  obj.defineNativeMethod("slice", 2, (context, [start, end]) => {
    // 1. Let O be the this value.
    let O = context;

    // 2. Perform ? ValidateTypedArray(O).
    (0, _typedarray.ValidateTypedArray)(realm, O);
    (0, _invariant2.default)(O instanceof _index.ObjectValue);

    // 3. Let len be O.[[ArrayLength]].
    let len = O.$ArrayLength;
    (0, _invariant2.default)(typeof len === "number");

    // 4. Let relativeStart be ? ToInteger(start).
    let relativeStart = _singletons.To.ToInteger(realm, start);

    // 5. If relativeStart < 0, let k be max((len + relativeStart), 0); else let k be min(relativeStart, len).
    let k = relativeStart < 0 ? Math.max(len + relativeStart, 0) : Math.min(relativeStart, len);

    // 6. If end is undefined, let relativeEnd be len; else let relativeEnd be ? ToInteger(end).
    let relativeEnd = !end || end instanceof _index.UndefinedValue ? len : _singletons.To.ToInteger(realm, end.throwIfNotConcrete());

    // 7. If relativeEnd < 0, let final be max((len + relativeEnd), 0); else let final be min(relativeEnd, len).
    let final = relativeEnd < 0 ? Math.max(len + relativeEnd, 0) : Math.min(relativeEnd, len);

    // 8. Let count be max(final - k, 0).
    let count = Math.max(final - k, 0);

    // 9. Let A be ? TypedArraySpeciesCreate(O, « count »).
    let A = (0, _typedarray.TypedArraySpeciesCreate)(realm, O, [new _index.NumberValue(realm, count)]);

    // 10. Let srcName be the String value of O.[[TypedArrayName]].
    let srcName = O.$TypedArrayName;
    (0, _invariant2.default)(typeof srcName === "string");

    // 11. Let srcType be the String value of the Element Type value in Table 50 for srcName.
    let srcType = _typedarray.ArrayElementType[srcName];

    // 12. Let targetName be the String value of A.[[TypedArrayName]].
    let targetName = A.$TypedArrayName;
    (0, _invariant2.default)(typeof targetName === "string");

    // 13. Let targetType be the String value of the Element Type value in Table 50 for targetName.
    let targetType = _typedarray.ArrayElementType[targetName];

    // 14. If SameValue(srcType, targetType) is false, then
    if (srcType !== targetType) {
      // a. Let n be 0.
      let n = 0;

      // b. Repeat, while k < final
      while (k < final) {
        // i. Let Pk be ! ToString(k).
        let Pk = _singletons.To.ToString(realm, new _index.NumberValue(realm, k));

        // ii. Let kValue be ? Get(O, Pk).
        let kValue = (0, _get.Get)(realm, O, Pk);

        // iii. Perform ! Set(A, ! ToString(n), kValue).
        _singletons.Properties.Set(realm, A, _singletons.To.ToString(realm, new _index.NumberValue(realm, n)), kValue, true);

        // iv. Increase k by 1.
        k += 1;

        // v. Increase n by 1.
        n += 1;
      }
    } else if (count > 0) {
      // 15. Else if count > 0, then
      // a. Let srcBuffer be O.[[ViewedArrayBuffer]].
      let srcBuffer = O.$ViewedArrayBuffer;
      (0, _invariant2.default)(srcBuffer);

      // b. If IsDetachedBuffer(srcBuffer) is true, throw a TypeError exception.
      if ((0, _is.IsDetachedBuffer)(realm, srcBuffer) === true) {
        throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "IsDetachedBuffer(srcBuffer) is true");
      }

      // c. Let targetBuffer be A.[[ViewedArrayBuffer]].
      let targetBuffer = A.$ViewedArrayBuffer;
      (0, _invariant2.default)(targetBuffer instanceof _index.ObjectValue);

      // d. Let elementSize be the Number value of the Element Size value specified in Table 50 for srcType.
      let elementSize = _types.ElementSize[srcType];

      // e. NOTE: If srcType and targetType are the same, the transfer must be performed in a manner that preserves the bit-level encoding of the source data.

      // f. Let srcByteOffset be O.[[ByteOffset]].
      let srcByteOffset = O.$ByteOffset;
      (0, _invariant2.default)(typeof srcByteOffset === "number");

      // g. Let targetByteIndex be A.[[ByteOffset]].
      let targetByteIndex = A.$ByteOffset;
      (0, _invariant2.default)(typeof targetByteIndex === "number");

      // h. Let srcByteIndex be (k × elementSize) + srcByteOffset.
      let srcByteIndex = k * elementSize + srcByteOffset;

      // i. Let limit be targetByteIndex + count × elementSize.
      let limit = targetByteIndex + count * elementSize;

      // j. Repeat, while targetByteIndex < limit
      while (targetByteIndex < limit) {
        // i. Let value be GetValueFromBuffer(srcBuffer, srcByteIndex, "Uint8").
        let value = (0, _arraybuffer.GetValueFromBuffer)(realm, srcBuffer, srcByteIndex, "Uint8");

        // ii. Perform SetValueInBuffer(targetBuffer, targetByteIndex, "Uint8", value).
        (0, _arraybuffer.SetValueInBuffer)(realm, targetBuffer, targetByteIndex, "Uint8", value.value);

        // iii. Increase srcByteIndex by 1.
        srcByteIndex += 1;

        // iv. Increase targetByteIndex by 1.
        targetByteIndex += 1;
      }
    }

    // 16. Return A.
    return A;
  });

  // ECMA262 22.2.3.25
  obj.defineNativeMethod("some", 1, (context, [callbackfn, thisArg]) => {
    // 1. Let O be ? ToObject(this value).
    let O = _singletons.To.ToObject(realm, context.throwIfNotConcrete());

    // 2. Perform ? ValidateTypedArray(O).
    (0, _typedarray.ValidateTypedArray)(realm, O);

    // 3. Let len be O.[[ArrayLength]].
    let len = O.$ArrayLength;
    (0, _invariant2.default)(typeof len === "number");

    // 4. If IsCallable(callbackfn) is false, throw a TypeError exception.
    if (!(0, _is.IsCallable)(realm, callbackfn)) {
      throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "callback passed to Array.prototype.some isn't callable");
    }

    // 5. If thisArg was supplied, let T be thisArg; else let T be undefined.
    let T = thisArg || realm.intrinsics.undefined;

    // 6. Let k be 0.
    let k = 0;

    // 7. Repeat, while k < len
    while (k < len) {
      // a. Let Pk be ! ToString(k).
      let Pk = new _index.StringValue(realm, k + "");

      // b. Let kPresent be ? HasProperty(O, Pk).
      let kPresent = (0, _has.HasProperty)(realm, O, Pk);

      // c. If kPresent is true, then
      if (kPresent) {
        // i. Let kValue be ? Get(O, Pk).
        let kValue = (0, _get.Get)(realm, O, Pk);

        // ii. Let testResult be ToBoolean(? Call(callbackfn, T, « kValue, k, O »)).
        let testResult = _singletons.To.ToBooleanPartial(realm, (0, _call.Call)(realm, callbackfn, T, [kValue, new _index.NumberValue(realm, k), O]));

        // iii. If testResult is true, return true.
        if (testResult) return realm.intrinsics.true;
      }

      // d. Increase k by 1.
      k++;
    }

    // 8. Return false.
    return realm.intrinsics.false;
  });

  // ECMA262 22.2.3.26
  obj.defineNativeMethod("sort", 1, (context, [comparefn]) => {
    // 1. Let obj be the this value.
    let O = _singletons.To.ToObject(realm, context.throwIfNotConcrete());

    // 2. Let buffer be ? ValidateTypedArray(obj).
    let buffer = (0, _typedarray.ValidateTypedArray)(realm, O);

    // 3. Let len be the value of obj's [[ArrayLength]] internal slot.
    let len = O.$ArrayLength;
    (0, _invariant2.default)(typeof len === "number");

    // 22.2.3.26 Runtime Semantics: SortCompare( x, y )#
    let SortCompare = (x, y) => {
      // 1. Assert: Both Type(x) and Type(y) is Number.
      (0, _invariant2.default)(x instanceof _index.NumberValue);
      (0, _invariant2.default)(y instanceof _index.NumberValue);

      // 2. If the argument comparefn is not undefined, then
      if (!comparefn.mightBeUndefined()) {
        // a. Let v be ? Call(comparefn, undefined, « x, y »).
        let v = (0, _call.Call)(realm, comparefn, realm.intrinsics.undefined, [x, y]);

        // b. If IsDetachedBuffer(buffer) is true, throw a TypeError exception.
        if ((0, _is.IsDetachedBuffer)(realm, buffer) === true) throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "array buffer has been detached");

        // c. If v is NaN, return +0.
        if (v instanceof _index.NumberValue && isNaN(v.value)) return realm.intrinsics.zero;

        // d. Return v.
        return v;
      }
      comparefn.throwIfNotConcrete();

      // If x and y are both NaN, return +0.
      // If x is NaN, return 1.
      if (isNaN(x.value)) {
        if (isNaN(y.value)) return realm.intrinsics.zero;
        return new _index.NumberValue(realm, 1);
      }

      // If y is NaN, return -1.
      if (isNaN(y.value)) return new _index.NumberValue(realm, -1);

      // If x < y, return -1.
      if (x.value < y.value) return new _index.NumberValue(realm, -1);

      // If x > y, return 1.
      if (x.value > y.value) return new _index.NumberValue(realm, +1);

      // If x is -0 and y is +0, return -1.
      if (Object.is(x.value, -0) && Object.is(y.value, +0)) return new _index.NumberValue(realm, -1);

      // If x is +0 and y is -0, return 1.
      if (Object.is(x.value, +0) && Object.is(y.value, -0)) return new _index.NumberValue(realm, 1);

      // Return +0.
      return realm.intrinsics.zero;
    };

    //1. Perform an implementation-dependent sequence of calls to the [[Get]] and [[Set]] internal methods of obj, to the DeletePropertyOrThrow and HasOwnProperty abstract operation with obj as the first argument, and to SortCompare (described below), such that:
    //   The property key argument for each call to [[Get]], [[Set]], HasOwnProperty, or DeletePropertyOrThrow is the string representation of a nonnegative integer less than len.

    // We leverage the underlying implementation sort by copying the element in a temp. array, sorting it, and
    // transfering back the value inside the our array.

    // We need to adapt the comparefn function to match the expected types
    let comparefn_ = (x, y) => {
      (0, _invariant2.default)(x instanceof _index.NumberValue, "Unexpected type");
      (0, _invariant2.default)(y instanceof _index.NumberValue, "Unexpected type");

      let result_ = SortCompare(x, y);
      let numb = _singletons.To.ToNumber(realm, result_);
      return numb;
    };

    let arr = [];
    for (let j = 0; j < len; j++) {
      let val = (0, _typedarray.IntegerIndexedElementGet)(realm, O, j);
      arr[j] = val;
    }

    arr.sort(comparefn_);

    //Apply the permutation back to the original array.
    for (let j = 0; j < len; j++) {
      (0, _typedarray.IntegerIndexedElementSet)(realm, O, j, arr[j]);
    }

    // 2. Return obj;
    return context;
  });

  // ECMA262 22.2.3.27
  obj.defineNativeMethod("subarray", 2, (context, [begin, end]) => {
    // 1. Let O be the this value.
    let O = context.throwIfNotConcrete();

    // 2. If Type(O) is not Object, throw a TypeError exception.
    if (!(O instanceof _index.ObjectValue)) {
      throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "Type(O) is not Object");
    }

    // 3. If O does not have a [[TypedArrayName]] internal slot, throw a TypeError exception.
    if (!("$TypedArrayName" in O)) {
      throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "O does not have a [[TypedArrayName]] internal slot");
    }

    // 4. Assert: O has a [[ViewedArrayBuffer]] internal slot.
    (0, _invariant2.default)(O.$ViewedArrayBuffer, "O has a [[ViewedArrayBuffer]] internal slot");

    // 5. Let buffer be O.[[ViewedArrayBuffer]].
    let buffer = O.$ViewedArrayBuffer;
    (0, _invariant2.default)(buffer);

    // 6. Let srcLength be O.[[ArrayLength]].
    let srcLength = O.$ArrayLength;
    (0, _invariant2.default)(typeof srcLength === "number");

    // 7. Let relativeBegin be ? ToInteger(begin).
    let relativeBegin = _singletons.To.ToInteger(realm, begin);

    // 8. If relativeBegin < 0, let beginIndex be max((srcLength + relativeBegin), 0); else let beginIndex be min(relativeBegin, srcLength).
    let beginIndex = relativeBegin < 0 ? Math.max(srcLength + relativeBegin, 0) : Math.min(relativeBegin, srcLength);

    // 9. If end is undefined, let relativeEnd be srcLength; else, let relativeEnd be ? ToInteger(end).
    let relativeEnd = !end || end instanceof _index.UndefinedValue ? srcLength : _singletons.To.ToInteger(realm, end.throwIfNotConcrete());

    // 10. If relativeEnd < 0, let endIndex be max((srcLength + relativeEnd), 0); else let endIndex be min(relativeEnd, srcLength).
    let endIndex = relativeEnd < 0 ? Math.max(srcLength + relativeEnd, 0) : Math.min(relativeEnd, srcLength);

    // 11. Let newLength be max(endIndex - beginIndex, 0).
    let newLength = Math.max(endIndex - beginIndex, 0);

    // 12. Let constructorName be the String value of O.[[TypedArrayName]].
    let constructorName = O.$TypedArrayName;
    (0, _invariant2.default)(typeof constructorName === "string");

    // 13. Let elementSize be the Number value of the Element Size value specified in Table 50 for constructorName.
    let elementSize = _typedarray.ArrayElementSize[constructorName];

    // 14. Let srcByteOffset be O.[[ByteOffset]].
    let srcByteOffset = O.$ByteOffset;
    (0, _invariant2.default)(typeof srcByteOffset === "number");

    // 15. Let beginByteOffset be srcByteOffset + beginIndex × elementSize.
    let beginByteOffset = srcByteOffset + beginIndex * elementSize;

    // 16. Let argumentsList be « buffer, beginByteOffset, newLength ».
    let argumentsList = [buffer, new _index.NumberValue(realm, beginByteOffset), new _index.NumberValue(realm, newLength)];

    // 17. Return ? TypedArraySpeciesCreate(O, argumentsList).
    return (0, _typedarray.TypedArraySpeciesCreate)(realm, O, argumentsList);
  });

  // ECMA262 22.2.3.28
  obj.defineNativeMethod("toLocaleString", 0, context => {
    // 1. Let array be ? ToObject(this value).
    let array = _singletons.To.ToObject(realm, context.throwIfNotConcrete());

    // 2. Perform ? ValidateTypedArray(array).
    (0, _typedarray.ValidateTypedArray)(realm, array);

    // 3. Let len be array.[[ArrayLength]].
    let len = array.$ArrayLength;
    (0, _invariant2.default)(typeof len === "number");

    // 4. Let separator be the String value for the list-separator String appropriate for the host environment's current locale (this is derived in an implementation-defined way).
    let separator = ",";

    // 5. If len is zero, return the empty String.
    if (len === 0) return realm.intrinsics.emptyString;

    // 6. Let firstElement be ? Get(array, "0").
    let firstElement = (0, _get.Get)(realm, array, "0");

    // 7. If firstElement is undefined or null, then
    let R;
    if ((0, _has.HasSomeCompatibleType)(firstElement, _index.UndefinedValue, _index.NullValue)) {
      // a. Let R be the empty String.
      R = "";
    } else {
      // 8. Else,
      // a. Let R be ? ToString(? Invoke(firstElement, "toLocaleString")).
      R = _singletons.To.ToStringPartial(realm, (0, _call.Invoke)(realm, firstElement, "toLocaleString"));
    }

    // 9. Let k be 1.
    let k = 1;

    // 10. Repeat, while k < len
    while (k < len) {
      // a. Let S be a String value produced by concatenating R and separator.
      let S = R + separator;

      // b. Let nextElement be ? Get(array, ! ToString(k)).
      let nextElement = (0, _get.Get)(realm, array, new _index.StringValue(realm, k + ""));

      // c. If nextElement is undefined or null, then
      if ((0, _has.HasSomeCompatibleType)(nextElement, _index.UndefinedValue, _index.NullValue)) {
        // i. Let R be the empty String.
        R = "";
      } else {
        // d. Else,
        // i. Let R be ? ToString(? Invoke(nextElement, "toLocaleString")).
        R = _singletons.To.ToStringPartial(realm, (0, _call.Invoke)(realm, nextElement, "toLocaleString"));
      }

      // e. Let R be a String value produced by concatenating S and R.
      R = S + R;

      // f. Increase k by 1.
      k++;
    }

    // 11. Return R.
    return new _index.StringValue(realm, R);
  });

  // ECMA262 22.2.3.29
  obj.defineNativeProperty("toString", realm.intrinsics.ArrayProto_toString);

  // ECMA262 22.2.3.30
  obj.defineNativeProperty("values", realm.intrinsics.TypedArrayProto_values);

  // ECMA262 22.2.3.31
  obj.defineNativeProperty(realm.intrinsics.SymbolIterator, realm.intrinsics.TypedArrayProto_values);

  // ECMA262 22.2.3.32
  obj.defineNativeGetter(realm.intrinsics.SymbolToStringTag, context => {
    // 1. Let O be the this value.
    let O = context.throwIfNotConcrete();

    // 2. If Type(O) is not Object, return undefined.
    if (!(O instanceof _index.ObjectValue)) return realm.intrinsics.undefined;

    // 3. If O does not have a [[TypedArrayName]] internal slot, return undefined.
    if (!("$TypedArrayName" in O)) return realm.intrinsics.undefined;

    // 4. Let name be O.[[TypedArrayName]].
    let name = O.$TypedArrayName;

    // 5. Assert: name is a String value.
    (0, _invariant2.default)(typeof name === "string", "name is a String value");

    // 6. Return name.
    return new _index.StringValue(realm, name);
  });
};

exports.build = build;

var _types = __webpack_require__(221);

var _index = __webpack_require__(0);

var _call = __webpack_require__(20);

var _get = __webpack_require__(11);

var _has = __webpack_require__(27);

var _is = __webpack_require__(9);

var _typedarray = __webpack_require__(161);

var _arraybuffer = __webpack_require__(92);

var _abstract = __webpack_require__(19);

var _singletons = __webpack_require__(2);

var _invariant = __webpack_require__(1);

var _invariant2 = _interopRequireDefault(_invariant);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 */

function build(realm, obj, type) {
  // ECMA262 22.2.6
  obj.$Prototype = realm.intrinsics.TypedArrayPrototype;

  // ECMA262 22.2.6.1
  obj.defineNativeConstant("BYTES_PER_ELEMENT", new _index.NumberValue(realm, _types.ElementSize[type]));
}

/***/ }),
/* 48 */
/***/ (function(module, exports, __webpack_require__) {

// This module was originally created so that Recast could add its own
// custom types to the AST type system (in particular, the File type), but
// those types are now incorporated into ast-types, so this module doesn't
// have much to do anymore. Still, it might prove useful in the future.
module.exports = __webpack_require__(484);


/***/ }),
/* 49 */
/***/ (function(module, exports) {

// https://github.com/zloirock/core-js/issues/86#issuecomment-115759028
var global = module.exports = typeof window != 'undefined' && window.Math == Math
  ? window : typeof self != 'undefined' && self.Math == Math ? self
  // eslint-disable-next-line no-new-func
  : Function('return this')();
if (typeof __g == 'number') __g = global; // eslint-disable-line no-undef


/***/ }),
/* 50 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


module.exports = __webpack_require__(591)() ? Symbol : __webpack_require__(592);


/***/ }),
/* 51 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


module.exports = function (fn) {
	if (typeof fn !== "function") throw new TypeError(fn + " is not a function");
	return fn;
};


/***/ }),
/* 52 */
/***/ (function(module, exports, __webpack_require__) {

var anObject = __webpack_require__(53);
var IE8_DOM_DEFINE = __webpack_require__(305);
var toPrimitive = __webpack_require__(183);
var dP = Object.defineProperty;

exports.f = __webpack_require__(54) ? Object.defineProperty : function defineProperty(O, P, Attributes) {
  anObject(O);
  P = toPrimitive(P, true);
  anObject(Attributes);
  if (IE8_DOM_DEFINE) try {
    return dP(O, P, Attributes);
  } catch (e) { /* empty */ }
  if ('get' in Attributes || 'set' in Attributes) throw TypeError('Accessors not supported!');
  if ('value' in Attributes) O[P] = Attributes.value;
  return O;
};


/***/ }),
/* 53 */
/***/ (function(module, exports, __webpack_require__) {

var isObject = __webpack_require__(32);
module.exports = function (it) {
  if (!isObject(it)) throw TypeError(it + ' is not an object!');
  return it;
};


/***/ }),
/* 54 */
/***/ (function(module, exports, __webpack_require__) {

// Thank's IE8 for his funny defineProperty
module.exports = !__webpack_require__(62)(function () {
  return Object.defineProperty({}, 'a', { get: function () { return 7; } }).a != 7;
});


/***/ }),
/* 55 */
/***/ (function(module, exports) {

/* WEBPACK VAR INJECTION */(function(__webpack_amd_options__) {/* globals __webpack_amd_options__ */
module.exports = __webpack_amd_options__;

/* WEBPACK VAR INJECTION */}.call(exports, {}))

/***/ }),
/* 56 */
/***/ (function(module, exports, __webpack_require__) {

module.exports = function (fork) {
    var exports = {};
    var types = fork.use(__webpack_require__(22));
    var Type = types.Type;
    var builtin = types.builtInTypes;
    var isNumber = builtin.number;

    // An example of constructing a new type with arbitrary constraints from
    // an existing type.
    exports.geq = function (than) {
        return new Type(function (value) {
            return isNumber.check(value) && value >= than;
        }, isNumber + " >= " + than);
    };

    // Default value-returning functions that may optionally be passed as a
    // third argument to Def.prototype.field.
    exports.defaults = {
        // Functions were used because (among other reasons) that's the most
        // elegant way to allow for the emptyArray one always to give a new
        // array instance.
        "null": function () { return null },
        "emptyArray": function () { return [] },
        "false": function () { return false },
        "true": function () { return true },
        "undefined": function () {}
    };

    var naiveIsPrimitive = Type.or(
      builtin.string,
      builtin.number,
      builtin.boolean,
      builtin.null,
      builtin.undefined
    );

    exports.isPrimitive = new Type(function (value) {
        if (value === null)
            return true;
        var type = typeof value;
        return !(type === "object" ||
        type === "function");
    }, naiveIsPrimitive.toString());

    return exports;
};

/***/ }),
/* 57 */
/***/ (function(module, exports) {

module.exports = function (it) {
  return typeof it === 'object' ? it !== null : typeof it === 'function';
};


/***/ }),
/* 58 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @abstract BaseSyntax
 */
var BaseSyntax =
/**
 * The constructor of BaseSyntax
 *
 * @param {String} type
 */
function BaseSyntax(type) {
  _classCallCheck(this, BaseSyntax);

  this.type = type;
};

exports.default = BaseSyntax;
module.exports = exports["default"];

/***/ }),
/* 59 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var assign        = __webpack_require__(176)
  , normalizeOpts = __webpack_require__(285)
  , isCallable    = __webpack_require__(587)
  , contains      = __webpack_require__(286)

  , d;

d = module.exports = function (dscr, value/*, options*/) {
	var c, e, w, options, desc;
	if ((arguments.length < 2) || (typeof dscr !== 'string')) {
		options = value;
		value = dscr;
		dscr = null;
	} else {
		options = arguments[2];
	}
	if (dscr == null) {
		c = w = true;
		e = false;
	} else {
		c = contains.call(dscr, 'c');
		e = contains.call(dscr, 'e');
		w = contains.call(dscr, 'w');
	}

	desc = { value: value, configurable: c, enumerable: e, writable: w };
	return !options ? desc : assign(normalizeOpts(options), desc);
};

d.gs = function (dscr, get, set/*, options*/) {
	var c, e, options, desc;
	if (typeof dscr !== 'string') {
		options = set;
		set = get;
		get = dscr;
		dscr = null;
	} else {
		options = arguments[3];
	}
	if (get == null) {
		get = undefined;
	} else if (!isCallable(get)) {
		options = get;
		get = set = undefined;
	} else if (set == null) {
		set = undefined;
	} else if (!isCallable(set)) {
		options = set;
		set = undefined;
	}
	if (dscr == null) {
		c = true;
		e = false;
	} else {
		c = contains.call(dscr, 'c');
		e = contains.call(dscr, 'e');
	}

	desc = { get: get, set: set, configurable: c, enumerable: e };
	return !options ? desc : assign(normalizeOpts(options), desc);
};


/***/ }),
/* 60 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _iterator = __webpack_require__(657);

var _iterator2 = _interopRequireDefault(_iterator);

var _symbol = __webpack_require__(309);

var _symbol2 = _interopRequireDefault(_symbol);

var _typeof = typeof _symbol2.default === "function" && typeof _iterator2.default === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof _symbol2.default === "function" && obj.constructor === _symbol2.default && obj !== _symbol2.default.prototype ? "symbol" : typeof obj; };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = typeof _symbol2.default === "function" && _typeof(_iterator2.default) === "symbol" ? function (obj) {
  return typeof obj === "undefined" ? "undefined" : _typeof(obj);
} : function (obj) {
  return obj && typeof _symbol2.default === "function" && obj.constructor === _symbol2.default && obj !== _symbol2.default.prototype ? "symbol" : typeof obj === "undefined" ? "undefined" : _typeof(obj);
};

/***/ }),
/* 61 */
/***/ (function(module, exports, __webpack_require__) {

var dP = __webpack_require__(52);
var createDesc = __webpack_require__(138);
module.exports = __webpack_require__(54) ? function (object, key, value) {
  return dP.f(object, key, createDesc(1, value));
} : function (object, key, value) {
  object[key] = value;
  return object;
};


/***/ }),
/* 62 */
/***/ (function(module, exports) {

module.exports = function (exec) {
  try {
    return !!exec();
  } catch (e) {
    return true;
  }
};


/***/ }),
/* 63 */
/***/ (function(module, exports) {

var hasOwnProperty = {}.hasOwnProperty;
module.exports = function (it, key) {
  return hasOwnProperty.call(it, key);
};


/***/ }),
/* 64 */
/***/ (function(module, exports, __webpack_require__) {

var Symbol = __webpack_require__(112),
    getRawTag = __webpack_require__(724),
    objectToString = __webpack_require__(725);

/** `Object#toString` result references. */
var nullTag = '[object Null]',
    undefinedTag = '[object Undefined]';

/** Built-in value references. */
var symToStringTag = Symbol ? Symbol.toStringTag : undefined;

/**
 * The base implementation of `getTag` without fallbacks for buggy environments.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the `toStringTag`.
 */
function baseGetTag(value) {
  if (value == null) {
    return value === undefined ? undefinedTag : nullTag;
  }
  return (symToStringTag && symToStringTag in Object(value))
    ? getRawTag(value)
    : objectToString(value);
}

module.exports = baseGetTag;


/***/ }),
/* 65 */
/***/ (function(module, exports) {

/**
 * Checks if `value` is the
 * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)
 * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an object, else `false`.
 * @example
 *
 * _.isObject({});
 * // => true
 *
 * _.isObject([1, 2, 3]);
 * // => true
 *
 * _.isObject(_.noop);
 * // => true
 *
 * _.isObject(null);
 * // => false
 */
function isObject(value) {
  var type = typeof value;
  return value != null && (type == 'object' || type == 'function');
}

module.exports = isObject;


/***/ }),
/* 66 */
/***/ (function(module, exports, __webpack_require__) {

var arrayLikeKeys = __webpack_require__(334),
    baseKeys = __webpack_require__(753),
    isArrayLike = __webpack_require__(67);

/**
 * Creates an array of the own enumerable property names of `object`.
 *
 * **Note:** Non-object values are coerced to objects. See the
 * [ES spec](http://ecma-international.org/ecma-262/7.0/#sec-object.keys)
 * for more details.
 *
 * @static
 * @since 0.1.0
 * @memberOf _
 * @category Object
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 * @example
 *
 * function Foo() {
 *   this.a = 1;
 *   this.b = 2;
 * }
 *
 * Foo.prototype.c = 3;
 *
 * _.keys(new Foo);
 * // => ['a', 'b'] (iteration order is not guaranteed)
 *
 * _.keys('hi');
 * // => ['0', '1']
 */
function keys(object) {
  return isArrayLike(object) ? arrayLikeKeys(object) : baseKeys(object);
}

module.exports = keys;


/***/ }),
/* 67 */
/***/ (function(module, exports, __webpack_require__) {

var isFunction = __webpack_require__(322),
    isLength = __webpack_require__(208);

/**
 * Checks if `value` is array-like. A value is considered array-like if it's
 * not a function and has a `value.length` that's an integer greater than or
 * equal to `0` and less than or equal to `Number.MAX_SAFE_INTEGER`.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is array-like, else `false`.
 * @example
 *
 * _.isArrayLike([1, 2, 3]);
 * // => true
 *
 * _.isArrayLike(document.body.children);
 * // => true
 *
 * _.isArrayLike('abc');
 * // => true
 *
 * _.isArrayLike(_.noop);
 * // => false
 */
function isArrayLike(value) {
  return value != null && isLength(value.length) && !isFunction(value);
}

module.exports = isArrayLike;


/***/ }),
/* 68 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;
exports.DEPRECATED_KEYS = exports.BUILDER_KEYS = exports.NODE_FIELDS = exports.ALIAS_KEYS = exports.VISITOR_KEYS = undefined;

var _getIterator2 = __webpack_require__(13);

var _getIterator3 = _interopRequireDefault(_getIterator2);

var _stringify = __webpack_require__(108);

var _stringify2 = _interopRequireDefault(_stringify);

var _typeof2 = __webpack_require__(60);

var _typeof3 = _interopRequireDefault(_typeof2);

exports.assertEach = assertEach;
exports.assertOneOf = assertOneOf;
exports.assertNodeType = assertNodeType;
exports.assertNodeOrValueType = assertNodeOrValueType;
exports.assertValueType = assertValueType;
exports.chain = chain;
exports.default = defineType;

var _index = __webpack_require__(4);

var t = _interopRequireWildcard(_index);

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var VISITOR_KEYS = exports.VISITOR_KEYS = {};
var ALIAS_KEYS = exports.ALIAS_KEYS = {};
var NODE_FIELDS = exports.NODE_FIELDS = {};
var BUILDER_KEYS = exports.BUILDER_KEYS = {};
var DEPRECATED_KEYS = exports.DEPRECATED_KEYS = {};

function getType(val) {
  if (Array.isArray(val)) {
    return "array";
  } else if (val === null) {
    return "null";
  } else if (val === undefined) {
    return "undefined";
  } else {
    return typeof val === "undefined" ? "undefined" : (0, _typeof3.default)(val);
  }
}

function assertEach(callback) {
  function validator(node, key, val) {
    if (!Array.isArray(val)) return;

    for (var i = 0; i < val.length; i++) {
      callback(node, key + "[" + i + "]", val[i]);
    }
  }
  validator.each = callback;
  return validator;
}

function assertOneOf() {
  for (var _len = arguments.length, vals = Array(_len), _key = 0; _key < _len; _key++) {
    vals[_key] = arguments[_key];
  }

  function validate(node, key, val) {
    if (vals.indexOf(val) < 0) {
      throw new TypeError("Property " + key + " expected value to be one of " + (0, _stringify2.default)(vals) + " but got " + (0, _stringify2.default)(val));
    }
  }

  validate.oneOf = vals;

  return validate;
}

function assertNodeType() {
  for (var _len2 = arguments.length, types = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
    types[_key2] = arguments[_key2];
  }

  function validate(node, key, val) {
    var valid = false;

    for (var _iterator = types, _isArray = Array.isArray(_iterator), _i = 0, _iterator = _isArray ? _iterator : (0, _getIterator3.default)(_iterator);;) {
      var _ref;

      if (_isArray) {
        if (_i >= _iterator.length) break;
        _ref = _iterator[_i++];
      } else {
        _i = _iterator.next();
        if (_i.done) break;
        _ref = _i.value;
      }

      var type = _ref;

      if (t.is(type, val)) {
        valid = true;
        break;
      }
    }

    if (!valid) {
      throw new TypeError("Property " + key + " of " + node.type + " expected node to be of a type " + (0, _stringify2.default)(types) + " " + ("but instead got " + (0, _stringify2.default)(val && val.type)));
    }
  }

  validate.oneOfNodeTypes = types;

  return validate;
}

function assertNodeOrValueType() {
  for (var _len3 = arguments.length, types = Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
    types[_key3] = arguments[_key3];
  }

  function validate(node, key, val) {
    var valid = false;

    for (var _iterator2 = types, _isArray2 = Array.isArray(_iterator2), _i2 = 0, _iterator2 = _isArray2 ? _iterator2 : (0, _getIterator3.default)(_iterator2);;) {
      var _ref2;

      if (_isArray2) {
        if (_i2 >= _iterator2.length) break;
        _ref2 = _iterator2[_i2++];
      } else {
        _i2 = _iterator2.next();
        if (_i2.done) break;
        _ref2 = _i2.value;
      }

      var type = _ref2;

      if (getType(val) === type || t.is(type, val)) {
        valid = true;
        break;
      }
    }

    if (!valid) {
      throw new TypeError("Property " + key + " of " + node.type + " expected node to be of a type " + (0, _stringify2.default)(types) + " " + ("but instead got " + (0, _stringify2.default)(val && val.type)));
    }
  }

  validate.oneOfNodeOrValueTypes = types;

  return validate;
}

function assertValueType(type) {
  function validate(node, key, val) {
    var valid = getType(val) === type;

    if (!valid) {
      throw new TypeError("Property " + key + " expected type of " + type + " but got " + getType(val));
    }
  }

  validate.type = type;

  return validate;
}

function chain() {
  for (var _len4 = arguments.length, fns = Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
    fns[_key4] = arguments[_key4];
  }

  function validate() {
    for (var _iterator3 = fns, _isArray3 = Array.isArray(_iterator3), _i3 = 0, _iterator3 = _isArray3 ? _iterator3 : (0, _getIterator3.default)(_iterator3);;) {
      var _ref3;

      if (_isArray3) {
        if (_i3 >= _iterator3.length) break;
        _ref3 = _iterator3[_i3++];
      } else {
        _i3 = _iterator3.next();
        if (_i3.done) break;
        _ref3 = _i3.value;
      }

      var fn = _ref3;

      fn.apply(undefined, arguments);
    }
  }
  validate.chainOf = fns;
  return validate;
}

function defineType(type) {
  var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

  var inherits = opts.inherits && store[opts.inherits] || {};

  opts.fields = opts.fields || inherits.fields || {};
  opts.visitor = opts.visitor || inherits.visitor || [];
  opts.aliases = opts.aliases || inherits.aliases || [];
  opts.builder = opts.builder || inherits.builder || opts.visitor || [];

  if (opts.deprecatedAlias) {
    DEPRECATED_KEYS[opts.deprecatedAlias] = type;
  }

  for (var _iterator4 = opts.visitor.concat(opts.builder), _isArray4 = Array.isArray(_iterator4), _i4 = 0, _iterator4 = _isArray4 ? _iterator4 : (0, _getIterator3.default)(_iterator4);;) {
    var _ref4;

    if (_isArray4) {
      if (_i4 >= _iterator4.length) break;
      _ref4 = _iterator4[_i4++];
    } else {
      _i4 = _iterator4.next();
      if (_i4.done) break;
      _ref4 = _i4.value;
    }

    var _key5 = _ref4;

    opts.fields[_key5] = opts.fields[_key5] || {};
  }

  for (var key in opts.fields) {
    var field = opts.fields[key];

    if (opts.builder.indexOf(key) === -1) {
      field.optional = true;
    }
    if (field.default === undefined) {
      field.default = null;
    } else if (!field.validate) {
      field.validate = assertValueType(getType(field.default));
    }
  }

  VISITOR_KEYS[type] = opts.visitor;
  BUILDER_KEYS[type] = opts.builder;
  NODE_FIELDS[type] = opts.fields;
  ALIAS_KEYS[type] = opts.aliases;

  store[type] = opts;
}

var store = {};

/***/ }),
/* 69 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Modules = exports.ModuleTracer = undefined;

var _environment = __webpack_require__(8);

var _errors = __webpack_require__(6);

var _realm = __webpack_require__(7);

var _index = __webpack_require__(5);

var _completions = __webpack_require__(3);

var _singletons = __webpack_require__(2);

var _index2 = __webpack_require__(0);

var _babelTypes = __webpack_require__(4);

var t = _interopRequireWildcard(_babelTypes);

var _invariant = __webpack_require__(1);

var _invariant2 = _interopRequireDefault(_invariant);

var _logger = __webpack_require__(44);

var _types = __webpack_require__(37);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

function downgradeErrorsToWarnings(realm, f) {
  let savedHandler = realm.errorHandler;
  function handler(e) {
    e.severity = "Warning";
    realm.errorHandler = savedHandler;
    try {
      return realm.handleError(e);
    } finally {
      realm.errorHandler = handler;
    }
  }
  realm.errorHandler = handler;
  try {
    return f();
  } finally {
    realm.errorHandler = savedHandler;
  }
} /**
   * Copyright (c) 2017-present, Facebook, Inc.
   * All rights reserved.
   *
   * This source code is licensed under the BSD-style license found in the
   * LICENSE file in the root directory of this source tree. An additional grant
   * of patent rights can be found in the PATENTS file in the same directory.
   */

class ModuleTracer extends _realm.Tracer {
  constructor(modules, statistics, logModules) {
    super();
    this.modules = modules;
    this.evaluateForEffectsNesting = 0;
    this.requireStack = [];
    this.requireSequence = [];
    this.logModules = logModules;
    this.uninitializedModuleIdsRequiredInEvaluateForEffects = new Set();
    this.statistics = statistics;
  }
  // We can't say that a module has been initialized if it was initialized in a
  // evaluate for effects context until we know the effects are applied.


  log(message) {
    if (this.logModules) console.log(`[modules] ${this.requireStack.map(_ => "  ").join("")}${message}`);
  }

  beginEvaluateForEffects(state) {
    if (state !== this) {
      this.log(">evaluate for effects");
      this.evaluateForEffectsNesting++;
      this.requireStack.push(undefined);
    }
  }

  endEvaluateForEffects(state, effects) {
    if (state !== this) {
      let popped = this.requireStack.pop();
      (0, _invariant2.default)(popped === undefined);
      this.evaluateForEffectsNesting--;
      this.log("<evaluate for effects");
    }
  }

  // If we don't delay unsupported requires, we simply want to record here
  // when a module gets initialized, and then we return.
  _callRequireAndRecord(moduleIdValue, performCall) {
    let realm = this.modules.realm;
    if ((this.requireStack.length === 0 || this.requireStack[this.requireStack.length - 1] !== moduleIdValue) && this.modules.moduleIds.has(moduleIdValue)) {
      this.requireStack.push(moduleIdValue);
      try {
        let value = performCall();
        // Make this into a join point by suppressing the conditional exception.
        // TODO: delete this code and let the caller deal with the conditional exception.
        let completion = _singletons.Functions.incorporateSavedCompletion(realm, value);
        if (completion instanceof _completions.PossiblyNormalCompletion) {
          realm.stopEffectCapture(completion);
          let warning = new _errors.CompilerDiagnostic("Module import may fail with an exception", completion.location, "PP0018", "Warning");
          realm.handleError(warning);
        } else {
          this.modules.recordModuleInitialized(moduleIdValue, value);
        }
        return value;
      } finally {
        (0, _invariant2.default)(this.requireStack.pop() === moduleIdValue);
      }
    }
    return undefined;
  }

  _callRequireAndAccelerate(isTopLevelRequire, moduleIdValue, performCall) {
    let realm = this.modules.realm;
    let acceleratedModuleIds, effects;
    do {
      try {
        effects = realm.evaluateForEffects(() => performCall(), this);
      } catch (e) {
        e;
      }

      acceleratedModuleIds = [];
      if (isTopLevelRequire && effects !== undefined && !(effects[0] instanceof _completions.AbruptCompletion)) {
        // We gathered all effects, but didn't apply them yet.
        // Let's check if there was any call to `require` in a
        // evaluate-for-effects context. If so, try to initialize
        // that module right now. Acceleration module initialization in this
        // way might not actually be desirable, but it works around
        // general prepack-limitations around joined abstract values involving
        // conditionals. Long term, Prepack needs to implement a notion of refinement
        // of conditional abstract values under the known path condition.
        // Example:
        //   if (*) require(1); else require(2);
        //   let x = require(1).X;
        // =>
        //   require(1);
        //   require(2);
        //   if (*) require(1); else require(2);
        //   let x = require(1).X;

        for (let nestedModuleId of this.uninitializedModuleIdsRequiredInEvaluateForEffects) {
          let nestedEffects = this.modules.tryInitializeModule(nestedModuleId, `accelerated initialization of conditional module ${nestedModuleId} as it's required in an evaluate-for-effects context by module ${moduleIdValue}`);
          if (this.modules.accelerateUnsupportedRequires && nestedEffects !== undefined && nestedEffects[0] instanceof _index2.Value && this.modules.isModuleInitialized(nestedModuleId)) {
            acceleratedModuleIds.push(nestedModuleId);
          }
        }
        this.uninitializedModuleIdsRequiredInEvaluateForEffects.clear();
        // Keep restarting for as long as we find additional modules to accelerate.
        if (acceleratedModuleIds.length > 0) {
          console.log(`restarting require(${moduleIdValue}) after accelerating conditional require calls for ${acceleratedModuleIds.join()}`);
          this.statistics.acceleratedModules += acceleratedModuleIds.length;
        }
      }
    } while (acceleratedModuleIds.length > 0);

    return effects;
  }

  // If a require fails, recover from it and delay the factory call until runtime
  // Also, only in this mode, consider "accelerating" require calls, see below.
  _callRequireAndDelayIfNeeded(moduleIdValue, performCall) {
    let realm = this.modules.realm;
    this.log(`>require(${moduleIdValue})`);
    let isTopLevelRequire = this.requireStack.length === 0;
    if (this.evaluateForEffectsNesting > 0) {
      if (isTopLevelRequire) {
        let diagnostic = new _errors.CompilerDiagnostic("Non-deterministically conditional top-level require not currently supported", realm.currentLocation, "PP0017", "FatalError");
        realm.handleError(diagnostic);
        throw new _errors.FatalError();
      } else if (!this.modules.isModuleInitialized(moduleIdValue))
        // Nested require call: We record that this happened. Just so that
        // if we discover later this this require call needs to get delayed,
        // then we still know (some of) which modules it in turn required,
        // and then we'll later "accelerate" requiring them to preserve the
        // require ordering. See below for more details on acceleration.
        this.uninitializedModuleIdsRequiredInEvaluateForEffects.add(moduleIdValue);

      return undefined;
    } else {
      return downgradeErrorsToWarnings(realm, () => {
        let result;
        try {
          this.requireStack.push(moduleIdValue);
          let requireSequenceStart = this.requireSequence.length;
          this.requireSequence.push(moduleIdValue);
          const previousNumDelayedModules = this.statistics.delayedModules;
          let effects = this._callRequireAndAccelerate(isTopLevelRequire, moduleIdValue, performCall);
          if (effects === undefined || effects[0] instanceof _completions.AbruptCompletion) {
            console.log(`delaying require(${moduleIdValue})`);
            this.statistics.delayedModules = previousNumDelayedModules + 1;
            // So we are about to emit a delayed require(...) call.
            // However, before we do that, let's try to require all modules that we
            // know this delayed require call will require.
            // This way, we ensure that those modules will be fully initialized
            // before the require call executes.
            // TODO #690: More needs to be done to make the delayUnsupportedRequires
            // feature completely safe. Open issues are:
            // 1) Side-effects on the heap of delayed factory functions are not discovered or rejected.
            // 2) While we do process an appropriate list of transitively required modules here,
            //    it's likely just a subset / prefix of all transivitely required modules, as
            //    more modules would have been required if the Introspection exception had not been thrown.
            //    To be correct, those modules would have to be prepacked here as well.
            //    TODO #798: Watch out for an upcoming change to the __d module declaration where the statically known
            //    list of dependencies will be announced, so we'll no longer have to guess.
            let nestedModulesIds = new Set();
            for (let i = requireSequenceStart; i < this.requireSequence.length; i++) {
              let nestedModuleId = this.requireSequence[i];
              if (nestedModulesIds.has(nestedModuleId)) continue;
              nestedModulesIds.add(nestedModuleId);
              this.modules.tryInitializeModule(nestedModuleId, `initialization of module ${nestedModuleId} as it's required by module ${moduleIdValue}`);
            }

            result = _index2.AbstractValue.createTemporalFromBuildFunction(realm, _index2.Value, [], ([]) => t.callExpression(t.identifier("require"), [t.valueToNode(moduleIdValue)]));
          } else {
            result = effects[0];
            if (result instanceof _index2.Value) {
              realm.applyEffects(effects, `initialization of module ${moduleIdValue}`);
              this.modules.recordModuleInitialized(moduleIdValue, result);
            } else if (result instanceof _completions.PossiblyNormalCompletion) {
              let warning = new _errors.CompilerDiagnostic("Module import may fail with an exception", result.location, "PP0018", "Warning");
              realm.handleError(warning);
              result = result.value;
              realm.applyEffects(effects, `initialization of module ${moduleIdValue}`);
            } else {
              (0, _invariant2.default)(false);
            }
          }
        } finally {
          let popped = this.requireStack.pop();
          (0, _invariant2.default)(popped === moduleIdValue);
          this.log(`<require(${moduleIdValue})`);
        }
        (0, _invariant2.default)(result instanceof _index2.Value);
        return result;
      });
    }
  }

  _tryExtractDependencies(value) {
    if (value === undefined || value instanceof _index2.NullValue || value instanceof _index2.UndefinedValue) return [];
    if (value instanceof _index2.ArrayValue) {
      const realm = this.modules.realm;
      const lengthValue = (0, _index.Get)(realm, value, "length");
      if (lengthValue instanceof _index2.NumberValue) {
        const dependencies = [];
        const logger = this.modules.logger;
        for (let i = 0; i < lengthValue.value; i++) {
          const elementValue = logger.tryQuery(() => (0, _index.Get)(realm, value, "" + i), realm.intrinsics.undefined);
          dependencies.push(elementValue);
        }
        return dependencies;
      }
    }
    return undefined;
  }

  detourCall(F, thisArgument, argumentsList, newTarget, performCall) {
    if (F === this.modules.getRequire() && !this.modules.disallowDelayingRequiresOverride && argumentsList.length === 1) {
      // Here, we handle calls of the form
      //   require(42)

      let moduleId = argumentsList[0];
      let moduleIdValue;
      // Do some sanity checks and request require(...) calls with bad arguments
      if (moduleId instanceof _index2.NumberValue || moduleId instanceof _index2.StringValue) {
        moduleIdValue = moduleId.value;
        if (!this.modules.moduleIds.has(moduleIdValue) && this.modules.delayUnsupportedRequires) {
          this.modules.logger.logError(moduleId, "Module referenced by require call has not been defined.");
        }
      } else {
        if (this.modules.delayUnsupportedRequires) {
          this.modules.logger.logError(moduleId, "First argument to require function is not a number or string value.");
        }
        return undefined;
      }

      if (this.modules.delayUnsupportedRequires) return this._callRequireAndDelayIfNeeded(moduleIdValue, performCall);else return this._callRequireAndRecord(moduleIdValue, performCall);
    } else if (F === this.modules.getDefine()) {
      // Here, we handle calls of the form
      //   __d(factoryFunction, moduleId, dependencyArray)

      if (this.evaluateForEffectsNesting !== 0) this.modules.logger.logError(F, "Defining a module in nested partial evaluation is not supported.");
      let factoryFunction = argumentsList[0];
      if (factoryFunction instanceof _index2.FunctionValue) {
        let dependencies = this._tryExtractDependencies(argumentsList[2]);
        if (dependencies !== undefined) this.modules.factoryFunctionDependencies.set(factoryFunction, dependencies);else this.modules.logger.logError(argumentsList[2], "Third argument to define function is present but not a concrete array.");
      } else this.modules.logger.logError(factoryFunction, "First argument to define function is not a function value.");
      let moduleId = argumentsList[1];
      if (moduleId instanceof _index2.NumberValue || moduleId instanceof _index2.StringValue) this.modules.moduleIds.add(moduleId.value);else this.modules.logger.logError(moduleId, "Second argument to define function is not a number or string value.");
    }
    return undefined;
  }
}

exports.ModuleTracer = ModuleTracer;
class Modules {
  constructor(realm, logger, statistics, logModules, delayUnsupportedRequires, accelerateUnsupportedRequires) {
    this.realm = realm;
    this.logger = logger;
    this._require = realm.intrinsics.undefined;
    this._define = realm.intrinsics.undefined;
    this.factoryFunctionDependencies = new Map();
    this.moduleIds = new Set();
    this.initializedModules = new Map();
    realm.tracers.push(this.moduleTracer = new ModuleTracer(this, statistics, logModules));
    this.delayUnsupportedRequires = delayUnsupportedRequires;
    this.accelerateUnsupportedRequires = accelerateUnsupportedRequires;
    this.disallowDelayingRequiresOverride = false;
  }

  resolveInitializedModules() {
    this.initializedModules.clear();
    let globalInitializedModulesMap = this._getGlobalProperty("__initializedModules");
    (0, _invariant2.default)(globalInitializedModulesMap instanceof _index2.ObjectValue);
    for (let moduleId of globalInitializedModulesMap.properties.keys()) {
      let property = globalInitializedModulesMap.properties.get(moduleId);
      (0, _invariant2.default)(property);
      let moduleValue = property.descriptor && property.descriptor.value;
      if (moduleValue instanceof _index2.Value) this.initializedModules.set(moduleId, moduleValue);
    }
  }

  _getGlobalProperty(name) {
    if (this.active) return this.realm.intrinsics.undefined;
    this.active = true;
    try {
      let realm = this.realm;
      return this.logger.tryQuery(() => (0, _index.Get)(realm, realm.$GlobalObject, name), realm.intrinsics.undefined);
    } finally {
      this.active = false;
    }
  }

  getRequire() {
    if (!(this._require instanceof _index2.FunctionValue)) this._require = this._getGlobalProperty("require");
    return this._require;
  }

  getDefine() {
    if (!(this._define instanceof _index2.FunctionValue)) this._define = this._getGlobalProperty("__d");
    return this._define;
  }

  // Returns a function that checks if a call node represents a call to a
  // known require function, and if so, what module id that call indicates.
  // A known require function call is either of the form
  //   ... require(42) ...
  // where require resolves to the global require function, or
  //   factoryFunction(, require, , , dependencies) {
  //     ...
  //       ... require(dependencies[3]) ...
  // where factoryFunction and dependencies were announced as part of the
  // global code execution via a global module declaration call such as
  //   global.__d(factoryFunction, , [0,2,4,6,8])
  getGetModuleIdIfNodeIsRequireFunction(formalParameters, functions) {
    let realm = this.realm;
    let logger = this.logger;
    let modules = this;
    return (scope, node) => {
      // Are we calling a function that has a single name and a single argument?
      if (!t.isIdentifier(node.callee) || node.arguments.length !== 1) return undefined;
      let argument = node.arguments[0];
      if (!argument) return undefined;

      if (!t.isNumericLiteral(argument) && !t.isStringLiteral(argument) && !t.isMemberExpression(argument)) return undefined;

      (0, _invariant2.default)(node.callee);
      let innerName = node.callee.name;

      let moduleId;

      // Helper function used to give up if we ever come up with different module ids for different functions
      let updateModuleId = newModuleId => {
        if (moduleId !== undefined && moduleId !== newModuleId) return false;
        moduleId = newModuleId;
        return true;
      };

      // Helper function that retrieves module id from call argument, possibly chasing dependency array indirection
      const getModuleId = dependencies => {
        if (t.isMemberExpression(argument)) {
          if (dependencies !== undefined) {
            let memberExpression = argument;
            if (t.isIdentifier(memberExpression.object)) {
              let scopedBinding = scope.getBinding(memberExpression.object.name);
              if (scopedBinding && formalParameters[4] === scopedBinding.path.node) {
                if (t.isNumericLiteral(memberExpression.property)) {
                  let dependencyIndex = memberExpression.property.value;
                  if (Number.isInteger(dependencyIndex) && dependencyIndex >= 0 && dependencyIndex < dependencies.length) {
                    let dependency = dependencies[dependencyIndex];
                    if (dependency instanceof _index2.NumberValue || dependency instanceof _index2.StringValue) return dependency.value;
                  }
                }
              }
            }
          }
        } else {
          return argument.value;
        }
      };

      // Let's consider each of the function instances (closures for the same code)
      for (let f of functions) {
        // 1. Let's check if we have a match for a factory function like
        //      factoryFunction(, require, , , [dependencies])
        //    which is used with the Metro bundler
        let scopedBinding = scope.getBinding(innerName);
        if (scopedBinding) {
          let dependencies = modules.factoryFunctionDependencies.get(f);
          if (dependencies !== undefined && formalParameters[1] === scopedBinding.path.node) {
            (0, _invariant2.default)(scopedBinding.kind === "param");
            let newModuleId = getModuleId(dependencies);
            if (newModuleId !== undefined && !updateModuleId(newModuleId)) return undefined;
            continue;
          }

          // The name binds to some local entity, but nothing we'd know what exactly it is
          return undefined;
        }

        // 2. Let's check if we can resolve the called function just by looking at the
        //    function instance environment.
        //    TODO: We should not do this if the current node is in a nested function!

        // We won't have a dependency map here, so this only works for literal arguments.
        if (!t.isNumericLiteral(argument) && !t.isStringLiteral(argument)) return undefined;

        let doesNotMatter = true;
        let reference = logger.tryQuery(() => _singletons.Environment.ResolveBinding(realm, innerName, doesNotMatter, f.$Environment), undefined);
        if (reference === undefined) {
          // We couldn't resolve as we came across some behavior that we cannot deal with abstractly
          return undefined;
        }
        if (_singletons.Environment.IsUnresolvableReference(realm, reference)) return undefined;
        let referencedBase = reference.base;
        let referencedName = reference.referencedName;
        if (typeof referencedName !== "string") return undefined;
        let value;
        if (reference.base instanceof _environment.GlobalEnvironmentRecord) {
          value = logger.tryQuery(() => (0, _index.Get)(realm, realm.$GlobalObject, innerName), realm.intrinsics.undefined);
        } else {
          (0, _invariant2.default)(referencedBase instanceof _environment.DeclarativeEnvironmentRecord);
          let binding = referencedBase.bindings[referencedName];
          if (!binding.initialized) return undefined;
          value = binding.value;
        }
        if (value !== modules.getRequire()) return undefined;
        const newModuleId = getModuleId();
        (0, _invariant2.default)(newModuleId !== undefined);
        if (!updateModuleId(newModuleId)) return undefined;
      }

      return moduleId;
    };
  }

  recordModuleInitialized(moduleId, value) {
    this.realm.assignToGlobal(t.memberExpression(t.memberExpression(t.identifier("global"), t.identifier("__initializedModules")), t.identifier("" + moduleId)), value);
  }

  tryInitializeModule(moduleId, message) {
    let realm = this.realm;
    let previousDisallowDelayingRequiresOverride = this.disallowDelayingRequiresOverride;
    this.disallowDelayingRequiresOverride = true;
    return downgradeErrorsToWarnings(realm, () => {
      try {
        let node = t.callExpression(t.identifier("require"), [t.valueToNode(moduleId)]);

        let effects = realm.evaluateNodeForEffectsInGlobalEnv(node);
        realm.applyEffects(effects, message);
        return effects;
      } catch (err) {
        if (err instanceof _errors.FatalError) return undefined;else throw err;
      } finally {
        this.disallowDelayingRequiresOverride = previousDisallowDelayingRequiresOverride;
      }
    });
  }

  initializeMoreModules() {
    // partially evaluate all factory methods by calling require
    let count = 0;
    for (let moduleId of this.moduleIds) {
      if (this.initializedModules.has(moduleId)) continue;
      let effects = this.tryInitializeModule(moduleId, `Speculative initialization of module ${moduleId}`);
      if (effects === undefined) continue;
      let result = effects[0];
      if (!(result instanceof _index2.Value)) continue; // module might throw
      count++;
      this.initializedModules.set(moduleId, result);
    }
    if (count > 0) console.log(`=== speculatively initialized ${count} additional modules`);
  }

  isModuleInitialized(moduleId) {
    let realm = this.realm;
    let oldReadOnly = realm.setReadOnly(true);
    let oldDisallowDelayingRequiresOverride = this.disallowDelayingRequiresOverride;
    this.disallowDelayingRequiresOverride = true;
    try {
      let node = t.callExpression(t.identifier("require"), [t.valueToNode(moduleId)]);

      let [compl, generator, bindings, properties, createdObjects] = realm.evaluateNodeForEffectsInGlobalEnv(node);
      // for lint unused
      (0, _invariant2.default)(bindings);

      if (compl instanceof _completions.AbruptCompletion) return undefined;
      (0, _invariant2.default)(compl instanceof _index2.Value);

      if (!generator.empty() || compl instanceof _index2.ObjectValue && createdObjects.has(compl)) return undefined;
      // Check for escaping property assignments, if none escape, we got an existing object
      let escapes = false;
      for (let [binding] of properties) {
        let object = binding.object;
        (0, _invariant2.default)(object instanceof _index2.ObjectValue);
        if (!createdObjects.has(object)) escapes = true;
      }
      if (escapes) return undefined;

      return compl;
    } catch (err) {
      if (err instanceof _errors.FatalError) return undefined;
      throw err;
    } finally {
      realm.setReadOnly(oldReadOnly);
      this.disallowDelayingRequiresOverride = oldDisallowDelayingRequiresOverride;
    }
  }
}
exports.Modules = Modules;

/***/ }),
/* 70 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = IsStrict;
function IsStrict(node) {
  if (node.strict) return true;
  if (node.type !== "BlockStatement" && node.type !== "Program") return false;
  let directives = node.directives;
  if (!directives) return false;
  return directives.some(directive => {
    if (directive.type !== "Directive") {
      return false;
    }
    if (directive.value.type !== "DirectiveLiteral") {
      return false;
    }
    return directive.value.value === "use strict";
  });
} /**
   * Copyright (c) 2017-present, Facebook, Inc.
   * All rights reserved.
   *
   * This source code is licensed under the BSD-style license found in the
   * LICENSE file in the root directory of this source tree. An additional grant
   * of patent rights can be found in the PATENTS file in the same directory.
   */

/***/ }),
/* 71 */
/***/ (function(module, exports, __webpack_require__) {

/*!
 * chai
 * Copyright(c) 2011-2014 Jake Luer <jake@alogicalparadox.com>
 * MIT Licensed
 */

var used = [];

/*!
 * Chai version
 */

exports.version = '4.1.2';

/*!
 * Assertion Error
 */

exports.AssertionError = __webpack_require__(232);

/*!
 * Utils for plugins (not exported)
 */

var util = __webpack_require__(423);

/**
 * # .use(function)
 *
 * Provides a way to extend the internals of Chai.
 *
 * @param {Function}
 * @returns {this} for chaining
 * @api public
 */

exports.use = function (fn) {
  if (!~used.indexOf(fn)) {
    fn(exports, util);
    used.push(fn);
  }

  return exports;
};

/*!
 * Utility Functions
 */

exports.util = util;

/*!
 * Configuration
 */

var config = __webpack_require__(72);
exports.config = config;

/*!
 * Primary `Assertion` prototype
 */

var assertion = __webpack_require__(440);
exports.use(assertion);

/*!
 * Core Assertions
 */

var core = __webpack_require__(441);
exports.use(core);

/*!
 * Expect interface
 */

var expect = __webpack_require__(442);
exports.use(expect);

/*!
 * Should interface
 */

var should = __webpack_require__(443);
exports.use(should);

/*!
 * Assert interface
 */

var assert = __webpack_require__(444);
exports.use(assert);


/***/ }),
/* 72 */
/***/ (function(module, exports) {

module.exports = {

  /**
   * ### config.includeStack
   *
   * User configurable property, influences whether stack trace
   * is included in Assertion error message. Default of false
   * suppresses stack trace in the error message.
   *
   *     chai.config.includeStack = true;  // enable stack on error
   *
   * @param {Boolean}
   * @api public
   */

  includeStack: false,

  /**
   * ### config.showDiff
   *
   * User configurable property, influences whether or not
   * the `showDiff` flag should be included in the thrown
   * AssertionErrors. `false` will always be `false`; `true`
   * will be true when the assertion has requested a diff
   * be shown.
   *
   * @param {Boolean}
   * @api public
   */

  showDiff: true,

  /**
   * ### config.truncateThreshold
   *
   * User configurable property, sets length threshold for actual and
   * expected values in assertion errors. If this threshold is exceeded, for
   * example for large data structures, the value is replaced with something
   * like `[ Array(3) ]` or `{ Object (prop1, prop2) }`.
   *
   * Set it to zero if you want to disable truncating altogether.
   *
   * This is especially userful when doing assertions on arrays: having this
   * set to a reasonable large value makes the failure messages readily
   * inspectable.
   *
   *     chai.config.truncateThreshold = 0;  // disable truncating
   *
   * @param {Number}
   * @api public
   */

  truncateThreshold: 40,

  /**
   * ### config.useProxy
   *
   * User configurable property, defines if chai will use a Proxy to throw
   * an error when a non-existent property is read, which protects users
   * from typos when using property-based assertions.
   *
   * Set it to false if you want to disable this feature.
   *
   *     chai.config.useProxy = false;  // disable use of Proxy
   *
   * This feature is automatically disabled regardless of this config value
   * in environments that don't support proxies.
   *
   * @param {Boolean}
   * @api public
   */

  useProxy: true,

  /**
   * ### config.proxyExcludedKeys
   *
   * User configurable property, defines which properties should be ignored
   * instead of throwing an error if they do not exist on the assertion.
   * This is only applied if the environment Chai is running in supports proxies and
   * if the `useProxy` configuration setting is enabled.
   * By default, `then` and `inspect` will not throw an error if they do not exist on the
   * assertion object because the `.inspect` property is read by `util.inspect` (for example, when
   * using `console.log` on the assertion object) and `.then` is necessary for promise type-checking.
   *
   *     // By default these keys will not throw an error if they do not exist on the assertion object
   *     chai.config.proxyExcludedKeys = ['then', 'inspect'];
   *
   * @param {Array}
   * @api public
   */

  proxyExcludedKeys: ['then', 'inspect', 'toJSON']
};


/***/ }),
/* 73 */
/***/ (function(module, exports) {

/*!
 * Chai - transferFlags utility
 * Copyright(c) 2012-2014 Jake Luer <jake@alogicalparadox.com>
 * MIT Licensed
 */

/**
 * ### .transferFlags(assertion, object, includeAll = true)
 *
 * Transfer all the flags for `assertion` to `object`. If
 * `includeAll` is set to `false`, then the base Chai
 * assertion flags (namely `object`, `ssfi`, `lockSsfi`,
 * and `message`) will not be transferred.
 *
 *
 *     var newAssertion = new Assertion();
 *     utils.transferFlags(assertion, newAssertion);
 *
 *     var anotherAsseriton = new Assertion(myObj);
 *     utils.transferFlags(assertion, anotherAssertion, false);
 *
 * @param {Assertion} assertion the assertion to transfer the flags from
 * @param {Object} object the object to transfer the flags to; usually a new assertion
 * @param {Boolean} includeAll
 * @namespace Utils
 * @name transferFlags
 * @api private
 */

module.exports = function transferFlags(assertion, object, includeAll) {
  var flags = assertion.__flags || (assertion.__flags = Object.create(null));

  if (!object.__flags) {
    object.__flags = Object.create(null);
  }

  includeAll = arguments.length === 3 ? includeAll : true;

  for (var flag in flags) {
    if (includeAll ||
        (flag !== 'object' && flag !== 'ssfi' && flag !== 'lockSsfi' && flag != 'message')) {
      object.__flags[flag] = flags[flag];
    }
  }
};


/***/ }),
/* 74 */
/***/ (function(module, exports, __webpack_require__) {

// Thank's IE8 for his funny defineProperty
module.exports = !__webpack_require__(130)(function () {
  return Object.defineProperty({}, 'a', { get: function () { return 7; } }).a != 7;
});


/***/ }),
/* 75 */
/***/ (function(module, exports, __webpack_require__) {

var baseIsNative = __webpack_require__(723),
    getValue = __webpack_require__(728);

/**
 * Gets the native function at `key` of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {string} key The key of the method to get.
 * @returns {*} Returns the function if it's native, else `undefined`.
 */
function getNative(object, key) {
  var value = getValue(object, key);
  return baseIsNative(value) ? value : undefined;
}

module.exports = getNative;


/***/ }),
/* 76 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GetIterator = GetIterator;
exports.IteratorStep = IteratorStep;
exports.IteratorValue = IteratorValue;
exports.IteratorComplete = IteratorComplete;
exports.IteratorNext = IteratorNext;
exports.CreateListIterator = CreateListIterator;
exports.CreateMapIterator = CreateMapIterator;
exports.CreateSetIterator = CreateSetIterator;
exports.IteratorClose = IteratorClose;
exports.IterableToList = IterableToList;

var _completions = __webpack_require__(3);

var _index = __webpack_require__(0);

var _index2 = __webpack_require__(5);

var _invariant = __webpack_require__(1);

var _invariant2 = _interopRequireDefault(_invariant);

var _abstract = __webpack_require__(19);

var _singletons = __webpack_require__(2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// ECMA262 7.4.1
/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 */

function GetIterator(realm, obj = realm.intrinsics.undefined, method) {
  // 1. If method was not passed, then
  if (!method) {
    // a. Let method be ? GetMethod(obj, @@iterator).
    method = (0, _index2.GetMethod)(realm, obj, realm.intrinsics.SymbolIterator);
  }

  // 2. Let iterator be ? Call(method, obj).
  let iterator = (0, _index2.Call)(realm, method, obj);

  // 3. If Type(iterator) is not Object, throw a TypeError exception.
  if (!(iterator instanceof _index.ObjectValue)) {
    throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError);
  }

  // 4. Return iterator.
  return iterator;
}

// ECMA262 7.4.5
function IteratorStep(realm, iterator) {
  // 1. Let result be ? IteratorNext(iterator).
  let result = IteratorNext(realm, iterator);

  // 2. Let done be ? IteratorComplete(result).
  let done = IteratorComplete(realm, result);

  // 3. If done is true, return false.
  if (done) return false;

  // 4. Return result.
  return result;
}

// ECMA262 7.4.4
function IteratorValue(realm, iterResult) {
  // 1. Assert: Type(iterResult) is Object.
  (0, _invariant2.default)(iterResult instanceof _index.ObjectValue, "expected obj");

  // 2. Return ? Get(iterResult, "value").
  return (0, _index2.Get)(realm, iterResult, "value");
}

// ECMA262 7.4.2
function IteratorComplete(realm, iterResult) {
  // 1. Assert: Type(iterResult) is Object.
  (0, _invariant2.default)(iterResult instanceof _index.ObjectValue, "expected obj");

  // 2. Return ToBoolean(? Get(iterResult, "done")).
  return _singletons.To.ToBooleanPartial(realm, (0, _index2.Get)(realm, iterResult, "done"));
}

// ECMA262 7.4.2
function IteratorNext(realm, iterator, value) {
  // 1. If value was not passed, then
  let result;
  if (!value) {
    // a. Let result be ? Invoke(iterator, "next", « »).
    result = (0, _index2.Invoke)(realm, iterator, "next", []);
  } else {
    // 2. Else,
    // a. Let result be ? Invoke(iterator, "next", « value »).
    result = (0, _index2.Invoke)(realm, iterator, "next", [value]);
  }

  // 3. If Type(result) is not Object, throw a TypeError exception.
  if (!(result instanceof _index.ObjectValue)) {
    throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError);
  }

  // 4. Return result.
  return result;
}

// ECMA262 7.4.8
function CreateListIterator(realm, list) {
  // 1. Let iterator be ObjectCreate(%IteratorPrototype%, « [[IteratorNext]], [[IteratedList]], [[ListIteratorNextIndex]] »).
  let iterator = _singletons.Create.ObjectCreate(realm, realm.intrinsics.IteratorPrototype, {
    $IteratorNext: undefined,
    $IteratedList: undefined,
    $ListIteratorNextIndex: undefined
  });

  // 2. Set iterator's [[IteratedList]] internal slot to list.
  iterator.$IteratedList = list;

  // 3. Set iterator's [[ListIteratorNextIndex]] internal slot to 0.
  iterator.$ListIteratorNextIndex = 0;

  // 4. Let next be a new built-in function object as defined in ListIterator next (7.4.8.1).
  let next = ListIterator_next(realm);

  // 5. Set iterator's [[IteratorNext]] internal slot to next.
  iterator.$IteratorNext = next;

  // 6. Perform CreateMethodProperty(iterator, "next", next).
  _singletons.Create.CreateMethodProperty(realm, iterator, new _index.StringValue(realm, "next"), next);

  // 7. Return iterator.
  return iterator;
}

// ECMA262 7.4.8.1
function ListIterator_next(realm) {
  let func = new _index.NativeFunctionValue(realm, undefined, "next", 0, context => {
    (0, _invariant2.default)(context instanceof _index.ObjectValue);

    // 1. Let O be the this value.
    let O = context;

    // 2. Let f be the active function object.
    let f = func;

    // 3. If O does not have a [[IteratorNext]] internal slot, throw a TypeError exception.
    if (!O.$IteratorNext) {
      throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "O does not have an [[IteratorNext]] internal slot");
    }

    // 4. Let next be the value of the [[IteratorNext]] internal slot of O.
    let next = O.$IteratorNext;

    // 5. If SameValue(f, next) is false, throw a TypeError exception.
    if (!(0, _abstract.SameValue)(realm, f, next)) {
      throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError);
    }

    // 6. If O does not have an [[IteratedList]] internal slot, throw a TypeError exception.
    if (!O.$IteratedList) {
      throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "O does not have an [[IteratedList]] internal slot");
    }

    // 7. Let list be the value of the [[IteratedList]] internal slot of O.
    let list = O.$IteratedList;

    (0, _invariant2.default)(typeof O.$ListIteratorNextIndex === "number");

    // 8. Let index be the value of the [[ListIteratorNextIndex]] internal slot of O.
    // Default to 0 for Flow.
    let index = O.$ListIteratorNextIndex;

    // 9. Let len be the number of elements of list.
    let len = list.length;

    // 10. If index ≥ len, then
    if (index >= len) {
      // a. Return CreateIterResultObject(undefined, true).
      return _singletons.Create.CreateIterResultObject(realm, realm.intrinsics.undefined, true);
    }

    // 11. Set the value of the [[ListIteratorNextIndex]] internal slot of O to index+1.
    O.$ListIteratorNextIndex = index + 1;

    // 12. Return CreateIterResultObject(list[index], false).
    return _singletons.Create.CreateIterResultObject(realm, list[index], false);
  });

  return func;
}

// ECMA262 23.1.5.1
function CreateMapIterator(realm, map, kind) {
  // 1. If Type(map) is not Object, throw a TypeError exception.
  if (!(map instanceof _index.ObjectValue)) {
    throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError);
  }

  // 2. If map does not have a [[MapData]] internal slot, throw a TypeError exception.
  if (!map.$MapData) {
    throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError);
  }

  // 3. Let iterator be ObjectCreate(%MapIteratorPrototype%, « [[Map]], [[MapNextIndex]], [[MapIterationKind]] »).
  let iterator = _singletons.Create.ObjectCreate(realm, realm.intrinsics.MapIteratorPrototype, {
    $Map: undefined,
    $MapNextIndex: undefined,
    $MapIterationKind: undefined
  });

  // 4. Set iterator's [[Map]] internal slot to map.
  iterator.$Map = map;

  // 5. Set iterator's [[MapNextIndex]] internal slot to 0.
  iterator.$MapNextIndex = new _index.NumberValue(realm, 0);

  // 6. Set iterator's [[MapIterationKind]] internal slot to kind.
  iterator.$MapIterationKind = kind;

  // 7. Return iterator.
  return iterator;
}

// ECMA262 23.2.5.1
function CreateSetIterator(realm, set, kind) {
  // 1. If Type(set) is not Object, throw a TypeError exception.
  if (!(set instanceof _index.ObjectValue)) {
    throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError);
  }

  // 2. If set does not have a [[SetData]] internal slot, throw a TypeError exception.
  if (!set.$SetData) {
    throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError);
  }

  // 3. Let iterator be ObjectCreate(%SetIteratorPrototype%, « [[IteratedSet]], [[SetNextIndex]], [[SetIterationKind]] »).
  let iterator = _singletons.Create.ObjectCreate(realm, realm.intrinsics.SetIteratorPrototype, {
    $IteratedSet: undefined,
    $SetNextIndex: undefined,
    $SetIterationKind: undefined
  });

  // 4. Set iterator's [[IteratedSet]] internal slot to set.
  iterator.$IteratedSet = set;

  // 5. Set iterator's [[SetNextIndex]] internal slot to 0.
  iterator.$SetNextIndex = 0;

  // 6. Set iterator's [[SetIterationKind]] internal slot to kind.
  iterator.$SetIterationKind = kind;

  // 7. Return iterator.
  return iterator;
}

// ECMA262 7.4.6
function IteratorClose(realm, iterator, completion) {
  // 1. Assert: Type(iterator) is Object.
  (0, _invariant2.default)(iterator instanceof _index.ObjectValue, "expected object");

  // 2. Assert: completion is a Completion Record.
  (0, _invariant2.default)(completion instanceof _completions.Completion, "expected completion record");

  // 3. Let return be ? GetMethod(iterator, "return").
  let ret = (0, _index2.GetMethod)(realm, iterator, "return");

  // 4. If return is undefined, return Completion(completion).
  if (ret instanceof _index.UndefinedValue) return completion;

  // 5. Let innerResult be Call(return, iterator, « »).
  let innerResult;
  try {
    innerResult = (0, _index2.Call)(realm, ret.throwIfNotConcrete(), iterator, []);
  } catch (error) {
    if (error instanceof _completions.AbruptCompletion) {
      innerResult = error;
    } else {
      throw error;
    }
  }

  // 6. If completion.[[Type]] is throw, return Completion(completion).
  if (completion instanceof _completions.ThrowCompletion) return completion;

  // 7. If innerResult.[[Type]] is throw, return Completion(innerResult).
  if (innerResult instanceof _completions.ThrowCompletion) return innerResult;

  // 8. If Type(innerResult.[[Value]]) is not Object, throw a TypeError exception.
  if (!(innerResult instanceof _index.ObjectValue)) {
    return realm.createErrorThrowCompletion(realm.intrinsics.TypeError);
  }

  // 9. Return Completion(completion).
  return completion;
}

// ECMA262 22.2.2.1.1
function IterableToList(realm, items, method) {
  // 1. Let iterator be ? GetIterator(items, method).
  let iterator = GetIterator(realm, items, method);

  // 2. Let values be a new empty List.
  let values = [];

  // 3. Let next be true.
  let next = true;

  // 4. Repeat, while next is not false
  while (next !== false) {
    // a. Let next be ? IteratorStep(iterator).
    next = IteratorStep(realm, iterator);

    // b. If next is not false, then
    if (next !== false) {
      // i. Let nextValue be ? IteratorValue(next).
      let nextValue = IteratorValue(realm, next);

      // ii. Append nextValue to the end of the List values.
      values.push(nextValue);
    }
  }

  // 5. Return values.
  return values;
}

/***/ }),
/* 77 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = traverse;

var _babelTypes = __webpack_require__(4);

var t = _interopRequireWildcard(_babelTypes);

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

// This is a variation of traverseFast from
// https://github.com/babel/babel/blob/28ae47a174f67a8ae6f4527e0a66e88896814170/packages/babel-types/src/index.js
// This version...
// - takes a callback function that returns a boolean to indicate whether to short-circuit the traversal
// - doesn't pass around or allocate an optional parameter value to the callback.
/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 */

function traverse(node, enter) {
  if (!node) return;

  let keys = t.VISITOR_KEYS[node.type];
  if (!keys) return;

  let stop = enter(node);
  if (stop) return;

  for (let key of keys) {
    let subNode = node[key];

    if (Array.isArray(subNode)) {
      for (let elementNode of subNode) {
        traverse(elementNode, enter);
      }
    } else {
      traverse(subNode, enter);
    }
  }
}

/***/ }),
/* 78 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

exports.default = function (ast, strictCode, env, realm) {
  // evaluate left
  let lref = env.evaluate(ast.left, strictCode);
  let lval = _singletons.Environment.GetValue(realm, lref);

  // evaluate right
  let rref = env.evaluate(ast.right, strictCode);
  let rval = _singletons.Environment.GetValue(realm, rref);

  return computeBinary(realm, ast.operator, lval, rval, ast.left.loc, ast.right.loc, ast.loc);
};

exports.getPureBinaryOperationResultType = getPureBinaryOperationResultType;
exports.computeBinary = computeBinary;

var _index = __webpack_require__(24);

var _errors = __webpack_require__(6);

var _index2 = __webpack_require__(0);

var _completions = __webpack_require__(3);

var _singletons = __webpack_require__(2);

var _babelTypes = __webpack_require__(4);

var t = _interopRequireWildcard(_babelTypes);

var _invariant = __webpack_require__(1);

var _invariant2 = _interopRequireDefault(_invariant);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

let unknownValueOfOrToString = "might be an object with an unknown valueOf or toString or Symbol.toPrimitive method";

// Returns result type if binary operation is pure (terminates, does not throw exception, does not read or write heap), otherwise undefined.
/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 */

function getPureBinaryOperationResultType(realm, op, lval, rval, lloc, rloc) {
  function reportErrorIfNotPure(purityTest, typeIfPure) {
    let leftPure = purityTest(realm, lval);
    let rightPure = purityTest(realm, rval);
    if (leftPure && rightPure) return typeIfPure;
    let loc = !leftPure ? lloc : rloc;
    let error = new _errors.CompilerDiagnostic(unknownValueOfOrToString, loc, "PP0002", "RecoverableError");
    if (realm.handleError(error) === "Recover") {
      // Assume that an unknown value is actually a primitive or otherwise a well behaved object.
      return typeIfPure;
    }
    throw new _errors.FatalError();
  }
  if (op === "+") {
    let ltype = _singletons.To.GetToPrimitivePureResultType(realm, lval);
    let rtype = _singletons.To.GetToPrimitivePureResultType(realm, rval);
    if (ltype === undefined || rtype === undefined) {
      let loc = ltype === undefined ? lloc : rloc;
      let error = new _errors.CompilerDiagnostic(unknownValueOfOrToString, loc, "PP0002", "RecoverableError");
      if (realm.handleError(error) === "Recover") {
        // Assume that the unknown value is actually a primitive or otherwise a well behaved object.
        ltype = lval.getType();
        rtype = rval.getType();
        if (ltype === _index2.StringValue || rtype === _index2.StringValue) return _index2.StringValue;
        if (ltype === _index2.IntegralValue && rtype === _index2.IntegralValue) return _index2.IntegralValue;
        if ((ltype === _index2.NumberValue || ltype === _index2.IntegralValue) && (rtype === _index2.NumberValue || rtype === _index2.IntegralValue)) return _index2.NumberValue;

        return _index2.Value;
      }
      throw new _errors.FatalError();
    }
    if (ltype === _index2.StringValue || rtype === _index2.StringValue) return _index2.StringValue;
    return _index2.NumberValue;
  } else if (op === "<" || op === ">" || op === ">=" || op === "<=") {
    return reportErrorIfNotPure(_singletons.To.IsToPrimitivePure.bind(_singletons.To), _index2.BooleanValue);
  } else if (op === "!=" || op === "==") {
    let ltype = lval.getType();
    let rtype = rval.getType();
    if (ltype === _index2.NullValue || ltype === _index2.UndefinedValue || rtype === _index2.NullValue || rtype === _index2.UndefinedValue) return _index2.BooleanValue;
    return reportErrorIfNotPure(_singletons.To.IsToPrimitivePure.bind(_singletons.To), _index2.BooleanValue);
  } else if (op === "===" || op === "!==") {
    return _index2.BooleanValue;
  } else if (op === ">>>" || op === "<<" || op === ">>" || op === "&" || op === "|" || op === "^" || op === "**" || op === "%" || op === "/" || op === "*" || op === "-") {
    return reportErrorIfNotPure(_singletons.To.IsToNumberPure.bind(_singletons.To), _index2.NumberValue);
  } else if (op === "in" || op === "instanceof") {
    if (rval.mightNotBeObject()) {
      let error = new _errors.CompilerDiagnostic(`might not be an object, hence the ${op} operator might throw a TypeError`, rloc, "PP0003", "RecoverableError");
      if (realm.handleError(error) === "Recover") {
        // Assume that the object is actually a well behaved object.
        return _index2.BooleanValue;
      }
      throw new _errors.FatalError();
    }
    if (!rval.mightNotBeObject()) {
      // Simple object won't throw here, aren't proxy objects or typed arrays and do not have @@hasInstance properties.
      if (rval.isSimpleObject()) return _index2.BooleanValue;
    }
    let error = new _errors.CompilerDiagnostic(`might be an object that behaves badly for the ${op} operator`, rloc, "PP0004", "RecoverableError");
    if (realm.handleError(error) === "Recover") {
      // Assume that the object is actually a well behaved object.
      return _index2.BooleanValue;
    }
    throw new _errors.FatalError();
  }
  (0, _invariant2.default)(false, "unimplemented " + op);
}

function computeBinary(realm, op, lval, rval, lloc, rloc, loc) {
  // partial evaluation shortcut for a particular pattern
  if (realm.useAbstractInterpretation && (op === "==" || op === "===" || op === "!=" || op === "!==")) {
    if (!lval.mightNotBeObject() && (rval instanceof _index2.NullValue || rval instanceof _index2.UndefinedValue) || (lval instanceof _index2.NullValue || lval instanceof _index2.UndefinedValue) && !rval.mightNotBeObject()) {
      return new _index2.BooleanValue(realm, op[0] !== "=");
    }
  }

  let resultType;
  const compute = () => {
    if (lval instanceof _index2.AbstractValue || rval instanceof _index2.AbstractValue) {
      // generate error if binary operation might throw or have side effects
      resultType = getPureBinaryOperationResultType(realm, op, lval, rval, lloc, rloc);
      return _index2.AbstractValue.createFromBinaryOp(realm, op, lval, rval, loc);
    } else {
      // ECMA262 12.10.3

      // 5. If Type(rval) is not Object, throw a TypeError exception.
      if (op === "in" && !(rval instanceof _index2.ObjectValue)) {
        throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError);
      }
      (0, _invariant2.default)(lval instanceof _index2.ConcreteValue);
      (0, _invariant2.default)(rval instanceof _index2.ConcreteValue);
      const result = _index.ValuesDomain.computeBinary(realm, op, lval, rval);
      resultType = result.getType();
      return result;
    }
  };

  if (realm.isInPureScope()) {
    // If we're in pure mode we can recover even if this operation might not be pure.
    // To do that, we'll temporarily override the error handler.
    const previousErrorHandler = realm.errorHandler;
    let isPure = true;
    realm.errorHandler = diagnostic => {
      isPure = false;
      return "Recover";
    };
    let effects;
    try {
      effects = realm.evaluateForEffects(compute);
    } catch (x) {
      if (x instanceof _errors.FatalError) {
        isPure = false;
      } else {
        throw x;
      }
    } finally {
      realm.errorHandler = previousErrorHandler;
    }

    if (isPure && effects) {
      let completion = effects[0];
      if (completion instanceof _completions.PossiblyNormalCompletion) {
        // in this case one of the branches may complete abruptly, which means that
        // not all control flow branches join into one flow at this point.
        // Consequently we have to continue tracking changes until the point where
        // all the branches come together into one.
        completion = realm.composeWithSavedCompletion(completion);
      }
      // Note that the effects of (non joining) abrupt branches are not included
      // in effects, but are tracked separately inside completion.
      realm.applyEffects(effects);
      // return or throw completion
      if (completion instanceof _completions.AbruptCompletion) throw completion;
      (0, _invariant2.default)(completion instanceof _index2.Value);
      return completion;
    }

    // If this ended up reporting an error, it might not be pure, so we'll leave it in
    // as a temporal operation with a known return type.
    // Some of these values may trigger side-effectful user code such as valueOf.
    // To be safe, we have to Havoc them.
    _singletons.Havoc.value(realm, lval, loc);
    if (op !== "in") {
      // The "in" operator have side-effects on its right val other than throw.
      _singletons.Havoc.value(realm, rval, loc);
    }
    return realm.evaluateWithPossibleThrowCompletion(() => _index2.AbstractValue.createTemporalFromBuildFunction(realm, resultType, [lval, rval], ([lnode, rnode]) => t.binaryExpression(op, lnode, rnode)), _index.TypesDomain.topVal, _index.ValuesDomain.topVal);
  }
  return compute();
}

/***/ }),
/* 79 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _getIterator2 = __webpack_require__(13);

var _getIterator3 = _interopRequireDefault(_getIterator2);

var _classCallCheck2 = __webpack_require__(26);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _virtualTypes = __webpack_require__(361);

var virtualTypes = _interopRequireWildcard(_virtualTypes);

var _debug2 = __webpack_require__(858);

var _debug3 = _interopRequireDefault(_debug2);

var _invariant = __webpack_require__(861);

var _invariant2 = _interopRequireDefault(_invariant);

var _index = __webpack_require__(43);

var _index2 = _interopRequireDefault(_index);

var _assign = __webpack_require__(362);

var _assign2 = _interopRequireDefault(_assign);

var _scope = __webpack_require__(222);

var _scope2 = _interopRequireDefault(_scope);

var _babelTypes = __webpack_require__(4);

var t = _interopRequireWildcard(_babelTypes);

var _cache = __webpack_require__(160);

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _debug = (0, _debug3.default)("babel");

var NodePath = function () {
  function NodePath(hub, parent) {
    (0, _classCallCheck3.default)(this, NodePath);

    this.parent = parent;
    this.hub = hub;
    this.contexts = [];
    this.data = {};
    this.shouldSkip = false;
    this.shouldStop = false;
    this.removed = false;
    this.state = null;
    this.opts = null;
    this.skipKeys = null;
    this.parentPath = null;
    this.context = null;
    this.container = null;
    this.listKey = null;
    this.inList = false;
    this.parentKey = null;
    this.key = null;
    this.node = null;
    this.scope = null;
    this.type = null;
    this.typeAnnotation = null;
  }

  NodePath.get = function get(_ref) {
    var hub = _ref.hub,
        parentPath = _ref.parentPath,
        parent = _ref.parent,
        container = _ref.container,
        listKey = _ref.listKey,
        key = _ref.key;

    if (!hub && parentPath) {
      hub = parentPath.hub;
    }

    (0, _invariant2.default)(parent, "To get a node path the parent needs to exist");

    var targetNode = container[key];

    var paths = _cache.path.get(parent) || [];
    if (!_cache.path.has(parent)) {
      _cache.path.set(parent, paths);
    }

    var path = void 0;

    for (var i = 0; i < paths.length; i++) {
      var pathCheck = paths[i];
      if (pathCheck.node === targetNode) {
        path = pathCheck;
        break;
      }
    }

    if (!path) {
      path = new NodePath(hub, parent);
      paths.push(path);
    }

    path.setup(parentPath, container, listKey, key);

    return path;
  };

  NodePath.prototype.getScope = function getScope(scope) {
    var ourScope = scope;

    if (this.isScope()) {
      ourScope = new _scope2.default(this, scope);
    }

    return ourScope;
  };

  NodePath.prototype.setData = function setData(key, val) {
    return this.data[key] = val;
  };

  NodePath.prototype.getData = function getData(key, def) {
    var val = this.data[key];
    if (!val && def) val = this.data[key] = def;
    return val;
  };

  NodePath.prototype.buildCodeFrameError = function buildCodeFrameError(msg) {
    var Error = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : SyntaxError;

    return this.hub.file.buildCodeFrameError(this.node, msg, Error);
  };

  NodePath.prototype.traverse = function traverse(visitor, state) {
    (0, _index2.default)(this.node, visitor, this.scope, state, this);
  };

  NodePath.prototype.mark = function mark(type, message) {
    this.hub.file.metadata.marked.push({
      type: type,
      message: message,
      loc: this.node.loc
    });
  };

  NodePath.prototype.set = function set(key, node) {
    t.validate(this.node, key, node);
    this.node[key] = node;
  };

  NodePath.prototype.getPathLocation = function getPathLocation() {
    var parts = [];
    var path = this;
    do {
      var key = path.key;
      if (path.inList) key = path.listKey + "[" + key + "]";
      parts.unshift(key);
    } while (path = path.parentPath);
    return parts.join(".");
  };

  NodePath.prototype.debug = function debug(buildMessage) {
    if (!_debug.enabled) return;
    _debug(this.getPathLocation() + " " + this.type + ": " + buildMessage());
  };

  return NodePath;
}();

exports.default = NodePath;


(0, _assign2.default)(NodePath.prototype, __webpack_require__(890));
(0, _assign2.default)(NodePath.prototype, __webpack_require__(891));
(0, _assign2.default)(NodePath.prototype, __webpack_require__(894));
(0, _assign2.default)(NodePath.prototype, __webpack_require__(904));
(0, _assign2.default)(NodePath.prototype, __webpack_require__(905));
(0, _assign2.default)(NodePath.prototype, __webpack_require__(906));
(0, _assign2.default)(NodePath.prototype, __webpack_require__(907));
(0, _assign2.default)(NodePath.prototype, __webpack_require__(908));
(0, _assign2.default)(NodePath.prototype, __webpack_require__(910));
(0, _assign2.default)(NodePath.prototype, __webpack_require__(912));
(0, _assign2.default)(NodePath.prototype, __webpack_require__(913));

var _loop2 = function _loop2() {
  if (_isArray) {
    if (_i >= _iterator.length) return "break";
    _ref2 = _iterator[_i++];
  } else {
    _i = _iterator.next();
    if (_i.done) return "break";
    _ref2 = _i.value;
  }

  var type = _ref2;

  var typeKey = "is" + type;
  NodePath.prototype[typeKey] = function (opts) {
    return t[typeKey](this.node, opts);
  };

  NodePath.prototype["assert" + type] = function (opts) {
    if (!this[typeKey](opts)) {
      throw new TypeError("Expected node path of type " + type);
    }
  };
};

for (var _iterator = t.TYPES, _isArray = Array.isArray(_iterator), _i = 0, _iterator = _isArray ? _iterator : (0, _getIterator3.default)(_iterator);;) {
  var _ref2;

  var _ret2 = _loop2();

  if (_ret2 === "break") break;
}

var _loop = function _loop(type) {
  if (type[0] === "_") return "continue";
  if (t.TYPES.indexOf(type) < 0) t.TYPES.push(type);

  var virtualType = virtualTypes[type];

  NodePath.prototype["is" + type] = function (opts) {
    return virtualType.checkPath(this, opts);
  };
};

for (var type in virtualTypes) {
  var _ret = _loop(type);

  if (_ret === "continue") continue;
}
module.exports = exports["default"];

/***/ }),
/* 80 */
/***/ (function(module, exports, __webpack_require__) {

var assert = __webpack_require__(25);
var types = __webpack_require__(48);
var getFieldValue = types.getFieldValue;
var n = types.namedTypes;
var sourceMap = __webpack_require__(166);
var SourceMapConsumer = sourceMap.SourceMapConsumer;
var SourceMapGenerator = sourceMap.SourceMapGenerator;
var hasOwn = Object.prototype.hasOwnProperty;
var util = exports;

function getUnionOfKeys() {
  var result = {};
  var argc = arguments.length;
  for (var i = 0; i < argc; ++i) {
    var keys = Object.keys(arguments[i]);
    var keyCount = keys.length;
    for (var j = 0; j < keyCount; ++j) {
      result[keys[j]] = true;
    }
  }
  return result;
}
util.getUnionOfKeys = getUnionOfKeys;

function comparePos(pos1, pos2) {
  return (pos1.line - pos2.line) || (pos1.column - pos2.column);
}
util.comparePos = comparePos;

function copyPos(pos) {
  return {
    line: pos.line,
    column: pos.column
  };
}
util.copyPos = copyPos;

util.composeSourceMaps = function(formerMap, latterMap) {
  if (formerMap) {
    if (!latterMap) {
      return formerMap;
    }
  } else {
    return latterMap || null;
  }

  var smcFormer = new SourceMapConsumer(formerMap);
  var smcLatter = new SourceMapConsumer(latterMap);
  var smg = new SourceMapGenerator({
    file: latterMap.file,
    sourceRoot: latterMap.sourceRoot
  });

  var sourcesToContents = {};

  smcLatter.eachMapping(function(mapping) {
    var origPos = smcFormer.originalPositionFor({
      line: mapping.originalLine,
      column: mapping.originalColumn
    });

    var sourceName = origPos.source;
    if (sourceName === null) {
      return;
    }

    smg.addMapping({
      source: sourceName,
      original: copyPos(origPos),
      generated: {
        line: mapping.generatedLine,
        column: mapping.generatedColumn
      },
      name: mapping.name
    });

    var sourceContent = smcFormer.sourceContentFor(sourceName);
    if (sourceContent && !hasOwn.call(sourcesToContents, sourceName)) {
      sourcesToContents[sourceName] = sourceContent;
      smg.setSourceContent(sourceName, sourceContent);
    }
  });

  return smg.toJSON();
};

util.getTrueLoc = function(node, lines) {
  // It's possible that node is newly-created (not parsed by Esprima),
  // in which case it probably won't have a .loc property (or an
  // .original property for that matter). That's fine; we'll just
  // pretty-print it as usual.
  if (!node.loc) {
    return null;
  }

  var result = {
    start: node.loc.start,
    end: node.loc.end
  };

  function include(node) {
    expandLoc(result, node.loc);
  }

  // If the node has any comments, their locations might contribute to
  // the true start/end positions of the node.
  if (node.comments) {
    node.comments.forEach(include);
  }

  // If the node is an export declaration and its .declaration has any
  // decorators, their locations might contribute to the true start/end
  // positions of the export declaration node.
  if (node.declaration && util.isExportDeclaration(node) &&
      node.declaration.decorators) {
    node.declaration.decorators.forEach(include);
  }

  if (comparePos(result.start, result.end) < 0) {
    // Trim leading whitespace.
    result.start = copyPos(result.start);
    lines.skipSpaces(result.start, false, true);

    if (comparePos(result.start, result.end) < 0) {
      // Trim trailing whitespace, if the end location is not already the
      // same as the start location.
      result.end = copyPos(result.end);
      lines.skipSpaces(result.end, true, true);
    }
  }

  return result;
};

function expandLoc(parentLoc, childLoc) {
  if (parentLoc && childLoc) {
    if (comparePos(childLoc.start, parentLoc.start) < 0) {
      parentLoc.start = childLoc.start;
    }

    if (comparePos(parentLoc.end, childLoc.end) < 0) {
      parentLoc.end = childLoc.end;
    }
  }
}

util.fixFaultyLocations = function(node, lines) {
  var loc = node.loc;
  if (loc) {
    if (loc.start.line < 1) {
      loc.start.line = 1;
    }

    if (loc.end.line < 1) {
      loc.end.line = 1;
    }
  }

  if (node.type === "File") {
    // Babylon returns File nodes whose .loc.{start,end} do not include
    // leading or trailing whitespace.
    loc.start = lines.firstPos();
    loc.end = lines.lastPos();
  }

  fixForLoopHead(node, lines);
  fixTemplateLiteral(node, lines);

  if (loc && node.decorators) {
    // Expand the .loc of the node responsible for printing the decorators
    // (here, the decorated node) so that it includes node.decorators.
    node.decorators.forEach(function (decorator) {
      expandLoc(loc, decorator.loc);
    });

  } else if (node.declaration && util.isExportDeclaration(node)) {
    // Nullify .loc information for the child declaration so that we never
    // try to reprint it without also reprinting the export declaration.
    node.declaration.loc = null;

    // Expand the .loc of the node responsible for printing the decorators
    // (here, the export declaration) so that it includes node.decorators.
    var decorators = node.declaration.decorators;
    if (decorators) {
      decorators.forEach(function (decorator) {
        expandLoc(loc, decorator.loc);
      });
    }

  } else if ((n.MethodDefinition && n.MethodDefinition.check(node)) ||
             (n.Property.check(node) && (node.method || node.shorthand))) {
    // If the node is a MethodDefinition or a .method or .shorthand
    // Property, then the location information stored in
    // node.value.loc is very likely untrustworthy (just the {body}
    // part of a method, or nothing in the case of shorthand
    // properties), so we null out that information to prevent
    // accidental reuse of bogus source code during reprinting.
    node.value.loc = null;

    if (n.FunctionExpression.check(node.value)) {
      // FunctionExpression method values should be anonymous,
      // because their .id fields are ignored anyway.
      node.value.id = null;
    }

  } else if (node.type === "ObjectTypeProperty") {
    var loc = node.loc;
    var end = loc && loc.end;
    if (end) {
      end = copyPos(end);
      if (lines.prevPos(end) &&
          lines.charAt(end) === ",") {
        // Some parsers accidentally include trailing commas in the
        // .loc.end information for ObjectTypeProperty nodes.
        if ((end = lines.skipSpaces(end, true, true))) {
          loc.end = end;
        }
      }
    }
  }
};

function fixForLoopHead(node, lines) {
  if (node.type !== "ForStatement") {
    return;
  }

  function fix(child) {
    var loc = child && child.loc;
    var start = loc && loc.start;
    var end = loc && copyPos(loc.end);

    while (start && end && comparePos(start, end) < 0) {
      lines.prevPos(end);
      if (lines.charAt(end) === ";") {
        // Update child.loc.end to *exclude* the ';' character.
        loc.end.line = end.line;
        loc.end.column = end.column;
      } else {
        break;
      }
    }
  }

  fix(node.init);
  fix(node.test);
  fix(node.update);
}

function fixTemplateLiteral(node, lines) {
  if (node.type !== "TemplateLiteral") {
    return;
  }

  if (node.quasis.length === 0) {
    // If there are no quasi elements, then there is nothing to fix.
    return;
  }

  // First we need to exclude the opening ` from the .loc of the first
  // quasi element, in case the parser accidentally decided to include it.
  var afterLeftBackTickPos = copyPos(node.loc.start);
  assert.strictEqual(lines.charAt(afterLeftBackTickPos), "`");
  assert.ok(lines.nextPos(afterLeftBackTickPos));
  var firstQuasi = node.quasis[0];
  if (comparePos(firstQuasi.loc.start, afterLeftBackTickPos) < 0) {
    firstQuasi.loc.start = afterLeftBackTickPos;
  }

  // Next we need to exclude the closing ` from the .loc of the last quasi
  // element, in case the parser accidentally decided to include it.
  var rightBackTickPos = copyPos(node.loc.end);
  assert.ok(lines.prevPos(rightBackTickPos));
  assert.strictEqual(lines.charAt(rightBackTickPos), "`");
  var lastQuasi = node.quasis[node.quasis.length - 1];
  if (comparePos(rightBackTickPos, lastQuasi.loc.end) < 0) {
    lastQuasi.loc.end = rightBackTickPos;
  }

  // Now we need to exclude ${ and } characters from the .loc's of all
  // quasi elements, since some parsers accidentally include them.
  node.expressions.forEach(function (expr, i) {
    // Rewind from expr.loc.start over any whitespace and the ${ that
    // precedes the expression. The position of the $ should be the same
    // as the .loc.end of the preceding quasi element, but some parsers
    // accidentally include the ${ in the .loc of the quasi element.
    var dollarCurlyPos = lines.skipSpaces(expr.loc.start, true, false);
    if (lines.prevPos(dollarCurlyPos) &&
        lines.charAt(dollarCurlyPos) === "{" &&
        lines.prevPos(dollarCurlyPos) &&
        lines.charAt(dollarCurlyPos) === "$") {
      var quasiBefore = node.quasis[i];
      if (comparePos(dollarCurlyPos, quasiBefore.loc.end) < 0) {
        quasiBefore.loc.end = dollarCurlyPos;
      }
    }

    // Likewise, some parsers accidentally include the } that follows
    // the expression in the .loc of the following quasi element.
    var rightCurlyPos = lines.skipSpaces(expr.loc.end, false, false);
    if (lines.charAt(rightCurlyPos) === "}") {
      assert.ok(lines.nextPos(rightCurlyPos));
      // Now rightCurlyPos is technically the position just after the }.
      var quasiAfter = node.quasis[i + 1];
      if (comparePos(quasiAfter.loc.start, rightCurlyPos) < 0) {
        quasiAfter.loc.start = rightCurlyPos;
      }
    }
  });
}

util.isExportDeclaration = function (node) {
  if (node) switch (node.type) {
  case "ExportDeclaration":
  case "ExportDefaultDeclaration":
  case "ExportDefaultSpecifier":
  case "DeclareExportDeclaration":
  case "ExportNamedDeclaration":
  case "ExportAllDeclaration":
    return true;
  }

  return false;
};

util.getParentExportDeclaration = function (path) {
  var parentNode = path.getParentNode();
  if (path.getName() === "declaration" &&
      util.isExportDeclaration(parentNode)) {
    return parentNode;
  }

  return null;
};

util.isTrailingCommaEnabled = function(options, context) {
  var trailingComma = options.trailingComma;
  if (typeof trailingComma === "object") {
    return !!trailingComma[context];
  }
  return !!trailingComma;
};


/***/ }),
/* 81 */
/***/ (function(module, exports, __webpack_require__) {

var global = __webpack_require__(49);
var hide = __webpack_require__(82);
var has = __webpack_require__(85);
var SRC = __webpack_require__(129)('src');
var TO_STRING = 'toString';
var $toString = Function[TO_STRING];
var TPL = ('' + $toString).split(TO_STRING);

__webpack_require__(97).inspectSource = function (it) {
  return $toString.call(it);
};

(module.exports = function (O, key, val, safe) {
  var isFunction = typeof val == 'function';
  if (isFunction) has(val, 'name') || hide(val, 'name', key);
  if (O[key] === val) return;
  if (isFunction) has(val, SRC) || hide(val, SRC, O[key] ? '' + O[key] : TPL.join(String(key)));
  if (O === global) {
    O[key] = val;
  } else if (!safe) {
    delete O[key];
    hide(O, key, val);
  } else if (O[key]) {
    O[key] = val;
  } else {
    hide(O, key, val);
  }
// add fake Function#toString for correct work wrapped methods / constructors with methods like LoDash isNative
})(Function.prototype, TO_STRING, function toString() {
  return typeof this == 'function' && this[SRC] || $toString.call(this);
});


/***/ }),
/* 82 */
/***/ (function(module, exports, __webpack_require__) {

var dP = __webpack_require__(83);
var createDesc = __webpack_require__(168);
module.exports = __webpack_require__(74) ? function (object, key, value) {
  return dP.f(object, key, createDesc(1, value));
} : function (object, key, value) {
  object[key] = value;
  return object;
};


/***/ }),
/* 83 */
/***/ (function(module, exports, __webpack_require__) {

var anObject = __webpack_require__(84);
var IE8_DOM_DEFINE = __webpack_require__(259);
var toPrimitive = __webpack_require__(261);
var dP = Object.defineProperty;

exports.f = __webpack_require__(74) ? Object.defineProperty : function defineProperty(O, P, Attributes) {
  anObject(O);
  P = toPrimitive(P, true);
  anObject(Attributes);
  if (IE8_DOM_DEFINE) try {
    return dP(O, P, Attributes);
  } catch (e) { /* empty */ }
  if ('get' in Attributes || 'set' in Attributes) throw TypeError('Accessors not supported!');
  if ('value' in Attributes) O[P] = Attributes.value;
  return O;
};


/***/ }),
/* 84 */
/***/ (function(module, exports, __webpack_require__) {

var isObject = __webpack_require__(57);
module.exports = function (it) {
  if (!isObject(it)) throw TypeError(it + ' is not an object!');
  return it;
};


/***/ }),
/* 85 */
/***/ (function(module, exports) {

var hasOwnProperty = {}.hasOwnProperty;
module.exports = function (it, key) {
  return hasOwnProperty.call(it, key);
};


/***/ }),
/* 86 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = multiReplaceStatement;

var _copyComments = __webpack_require__(100);

var _copyComments2 = _interopRequireDefault(_copyComments);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

/**
 * Replaces `node` inside `parent` with any number of `replacements`.
 *
 * ESTraverse only allows replacing one node with a single other node.
 * This function overcomes this limitation, allowing to replace it with multiple nodes.
 *
 * NOTE: Only works for nodes that allow multiple elements in their body.
 *       When node doesn't exist inside parent, does nothing.
 *
 * @param  {Object} cfg
 *   @param  {Object} cfg.parent Parent node of the node to replace
 *   @param  {Object} cfg.node The node to replace
 *   @param  {Object[]} cfg.replacements Replacement nodes (can be empty array)
 *   @param  {Boolean} [cfg.preserveComments] True to copy over comments from
 *     node to first replacement node
 */
function multiReplaceStatement(_ref) {
  var parent = _ref.parent,
      node = _ref.node,
      replacements = _ref.replacements,
      preserveComments = _ref.preserveComments;

  var body = getBody(parent);
  var index = body.indexOf(node);
  if (preserveComments && replacements[0]) {
    (0, _copyComments2.default)({ from: node, to: replacements[0] });
  }
  if (index !== -1) {
    body.splice.apply(body, [index, 1].concat(_toConsumableArray(replacements)));
  }
}

function getBody(node) {
  switch (node.type) {
    case 'BlockStatement':
    case 'Program':
      return node.body;
    case 'SwitchCase':
      return node.consequent;
    default:
      throw 'Unsupported node type \'' + node.type + '\' in multiReplaceStatement()';
  }
}
module.exports = exports['default'];

/***/ }),
/* 87 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isFunction = isFunction;
exports.isFunctionExpression = isFunctionExpression;
exports.isFunctionDeclaration = isFunctionDeclaration;
/**
 * True when node is any kind of function.
 */
function isFunction(node) {
  return isFunctionDeclaration(node) || isFunctionExpression(node);
}

/**
 * True when node is (arrow) function expression.
 */
function isFunctionExpression(node) {
  return node.type === 'FunctionExpression' || node.type === 'ArrowFunctionExpression';
}

/**
 * True when node is function declaration.
 */
function isFunctionDeclaration(node) {
  return node.type === 'FunctionDeclaration';
}

/***/ }),
/* 88 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _undefined = __webpack_require__(284)(); // Support ES3 engines

module.exports = function (val) {
 return (val !== _undefined) && (val !== null);
};


/***/ }),
/* 89 */
/***/ (function(module, exports, __webpack_require__) {

// optional / simple context binding
var aFunction = __webpack_require__(304);
module.exports = function (fn, that, length) {
  aFunction(fn);
  if (that === undefined) return fn;
  switch (length) {
    case 1: return function (a) {
      return fn.call(that, a);
    };
    case 2: return function (a, b) {
      return fn.call(that, a, b);
    };
    case 3: return function (a, b, c) {
      return fn.call(that, a, b, c);
    };
  }
  return function (/* ...args */) {
    return fn.apply(that, arguments);
  };
};


/***/ }),
/* 90 */
/***/ (function(module, exports, __webpack_require__) {

// to indexed object, toObject with fallback for non-array-like ES3 strings
var IObject = __webpack_require__(185);
var defined = __webpack_require__(181);
module.exports = function (it) {
  return IObject(defined(it));
};


/***/ }),
/* 91 */
/***/ (function(module, exports, __webpack_require__) {

module.exports = { "default": __webpack_require__(685), __esModule: true };

/***/ }),
/* 92 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateByteDataBlock = CreateByteDataBlock;
exports.CopyDataBlockBytes = CopyDataBlockBytes;
exports.AllocateArrayBuffer = AllocateArrayBuffer;
exports.DetachArrayBuffer = DetachArrayBuffer;
exports.GetViewValue = GetViewValue;
exports.GetValueFromBuffer = GetValueFromBuffer;
exports.SetViewValue = SetViewValue;
exports.CloneArrayBuffer = CloneArrayBuffer;
exports.SetValueInBuffer = SetValueInBuffer;

var _index = __webpack_require__(0);

var _construct = __webpack_require__(35);

var _index2 = __webpack_require__(5);

var _is = __webpack_require__(9);

var _singletons = __webpack_require__(2);

var _invariant = __webpack_require__(1);

var _invariant2 = _interopRequireDefault(_invariant);

var _types = __webpack_require__(221);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// ECMA262 6.2.6.1
function CreateByteDataBlock(realm, size) {
  // 1. Assert: size≥0.
  (0, _invariant2.default)(size >= 0, "size >= 0");

  // 2. Let db be a new Data Block value consisting of size bytes. If it is impossible to create such a Data Block, throw a RangeError exception.
  let db;
  try {
    db = new Uint8Array(size);
  } catch (e) {
    if (e instanceof RangeError) {
      throw realm.createErrorThrowCompletion(realm.intrinsics.RangeError, "Invalid typed array length");
    } else {
      throw e;
    }
  }

  // 3. Set all of the bytes of db to 0.
  for (let i = 0; i < size; ++i) {
    db[i] = 0;
  }

  // 4. Return db.
  return db;
}

// ECMA262 6.2.6.2
/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 */

function CopyDataBlockBytes(realm, toBlock, toIndex, fromBlock, fromIndex, count) {
  // 1. Assert: fromBlock and toBlock are distinct Data Block values.
  (0, _invariant2.default)(toBlock instanceof Uint8Array && fromBlock instanceof Uint8Array && toBlock !== fromBlock);

  // 2. Assert: fromIndex, toIndex, and count are integer values ≥ 0.
  (0, _invariant2.default)(toIndex >= 0 && fromIndex >= 0 && count >= 0);

  // 3. Let fromSize be the number of bytes in fromBlock.
  let fromSize = fromBlock.length;

  // 4. Assert: fromIndex+count ≤ fromSize.
  (0, _invariant2.default)(fromIndex + count <= fromSize, "fromIndex+count ≤ fromSize");

  // 5. Let toSize be the number of bytes in toBlock.
  let toSize = toBlock.length;

  // 6. Assert: toIndex+count ≤ toSize.
  (0, _invariant2.default)(toIndex + count <= toSize, "toIndex+count ≤ toSize");

  // 7. Repeat, while count>0
  while (count > 0) {
    // a. Set toBlock[toIndex] to the value of fromBlock[fromIndex].
    toBlock[toIndex] = fromBlock[fromIndex];

    // b. Increment toIndex and fromIndex each by 1.
    toIndex += 1;
    fromIndex += 1;

    // c. Decrement count by 1.
    count -= 1;
  }

  // 8. Return NormalCompletion(empty).
  return realm.intrinsics.empty;
}

// ECMA262 24.1.1.1
function AllocateArrayBuffer(realm, constructor, byteLength) {
  // 1. Let obj be ? OrdinaryCreateFromConstructor(constructor, "%ArrayBufferPrototype%", « [[ArrayBufferData]], [[ArrayBufferByteLength]] »).
  let obj = _singletons.Create.OrdinaryCreateFromConstructor(realm, constructor, "ArrayBufferPrototype", {
    $ArrayBufferData: undefined,
    $ArrayBufferByteLength: undefined
  });

  // 2. Assert: byteLength is an integer value ≥ 0.
  (0, _invariant2.default)(typeof byteLength === "number" && byteLength >= 0, "byteLength is an integer value ≥ 0");

  // 3. Let block be ? CreateByteDataBlock(byteLength).
  let block = CreateByteDataBlock(realm, byteLength);

  // 4. Set obj's [[ArrayBufferData]] internal slot to block.
  obj.$ArrayBufferData = block;

  // 5. Set obj's [[ArrayBufferByteLength]] internal slot to byteLength.
  obj.$ArrayBufferByteLength = byteLength;

  // 6. Return obj.
  return obj;
}

// ECMA262 24.1.1.3
function DetachArrayBuffer(realm, arrayBuffer) {
  // 1. Assert: Type(arrayBuffer) is Object and it has [[ArrayBufferData]] and [[ArrayBufferByteLength]] internal slots.
  (0, _invariant2.default)(arrayBuffer instanceof _index.ObjectValue && "$ArrayBufferData" in arrayBuffer && "$ArrayBufferByteLength" in arrayBuffer);

  // 2. Set arrayBuffer.[[ArrayBufferData]] to null.
  _singletons.Properties.ThrowIfInternalSlotNotWritable(realm, arrayBuffer, "$ArrayBufferData").$ArrayBufferData = null;

  // 3. Set arrayBuffer.[[ArrayBufferByteLength]] to 0.
  _singletons.Properties.ThrowIfInternalSlotNotWritable(realm, arrayBuffer, "$ArrayBufferByteLength").$ArrayBufferByteLength = 0;

  // 4. Return NormalCompletion(null).
  return realm.intrinsics.null;
}

// ECMA262 24.2.1.1
function GetViewValue(realm, view, requestIndex, isLittleEndian, type) {
  view = view.throwIfNotConcrete();

  // 1. If Type(view) is not Object, throw a TypeError exception.
  if (!(view instanceof _index.ObjectValue)) {
    throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "Type(view) is not Object");
  }

  // 2. If view does not have a [[DataView]] internal slot, throw a TypeError exception.
  if (!("$DataView" in view)) {
    throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "view does not have a [[DataView]] internal slot");
  }

  // 3. Assert: view has a [[ViewedArrayBuffer]] internal slot.
  (0, _invariant2.default)(view.$ViewedArrayBuffer);

  // 4. Let getIndex be ? ToIndex(requestIndex).
  let getIndex = _singletons.To.ToIndexPartial(realm, requestIndex);

  // 5. Let littleEndian be ToBoolean(isLittleEndian).
  let littleEndian = _singletons.To.ToBooleanPartial(realm, isLittleEndian);

  // 6. Let buffer be view.[[ViewedArrayBuffer]].
  let buffer = view.$ViewedArrayBuffer;
  (0, _invariant2.default)(buffer);

  // 7. If IsDetachedBuffer(buffer) is true, throw a TypeError exception.
  if ((0, _is.IsDetachedBuffer)(realm, buffer) === true) {
    throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "IsDetachedBuffer(buffer) is true");
  }

  // 8. Let viewOffset be view.[[ByteOffset]].
  let viewOffset = view.$ByteOffset;
  (0, _invariant2.default)(typeof viewOffset === "number");

  // 9. Let viewSize be view.[[ByteLength]].
  let viewSize = view.$ByteLength;
  (0, _invariant2.default)(typeof viewSize === "number");

  // 10. Let elementSize be the Number value of the Element Size value specified in Table 50 for Element Type type.
  let elementSize = _types.ElementSize[type];

  // 11. If getIndex + elementSize > viewSize, throw a RangeError exception.
  if (getIndex + elementSize > viewSize) {
    throw realm.createErrorThrowCompletion(realm.intrinsics.RangeError, "getIndex + elementSize > viewSize");
  }

  // 12. Let bufferIndex be getIndex + viewOffset.
  let bufferIndex = getIndex + viewOffset;

  // 13. Return GetValueFromBuffer(buffer, bufferIndex, type, littleEndian).
  return GetValueFromBuffer(realm, buffer, bufferIndex, type, littleEndian);
}

// ECMA262 24.1.1.5
function GetValueFromBuffer(realm, arrayBuffer, byteIndex, type, isLittleEndian) {
  // 1. Assert: IsDetachedBuffer(arrayBuffer) is false.
  (0, _invariant2.default)((0, _is.IsDetachedBuffer)(realm, arrayBuffer) === false);

  // 2. Assert: There are sufficient bytes in arrayBuffer starting at byteIndex to represent a value of type.
  (0, _invariant2.default)(arrayBuffer.$ArrayBufferData instanceof Uint8Array && byteIndex + _types.ElementSize[type] <= arrayBuffer.$ArrayBufferData.length);

  // 3. Assert: byteIndex is an integer value ≥ 0.
  (0, _invariant2.default)(byteIndex >= 0);

  // 4. Let block be arrayBuffer.[[ArrayBufferData]].
  let block = arrayBuffer.$ArrayBufferData;
  (0, _invariant2.default)(block instanceof Uint8Array);

  // 5. Let elementSize be the Number value of the Element Size value specified in Table 50 for Element Type type.
  let elementSize = _types.ElementSize[type];

  // 6. Let rawValue be a List of elementSize containing, in order, the elementSize sequence of bytes starting with block[byteIndex].
  let rawValue = new DataView(block.buffer, byteIndex, elementSize);

  // 7. If isLittleEndian is not present, set isLittleEndian to either true or false. The choice is implementation dependent and should be the alternative that is most efficient for the implementation. An implementation must use the same value each time this step is executed and the same value must be used for the corresponding step in the SetValueInBuffer abstract operation.
  if (isLittleEndian === undefined) isLittleEndian = true;

  // 8. If isLittleEndian is false, reverse the order of the elements of rawValue.

  // 9. If type is "Float32", then
  if (type === "Float32") {
    // a. Let value be the byte elements of rawValue concatenated and interpreted as a little-endian bit string encoding of an IEEE 754-2008 binary32 value.
    // b. If value is an IEEE 754-2008 binary32 NaN value, return the NaN Number value.
    // c. Return the Number value that corresponds to value.
    return new _index.NumberValue(realm, rawValue.getFloat32(0, isLittleEndian));
  }

  // 10. If type is "Float64", then
  if (type === "Float64") {
    // a. Let value be the byte elements of rawValue concatenated and interpreted as a little-endian bit string encoding of an IEEE 754-2008 binary64 value.
    // b. If value is an IEEE 754-2008 binary64 NaN value, return the NaN Number value.
    // c. Return the Number value that corresponds to value.
    return new _index.NumberValue(realm, rawValue.getFloat64(0, isLittleEndian));
  }

  let intValue;
  // 11. If the first code unit of type is "U", then
  if (type === "Uint8" || type === "Uint16" || type === "Uint32" || type === "Uint8Clamped") {
    // a. Let intValue be the byte elements of rawValue concatenated and interpreted as a bit string encoding of an unsigned little-endian binary number.
    if (elementSize === 1) {
      intValue = rawValue.getUint8(0);
    } else if (elementSize === 2) {
      intValue = rawValue.getUint16(0, isLittleEndian);
    } else {
      intValue = rawValue.getUint32(0, isLittleEndian);
    }
  } else {
    // 12. Else,
    // a. Let intValue be the byte elements of rawValue concatenated and interpreted as a bit string encoding of a binary little-endian 2's complement number of bit length elementSize × 8.
    if (elementSize === 1) {
      intValue = rawValue.getInt8(0);
    } else if (elementSize === 2) {
      intValue = rawValue.getInt16(0, isLittleEndian);
    } else {
      intValue = rawValue.getInt32(0, isLittleEndian);
    }
  }

  // 13. Return the Number value that corresponds to intValue.
  return new _index.NumberValue(realm, intValue);
}

// ECMA262 24.2.1.2
function SetViewValue(realm, view, requestIndex, isLittleEndian, type, value) {
  view = view.throwIfNotConcrete();

  // 1. If Type(view) is not Object, throw a TypeError exception.
  if (!(view instanceof _index.ObjectValue)) {
    throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "Type(view) is not Object");
  }

  // 2. If view does not have a [[DataView]] internal slot, throw a TypeError exception.
  if (!("$DataView" in view)) {
    throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "view does not have a [[DataView]] internal slot");
  }

  // 3. Assert: view has a [[ViewedArrayBuffer]] internal slot.
  (0, _invariant2.default)(view.$ViewedArrayBuffer);

  // 4. Let getIndex be ? ToIndex(requestIndex).
  let getIndex = _singletons.To.ToIndexPartial(realm, requestIndex);

  // 5. Let numberValue be ? ToNumber(value).
  let numberValue = _singletons.To.ToNumber(realm, value);

  // 6. Let littleEndian be ToBoolean(isLittleEndian).
  let littleEndian = _singletons.To.ToBooleanPartial(realm, isLittleEndian);

  // 7. Let buffer be view.[[ViewedArrayBuffer]].
  let buffer = view.$ViewedArrayBuffer;
  (0, _invariant2.default)(buffer);

  // 8. If IsDetachedBuffer(buffer) is true, throw a TypeError exception.
  if ((0, _is.IsDetachedBuffer)(realm, buffer) === true) {
    throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "IsDetachedBuffer(buffer) is true");
  }

  // 9. Let viewOffset be view.[[ByteOffset]].
  let viewOffset = view.$ByteOffset;
  (0, _invariant2.default)(typeof viewOffset === "number");

  // 10. Let viewSize be view.[[ByteLength]].
  let viewSize = view.$ByteLength;
  (0, _invariant2.default)(typeof viewSize === "number");

  // 11. Let elementSize be the Number value of the Element Size value specified in Table 50 for Element Type type.
  let elementSize = _types.ElementSize[type];

  // 12. If getIndex + elementSize > viewSize, throw a RangeError exception.
  if (getIndex + elementSize > viewSize) {
    throw realm.createErrorThrowCompletion(realm.intrinsics.RangeError, "getIndex + elementSize > viewSize");
  }

  // 13. Let bufferIndex be getIndex + viewOffset.
  let bufferIndex = getIndex + viewOffset;

  // 14. Return SetValueInBuffer(buffer, bufferIndex, type, numberValue, littleEndian).
  return SetValueInBuffer(realm, buffer, bufferIndex, type, numberValue, littleEndian);
}

// ECMA262 24.1.1.4
function CloneArrayBuffer(realm, srcBuffer, srcByteOffset, cloneConstructor) {
  // 1. Assert: Type(srcBuffer) is Object and it has an [[ArrayBufferData]] internal slot.
  (0, _invariant2.default)(srcBuffer instanceof _index.ObjectValue && srcBuffer.$ArrayBufferData);

  // 2. If cloneConstructor is not present, then
  if (cloneConstructor === undefined) {
    // a. Let cloneConstructor be ? SpeciesConstructor(srcBuffer, %ArrayBuffer%).
    cloneConstructor = (0, _construct.SpeciesConstructor)(realm, srcBuffer, realm.intrinsics.ArrayBuffer);

    // b. If IsDetachedBuffer(srcBuffer) is true, throw a TypeError exception.
    if ((0, _is.IsDetachedBuffer)(realm, srcBuffer) === true) {
      throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "IsDetachedBuffer(srcBuffer) is true");
    }
  }

  // 3. Else, Assert: IsConstructor(cloneConstructor) is true.
  (0, _invariant2.default)((0, _index2.IsConstructor)(realm, cloneConstructor) === true, "IsConstructor(cloneConstructor) is true");

  // 4. Let srcLength be the value of srcBuffer's [[ArrayBufferByteLength]] internal slot.
  let srcLength = srcBuffer.$ArrayBufferByteLength;
  (0, _invariant2.default)(typeof srcLength === "number");

  // 5. Assert: srcByteOffset ≤ srcLength.
  (0, _invariant2.default)(srcByteOffset <= srcLength, "srcByteOffset ≤ srcLength");

  // 6. Let cloneLength be srcLength - srcByteOffset.
  let cloneLength = srcLength - srcByteOffset;

  // 7. Let srcBlock be srcBuffer.[[ArrayBufferData]].
  let srcBlock = srcBuffer.$ArrayBufferData;
  (0, _invariant2.default)(srcBlock);

  // 8. Let targetBuffer be ? AllocateArrayBuffer(cloneConstructor, srcLength).
  let targetBuffer = AllocateArrayBuffer(realm, cloneConstructor, srcLength);

  // 9. If IsDetachedBuffer(srcBuffer) is true, throw a TypeError exception.
  if ((0, _is.IsDetachedBuffer)(realm, srcBuffer) === true) {
    throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "IsDetachedBuffer(srcBuffer) is true");
  }

  // 10. Let targetBlock be targetBuffer.[[ArrayBufferData]].
  let targetBlock = targetBuffer.$ArrayBufferData;
  (0, _invariant2.default)(targetBlock);

  // 11. Perform CopyDataBlockBytes(targetBlock, 0, srcBlock, srcByteOffset, cloneLength).
  CopyDataBlockBytes(realm, targetBlock, 0, srcBlock, srcByteOffset, cloneLength);

  // 12. Return targetBuffer.
  return targetBuffer;
}

// ECMA262 24.1.1.6
function SetValueInBuffer(realm, arrayBuffer, byteIndex, type, value, isLittleEndian) {
  // 1. Assert: IsDetachedBuffer(arrayBuffer) is false.
  (0, _invariant2.default)((0, _is.IsDetachedBuffer)(realm, arrayBuffer) === false);

  // 2. Assert: There are sufficient bytes in arrayBuffer starting at byteIndex to represent a value of type.
  (0, _invariant2.default)(arrayBuffer.$ArrayBufferData instanceof Uint8Array && byteIndex + _types.ElementSize[type] <= arrayBuffer.$ArrayBufferData.length);

  // 3. Assert: byteIndex is an integer value ≥ 0.
  (0, _invariant2.default)(byteIndex >= 0);

  // 4. Assert: Type(value) is Number.
  (0, _invariant2.default)(typeof value === "number");

  // 5. Let block be arrayBuffer.[[ArrayBufferData]].
  let block = _singletons.Properties.ThrowIfInternalSlotNotWritable(realm, arrayBuffer, "$ArrayBufferData").$ArrayBufferData;

  // 6. Assert: block is not undefined.
  (0, _invariant2.default)(block instanceof Uint8Array);

  // 7. If isLittleEndian is not present, set isLittleEndian to either true or false. The choice is implementation dependent and should be the alternative that is most efficient for the implementation. An implementation must use the same value each time this step is executed and the same value must be used for the corresponding step in the SetValueInBuffer abstract operation.
  if (isLittleEndian === undefined) isLittleEndian = true;

  let rawBytes = new Uint8Array(_types.ElementSize[type]);
  // 8. If type is "Float32", then
  if (type === "Float32") {
    // a. Set rawBytes to a List containing the 4 bytes that are the result of converting value to IEEE 754-2008 binary32 format using “Round to nearest, ties to even” rounding mode. If isLittleEndian is false, the bytes are arranged in big endian order. Otherwise, the bytes are arranged in little endian order. If value is NaN, rawValue may be set to any implementation chosen IEEE 754-2008 binary32 format Not-a-Number encoding. An implementation must always choose the same encoding for each implementation distinguishable NaN value.
    new DataView(rawBytes.buffer).setFloat32(0, value, isLittleEndian);
  } else if (type === "Float64") {
    // 9. Else if type is "Float64", then
    // a. Set rawBytes to a List containing the 8 bytes that are the IEEE 754-2008 binary64 format encoding of value. If isLittleEndian is false, the bytes are arranged in big endian order. Otherwise, the bytes are arranged in little endian order. If value is NaN, rawValue may be set to any implementation chosen IEEE 754-2008 binary64 format Not-a-Number encoding. An implementation must always choose the same encoding for each implementation distinguishable NaN value.
    new DataView(rawBytes.buffer).setFloat64(0, value, isLittleEndian);
  } else {
    // 10. Else,
    // a. Let n be the Number value of the Element Size specified in Table 50 for Element Type type.
    let n = _types.ElementSize[type];

    // b. Let convOp be the abstract operation named in the Conversion Operation column in Table 50 for Element Type type.
    let convOp = _singletons.To.ElementConv[type];

    // c. Let intValue be convOp(value).
    let intValue = convOp(realm, value);

    // d. If intValue ≥ 0, then
    if (intValue > 0) {
      // i. Let rawBytes be a List containing the n-byte binary encoding of intValue. If isLittleEndian is false, the bytes are ordered in big endian order. Otherwise, the bytes are ordered in little endian order.
      if (n === 1) {
        new DataView(rawBytes.buffer).setUint8(0, intValue);
      } else if (n === 2) {
        new DataView(rawBytes.buffer).setUint16(0, intValue, isLittleEndian);
      } else if (n === 4) {
        new DataView(rawBytes.buffer).setUint32(0, intValue, isLittleEndian);
      } else {
        (0, _invariant2.default)(false);
      }
    } else {
      // e. Else,
      // i. Let rawBytes be a List containing the n-byte binary 2's complement encoding of intValue. If isLittleEndian is false, the bytes are ordered in big endian order. Otherwise, the bytes are ordered in little endian order.
      if (n === 1) {
        new DataView(rawBytes.buffer).setInt8(0, intValue);
      } else if (n === 2) {
        new DataView(rawBytes.buffer).setInt16(0, intValue, isLittleEndian);
      } else if (n === 4) {
        new DataView(rawBytes.buffer).setInt32(0, intValue, isLittleEndian);
      } else {
        (0, _invariant2.default)(false);
      }
    }
  }

  // 11. Store the individual bytes of rawBytes into block, in order, starting at block[byteIndex].
  for (let i = 0; i < rawBytes.length; ++i) {
    block[byteIndex + i] = rawBytes[i];
  }

  // 12. Return NormalCompletion(undefined).
  return realm.intrinsics.undefined;
}

/***/ }),
/* 93 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.protoExpression = exports.constructorExpression = exports.emptyExpression = exports.nullExpression = exports.voidExpression = undefined;

var _babelTypes = __webpack_require__(4);

var t = _interopRequireWildcard(_babelTypes);

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 */

const voidExpression = exports.voidExpression = t.unaryExpression("void", t.numericLiteral(0), true);
const nullExpression = exports.nullExpression = t.nullLiteral();
const emptyExpression = exports.emptyExpression = t.identifier("__empty");
const constructorExpression = exports.constructorExpression = t.identifier("__constructor");
const protoExpression = exports.protoExpression = t.identifier("__proto__");

/***/ }),
/* 94 */
/***/ (function(module, exports, __webpack_require__) {

module.exports = function (fork) {
    fork.use(__webpack_require__(246));

    var types = fork.use(__webpack_require__(22));
    var def = types.Type.def;
    var or = types.Type.or;
    var builtin = types.builtInTypes;
    var defaults = fork.use(__webpack_require__(56)).defaults;

    def("Function")
      .field("async", Boolean, defaults["false"]);

    def("SpreadProperty")
      .bases("Node")
      .build("argument")
      .field("argument", def("Expression"));

    def("ObjectExpression")
      .field("properties", [or(def("Property"), def("SpreadProperty"))]);

    def("SpreadPropertyPattern")
      .bases("Pattern")
      .build("argument")
      .field("argument", def("Pattern"));

    def("ObjectPattern")
      .field("properties", [or(
        def("Property"),
        def("PropertyPattern"),
        def("SpreadPropertyPattern")
      )]);

    def("AwaitExpression")
      .bases("Expression")
      .build("argument", "all")
      .field("argument", or(def("Expression"), null))
      .field("all", Boolean, defaults["false"]);
};

/***/ }),
/* 95 */
/***/ (function(module, exports, __webpack_require__) {

var assert = __webpack_require__(25);
var sourceMap = __webpack_require__(166);
var normalizeOptions = __webpack_require__(167).normalize;
var secretKey = __webpack_require__(252).makeUniqueKey();
var types = __webpack_require__(48);
var isString = types.builtInTypes.string;
var comparePos = __webpack_require__(80).comparePos;
var Mapping = __webpack_require__(504);

// Goals:
// 1. Minimize new string creation.
// 2. Keep (de)identation O(lines) time.
// 3. Permit negative indentations.
// 4. Enforce immutability.
// 5. No newline characters.

var useSymbol = typeof Symbol === "function";
var secretKey = "recastLinesSecret";
if (useSymbol) {
  secretKey = Symbol.for(secretKey);
}

function getSecret(lines) {
  return lines[secretKey];
}

function Lines(infos, sourceFileName) {
  assert.ok(this instanceof Lines);
  assert.ok(infos.length > 0);

  if (sourceFileName) {
    isString.assert(sourceFileName);
  } else {
    sourceFileName = null;
  }

  setSymbolOrKey(this, secretKey, {
    infos: infos,
    mappings: [],
    name: sourceFileName,
    cachedSourceMap: null
  });

  this.length = infos.length;
  this.name = sourceFileName;

  if (sourceFileName) {
    getSecret(this).mappings.push(new Mapping(this, {
      start: this.firstPos(),
      end: this.lastPos()
    }));
  }
}

function setSymbolOrKey(obj, key, value) {
  if (useSymbol) {
    return obj[key] = value;
  }

  Object.defineProperty(obj, key, {
    value: value,
    enumerable: false,
    writable: false,
    configurable: true
  });

  return value;
}

// Exposed for instanceof checks. The fromString function should be used
// to create new Lines objects.
exports.Lines = Lines;
var Lp = Lines.prototype;

function copyLineInfo(info) {
  return {
    line: info.line,
    indent: info.indent,
    locked: info.locked,
    sliceStart: info.sliceStart,
    sliceEnd: info.sliceEnd
  };
}

var fromStringCache = {};
var hasOwn = fromStringCache.hasOwnProperty;
var maxCacheKeyLen = 10;

function countSpaces(spaces, tabWidth) {
  var count = 0;
  var len = spaces.length;

  for (var i = 0; i < len; ++i) {
    switch (spaces.charCodeAt(i)) {
    case 9: // '\t'
      assert.strictEqual(typeof tabWidth, "number");
      assert.ok(tabWidth > 0);

      var next = Math.ceil(count / tabWidth) * tabWidth;
      if (next === count) {
        count += tabWidth;
      } else {
        count = next;
      }

      break;

    case 11: // '\v'
    case 12: // '\f'
    case 13: // '\r'
    case 0xfeff: // zero-width non-breaking space
      // These characters contribute nothing to indentation.
      break;

    case 32: // ' '
    default: // Treat all other whitespace like ' '.
      count += 1;
      break;
    }
  }

  return count;
}
exports.countSpaces = countSpaces;

var leadingSpaceExp = /^\s*/;

// As specified here: http://www.ecma-international.org/ecma-262/6.0/#sec-line-terminators
var lineTerminatorSeqExp =
  /\u000D\u000A|\u000D(?!\u000A)|\u000A|\u2028|\u2029/;

/**
 * @param {Object} options - Options object that configures printing.
 */
function fromString(string, options) {
  if (string instanceof Lines)
    return string;

  string += "";

  var tabWidth = options && options.tabWidth;
  var tabless = string.indexOf("\t") < 0;
  var locked = !! (options && options.locked);
  var cacheable = !options && tabless && (string.length <= maxCacheKeyLen);

  assert.ok(tabWidth || tabless, "No tab width specified but encountered tabs in string\n" + string);

  if (cacheable && hasOwn.call(fromStringCache, string))
    return fromStringCache[string];

  var lines = new Lines(string.split(lineTerminatorSeqExp).map(function(line) {
    var spaces = leadingSpaceExp.exec(line)[0];
    return {
      line: line,
      indent: countSpaces(spaces, tabWidth),
      // Boolean indicating whether this line can be reindented.
      locked: locked,
      sliceStart: spaces.length,
      sliceEnd: line.length
    };
  }), normalizeOptions(options).sourceFileName);

  if (cacheable)
    fromStringCache[string] = lines;

  return lines;
}
exports.fromString = fromString;

function isOnlyWhitespace(string) {
  return !/\S/.test(string);
}

Lp.toString = function(options) {
  return this.sliceString(this.firstPos(), this.lastPos(), options);
};

Lp.getSourceMap = function(sourceMapName, sourceRoot) {
  if (!sourceMapName) {
    // Although we could make up a name or generate an anonymous
    // source map, instead we assume that any consumer who does not
    // provide a name does not actually want a source map.
    return null;
  }

  var targetLines = this;

  function updateJSON(json) {
    json = json || {};

    isString.assert(sourceMapName);
    json.file = sourceMapName;

    if (sourceRoot) {
      isString.assert(sourceRoot);
      json.sourceRoot = sourceRoot;
    }

    return json;
  }

  var secret = getSecret(targetLines);
  if (secret.cachedSourceMap) {
    // Since Lines objects are immutable, we can reuse any source map
    // that was previously generated. Nevertheless, we return a new
    // JSON object here to protect the cached source map from outside
    // modification.
    return updateJSON(secret.cachedSourceMap.toJSON());
  }

  var smg = new sourceMap.SourceMapGenerator(updateJSON());
  var sourcesToContents = {};

  secret.mappings.forEach(function(mapping) {
    var sourceCursor = mapping.sourceLines.skipSpaces(
      mapping.sourceLoc.start
    ) || mapping.sourceLines.lastPos();

    var targetCursor = targetLines.skipSpaces(
      mapping.targetLoc.start
    ) || targetLines.lastPos();

    while (comparePos(sourceCursor, mapping.sourceLoc.end) < 0 &&
           comparePos(targetCursor, mapping.targetLoc.end) < 0) {

      var sourceChar = mapping.sourceLines.charAt(sourceCursor);
      var targetChar = targetLines.charAt(targetCursor);
      assert.strictEqual(sourceChar, targetChar);

      var sourceName = mapping.sourceLines.name;

      // Add mappings one character at a time for maximum resolution.
      smg.addMapping({
        source: sourceName,
        original: { line: sourceCursor.line,
                    column: sourceCursor.column },
        generated: { line: targetCursor.line,
                     column: targetCursor.column }
      });

      if (!hasOwn.call(sourcesToContents, sourceName)) {
        var sourceContent = mapping.sourceLines.toString();
        smg.setSourceContent(sourceName, sourceContent);
        sourcesToContents[sourceName] = sourceContent;
      }

      targetLines.nextPos(targetCursor, true);
      mapping.sourceLines.nextPos(sourceCursor, true);
    }
  });

  secret.cachedSourceMap = smg;

  return smg.toJSON();
};

Lp.bootstrapCharAt = function(pos) {
  assert.strictEqual(typeof pos, "object");
  assert.strictEqual(typeof pos.line, "number");
  assert.strictEqual(typeof pos.column, "number");

  var line = pos.line,
  column = pos.column,
  strings = this.toString().split(lineTerminatorSeqExp),
  string = strings[line - 1];

  if (typeof string === "undefined")
    return "";

  if (column === string.length &&
      line < strings.length)
    return "\n";

  if (column >= string.length)
    return "";

  return string.charAt(column);
};

Lp.charAt = function(pos) {
  assert.strictEqual(typeof pos, "object");
  assert.strictEqual(typeof pos.line, "number");
  assert.strictEqual(typeof pos.column, "number");

  var line = pos.line,
  column = pos.column,
  secret = getSecret(this),
  infos = secret.infos,
  info = infos[line - 1],
  c = column;

  if (typeof info === "undefined" || c < 0)
    return "";

  var indent = this.getIndentAt(line);
  if (c < indent)
    return " ";

  c += info.sliceStart - indent;

  if (c === info.sliceEnd &&
      line < this.length)
    return "\n";

  if (c >= info.sliceEnd)
    return "";

  return info.line.charAt(c);
};

Lp.stripMargin = function(width, skipFirstLine) {
  if (width === 0)
    return this;

  assert.ok(width > 0, "negative margin: " + width);

  if (skipFirstLine && this.length === 1)
    return this;

  var secret = getSecret(this);

  var lines = new Lines(secret.infos.map(function(info, i) {
    if (info.line && (i > 0 || !skipFirstLine)) {
      info = copyLineInfo(info);
      info.indent = Math.max(0, info.indent - width);
    }
    return info;
  }));

  if (secret.mappings.length > 0) {
    var newMappings = getSecret(lines).mappings;
    assert.strictEqual(newMappings.length, 0);
    secret.mappings.forEach(function(mapping) {
      newMappings.push(mapping.indent(width, skipFirstLine, true));
    });
  }

  return lines;
};

Lp.indent = function(by) {
  if (by === 0)
    return this;

  var secret = getSecret(this);

  var lines = new Lines(secret.infos.map(function(info) {
    if (info.line && ! info.locked) {
      info = copyLineInfo(info);
      info.indent += by;
    }
    return info
  }));

  if (secret.mappings.length > 0) {
    var newMappings = getSecret(lines).mappings;
    assert.strictEqual(newMappings.length, 0);
    secret.mappings.forEach(function(mapping) {
      newMappings.push(mapping.indent(by));
    });
  }

  return lines;
};

Lp.indentTail = function(by) {
  if (by === 0)
    return this;

  if (this.length < 2)
    return this;

  var secret = getSecret(this);

  var lines = new Lines(secret.infos.map(function(info, i) {
    if (i > 0 && info.line && ! info.locked) {
      info = copyLineInfo(info);
      info.indent += by;
    }

    return info;
  }));

  if (secret.mappings.length > 0) {
    var newMappings = getSecret(lines).mappings;
    assert.strictEqual(newMappings.length, 0);
    secret.mappings.forEach(function(mapping) {
      newMappings.push(mapping.indent(by, true));
    });
  }

  return lines;
};

Lp.lockIndentTail = function () {
  if (this.length < 2) {
    return this;
  }

  var infos = getSecret(this).infos;

  return new Lines(infos.map(function (info, i) {
    info = copyLineInfo(info);
    info.locked = i > 0;
    return info;
  }));
};

Lp.getIndentAt = function(line) {
  assert.ok(line >= 1, "no line " + line + " (line numbers start from 1)");
  var secret = getSecret(this),
  info = secret.infos[line - 1];
  return Math.max(info.indent, 0);
};

Lp.guessTabWidth = function() {
  var secret = getSecret(this);
  if (hasOwn.call(secret, "cachedTabWidth")) {
    return secret.cachedTabWidth;
  }

  var counts = []; // Sparse array.
  var lastIndent = 0;

  for (var line = 1, last = this.length; line <= last; ++line) {
    var info = secret.infos[line - 1];
    var sliced = info.line.slice(info.sliceStart, info.sliceEnd);

    // Whitespace-only lines don't tell us much about the likely tab
    // width of this code.
    if (isOnlyWhitespace(sliced)) {
      continue;
    }

    var diff = Math.abs(info.indent - lastIndent);
    counts[diff] = ~~counts[diff] + 1;
    lastIndent = info.indent;
  }

  var maxCount = -1;
  var result = 2;

  for (var tabWidth = 1;
       tabWidth < counts.length;
       tabWidth += 1) {
    if (hasOwn.call(counts, tabWidth) &&
        counts[tabWidth] > maxCount) {
      maxCount = counts[tabWidth];
      result = tabWidth;
    }
  }

  return secret.cachedTabWidth = result;
};

// Determine if the list of lines has a first line that starts with a //
// or /* comment. If this is the case, the code may need to be wrapped in
// parens to avoid ASI issues.
Lp.startsWithComment = function () {
  var secret = getSecret(this);
  if (secret.infos.length === 0) {
    return false;
  }
  var firstLineInfo = secret.infos[0],
  sliceStart = firstLineInfo.sliceStart,
  sliceEnd = firstLineInfo.sliceEnd,
  firstLine = firstLineInfo.line.slice(sliceStart, sliceEnd).trim();
  return firstLine.length === 0 ||
    firstLine.slice(0, 2) === "//" ||
    firstLine.slice(0, 2) === "/*";
};

Lp.isOnlyWhitespace = function() {
  return isOnlyWhitespace(this.toString());
};

Lp.isPrecededOnlyByWhitespace = function(pos) {
  var secret = getSecret(this);
  var info = secret.infos[pos.line - 1];
  var indent = Math.max(info.indent, 0);

  var diff = pos.column - indent;
  if (diff <= 0) {
    // If pos.column does not exceed the indentation amount, then
    // there must be only whitespace before it.
    return true;
  }

  var start = info.sliceStart;
  var end = Math.min(start + diff, info.sliceEnd);
  var prefix = info.line.slice(start, end);

  return isOnlyWhitespace(prefix);
};

Lp.getLineLength = function(line) {
  var secret = getSecret(this),
  info = secret.infos[line - 1];
  return this.getIndentAt(line) + info.sliceEnd - info.sliceStart;
};

Lp.nextPos = function(pos, skipSpaces) {
  var l = Math.max(pos.line, 0),
  c = Math.max(pos.column, 0);

  if (c < this.getLineLength(l)) {
    pos.column += 1;

    return skipSpaces
      ? !!this.skipSpaces(pos, false, true)
      : true;
  }

  if (l < this.length) {
    pos.line += 1;
    pos.column = 0;

    return skipSpaces
      ? !!this.skipSpaces(pos, false, true)
      : true;
  }

  return false;
};

Lp.prevPos = function(pos, skipSpaces) {
  var l = pos.line,
  c = pos.column;

  if (c < 1) {
    l -= 1;

    if (l < 1)
      return false;

    c = this.getLineLength(l);

  } else {
    c = Math.min(c - 1, this.getLineLength(l));
  }

  pos.line = l;
  pos.column = c;

  return skipSpaces
    ? !!this.skipSpaces(pos, true, true)
    : true;
};

Lp.firstPos = function() {
  // Trivial, but provided for completeness.
  return { line: 1, column: 0 };
};

Lp.lastPos = function() {
  return {
    line: this.length,
    column: this.getLineLength(this.length)
  };
};

Lp.skipSpaces = function(pos, backward, modifyInPlace) {
  if (pos) {
    pos = modifyInPlace ? pos : {
      line: pos.line,
      column: pos.column
    };
  } else if (backward) {
    pos = this.lastPos();
  } else {
    pos = this.firstPos();
  }

  if (backward) {
    while (this.prevPos(pos)) {
      if (!isOnlyWhitespace(this.charAt(pos)) &&
          this.nextPos(pos)) {
        return pos;
      }
    }

    return null;

  } else {
    while (isOnlyWhitespace(this.charAt(pos))) {
      if (!this.nextPos(pos)) {
        return null;
      }
    }

    return pos;
  }
};

Lp.trimLeft = function() {
  var pos = this.skipSpaces(this.firstPos(), false, true);
  return pos ? this.slice(pos) : emptyLines;
};

Lp.trimRight = function() {
  var pos = this.skipSpaces(this.lastPos(), true, true);
  return pos ? this.slice(this.firstPos(), pos) : emptyLines;
};

Lp.trim = function() {
  var start = this.skipSpaces(this.firstPos(), false, true);
  if (start === null)
    return emptyLines;

  var end = this.skipSpaces(this.lastPos(), true, true);
  assert.notStrictEqual(end, null);

  return this.slice(start, end);
};

Lp.eachPos = function(callback, startPos, skipSpaces) {
  var pos = this.firstPos();

  if (startPos) {
    pos.line = startPos.line,
    pos.column = startPos.column
  }

  if (skipSpaces && !this.skipSpaces(pos, false, true)) {
    return; // Encountered nothing but spaces.
  }

  do callback.call(this, pos);
  while (this.nextPos(pos, skipSpaces));
};

Lp.bootstrapSlice = function(start, end) {
  var strings = this.toString().split(
    lineTerminatorSeqExp
  ).slice(
    start.line - 1,
    end.line
  );

  strings.push(strings.pop().slice(0, end.column));
  strings[0] = strings[0].slice(start.column);

  return fromString(strings.join("\n"));
};

Lp.slice = function(start, end) {
  if (!end) {
    if (!start) {
      // The client seems to want a copy of this Lines object, but
      // Lines objects are immutable, so it's perfectly adequate to
      // return the same object.
      return this;
    }

    // Slice to the end if no end position was provided.
    end = this.lastPos();
  }

  var secret = getSecret(this);
  var sliced = secret.infos.slice(start.line - 1, end.line);

  if (start.line === end.line) {
    sliced[0] = sliceInfo(sliced[0], start.column, end.column);
  } else {
    assert.ok(start.line < end.line);
    sliced[0] = sliceInfo(sliced[0], start.column);
    sliced.push(sliceInfo(sliced.pop(), 0, end.column));
  }

  var lines = new Lines(sliced);

  if (secret.mappings.length > 0) {
    var newMappings = getSecret(lines).mappings;
    assert.strictEqual(newMappings.length, 0);
    secret.mappings.forEach(function(mapping) {
      var sliced = mapping.slice(this, start, end);
      if (sliced) {
        newMappings.push(sliced);
      }
    }, this);
  }

  return lines;
};

function sliceInfo(info, startCol, endCol) {
  var sliceStart = info.sliceStart;
  var sliceEnd = info.sliceEnd;
  var indent = Math.max(info.indent, 0);
  var lineLength = indent + sliceEnd - sliceStart;

  if (typeof endCol === "undefined") {
    endCol = lineLength;
  }

  startCol = Math.max(startCol, 0);
  endCol = Math.min(endCol, lineLength);
  endCol = Math.max(endCol, startCol);

  if (endCol < indent) {
    indent = endCol;
    sliceEnd = sliceStart;
  } else {
    sliceEnd -= lineLength - endCol;
  }

  lineLength = endCol;
  lineLength -= startCol;

  if (startCol < indent) {
    indent -= startCol;
  } else {
    startCol -= indent;
    indent = 0;
    sliceStart += startCol;
  }

  assert.ok(indent >= 0);
  assert.ok(sliceStart <= sliceEnd);
  assert.strictEqual(lineLength, indent + sliceEnd - sliceStart);

  if (info.indent === indent &&
      info.sliceStart === sliceStart &&
      info.sliceEnd === sliceEnd) {
    return info;
  }

  return {
    line: info.line,
    indent: indent,
    // A destructive slice always unlocks indentation.
    locked: false,
    sliceStart: sliceStart,
    sliceEnd: sliceEnd
  };
}

Lp.bootstrapSliceString = function(start, end, options) {
  return this.slice(start, end).toString(options);
};

Lp.sliceString = function(start, end, options) {
  if (!end) {
    if (!start) {
      // The client seems to want a copy of this Lines object, but
      // Lines objects are immutable, so it's perfectly adequate to
      // return the same object.
      return this;
    }

    // Slice to the end if no end position was provided.
    end = this.lastPos();
  }

  options = normalizeOptions(options);

  var infos = getSecret(this).infos;
  var parts = [];
  var tabWidth = options.tabWidth;

  for (var line = start.line; line <= end.line; ++line) {
    var info = infos[line - 1];

    if (line === start.line) {
      if (line === end.line) {
        info = sliceInfo(info, start.column, end.column);
      } else {
        info = sliceInfo(info, start.column);
      }
    } else if (line === end.line) {
      info = sliceInfo(info, 0, end.column);
    }

    var indent = Math.max(info.indent, 0);

    var before = info.line.slice(0, info.sliceStart);
    if (options.reuseWhitespace &&
        isOnlyWhitespace(before) &&
        countSpaces(before, options.tabWidth) === indent) {
      // Reuse original spaces if the indentation is correct.
      parts.push(info.line.slice(0, info.sliceEnd));
      continue;
    }

    var tabs = 0;
    var spaces = indent;

    if (options.useTabs) {
      tabs = Math.floor(indent / tabWidth);
      spaces -= tabs * tabWidth;
    }

    var result = "";

    if (tabs > 0) {
      result += new Array(tabs + 1).join("\t");
    }

    if (spaces > 0) {
      result += new Array(spaces + 1).join(" ");
    }

    result += info.line.slice(info.sliceStart, info.sliceEnd);

    parts.push(result);
  }

  return parts.join(options.lineTerminator);
};

Lp.isEmpty = function() {
  return this.length < 2 && this.getLineLength(1) < 1;
};

Lp.join = function(elements) {
  var separator = this;
  var separatorSecret = getSecret(separator);
  var infos = [];
  var mappings = [];
  var prevInfo;

  function appendSecret(secret) {
    if (secret === null)
      return;

    if (prevInfo) {
      var info = secret.infos[0];
      var indent = new Array(info.indent + 1).join(" ");
      var prevLine = infos.length;
      var prevColumn = Math.max(prevInfo.indent, 0) +
        prevInfo.sliceEnd - prevInfo.sliceStart;

      prevInfo.line = prevInfo.line.slice(
        0, prevInfo.sliceEnd) + indent + info.line.slice(
          info.sliceStart, info.sliceEnd);

      // If any part of a line is indentation-locked, the whole line
      // will be indentation-locked.
      prevInfo.locked = prevInfo.locked || info.locked;

      prevInfo.sliceEnd = prevInfo.line.length;

      if (secret.mappings.length > 0) {
        secret.mappings.forEach(function(mapping) {
          mappings.push(mapping.add(prevLine, prevColumn));
        });
      }

    } else if (secret.mappings.length > 0) {
      mappings.push.apply(mappings, secret.mappings);
    }

    secret.infos.forEach(function(info, i) {
      if (!prevInfo || i > 0) {
        prevInfo = copyLineInfo(info);
        infos.push(prevInfo);
      }
    });
  }

  function appendWithSeparator(secret, i) {
    if (i > 0)
      appendSecret(separatorSecret);
    appendSecret(secret);
  }

  elements.map(function(elem) {
    var lines = fromString(elem);
    if (lines.isEmpty())
      return null;
    return getSecret(lines);
  }).forEach(separator.isEmpty()
             ? appendSecret
             : appendWithSeparator);

  if (infos.length < 1)
    return emptyLines;

  var lines = new Lines(infos);

  getSecret(lines).mappings = mappings;

  return lines;
};

exports.concat = function(elements) {
  return emptyLines.join(elements);
};

Lp.concat = function(other) {
  var args = arguments,
  list = [this];
  list.push.apply(list, args);
  assert.strictEqual(list.length, args.length + 1);
  return emptyLines.join(list);
};

// The emptyLines object needs to be created all the way down here so that
// Lines.prototype will be fully populated.
var emptyLines = fromString("");


/***/ }),
/* 96 */
/***/ (function(module, exports) {

/* -*- Mode: js; js-indent-level: 2; -*- */
/*
 * Copyright 2011 Mozilla Foundation and contributors
 * Licensed under the New BSD license. See LICENSE or:
 * http://opensource.org/licenses/BSD-3-Clause
 */

/**
 * This is a helper function for getting values from parameter/options
 * objects.
 *
 * @param args The object we are extracting values from
 * @param name The name of the property we are getting.
 * @param defaultValue An optional value to return if the property is missing
 * from the object. If this is not specified and the property is missing, an
 * error will be thrown.
 */
function getArg(aArgs, aName, aDefaultValue) {
  if (aName in aArgs) {
    return aArgs[aName];
  } else if (arguments.length === 3) {
    return aDefaultValue;
  } else {
    throw new Error('"' + aName + '" is a required argument.');
  }
}
exports.getArg = getArg;

var urlRegexp = /^(?:([\w+\-.]+):)?\/\/(?:(\w+:\w+)@)?([\w.-]*)(?::(\d+))?(.*)$/;
var dataUrlRegexp = /^data:.+\,.+$/;

function urlParse(aUrl) {
  var match = aUrl.match(urlRegexp);
  if (!match) {
    return null;
  }
  return {
    scheme: match[1],
    auth: match[2],
    host: match[3],
    port: match[4],
    path: match[5]
  };
}
exports.urlParse = urlParse;

function urlGenerate(aParsedUrl) {
  var url = '';
  if (aParsedUrl.scheme) {
    url += aParsedUrl.scheme + ':';
  }
  url += '//';
  if (aParsedUrl.auth) {
    url += aParsedUrl.auth + '@';
  }
  if (aParsedUrl.host) {
    url += aParsedUrl.host;
  }
  if (aParsedUrl.port) {
    url += ":" + aParsedUrl.port
  }
  if (aParsedUrl.path) {
    url += aParsedUrl.path;
  }
  return url;
}
exports.urlGenerate = urlGenerate;

/**
 * Normalizes a path, or the path portion of a URL:
 *
 * - Replaces consecutive slashes with one slash.
 * - Removes unnecessary '.' parts.
 * - Removes unnecessary '<dir>/..' parts.
 *
 * Based on code in the Node.js 'path' core module.
 *
 * @param aPath The path or url to normalize.
 */
function normalize(aPath) {
  var path = aPath;
  var url = urlParse(aPath);
  if (url) {
    if (!url.path) {
      return aPath;
    }
    path = url.path;
  }
  var isAbsolute = exports.isAbsolute(path);

  var parts = path.split(/\/+/);
  for (var part, up = 0, i = parts.length - 1; i >= 0; i--) {
    part = parts[i];
    if (part === '.') {
      parts.splice(i, 1);
    } else if (part === '..') {
      up++;
    } else if (up > 0) {
      if (part === '') {
        // The first part is blank if the path is absolute. Trying to go
        // above the root is a no-op. Therefore we can remove all '..' parts
        // directly after the root.
        parts.splice(i + 1, up);
        up = 0;
      } else {
        parts.splice(i, 2);
        up--;
      }
    }
  }
  path = parts.join('/');

  if (path === '') {
    path = isAbsolute ? '/' : '.';
  }

  if (url) {
    url.path = path;
    return urlGenerate(url);
  }
  return path;
}
exports.normalize = normalize;

/**
 * Joins two paths/URLs.
 *
 * @param aRoot The root path or URL.
 * @param aPath The path or URL to be joined with the root.
 *
 * - If aPath is a URL or a data URI, aPath is returned, unless aPath is a
 *   scheme-relative URL: Then the scheme of aRoot, if any, is prepended
 *   first.
 * - Otherwise aPath is a path. If aRoot is a URL, then its path portion
 *   is updated with the result and aRoot is returned. Otherwise the result
 *   is returned.
 *   - If aPath is absolute, the result is aPath.
 *   - Otherwise the two paths are joined with a slash.
 * - Joining for example 'http://' and 'www.example.com' is also supported.
 */
function join(aRoot, aPath) {
  if (aRoot === "") {
    aRoot = ".";
  }
  if (aPath === "") {
    aPath = ".";
  }
  var aPathUrl = urlParse(aPath);
  var aRootUrl = urlParse(aRoot);
  if (aRootUrl) {
    aRoot = aRootUrl.path || '/';
  }

  // `join(foo, '//www.example.org')`
  if (aPathUrl && !aPathUrl.scheme) {
    if (aRootUrl) {
      aPathUrl.scheme = aRootUrl.scheme;
    }
    return urlGenerate(aPathUrl);
  }

  if (aPathUrl || aPath.match(dataUrlRegexp)) {
    return aPath;
  }

  // `join('http://', 'www.example.com')`
  if (aRootUrl && !aRootUrl.host && !aRootUrl.path) {
    aRootUrl.host = aPath;
    return urlGenerate(aRootUrl);
  }

  var joined = aPath.charAt(0) === '/'
    ? aPath
    : normalize(aRoot.replace(/\/+$/, '') + '/' + aPath);

  if (aRootUrl) {
    aRootUrl.path = joined;
    return urlGenerate(aRootUrl);
  }
  return joined;
}
exports.join = join;

exports.isAbsolute = function (aPath) {
  return aPath.charAt(0) === '/' || urlRegexp.test(aPath);
};

/**
 * Make a path relative to a URL or another path.
 *
 * @param aRoot The root path or URL.
 * @param aPath The path or URL to be made relative to aRoot.
 */
function relative(aRoot, aPath) {
  if (aRoot === "") {
    aRoot = ".";
  }

  aRoot = aRoot.replace(/\/$/, '');

  // It is possible for the path to be above the root. In this case, simply
  // checking whether the root is a prefix of the path won't work. Instead, we
  // need to remove components from the root one by one, until either we find
  // a prefix that fits, or we run out of components to remove.
  var level = 0;
  while (aPath.indexOf(aRoot + '/') !== 0) {
    var index = aRoot.lastIndexOf("/");
    if (index < 0) {
      return aPath;
    }

    // If the only part of the root that is left is the scheme (i.e. http://,
    // file:///, etc.), one or more slashes (/), or simply nothing at all, we
    // have exhausted all components, so the path is not relative to the root.
    aRoot = aRoot.slice(0, index);
    if (aRoot.match(/^([^\/]+:\/)?\/*$/)) {
      return aPath;
    }

    ++level;
  }

  // Make sure we add a "../" for each component we removed from the root.
  return Array(level + 1).join("../") + aPath.substr(aRoot.length + 1);
}
exports.relative = relative;

var supportsNullProto = (function () {
  var obj = Object.create(null);
  return !('__proto__' in obj);
}());

function identity (s) {
  return s;
}

/**
 * Because behavior goes wacky when you set `__proto__` on objects, we
 * have to prefix all the strings in our set with an arbitrary character.
 *
 * See https://github.com/mozilla/source-map/pull/31 and
 * https://github.com/mozilla/source-map/issues/30
 *
 * @param String aStr
 */
function toSetString(aStr) {
  if (isProtoString(aStr)) {
    return '$' + aStr;
  }

  return aStr;
}
exports.toSetString = supportsNullProto ? identity : toSetString;

function fromSetString(aStr) {
  if (isProtoString(aStr)) {
    return aStr.slice(1);
  }

  return aStr;
}
exports.fromSetString = supportsNullProto ? identity : fromSetString;

function isProtoString(s) {
  if (!s) {
    return false;
  }

  var length = s.length;

  if (length < 9 /* "__proto__".length */) {
    return false;
  }

  if (s.charCodeAt(length - 1) !== 95  /* '_' */ ||
      s.charCodeAt(length - 2) !== 95  /* '_' */ ||
      s.charCodeAt(length - 3) !== 111 /* 'o' */ ||
      s.charCodeAt(length - 4) !== 116 /* 't' */ ||
      s.charCodeAt(length - 5) !== 111 /* 'o' */ ||
      s.charCodeAt(length - 6) !== 114 /* 'r' */ ||
      s.charCodeAt(length - 7) !== 112 /* 'p' */ ||
      s.charCodeAt(length - 8) !== 95  /* '_' */ ||
      s.charCodeAt(length - 9) !== 95  /* '_' */) {
    return false;
  }

  for (var i = length - 10; i >= 0; i--) {
    if (s.charCodeAt(i) !== 36 /* '$' */) {
      return false;
    }
  }

  return true;
}

/**
 * Comparator between two mappings where the original positions are compared.
 *
 * Optionally pass in `true` as `onlyCompareGenerated` to consider two
 * mappings with the same original source/line/column, but different generated
 * line and column the same. Useful when searching for a mapping with a
 * stubbed out mapping.
 */
function compareByOriginalPositions(mappingA, mappingB, onlyCompareOriginal) {
  var cmp = strcmp(mappingA.source, mappingB.source);
  if (cmp !== 0) {
    return cmp;
  }

  cmp = mappingA.originalLine - mappingB.originalLine;
  if (cmp !== 0) {
    return cmp;
  }

  cmp = mappingA.originalColumn - mappingB.originalColumn;
  if (cmp !== 0 || onlyCompareOriginal) {
    return cmp;
  }

  cmp = mappingA.generatedColumn - mappingB.generatedColumn;
  if (cmp !== 0) {
    return cmp;
  }

  cmp = mappingA.generatedLine - mappingB.generatedLine;
  if (cmp !== 0) {
    return cmp;
  }

  return strcmp(mappingA.name, mappingB.name);
}
exports.compareByOriginalPositions = compareByOriginalPositions;

/**
 * Comparator between two mappings with deflated source and name indices where
 * the generated positions are compared.
 *
 * Optionally pass in `true` as `onlyCompareGenerated` to consider two
 * mappings with the same generated line and column, but different
 * source/name/original line and column the same. Useful when searching for a
 * mapping with a stubbed out mapping.
 */
function compareByGeneratedPositionsDeflated(mappingA, mappingB, onlyCompareGenerated) {
  var cmp = mappingA.generatedLine - mappingB.generatedLine;
  if (cmp !== 0) {
    return cmp;
  }

  cmp = mappingA.generatedColumn - mappingB.generatedColumn;
  if (cmp !== 0 || onlyCompareGenerated) {
    return cmp;
  }

  cmp = strcmp(mappingA.source, mappingB.source);
  if (cmp !== 0) {
    return cmp;
  }

  cmp = mappingA.originalLine - mappingB.originalLine;
  if (cmp !== 0) {
    return cmp;
  }

  cmp = mappingA.originalColumn - mappingB.originalColumn;
  if (cmp !== 0) {
    return cmp;
  }

  return strcmp(mappingA.name, mappingB.name);
}
exports.compareByGeneratedPositionsDeflated = compareByGeneratedPositionsDeflated;

function strcmp(aStr1, aStr2) {
  if (aStr1 === aStr2) {
    return 0;
  }

  if (aStr1 === null) {
    return 1; // aStr2 !== null
  }

  if (aStr2 === null) {
    return -1; // aStr1 !== null
  }

  if (aStr1 > aStr2) {
    return 1;
  }

  return -1;
}

/**
 * Comparator between two mappings with inflated source and name strings where
 * the generated positions are compared.
 */
function compareByGeneratedPositionsInflated(mappingA, mappingB) {
  var cmp = mappingA.generatedLine - mappingB.generatedLine;
  if (cmp !== 0) {
    return cmp;
  }

  cmp = mappingA.generatedColumn - mappingB.generatedColumn;
  if (cmp !== 0) {
    return cmp;
  }

  cmp = strcmp(mappingA.source, mappingB.source);
  if (cmp !== 0) {
    return cmp;
  }

  cmp = mappingA.originalLine - mappingB.originalLine;
  if (cmp !== 0) {
    return cmp;
  }

  cmp = mappingA.originalColumn - mappingB.originalColumn;
  if (cmp !== 0) {
    return cmp;
  }

  return strcmp(mappingA.name, mappingB.name);
}
exports.compareByGeneratedPositionsInflated = compareByGeneratedPositionsInflated;

/**
 * Strip any JSON XSSI avoidance prefix from the string (as documented
 * in the source maps specification), and then parse the string as
 * JSON.
 */
function parseSourceMapInput(str) {
  return JSON.parse(str.replace(/^\)]}'[^\n]*\n/, ''));
}
exports.parseSourceMapInput = parseSourceMapInput;

/**
 * Compute the URL of a source given the the source root, the source's
 * URL, and the source map's URL.
 */
function computeSourceURL(sourceRoot, sourceURL, sourceMapURL) {
  sourceURL = sourceURL || '';

  if (sourceRoot) {
    // This follows what Chrome does.
    if (sourceRoot[sourceRoot.length - 1] !== '/' && sourceURL[0] !== '/') {
      sourceRoot += '/';
    }
    // The spec says:
    //   Line 4: An optional source root, useful for relocating source
    //   files on a server or removing repeated values in the
    //   “sources” entry.  This value is prepended to the individual
    //   entries in the “source” field.
    sourceURL = sourceRoot + sourceURL;
  }

  // Historically, SourceMapConsumer did not take the sourceMapURL as
  // a parameter.  This mode is still somewhat supported, which is why
  // this code block is conditional.  However, it's preferable to pass
  // the source map URL to SourceMapConsumer, so that this function
  // can implement the source URL resolution algorithm as outlined in
  // the spec.  This block is basically the equivalent of:
  //    new URL(sourceURL, sourceMapURL).toString()
  // ... except it avoids using URL, which wasn't available in the
  // older releases of node still supported by this library.
  //
  // The spec says:
  //   If the sources are not absolute URLs after prepending of the
  //   “sourceRoot”, the sources are resolved relative to the
  //   SourceMap (like resolving script src in a html document).
  if (sourceMapURL) {
    var parsed = urlParse(sourceMapURL);
    if (!parsed) {
      throw new Error("sourceMapURL could not be parsed");
    }
    if (parsed.path) {
      // Strip the last path component, but keep the "/".
      var index = parsed.path.lastIndexOf('/');
      if (index >= 0) {
        parsed.path = parsed.path.substring(0, index + 1);
      }
    }
    sourceURL = join(urlGenerate(parsed), sourceURL);
  }

  return normalize(sourceURL);
}
exports.computeSourceURL = computeSourceURL;


/***/ }),
/* 97 */
/***/ (function(module, exports) {

var core = module.exports = { version: '2.5.7' };
if (typeof __e == 'number') __e = core; // eslint-disable-line no-undef


/***/ }),
/* 98 */
/***/ (function(module, exports) {

module.exports = {};


/***/ }),
/* 99 */
/***/ (function(module, exports, __webpack_require__) {

/*
  Copyright (C) 2012-2013 Yusuke Suzuki <utatane.tea@gmail.com>
  Copyright (C) 2012 Ariya Hidayat <ariya.hidayat@gmail.com>

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
/*jslint vars:false, bitwise:true*/
/*jshint indent:4*/
/*global exports:true*/
(function clone(exports) {
    'use strict';

    var Syntax,
        isArray,
        VisitorOption,
        VisitorKeys,
        objectCreate,
        objectKeys,
        BREAK,
        SKIP,
        REMOVE;

    function ignoreJSHintError() { }

    isArray = Array.isArray;
    if (!isArray) {
        isArray = function isArray(array) {
            return Object.prototype.toString.call(array) === '[object Array]';
        };
    }

    function deepCopy(obj) {
        var ret = {}, key, val;
        for (key in obj) {
            if (obj.hasOwnProperty(key)) {
                val = obj[key];
                if (typeof val === 'object' && val !== null) {
                    ret[key] = deepCopy(val);
                } else {
                    ret[key] = val;
                }
            }
        }
        return ret;
    }

    function shallowCopy(obj) {
        var ret = {}, key;
        for (key in obj) {
            if (obj.hasOwnProperty(key)) {
                ret[key] = obj[key];
            }
        }
        return ret;
    }
    ignoreJSHintError(shallowCopy);

    // based on LLVM libc++ upper_bound / lower_bound
    // MIT License

    function upperBound(array, func) {
        var diff, len, i, current;

        len = array.length;
        i = 0;

        while (len) {
            diff = len >>> 1;
            current = i + diff;
            if (func(array[current])) {
                len = diff;
            } else {
                i = current + 1;
                len -= diff + 1;
            }
        }
        return i;
    }

    function lowerBound(array, func) {
        var diff, len, i, current;

        len = array.length;
        i = 0;

        while (len) {
            diff = len >>> 1;
            current = i + diff;
            if (func(array[current])) {
                i = current + 1;
                len -= diff + 1;
            } else {
                len = diff;
            }
        }
        return i;
    }
    ignoreJSHintError(lowerBound);

    objectCreate = Object.create || (function () {
        function F() { }

        return function (o) {
            F.prototype = o;
            return new F();
        };
    })();

    objectKeys = Object.keys || function (o) {
        var keys = [], key;
        for (key in o) {
            keys.push(key);
        }
        return keys;
    };

    function extend(to, from) {
        var keys = objectKeys(from), key, i, len;
        for (i = 0, len = keys.length; i < len; i += 1) {
            key = keys[i];
            to[key] = from[key];
        }
        return to;
    }

    Syntax = {
        AssignmentExpression: 'AssignmentExpression',
        AssignmentPattern: 'AssignmentPattern',
        ArrayExpression: 'ArrayExpression',
        ArrayPattern: 'ArrayPattern',
        ArrowFunctionExpression: 'ArrowFunctionExpression',
        AwaitExpression: 'AwaitExpression', // CAUTION: It's deferred to ES7.
        BlockStatement: 'BlockStatement',
        BinaryExpression: 'BinaryExpression',
        BreakStatement: 'BreakStatement',
        CallExpression: 'CallExpression',
        CatchClause: 'CatchClause',
        ClassBody: 'ClassBody',
        ClassDeclaration: 'ClassDeclaration',
        ClassExpression: 'ClassExpression',
        ComprehensionBlock: 'ComprehensionBlock',  // CAUTION: It's deferred to ES7.
        ComprehensionExpression: 'ComprehensionExpression',  // CAUTION: It's deferred to ES7.
        ConditionalExpression: 'ConditionalExpression',
        ContinueStatement: 'ContinueStatement',
        DebuggerStatement: 'DebuggerStatement',
        DirectiveStatement: 'DirectiveStatement',
        DoWhileStatement: 'DoWhileStatement',
        EmptyStatement: 'EmptyStatement',
        ExportAllDeclaration: 'ExportAllDeclaration',
        ExportDefaultDeclaration: 'ExportDefaultDeclaration',
        ExportNamedDeclaration: 'ExportNamedDeclaration',
        ExportSpecifier: 'ExportSpecifier',
        ExpressionStatement: 'ExpressionStatement',
        ForStatement: 'ForStatement',
        ForInStatement: 'ForInStatement',
        ForOfStatement: 'ForOfStatement',
        FunctionDeclaration: 'FunctionDeclaration',
        FunctionExpression: 'FunctionExpression',
        GeneratorExpression: 'GeneratorExpression',  // CAUTION: It's deferred to ES7.
        Identifier: 'Identifier',
        IfStatement: 'IfStatement',
        ImportDeclaration: 'ImportDeclaration',
        ImportDefaultSpecifier: 'ImportDefaultSpecifier',
        ImportNamespaceSpecifier: 'ImportNamespaceSpecifier',
        ImportSpecifier: 'ImportSpecifier',
        Literal: 'Literal',
        LabeledStatement: 'LabeledStatement',
        LogicalExpression: 'LogicalExpression',
        MemberExpression: 'MemberExpression',
        MetaProperty: 'MetaProperty',
        MethodDefinition: 'MethodDefinition',
        ModuleSpecifier: 'ModuleSpecifier',
        NewExpression: 'NewExpression',
        ObjectExpression: 'ObjectExpression',
        ObjectPattern: 'ObjectPattern',
        Program: 'Program',
        Property: 'Property',
        RestElement: 'RestElement',
        ReturnStatement: 'ReturnStatement',
        SequenceExpression: 'SequenceExpression',
        SpreadElement: 'SpreadElement',
        Super: 'Super',
        SwitchStatement: 'SwitchStatement',
        SwitchCase: 'SwitchCase',
        TaggedTemplateExpression: 'TaggedTemplateExpression',
        TemplateElement: 'TemplateElement',
        TemplateLiteral: 'TemplateLiteral',
        ThisExpression: 'ThisExpression',
        ThrowStatement: 'ThrowStatement',
        TryStatement: 'TryStatement',
        UnaryExpression: 'UnaryExpression',
        UpdateExpression: 'UpdateExpression',
        VariableDeclaration: 'VariableDeclaration',
        VariableDeclarator: 'VariableDeclarator',
        WhileStatement: 'WhileStatement',
        WithStatement: 'WithStatement',
        YieldExpression: 'YieldExpression'
    };

    VisitorKeys = {
        AssignmentExpression: ['left', 'right'],
        AssignmentPattern: ['left', 'right'],
        ArrayExpression: ['elements'],
        ArrayPattern: ['elements'],
        ArrowFunctionExpression: ['params', 'body'],
        AwaitExpression: ['argument'], // CAUTION: It's deferred to ES7.
        BlockStatement: ['body'],
        BinaryExpression: ['left', 'right'],
        BreakStatement: ['label'],
        CallExpression: ['callee', 'arguments'],
        CatchClause: ['param', 'body'],
        ClassBody: ['body'],
        ClassDeclaration: ['id', 'superClass', 'body'],
        ClassExpression: ['id', 'superClass', 'body'],
        ComprehensionBlock: ['left', 'right'],  // CAUTION: It's deferred to ES7.
        ComprehensionExpression: ['blocks', 'filter', 'body'],  // CAUTION: It's deferred to ES7.
        ConditionalExpression: ['test', 'consequent', 'alternate'],
        ContinueStatement: ['label'],
        DebuggerStatement: [],
        DirectiveStatement: [],
        DoWhileStatement: ['body', 'test'],
        EmptyStatement: [],
        ExportAllDeclaration: ['source'],
        ExportDefaultDeclaration: ['declaration'],
        ExportNamedDeclaration: ['declaration', 'specifiers', 'source'],
        ExportSpecifier: ['exported', 'local'],
        ExpressionStatement: ['expression'],
        ForStatement: ['init', 'test', 'update', 'body'],
        ForInStatement: ['left', 'right', 'body'],
        ForOfStatement: ['left', 'right', 'body'],
        FunctionDeclaration: ['id', 'params', 'body'],
        FunctionExpression: ['id', 'params', 'body'],
        GeneratorExpression: ['blocks', 'filter', 'body'],  // CAUTION: It's deferred to ES7.
        Identifier: [],
        IfStatement: ['test', 'consequent', 'alternate'],
        ImportDeclaration: ['specifiers', 'source'],
        ImportDefaultSpecifier: ['local'],
        ImportNamespaceSpecifier: ['local'],
        ImportSpecifier: ['imported', 'local'],
        Literal: [],
        LabeledStatement: ['label', 'body'],
        LogicalExpression: ['left', 'right'],
        MemberExpression: ['object', 'property'],
        MetaProperty: ['meta', 'property'],
        MethodDefinition: ['key', 'value'],
        ModuleSpecifier: [],
        NewExpression: ['callee', 'arguments'],
        ObjectExpression: ['properties'],
        ObjectPattern: ['properties'],
        Program: ['body'],
        Property: ['key', 'value'],
        RestElement: [ 'argument' ],
        ReturnStatement: ['argument'],
        SequenceExpression: ['expressions'],
        SpreadElement: ['argument'],
        Super: [],
        SwitchStatement: ['discriminant', 'cases'],
        SwitchCase: ['test', 'consequent'],
        TaggedTemplateExpression: ['tag', 'quasi'],
        TemplateElement: [],
        TemplateLiteral: ['quasis', 'expressions'],
        ThisExpression: [],
        ThrowStatement: ['argument'],
        TryStatement: ['block', 'handler', 'finalizer'],
        UnaryExpression: ['argument'],
        UpdateExpression: ['argument'],
        VariableDeclaration: ['declarations'],
        VariableDeclarator: ['id', 'init'],
        WhileStatement: ['test', 'body'],
        WithStatement: ['object', 'body'],
        YieldExpression: ['argument']
    };

    // unique id
    BREAK = {};
    SKIP = {};
    REMOVE = {};

    VisitorOption = {
        Break: BREAK,
        Skip: SKIP,
        Remove: REMOVE
    };

    function Reference(parent, key) {
        this.parent = parent;
        this.key = key;
    }

    Reference.prototype.replace = function replace(node) {
        this.parent[this.key] = node;
    };

    Reference.prototype.remove = function remove() {
        if (isArray(this.parent)) {
            this.parent.splice(this.key, 1);
            return true;
        } else {
            this.replace(null);
            return false;
        }
    };

    function Element(node, path, wrap, ref) {
        this.node = node;
        this.path = path;
        this.wrap = wrap;
        this.ref = ref;
    }

    function Controller() { }

    // API:
    // return property path array from root to current node
    Controller.prototype.path = function path() {
        var i, iz, j, jz, result, element;

        function addToPath(result, path) {
            if (isArray(path)) {
                for (j = 0, jz = path.length; j < jz; ++j) {
                    result.push(path[j]);
                }
            } else {
                result.push(path);
            }
        }

        // root node
        if (!this.__current.path) {
            return null;
        }

        // first node is sentinel, second node is root element
        result = [];
        for (i = 2, iz = this.__leavelist.length; i < iz; ++i) {
            element = this.__leavelist[i];
            addToPath(result, element.path);
        }
        addToPath(result, this.__current.path);
        return result;
    };

    // API:
    // return type of current node
    Controller.prototype.type = function () {
        var node = this.current();
        return node.type || this.__current.wrap;
    };

    // API:
    // return array of parent elements
    Controller.prototype.parents = function parents() {
        var i, iz, result;

        // first node is sentinel
        result = [];
        for (i = 1, iz = this.__leavelist.length; i < iz; ++i) {
            result.push(this.__leavelist[i].node);
        }

        return result;
    };

    // API:
    // return current node
    Controller.prototype.current = function current() {
        return this.__current.node;
    };

    Controller.prototype.__execute = function __execute(callback, element) {
        var previous, result;

        result = undefined;

        previous  = this.__current;
        this.__current = element;
        this.__state = null;
        if (callback) {
            result = callback.call(this, element.node, this.__leavelist[this.__leavelist.length - 1].node);
        }
        this.__current = previous;

        return result;
    };

    // API:
    // notify control skip / break
    Controller.prototype.notify = function notify(flag) {
        this.__state = flag;
    };

    // API:
    // skip child nodes of current node
    Controller.prototype.skip = function () {
        this.notify(SKIP);
    };

    // API:
    // break traversals
    Controller.prototype['break'] = function () {
        this.notify(BREAK);
    };

    // API:
    // remove node
    Controller.prototype.remove = function () {
        this.notify(REMOVE);
    };

    Controller.prototype.__initialize = function(root, visitor) {
        this.visitor = visitor;
        this.root = root;
        this.__worklist = [];
        this.__leavelist = [];
        this.__current = null;
        this.__state = null;
        this.__fallback = null;
        if (visitor.fallback === 'iteration') {
            this.__fallback = objectKeys;
        } else if (typeof visitor.fallback === 'function') {
            this.__fallback = visitor.fallback;
        }

        this.__keys = VisitorKeys;
        if (visitor.keys) {
            this.__keys = extend(objectCreate(this.__keys), visitor.keys);
        }
    };

    function isNode(node) {
        if (node == null) {
            return false;
        }
        return typeof node === 'object' && typeof node.type === 'string';
    }

    function isProperty(nodeType, key) {
        return (nodeType === Syntax.ObjectExpression || nodeType === Syntax.ObjectPattern) && 'properties' === key;
    }

    Controller.prototype.traverse = function traverse(root, visitor) {
        var worklist,
            leavelist,
            element,
            node,
            nodeType,
            ret,
            key,
            current,
            current2,
            candidates,
            candidate,
            sentinel;

        this.__initialize(root, visitor);

        sentinel = {};

        // reference
        worklist = this.__worklist;
        leavelist = this.__leavelist;

        // initialize
        worklist.push(new Element(root, null, null, null));
        leavelist.push(new Element(null, null, null, null));

        while (worklist.length) {
            element = worklist.pop();

            if (element === sentinel) {
                element = leavelist.pop();

                ret = this.__execute(visitor.leave, element);

                if (this.__state === BREAK || ret === BREAK) {
                    return;
                }
                continue;
            }

            if (element.node) {

                ret = this.__execute(visitor.enter, element);

                if (this.__state === BREAK || ret === BREAK) {
                    return;
                }

                worklist.push(sentinel);
                leavelist.push(element);

                if (this.__state === SKIP || ret === SKIP) {
                    continue;
                }

                node = element.node;
                nodeType = node.type || element.wrap;
                candidates = this.__keys[nodeType];
                if (!candidates) {
                    if (this.__fallback) {
                        candidates = this.__fallback(node);
                    } else {
                        throw new Error('Unknown node type ' + nodeType + '.');
                    }
                }

                current = candidates.length;
                while ((current -= 1) >= 0) {
                    key = candidates[current];
                    candidate = node[key];
                    if (!candidate) {
                        continue;
                    }

                    if (isArray(candidate)) {
                        current2 = candidate.length;
                        while ((current2 -= 1) >= 0) {
                            if (!candidate[current2]) {
                                continue;
                            }
                            if (isProperty(nodeType, candidates[current])) {
                                element = new Element(candidate[current2], [key, current2], 'Property', null);
                            } else if (isNode(candidate[current2])) {
                                element = new Element(candidate[current2], [key, current2], null, null);
                            } else {
                                continue;
                            }
                            worklist.push(element);
                        }
                    } else if (isNode(candidate)) {
                        worklist.push(new Element(candidate, key, null, null));
                    }
                }
            }
        }
    };

    Controller.prototype.replace = function replace(root, visitor) {
        var worklist,
            leavelist,
            node,
            nodeType,
            target,
            element,
            current,
            current2,
            candidates,
            candidate,
            sentinel,
            outer,
            key;

        function removeElem(element) {
            var i,
                key,
                nextElem,
                parent;

            if (element.ref.remove()) {
                // When the reference is an element of an array.
                key = element.ref.key;
                parent = element.ref.parent;

                // If removed from array, then decrease following items' keys.
                i = worklist.length;
                while (i--) {
                    nextElem = worklist[i];
                    if (nextElem.ref && nextElem.ref.parent === parent) {
                        if  (nextElem.ref.key < key) {
                            break;
                        }
                        --nextElem.ref.key;
                    }
                }
            }
        }

        this.__initialize(root, visitor);

        sentinel = {};

        // reference
        worklist = this.__worklist;
        leavelist = this.__leavelist;

        // initialize
        outer = {
            root: root
        };
        element = new Element(root, null, null, new Reference(outer, 'root'));
        worklist.push(element);
        leavelist.push(element);

        while (worklist.length) {
            element = worklist.pop();

            if (element === sentinel) {
                element = leavelist.pop();

                target = this.__execute(visitor.leave, element);

                // node may be replaced with null,
                // so distinguish between undefined and null in this place
                if (target !== undefined && target !== BREAK && target !== SKIP && target !== REMOVE) {
                    // replace
                    element.ref.replace(target);
                }

                if (this.__state === REMOVE || target === REMOVE) {
                    removeElem(element);
                }

                if (this.__state === BREAK || target === BREAK) {
                    return outer.root;
                }
                continue;
            }

            target = this.__execute(visitor.enter, element);

            // node may be replaced with null,
            // so distinguish between undefined and null in this place
            if (target !== undefined && target !== BREAK && target !== SKIP && target !== REMOVE) {
                // replace
                element.ref.replace(target);
                element.node = target;
            }

            if (this.__state === REMOVE || target === REMOVE) {
                removeElem(element);
                element.node = null;
            }

            if (this.__state === BREAK || target === BREAK) {
                return outer.root;
            }

            // node may be null
            node = element.node;
            if (!node) {
                continue;
            }

            worklist.push(sentinel);
            leavelist.push(element);

            if (this.__state === SKIP || target === SKIP) {
                continue;
            }

            nodeType = node.type || element.wrap;
            candidates = this.__keys[nodeType];
            if (!candidates) {
                if (this.__fallback) {
                    candidates = this.__fallback(node);
                } else {
                    throw new Error('Unknown node type ' + nodeType + '.');
                }
            }

            current = candidates.length;
            while ((current -= 1) >= 0) {
                key = candidates[current];
                candidate = node[key];
                if (!candidate) {
                    continue;
                }

                if (isArray(candidate)) {
                    current2 = candidate.length;
                    while ((current2 -= 1) >= 0) {
                        if (!candidate[current2]) {
                            continue;
                        }
                        if (isProperty(nodeType, candidates[current])) {
                            element = new Element(candidate[current2], [key, current2], 'Property', new Reference(candidate, current2));
                        } else if (isNode(candidate[current2])) {
                            element = new Element(candidate[current2], [key, current2], null, new Reference(candidate, current2));
                        } else {
                            continue;
                        }
                        worklist.push(element);
                    }
                } else if (isNode(candidate)) {
                    worklist.push(new Element(candidate, key, null, new Reference(node, key)));
                }
            }
        }

        return outer.root;
    };

    function traverse(root, visitor) {
        var controller = new Controller();
        return controller.traverse(root, visitor);
    }

    function replace(root, visitor) {
        var controller = new Controller();
        return controller.replace(root, visitor);
    }

    function extendCommentRange(comment, tokens) {
        var target;

        target = upperBound(tokens, function search(token) {
            return token.range[0] > comment.range[0];
        });

        comment.extendedRange = [comment.range[0], comment.range[1]];

        if (target !== tokens.length) {
            comment.extendedRange[1] = tokens[target].range[0];
        }

        target -= 1;
        if (target >= 0) {
            comment.extendedRange[0] = tokens[target].range[1];
        }

        return comment;
    }

    function attachComments(tree, providedComments, tokens) {
        // At first, we should calculate extended comment ranges.
        var comments = [], comment, len, i, cursor;

        if (!tree.range) {
            throw new Error('attachComments needs range information');
        }

        // tokens array is empty, we attach comments to tree as 'leadingComments'
        if (!tokens.length) {
            if (providedComments.length) {
                for (i = 0, len = providedComments.length; i < len; i += 1) {
                    comment = deepCopy(providedComments[i]);
                    comment.extendedRange = [0, tree.range[0]];
                    comments.push(comment);
                }
                tree.leadingComments = comments;
            }
            return tree;
        }

        for (i = 0, len = providedComments.length; i < len; i += 1) {
            comments.push(extendCommentRange(deepCopy(providedComments[i]), tokens));
        }

        // This is based on John Freeman's implementation.
        cursor = 0;
        traverse(tree, {
            enter: function (node) {
                var comment;

                while (cursor < comments.length) {
                    comment = comments[cursor];
                    if (comment.extendedRange[1] > node.range[0]) {
                        break;
                    }

                    if (comment.extendedRange[1] === node.range[0]) {
                        if (!node.leadingComments) {
                            node.leadingComments = [];
                        }
                        node.leadingComments.push(comment);
                        comments.splice(cursor, 1);
                    } else {
                        cursor += 1;
                    }
                }

                // already out of owned node
                if (cursor === comments.length) {
                    return VisitorOption.Break;
                }

                if (comments[cursor].extendedRange[0] > node.range[1]) {
                    return VisitorOption.Skip;
                }
            }
        });

        cursor = 0;
        traverse(tree, {
            leave: function (node) {
                var comment;

                while (cursor < comments.length) {
                    comment = comments[cursor];
                    if (node.range[1] < comment.extendedRange[0]) {
                        break;
                    }

                    if (node.range[1] === comment.extendedRange[0]) {
                        if (!node.trailingComments) {
                            node.trailingComments = [];
                        }
                        node.trailingComments.push(comment);
                        comments.splice(cursor, 1);
                    } else {
                        cursor += 1;
                    }
                }

                // already out of owned node
                if (cursor === comments.length) {
                    return VisitorOption.Break;
                }

                if (comments[cursor].extendedRange[0] > node.range[1]) {
                    return VisitorOption.Skip;
                }
            }
        });

        return tree;
    }

    exports.version = __webpack_require__(541).version;
    exports.Syntax = Syntax;
    exports.traverse = traverse;
    exports.replace = replace;
    exports.attachComments = attachComments;
    exports.VisitorKeys = VisitorKeys;
    exports.VisitorOption = VisitorOption;
    exports.Controller = Controller;
    exports.cloneEnvironment = function () { return clone({}); };

    return exports;
}(exports));
/* vim: set sw=4 ts=4 et tw=80 : */


/***/ }),
/* 100 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = copyComments;
/**
 * Appends comments of one node to comments of another.
 *
 * - Modifies `to` node with added comments.
 * - Does nothing when there are no comments to copy
 *   (ensuring we don't modify the `to` node when not needed).
 *
 * @param  {Object} from Node to copy comments from
 * @param  {Object} to Node to copy comments to
 */
function copyComments(_ref) {
  var from = _ref.from,
      to = _ref.to;

  if (from.comments && from.comments.length > 0) {
    to.comments = (to.comments || []).concat(from.comments || []);
  }
}
module.exports = exports["default"];

/***/ }),
/* 101 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = isEqualAst;

var _fp = __webpack_require__(14);

var metaDataFields = {
  comments: true,
  loc: true,
  start: true,
  end: true
};

/**
 * True when two AST nodes are structurally equal.
 * When comparing objects it ignores the meta-data fields for
 * comments and source-code position.
 * @param  {Object}  a
 * @param  {Object}  b
 * @return {Boolean}
 */
function isEqualAst(a, b) {
  return (0, _fp.isEqualWith)(function (aValue, bValue, key) {
    return metaDataFields[key];
  }, a, b);
}
module.exports = exports['default'];

/***/ }),
/* 102 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


module.exports = __webpack_require__(281)()
	? Object.setPrototypeOf
	: __webpack_require__(282);


/***/ }),
/* 103 */
/***/ (function(module, exports) {

module.exports = {};


/***/ }),
/* 104 */
/***/ (function(module, exports, __webpack_require__) {

// 19.1.2.14 / 15.2.3.14 Object.keys(O)
var $keys = __webpack_require__(307);
var enumBugKeys = __webpack_require__(190);

module.exports = Object.keys || function keys(O) {
  return $keys(O, enumBugKeys);
};


/***/ }),
/* 105 */
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(666);
var global = __webpack_require__(40);
var hide = __webpack_require__(61);
var Iterators = __webpack_require__(103);
var TO_STRING_TAG = __webpack_require__(33)('toStringTag');

var DOMIterables = ('CSSRuleList,CSSStyleDeclaration,CSSValueList,ClientRectList,DOMRectList,DOMStringList,' +
  'DOMTokenList,DataTransferItemList,FileList,HTMLAllCollection,HTMLCollection,HTMLFormElement,HTMLSelectElement,' +
  'MediaList,MimeTypeArray,NamedNodeMap,NodeList,PaintRequestList,Plugin,PluginArray,SVGLengthList,SVGNumberList,' +
  'SVGPathSegList,SVGPointList,SVGStringList,SVGTransformList,SourceBufferList,StyleSheetList,TextTrackCueList,' +
  'TextTrackList,TouchList').split(',');

for (var i = 0; i < DOMIterables.length; i++) {
  var NAME = DOMIterables[i];
  var Collection = global[NAME];
  var proto = Collection && Collection.prototype;
  if (proto && !proto[TO_STRING_TAG]) hide(proto, TO_STRING_TAG, NAME);
  Iterators[NAME] = Iterators.Array;
}


/***/ }),
/* 106 */
/***/ (function(module, exports, __webpack_require__) {

var META = __webpack_require__(140)('meta');
var isObject = __webpack_require__(32);
var has = __webpack_require__(63);
var setDesc = __webpack_require__(52).f;
var id = 0;
var isExtensible = Object.isExtensible || function () {
  return true;
};
var FREEZE = !__webpack_require__(62)(function () {
  return isExtensible(Object.preventExtensions({}));
});
var setMeta = function (it) {
  setDesc(it, META, { value: {
    i: 'O' + ++id, // object ID
    w: {}          // weak collections IDs
  } });
};
var fastKey = function (it, create) {
  // return primitive with prefix
  if (!isObject(it)) return typeof it == 'symbol' ? it : (typeof it == 'string' ? 'S' : 'P') + it;
  if (!has(it, META)) {
    // can't set metadata to uncaught frozen object
    if (!isExtensible(it)) return 'F';
    // not necessary to add metadata
    if (!create) return 'E';
    // add missing metadata
    setMeta(it);
  // return object ID
  } return it[META].i;
};
var getWeak = function (it, create) {
  if (!has(it, META)) {
    // can't set metadata to uncaught frozen object
    if (!isExtensible(it)) return true;
    // not necessary to add metadata
    if (!create) return false;
    // add missing metadata
    setMeta(it);
  // return hash weak collections IDs
  } return it[META].w;
};
// add metadata on freeze-family methods calling
var onFreeze = function (it) {
  if (FREEZE && meta.NEED && isExtensible(it) && !has(it, META)) setMeta(it);
  return it;
};
var meta = module.exports = {
  KEY: META,
  NEED: false,
  fastKey: fastKey,
  getWeak: getWeak,
  onFreeze: onFreeze
};


/***/ }),
/* 107 */
/***/ (function(module, exports) {

/* -*- Mode: js; js-indent-level: 2; -*- */
/*
 * Copyright 2011 Mozilla Foundation and contributors
 * Licensed under the New BSD license. See LICENSE or:
 * http://opensource.org/licenses/BSD-3-Clause
 */

/**
 * This is a helper function for getting values from parameter/options
 * objects.
 *
 * @param args The object we are extracting values from
 * @param name The name of the property we are getting.
 * @param defaultValue An optional value to return if the property is missing
 * from the object. If this is not specified and the property is missing, an
 * error will be thrown.
 */
function getArg(aArgs, aName, aDefaultValue) {
  if (aName in aArgs) {
    return aArgs[aName];
  } else if (arguments.length === 3) {
    return aDefaultValue;
  } else {
    throw new Error('"' + aName + '" is a required argument.');
  }
}
exports.getArg = getArg;

var urlRegexp = /^(?:([\w+\-.]+):)?\/\/(?:(\w+:\w+)@)?([\w.]*)(?::(\d+))?(\S*)$/;
var dataUrlRegexp = /^data:.+\,.+$/;

function urlParse(aUrl) {
  var match = aUrl.match(urlRegexp);
  if (!match) {
    return null;
  }
  return {
    scheme: match[1],
    auth: match[2],
    host: match[3],
    port: match[4],
    path: match[5]
  };
}
exports.urlParse = urlParse;

function urlGenerate(aParsedUrl) {
  var url = '';
  if (aParsedUrl.scheme) {
    url += aParsedUrl.scheme + ':';
  }
  url += '//';
  if (aParsedUrl.auth) {
    url += aParsedUrl.auth + '@';
  }
  if (aParsedUrl.host) {
    url += aParsedUrl.host;
  }
  if (aParsedUrl.port) {
    url += ":" + aParsedUrl.port
  }
  if (aParsedUrl.path) {
    url += aParsedUrl.path;
  }
  return url;
}
exports.urlGenerate = urlGenerate;

/**
 * Normalizes a path, or the path portion of a URL:
 *
 * - Replaces consecutive slashes with one slash.
 * - Removes unnecessary '.' parts.
 * - Removes unnecessary '<dir>/..' parts.
 *
 * Based on code in the Node.js 'path' core module.
 *
 * @param aPath The path or url to normalize.
 */
function normalize(aPath) {
  var path = aPath;
  var url = urlParse(aPath);
  if (url) {
    if (!url.path) {
      return aPath;
    }
    path = url.path;
  }
  var isAbsolute = exports.isAbsolute(path);

  var parts = path.split(/\/+/);
  for (var part, up = 0, i = parts.length - 1; i >= 0; i--) {
    part = parts[i];
    if (part === '.') {
      parts.splice(i, 1);
    } else if (part === '..') {
      up++;
    } else if (up > 0) {
      if (part === '') {
        // The first part is blank if the path is absolute. Trying to go
        // above the root is a no-op. Therefore we can remove all '..' parts
        // directly after the root.
        parts.splice(i + 1, up);
        up = 0;
      } else {
        parts.splice(i, 2);
        up--;
      }
    }
  }
  path = parts.join('/');

  if (path === '') {
    path = isAbsolute ? '/' : '.';
  }

  if (url) {
    url.path = path;
    return urlGenerate(url);
  }
  return path;
}
exports.normalize = normalize;

/**
 * Joins two paths/URLs.
 *
 * @param aRoot The root path or URL.
 * @param aPath The path or URL to be joined with the root.
 *
 * - If aPath is a URL or a data URI, aPath is returned, unless aPath is a
 *   scheme-relative URL: Then the scheme of aRoot, if any, is prepended
 *   first.
 * - Otherwise aPath is a path. If aRoot is a URL, then its path portion
 *   is updated with the result and aRoot is returned. Otherwise the result
 *   is returned.
 *   - If aPath is absolute, the result is aPath.
 *   - Otherwise the two paths are joined with a slash.
 * - Joining for example 'http://' and 'www.example.com' is also supported.
 */
function join(aRoot, aPath) {
  if (aRoot === "") {
    aRoot = ".";
  }
  if (aPath === "") {
    aPath = ".";
  }
  var aPathUrl = urlParse(aPath);
  var aRootUrl = urlParse(aRoot);
  if (aRootUrl) {
    aRoot = aRootUrl.path || '/';
  }

  // `join(foo, '//www.example.org')`
  if (aPathUrl && !aPathUrl.scheme) {
    if (aRootUrl) {
      aPathUrl.scheme = aRootUrl.scheme;
    }
    return urlGenerate(aPathUrl);
  }

  if (aPathUrl || aPath.match(dataUrlRegexp)) {
    return aPath;
  }

  // `join('http://', 'www.example.com')`
  if (aRootUrl && !aRootUrl.host && !aRootUrl.path) {
    aRootUrl.host = aPath;
    return urlGenerate(aRootUrl);
  }

  var joined = aPath.charAt(0) === '/'
    ? aPath
    : normalize(aRoot.replace(/\/+$/, '') + '/' + aPath);

  if (aRootUrl) {
    aRootUrl.path = joined;
    return urlGenerate(aRootUrl);
  }
  return joined;
}
exports.join = join;

exports.isAbsolute = function (aPath) {
  return aPath.charAt(0) === '/' || !!aPath.match(urlRegexp);
};

/**
 * Make a path relative to a URL or another path.
 *
 * @param aRoot The root path or URL.
 * @param aPath The path or URL to be made relative to aRoot.
 */
function relative(aRoot, aPath) {
  if (aRoot === "") {
    aRoot = ".";
  }

  aRoot = aRoot.replace(/\/$/, '');

  // It is possible for the path to be above the root. In this case, simply
  // checking whether the root is a prefix of the path won't work. Instead, we
  // need to remove components from the root one by one, until either we find
  // a prefix that fits, or we run out of components to remove.
  var level = 0;
  while (aPath.indexOf(aRoot + '/') !== 0) {
    var index = aRoot.lastIndexOf("/");
    if (index < 0) {
      return aPath;
    }

    // If the only part of the root that is left is the scheme (i.e. http://,
    // file:///, etc.), one or more slashes (/), or simply nothing at all, we
    // have exhausted all components, so the path is not relative to the root.
    aRoot = aRoot.slice(0, index);
    if (aRoot.match(/^([^\/]+:\/)?\/*$/)) {
      return aPath;
    }

    ++level;
  }

  // Make sure we add a "../" for each component we removed from the root.
  return Array(level + 1).join("../") + aPath.substr(aRoot.length + 1);
}
exports.relative = relative;

var supportsNullProto = (function () {
  var obj = Object.create(null);
  return !('__proto__' in obj);
}());

function identity (s) {
  return s;
}

/**
 * Because behavior goes wacky when you set `__proto__` on objects, we
 * have to prefix all the strings in our set with an arbitrary character.
 *
 * See https://github.com/mozilla/source-map/pull/31 and
 * https://github.com/mozilla/source-map/issues/30
 *
 * @param String aStr
 */
function toSetString(aStr) {
  if (isProtoString(aStr)) {
    return '$' + aStr;
  }

  return aStr;
}
exports.toSetString = supportsNullProto ? identity : toSetString;

function fromSetString(aStr) {
  if (isProtoString(aStr)) {
    return aStr.slice(1);
  }

  return aStr;
}
exports.fromSetString = supportsNullProto ? identity : fromSetString;

function isProtoString(s) {
  if (!s) {
    return false;
  }

  var length = s.length;

  if (length < 9 /* "__proto__".length */) {
    return false;
  }

  if (s.charCodeAt(length - 1) !== 95  /* '_' */ ||
      s.charCodeAt(length - 2) !== 95  /* '_' */ ||
      s.charCodeAt(length - 3) !== 111 /* 'o' */ ||
      s.charCodeAt(length - 4) !== 116 /* 't' */ ||
      s.charCodeAt(length - 5) !== 111 /* 'o' */ ||
      s.charCodeAt(length - 6) !== 114 /* 'r' */ ||
      s.charCodeAt(length - 7) !== 112 /* 'p' */ ||
      s.charCodeAt(length - 8) !== 95  /* '_' */ ||
      s.charCodeAt(length - 9) !== 95  /* '_' */) {
    return false;
  }

  for (var i = length - 10; i >= 0; i--) {
    if (s.charCodeAt(i) !== 36 /* '$' */) {
      return false;
    }
  }

  return true;
}

/**
 * Comparator between two mappings where the original positions are compared.
 *
 * Optionally pass in `true` as `onlyCompareGenerated` to consider two
 * mappings with the same original source/line/column, but different generated
 * line and column the same. Useful when searching for a mapping with a
 * stubbed out mapping.
 */
function compareByOriginalPositions(mappingA, mappingB, onlyCompareOriginal) {
  var cmp = mappingA.source - mappingB.source;
  if (cmp !== 0) {
    return cmp;
  }

  cmp = mappingA.originalLine - mappingB.originalLine;
  if (cmp !== 0) {
    return cmp;
  }

  cmp = mappingA.originalColumn - mappingB.originalColumn;
  if (cmp !== 0 || onlyCompareOriginal) {
    return cmp;
  }

  cmp = mappingA.generatedColumn - mappingB.generatedColumn;
  if (cmp !== 0) {
    return cmp;
  }

  cmp = mappingA.generatedLine - mappingB.generatedLine;
  if (cmp !== 0) {
    return cmp;
  }

  return mappingA.name - mappingB.name;
}
exports.compareByOriginalPositions = compareByOriginalPositions;

/**
 * Comparator between two mappings with deflated source and name indices where
 * the generated positions are compared.
 *
 * Optionally pass in `true` as `onlyCompareGenerated` to consider two
 * mappings with the same generated line and column, but different
 * source/name/original line and column the same. Useful when searching for a
 * mapping with a stubbed out mapping.
 */
function compareByGeneratedPositionsDeflated(mappingA, mappingB, onlyCompareGenerated) {
  var cmp = mappingA.generatedLine - mappingB.generatedLine;
  if (cmp !== 0) {
    return cmp;
  }

  cmp = mappingA.generatedColumn - mappingB.generatedColumn;
  if (cmp !== 0 || onlyCompareGenerated) {
    return cmp;
  }

  cmp = mappingA.source - mappingB.source;
  if (cmp !== 0) {
    return cmp;
  }

  cmp = mappingA.originalLine - mappingB.originalLine;
  if (cmp !== 0) {
    return cmp;
  }

  cmp = mappingA.originalColumn - mappingB.originalColumn;
  if (cmp !== 0) {
    return cmp;
  }

  return mappingA.name - mappingB.name;
}
exports.compareByGeneratedPositionsDeflated = compareByGeneratedPositionsDeflated;

function strcmp(aStr1, aStr2) {
  if (aStr1 === aStr2) {
    return 0;
  }

  if (aStr1 > aStr2) {
    return 1;
  }

  return -1;
}

/**
 * Comparator between two mappings with inflated source and name strings where
 * the generated positions are compared.
 */
function compareByGeneratedPositionsInflated(mappingA, mappingB) {
  var cmp = mappingA.generatedLine - mappingB.generatedLine;
  if (cmp !== 0) {
    return cmp;
  }

  cmp = mappingA.generatedColumn - mappingB.generatedColumn;
  if (cmp !== 0) {
    return cmp;
  }

  cmp = strcmp(mappingA.source, mappingB.source);
  if (cmp !== 0) {
    return cmp;
  }

  cmp = mappingA.originalLine - mappingB.originalLine;
  if (cmp !== 0) {
    return cmp;
  }

  cmp = mappingA.originalColumn - mappingB.originalColumn;
  if (cmp !== 0) {
    return cmp;
  }

  return strcmp(mappingA.name, mappingB.name);
}
exports.compareByGeneratedPositionsInflated = compareByGeneratedPositionsInflated;


/***/ }),
/* 108 */
/***/ (function(module, exports, __webpack_require__) {

module.exports = { "default": __webpack_require__(694), __esModule: true };

/***/ }),
/* 109 */
/***/ (function(module, exports, __webpack_require__) {

var ctx = __webpack_require__(89);
var call = __webpack_require__(704);
var isArrayIter = __webpack_require__(705);
var anObject = __webpack_require__(53);
var toLength = __webpack_require__(187);
var getIterFn = __webpack_require__(318);
var BREAK = {};
var RETURN = {};
var exports = module.exports = function (iterable, entries, fn, that, ITERATOR) {
  var iterFn = ITERATOR ? function () { return iterable; } : getIterFn(iterable);
  var f = ctx(fn, that, entries ? 2 : 1);
  var index = 0;
  var length, step, iterator, result;
  if (typeof iterFn != 'function') throw TypeError(iterable + ' is not iterable!');
  // fast case for arrays with default iterator
  if (isArrayIter(iterFn)) for (length = toLength(iterable.length); length > index; index++) {
    result = entries ? f(anObject(step = iterable[index])[0], step[1]) : f(iterable[index]);
    if (result === BREAK || result === RETURN) return result;
  } else for (iterator = iterFn.call(iterable); !(step = iterator.next()).done;) {
    result = call(iterator, f, step.value, entries);
    if (result === BREAK || result === RETURN) return result;
  }
};
exports.BREAK = BREAK;
exports.RETURN = RETURN;


/***/ }),
/* 110 */
/***/ (function(module, exports, __webpack_require__) {

var isObject = __webpack_require__(32);
module.exports = function (it, TYPE) {
  if (!isObject(it) || it._t !== TYPE) throw TypeError('Incompatible receiver, ' + TYPE + ' required!');
  return it;
};


/***/ }),
/* 111 */
/***/ (function(module, exports) {

/**
 * Performs a
 * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
 * comparison between two values to determine if they are equivalent.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to compare.
 * @param {*} other The other value to compare.
 * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
 * @example
 *
 * var object = { 'a': 1 };
 * var other = { 'a': 1 };
 *
 * _.eq(object, object);
 * // => true
 *
 * _.eq(object, other);
 * // => false
 *
 * _.eq('a', 'a');
 * // => true
 *
 * _.eq('a', Object('a'));
 * // => false
 *
 * _.eq(NaN, NaN);
 * // => true
 */
function eq(value, other) {
  return value === other || (value !== value && other !== other);
}

module.exports = eq;


/***/ }),
/* 112 */
/***/ (function(module, exports, __webpack_require__) {

var root = __webpack_require__(41);

/** Built-in value references. */
var Symbol = root.Symbol;

module.exports = Symbol;


/***/ }),
/* 113 */
/***/ (function(module, exports, __webpack_require__) {

var toFinite = __webpack_require__(771);

/**
 * Converts `value` to an integer.
 *
 * **Note:** This method is loosely based on
 * [`ToInteger`](http://www.ecma-international.org/ecma-262/7.0/#sec-tointeger).
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to convert.
 * @returns {number} Returns the converted integer.
 * @example
 *
 * _.toInteger(3.2);
 * // => 3
 *
 * _.toInteger(Number.MIN_VALUE);
 * // => 0
 *
 * _.toInteger(Infinity);
 * // => 1.7976931348623157e+308
 *
 * _.toInteger('3.2');
 * // => 3
 */
function toInteger(value) {
  var result = toFinite(value),
      remainder = result % 1;

  return result === result ? (remainder ? result - remainder : result) : 0;
}

module.exports = toInteger;


/***/ }),
/* 114 */
/***/ (function(module, exports, __webpack_require__) {

var assignValue = __webpack_require__(216),
    baseAssignValue = __webpack_require__(352);

/**
 * Copies properties of `source` to `object`.
 *
 * @private
 * @param {Object} source The object to copy properties from.
 * @param {Array} props The property identifiers to copy.
 * @param {Object} [object={}] The object to copy properties to.
 * @param {Function} [customizer] The function to customize copied values.
 * @returns {Object} Returns `object`.
 */
function copyObject(source, props, object, customizer) {
  var isNew = !object;
  object || (object = {});

  var index = -1,
      length = props.length;

  while (++index < length) {
    var key = props[index];

    var newValue = customizer
      ? customizer(object[key], source[key], key, object, source)
      : undefined;

    if (newValue === undefined) {
      newValue = source[key];
    }
    if (isNew) {
      baseAssignValue(object, key, newValue);
    } else {
      assignValue(object, key, newValue);
    }
  }
  return object;
}

module.exports = copyObject;


/***/ }),
/* 115 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EvalPropertyName = EvalPropertyName;

exports.default = function (ast, strictCode, env, realm) {
  // 1. Let obj be ObjectCreate(%ObjectPrototype%).
  let obj = _singletons.Create.ObjectCreate(realm, realm.intrinsics.ObjectPrototype);

  // 2. Let status be the result of performing PropertyDefinitionEvaluation of PropertyDefinitionList with arguments obj and true.
  for (let prop of ast.properties) {
    if (prop.type === "ObjectProperty") {
      // 12.2.6.9 case 3
      // 1. Let propKey be the result of evaluating PropertyName.
      let propKey = EvalPropertyNamePartial(prop, env, realm, strictCode);

      // 2. ReturnIfAbrupt(propKey).

      // 3. Let exprValueRef be the result of evaluating AssignmentExpression.
      let exprValueRef = env.evaluate(prop.value, strictCode);

      // 4. Let propValue be ? GetValue(exprValueRef).
      let propValue = _singletons.Environment.GetValue(realm, exprValueRef);

      // 5. If IsAnonymousFunctionDefinition(AssignmentExpression) is true, then
      if ((0, _index2.IsAnonymousFunctionDefinition)(realm, prop.value)) {
        (0, _invariant2.default)(propValue instanceof _index.ObjectValue);

        // a. Let hasNameProperty be ? HasOwnProperty(propValue, "name").
        let hasNameProperty = (0, _index2.HasOwnProperty)(realm, propValue, "name");

        // b. If hasNameProperty is false, perform SetFunctionName(propValue, propKey).
        (0, _invariant2.default)(!hasNameProperty); // No expression that passes through IsAnonymousFunctionDefinition can have it here
        _singletons.Functions.SetFunctionName(realm, propValue, propKey);
      }

      // 6. Assert: enumerable is true.

      // 7. Return CreateDataPropertyOrThrow(object, propKey, propValue).
      if (propKey instanceof _index.AbstractValue) {
        if (propKey.mightNotBeString()) {
          let error = new _errors.CompilerDiagnostic("property key value is unknown", prop.loc, "PP0011", "FatalError");
          if (realm.handleError(error) === "Fail") throw new _errors.FatalError();
          continue; // recover by ignoring the property, which is only ever safe to do if the property is dead,
          // which is assuming a bit much, hence the designation as a FatalError.
        }
        obj.$SetPartial(propKey, propValue, obj);
      } else {
        _singletons.Create.CreateDataPropertyOrThrow(realm, obj, propKey, propValue);
      }
    } else {
      (0, _invariant2.default)(prop.type === "ObjectMethod");
      _singletons.Properties.PropertyDefinitionEvaluation(realm, prop, obj, env, strictCode, true);
    }
  }

  // 3. ReturnIfAbrupt(status).

  // 4. Return obj.
  return obj;
};

var _errors = __webpack_require__(6);

var _index = __webpack_require__(0);

var _index2 = __webpack_require__(5);

var _singletons = __webpack_require__(2);

var _invariant = __webpack_require__(1);

var _invariant2 = _interopRequireDefault(_invariant);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// Returns the result of evaluating PropertyName.
/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 */

function EvalPropertyName(prop, env, realm, strictCode) {
  let result = EvalPropertyNamePartial(prop, env, realm, strictCode);
  if (result instanceof _index.AbstractValue) {
    let error = new _errors.CompilerDiagnostic("unknown computed property name", prop.loc, "PP0014", "FatalError");
    realm.handleError(error);
    throw new _errors.FatalError();
  }
  return result;
}

function EvalPropertyNamePartial(prop, env, realm, strictCode) {
  if (prop.computed) {
    let propertyKeyName = _singletons.Environment.GetValue(realm, env.evaluate(prop.key, strictCode));
    if (propertyKeyName instanceof _index.AbstractValue) return propertyKeyName;
    (0, _invariant2.default)(propertyKeyName instanceof _index.ConcreteValue);
    return _singletons.To.ToPropertyKey(realm, propertyKeyName);
  } else {
    if (prop.key.type === "Identifier") {
      return new _index.StringValue(realm, prop.key.name);
    } else {
      let propertyKeyName = _singletons.Environment.GetValue(realm, env.evaluate(prop.key, strictCode));
      (0, _invariant2.default)(propertyKeyName instanceof _index.ConcreteValue); // syntax only allows literals if !prop.computed
      return _singletons.To.ToString(realm, propertyKeyName);
    }
  }
}

// ECMA262 12.2.6.8

/***/ }),
/* 116 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseTypeNameOrTemplate = parseTypeNameOrTemplate;
exports.createAbstractArgument = createAbstractArgument;
exports.createAbstract = createAbstract;

var _index = __webpack_require__(0);

var _builder = __webpack_require__(36);

var _builder2 = _interopRequireDefault(_builder);

var _index2 = __webpack_require__(24);

var _Error = __webpack_require__(45);

var _singletons = __webpack_require__(2);

var _AbstractObjectValue = __webpack_require__(370);

var _AbstractObjectValue2 = _interopRequireDefault(_AbstractObjectValue);

var _errors = __webpack_require__(6);

var _singletons2 = __webpack_require__(2);

var _invariant = __webpack_require__(1);

var _invariant2 = _interopRequireDefault(_invariant);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 */

const throwTemplateSrc = "(function(){throw new global.Error('abstract value defined at ' + A);})()";
const throwTemplate = (0, _builder2.default)(throwTemplateSrc);

function parseTypeNameOrTemplate(realm, typeNameOrTemplate) {
  if (typeNameOrTemplate === undefined || typeNameOrTemplate instanceof _index.UndefinedValue) {
    return { type: _index.Value, template: undefined };
  } else if (typeof typeNameOrTemplate === "string") {
    let type = _singletons2.Utils.getTypeFromName(typeNameOrTemplate);
    if (type === undefined) {
      throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "unknown typeNameOrTemplate");
    }
    return { type, template: undefined };
  } else if (typeNameOrTemplate instanceof _index.StringValue) {
    let typeNameString = _singletons.To.ToStringPartial(realm, typeNameOrTemplate);
    let hasFunctionResultType = typeNameString.startsWith(":");
    if (hasFunctionResultType) typeNameString = typeNameString.substring(1);
    let type = _singletons2.Utils.getTypeFromName(typeNameString);
    if (type === undefined) {
      throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "unknown typeNameOrTemplate");
    }
    return hasFunctionResultType ? { type: _index.FunctionValue, template: undefined, functionResultType: type } : { type, template: undefined };
  } else if (typeNameOrTemplate instanceof _index.FunctionValue) {
    return { type: _index.FunctionValue, template: typeNameOrTemplate };
  } else if (typeNameOrTemplate instanceof _index.ObjectValue) {
    return { type: _index.ObjectValue, template: typeNameOrTemplate };
  } else {
    throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "typeNameOrTemplate has unsupported type");
  }
}

function createAbstractArgument(realm, name, location) {
  if (!realm.useAbstractInterpretation) {
    throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "realm is not partial");
  }

  let locString;
  if (location) locString = (0, _Error.describeLocation)(realm, undefined, undefined, location);
  let locVal = new _index.StringValue(realm, locString || "(unknown location)");
  let kind = "__abstract_" + realm.objectCount++; // need not be an object, but must be unique
  let result = _index.AbstractValue.createFromTemplate(realm, (0, _builder2.default)(name), _index.Value, [locVal], kind);
  result.intrinsicName = name;

  return result;
}

function createAbstract(realm, typeNameOrTemplate, name, ...additionalValues) {
  if (!realm.useAbstractInterpretation) {
    throw realm.createErrorThrowCompletion(realm.intrinsics.TypeError, "realm is not partial");
  }

  let { type, template, functionResultType } = parseTypeNameOrTemplate(realm, typeNameOrTemplate);

  let result;
  let locString,
      loc = null;
  for (let executionContext of realm.contextStack.slice().reverse()) {
    let caller = executionContext.caller;
    loc = executionContext.loc;
    locString = (0, _Error.describeLocation)(realm, caller ? caller.function : undefined, caller ? caller.lexicalEnvironment : undefined, loc);
    if (locString !== undefined) break;
  }
  if (!name) {
    let locVal = new _index.StringValue(realm, locString || "(unknown location)");
    let kind = "__abstract_" + realm.objectCount++; // need not be an object, but must be unique
    result = _index.AbstractValue.createFromTemplate(realm, throwTemplate, type, [locVal], kind);
  } else {
    let kind = "__abstract_" + name;
    if (!realm.isNameStringUnique(name)) {
      let error = new _errors.CompilerDiagnostic("An abstract value with the same name exists", loc, "PP0019", "FatalError");
      realm.handleError(error);
      throw new _errors.FatalError();
    } else {
      realm.saveNameString(name);
    }
    result = _index.AbstractValue.createFromTemplate(realm, (0, _builder2.default)(name), type, [], kind);
    result.intrinsicName = name;
  }

  if (template) result.values = new _index2.ValuesDomain(new Set([template]));
  if (template && !(template instanceof _index.FunctionValue)) {
    // why exclude functions?
    template.makePartial();
    if (name) realm.rebuildNestedProperties(result, name);
  }
  if (functionResultType) {
    (0, _invariant2.default)(result instanceof _AbstractObjectValue2.default);
    result.functionResultType = functionResultType;
  }

  if (additionalValues.length > 0) result = _index.AbstractValue.createAbstractConcreteUnion(realm, result, ...additionalValues);
  return result;
}

/***/ }),
/* 117 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResidualHeapVisitor = undefined;

var _environment = __webpack_require__(8);

var _errors = __webpack_require__(6);

var _realm = __webpack_require__(7);

var _index = __webpack_require__(5);

var _index2 = __webpack_require__(0);

var _Error = __webpack_require__(45);

var _babelTypes = __webpack_require__(4);

var t = _interopRequireWildcard(_babelTypes);

var _generator = __webpack_require__(23);

var _babelTraverse = __webpack_require__(43);

var _babelTraverse2 = _interopRequireDefault(_babelTraverse);

var _invariant = __webpack_require__(1);

var _invariant2 = _interopRequireDefault(_invariant);

var _visitors = __webpack_require__(372);

var _logger = __webpack_require__(44);

var _modules = __webpack_require__(69);

var _ResidualHeapInspector = __webpack_require__(118);

var _Referentializer = __webpack_require__(226);

var _utils = __webpack_require__(119);

var _singletons = __webpack_require__(2);

var _utils2 = __webpack_require__(18);

var _hoisting = __webpack_require__(227);

var _ReactElementSet = __webpack_require__(952);

var _ReactElementSet2 = _interopRequireDefault(_ReactElementSet);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

/* This class visits all values that are reachable in the residual heap.
   In particular, this "filters out" values that are:
   - captured by a DeclarativeEnvironmentRecord, but not actually used by any closure.
   - Unmodified prototype objects
   TODO #680: Figure out minimal set of values that need to be kept alive for WeakSet and WeakMap instances.
*/
/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 */

class ResidualHeapVisitor {
  constructor(realm, logger, modules, additionalFunctionValuesAndEffects,
  // Referentializer is null if we're just checking what values exist
  referentializer) {
    (0, _invariant2.default)(realm.useAbstractInterpretation);
    this.realm = realm;
    this.logger = logger;
    this.modules = modules;
    this.referentializer = referentializer === "NO_REFERENTIALIZE" ? undefined : referentializer;

    this.declarativeEnvironmentRecordsBindings = new Map();
    this.globalBindings = new Map();
    this.functionInfos = new Map();
    this.classMethodInstances = new Map();
    this.functionInstances = new Map();
    this.values = new Map();
    let generator = this.realm.generator;
    (0, _invariant2.default)(generator);
    this.scope = this.commonScope = generator;
    this.inspector = new _ResidualHeapInspector.ResidualHeapInspector(realm, logger);
    this.referencedDeclaredValues = new Map();
    this.delayedVisitGeneratorEntries = [];
    this.someReactElement = undefined;
    this.additionalFunctionValuesAndEffects = additionalFunctionValuesAndEffects;
    this.equivalenceSet = new _index.HashSet();
    this.reactElementEquivalenceSet = new _ReactElementSet2.default(realm, this.equivalenceSet);
    this.additionalFunctionValueInfos = new Map();
    this.containingAdditionalFunction = undefined;
    this.additionalRoots = new Map();
    this.inClass = false;
    this.functionToCapturedScopes = new Map();
    this.generatorParents = new Map();
  }

  // Caches that ensure one ResidualFunctionBinding exists per (record, name) pair

  // Either the realm's generator or the FunctionValue of an additional function to serialize


  // We only want to add to additionalRoots when we're in an additional function

  // Tracks objects + functions that were visited from inside additional functions that need to be serialized in a
  // parent scope of the additional function (e.g. functions/objects only used from additional functions that were
  // declared outside the additional function need to be serialized in the additional function's parent scope for
  // identity to work).


  _registerAdditionalRoot(value) {
    let additionalFunction = this.containingAdditionalFunction;
    if (additionalFunction !== undefined && !this.inClass) {
      let s = this.additionalRoots.get(value);
      if (s === undefined) this.additionalRoots.set(value, s = new Set());
      s.add(additionalFunction);
    }
  }

  _withScope(scope, f) {
    let oldScope = this.scope;
    this.scope = scope;
    try {
      f();
    } finally {
      this.scope = oldScope;
    }
  }

  visitObjectProperty(binding) {
    let desc = binding.descriptor;
    if (desc === undefined) return; //deleted
    let obj = binding.object;
    if (obj instanceof _index2.AbstractObjectValue || !this.inspector.canIgnoreProperty(obj, binding.key)) {
      this.visitDescriptor(desc);
    }
  }

  visitObjectProperties(obj, kind) {
    let { skipPrototype, constructor } = (0, _utils.getObjectPrototypeMetadata)(this.realm, obj);

    // visit properties
    if (!(0, _utils2.isReactElement)(obj)) {
      for (let [symbol, propertyBinding] of obj.symbols) {
        (0, _invariant2.default)(propertyBinding);
        let desc = propertyBinding.descriptor;
        if (desc === undefined) continue; //deleted
        this.visitDescriptor(desc);
        this.visitValue(symbol);
      }
    }

    // visit properties
    for (let [propertyBindingKey, propertyBindingValue] of obj.properties) {
      // we don't want to visit these as we handle the serialization ourselves
      // via a different logic route for classes
      let descriptor = propertyBindingValue.descriptor;
      if (obj.$FunctionKind === "classConstructor" && (_utils.ClassPropertiesToIgnore.has(propertyBindingKey) || propertyBindingKey === "length" && (0, _utils.canIgnoreClassLengthProperty)(obj, descriptor, this.logger))) {
        continue;
      }
      if (propertyBindingKey.pathNode !== undefined) continue; // property is written to inside a loop
      (0, _invariant2.default)(propertyBindingValue);
      this.visitObjectProperty(propertyBindingValue);
    }

    // inject properties with computed names
    if (obj.unknownProperty !== undefined) {
      let desc = obj.unknownProperty.descriptor;
      if (desc !== undefined) {
        let val = desc.value;
        (0, _invariant2.default)(val instanceof _index2.AbstractValue);
        this.visitObjectPropertiesWithComputedNames(val);
      }
    }

    // prototype
    if (!(0, _utils2.isReactElement)(obj) && !skipPrototype) {
      // we don't want to the ReactElement prototype visited
      // as this is contained within the JSXElement, otherwise
      // they we be need to be emitted during serialization
      this.visitObjectPrototype(obj);
    }
    if (obj instanceof _index2.FunctionValue) {
      this.visitConstructorPrototype(constructor ? constructor : obj);
    } else if (obj instanceof _index2.ObjectValue && skipPrototype && constructor) {
      this.visitValue(constructor);
    }
  }

  visitObjectPrototype(obj) {
    let proto = obj.$Prototype;

    let kind = obj.getKind();
    if (proto === this.realm.intrinsics[kind + "Prototype"]) return;

    if (!obj.$IsClassPrototype || proto !== this.realm.intrinsics.null) {
      this.visitValue(proto);
    }
  }

  visitConstructorPrototype(func) {
    // If the original prototype object was mutated,
    // request its serialization here as this might be observable by
    // residual code.
    (0, _invariant2.default)(func instanceof _index2.FunctionValue);
    let prototype = _ResidualHeapInspector.ResidualHeapInspector.getPropertyValue(func, "prototype");
    if (prototype instanceof _index2.ObjectValue && prototype.originalConstructor === func && !this.inspector.isDefaultPrototype(prototype)) {
      this.visitValue(prototype);
    }
  }

  visitObjectPropertiesWithComputedNames(absVal) {
    if (absVal.kind === "widened property") return;
    (0, _invariant2.default)(absVal.args.length === 3);
    let cond = absVal.args[0];
    (0, _invariant2.default)(cond instanceof _index2.AbstractValue);
    if (cond.kind === "template for property name condition") {
      let P = cond.args[0];
      (0, _invariant2.default)(P instanceof _index2.AbstractValue);
      let V = absVal.args[1];
      let earlier_props = absVal.args[2];
      if (earlier_props instanceof _index2.AbstractValue) this.visitObjectPropertiesWithComputedNames(earlier_props);
      this.visitValue(P);
      this.visitValue(V);
    } else {
      // conditional assignment
      absVal.args[0] = this.visitEquivalentValue(cond);
      let consequent = absVal.args[1];
      (0, _invariant2.default)(consequent instanceof _index2.AbstractValue);
      let alternate = absVal.args[2];
      (0, _invariant2.default)(alternate instanceof _index2.AbstractValue);
      this.visitObjectPropertiesWithComputedNames(consequent);
      this.visitObjectPropertiesWithComputedNames(alternate);
    }
  }

  visitDescriptor(desc) {
    (0, _invariant2.default)(desc.value === undefined || desc.value instanceof _index2.Value);
    if (desc.joinCondition !== undefined) {
      desc.joinCondition = this.visitEquivalentValue(desc.joinCondition);
      if (desc.descriptor1 !== undefined) this.visitDescriptor(desc.descriptor1);
      if (desc.descriptor2 !== undefined) this.visitDescriptor(desc.descriptor2);
      return;
    }
    if (desc.value !== undefined) desc.value = this.visitEquivalentValue(desc.value);
    if (desc.get !== undefined) this.visitValue(desc.get);
    if (desc.set !== undefined) this.visitValue(desc.set);
  }

  visitValueArray(val) {
    this.visitObjectProperties(val);
    const realm = this.realm;
    let lenProperty;
    if (val.isHavocedObject()) {
      lenProperty = this.realm.evaluateWithoutLeakLogic(() => (0, _index.Get)(realm, val, "length"));
    } else {
      lenProperty = (0, _index.Get)(realm, val, "length");
    }
    if (lenProperty instanceof _index2.AbstractValue || _singletons.To.ToLength(realm, lenProperty) !== (0, _utils.getSuggestedArrayLiteralLength)(realm, val)) {
      this.visitValue(lenProperty);
    }
  }

  visitValueMap(val) {
    let kind = val.getKind();

    let entries;
    if (kind === "Map") {
      entries = val.$MapData;
    } else {
      (0, _invariant2.default)(kind === "WeakMap");
      entries = val.$WeakMapData;
    }
    (0, _invariant2.default)(entries !== undefined);
    let len = entries.length;

    for (let i = 0; i < len; i++) {
      let entry = entries[i];
      let key = entry.$Key;
      let value = entry.$Value;
      if (key === undefined || value === undefined) continue;
      this.visitValue(key);
      this.visitValue(value);
    }
  }

  visitValueSet(val) {
    let kind = val.getKind();

    let entries;
    if (kind === "Set") {
      entries = val.$SetData;
    } else {
      (0, _invariant2.default)(kind === "WeakSet");
      entries = val.$WeakSetData;
    }
    (0, _invariant2.default)(entries !== undefined);
    let len = entries.length;

    for (let i = 0; i < len; i++) {
      let entry = entries[i];
      if (entry === undefined) continue;
      this.visitValue(entry);
    }
  }

  visitValueFunction(val, parentScope) {
    let isClass = false;

    this._registerAdditionalRoot(val);
    if (val.$FunctionKind === "classConstructor") {
      (0, _invariant2.default)(val instanceof _index2.ECMAScriptSourceFunctionValue);
      let homeObject = val.$HomeObject;
      if (homeObject instanceof _index2.ObjectValue && homeObject.$IsClassPrototype) {
        isClass = true;
        this.inClass = true;
      }
    }
    this.visitObjectProperties(val);
    if (isClass && this.inClass) {
      this.inClass = false;
    }

    if (val instanceof _index2.BoundFunctionValue) {
      this.visitValue(val.$BoundTargetFunction);
      this.visitValue(val.$BoundThis);
      for (let boundArg of val.$BoundArguments) this.visitValue(boundArg);
      return;
    }

    (0, _invariant2.default)(!(val instanceof _index2.NativeFunctionValue), "all native function values should be intrinsics");

    (0, _invariant2.default)(val instanceof _index2.ECMAScriptSourceFunctionValue);
    (0, _invariant2.default)(val.constructor === _index2.ECMAScriptSourceFunctionValue);
    let formalParameters = val.$FormalParameters;
    let code = val.$ECMAScriptCode;

    let functionInfo = this.functionInfos.get(code);
    let residualFunctionBindings = new Map();
    this.functionInstances.set(val, {
      residualFunctionBindings,
      initializationStatements: [],
      functionValue: val,
      scopeInstances: new Map()
    });

    if (!functionInfo) {
      functionInfo = {
        unbound: new Set(),
        modified: new Set(),
        usesArguments: false,
        usesThis: false
      };
      let state = {
        tryQuery: this.logger.tryQuery.bind(this.logger),
        val,
        functionInfo,
        realm: this.realm
      };

      (0, _babelTraverse2.default)(t.file(t.program([t.expressionStatement(t.functionExpression(null, formalParameters, code))])), _visitors.ClosureRefVisitor, null, state);
      this.functionInfos.set(code, functionInfo);

      if (val.isResidual && functionInfo.unbound.size) {
        if (!val.isUnsafeResidual) {
          this.logger.logError(val, `residual function ${(0, _Error.describeLocation)(this.realm, val, undefined, code.loc) || "(unknown)"} refers to the following identifiers defined outside of the local scope: ${Object.keys(functionInfo.unbound).join(", ")}`);
        }
      }
    }

    let additionalFunctionEffects = this.additionalFunctionValuesAndEffects.get(val);
    if (additionalFunctionEffects) {
      this._visitAdditionalFunction(val, additionalFunctionEffects, parentScope);
    } else {
      this._withScope(val, () => {
        (0, _invariant2.default)(functionInfo);
        for (let innerName of functionInfo.unbound) {
          let residualBinding = this.visitBinding(val, innerName);
          (0, _invariant2.default)(residualBinding !== undefined);
          residualFunctionBindings.set(innerName, residualBinding);
          if (functionInfo.modified.has(innerName)) {
            residualBinding.modified = true;
          }
        }
      });
    }
    if (isClass && val.$HomeObject instanceof _index2.ObjectValue) {
      this._visitClass(val, val.$HomeObject);
    }
    this.functionInstances.set(val, {
      residualFunctionBindings,
      initializationStatements: [],
      functionValue: val,
      scopeInstances: new Map()
    });
  }

  // Addresses the case:
  // let x = [];
  // let y = [];
  // function a() { x.push("hi"); }
  // function b() { y.push("bye"); }
  // function c() { return x.length + y.length; }
  // Here we need to make sure that a and b both initialize x and y because x and y will be in the same
  // captured scope because c captures both x and y.
  _recordBindingVisitedAndRevisit(val, residualFunctionBinding) {
    let refScope = this.containingAdditionalFunction ? this.containingAdditionalFunction : "GLOBAL";
    (0, _invariant2.default)(!(refScope instanceof _generator.Generator));
    let funcToScopes = (0, _utils.getOrDefault)(this.functionToCapturedScopes, refScope, () => new Map());
    let envRec = residualFunctionBinding.declarativeEnvironmentRecord;
    (0, _invariant2.default)(envRec !== null);
    let bindingState = (0, _utils.getOrDefault)(funcToScopes, envRec, () => ({
      capturedBindings: new Set(),
      capturingFunctionsToCommonScope: new Map()
    }));
    // If the binding is new for this bindingState, have all functions capturing bindings from that scope visit it
    if (!bindingState.capturedBindings.has(residualFunctionBinding)) {
      if (residualFunctionBinding.value) {
        (0, _invariant2.default)(this);
        for (let [functionValue, functionCommonScope] of bindingState.capturingFunctionsToCommonScope) {
          (0, _invariant2.default)(this);
          let prevCommonScope = this.commonScope;
          try {
            this.commonScope = functionCommonScope;
            let value = residualFunctionBinding.value;
            this._withScope(functionValue, () => this.visitValue(value));
          } finally {
            this.commonScope = prevCommonScope;
          }
        }
      }
      bindingState.capturedBindings.add(residualFunctionBinding);
    }
    // If the function is new for this bindingState, visit all existent bindings in this scope
    if (!bindingState.capturingFunctionsToCommonScope.has(val)) {
      for (let residualBinding of bindingState.capturedBindings) {
        if (residualBinding.value) this.visitValue(residualBinding.value);
      }
      bindingState.capturingFunctionsToCommonScope.set(val, this.commonScope);
    }
  }

  // Visits a binding, if createBinding is true, will always return a ResidualFunctionBinding
  // otherwise visits + returns the binding only if one already exists.
  visitBinding(val, name, createBinding = true) {
    let residualFunctionBinding;
    let doesNotMatter = true;
    let reference = this.logger.tryQuery(() => _singletons.Environment.ResolveBinding(this.realm, name, doesNotMatter, val.$Environment), undefined);
    let getFromMap = createBinding ? _utils.getOrDefault : (map, key, defaultFn) => map.get(key);
    if (reference === undefined || _singletons.Environment.IsUnresolvableReference(this.realm, reference) || reference.base instanceof _environment.GlobalEnvironmentRecord) {
      // Global Binding
      residualFunctionBinding = getFromMap(this.globalBindings, name, () => ({
        value: this.realm.getGlobalLetBinding(name),
        modified: true,
        declarativeEnvironmentRecord: null
      }));
    } else {
      // DeclarativeEnvironmentRecord binding
      (0, _invariant2.default)(!_singletons.Environment.IsUnresolvableReference(this.realm, reference));
      let referencedBase = reference.base;
      let referencedName = reference.referencedName;
      if (typeof referencedName !== "string") {
        throw new _errors.FatalError("TODO: do not know how to visit reference with symbol");
      }
      (0, _invariant2.default)(referencedBase instanceof _environment.DeclarativeEnvironmentRecord);
      let residualFunctionBindings = (0, _utils.getOrDefault)(this.declarativeEnvironmentRecordsBindings, referencedBase, () => new Map());
      let createdBinding = !residualFunctionBindings.has(referencedName);
      residualFunctionBinding = getFromMap(residualFunctionBindings, referencedName, () => {
        (0, _invariant2.default)(referencedBase instanceof _environment.DeclarativeEnvironmentRecord);
        let binding = referencedBase.bindings[referencedName];
        (0, _invariant2.default)(!binding.deletable);
        return {
          value: binding.initialized && binding.value || this.realm.intrinsics.undefined,
          modified: false,
          declarativeEnvironmentRecord: referencedBase
        };
      });
      if (residualFunctionBinding) {
        if (this.containingAdditionalFunction && createdBinding) residualFunctionBinding.referencedOnlyFromAdditionalFunctions = this.containingAdditionalFunction;
        if (!this.containingAdditionalFunction && residualFunctionBinding.referencedOnlyFromAdditionalFunctions) delete residualFunctionBinding.referencedOnlyFromAdditionalFunctions;
        this._recordBindingVisitedAndRevisit(val, residualFunctionBinding);
      }
    }
    if (residualFunctionBinding && residualFunctionBinding.value) {
      residualFunctionBinding.value = this.visitEquivalentValue(residualFunctionBinding.value);
    }
    return residualFunctionBinding;
  }

  _visitClass(classFunc, classPrototype) {
    let visitClassMethod = (propertyNameOrSymbol, methodFunc, methodType, isStatic) => {
      if (methodFunc instanceof _index2.ECMAScriptSourceFunctionValue) {
        // if the method does not have a $HomeObject, it's not a class method
        if (methodFunc.$HomeObject !== undefined) {
          if (methodFunc !== classFunc) {
            this._visitClassMethod(methodFunc, methodType, classPrototype, !!isStatic);
          }
        }
      }
    };
    for (let [propertyName, method] of classPrototype.properties) {
      (0, _utils.withDescriptorValue)(propertyName, method.descriptor, visitClassMethod);
    }
    for (let [symbol, method] of classPrototype.symbols) {
      (0, _utils.withDescriptorValue)(symbol, method.descriptor, visitClassMethod);
    }

    // handle class inheritance
    if (!(classFunc.$Prototype instanceof _index2.NativeFunctionValue)) {
      this.visitValue(classFunc.$Prototype);
    }

    if (classPrototype.properties.has("constructor")) {
      let constructor = classPrototype.properties.get("constructor");

      (0, _invariant2.default)(constructor !== undefined);
      // check if the constructor was deleted, as it can't really be deleted
      // it just gets set to empty (the default again)
      if (constructor.descriptor === undefined) {
        classFunc.$HasEmptyConstructor = true;
      } else {
        let visitClassProperty = (propertyNameOrSymbol, methodFunc, methodType) => {
          visitClassMethod(propertyNameOrSymbol, methodFunc, methodType, true);
        };
        // check if we have any static methods we need to include
        let constructorFunc = (0, _index.Get)(this.realm, classPrototype, "constructor");
        (0, _invariant2.default)(constructorFunc instanceof _index2.ObjectValue);
        for (let [propertyName, method] of constructorFunc.properties) {
          if (!_utils.ClassPropertiesToIgnore.has(propertyName) && method.descriptor !== undefined && !(propertyName === "length" && (0, _utils.canIgnoreClassLengthProperty)(constructorFunc, method.descriptor, this.logger))) {
            (0, _utils.withDescriptorValue)(propertyName, method.descriptor, visitClassProperty);
          }
        }
      }
    }
    this.classMethodInstances.set(classFunc, {
      classPrototype,
      methodType: "constructor",
      classSuperNode: undefined,
      classMethodIsStatic: false,
      classMethodKeyNode: undefined,
      classMethodComputed: false
    });
  }

  _visitClassMethod(methodFunc, methodType, classPrototype, isStatic) {
    this.classMethodInstances.set(methodFunc, {
      classPrototype,
      methodType: methodType === "value" ? "method" : methodType,
      classSuperNode: undefined,
      classMethodIsStatic: isStatic,
      classMethodKeyNode: undefined,
      classMethodComputed: !!methodFunc.$HasComputedName
    });
  }

  visitValueObject(val) {
    this._registerAdditionalRoot(val);
    let kind = val.getKind();
    this.visitObjectProperties(val, kind);

    // If this object is a prototype object that was implicitly created by the runtime
    // for a constructor, then we can obtain a reference to this object
    // in a special way that's handled alongside function serialization.
    let constructor = val.originalConstructor;
    if (constructor !== undefined) {
      this.visitValue(constructor);
      return;
    }

    switch (kind) {
      case "RegExp":
      case "Number":
      case "String":
      case "Boolean":
      case "ArrayBuffer":
        return;
      case "ReactElement":
        this.someReactElement = val;
        // check we can hoist a React Element
        (0, _hoisting.canHoistReactElement)(this.realm, val, this);
        return;
      case "Date":
        let dateValue = val.$DateValue;
        (0, _invariant2.default)(dateValue !== undefined);
        this.visitValue(dateValue);
        return;
      case "Float32Array":
      case "Float64Array":
      case "Int8Array":
      case "Int16Array":
      case "Int32Array":
      case "Uint8Array":
      case "Uint16Array":
      case "Uint32Array":
      case "Uint8ClampedArray":
      case "DataView":
        let buf = val.$ViewedArrayBuffer;
        (0, _invariant2.default)(buf !== undefined);
        this.visitValue(buf);
        return;
      case "Map":
      case "WeakMap":
        this.visitValueMap(val);
        return;
      case "Set":
      case "WeakSet":
        this.visitValueSet(val);
        return;
      default:
        if (kind !== "Object") this.logger.logError(val, `Object of kind ${kind} is not supported in residual heap.`);
        if (this.$ParameterMap !== undefined) {
          this.logger.logError(val, `Arguments object is not supported in residual heap.`);
        }
        if (this.realm.react.enabled && (0, _utils2.valueIsReactLibraryObject)(this.realm, val, this.logger)) {
          this.realm.fbLibraries.react = val;
        }
        return;
    }
  }

  visitValueSymbol(val) {
    if (val.$Description) this.visitValue(val.$Description);
  }

  visitValueProxy(val) {
    this.visitValue(val.$ProxyTarget);
    this.visitValue(val.$ProxyHandler);
  }

  visitAbstractValue(val) {
    if (val.kind === "sentinel member expression") this.logger.logError(val, "expressions of type o[p] are not yet supported for partially known o and unknown p");
    if (val.kind === "sentinel ToObject") this.logger.logError(val, "Unknown object cannot be coerced to Object");
    for (let i = 0, n = val.args.length; i < n; i++) {
      val.args[i] = this.visitEquivalentValue(val.args[i]);
    }
  }

  // Overridable hook for pre-visiting the value.
  // Return false will tell visitor to skip visiting children of this node.
  preProcessValue(val) {
    return this._mark(val);
  }

  // Overridable hook for post-visiting the value.
  postProcessValue(val) {}

  _mark(val) {
    let scopes = this.values.get(val);
    if (scopes === undefined) this.values.set(val, scopes = new Set());
    if (scopes.has(this.scope)) return false;
    scopes.add(this.scope);
    return true;
  }

  visitEquivalentValue(val) {
    if (val instanceof _index2.AbstractValue) {
      let equivalentValue = this.equivalenceSet.add(val);
      if (this.preProcessValue(equivalentValue)) this.visitAbstractValue(equivalentValue);
      this.postProcessValue(equivalentValue);
      return equivalentValue;
    }
    if (val instanceof _index2.ObjectValue && (0, _utils2.isReactElement)(val)) {
      let equivalentReactElementValue = this.reactElementEquivalenceSet.add(val);
      if (this._mark(equivalentReactElementValue)) this.visitValueObject(equivalentReactElementValue);
      return equivalentReactElementValue;
    }
    this.visitValue(val);
    return val;
  }

  visitValue(val) {
    (0, _invariant2.default)(!val.refuseSerialization);
    if (val instanceof _index2.AbstractValue) {
      if (this.preProcessValue(val)) this.visitAbstractValue(val);
    } else if (val.isIntrinsic()) {
      // All intrinsic values exist from the beginning of time...
      // ...except for a few that come into existence as templates for abstract objects via executable code.
      if (val._isScopedTemplate) this.preProcessValue(val);else this._withScope(this.commonScope, () => {
        this.preProcessValue(val);
      });
    } else if (val instanceof _index2.EmptyValue) {
      this.preProcessValue(val);
    } else if (_ResidualHeapInspector.ResidualHeapInspector.isLeaf(val)) {
      this.preProcessValue(val);
    } else if ((0, _index.IsArray)(this.realm, val)) {
      (0, _invariant2.default)(val instanceof _index2.ObjectValue);
      if (this.preProcessValue(val)) this.visitValueArray(val);
    } else if (val instanceof _index2.ProxyValue) {
      if (this.preProcessValue(val)) this.visitValueProxy(val);
    } else if (val instanceof _index2.FunctionValue) {
      // Function declarations should get hoisted in common scope so that instances only get allocated once
      let parentScope = this.scope;
      // Every function references itself through arguments, prevent the recursive double-visit
      if (this.scope !== val && this.commonScope !== val) this._withScope(this.commonScope, () => {
        (0, _invariant2.default)(val instanceof _index2.FunctionValue);
        if (this.preProcessValue(val)) this.visitValueFunction(val, parentScope);
      });
    } else if (val instanceof _index2.SymbolValue) {
      if (this.preProcessValue(val)) this.visitValueSymbol(val);
    } else {
      (0, _invariant2.default)(val instanceof _index2.ObjectValue);

      // Prototypes are reachable via function declarations, and those get hoisted, so we need to move
      // prototype initialization to the common scope code as well.
      if (val.originalConstructor !== undefined) {
        this._withScope(this.commonScope, () => {
          (0, _invariant2.default)(val instanceof _index2.ObjectValue);
          if (this.preProcessValue(val)) this.visitValueObject(val);
        });
      } else {
        if (this.preProcessValue(val)) this.visitValueObject(val);
      }
    }
    this.postProcessValue(val);
  }

  createGeneratorVisitCallbacks(commonScope) {
    return {
      visitValues: values => {
        for (let i = 0, n = values.length; i < n; i++) values[i] = this.visitEquivalentValue(values[i]);
      },
      visitGenerator: (generator, parent) => {
        // TODO: The serializer assumes that each generator has a unique parent; however, in the presence of conditional exceptions that is not actually true.
        // invariant(!this.generatorParents.has(generator));
        this.generatorParents.set(generator, parent);
        this.visitGenerator(generator);
      },
      canSkip: value => {
        return !this.referencedDeclaredValues.has(value) && !this.values.has(value);
      },
      recordDeclaration: value => {
        this.referencedDeclaredValues.set(value, this.containingAdditionalFunction);
      },
      recordDelayedEntry: (generator, entry) => {
        this.delayedVisitGeneratorEntries.push({ commonScope, generator, entry });
      }
    };
  }

  visitGenerator(generator) {
    this._withScope(generator, () => {
      generator.visit(this.createGeneratorVisitCallbacks(this.commonScope));
    });
  }

  // result -- serialized as a return statement
  // Generator -- visit all entries
  // Bindings -- (modifications to named variables) only need to serialize bindings if they're
  //             captured by a residual function
  //          -- need to apply them and maybe need to revisit functions in ancestors to make sure
  //             we don't overwrite anything they capture
  // PropertyBindings -- (property modifications) visit any property bindings to pre-existing objects
  // CreatedObjects -- should take care of itself
  _visitEffects(additionalFunctionInfo, effects) {
    let functionValue = additionalFunctionInfo.functionValue;
    (0, _invariant2.default)(functionValue instanceof _index2.ECMAScriptSourceFunctionValue);
    let code = functionValue.$ECMAScriptCode;
    let functionInfo = this.functionInfos.get(code);
    (0, _invariant2.default)(functionInfo !== undefined);
    let [result,, modifiedBindings, modifiedProperties, createdObjects] = effects;
    for (let propertyBinding of modifiedProperties.keys()) {
      let object = propertyBinding.object;
      if (object instanceof _index2.ObjectValue && createdObjects.has(object)) continue; // Created Object's binding
      if (object.refuseSerialization) continue; // modification to internal state
      if (object.intrinsicName === "global") continue; // Avoid double-counting
      this.visitObjectProperty(propertyBinding);
    }
    // Handing of ModifiedBindings
    for (let [additionalBinding, previousValue] of modifiedBindings) {
      let modifiedBinding = additionalBinding;
      let residualBinding;
      this._withScope(functionValue, () => {
        // Also visit the original value of the binding
        residualBinding = this.visitBinding(functionValue, modifiedBinding.name);
        (0, _invariant2.default)(residualBinding !== undefined);
        // named functions inside an additional function that have a global binding
        // can be skipped, as we don't want them to bind to the global
        if (residualBinding.declarativeEnvironmentRecord === null && modifiedBinding.value instanceof _index2.ECMAScriptSourceFunctionValue) {
          residualBinding = null;
          return;
        }
        // Fixup the binding to have the correct value
        // No previousValue means this is a binding for a nested function
        if (previousValue && previousValue.value) residualBinding.value = this.visitEquivalentValue(previousValue.value);
        (0, _invariant2.default)(functionInfo !== undefined);
        if (functionInfo.modified.has(modifiedBinding.name)) residualBinding.modified;
      });
      if (residualBinding === null) continue;
      (0, _invariant2.default)(residualBinding);
      let funcInstance = additionalFunctionInfo.instance;
      (0, _invariant2.default)(funcInstance !== undefined);
      funcInstance.residualFunctionBindings.set(modifiedBinding.name, residualBinding);
      let newValue = modifiedBinding.value;
      (0, _invariant2.default)(newValue);
      this.visitValue(newValue);
      residualBinding.modified = true;
      // This should be enforced by checkThatFunctionsAreIndependent
      (0, _invariant2.default)(!residualBinding.additionalFunctionOverridesValue, "We should only have one additional function value modifying any given residual binding");
      if (previousValue && previousValue.value) residualBinding.additionalFunctionOverridesValue = functionValue;
      additionalFunctionInfo.modifiedBindings.set(modifiedBinding, residualBinding);
    }
    (0, _invariant2.default)(result instanceof _index2.Value);
    if (!(result instanceof _index2.UndefinedValue)) this.visitValue(result);
  }

  _visitAdditionalFunction(functionValue, additionalEffects, parentScope) {
    // Get Instance + Info
    (0, _invariant2.default)(functionValue instanceof _index2.ECMAScriptSourceFunctionValue);
    let code = functionValue.$ECMAScriptCode;
    let functionInfo = this.functionInfos.get(code);
    (0, _invariant2.default)(functionInfo !== undefined);
    let funcInstance = this.functionInstances.get(functionValue);
    (0, _invariant2.default)(funcInstance !== undefined);

    // Set Visitor state
    // Allows us to emit function declarations etc. inside of this additional
    // function instead of adding them at global scope
    let prevCommonScope = this.commonScope;
    this.commonScope = functionValue;
    let oldReactElementEquivalenceSet = this.reactElementEquivalenceSet;
    this.reactElementEquivalenceSet = new _ReactElementSet2.default(this.realm, this.equivalenceSet);
    let oldcontainingAdditionalFunction = this.containingAdditionalFunction;
    this.containingAdditionalFunction = functionValue;
    let prevReVisit = this.additionalRoots;
    this.additionalRoots = new Map();

    let modifiedBindingInfo = new Map();
    let [, generator,,, createdObjects] = additionalEffects.effects;

    (0, _invariant2.default)(funcInstance !== undefined);
    (0, _invariant2.default)(functionInfo !== undefined);
    let additionalFunctionInfo = {
      functionValue,
      captures: functionInfo.unbound,
      modifiedBindings: modifiedBindingInfo,
      instance: funcInstance
    };
    this.additionalFunctionValueInfos.set(functionValue, additionalFunctionInfo);

    this.realm.withEffectsAppliedInGlobalEnv(effects => {
      this.visitGenerator(generator);
      // All modified properties and bindings should be accessible
      // from its containing additional function scope.
      this._withScope(functionValue, this._visitEffects.bind(this, additionalFunctionInfo, effects));
      return this.realm.intrinsics.undefined;
    }, additionalEffects.effects);
    for (let createdObject of createdObjects) this.additionalRoots.delete(createdObject);

    // Cleanup
    this.commonScope = prevCommonScope;
    this.reactElementEquivalenceSet = oldReactElementEquivalenceSet;
    this._withScope(parentScope,
    // Re-visit any bindings corresponding to unbound values or values closed over from outside additional function
    // they're serialized in the correct scope
    () => {
      (0, _invariant2.default)(functionInfo !== undefined);
      (0, _invariant2.default)(funcInstance !== undefined);
      for (let [value, additionalParentGenerators] of this.additionalRoots) {
        // Populate old additionalRoots because we switched them out
        prevReVisit.set(value, additionalParentGenerators);
        this.visitValue(value);
      }
      for (let innerName of functionInfo.unbound) {
        let residualBinding = this.visitBinding(functionValue, innerName, false);
        if (residualBinding) {
          funcInstance.residualFunctionBindings.set(innerName, residualBinding);
          delete residualBinding.referencedOnlyFromAdditionalFunctions;
        }
      }
      this.additionalRoots = prevReVisit;
    });
    this.containingAdditionalFunction = oldcontainingAdditionalFunction;
  }

  visitRoots() {
    let generator = this.realm.generator;
    (0, _invariant2.default)(generator);
    this.visitGenerator(generator);
    for (let moduleValue of this.modules.initializedModules.values()) this.visitValue(moduleValue);
    if (this.realm.react.enabled && this.someReactElement !== undefined) {
      this._visitReactLibrary(this.someReactElement);
    }

    // Do a fixpoint over all pure generator entries to make sure that we visit
    // arguments of only BodyEntries that are required by some other residual value
    let oldDelayedEntries = [];
    while (oldDelayedEntries.length !== this.delayedVisitGeneratorEntries.length) {
      oldDelayedEntries = this.delayedVisitGeneratorEntries;
      this.delayedVisitGeneratorEntries = [];
      for (let _ref of oldDelayedEntries) {
        let { commonScope, generator: entryGenerator, entry } = _ref;

        this.commonScope = commonScope;
        this._withScope(entryGenerator, () => {
          entryGenerator.visitEntry(entry, this.createGeneratorVisitCallbacks(commonScope));
        });
      }
    }

    let referentializer = this.referentializer;
    if (referentializer !== undefined) {
      let bodyToInstances = new Map();
      for (let instance of this.functionInstances.values()) {
        // TODO: do something for additional functions
        if (!this.additionalFunctionValuesAndEffects.has(instance.functionValue)) {
          let code = instance.functionValue.$ECMAScriptCode;
          (0, _invariant2.default)(code !== undefined);
          (0, _utils.getOrDefault)(bodyToInstances, code, () => []).push(instance);
        }
      }

      for (let [funcBody, instances] of bodyToInstances) {
        let functionInfo = this.functionInfos.get(funcBody);
        (0, _invariant2.default)(functionInfo !== undefined);
        referentializer.referentialize(functionInfo.unbound, instances, instance => !this.additionalFunctionValuesAndEffects.has(instance.functionValue));
      }
    }
  }

  _visitReactLibrary(someReactElement) {
    // find and visit the React library
    let reactLibraryObject = this.realm.fbLibraries.react;
    if (this.realm.react.output === "jsx") {
      // React might not be defined in scope, i.e. another library is using JSX
      // we don't throw an error as we should support JSX stand-alone
      if (reactLibraryObject !== undefined) {
        this.visitValue(reactLibraryObject);
      }
    } else if (this.realm.react.output === "create-element") {
      let logError = () => {
        this.logger.logError(someReactElement, "unable to visit createElement due to React not being referenced in scope");
      };
      // createElement output needs React in scope
      if (reactLibraryObject === undefined) {
        logError();
      } else {
        (0, _invariant2.default)(reactLibraryObject instanceof _index2.ObjectValue);
        let createElement = reactLibraryObject.properties.get("createElement");
        if (createElement === undefined || createElement.descriptor === undefined) {
          logError();
        } else {
          let reactCreateElement = (0, _index.Get)(this.realm, reactLibraryObject, "createElement");
          this.visitValue(reactCreateElement);
        }
      }
    }
  }
}
exports.ResidualHeapVisitor = ResidualHeapVisitor;

/***/ }),
/* 118 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResidualHeapInspector = undefined;

var _realm = __webpack_require__(7);

var _index = __webpack_require__(5);

var _index2 = __webpack_require__(0);

var _invariant = __webpack_require__(1);

var _invariant2 = _interopRequireDefault(_invariant);

var _logger = __webpack_require__(44);

var _utils = __webpack_require__(18);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 */

class ResidualHeapInspector {
  constructor(realm, logger) {
    this.realm = realm;
    this.logger = logger;
    this.ignoredProperties = new Map();
    this._targetIntegrityCommands = new Map();
  }

  getTargetIntegrityCommand(val) {
    let command = this._targetIntegrityCommands.get(val);
    if (command === undefined) {
      command = "";
      if (val instanceof _index2.ProxyValue) {
        // proxies don't participate in regular object freezing/sealing,
        // only their underlying proxied objects do
      } else {
        let extensible = val.$Extensible;
        if (!(extensible instanceof _index2.BooleanValue)) {
          this.logger.logError(val, "Object that might or might not be sealed or frozen are not supported in residual heap.");
        } else if (!extensible.value) {
          let anyWritable = false,
              anyConfigurable = false;
          for (let propertyBinding of val.properties.values()) {
            let desc = propertyBinding.descriptor;
            if (desc === undefined) continue; //deleted
            if (desc.configurable) anyConfigurable = true;else if (desc.value !== undefined && desc.writable) anyWritable = true;
          }
          command = anyConfigurable ? "preventExtensions" : anyWritable ? "seal" : "freeze";
        }
      }
      this._targetIntegrityCommands.set(val, command);
    }
    return command;
  }

  getTargetIntegrityDescriptor(val) {
    return ResidualHeapInspector._integrityDescriptors[this.getTargetIntegrityCommand(val)];
  }

  static isLeaf(val) {
    if (val instanceof _index2.SymbolValue) {
      return false;
    }

    if (val instanceof _index2.AbstractValue && val.hasIdentifier()) {
      return true;
    }

    if (val.isIntrinsic()) {
      return false;
    }

    return val instanceof _index2.PrimitiveValue;
  }

  // Object properties which have the default value can be ignored by the serializer.
  canIgnoreProperty(val, key) {
    let set = this.ignoredProperties.get(val);
    if (!set) {
      this.ignoredProperties.set(val, set = this._getIgnoredProperties(val));
    }
    return set.has(key);
  }

  _getIgnoredProperties(val) {
    let set = new Set();
    for (let [key, propertyBinding] of val.properties) {
      (0, _invariant2.default)(propertyBinding);
      let desc = propertyBinding.descriptor;
      if (desc === undefined) continue; //deleted
      if (this._canIgnoreProperty(val, key, desc)) set.add(key);
    }
    return set;
  }

  _canIgnoreProperty(val, key, desc) {
    let targetDescriptor = this.getTargetIntegrityDescriptor(val);

    if ((0, _index.IsArray)(this.realm, val)) {
      if (key === "length" && desc.writable === targetDescriptor.writable && !desc.enumerable && !desc.configurable) {
        // length property has the correct descriptor values
        return true;
      }
    } else if ((0, _utils.isReactElement)(val)) {
      // we don't want to visit/serialize $$typeof, _owner and _store properties
      // as these are all internals of JSX/createElement
      if (key === "$$typeof" || key === "_owner" || key === "_store") {
        return true;
      }
      if ((key === "ref" || key === "key") && desc.value === this.realm.intrinsics.null) {
        return true;
      }
    } else if (val instanceof _index2.FunctionValue) {
      if (key === "length") {
        if (desc.value === undefined) {
          this.logger.logError(val, "Functions with length accessor properties are not supported in residual heap.");
          // Rationale: .bind() would call the accessor, which might throw, mutate state, or do whatever...
        }
        // length property will be inferred already by the amount of parameters
        return !desc.writable && !desc.enumerable && desc.configurable === targetDescriptor.configurable && val.hasDefaultLength();
      }

      if (key === "name") {
        // TODO #474: Make sure that we retain original function names. Or set name property.
        // Or ensure that nothing references the name property.
        // NOTE: with some old runtimes notably JSC, function names are not configurable
        // For now don't ignore the property if it is different from the function name.
        // I.e. if it was set explicitly in the code, retain it.
        if (desc.value !== undefined && !this.realm.isCompatibleWith(this.realm.MOBILE_JSC_VERSION) && !this.realm.isCompatibleWith("mobile") && (desc.value instanceof _index2.AbstractValue || val.__originalName && val.__originalName !== "" && desc.value.value !== val.__originalName)) return false;
        return true;
      }

      // Properties `caller` and `arguments` are added to normal functions in non-strict mode to prevent TypeErrors.
      // Because they are autogenerated, they should be ignored.
      if (key === "arguments" || key === "caller") {
        (0, _invariant2.default)(val instanceof _index2.ECMAScriptSourceFunctionValue);
        if (!val.$Strict && desc.writable === (!val.$Strict && targetDescriptor.writable) && !desc.enumerable && desc.configurable === targetDescriptor.configurable && desc.value instanceof _index2.UndefinedValue && val.$FunctionKind === "normal") return true;
      }

      // ignore the `prototype` property when it's the right one
      if (key === "prototype") {
        if (!desc.configurable && !desc.enumerable && desc.writable === targetDescriptor.writable && desc.value instanceof _index2.ObjectValue && desc.value.originalConstructor === val) {
          return true;
        }
      }
    } else {
      let kind = val.getKind();
      switch (kind) {
        case "RegExp":
          if (key === "lastIndex" && desc.writable === targetDescriptor.writable && !desc.enumerable && !desc.configurable) {
            // length property has the correct descriptor values
            let v = desc.value;
            return v instanceof _index2.NumberValue && v.value === 0;
          }
          break;
        default:
          break;
      }
    }

    if (key === "constructor") {
      if (desc.configurable === targetDescriptor.configurable && !desc.enumerable && desc.writable === targetDescriptor.writable && desc.value === val.originalConstructor) return true;
    }

    return false;
  }

  static getPropertyValue(val, name) {
    let prototypeBinding = val.properties.get(name);
    if (prototypeBinding === undefined) return undefined;
    let prototypeDesc = prototypeBinding.descriptor;
    if (prototypeDesc === undefined) return undefined;
    (0, _invariant2.default)(prototypeDesc.value === undefined || prototypeDesc.value instanceof _index2.Value);
    return prototypeDesc.value;
  }

  isDefaultPrototype(prototype) {
    if (prototype.symbols.size !== 0 || prototype.$Prototype !== this.realm.intrinsics.ObjectPrototype || prototype.$Extensible.mightNotBeTrue()) {
      return false;
    }
    let foundConstructor = false;
    for (let name of prototype.properties.keys()) if (name === "constructor" && ResidualHeapInspector.getPropertyValue(prototype, name) === prototype.originalConstructor) foundConstructor = true;else return false;
    return foundConstructor;
  }
}
exports.ResidualHeapInspector = ResidualHeapInspector;
ResidualHeapInspector._integrityDescriptors = {
  "": { writable: true, configurable: true },
  preventExtensions: { writable: true, configurable: true },
  seal: { writable: true, configurable: false },
  freeze: { writable: false, configurable: false }
};

/***/ }),
/* 119 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ClassPropertiesToIgnore = undefined;
exports.getSuggestedArrayLiteralLength = getSuggestedArrayLiteralLength;
exports.commonAncestorOf = commonAncestorOf;
exports.getOrDefault = getOrDefault;
exports.withDescriptorValue = withDescriptorValue;
exports.canIgnoreClassLengthProperty = canIgnoreClassLengthProperty;
exports.getObjectPrototypeMetadata = getObjectPrototypeMetadata;

var _index = __webpack_require__(0);

var _errors = __webpack_require__(6);

var _invariant = __webpack_require__(1);

var _invariant2 = _interopRequireDefault(_invariant);

var _index2 = __webpack_require__(5);

var _logger = __webpack_require__(44);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Get index property list length by searching array properties list for the max index key value plus 1.
 */
function getSuggestedArrayLiteralLength(realm, val) {
  (0, _invariant2.default)((0, _index2.IsArray)(realm, val));

  let length = 0;
  for (const key of val.properties.keys()) {
    if ((0, _index2.IsArrayIndex)(realm, key) && Number(key) >= length) {
      length = Number(key) + 1;
    }
  }
  return length;
} /**
   * Copyright (c) 2017-present, Facebook, Inc.
   * All rights reserved.
   *
   * This source code is licensed under the BSD-style license found in the
   * LICENSE file in the root directory of this source tree. An additional grant
   * of patent rights can be found in the PATENTS file in the same directory.
   */

function commonAncestorOf(node1, node2, getParent) {
  if (node1 === node2) return node1;
  // First get the path length to the root node for both nodes while also checking if
  // either node is the parent of the other.
  let n1 = node1,
      n2 = node2,
      count1 = 0,
      count2 = 0;
  while (true) {
    let p1 = n1 && getParent(n1);
    let p2 = n2 && getParent(n2);
    if (p1 === node2) return node2;
    if (p2 === node1) return node1;
    if (p1) count1++;
    if (p2) count2++;
    if (!p1 && !p2) break;
    n1 = p1;
    n2 = p2;
  }
  // Now shorten the longest path to the same length as the shorter path
  n1 = node1;
  while (count1 > count2) {
    (0, _invariant2.default)(n1 !== undefined);
    n1 = getParent(n1);
    count1--;
  }
  n2 = node2;
  while (count1 < count2) {
    (0, _invariant2.default)(n2 !== undefined);
    n2 = getParent(n2);
    count2--;
  }
  // Now run up both paths in tandem, stopping at the first common entry
  while (n1 !== n2) {
    (0, _invariant2.default)(n1 !== undefined);
    n1 = getParent(n1);
    (0, _invariant2.default)(n2 !== undefined);
    n2 = getParent(n2);
  }
  return n1;
}

// Gets map[key] with default value provided by defaultFn
function getOrDefault(map, key, defaultFn) {
  let value = map.get(key);
  if (value === undefined) map.set(key, value = defaultFn());
  (0, _invariant2.default)(value !== undefined);
  return value;
}

function withDescriptorValue(propertyNameOrSymbol, descriptor, func) {
  if (descriptor !== undefined) {
    if (descriptor.value !== undefined) {
      func(propertyNameOrSymbol, descriptor.value, "value");
    } else {
      if (descriptor.get !== undefined) {
        func(propertyNameOrSymbol, descriptor.get, "get");
      }
      if (descriptor.set !== undefined) {
        func(propertyNameOrSymbol, descriptor.set, "set");
      }
    }
  }
}

const ClassPropertiesToIgnore = exports.ClassPropertiesToIgnore = new Set(["arguments", "name", "caller"]);

function canIgnoreClassLengthProperty(val, desc, logger) {
  if (desc && desc.value === undefined) {
    logger.logError(val, "Functions with length accessor properties are not supported in residual heap.");
  }
  return true;
}

function getObjectPrototypeMetadata(realm, obj) {
  let proto = obj.$Prototype;
  let skipPrototype = false;
  let constructor;

  if (obj.$IsClassPrototype) {
    skipPrototype = true;
  }
  if (proto.$IsClassPrototype) {
    (0, _invariant2.default)(proto instanceof _index.ObjectValue);
    // we now need to check if the prototpe has a constructor
    if (proto.properties.has("constructor")) {
      let _constructor = proto.properties.get("constructor");
      (0, _invariant2.default)(_constructor !== undefined);
      // if the contructor has been deleted then we have no way
      // to serialize the original class AST as it won't have been
      // evluated and thus visited
      if (_constructor.descriptor === undefined) {
        throw new _errors.FatalError("TODO #1024: implement object prototype serialization with deleted constructor");
      }
      let classFunc = (0, _index2.Get)(realm, proto, "constructor");
      constructor = classFunc;
      (0, _invariant2.default)(constructor instanceof _index.ECMAScriptSourceFunctionValue);
      skipPrototype = true;
    }
  }

  return {
    skipPrototype,
    constructor
  };
}

/***/ }),
/* 120 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InternalGetResultValue = InternalGetResultValue;
exports.LoopContinues = LoopContinues;
exports.ForInOfHeadEvaluation = ForInOfHeadEvaluation;
exports.ForInOfBodyEvaluation = ForInOfBodyEvaluation;

exports.default = function (ast, strictCode, env, realm, labelSet) {
  let { left, right, body } = ast;

  try {
    if (left.type === "VariableDeclaration") {
      if (left.kind === "var") {
        // for (var ForBinding o fAssignmentExpression) Statement
        // 1. Let keyResult be the result of performing ? ForIn/OfHeadEvaluation(« », AssignmentExpression, iterate).
        let keyResult = ForInOfHeadEvaluation(realm, env, [], right, "iterate", strictCode);
        (0, _invariant2.default)(keyResult instanceof _index.ObjectValue);

        // 2. Return ? ForIn/OfBodyEvaluation(ForBinding, Statement, keyResult, varBinding, labelSet).
        return ForInOfBodyEvaluation(realm, env, left.declarations[0].id, body, keyResult, "varBinding", labelSet, strictCode);
      } else {
        // for (ForDeclaration of AssignmentExpression) Statement
        // 1. Let keyResult be the result of performing ? ForIn/OfHeadEvaluation(BoundNames of ForDeclaration, AssignmentExpression, iterate).
        let keyResult = ForInOfHeadEvaluation(realm, env, _singletons.Environment.BoundNames(realm, left), right, "iterate", strictCode);
        (0, _invariant2.default)(keyResult instanceof _index.ObjectValue);

        // 2. Return ? ForIn/OfBodyEvaluation(ForDeclaration, Statement, keyResult, lexicalBinding, labelSet).
        return ForInOfBodyEvaluation(realm, env, left, body, keyResult, "lexicalBinding", labelSet, strictCode);
      }
    } else {
      // for (LeftHandSideExpression of AssignmentExpression) Statement
      // 1. Let keyResult be the result of performing ? ForIn/OfHeadEvaluation(« », AssignmentExpression, iterate).
      let keyResult = ForInOfHeadEvaluation(realm, env, [], right, "iterate", strictCode);
      (0, _invariant2.default)(keyResult instanceof _index.ObjectValue);

      // 2. Return ? ForIn/OfBodyEvaluation(LeftHandSideExpression, Statement, keyResult, assignment, labelSet).
      return ForInOfBodyEvaluation(realm, env, left, body, keyResult, "assignment", labelSet, strictCode);
    }
  } catch (e) {
    if (e instanceof _completions.BreakCompletion) {
      if (!e.target) return (0, _index2.UpdateEmpty)(realm, e, realm.intrinsics.undefined).value;
    }
    throw e;
  }
};

var _errors = __webpack_require__(6);

var _environment = __webpack_require__(8);

var _completions = __webpack_require__(3);

var _index = __webpack_require__(0);

var _invariant = __webpack_require__(1);

var _invariant2 = _interopRequireDefault(_invariant);

var _index2 = __webpack_require__(5);

var _singletons = __webpack_require__(2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 */

function InternalGetResultValue(realm, result) {
  if (result instanceof _completions.AbruptCompletion) {
    return result.value;
  } else {
    return result;
  }
}

// ECMA262 13.7.1.2
function LoopContinues(realm, completion, labelSet) {
  // 1. If completion.[[Type]] is normal, return true.
  if (completion instanceof _index.Value) return true;
  (0, _invariant2.default)(completion instanceof _completions.AbruptCompletion);

  // 2. If completion.[[Type]] is not continue, return false.
  if (!(completion instanceof _completions.ContinueCompletion)) return false;

  // 3. If completion.[[Target]] is empty, return true.
  if (!completion.target) return true;

  // 4. If completion.[[Target]] is an element of labelSet, return true.
  if (labelSet != null && labelSet.indexOf(completion.target) >= 0) return true;

  // 5. Return false.
  return false;
}

// ECMA262 13.7.5.10
function BindingInstantiation(realm, ast, env) {
  // ast = ForDeclaration : LetOrConst ForBinding

  // 1. Let envRec be environment's EnvironmentRecord.
  let envRec = env.environmentRecord;

  // 2. Assert: envRec is a declarative Environment Record.
  (0, _invariant2.default)(envRec instanceof _environment.DeclarativeEnvironmentRecord);

  // 3. For each element name of the BoundNames of ForBinding do
  for (let name of _singletons.Environment.BoundNames(realm, ast)) {
    // a. If IsConstantDeclaration of LetOrConst is true, then
    if (ast.kind === "const") {
      // i. Perform ! envRec.CreateImmutableBinding(name, true).
      envRec.CreateImmutableBinding(name, true);
    } else {
      // b.
      // i. Perform ! envRec.CreateMutableBinding(name, false).
      envRec.CreateMutableBinding(name, false);
    }
  }
}

// ECMA262 13.7.5.12
function ForInOfHeadEvaluation(realm, env, TDZnames, expr, iterationKind, strictCode) {
  // 1. Let oldEnv be the running execution context's LexicalEnvironment.
  let oldEnv = realm.getRunningContext().lexicalEnvironment;

  // 2. If TDZnames is not an empty List, then
  if (TDZnames.length) {
    // a. Assert: TDZnames has no duplicate entries.

    // b. Let TDZ be NewDeclarativeEnvironment(oldEnv).
    let TDZ = _singletons.Environment.NewDeclarativeEnvironment(realm, oldEnv);

    // c. Let TDZEnvRec be TDZ's EnvironmentRecord.
    let TDZEnvRec = TDZ.environmentRecord;

    // d. For each string name in TDZnames, do
    for (let name of TDZnames) {
      // i. Perform ! TDZEnvRec.CreateMutableBinding(name, false).
      TDZEnvRec.CreateMutableBinding(name, false);
    }

    // e. Set the running execution context's LexicalEnvironment to TDZ.
    realm.getRunningContext().lexicalEnvironment = TDZ;
    env = TDZ;
  }

  let exprRef;
  try {
    // 3. Let exprRef be the result of evaluating expr.
    exprRef = env.evaluate(expr, strictCode);
  } finally {
    // 4. Set the running execution context's LexicalEnvironment to oldEnv.
    let lexEnv = realm.getRunningContext().lexicalEnvironment;
    if (lexEnv !== oldEnv) realm.onDestroyScope(lexEnv);
    realm.getRunningContext().lexicalEnvironment = oldEnv;
  }
  env = oldEnv;

  // 5. Let exprValue be ? GetValue(exprRef).
  let exprValue = _singletons.Environment.GetValue(realm, exprRef);

  // 6. If iterationKind is enumerate, then
  if (iterationKind === "enumerate") {
    // a. If exprValue.[[Value]] is null or undefined, then
    if (exprValue instanceof _index.NullValue || exprValue instanceof _index.UndefinedValue) {
      // i. Return Completion{[[Type]]: break, [[Value]]: empty, [[Target]]: empty}.
      throw new _completions.BreakCompletion(realm.intrinsics.empty, expr.loc, undefined);
    }

    // b. Let obj be ToObject(exprValue).
    let obj = _singletons.To.ToObjectPartial(realm, exprValue);

    // c. Return ? EnumerateObjectProperties(obj).
    if (obj.isPartialObject() || obj instanceof _index.AbstractObjectValue) {
      return obj;
    } else {
      return _singletons.Properties.EnumerateObjectProperties(realm, obj);
    }
  } else {
    // 8. Else,
    // 1. Assert: iterationKind is iterate.
    (0, _invariant2.default)(iterationKind === "iterate", "expected iterationKind to be iterate");

    if (exprValue instanceof _index.AbstractValue) {
      let error = new _errors.CompilerDiagnostic("for of loops over unknown collections are not yet supported", expr.loc, "PP0014", "FatalError");
      realm.handleError(error);
      throw new _errors.FatalError();
    }

    // 1. Return ? GetIterator(exprValue).
    return (0, _index2.GetIterator)(realm, exprValue);
  }
}

// ECMA262 13.7.5.13
function ForInOfBodyEvaluation(realm, env, lhs, stmt, iterator, lhsKind, labelSet, strictCode) {
  // 1. Let oldEnv be the running execution context's LexicalEnvironment.
  let oldEnv = realm.getRunningContext().lexicalEnvironment;

  // 2. Let V be undefined.
  let V = realm.intrinsics.undefined;

  // 3. Let destructuring be IsDestructuring of lhs.
  let destructuring = _singletons.Environment.IsDestructuring(lhs);

  // 4. If destructuring is true and if lhsKind is assignment, then
  if (destructuring && lhsKind === "assignment") {
    // a. Assert: lhs is a LeftHandSideExpression.
    (0, _invariant2.default)(lhs.type !== "VariableDeclaration");

    // b. Let assignmentPattern be the parse of the source text corresponding to lhs using AssignmentPattern as the goal symbol.
  }

  // 5. Repeat
  while (true) {
    // a. Let nextResult be ? IteratorStep(iterator).
    let nextResult = (0, _index2.IteratorStep)(realm, iterator);

    // b. If nextResult is false, return NormalCompletion(V).
    if (!nextResult) return V;

    // c. Let nextValue be ? IteratorValue(nextResult).
    let nextValue = (0, _index2.IteratorValue)(realm, nextResult);

    // d. If lhsKind is either assignment or varBinding, then
    let iterationEnv;
    let lhsRef;
    if (lhsKind === "assignment" || lhsKind === "varBinding") {
      // i. If destructuring is false, then
      if (!destructuring) {
        // 1. Let lhsRef be the result of evaluating lhs. (It may be evaluated repeatedly.)
        lhsRef = env.evaluateCompletion(lhs, strictCode);
      }
    } else {
      // e. Else,
      // i. Assert: lhsKind is lexicalBinding.
      (0, _invariant2.default)(lhsKind === "lexicalBinding", "expected lhsKind to be lexicalBinding");
      (0, _invariant2.default)(lhs.type === "VariableDeclaration");

      // ii. Assert: lhs is a ForDeclaration.

      // iii. Let iterationEnv be NewDeclarativeEnvironment(oldEnv).
      iterationEnv = _singletons.Environment.NewDeclarativeEnvironment(realm, oldEnv);

      // iv. Perform BindingInstantiation for lhs passing iterationEnv as the argument.
      BindingInstantiation(realm, lhs, iterationEnv);

      // v. Set the running execution context's LexicalEnvironment to iterationEnv.
      realm.getRunningContext().lexicalEnvironment = iterationEnv;
      env = iterationEnv;

      // vi. If destructuring is false, then
      if (!destructuring) {
        let names = _singletons.Environment.BoundNames(realm, lhs);

        // 1. Assert: lhs binds a single name.
        (0, _invariant2.default)(names.length === 1, "expected single name");

        // 2. Let lhsName be the sole element of BoundNames of lhs.
        let lhsName = names[0];

        // 3. Let lhsRef be ! ResolveBinding(lhsName).
        lhsRef = _singletons.Environment.ResolveBinding(realm, lhsName, strictCode);
      }
    }

    // f. If destructuring is false, then
    let status;
    try {
      if (!destructuring) {
        // i. If lhsRef is an abrupt completion, then
        if (lhsRef instanceof _completions.AbruptCompletion) {
          // 1. Let status be lhsRef.
          status = lhsRef;
        } else if (lhsKind === "lexicalBinding") {
          // ii. Else if lhsKind is lexicalBinding, then
          // 1. Let status be InitializeReferencedBinding(lhsRef, nextValue).
          (0, _invariant2.default)(lhsRef instanceof _environment.Reference);
          status = _singletons.Environment.InitializeReferencedBinding(realm, lhsRef, nextValue);
        } else {
          // iii. Else,
          // 1. Let status be PutValue(lhsRef, nextValue).
          (0, _invariant2.default)(lhsRef !== undefined);
          status = _singletons.Properties.PutValue(realm, lhsRef, nextValue);
        }
      } else {
        // g. Else,
        // i. If lhsKind is assignment, then
        if (lhsKind === "assignment") {
          (0, _invariant2.default)(lhs.type === "ArrayPattern" || lhs.type === "ObjectPattern");

          // 1. Let status be the result of performing DestructuringAssignmentEvaluation of assignmentPattern using nextValue as the argument.
          status = (0, _index2.DestructuringAssignmentEvaluation)(realm, lhs, nextValue, strictCode, iterationEnv || env);
        } else if (lhsKind === "varBinding") {
          // ii. Else if lhsKind is varBinding, then
          // 1. Assert: lhs is a ForBinding.

          // 2. Let status be the result of performing BindingInitialization for lhs passing nextValue and undefined as the arguments.
          status = _singletons.Environment.BindingInitialization(realm, lhs, nextValue, strictCode, undefined);
        } else {
          // iii. Else,
          // 1. Assert: lhsKind is lexicalBinding.
          (0, _invariant2.default)(lhsKind === "lexicalBinding");

          // 2. Assert: lhs is a ForDeclaration.

          // 3. Let status be the result of performing BindingInitialization for lhs passing nextValue and iterationEnv as arguments.
          (0, _invariant2.default)(iterationEnv !== undefined);
          status = _singletons.Environment.BindingInitialization(realm, lhs, nextValue, strictCode, iterationEnv);
        }
      }
    } catch (e) {
      if (e instanceof _completions.AbruptCompletion) {
        status = e;
      } else {
        throw e;
      }
    }

    // h. If status is an abrupt completion, then
    if (status instanceof _completions.AbruptCompletion) {
      // i. Set the running execution context's LexicalEnvironment to oldEnv.
      realm.getRunningContext().lexicalEnvironment = oldEnv;

      // ii. Return ? IteratorClose(iterator, status).
      throw (0, _index2.IteratorClose)(realm, iterator, status);
    }

    // i. Let result be the result of evaluating stmt.
    let result = env.evaluateCompletion(stmt, strictCode);
    (0, _invariant2.default)(result instanceof _index.Value || result instanceof _completions.AbruptCompletion);

    // j. Set the running execution context's LexicalEnvironment to oldEnv.

    let lexEnv = realm.getRunningContext().lexicalEnvironment;
    if (lexEnv !== oldEnv) realm.onDestroyScope(lexEnv);
    realm.getRunningContext().lexicalEnvironment = oldEnv;
    env = oldEnv;

    // k. If LoopContinues(result, labelSet) is false, return ? IteratorClose(iterator, UpdateEmpty(result, V)).
    if (!LoopContinues(realm, result, labelSet)) {
      (0, _invariant2.default)(result instanceof _completions.AbruptCompletion);
      result = (0, _index2.UpdateEmpty)(realm, result, V);
      (0, _invariant2.default)(result instanceof _completions.AbruptCompletion);
      throw (0, _index2.IteratorClose)(realm, iterator, result);
    }

    // l. If result.[[Value]] is not empty, let V be result.[[Value]].
    let resultValue = InternalGetResultValue(realm, result);
    if (!(resultValue instanceof _index.EmptyValue)) V = resultValue;
  }

  /* istanbul ignore next */
  (0, _invariant2.default)(false); // can't get here but there is no other way to make Flow happy
}

// ECMA262 13.7.5.11

/***/ }),
/* 121 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = invariant;
/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 */

function invariant(condition, format) {
  if (condition) return;

  let error = new Error(format);
  error.name = "Invariant Violation";
  throw error;
}

/***/ }),
/* 122 */
/***/ (function(module, exports, __webpack_require__) {

// This is (almost) directly from Node.js utils
// https://github.com/joyent/node/blob/f8c335d0caf47f16d31413f89aa28eda3878e3aa/lib/util.js

var getName = __webpack_require__(234);
var getProperties = __webpack_require__(235);
var getEnumerableProperties = __webpack_require__(428);
var config = __webpack_require__(72);

module.exports = inspect;

/**
 * ### .inspect(obj, [showHidden], [depth], [colors])
 *
 * Echoes the value of a value. Tries to print the value out
 * in the best way possible given the different types.
 *
 * @param {Object} obj The object to print out.
 * @param {Boolean} showHidden Flag that shows hidden (not enumerable)
 *    properties of objects. Default is false.
 * @param {Number} depth Depth in which to descend in object. Default is 2.
 * @param {Boolean} colors Flag to turn on ANSI escape codes to color the
 *    output. Default is false (no coloring).
 * @namespace Utils
 * @name inspect
 */
function inspect(obj, showHidden, depth, colors) {
  var ctx = {
    showHidden: showHidden,
    seen: [],
    stylize: function (str) { return str; }
  };
  return formatValue(ctx, obj, (typeof depth === 'undefined' ? 2 : depth));
}

// Returns true if object is a DOM element.
var isDOMElement = function (object) {
  if (typeof HTMLElement === 'object') {
    return object instanceof HTMLElement;
  } else {
    return object &&
      typeof object === 'object' &&
      'nodeType' in object &&
      object.nodeType === 1 &&
      typeof object.nodeName === 'string';
  }
};

function formatValue(ctx, value, recurseTimes) {
  // Provide a hook for user-specified inspect functions.
  // Check that value is an object with an inspect function on it
  if (value && typeof value.inspect === 'function' &&
      // Filter out the util module, it's inspect function is special
      value.inspect !== exports.inspect &&
      // Also filter out any prototype objects using the circular check.
      !(value.constructor && value.constructor.prototype === value)) {
    var ret = value.inspect(recurseTimes, ctx);
    if (typeof ret !== 'string') {
      ret = formatValue(ctx, ret, recurseTimes);
    }
    return ret;
  }

  // Primitive types cannot have properties
  var primitive = formatPrimitive(ctx, value);
  if (primitive) {
    return primitive;
  }

  // If this is a DOM element, try to get the outer HTML.
  if (isDOMElement(value)) {
    if ('outerHTML' in value) {
      return value.outerHTML;
      // This value does not have an outerHTML attribute,
      //   it could still be an XML element
    } else {
      // Attempt to serialize it
      try {
        if (document.xmlVersion) {
          var xmlSerializer = new XMLSerializer();
          return xmlSerializer.serializeToString(value);
        } else {
          // Firefox 11- do not support outerHTML
          //   It does, however, support innerHTML
          //   Use the following to render the element
          var ns = "http://www.w3.org/1999/xhtml";
          var container = document.createElementNS(ns, '_');

          container.appendChild(value.cloneNode(false));
          var html = container.innerHTML
            .replace('><', '>' + value.innerHTML + '<');
          container.innerHTML = '';
          return html;
        }
      } catch (err) {
        // This could be a non-native DOM implementation,
        //   continue with the normal flow:
        //   printing the element as if it is an object.
      }
    }
  }

  // Look up the keys of the object.
  var visibleKeys = getEnumerableProperties(value);
  var keys = ctx.showHidden ? getProperties(value) : visibleKeys;

  var name, nameSuffix;

  // Some type of object without properties can be shortcutted.
  // In IE, errors have a single `stack` property, or if they are vanilla `Error`,
  // a `stack` plus `description` property; ignore those for consistency.
  if (keys.length === 0 || (isError(value) && (
      (keys.length === 1 && keys[0] === 'stack') ||
      (keys.length === 2 && keys[0] === 'description' && keys[1] === 'stack')
     ))) {
    if (typeof value === 'function') {
      name = getName(value);
      nameSuffix = name ? ': ' + name : '';
      return ctx.stylize('[Function' + nameSuffix + ']', 'special');
    }
    if (isRegExp(value)) {
      return ctx.stylize(RegExp.prototype.toString.call(value), 'regexp');
    }
    if (isDate(value)) {
      return ctx.stylize(Date.prototype.toUTCString.call(value), 'date');
    }
    if (isError(value)) {
      return formatError(value);
    }
  }

  var base = ''
    , array = false
    , typedArray = false
    , braces = ['{', '}'];

  if (isTypedArray(value)) {
    typedArray = true;
    braces = ['[', ']'];
  }

  // Make Array say that they are Array
  if (isArray(value)) {
    array = true;
    braces = ['[', ']'];
  }

  // Make functions say that they are functions
  if (typeof value === 'function') {
    name = getName(value);
    nameSuffix = name ? ': ' + name : '';
    base = ' [Function' + nameSuffix + ']';
  }

  // Make RegExps say that they are RegExps
  if (isRegExp(value)) {
    base = ' ' + RegExp.prototype.toString.call(value);
  }

  // Make dates with properties first say the date
  if (isDate(value)) {
    base = ' ' + Date.prototype.toUTCString.call(value);
  }

  // Make error with message first say the error
  if (isError(value)) {
    return formatError(value);
  }

  if (keys.length === 0 && (!array || value.length == 0)) {
    return braces[0] + base + braces[1];
  }

  if (recurseTimes < 0) {
    if (isRegExp(value)) {
      return ctx.stylize(RegExp.prototype.toString.call(value), 'regexp');
    } else {
      return ctx.stylize('[Object]', 'special');
    }
  }

  ctx.seen.push(value);

  var output;
  if (array) {
    output = formatArray(ctx, value, recurseTimes, visibleKeys, keys);
  } else if (typedArray) {
    return formatTypedArray(value);
  } else {
    output = keys.map(function(key) {
      return formatProperty(ctx, value, recurseTimes, visibleKeys, key, array);
    });
  }

  ctx.seen.pop();

  return reduceToSingleString(output, base, braces);
}


function formatPrimitive(ctx, value) {
  switch (typeof value) {
    case 'undefined':
      return ctx.stylize('undefined', 'undefined');

    case 'string':
      var simple = '\'' + JSON.stringify(value).replace(/^"|"$/g, '')
                                               .replace(/'/g, "\\'")
                                               .replace(/\\"/g, '"') + '\'';
      return ctx.stylize(simple, 'string');

    case 'number':
      if (value === 0 && (1/value) === -Infinity) {
        return ctx.stylize('-0', 'number');
      }
      return ctx.stylize('' + value, 'number');

    case 'boolean':
      return ctx.stylize('' + value, 'boolean');

    case 'symbol':
      return ctx.stylize(value.toString(), 'symbol');
  }
  // For some reason typeof null is "object", so special case here.
  if (value === null) {
    return ctx.stylize('null', 'null');
  }
}


function formatError(value) {
  return '[' + Error.prototype.toString.call(value) + ']';
}


function formatArray(ctx, value, recurseTimes, visibleKeys, keys) {
  var output = [];
  for (var i = 0, l = value.length; i < l; ++i) {
    if (Object.prototype.hasOwnProperty.call(value, String(i))) {
      output.push(formatProperty(ctx, value, recurseTimes, visibleKeys,
          String(i), true));
    } else {
      output.push('');
    }
  }

  keys.forEach(function(key) {
    if (!key.match(/^\d+$/)) {
      output.push(formatProperty(ctx, value, recurseTimes, visibleKeys,
          key, true));
    }
  });
  return output;
}

function formatTypedArray(value) {
  var str = '[ ';

  for (var i = 0; i < value.length; ++i) {
    if (str.length >= config.truncateThreshold - 7) {
      str += '...';
      break;
    }
    str += value[i] + ', ';
  }
  str += ' ]';

  // Removing trailing `, ` if the array was not truncated
  if (str.indexOf(',  ]') !== -1) {
    str = str.replace(',  ]', ' ]');
  }

  return str;
}

function formatProperty(ctx, value, recurseTimes, visibleKeys, key, array) {
  var name;
  var propDescriptor = Object.getOwnPropertyDescriptor(value, key);
  var str;

  if (propDescriptor) {
    if (propDescriptor.get) {
      if (propDescriptor.set) {
        str = ctx.stylize('[Getter/Setter]', 'special');
      } else {
        str = ctx.stylize('[Getter]', 'special');
      }
    } else {
      if (propDescriptor.set) {
        str = ctx.stylize('[Setter]', 'special');
      }
    }
  }
  if (visibleKeys.indexOf(key) < 0) {
    name = '[' + key + ']';
  }
  if (!str) {
    if (ctx.seen.indexOf(value[key]) < 0) {
      if (recurseTimes === null) {
        str = formatValue(ctx, value[key], null);
      } else {
        str = formatValue(ctx, value[key], recurseTimes - 1);
      }
      if (str.indexOf('\n') > -1) {
        if (array) {
          str = str.split('\n').map(function(line) {
            return '  ' + line;
          }).join('\n').substr(2);
        } else {
          str = '\n' + str.split('\n').map(function(line) {
            return '   ' + line;
          }).join('\n');
        }
      }
    } else {
      str = ctx.stylize('[Circular]', 'special');
    }
  }
  if (typeof name === 'undefined') {
    if (array && key.match(/^\d+$/)) {
      return str;
    }
    name = JSON.stringify('' + key);
    if (name.match(/^"([a-zA-Z_][a-zA-Z_0-9]*)"$/)) {
      name = name.substr(1, name.length - 2);
      name = ctx.stylize(name, 'name');
    } else {
      name = name.replace(/'/g, "\\'")
                 .replace(/\\"/g, '"')
                 .replace(/(^"|"$)/g, "'");
      name = ctx.stylize(name, 'string');
    }
  }

  return name + ': ' + str;
}


function reduceToSingleString(output, base, braces) {
  var numLinesEst = 0;
  var length = output.reduce(function(prev, cur) {
    numLinesEst++;
    if (cur.indexOf('\n') >= 0) numLinesEst++;
    return prev + cur.length + 1;
  }, 0);

  if (length > 60) {
    return braces[0] +
           (base === '' ? '' : base + '\n ') +
           ' ' +
           output.join(',\n  ') +
           ' ' +
           braces[1];
  }

  return braces[0] + base + ' ' + output.join(', ') + ' ' + braces[1];
}

function isTypedArray(ar) {
  // Unfortunately there's no way to check if an object is a TypedArray
  // We have to check if it's one of these types
  return (typeof ar === 'object' && /\w+Array]$/.test(objectToString(ar)));
}

function isArray(ar) {
  return Array.isArray(ar) ||
         (typeof ar === 'object' && objectToString(ar) === '[object Array]');
}

function isRegExp(re) {
  return typeof re === 'object' && objectToString(re) === '[object RegExp]';
}

function isDate(d) {
  return typeof d === 'object' && objectToString(d) === '[object Date]';
}

function isError(e) {
  return typeof e === 'object' && objectToString(e) === '[object Error]';
}

function objectToString(o) {
  return Object.prototype.toString.call(o);
}


/***/ }),
/* 123 */
/***/ (function(module, exports, __webpack_require__) {

var config = __webpack_require__(72);

/*!
 * Chai - isProxyEnabled helper
 * Copyright(c) 2012-2014 Jake Luer <jake@alogicalparadox.com>
 * MIT Licensed
 */

/**
 * ### .isProxyEnabled()
 *
 * Helper function to check if Chai's proxy protection feature is enabled. If
 * proxies are unsupported or disabled via the user's Chai config, then return
 * false. Otherwise, return true.
 *
 * @namespace Utils
 * @name isProxyEnabled
 */

module.exports = function isProxyEnabled() {
  return config.useProxy && 
    typeof Proxy !== 'undefined' &&
    typeof Reflect !== 'undefined';
};


/***/ }),
/* 124 */
/***/ (function(module, exports, __webpack_require__) {

var config = __webpack_require__(72);

var fnLengthDesc = Object.getOwnPropertyDescriptor(function () {}, 'length');

/*!
 * Chai - addLengthGuard utility
 * Copyright(c) 2012-2014 Jake Luer <jake@alogicalparadox.com>
 * MIT Licensed
 */

/**
 * ### .addLengthGuard(fn, assertionName, isChainable)
 *
 * Define `length` as a getter on the given uninvoked method assertion. The
 * getter acts as a guard against chaining `length` directly off of an uninvoked
 * method assertion, which is a problem because it references `function`'s
 * built-in `length` property instead of Chai's `length` assertion. When the
 * getter catches the user making this mistake, it throws an error with a
 * helpful message.
 *
 * There are two ways in which this mistake can be made. The first way is by
 * chaining the `length` assertion directly off of an uninvoked chainable
 * method. In this case, Chai suggests that the user use `lengthOf` instead. The
 * second way is by chaining the `length` assertion directly off of an uninvoked
 * non-chainable method. Non-chainable methods must be invoked prior to
 * chaining. In this case, Chai suggests that the user consult the docs for the
 * given assertion.
 *
 * If the `length` property of functions is unconfigurable, then return `fn`
 * without modification.
 *
 * Note that in ES6, the function's `length` property is configurable, so once
 * support for legacy environments is dropped, Chai's `length` property can
 * replace the built-in function's `length` property, and this length guard will
 * no longer be necessary. In the mean time, maintaining consistency across all
 * environments is the priority.
 *
 * @param {Function} fn
 * @param {String} assertionName
 * @param {Boolean} isChainable
 * @namespace Utils
 * @name addLengthGuard
 */

module.exports = function addLengthGuard (fn, assertionName, isChainable) {
  if (!fnLengthDesc.configurable) return fn;

  Object.defineProperty(fn, 'length', {
    get: function () {
      if (isChainable) {
        throw Error('Invalid Chai property: ' + assertionName + '.length. Due' +
          ' to a compatibility issue, "length" cannot directly follow "' +
          assertionName + '". Use "' + assertionName + '.lengthOf" instead.');
      }

      throw Error('Invalid Chai property: ' + assertionName + '.length. See' +
        ' docs for proper usage of "' + assertionName + '".');
    }
  });

  return fn;
};


/***/ }),
/* 125 */
/***/ (function(module, exports, __webpack_require__) {

var config = __webpack_require__(72);
var flag = __webpack_require__(39);
var getProperties = __webpack_require__(235);
var isProxyEnabled = __webpack_require__(123);

/*!
 * Chai - proxify utility
 * Copyright(c) 2012-2014 Jake Luer <jake@alogicalparadox.com>
 * MIT Licensed
 */

/**
 * ### .proxify(object)
 *
 * Return a proxy of given object that throws an error when a non-existent
 * property is read. By default, the root cause is assumed to be a misspelled
 * property, and thus an attempt is made to offer a reasonable suggestion from
 * the list of existing properties. However, if a nonChainableMethodName is
 * provided, then the root cause is instead a failure to invoke a non-chainable
 * method prior to reading the non-existent property.
 * 
 * If proxies are unsupported or disabled via the user's Chai config, then
 * return object without modification.
 *
 * @param {Object} obj
 * @param {String} nonChainableMethodName
 * @namespace Utils
 * @name proxify
 */

var builtins = ['__flags', '__methods', '_obj', 'assert'];

module.exports = function proxify(obj, nonChainableMethodName) {
  if (!isProxyEnabled()) return obj;

  return new Proxy(obj, {
    get: function proxyGetter(target, property) {
      // This check is here because we should not throw errors on Symbol properties
      // such as `Symbol.toStringTag`.
      // The values for which an error should be thrown can be configured using
      // the `config.proxyExcludedKeys` setting.
      if (typeof property === 'string' &&
          config.proxyExcludedKeys.indexOf(property) === -1 &&
          !Reflect.has(target, property)) {
        // Special message for invalid property access of non-chainable methods.
        if (nonChainableMethodName) {
          throw Error('Invalid Chai property: ' + nonChainableMethodName + '.' +
            property + '. See docs for proper usage of "' +
            nonChainableMethodName + '".');
        }

        var orderedProperties = getProperties(target).filter(function(property) {
          return !Object.prototype.hasOwnProperty(property) &&
            builtins.indexOf(property) === -1;
        }).sort(function(a, b) {
          return stringDistance(property, a) - stringDistance(property, b);
        });

        if (orderedProperties.length &&
            stringDistance(orderedProperties[0], property) < 4) {
          // If the property is reasonably close to an existing Chai property,
          // suggest that property to the user.
          throw Error('Invalid Chai property: ' + property +
            '. Did you mean "' + orderedProperties[0] + '"?');
        } else {
          throw Error('Invalid Chai property: ' + property);
        }
      }

      // Use this proxy getter as the starting point for removing implementation
      // frames from the stack trace of a failed assertion. For property
      // assertions, this prevents the proxy getter from showing up in the stack
      // trace since it's invoked before the property getter. For method and
      // chainable method assertions, this flag will end up getting changed to
      // the method wrapper, which is good since this frame will no longer be in
      // the stack once the method is invoked. Note that Chai builtin assertion
      // properties such as `__flags` are skipped since this is only meant to
      // capture the starting point of an assertion. This step is also skipped
      // if the `lockSsfi` flag is set, thus indicating that this assertion is
      // being called from within another assertion. In that case, the `ssfi`
      // flag is already set to the outer assertion's starting point.
      if (builtins.indexOf(property) === -1 && !flag(target, 'lockSsfi')) {
        flag(target, 'ssfi', proxyGetter);
      }

      return Reflect.get(target, property);
    }
  });
};

/**
 * # stringDistance(strA, strB)
 * Return the Levenshtein distance between two strings.
 * @param {string} strA
 * @param {string} strB
 * @return {number} the string distance between strA and strB
 * @api private
 */

function stringDistance(strA, strB, memo) {
  if (!memo) {
    // `memo` is a two-dimensional array containing a cache of distances
    // memo[i][j] is the distance between strA.slice(0, i) and
    // strB.slice(0, j).
    memo = [];
    for (var i = 0; i <= strA.length; i++) {
      memo[i] = [];
    }
  }

  if (!memo[strA.length] || !memo[strA.length][strB.length]) {
    if (strA.length === 0 || strB.length === 0) {
      memo[strA.length][strB.length] = Math.max(strA.length, strB.length);
    } else {
      memo[strA.length][strB.length] = Math.min(
        stringDistance(strA.slice(0, -1), strB, memo) + 1,
        stringDistance(strA, strB.slice(0, -1), memo) + 1,
        stringDistance(strA.slice(0, -1), strB.slice(0, -1), memo) +
          (strA.slice(-1) === strB.slice(-1) ? 0 : 1)
      );
    }
  }

  return memo[strA.length][strB.length];
}


/***/ }),
/* 126 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(process) {// Generated by CoffeeScript 2.2.3
(function() {
  // This file contains the common helper functions that we'd like to share among
  // the **Lexer**, **Rewriter**, and the **Nodes**. Merge objects, flatten
  // arrays, count characters, that sort of thing.

  // Peek at the beginning of a given string to see if it matches a sequence.
  var attachCommentsToNode, buildLocationData, buildLocationHash, extend, flatten, ref, repeat, syntaxErrorToString;

  exports.starts = function(string, literal, start) {
    return literal === string.substr(start, literal.length);
  };

  // Peek at the end of a given string to see if it matches a sequence.
  exports.ends = function(string, literal, back) {
    var len;
    len = literal.length;
    return literal === string.substr(string.length - len - (back || 0), len);
  };

  // Repeat a string `n` times.
  exports.repeat = repeat = function(str, n) {
    var res;
    // Use clever algorithm to have O(log(n)) string concatenation operations.
    res = '';
    while (n > 0) {
      if (n & 1) {
        res += str;
      }
      n >>>= 1;
      str += str;
    }
    return res;
  };

  // Trim out all falsy values from an array.
  exports.compact = function(array) {
    var i, item, len1, results;
    results = [];
    for (i = 0, len1 = array.length; i < len1; i++) {
      item = array[i];
      if (item) {
        results.push(item);
      }
    }
    return results;
  };

  // Count the number of occurrences of a string in a string.
  exports.count = function(string, substr) {
    var num, pos;
    num = pos = 0;
    if (!substr.length) {
      return 1 / 0;
    }
    while (pos = 1 + string.indexOf(substr, pos)) {
      num++;
    }
    return num;
  };

  // Merge objects, returning a fresh copy with attributes from both sides.
  // Used every time `Base#compile` is called, to allow properties in the
  // options hash to propagate down the tree without polluting other branches.
  exports.merge = function(options, overrides) {
    return extend(extend({}, options), overrides);
  };

  // Extend a source object with the properties of another object (shallow copy).
  extend = exports.extend = function(object, properties) {
    var key, val;
    for (key in properties) {
      val = properties[key];
      object[key] = val;
    }
    return object;
  };

  // Return a flattened version of an array.
  // Handy for getting a list of `children` from the nodes.
  exports.flatten = flatten = function(array) {
    var element, flattened, i, len1;
    flattened = [];
    for (i = 0, len1 = array.length; i < len1; i++) {
      element = array[i];
      if ('[object Array]' === Object.prototype.toString.call(element)) {
        flattened = flattened.concat(flatten(element));
      } else {
        flattened.push(element);
      }
    }
    return flattened;
  };

  // Delete a key from an object, returning the value. Useful when a node is
  // looking for a particular method in an options hash.
  exports.del = function(obj, key) {
    var val;
    val = obj[key];
    delete obj[key];
    return val;
  };

  // Typical Array::some
  exports.some = (ref = Array.prototype.some) != null ? ref : function(fn) {
    var e, i, len1, ref1;
    ref1 = this;
    for (i = 0, len1 = ref1.length; i < len1; i++) {
      e = ref1[i];
      if (fn(e)) {
        return true;
      }
    }
    return false;
  };

  // Helper function for extracting code from Literate CoffeeScript by stripping
  // out all non-code blocks, producing a string of CoffeeScript code that can
  // be compiled “normally.”
  exports.invertLiterate = function(code) {
    var blankLine, i, indented, insideComment, len1, line, listItemStart, out, ref1;
    out = [];
    blankLine = /^\s*$/;
    indented = /^[\t ]/;
    listItemStart = /^(?:\t?| {0,3})(?:[\*\-\+]|[0-9]{1,9}\.)[ \t]/; // Up to one tab, or up to three spaces, or neither;
    // followed by `*`, `-` or `+`;
    // or by an integer up to 9 digits long, followed by a period;
    // followed by a space or a tab.
    insideComment = false;
    ref1 = code.split('\n');
    for (i = 0, len1 = ref1.length; i < len1; i++) {
      line = ref1[i];
      if (blankLine.test(line)) {
        insideComment = false;
        out.push(line);
      } else if (insideComment || listItemStart.test(line)) {
        insideComment = true;
        out.push(`# ${line}`);
      } else if (!insideComment && indented.test(line)) {
        out.push(line);
      } else {
        insideComment = true;
        out.push(`# ${line}`);
      }
    }
    return out.join('\n');
  };

  // Merge two jison-style location data objects together.
  // If `last` is not provided, this will simply return `first`.
  buildLocationData = function(first, last) {
    if (!last) {
      return first;
    } else {
      return {
        first_line: first.first_line,
        first_column: first.first_column,
        last_line: last.last_line,
        last_column: last.last_column
      };
    }
  };

  buildLocationHash = function(loc) {
    return `${loc.first_line}x${loc.first_column}-${loc.last_line}x${loc.last_column}`;
  };

  // This returns a function which takes an object as a parameter, and if that
  // object is an AST node, updates that object's locationData.
  // The object is returned either way.
  exports.addDataToNode = function(parserState, first, last) {
    return function(obj) {
      var i, len1, objHash, ref1, token, tokenHash;
      // Add location data
      if (((obj != null ? obj.updateLocationDataIfMissing : void 0) != null) && (first != null)) {
        obj.updateLocationDataIfMissing(buildLocationData(first, last));
      }
      // Add comments data
      if (!parserState.tokenComments) {
        parserState.tokenComments = {};
        ref1 = parserState.parser.tokens;
        for (i = 0, len1 = ref1.length; i < len1; i++) {
          token = ref1[i];
          if (!token.comments) {
            continue;
          }
          tokenHash = buildLocationHash(token[2]);
          if (parserState.tokenComments[tokenHash] == null) {
            parserState.tokenComments[tokenHash] = token.comments;
          } else {
            parserState.tokenComments[tokenHash].push(...token.comments);
          }
        }
      }
      if (obj.locationData != null) {
        objHash = buildLocationHash(obj.locationData);
        if (parserState.tokenComments[objHash] != null) {
          attachCommentsToNode(parserState.tokenComments[objHash], obj);
        }
      }
      return obj;
    };
  };

  exports.attachCommentsToNode = attachCommentsToNode = function(comments, node) {
    if ((comments == null) || comments.length === 0) {
      return;
    }
    if (node.comments == null) {
      node.comments = [];
    }
    return node.comments.push(...comments);
  };

  // Convert jison location data to a string.
  // `obj` can be a token, or a locationData.
  exports.locationDataToString = function(obj) {
    var locationData;
    if (("2" in obj) && ("first_line" in obj[2])) {
      locationData = obj[2];
    } else if ("first_line" in obj) {
      locationData = obj;
    }
    if (locationData) {
      return `${locationData.first_line + 1}:${locationData.first_column + 1}-` + `${locationData.last_line + 1}:${locationData.last_column + 1}`;
    } else {
      return "No location data";
    }
  };

  // A `.coffee.md` compatible version of `basename`, that returns the file sans-extension.
  exports.baseFileName = function(file, stripExt = false, useWinPathSep = false) {
    var parts, pathSep;
    pathSep = useWinPathSep ? /\\|\// : /\//;
    parts = file.split(pathSep);
    file = parts[parts.length - 1];
    if (!(stripExt && file.indexOf('.') >= 0)) {
      return file;
    }
    parts = file.split('.');
    parts.pop();
    if (parts[parts.length - 1] === 'coffee' && parts.length > 1) {
      parts.pop();
    }
    return parts.join('.');
  };

  // Determine if a filename represents a CoffeeScript file.
  exports.isCoffee = function(file) {
    return /\.((lit)?coffee|coffee\.md)$/.test(file);
  };

  // Determine if a filename represents a Literate CoffeeScript file.
  exports.isLiterate = function(file) {
    return /\.(litcoffee|coffee\.md)$/.test(file);
  };

  // Throws a SyntaxError from a given location.
  // The error's `toString` will return an error message following the "standard"
  // format `<filename>:<line>:<col>: <message>` plus the line with the error and a
  // marker showing where the error is.
  exports.throwSyntaxError = function(message, location) {
    var error;
    error = new SyntaxError(message);
    error.location = location;
    error.toString = syntaxErrorToString;
    // Instead of showing the compiler's stacktrace, show our custom error message
    // (this is useful when the error bubbles up in Node.js applications that
    // compile CoffeeScript for example).
    error.stack = error.toString();
    throw error;
  };

  // Update a compiler SyntaxError with source code information if it didn't have
  // it already.
  exports.updateSyntaxError = function(error, code, filename) {
    // Avoid screwing up the `stack` property of other errors (i.e. possible bugs).
    if (error.toString === syntaxErrorToString) {
      error.code || (error.code = code);
      error.filename || (error.filename = filename);
      error.stack = error.toString();
    }
    return error;
  };

  syntaxErrorToString = function() {
    var codeLine, colorize, colorsEnabled, end, filename, first_column, first_line, last_column, last_line, marker, ref1, ref2, ref3, start;
    if (!(this.code && this.location)) {
      return Error.prototype.toString.call(this);
    }
    ({first_line, first_column, last_line, last_column} = this.location);
    if (last_line == null) {
      last_line = first_line;
    }
    if (last_column == null) {
      last_column = first_column;
    }
    filename = this.filename || '[stdin]';
    codeLine = this.code.split('\n')[first_line];
    start = first_column;
    // Show only the first line on multi-line errors.
    end = first_line === last_line ? last_column + 1 : codeLine.length;
    marker = codeLine.slice(0, start).replace(/[^\s]/g, ' ') + repeat('^', end - start);
    // Check to see if we're running on a color-enabled TTY.
    if (typeof process !== "undefined" && process !== null) {
      colorsEnabled = ((ref1 = process.stdout) != null ? ref1.isTTY : void 0) && !((ref2 = process.env) != null ? ref2.NODE_DISABLE_COLORS : void 0);
    }
    if ((ref3 = this.colorful) != null ? ref3 : colorsEnabled) {
      colorize = function(str) {
        return `\x1B[1;31m${str}\x1B[0m`;
      };
      codeLine = codeLine.slice(0, start) + colorize(codeLine.slice(start, end)) + codeLine.slice(end);
      marker = colorize(marker);
    }
    return `${filename}:${first_line + 1}:${first_column + 1}: error: ${this.message}\n${codeLine}\n${marker}`;
  };

  exports.nameWhitespaceCharacter = function(string) {
    switch (string) {
      case ' ':
        return 'space';
      case '\n':
        return 'newline';
      case '\r':
        return 'carriage return';
      case '\t':
        return 'tab';
      default:
        return string;
    }
  };

}).call(this);

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(28)))

/***/ }),
/* 127 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(module, global) {var __WEBPACK_AMD_DEFINE_RESULT__;/**
 * @license
 * lodash 3.7.0 (Custom Build) <https://lodash.com/>
 * Build: `lodash modern -d -o ./index.js`
 * Copyright 2012-2015 The Dojo Foundation <http://dojofoundation.org/>
 * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
 * Copyright 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
 * Available under MIT license <https://lodash.com/license>
 */
;(function() {

  /** Used as a safe reference for `undefined` in pre-ES5 environments. */
  var undefined;

  /** Used as the semantic version number. */
  var VERSION = '3.7.0';

  /** Used to compose bitmasks for wrapper metadata. */
  var BIND_FLAG = 1,
      BIND_KEY_FLAG = 2,
      CURRY_BOUND_FLAG = 4,
      CURRY_FLAG = 8,
      CURRY_RIGHT_FLAG = 16,
      PARTIAL_FLAG = 32,
      PARTIAL_RIGHT_FLAG = 64,
      ARY_FLAG = 128,
      REARG_FLAG = 256;

  /** Used as default options for `_.trunc`. */
  var DEFAULT_TRUNC_LENGTH = 30,
      DEFAULT_TRUNC_OMISSION = '...';

  /** Used to detect when a function becomes hot. */
  var HOT_COUNT = 150,
      HOT_SPAN = 16;

  /** Used to indicate the type of lazy iteratees. */
  var LAZY_DROP_WHILE_FLAG = 0,
      LAZY_FILTER_FLAG = 1,
      LAZY_MAP_FLAG = 2;

  /** Used as the `TypeError` message for "Functions" methods. */
  var FUNC_ERROR_TEXT = 'Expected a function';

  /** Used as the internal argument placeholder. */
  var PLACEHOLDER = '__lodash_placeholder__';

  /** `Object#toString` result references. */
  var argsTag = '[object Arguments]',
      arrayTag = '[object Array]',
      boolTag = '[object Boolean]',
      dateTag = '[object Date]',
      errorTag = '[object Error]',
      funcTag = '[object Function]',
      mapTag = '[object Map]',
      numberTag = '[object Number]',
      objectTag = '[object Object]',
      regexpTag = '[object RegExp]',
      setTag = '[object Set]',
      stringTag = '[object String]',
      weakMapTag = '[object WeakMap]';

  var arrayBufferTag = '[object ArrayBuffer]',
      float32Tag = '[object Float32Array]',
      float64Tag = '[object Float64Array]',
      int8Tag = '[object Int8Array]',
      int16Tag = '[object Int16Array]',
      int32Tag = '[object Int32Array]',
      uint8Tag = '[object Uint8Array]',
      uint8ClampedTag = '[object Uint8ClampedArray]',
      uint16Tag = '[object Uint16Array]',
      uint32Tag = '[object Uint32Array]';

  /** Used to match empty string literals in compiled template source. */
  var reEmptyStringLeading = /\b__p \+= '';/g,
      reEmptyStringMiddle = /\b(__p \+=) '' \+/g,
      reEmptyStringTrailing = /(__e\(.*?\)|\b__t\)) \+\n'';/g;

  /** Used to match HTML entities and HTML characters. */
  var reEscapedHtml = /&(?:amp|lt|gt|quot|#39|#96);/g,
      reUnescapedHtml = /[&<>"'`]/g,
      reHasEscapedHtml = RegExp(reEscapedHtml.source),
      reHasUnescapedHtml = RegExp(reUnescapedHtml.source);

  /** Used to match template delimiters. */
  var reEscape = /<%-([\s\S]+?)%>/g,
      reEvaluate = /<%([\s\S]+?)%>/g,
      reInterpolate = /<%=([\s\S]+?)%>/g;

  /** Used to match property names within property paths. */
  var reIsDeepProp = /\.|\[(?:[^[\]]+|(["'])(?:(?!\1)[^\n\\]|\\.)*?)\1\]/,
      reIsPlainProp = /^\w*$/,
      rePropName = /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\n\\]|\\.)*?)\2)\]/g;

  /**
   * Used to match `RegExp` [special characters](http://www.regular-expressions.info/characters.html#special).
   * In addition to special characters the forward slash is escaped to allow for
   * easier `eval` use and `Function` compilation.
   */
  var reRegExpChars = /[.*+?^${}()|[\]\/\\]/g,
      reHasRegExpChars = RegExp(reRegExpChars.source);

  /** Used to match [combining diacritical marks](https://en.wikipedia.org/wiki/Combining_Diacritical_Marks). */
  var reComboMark = /[\u0300-\u036f\ufe20-\ufe23]/g;

  /** Used to match backslashes in property paths. */
  var reEscapeChar = /\\(\\)?/g;

  /** Used to match [ES template delimiters](https://people.mozilla.org/~jorendorff/es6-draft.html#sec-template-literal-lexical-components). */
  var reEsTemplate = /\$\{([^\\}]*(?:\\.[^\\}]*)*)\}/g;

  /** Used to match `RegExp` flags from their coerced string values. */
  var reFlags = /\w*$/;

  /** Used to detect hexadecimal string values. */
  var reHasHexPrefix = /^0[xX]/;

  /** Used to detect host constructors (Safari > 5). */
  var reIsHostCtor = /^\[object .+?Constructor\]$/;

  /** Used to match latin-1 supplementary letters (excluding mathematical operators). */
  var reLatin1 = /[\xc0-\xd6\xd8-\xde\xdf-\xf6\xf8-\xff]/g;

  /** Used to ensure capturing order of template delimiters. */
  var reNoMatch = /($^)/;

  /** Used to match unescaped characters in compiled string literals. */
  var reUnescapedString = /['\n\r\u2028\u2029\\]/g;

  /** Used to match words to create compound words. */
  var reWords = (function() {
    var upper = '[A-Z\\xc0-\\xd6\\xd8-\\xde]',
        lower = '[a-z\\xdf-\\xf6\\xf8-\\xff]+';

    return RegExp(upper + '+(?=' + upper + lower + ')|' + upper + '?' + lower + '|' + upper + '+|[0-9]+', 'g');
  }());

  /** Used to detect and test for whitespace. */
  var whitespace = (
    // Basic whitespace characters.
    ' \t\x0b\f\xa0\ufeff' +

    // Line terminators.
    '\n\r\u2028\u2029' +

    // Unicode category "Zs" space separators.
    '\u1680\u180e\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000'
  );

  /** Used to assign default `context` object properties. */
  var contextProps = [
    'Array', 'ArrayBuffer', 'Date', 'Error', 'Float32Array', 'Float64Array',
    'Function', 'Int8Array', 'Int16Array', 'Int32Array', 'Math', 'Number',
    'Object', 'RegExp', 'Set', 'String', '_', 'clearTimeout', 'document',
    'isFinite', 'parseInt', 'setTimeout', 'TypeError', 'Uint8Array',
    'Uint8ClampedArray', 'Uint16Array', 'Uint32Array', 'WeakMap',
    'window'
  ];

  /** Used to make template sourceURLs easier to identify. */
  var templateCounter = -1;

  /** Used to identify `toStringTag` values of typed arrays. */
  var typedArrayTags = {};
  typedArrayTags[float32Tag] = typedArrayTags[float64Tag] =
  typedArrayTags[int8Tag] = typedArrayTags[int16Tag] =
  typedArrayTags[int32Tag] = typedArrayTags[uint8Tag] =
  typedArrayTags[uint8ClampedTag] = typedArrayTags[uint16Tag] =
  typedArrayTags[uint32Tag] = true;
  typedArrayTags[argsTag] = typedArrayTags[arrayTag] =
  typedArrayTags[arrayBufferTag] = typedArrayTags[boolTag] =
  typedArrayTags[dateTag] = typedArrayTags[errorTag] =
  typedArrayTags[funcTag] = typedArrayTags[mapTag] =
  typedArrayTags[numberTag] = typedArrayTags[objectTag] =
  typedArrayTags[regexpTag] = typedArrayTags[setTag] =
  typedArrayTags[stringTag] = typedArrayTags[weakMapTag] = false;

  /** Used to identify `toStringTag` values supported by `_.clone`. */
  var cloneableTags = {};
  cloneableTags[argsTag] = cloneableTags[arrayTag] =
  cloneableTags[arrayBufferTag] = cloneableTags[boolTag] =
  cloneableTags[dateTag] = cloneableTags[float32Tag] =
  cloneableTags[float64Tag] = cloneableTags[int8Tag] =
  cloneableTags[int16Tag] = cloneableTags[int32Tag] =
  cloneableTags[numberTag] = cloneableTags[objectTag] =
  cloneableTags[regexpTag] = cloneableTags[stringTag] =
  cloneableTags[uint8Tag] = cloneableTags[uint8ClampedTag] =
  cloneableTags[uint16Tag] = cloneableTags[uint32Tag] = true;
  cloneableTags[errorTag] = cloneableTags[funcTag] =
  cloneableTags[mapTag] = cloneableTags[setTag] =
  cloneableTags[weakMapTag] = false;

  /** Used as an internal `_.debounce` options object by `_.throttle`. */
  var debounceOptions = {
    'leading': false,
    'maxWait': 0,
    'trailing': false
  };

  /** Used to map latin-1 supplementary letters to basic latin letters. */
  var deburredLetters = {
    '\xc0': 'A',  '\xc1': 'A', '\xc2': 'A', '\xc3': 'A', '\xc4': 'A', '\xc5': 'A',
    '\xe0': 'a',  '\xe1': 'a', '\xe2': 'a', '\xe3': 'a', '\xe4': 'a', '\xe5': 'a',
    '\xc7': 'C',  '\xe7': 'c',
    '\xd0': 'D',  '\xf0': 'd',
    '\xc8': 'E',  '\xc9': 'E', '\xca': 'E', '\xcb': 'E',
    '\xe8': 'e',  '\xe9': 'e', '\xea': 'e', '\xeb': 'e',
    '\xcC': 'I',  '\xcd': 'I', '\xce': 'I', '\xcf': 'I',
    '\xeC': 'i',  '\xed': 'i', '\xee': 'i', '\xef': 'i',
    '\xd1': 'N',  '\xf1': 'n',
    '\xd2': 'O',  '\xd3': 'O', '\xd4': 'O', '\xd5': 'O', '\xd6': 'O', '\xd8': 'O',
    '\xf2': 'o',  '\xf3': 'o', '\xf4': 'o', '\xf5': 'o', '\xf6': 'o', '\xf8': 'o',
    '\xd9': 'U',  '\xda': 'U', '\xdb': 'U', '\xdc': 'U',
    '\xf9': 'u',  '\xfa': 'u', '\xfb': 'u', '\xfc': 'u',
    '\xdd': 'Y',  '\xfd': 'y', '\xff': 'y',
    '\xc6': 'Ae', '\xe6': 'ae',
    '\xde': 'Th', '\xfe': 'th',
    '\xdf': 'ss'
  };

  /** Used to map characters to HTML entities. */
  var htmlEscapes = {
    '&': '&amp;',
    '<': '&lt;',
    '>': '&gt;',
    '"': '&quot;',
    "'": '&#39;',
    '`': '&#96;'
  };

  /** Used to map HTML entities to characters. */
  var htmlUnescapes = {
    '&amp;': '&',
    '&lt;': '<',
    '&gt;': '>',
    '&quot;': '"',
    '&#39;': "'",
    '&#96;': '`'
  };

  /** Used to determine if values are of the language type `Object`. */
  var objectTypes = {
    'function': true,
    'object': true
  };

  /** Used to escape characters for inclusion in compiled string literals. */
  var stringEscapes = {
    '\\': '\\',
    "'": "'",
    '\n': 'n',
    '\r': 'r',
    '\u2028': 'u2028',
    '\u2029': 'u2029'
  };

  /** Detect free variable `exports`. */
  var freeExports = objectTypes[typeof exports] && exports && !exports.nodeType && exports;

  /** Detect free variable `module`. */
  var freeModule = objectTypes[typeof module] && module && !module.nodeType && module;

  /** Detect free variable `global` from Node.js. */
  var freeGlobal = freeExports && freeModule && typeof global == 'object' && global && global.Object && global;

  /** Detect free variable `self`. */
  var freeSelf = objectTypes[typeof self] && self && self.Object && self;

  /** Detect free variable `window`. */
  var freeWindow = objectTypes[typeof window] && window && window.Object && window;

  /** Detect the popular CommonJS extension `module.exports`. */
  var moduleExports = freeModule && freeModule.exports === freeExports && freeExports;

  /**
   * Used as a reference to the global object.
   *
   * The `this` value is used if it is the global object to avoid Greasemonkey's
   * restricted `window` object, otherwise the `window` object is used.
   */
  var root = freeGlobal || ((freeWindow !== (this && this.window)) && freeWindow) || freeSelf || this;

  /*--------------------------------------------------------------------------*/

  /**
   * The base implementation of `compareAscending` which compares values and
   * sorts them in ascending order without guaranteeing a stable sort.
   *
   * @private
   * @param {*} value The value to compare to `other`.
   * @param {*} other The value to compare to `value`.
   * @returns {number} Returns the sort order indicator for `value`.
   */
  function baseCompareAscending(value, other) {
    if (value !== other) {
      var valIsReflexive = value === value,
          othIsReflexive = other === other;

      if (value > other || !valIsReflexive || (value === undefined && othIsReflexive)) {
        return 1;
      }
      if (value < other || !othIsReflexive || (other === undefined && valIsReflexive)) {
        return -1;
      }
    }
    return 0;
  }

  /**
   * The base implementation of `_.findIndex` and `_.findLastIndex` without
   * support for callback shorthands and `this` binding.
   *
   * @private
   * @param {Array} array The array to search.
   * @param {Function} predicate The function invoked per iteration.
   * @param {boolean} [fromRight] Specify iterating from right to left.
   * @returns {number} Returns the index of the matched value, else `-1`.
   */
  function baseFindIndex(array, predicate, fromRight) {
    var length = array.length,
        index = fromRight ? length : -1;

    while ((fromRight ? index-- : ++index < length)) {
      if (predicate(array[index], index, array)) {
        return index;
      }
    }
    return -1;
  }

  /**
   * The base implementation of `_.indexOf` without support for binary searches.
   *
   * @private
   * @param {Array} array The array to search.
   * @param {*} value The value to search for.
   * @param {number} fromIndex The index to search from.
   * @returns {number} Returns the index of the matched value, else `-1`.
   */
  function baseIndexOf(array, value, fromIndex) {
    if (value !== value) {
      return indexOfNaN(array, fromIndex);
    }
    var index = fromIndex - 1,
        length = array.length;

    while (++index < length) {
      if (array[index] === value) {
        return index;
      }
    }
    return -1;
  }

  /**
   * The base implementation of `_.isFunction` without support for environments
   * with incorrect `typeof` results.
   *
   * @private
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is correctly classified, else `false`.
   */
  function baseIsFunction(value) {
    // Avoid a Chakra JIT bug in compatibility modes of IE 11.
    // See https://github.com/jashkenas/underscore/issues/1621 for more details.
    return typeof value == 'function' || false;
  }

  /**
   * Converts `value` to a string if it is not one. An empty string is returned
   * for `null` or `undefined` values.
   *
   * @private
   * @param {*} value The value to process.
   * @returns {string} Returns the string.
   */
  function baseToString(value) {
    if (typeof value == 'string') {
      return value;
    }
    return value == null ? '' : (value + '');
  }

  /**
   * Used by `_.max` and `_.min` as the default callback for string values.
   *
   * @private
   * @param {string} string The string to inspect.
   * @returns {number} Returns the code unit of the first character of the string.
   */
  function charAtCallback(string) {
    return string.charCodeAt(0);
  }

  /**
   * Used by `_.trim` and `_.trimLeft` to get the index of the first character
   * of `string` that is not found in `chars`.
   *
   * @private
   * @param {string} string The string to inspect.
   * @param {string} chars The characters to find.
   * @returns {number} Returns the index of the first character not found in `chars`.
   */
  function charsLeftIndex(string, chars) {
    var index = -1,
        length = string.length;

    while (++index < length && chars.indexOf(string.charAt(index)) > -1) {}
    return index;
  }

  /**
   * Used by `_.trim` and `_.trimRight` to get the index of the last character
   * of `string` that is not found in `chars`.
   *
   * @private
   * @param {string} string The string to inspect.
   * @param {string} chars The characters to find.
   * @returns {number} Returns the index of the last character not found in `chars`.
   */
  function charsRightIndex(string, chars) {
    var index = string.length;

    while (index-- && chars.indexOf(string.charAt(index)) > -1) {}
    return index;
  }

  /**
   * Used by `_.sortBy` to compare transformed elements of a collection and stable
   * sort them in ascending order.
   *
   * @private
   * @param {Object} object The object to compare to `other`.
   * @param {Object} other The object to compare to `object`.
   * @returns {number} Returns the sort order indicator for `object`.
   */
  function compareAscending(object, other) {
    return baseCompareAscending(object.criteria, other.criteria) || (object.index - other.index);
  }

  /**
   * Used by `_.sortByOrder` to compare multiple properties of each element
   * in a collection and stable sort them in the following order:
   *
   * If `orders` is unspecified, sort in ascending order for all properties.
   * Otherwise, for each property, sort in ascending order if its corresponding value in
   * orders is true, and descending order if false.
   *
   * @private
   * @param {Object} object The object to compare to `other`.
   * @param {Object} other The object to compare to `object`.
   * @param {boolean[]} orders The order to sort by for each property.
   * @returns {number} Returns the sort order indicator for `object`.
   */
  function compareMultiple(object, other, orders) {
    var index = -1,
        objCriteria = object.criteria,
        othCriteria = other.criteria,
        length = objCriteria.length,
        ordersLength = orders.length;

    while (++index < length) {
      var result = baseCompareAscending(objCriteria[index], othCriteria[index]);
      if (result) {
        if (index >= ordersLength) {
          return result;
        }
        return result * (orders[index] ? 1 : -1);
      }
    }
    // Fixes an `Array#sort` bug in the JS engine embedded in Adobe applications
    // that causes it, under certain circumstances, to provide the same value for
    // `object` and `other`. See https://github.com/jashkenas/underscore/pull/1247
    // for more details.
    //
    // This also ensures a stable sort in V8 and other engines.
    // See https://code.google.com/p/v8/issues/detail?id=90 for more details.
    return object.index - other.index;
  }

  /**
   * Used by `_.deburr` to convert latin-1 supplementary letters to basic latin letters.
   *
   * @private
   * @param {string} letter The matched letter to deburr.
   * @returns {string} Returns the deburred letter.
   */
  function deburrLetter(letter) {
    return deburredLetters[letter];
  }

  /**
   * Used by `_.escape` to convert characters to HTML entities.
   *
   * @private
   * @param {string} chr The matched character to escape.
   * @returns {string} Returns the escaped character.
   */
  function escapeHtmlChar(chr) {
    return htmlEscapes[chr];
  }

  /**
   * Used by `_.template` to escape characters for inclusion in compiled
   * string literals.
   *
   * @private
   * @param {string} chr The matched character to escape.
   * @returns {string} Returns the escaped character.
   */
  function escapeStringChar(chr) {
    return '\\' + stringEscapes[chr];
  }

  /**
   * Gets the index at which the first occurrence of `NaN` is found in `array`.
   *
   * @private
   * @param {Array} array The array to search.
   * @param {number} fromIndex The index to search from.
   * @param {boolean} [fromRight] Specify iterating from right to left.
   * @returns {number} Returns the index of the matched `NaN`, else `-1`.
   */
  function indexOfNaN(array, fromIndex, fromRight) {
    var length = array.length,
        index = fromIndex + (fromRight ? 0 : -1);

    while ((fromRight ? index-- : ++index < length)) {
      var other = array[index];
      if (other !== other) {
        return index;
      }
    }
    return -1;
  }

  /**
   * Checks if `value` is object-like.
   *
   * @private
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
   */
  function isObjectLike(value) {
    return !!value && typeof value == 'object';
  }

  /**
   * Used by `trimmedLeftIndex` and `trimmedRightIndex` to determine if a
   * character code is whitespace.
   *
   * @private
   * @param {number} charCode The character code to inspect.
   * @returns {boolean} Returns `true` if `charCode` is whitespace, else `false`.
   */
  function isSpace(charCode) {
    return ((charCode <= 160 && (charCode >= 9 && charCode <= 13) || charCode == 32 || charCode == 160) || charCode == 5760 || charCode == 6158 ||
      (charCode >= 8192 && (charCode <= 8202 || charCode == 8232 || charCode == 8233 || charCode == 8239 || charCode == 8287 || charCode == 12288 || charCode == 65279)));
  }

  /**
   * Replaces all `placeholder` elements in `array` with an internal placeholder
   * and returns an array of their indexes.
   *
   * @private
   * @param {Array} array The array to modify.
   * @param {*} placeholder The placeholder to replace.
   * @returns {Array} Returns the new array of placeholder indexes.
   */
  function replaceHolders(array, placeholder) {
    var index = -1,
        length = array.length,
        resIndex = -1,
        result = [];

    while (++index < length) {
      if (array[index] === placeholder) {
        array[index] = PLACEHOLDER;
        result[++resIndex] = index;
      }
    }
    return result;
  }

  /**
   * An implementation of `_.uniq` optimized for sorted arrays without support
   * for callback shorthands and `this` binding.
   *
   * @private
   * @param {Array} array The array to inspect.
   * @param {Function} [iteratee] The function invoked per iteration.
   * @returns {Array} Returns the new duplicate-value-free array.
   */
  function sortedUniq(array, iteratee) {
    var seen,
        index = -1,
        length = array.length,
        resIndex = -1,
        result = [];

    while (++index < length) {
      var value = array[index],
          computed = iteratee ? iteratee(value, index, array) : value;

      if (!index || seen !== computed) {
        seen = computed;
        result[++resIndex] = value;
      }
    }
    return result;
  }

  /**
   * Used by `_.trim` and `_.trimLeft` to get the index of the first non-whitespace
   * character of `string`.
   *
   * @private
   * @param {string} string The string to inspect.
   * @returns {number} Returns the index of the first non-whitespace character.
   */
  function trimmedLeftIndex(string) {
    var index = -1,
        length = string.length;

    while (++index < length && isSpace(string.charCodeAt(index))) {}
    return index;
  }

  /**
   * Used by `_.trim` and `_.trimRight` to get the index of the last non-whitespace
   * character of `string`.
   *
   * @private
   * @param {string} string The string to inspect.
   * @returns {number} Returns the index of the last non-whitespace character.
   */
  function trimmedRightIndex(string) {
    var index = string.length;

    while (index-- && isSpace(string.charCodeAt(index))) {}
    return index;
  }

  /**
   * Used by `_.unescape` to convert HTML entities to characters.
   *
   * @private
   * @param {string} chr The matched character to unescape.
   * @returns {string} Returns the unescaped character.
   */
  function unescapeHtmlChar(chr) {
    return htmlUnescapes[chr];
  }

  /*--------------------------------------------------------------------------*/

  /**
   * Create a new pristine `lodash` function using the given `context` object.
   *
   * @static
   * @memberOf _
   * @category Utility
   * @param {Object} [context=root] The context object.
   * @returns {Function} Returns a new `lodash` function.
   * @example
   *
   * _.mixin({ 'foo': _.constant('foo') });
   *
   * var lodash = _.runInContext();
   * lodash.mixin({ 'bar': lodash.constant('bar') });
   *
   * _.isFunction(_.foo);
   * // => true
   * _.isFunction(_.bar);
   * // => false
   *
   * lodash.isFunction(lodash.foo);
   * // => false
   * lodash.isFunction(lodash.bar);
   * // => true
   *
   * // using `context` to mock `Date#getTime` use in `_.now`
   * var mock = _.runInContext({
   *   'Date': function() {
   *     return { 'getTime': getTimeMock };
   *   }
   * });
   *
   * // or creating a suped-up `defer` in Node.js
   * var defer = _.runInContext({ 'setTimeout': setImmediate }).defer;
   */
  function runInContext(context) {
    // Avoid issues with some ES3 environments that attempt to use values, named
    // after built-in constructors like `Object`, for the creation of literals.
    // ES5 clears this up by stating that literals must use built-in constructors.
    // See https://es5.github.io/#x11.1.5 for more details.
    context = context ? _.defaults(root.Object(), context, _.pick(root, contextProps)) : root;

    /** Native constructor references. */
    var Array = context.Array,
        Date = context.Date,
        Error = context.Error,
        Function = context.Function,
        Math = context.Math,
        Number = context.Number,
        Object = context.Object,
        RegExp = context.RegExp,
        String = context.String,
        TypeError = context.TypeError;

    /** Used for native method references. */
    var arrayProto = Array.prototype,
        objectProto = Object.prototype,
        stringProto = String.prototype;

    /** Used to detect DOM support. */
    var document = (document = context.window) && document.document;

    /** Used to resolve the decompiled source of functions. */
    var fnToString = Function.prototype.toString;

    /** Used to check objects for own properties. */
    var hasOwnProperty = objectProto.hasOwnProperty;

    /** Used to generate unique IDs. */
    var idCounter = 0;

    /**
     * Used to resolve the [`toStringTag`](https://people.mozilla.org/~jorendorff/es6-draft.html#sec-object.prototype.tostring)
     * of values.
     */
    var objToString = objectProto.toString;

    /** Used to restore the original `_` reference in `_.noConflict`. */
    var oldDash = context._;

    /** Used to detect if a method is native. */
    var reIsNative = RegExp('^' +
      escapeRegExp(objToString)
      .replace(/toString|(function).*?(?=\\\()| for .+?(?=\\\])/g, '$1.*?') + '$'
    );

    /** Native method references. */
    var ArrayBuffer = isNative(ArrayBuffer = context.ArrayBuffer) && ArrayBuffer,
        bufferSlice = isNative(bufferSlice = ArrayBuffer && new ArrayBuffer(0).slice) && bufferSlice,
        ceil = Math.ceil,
        clearTimeout = context.clearTimeout,
        floor = Math.floor,
        getOwnPropertySymbols = isNative(getOwnPropertySymbols = Object.getOwnPropertySymbols) && getOwnPropertySymbols,
        getPrototypeOf = isNative(getPrototypeOf = Object.getPrototypeOf) && getPrototypeOf,
        push = arrayProto.push,
        preventExtensions = isNative(Object.preventExtensions = Object.preventExtensions) && preventExtensions,
        propertyIsEnumerable = objectProto.propertyIsEnumerable,
        Set = isNative(Set = context.Set) && Set,
        setTimeout = context.setTimeout,
        splice = arrayProto.splice,
        Uint8Array = isNative(Uint8Array = context.Uint8Array) && Uint8Array,
        WeakMap = isNative(WeakMap = context.WeakMap) && WeakMap;

    /** Used to clone array buffers. */
    var Float64Array = (function() {
      // Safari 5 errors when using an array buffer to initialize a typed array
      // where the array buffer's `byteLength` is not a multiple of the typed
      // array's `BYTES_PER_ELEMENT`.
      try {
        var func = isNative(func = context.Float64Array) && func,
            result = new func(new ArrayBuffer(10), 0, 1) && func;
      } catch(e) {}
      return result;
    }());

    /** Used as `baseAssign`. */
    var nativeAssign = (function() {
      // Avoid `Object.assign` in Firefox 34-37 which have an early implementation
      // with a now defunct try/catch behavior. See https://bugzilla.mozilla.org/show_bug.cgi?id=1103344
      // for more details.
      //
      // Use `Object.preventExtensions` on a plain object instead of simply using
      // `Object('x')` because Chrome and IE fail to throw an error when attempting
      // to assign values to readonly indexes of strings in strict mode.
      var object = { '1': 0 },
          func = preventExtensions && isNative(func = Object.assign) && func;

      try { func(preventExtensions(object), 'xo'); } catch(e) {}
      return !object[1] && func;
    }());

    /* Native method references for those with the same name as other `lodash` methods. */
    var nativeIsArray = isNative(nativeIsArray = Array.isArray) && nativeIsArray,
        nativeCreate = isNative(nativeCreate = Object.create) && nativeCreate,
        nativeIsFinite = context.isFinite,
        nativeKeys = isNative(nativeKeys = Object.keys) && nativeKeys,
        nativeMax = Math.max,
        nativeMin = Math.min,
        nativeNow = isNative(nativeNow = Date.now) && nativeNow,
        nativeNumIsFinite = isNative(nativeNumIsFinite = Number.isFinite) && nativeNumIsFinite,
        nativeParseInt = context.parseInt,
        nativeRandom = Math.random;

    /** Used as references for `-Infinity` and `Infinity`. */
    var NEGATIVE_INFINITY = Number.NEGATIVE_INFINITY,
        POSITIVE_INFINITY = Number.POSITIVE_INFINITY;

    /** Used as references for the maximum length and index of an array. */
    var MAX_ARRAY_LENGTH = Math.pow(2, 32) - 1,
        MAX_ARRAY_INDEX =  MAX_ARRAY_LENGTH - 1,
        HALF_MAX_ARRAY_LENGTH = MAX_ARRAY_LENGTH >>> 1;

    /** Used as the size, in bytes, of each `Float64Array` element. */
    var FLOAT64_BYTES_PER_ELEMENT = Float64Array ? Float64Array.BYTES_PER_ELEMENT : 0;

    /**
     * Used as the [maximum length](https://people.mozilla.org/~jorendorff/es6-draft.html#sec-number.max_safe_integer)
     * of an array-like value.
     */
    var MAX_SAFE_INTEGER = Math.pow(2, 53) - 1;

    /** Used to store function metadata. */
    var metaMap = WeakMap && new WeakMap;

    /** Used to lookup unminified function names. */
    var realNames = {};

    /*------------------------------------------------------------------------*/

    /**
     * Creates a `lodash` object which wraps `value` to enable implicit chaining.
     * Methods that operate on and return arrays, collections, and functions can
     * be chained together. Methods that return a boolean or single value will
     * automatically end the chain returning the unwrapped value. Explicit chaining
     * may be enabled using `_.chain`. The execution of chained methods is lazy,
     * that is, execution is deferred until `_#value` is implicitly or explicitly
     * called.
     *
     * Lazy evaluation allows several methods to support shortcut fusion. Shortcut
     * fusion is an optimization that merges iteratees to avoid creating intermediate
     * arrays and reduce the number of iteratee executions.
     *
     * Chaining is supported in custom builds as long as the `_#value` method is
     * directly or indirectly included in the build.
     *
     * In addition to lodash methods, wrappers have `Array` and `String` methods.
     *
     * The wrapper `Array` methods are:
     * `concat`, `join`, `pop`, `push`, `reverse`, `shift`, `slice`, `sort`,
     * `splice`, and `unshift`
     *
     * The wrapper `String` methods are:
     * `replace` and `split`
     *
     * The wrapper methods that support shortcut fusion are:
     * `compact`, `drop`, `dropRight`, `dropRightWhile`, `dropWhile`, `filter`,
     * `first`, `initial`, `last`, `map`, `pluck`, `reject`, `rest`, `reverse`,
     * `slice`, `take`, `takeRight`, `takeRightWhile`, `takeWhile`, `toArray`,
     * and `where`
     *
     * The chainable wrapper methods are:
     * `after`, `ary`, `assign`, `at`, `before`, `bind`, `bindAll`, `bindKey`,
     * `callback`, `chain`, `chunk`, `commit`, `compact`, `concat`, `constant`,
     * `countBy`, `create`, `curry`, `debounce`, `defaults`, `defer`, `delay`,
     * `difference`, `drop`, `dropRight`, `dropRightWhile`, `dropWhile`, `fill`,
     * `filter`, `flatten`, `flattenDeep`, `flow`, `flowRight`, `forEach`,
     * `forEachRight`, `forIn`, `forInRight`, `forOwn`, `forOwnRight`, `functions`,
     * `groupBy`, `indexBy`, `initial`, `intersection`, `invert`, `invoke`, `keys`,
     * `keysIn`, `map`, `mapValues`, `matches`, `matchesProperty`, `memoize`,
     * `merge`, `mixin`, `negate`, `omit`, `once`, `pairs`, `partial`, `partialRight`,
     * `partition`, `pick`, `plant`, `pluck`, `property`, `propertyOf`, `pull`,
     * `pullAt`, `push`, `range`, `rearg`, `reject`, `remove`, `rest`, `reverse`,
     * `shuffle`, `slice`, `sort`, `sortBy`, `sortByAll`, `sortByOrder`, `splice`,
     * `spread`, `take`, `takeRight`, `takeRightWhile`, `takeWhile`, `tap`,
     * `throttle`, `thru`, `times`, `toArray`, `toPlainObject`, `transform`,
     * `union`, `uniq`, `unshift`, `unzip`, `values`, `valuesIn`, `where`,
     * `without`, `wrap`, `xor`, `zip`, and `zipObject`
     *
     * The wrapper methods that are **not** chainable by default are:
     * `add`, `attempt`, `camelCase`, `capitalize`, `clone`, `cloneDeep`, `deburr`,
     * `endsWith`, `escape`, `escapeRegExp`, `every`, `find`, `findIndex`, `findKey`,
     * `findLast`, `findLastIndex`, `findLastKey`, `findWhere`, `first`, `has`,
     * `identity`, `includes`, `indexOf`, `inRange`, `isArguments`, `isArray`,
     * `isBoolean`, `isDate`, `isElement`, `isEmpty`, `isEqual`, `isError`, `isFinite`
     * `isFunction`, `isMatch`, `isNative`, `isNaN`, `isNull`, `isNumber`, `isObject`,
     * `isPlainObject`, `isRegExp`, `isString`, `isUndefined`, `isTypedArray`,
     * `join`, `kebabCase`, `last`, `lastIndexOf`, `max`, `min`, `noConflict`,
     * `noop`, `now`, `pad`, `padLeft`, `padRight`, `parseInt`, `pop`, `random`,
     * `reduce`, `reduceRight`, `repeat`, `result`, `runInContext`, `shift`, `size`,
     * `snakeCase`, `some`, `sortedIndex`, `sortedLastIndex`, `startCase`, `startsWith`,
     * `sum`, `template`, `trim`, `trimLeft`, `trimRight`, `trunc`, `unescape`,
     * `uniqueId`, `value`, and `words`
     *
     * The wrapper method `sample` will return a wrapped value when `n` is provided,
     * otherwise an unwrapped value is returned.
     *
     * @name _
     * @constructor
     * @category Chain
     * @param {*} value The value to wrap in a `lodash` instance.
     * @returns {Object} Returns the new `lodash` wrapper instance.
     * @example
     *
     * var wrapped = _([1, 2, 3]);
     *
     * // returns an unwrapped value
     * wrapped.reduce(function(total, n) {
     *   return total + n;
     * });
     * // => 6
     *
     * // returns a wrapped value
     * var squares = wrapped.map(function(n) {
     *   return n * n;
     * });
     *
     * _.isArray(squares);
     * // => false
     *
     * _.isArray(squares.value());
     * // => true
     */
    function lodash(value) {
      if (isObjectLike(value) && !isArray(value) && !(value instanceof LazyWrapper)) {
        if (value instanceof LodashWrapper) {
          return value;
        }
        if (hasOwnProperty.call(value, '__chain__') && hasOwnProperty.call(value, '__wrapped__')) {
          return wrapperClone(value);
        }
      }
      return new LodashWrapper(value);
    }

    /**
     * The function whose prototype all chaining wrappers inherit from.
     *
     * @private
     */
    function baseLodash() {
      // No operation performed.
    }

    /**
     * The base constructor for creating `lodash` wrapper objects.
     *
     * @private
     * @param {*} value The value to wrap.
     * @param {boolean} [chainAll] Enable chaining for all wrapper methods.
     * @param {Array} [actions=[]] Actions to peform to resolve the unwrapped value.
     */
    function LodashWrapper(value, chainAll, actions) {
      this.__wrapped__ = value;
      this.__actions__ = actions || [];
      this.__chain__ = !!chainAll;
    }

    /**
     * An object environment feature flags.
     *
     * @static
     * @memberOf _
     * @type Object
     */
    var support = lodash.support = {};

    (function(x) {
      var Ctor = function() { this.x = x; },
          object = { '0': x, 'length': x },
          props = [];

      Ctor.prototype = { 'valueOf': x, 'y': x };
      for (var key in new Ctor) { props.push(key); }

      /**
       * Detect if functions can be decompiled by `Function#toString`
       * (all but Firefox OS certified apps, older Opera mobile browsers, and
       * the PlayStation 3; forced `false` for Windows 8 apps).
       *
       * @memberOf _.support
       * @type boolean
       */
      support.funcDecomp = /\bthis\b/.test(function() { return this; });

      /**
       * Detect if `Function#name` is supported (all but IE).
       *
       * @memberOf _.support
       * @type boolean
       */
      support.funcNames = typeof Function.name == 'string';

      /**
       * Detect if the DOM is supported.
       *
       * @memberOf _.support
       * @type boolean
       */
      try {
        support.dom = document.createDocumentFragment().nodeType === 11;
      } catch(e) {
        support.dom = false;
      }

      /**
       * Detect if `arguments` object indexes are non-enumerable.
       *
       * In Firefox < 4, IE < 9, PhantomJS, and Safari < 5.1 `arguments` object
       * indexes are non-enumerable. Chrome < 25 and Node.js < 0.11.0 treat
       * `arguments` object indexes as non-enumerable and fail `hasOwnProperty`
       * checks for indexes that exceed the number of function parameters and
       * whose associated argument values are `0`.
       *
       * @memberOf _.support
       * @type boolean
       */
      try {
        support.nonEnumArgs = !propertyIsEnumerable.call(arguments, 1);
      } catch(e) {
        support.nonEnumArgs = true;
      }
    }(1, 0));

    /**
     * By default, the template delimiters used by lodash are like those in
     * embedded Ruby (ERB). Change the following template settings to use
     * alternative delimiters.
     *
     * @static
     * @memberOf _
     * @type Object
     */
    lodash.templateSettings = {

      /**
       * Used to detect `data` property values to be HTML-escaped.
       *
       * @memberOf _.templateSettings
       * @type RegExp
       */
      'escape': reEscape,

      /**
       * Used to detect code to be evaluated.
       *
       * @memberOf _.templateSettings
       * @type RegExp
       */
      'evaluate': reEvaluate,

      /**
       * Used to detect `data` property values to inject.
       *
       * @memberOf _.templateSettings
       * @type RegExp
       */
      'interpolate': reInterpolate,

      /**
       * Used to reference the data object in the template text.
       *
       * @memberOf _.templateSettings
       * @type string
       */
      'variable': '',

      /**
       * Used to import variables into the compiled template.
       *
       * @memberOf _.templateSettings
       * @type Object
       */
      'imports': {

        /**
         * A reference to the `lodash` function.
         *
         * @memberOf _.templateSettings.imports
         * @type Function
         */
        '_': lodash
      }
    };

    /*------------------------------------------------------------------------*/

    /**
     * Creates a lazy wrapper object which wraps `value` to enable lazy evaluation.
     *
     * @private
     * @param {*} value The value to wrap.
     */
    function LazyWrapper(value) {
      this.__wrapped__ = value;
      this.__actions__ = null;
      this.__dir__ = 1;
      this.__dropCount__ = 0;
      this.__filtered__ = false;
      this.__iteratees__ = null;
      this.__takeCount__ = POSITIVE_INFINITY;
      this.__views__ = null;
    }

    /**
     * Creates a clone of the lazy wrapper object.
     *
     * @private
     * @name clone
     * @memberOf LazyWrapper
     * @returns {Object} Returns the cloned `LazyWrapper` object.
     */
    function lazyClone() {
      var actions = this.__actions__,
          iteratees = this.__iteratees__,
          views = this.__views__,
          result = new LazyWrapper(this.__wrapped__);

      result.__actions__ = actions ? arrayCopy(actions) : null;
      result.__dir__ = this.__dir__;
      result.__filtered__ = this.__filtered__;
      result.__iteratees__ = iteratees ? arrayCopy(iteratees) : null;
      result.__takeCount__ = this.__takeCount__;
      result.__views__ = views ? arrayCopy(views) : null;
      return result;
    }

    /**
     * Reverses the direction of lazy iteration.
     *
     * @private
     * @name reverse
     * @memberOf LazyWrapper
     * @returns {Object} Returns the new reversed `LazyWrapper` object.
     */
    function lazyReverse() {
      if (this.__filtered__) {
        var result = new LazyWrapper(this);
        result.__dir__ = -1;
        result.__filtered__ = true;
      } else {
        result = this.clone();
        result.__dir__ *= -1;
      }
      return result;
    }

    /**
     * Extracts the unwrapped value from its lazy wrapper.
     *
     * @private
     * @name value
     * @memberOf LazyWrapper
     * @returns {*} Returns the unwrapped value.
     */
    function lazyValue() {
      var array = this.__wrapped__.value();
      if (!isArray(array)) {
        return baseWrapperValue(array, this.__actions__);
      }
      var dir = this.__dir__,
          isRight = dir < 0,
          view = getView(0, array.length, this.__views__),
          start = view.start,
          end = view.end,
          length = end - start,
          index = isRight ? end : (start - 1),
          takeCount = nativeMin(length, this.__takeCount__),
          iteratees = this.__iteratees__,
          iterLength = iteratees ? iteratees.length : 0,
          resIndex = 0,
          result = [];

      outer:
      while (length-- && resIndex < takeCount) {
        index += dir;

        var iterIndex = -1,
            value = array[index];

        while (++iterIndex < iterLength) {
          var data = iteratees[iterIndex],
              iteratee = data.iteratee,
              type = data.type;

          if (type == LAZY_DROP_WHILE_FLAG) {
            if (data.done && (isRight ? (index > data.index) : (index < data.index))) {
              data.count = 0;
              data.done = false;
            }
            data.index = index;
            if (!data.done) {
              var limit = data.limit;
              if (!(data.done = limit > -1 ? (data.count++ >= limit) : !iteratee(value))) {
                continue outer;
              }
            }
          } else {
            var computed = iteratee(value);
            if (type == LAZY_MAP_FLAG) {
              value = computed;
            } else if (!computed) {
              if (type == LAZY_FILTER_FLAG) {
                continue outer;
              } else {
                break outer;
              }
            }
          }
        }
        result[resIndex++] = value;
      }
      return result;
    }

    /*------------------------------------------------------------------------*/

    /**
     * Creates a cache object to store key/value pairs.
     *
     * @private
     * @static
     * @name Cache
     * @memberOf _.memoize
     */
    function MapCache() {
      this.__data__ = {};
    }

    /**
     * Removes `key` and its value from the cache.
     *
     * @private
     * @name delete
     * @memberOf _.memoize.Cache
     * @param {string} key The key of the value to remove.
     * @returns {boolean} Returns `true` if the entry was removed successfully, else `false`.
     */
    function mapDelete(key) {
      return this.has(key) && delete this.__data__[key];
    }

    /**
     * Gets the cached value for `key`.
     *
     * @private
     * @name get
     * @memberOf _.memoize.Cache
     * @param {string} key The key of the value to get.
     * @returns {*} Returns the cached value.
     */
    function mapGet(key) {
      return key == '__proto__' ? undefined : this.__data__[key];
    }

    /**
     * Checks if a cached value for `key` exists.
     *
     * @private
     * @name has
     * @memberOf _.memoize.Cache
     * @param {string} key The key of the entry to check.
     * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
     */
    function mapHas(key) {
      return key != '__proto__' && hasOwnProperty.call(this.__data__, key);
    }

    /**
     * Sets `value` to `key` of the cache.
     *
     * @private
     * @name set
     * @memberOf _.memoize.Cache
     * @param {string} key The key of the value to cache.
     * @param {*} value The value to cache.
     * @returns {Object} Returns the cache object.
     */
    function mapSet(key, value) {
      if (key != '__proto__') {
        this.__data__[key] = value;
      }
      return this;
    }

    /*------------------------------------------------------------------------*/

    /**
     *
     * Creates a cache object to store unique values.
     *
     * @private
     * @param {Array} [values] The values to cache.
     */
    function SetCache(values) {
      var length = values ? values.length : 0;

      this.data = { 'hash': nativeCreate(null), 'set': new Set };
      while (length--) {
        this.push(values[length]);
      }
    }

    /**
     * Checks if `value` is in `cache` mimicking the return signature of
     * `_.indexOf` by returning `0` if the value is found, else `-1`.
     *
     * @private
     * @param {Object} cache The cache to search.
     * @param {*} value The value to search for.
     * @returns {number} Returns `0` if `value` is found, else `-1`.
     */
    function cacheIndexOf(cache, value) {
      var data = cache.data,
          result = (typeof value == 'string' || isObject(value)) ? data.set.has(value) : data.hash[value];

      return result ? 0 : -1;
    }

    /**
     * Adds `value` to the cache.
     *
     * @private
     * @name push
     * @memberOf SetCache
     * @param {*} value The value to cache.
     */
    function cachePush(value) {
      var data = this.data;
      if (typeof value == 'string' || isObject(value)) {
        data.set.add(value);
      } else {
        data.hash[value] = true;
      }
    }

    /*------------------------------------------------------------------------*/

    /**
     * Copies the values of `source` to `array`.
     *
     * @private
     * @param {Array} source The array to copy values from.
     * @param {Array} [array=[]] The array to copy values to.
     * @returns {Array} Returns `array`.
     */
    function arrayCopy(source, array) {
      var index = -1,
          length = source.length;

      array || (array = Array(length));
      while (++index < length) {
        array[index] = source[index];
      }
      return array;
    }

    /**
     * A specialized version of `_.forEach` for arrays without support for callback
     * shorthands and `this` binding.
     *
     * @private
     * @param {Array} array The array to iterate over.
     * @param {Function} iteratee The function invoked per iteration.
     * @returns {Array} Returns `array`.
     */
    function arrayEach(array, iteratee) {
      var index = -1,
          length = array.length;

      while (++index < length) {
        if (iteratee(array[index], index, array) === false) {
          break;
        }
      }
      return array;
    }

    /**
     * A specialized version of `_.forEachRight` for arrays without support for
     * callback shorthands and `this` binding.
     *
     * @private
     * @param {Array} array The array to iterate over.
     * @param {Function} iteratee The function invoked per iteration.
     * @returns {Array} Returns `array`.
     */
    function arrayEachRight(array, iteratee) {
      var length = array.length;

      while (length--) {
        if (iteratee(array[length], length, array) === false) {
          break;
        }
      }
      return array;
    }

    /**
     * A specialized version of `_.every` for arrays without support for callback
     * shorthands and `this` binding.
     *
     * @private
     * @param {Array} array The array to iterate over.
     * @param {Function} predicate The function invoked per iteration.
     * @returns {boolean} Returns `true` if all elements pass the predicate check,
     *  else `false`.
     */
    function arrayEvery(array, predicate) {
      var index = -1,
          length = array.length;

      while (++index < length) {
        if (!predicate(array[index], index, array)) {
          return false;
        }
      }
      return true;
    }

    /**
     * A specialized version of `_.filter` for arrays without support for callback
     * shorthands and `this` binding.
     *
     * @private
     * @param {Array} array The array to iterate over.
     * @param {Function} predicate The function invoked per iteration.
     * @returns {Array} Returns the new filtered array.
     */
    function arrayFilter(array, predicate) {
      var index = -1,
          length = array.length,
          resIndex = -1,
          result = [];

      while (++index < length) {
        var value = array[index];
        if (predicate(value, index, array)) {
          result[++resIndex] = value;
        }
      }
      return result;
    }

    /**
     * A specialized version of `_.map` for arrays without support for callback
     * shorthands and `this` binding.
     *
     * @private
     * @param {Array} array The array to iterate over.
     * @param {Function} iteratee The function invoked per iteration.
     * @returns {Array} Returns the new mapped array.
     */
    function arrayMap(array, iteratee) {
      var index = -1,
          length = array.length,
          result = Array(length);

      while (++index < length) {
        result[index] = iteratee(array[index], index, array);
      }
      return result;
    }

    /**
     * A specialized version of `_.max` for arrays without support for iteratees.
     *
     * @private
     * @param {Array} array The array to iterate over.
     * @returns {*} Returns the maximum value.
     */
    function arrayMax(array) {
      var index = -1,
          length = array.length,
          result = NEGATIVE_INFINITY;

      while (++index < length) {
        var value = array[index];
        if (value > result) {
          result = value;
        }
      }
      return result;
    }

    /**
     * A specialized version of `_.min` for arrays without support for iteratees.
     *
     * @private
     * @param {Array} array The array to iterate over.
     * @returns {*} Returns the minimum value.
     */
    function arrayMin(array) {
      var index = -1,
          length = array.length,
          result = POSITIVE_INFINITY;

      while (++index < length) {
        var value = array[index];
        if (value < result) {
          result = value;
        }
      }
      return result;
    }

    /**
     * A specialized version of `_.reduce` for arrays without support for callback
     * shorthands and `this` binding.
     *
     * @private
     * @param {Array} array The array to iterate over.
     * @param {Function} iteratee The function invoked per iteration.
     * @param {*} [accumulator] The initial value.
     * @param {boolean} [initFromArray] Specify using the first element of `array`
     *  as the initial value.
     * @returns {*} Returns the accumulated value.
     */
    function arrayReduce(array, iteratee, accumulator, initFromArray) {
      var index = -1,
          length = array.length;

      if (initFromArray && length) {
        accumulator = array[++index];
      }
      while (++index < length) {
        accumulator = iteratee(accumulator, array[index], index, array);
      }
      return accumulator;
    }

    /**
     * A specialized version of `_.reduceRight` for arrays without support for
     * callback shorthands and `this` binding.
     *
     * @private
     * @param {Array} array The array to iterate over.
     * @param {Function} iteratee The function invoked per iteration.
     * @param {*} [accumulator] The initial value.
     * @param {boolean} [initFromArray] Specify using the last element of `array`
     *  as the initial value.
     * @returns {*} Returns the accumulated value.
     */
    function arrayReduceRight(array, iteratee, accumulator, initFromArray) {
      var length = array.length;
      if (initFromArray && length) {
        accumulator = array[--length];
      }
      while (length--) {
        accumulator = iteratee(accumulator, array[length], length, array);
      }
      return accumulator;
    }

    /**
     * A specialized version of `_.some` for arrays without support for callback
     * shorthands and `this` binding.
     *
     * @private
     * @param {Array} array The array to iterate over.
     * @param {Function} predicate The function invoked per iteration.
     * @returns {boolean} Returns `true` if any element passes the predicate check,
     *  else `false`.
     */
    function arraySome(array, predicate) {
      var index = -1,
          length = array.length;

      while (++index < length) {
        if (predicate(array[index], index, array)) {
          return true;
        }
      }
      return false;
    }

    /**
     * A specialized version of `_.sum` for arrays without support for iteratees.
     *
     * @private
     * @param {Array} array The array to iterate over.
     * @returns {number} Returns the sum.
     */
    function arraySum(array) {
      var length = array.length,
          result = 0;

      while (length--) {
        result += +array[length] || 0;
      }
      return result;
    }

    /**
     * Used by `_.defaults` to customize its `_.assign` use.
     *
     * @private
     * @param {*} objectValue The destination object property value.
     * @param {*} sourceValue The source object property value.
     * @returns {*} Returns the value to assign to the destination object.
     */
    function assignDefaults(objectValue, sourceValue) {
      return objectValue === undefined ? sourceValue : objectValue;
    }

    /**
     * Used by `_.template` to customize its `_.assign` use.
     *
     * **Note:** This function is like `assignDefaults` except that it ignores
     * inherited property values when checking if a property is `undefined`.
     *
     * @private
     * @param {*} objectValue The destination object property value.
     * @param {*} sourceValue The source object property value.
     * @param {string} key The key associated with the object and source values.
     * @param {Object} object The destination object.
     * @returns {*} Returns the value to assign to the destination object.
     */
    function assignOwnDefaults(objectValue, sourceValue, key, object) {
      return (objectValue === undefined || !hasOwnProperty.call(object, key))
        ? sourceValue
        : objectValue;
    }

    /**
     * A specialized version of `_.assign` for customizing assigned values without
     * support for argument juggling, multiple sources, and `this` binding `customizer`
     * functions.
     *
     * @private
     * @param {Object} object The destination object.
     * @param {Object} source The source object.
     * @param {Function} customizer The function to customize assigned values.
     * @returns {Object} Returns `object`.
     */
    function assignWith(object, source, customizer) {
      var props = keys(source);
      push.apply(props, getSymbols(source));

      var index = -1,
          length = props.length;

      while (++index < length) {
        var key = props[index],
            value = object[key],
            result = customizer(value, source[key], key, object, source);

        if ((result === result ? (result !== value) : (value === value)) ||
            (value === undefined && !(key in object))) {
          object[key] = result;
        }
      }
      return object;
    }

    /**
     * The base implementation of `_.assign` without support for argument juggling,
     * multiple sources, and `customizer` functions.
     *
     * @private
     * @param {Object} object The destination object.
     * @param {Object} source The source object.
     * @returns {Object} Returns `object`.
     */
    var baseAssign = nativeAssign || function(object, source) {
      return source == null
        ? object
        : baseCopy(source, getSymbols(source), baseCopy(source, keys(source), object));
    };

    /**
     * The base implementation of `_.at` without support for string collections
     * and individual key arguments.
     *
     * @private
     * @param {Array|Object} collection The collection to iterate over.
     * @param {number[]|string[]} props The property names or indexes of elements to pick.
     * @returns {Array} Returns the new array of picked elements.
     */
    function baseAt(collection, props) {
      var index = -1,
          length = collection.length,
          isArr = isLength(length),
          propsLength = props.length,
          result = Array(propsLength);

      while(++index < propsLength) {
        var key = props[index];
        if (isArr) {
          result[index] = isIndex(key, length) ? collection[key] : undefined;
        } else {
          result[index] = collection[key];
        }
      }
      return result;
    }

    /**
     * Copies properties of `source` to `object`.
     *
     * @private
     * @param {Object} source The object to copy properties from.
     * @param {Array} props The property names to copy.
     * @param {Object} [object={}] The object to copy properties to.
     * @returns {Object} Returns `object`.
     */
    function baseCopy(source, props, object) {
      object || (object = {});

      var index = -1,
          length = props.length;

      while (++index < length) {
        var key = props[index];
        object[key] = source[key];
      }
      return object;
    }

    /**
     * The base implementation of `_.callback` which supports specifying the
     * number of arguments to provide to `func`.
     *
     * @private
     * @param {*} [func=_.identity] The value to convert to a callback.
     * @param {*} [thisArg] The `this` binding of `func`.
     * @param {number} [argCount] The number of arguments to provide to `func`.
     * @returns {Function} Returns the callback.
     */
    function baseCallback(func, thisArg, argCount) {
      var type = typeof func;
      if (type == 'function') {
        return thisArg === undefined
          ? func
          : bindCallback(func, thisArg, argCount);
      }
      if (func == null) {
        return identity;
      }
      if (type == 'object') {
        return baseMatches(func);
      }
      return thisArg === undefined
        ? property(func)
        : baseMatchesProperty(func, thisArg);
    }

    /**
     * The base implementation of `_.clone` without support for argument juggling
     * and `this` binding `customizer` functions.
     *
     * @private
     * @param {*} value The value to clone.
     * @param {boolean} [isDeep] Specify a deep clone.
     * @param {Function} [customizer] The function to customize cloning values.
     * @param {string} [key] The key of `value`.
     * @param {Object} [object] The object `value` belongs to.
     * @param {Array} [stackA=[]] Tracks traversed source objects.
     * @param {Array} [stackB=[]] Associates clones with source counterparts.
     * @returns {*} Returns the cloned value.
     */
    function baseClone(value, isDeep, customizer, key, object, stackA, stackB) {
      var result;
      if (customizer) {
        result = object ? customizer(value, key, object) : customizer(value);
      }
      if (result !== undefined) {
        return result;
      }
      if (!isObject(value)) {
        return value;
      }
      var isArr = isArray(value);
      if (isArr) {
        result = initCloneArray(value);
        if (!isDeep) {
          return arrayCopy(value, result);
        }
      } else {
        var tag = objToString.call(value),
            isFunc = tag == funcTag;

        if (tag == objectTag || tag == argsTag || (isFunc && !object)) {
          result = initCloneObject(isFunc ? {} : value);
          if (!isDeep) {
            return baseAssign(result, value);
          }
        } else {
          return cloneableTags[tag]
            ? initCloneByTag(value, tag, isDeep)
            : (object ? value : {});
        }
      }
      // Check for circular references and return corresponding clone.
      stackA || (stackA = []);
      stackB || (stackB = []);

      var length = stackA.length;
      while (length--) {
        if (stackA[length] == value) {
          return stackB[length];
        }
      }
      // Add the source value to the stack of traversed objects and associate it with its clone.
      stackA.push(value);
      stackB.push(result);

      // Recursively populate clone (susceptible to call stack limits).
      (isArr ? arrayEach : baseForOwn)(value, function(subValue, key) {
        result[key] = baseClone(subValue, isDeep, customizer, key, value, stackA, stackB);
      });
      return result;
    }

    /**
     * The base implementation of `_.create` without support for assigning
     * properties to the created object.
     *
     * @private
     * @param {Object} prototype The object to inherit from.
     * @returns {Object} Returns the new object.
     */
    var baseCreate = (function() {
      function Object() {}
      return function(prototype) {
        if (isObject(prototype)) {
          Object.prototype = prototype;
          var result = new Object;
          Object.prototype = null;
        }
        return result || context.Object();
      };
    }());

    /**
     * The base implementation of `_.delay` and `_.defer` which accepts an index
     * of where to slice the arguments to provide to `func`.
     *
     * @private
     * @param {Function} func The function to delay.
     * @param {number} wait The number of milliseconds to delay invocation.
     * @param {Object} args The arguments provide to `func`.
     * @returns {number} Returns the timer id.
     */
    function baseDelay(func, wait, args) {
      if (typeof func != 'function') {
        throw new TypeError(FUNC_ERROR_TEXT);
      }
      return setTimeout(function() { func.apply(undefined, args); }, wait);
    }

    /**
     * The base implementation of `_.difference` which accepts a single array
     * of values to exclude.
     *
     * @private
     * @param {Array} array The array to inspect.
     * @param {Array} values The values to exclude.
     * @returns {Array} Returns the new array of filtered values.
     */
    function baseDifference(array, values) {
      var length = array ? array.length : 0,
          result = [];

      if (!length) {
        return result;
      }
      var index = -1,
          indexOf = getIndexOf(),
          isCommon = indexOf == baseIndexOf,
          cache = (isCommon && values.length >= 200) ? createCache(values) : null,
          valuesLength = values.length;

      if (cache) {
        indexOf = cacheIndexOf;
        isCommon = false;
        values = cache;
      }
      outer:
      while (++index < length) {
        var value = array[index];

        if (isCommon && value === value) {
          var valuesIndex = valuesLength;
          while (valuesIndex--) {
            if (values[valuesIndex] === value) {
              continue outer;
            }
          }
          result.push(value);
        }
        else if (indexOf(values, value, 0) < 0) {
          result.push(value);
        }
      }
      return result;
    }

    /**
     * The base implementation of `_.forEach` without support for callback
     * shorthands and `this` binding.
     *
     * @private
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function} iteratee The function invoked per iteration.
     * @returns {Array|Object|string} Returns `collection`.
     */
    var baseEach = createBaseEach(baseForOwn);

    /**
     * The base implementation of `_.forEachRight` without support for callback
     * shorthands and `this` binding.
     *
     * @private
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function} iteratee The function invoked per iteration.
     * @returns {Array|Object|string} Returns `collection`.
     */
    var baseEachRight = createBaseEach(baseForOwnRight, true);

    /**
     * The base implementation of `_.every` without support for callback
     * shorthands and `this` binding.
     *
     * @private
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function} predicate The function invoked per iteration.
     * @returns {boolean} Returns `true` if all elements pass the predicate check,
     *  else `false`
     */
    function baseEvery(collection, predicate) {
      var result = true;
      baseEach(collection, function(value, index, collection) {
        result = !!predicate(value, index, collection);
        return result;
      });
      return result;
    }

    /**
     * The base implementation of `_.fill` without an iteratee call guard.
     *
     * @private
     * @param {Array} array The array to fill.
     * @param {*} value The value to fill `array` with.
     * @param {number} [start=0] The start position.
     * @param {number} [end=array.length] The end position.
     * @returns {Array} Returns `array`.
     */
    function baseFill(array, value, start, end) {
      var length = array.length;

      start = start == null ? 0 : (+start || 0);
      if (start < 0) {
        start = -start > length ? 0 : (length + start);
      }
      end = (end === undefined || end > length) ? length : (+end || 0);
      if (end < 0) {
        end += length;
      }
      length = start > end ? 0 : (end >>> 0);
      start >>>= 0;

      while (start < length) {
        array[start++] = value;
      }
      return array;
    }

    /**
     * The base implementation of `_.filter` without support for callback
     * shorthands and `this` binding.
     *
     * @private
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function} predicate The function invoked per iteration.
     * @returns {Array} Returns the new filtered array.
     */
    function baseFilter(collection, predicate) {
      var result = [];
      baseEach(collection, function(value, index, collection) {
        if (predicate(value, index, collection)) {
          result.push(value);
        }
      });
      return result;
    }

    /**
     * The base implementation of `_.find`, `_.findLast`, `_.findKey`, and `_.findLastKey`,
     * without support for callback shorthands and `this` binding, which iterates
     * over `collection` using the provided `eachFunc`.
     *
     * @private
     * @param {Array|Object|string} collection The collection to search.
     * @param {Function} predicate The function invoked per iteration.
     * @param {Function} eachFunc The function to iterate over `collection`.
     * @param {boolean} [retKey] Specify returning the key of the found element
     *  instead of the element itself.
     * @returns {*} Returns the found element or its key, else `undefined`.
     */
    function baseFind(collection, predicate, eachFunc, retKey) {
      var result;
      eachFunc(collection, function(value, key, collection) {
        if (predicate(value, key, collection)) {
          result = retKey ? key : value;
          return false;
        }
      });
      return result;
    }

    /**
     * The base implementation of `_.flatten` with added support for restricting
     * flattening and specifying the start index.
     *
     * @private
     * @param {Array} array The array to flatten.
     * @param {boolean} isDeep Specify a deep flatten.
     * @param {boolean} isStrict Restrict flattening to arrays and `arguments` objects.
     * @returns {Array} Returns the new flattened array.
     */
    function baseFlatten(array, isDeep, isStrict) {
      var index = -1,
          length = array.length,
          resIndex = -1,
          result = [];

      while (++index < length) {
        var value = array[index];

        if (isObjectLike(value) && isLength(value.length) && (isArray(value) || isArguments(value))) {
          if (isDeep) {
            // Recursively flatten arrays (susceptible to call stack limits).
            value = baseFlatten(value, isDeep, isStrict);
          }
          var valIndex = -1,
              valLength = value.length;

          result.length += valLength;
          while (++valIndex < valLength) {
            result[++resIndex] = value[valIndex];
          }
        } else if (!isStrict) {
          result[++resIndex] = value;
        }
      }
      return result;
    }

    /**
     * The base implementation of `baseForIn` and `baseForOwn` which iterates
     * over `object` properties returned by `keysFunc` invoking `iteratee` for
     * each property. Iteratee functions may exit iteration early by explicitly
     * returning `false`.
     *
     * @private
     * @param {Object} object The object to iterate over.
     * @param {Function} iteratee The function invoked per iteration.
     * @param {Function} keysFunc The function to get the keys of `object`.
     * @returns {Object} Returns `object`.
     */
    var baseFor = createBaseFor();

    /**
     * This function is like `baseFor` except that it iterates over properties
     * in the opposite order.
     *
     * @private
     * @param {Object} object The object to iterate over.
     * @param {Function} iteratee The function invoked per iteration.
     * @param {Function} keysFunc The function to get the keys of `object`.
     * @returns {Object} Returns `object`.
     */
    var baseForRight = createBaseFor(true);

    /**
     * The base implementation of `_.forIn` without support for callback
     * shorthands and `this` binding.
     *
     * @private
     * @param {Object} object The object to iterate over.
     * @param {Function} iteratee The function invoked per iteration.
     * @returns {Object} Returns `object`.
     */
    function baseForIn(object, iteratee) {
      return baseFor(object, iteratee, keysIn);
    }

    /**
     * The base implementation of `_.forOwn` without support for callback
     * shorthands and `this` binding.
     *
     * @private
     * @param {Object} object The object to iterate over.
     * @param {Function} iteratee The function invoked per iteration.
     * @returns {Object} Returns `object`.
     */
    function baseForOwn(object, iteratee) {
      return baseFor(object, iteratee, keys);
    }

    /**
     * The base implementation of `_.forOwnRight` without support for callback
     * shorthands and `this` binding.
     *
     * @private
     * @param {Object} object The object to iterate over.
     * @param {Function} iteratee The function invoked per iteration.
     * @returns {Object} Returns `object`.
     */
    function baseForOwnRight(object, iteratee) {
      return baseForRight(object, iteratee, keys);
    }

    /**
     * The base implementation of `_.functions` which creates an array of
     * `object` function property names filtered from those provided.
     *
     * @private
     * @param {Object} object The object to inspect.
     * @param {Array} props The property names to filter.
     * @returns {Array} Returns the new array of filtered property names.
     */
    function baseFunctions(object, props) {
      var index = -1,
          length = props.length,
          resIndex = -1,
          result = [];

      while (++index < length) {
        var key = props[index];
        if (isFunction(object[key])) {
          result[++resIndex] = key;
        }
      }
      return result;
    }

    /**
     * The base implementation of `get` without support for string paths
     * and default values.
     *
     * @private
     * @param {Object} object The object to query.
     * @param {Array} path The path of the property to get.
     * @param {string} [pathKey] The key representation of path.
     * @returns {*} Returns the resolved value.
     */
    function baseGet(object, path, pathKey) {
      if (object == null) {
        return;
      }
      if (pathKey !== undefined && pathKey in toObject(object)) {
        path = [pathKey];
      }
      var index = -1,
          length = path.length;

      while (object != null && ++index < length) {
        var result = object = object[path[index]];
      }
      return result;
    }

    /**
     * The base implementation of `_.isEqual` without support for `this` binding
     * `customizer` functions.
     *
     * @private
     * @param {*} value The value to compare.
     * @param {*} other The other value to compare.
     * @param {Function} [customizer] The function to customize comparing values.
     * @param {boolean} [isLoose] Specify performing partial comparisons.
     * @param {Array} [stackA] Tracks traversed `value` objects.
     * @param {Array} [stackB] Tracks traversed `other` objects.
     * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
     */
    function baseIsEqual(value, other, customizer, isLoose, stackA, stackB) {
      // Exit early for identical values.
      if (value === other) {
        // Treat `+0` vs. `-0` as not equal.
        return value !== 0 || (1 / value == 1 / other);
      }
      var valType = typeof value,
          othType = typeof other;

      // Exit early for unlike primitive values.
      if ((valType != 'function' && valType != 'object' && othType != 'function' && othType != 'object') ||
          value == null || other == null) {
        // Return `false` unless both values are `NaN`.
        return value !== value && other !== other;
      }
      return baseIsEqualDeep(value, other, baseIsEqual, customizer, isLoose, stackA, stackB);
    }

    /**
     * A specialized version of `baseIsEqual` for arrays and objects which performs
     * deep comparisons and tracks traversed objects enabling objects with circular
     * references to be compared.
     *
     * @private
     * @param {Object} object The object to compare.
     * @param {Object} other The other object to compare.
     * @param {Function} equalFunc The function to determine equivalents of values.
     * @param {Function} [customizer] The function to customize comparing objects.
     * @param {boolean} [isLoose] Specify performing partial comparisons.
     * @param {Array} [stackA=[]] Tracks traversed `value` objects.
     * @param {Array} [stackB=[]] Tracks traversed `other` objects.
     * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
     */
    function baseIsEqualDeep(object, other, equalFunc, customizer, isLoose, stackA, stackB) {
      var objIsArr = isArray(object),
          othIsArr = isArray(other),
          objTag = arrayTag,
          othTag = arrayTag;

      if (!objIsArr) {
        objTag = objToString.call(object);
        if (objTag == argsTag) {
          objTag = objectTag;
        } else if (objTag != objectTag) {
          objIsArr = isTypedArray(object);
        }
      }
      if (!othIsArr) {
        othTag = objToString.call(other);
        if (othTag == argsTag) {
          othTag = objectTag;
        } else if (othTag != objectTag) {
          othIsArr = isTypedArray(other);
        }
      }
      var objIsObj = objTag == objectTag,
          othIsObj = othTag == objectTag,
          isSameTag = objTag == othTag;

      if (isSameTag && !(objIsArr || objIsObj)) {
        return equalByTag(object, other, objTag);
      }
      if (!isLoose) {
        var valWrapped = objIsObj && hasOwnProperty.call(object, '__wrapped__'),
            othWrapped = othIsObj && hasOwnProperty.call(other, '__wrapped__');

        if (valWrapped || othWrapped) {
          return equalFunc(valWrapped ? object.value() : object, othWrapped ? other.value() : other, customizer, isLoose, stackA, stackB);
        }
      }
      if (!isSameTag) {
        return false;
      }
      // Assume cyclic values are equal.
      // For more information on detecting circular references see https://es5.github.io/#JO.
      stackA || (stackA = []);
      stackB || (stackB = []);

      var length = stackA.length;
      while (length--) {
        if (stackA[length] == object) {
          return stackB[length] == other;
        }
      }
      // Add `object` and `other` to the stack of traversed objects.
      stackA.push(object);
      stackB.push(other);

      var result = (objIsArr ? equalArrays : equalObjects)(object, other, equalFunc, customizer, isLoose, stackA, stackB);

      stackA.pop();
      stackB.pop();

      return result;
    }

    /**
     * The base implementation of `_.isMatch` without support for callback
     * shorthands and `this` binding.
     *
     * @private
     * @param {Object} object The object to inspect.
     * @param {Array} props The source property names to match.
     * @param {Array} values The source values to match.
     * @param {Array} strictCompareFlags Strict comparison flags for source values.
     * @param {Function} [customizer] The function to customize comparing objects.
     * @returns {boolean} Returns `true` if `object` is a match, else `false`.
     */
    function baseIsMatch(object, props, values, strictCompareFlags, customizer) {
      var index = -1,
          length = props.length,
          noCustomizer = !customizer;

      while (++index < length) {
        if ((noCustomizer && strictCompareFlags[index])
              ? values[index] !== object[props[index]]
              : !(props[index] in object)
            ) {
          return false;
        }
      }
      index = -1;
      while (++index < length) {
        var key = props[index],
            objValue = object[key],
            srcValue = values[index];

        if (noCustomizer && strictCompareFlags[index]) {
          var result = objValue !== undefined || (key in object);
        } else {
          result = customizer ? customizer(objValue, srcValue, key) : undefined;
          if (result === undefined) {
            result = baseIsEqual(srcValue, objValue, customizer, true);
          }
        }
        if (!result) {
          return false;
        }
      }
      return true;
    }

    /**
     * The base implementation of `_.map` without support for callback shorthands
     * and `this` binding.
     *
     * @private
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function} iteratee The function invoked per iteration.
     * @returns {Array} Returns the new mapped array.
     */
    function baseMap(collection, iteratee) {
      var index = -1,
          length = getLength(collection),
          result = isLength(length) ? Array(length) : [];

      baseEach(collection, function(value, key, collection) {
        result[++index] = iteratee(value, key, collection);
      });
      return result;
    }

    /**
     * The base implementation of `_.matches` which does not clone `source`.
     *
     * @private
     * @param {Object} source The object of property values to match.
     * @returns {Function} Returns the new function.
     */
    function baseMatches(source) {
      var props = keys(source),
          length = props.length;

      if (!length) {
        return constant(true);
      }
      if (length == 1) {
        var key = props[0],
            value = source[key];

        if (isStrictComparable(value)) {
          return function(object) {
            if (object == null) {
              return false;
            }
            return object[key] === value && (value !== undefined || (key in toObject(object)));
          };
        }
      }
      var values = Array(length),
          strictCompareFlags = Array(length);

      while (length--) {
        value = source[props[length]];
        values[length] = value;
        strictCompareFlags[length] = isStrictComparable(value);
      }
      return function(object) {
        return object != null && baseIsMatch(toObject(object), props, values, strictCompareFlags);
      };
    }

    /**
     * The base implementation of `_.matchesProperty` which does not which does
     * not clone `value`.
     *
     * @private
     * @param {string} path The path of the property to get.
     * @param {*} value The value to compare.
     * @returns {Function} Returns the new function.
     */
    function baseMatchesProperty(path, value) {
      var isArr = isArray(path),
          isCommon = isKey(path) && isStrictComparable(value),
          pathKey = (path + '');

      path = toPath(path);
      return function(object) {
        if (object == null) {
          return false;
        }
        var key = pathKey;
        object = toObject(object);
        if ((isArr || !isCommon) && !(key in object)) {
          object = path.length == 1 ? object : baseGet(object, baseSlice(path, 0, -1));
          if (object == null) {
            return false;
          }
          key = last(path);
          object = toObject(object);
        }
        return object[key] === value
          ? (value !== undefined || (key in object))
          : baseIsEqual(value, object[key], null, true);
      };
    }

    /**
     * The base implementation of `_.merge` without support for argument juggling,
     * multiple sources, and `this` binding `customizer` functions.
     *
     * @private
     * @param {Object} object The destination object.
     * @param {Object} source The source object.
     * @param {Function} [customizer] The function to customize merging properties.
     * @param {Array} [stackA=[]] Tracks traversed source objects.
     * @param {Array} [stackB=[]] Associates values with source counterparts.
     * @returns {Object} Returns `object`.
     */
    function baseMerge(object, source, customizer, stackA, stackB) {
      if (!isObject(object)) {
        return object;
      }
      var isSrcArr = isLength(source.length) && (isArray(source) || isTypedArray(source));
      if (!isSrcArr) {
        var props = keys(source);
        push.apply(props, getSymbols(source));
      }
      arrayEach(props || source, function(srcValue, key) {
        if (props) {
          key = srcValue;
          srcValue = source[key];
        }
        if (isObjectLike(srcValue)) {
          stackA || (stackA = []);
          stackB || (stackB = []);
          baseMergeDeep(object, source, key, baseMerge, customizer, stackA, stackB);
        }
        else {
          var value = object[key],
              result = customizer ? customizer(value, srcValue, key, object, source) : undefined,
              isCommon = result === undefined;

          if (isCommon) {
            result = srcValue;
          }
          if ((isSrcArr || result !== undefined) &&
              (isCommon || (result === result ? (result !== value) : (value === value)))) {
            object[key] = result;
          }
        }
      });
      return object;
    }

    /**
     * A specialized version of `baseMerge` for arrays and objects which performs
     * deep merges and tracks traversed objects enabling objects with circular
     * references to be merged.
     *
     * @private
     * @param {Object} object The destination object.
     * @param {Object} source The source object.
     * @param {string} key The key of the value to merge.
     * @param {Function} mergeFunc The function to merge values.
     * @param {Function} [customizer] The function to customize merging properties.
     * @param {Array} [stackA=[]] Tracks traversed source objects.
     * @param {Array} [stackB=[]] Associates values with source counterparts.
     * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
     */
    function baseMergeDeep(object, source, key, mergeFunc, customizer, stackA, stackB) {
      var length = stackA.length,
          srcValue = source[key];

      while (length--) {
        if (stackA[length] == srcValue) {
          object[key] = stackB[length];
          return;
        }
      }
      var value = object[key],
          result = customizer ? customizer(value, srcValue, key, object, source) : undefined,
          isCommon = result === undefined;

      if (isCommon) {
        result = srcValue;
        if (isLength(srcValue.length) && (isArray(srcValue) || isTypedArray(srcValue))) {
          result = isArray(value)
            ? value
            : (getLength(value) ? arrayCopy(value) : []);
        }
        else if (isPlainObject(srcValue) || isArguments(srcValue)) {
          result = isArguments(value)
            ? toPlainObject(value)
            : (isPlainObject(value) ? value : {});
        }
        else {
          isCommon = false;
        }
      }
      // Add the source value to the stack of traversed objects and associate
      // it with its merged value.
      stackA.push(srcValue);
      stackB.push(result);

      if (isCommon) {
        // Recursively merge objects and arrays (susceptible to call stack limits).
        object[key] = mergeFunc(result, srcValue, customizer, stackA, stackB);
      } else if (result === result ? (result !== value) : (value === value)) {
        object[key] = result;
      }
    }

    /**
     * The base implementation of `_.property` without support for deep paths.
     *
     * @private
     * @param {string} key The key of the property to get.
     * @returns {Function} Returns the new function.
     */
    function baseProperty(key) {
      return function(object) {
        return object == null ? undefined : object[key];
      };
    }

    /**
     * A specialized version of `baseProperty` which supports deep paths.
     *
     * @private
     * @param {Array|string} path The path of the property to get.
     * @returns {Function} Returns the new function.
     */
    function basePropertyDeep(path) {
      var pathKey = (path + '');
      path = toPath(path);
      return function(object) {
        return baseGet(object, path, pathKey);
      };
    }

    /**
     * The base implementation of `_.pullAt` without support for individual
     * index arguments and capturing the removed elements.
     *
     * @private
     * @param {Array} array The array to modify.
     * @param {number[]} indexes The indexes of elements to remove.
     * @returns {Array} Returns `array`.
     */
    function basePullAt(array, indexes) {
      var length = indexes.length;
      while (length--) {
        var index = parseFloat(indexes[length]);
        if (index != previous && isIndex(index)) {
          var previous = index;
          splice.call(array, index, 1);
        }
      }
      return array;
    }

    /**
     * The base implementation of `_.random` without support for argument juggling
     * and returning floating-point numbers.
     *
     * @private
     * @param {number} min The minimum possible value.
     * @param {number} max The maximum possible value.
     * @returns {number} Returns the random number.
     */
    function baseRandom(min, max) {
      return min + floor(nativeRandom() * (max - min + 1));
    }

    /**
     * The base implementation of `_.reduce` and `_.reduceRight` without support
     * for callback shorthands and `this` binding, which iterates over `collection`
     * using the provided `eachFunc`.
     *
     * @private
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function} iteratee The function invoked per iteration.
     * @param {*} accumulator The initial value.
     * @param {boolean} initFromCollection Specify using the first or last element
     *  of `collection` as the initial value.
     * @param {Function} eachFunc The function to iterate over `collection`.
     * @returns {*} Returns the accumulated value.
     */
    function baseReduce(collection, iteratee, accumulator, initFromCollection, eachFunc) {
      eachFunc(collection, function(value, index, collection) {
        accumulator = initFromCollection
          ? (initFromCollection = false, value)
          : iteratee(accumulator, value, index, collection);
      });
      return accumulator;
    }

    /**
     * The base implementation of `setData` without support for hot loop detection.
     *
     * @private
     * @param {Function} func The function to associate metadata with.
     * @param {*} data The metadata.
     * @returns {Function} Returns `func`.
     */
    var baseSetData = !metaMap ? identity : function(func, data) {
      metaMap.set(func, data);
      return func;
    };

    /**
     * The base implementation of `_.slice` without an iteratee call guard.
     *
     * @private
     * @param {Array} array The array to slice.
     * @param {number} [start=0] The start position.
     * @param {number} [end=array.length] The end position.
     * @returns {Array} Returns the slice of `array`.
     */
    function baseSlice(array, start, end) {
      var index = -1,
          length = array.length;

      start = start == null ? 0 : (+start || 0);
      if (start < 0) {
        start = -start > length ? 0 : (length + start);
      }
      end = (end === undefined || end > length) ? length : (+end || 0);
      if (end < 0) {
        end += length;
      }
      length = start > end ? 0 : ((end - start) >>> 0);
      start >>>= 0;

      var result = Array(length);
      while (++index < length) {
        result[index] = array[index + start];
      }
      return result;
    }

    /**
     * The base implementation of `_.some` without support for callback shorthands
     * and `this` binding.
     *
     * @private
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function} predicate The function invoked per iteration.
     * @returns {boolean} Returns `true` if any element passes the predicate check,
     *  else `false`.
     */
    function baseSome(collection, predicate) {
      var result;

      baseEach(collection, function(value, index, collection) {
        result = predicate(value, index, collection);
        return !result;
      });
      return !!result;
    }

    /**
     * The base implementation of `_.sortBy` which uses `comparer` to define
     * the sort order of `array` and replaces criteria objects with their
     * corresponding values.
     *
     * @private
     * @param {Array} array The array to sort.
     * @param {Function} comparer The function to define sort order.
     * @returns {Array} Returns `array`.
     */
    function baseSortBy(array, comparer) {
      var length = array.length;

      array.sort(comparer);
      while (length--) {
        array[length] = array[length].value;
      }
      return array;
    }

    /**
     * The base implementation of `_.sortByOrder` without param guards.
     *
     * @private
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function[]|Object[]|string[]} iteratees The iteratees to sort by.
     * @param {boolean[]} orders The sort orders of `iteratees`.
     * @returns {Array} Returns the new sorted array.
     */
    function baseSortByOrder(collection, iteratees, orders) {
      var callback = getCallback(),
          index = -1;

      iteratees = arrayMap(iteratees, function(iteratee) { return callback(iteratee); });

      var result = baseMap(collection, function(value) {
        var criteria = arrayMap(iteratees, function(iteratee) { return iteratee(value); });
        return { 'criteria': criteria, 'index': ++index, 'value': value };
      });

      return baseSortBy(result, function(object, other) {
        return compareMultiple(object, other, orders);
      });
    }

    /**
     * The base implementation of `_.sum` without support for callback shorthands
     * and `this` binding.
     *
     * @private
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function} iteratee The function invoked per iteration.
     * @returns {number} Returns the sum.
     */
    function baseSum(collection, iteratee) {
      var result = 0;
      baseEach(collection, function(value, index, collection) {
        result += +iteratee(value, index, collection) || 0;
      });
      return result;
    }

    /**
     * The base implementation of `_.uniq` without support for callback shorthands
     * and `this` binding.
     *
     * @private
     * @param {Array} array The array to inspect.
     * @param {Function} [iteratee] The function invoked per iteration.
     * @returns {Array} Returns the new duplicate-value-free array.
     */
    function baseUniq(array, iteratee) {
      var index = -1,
          indexOf = getIndexOf(),
          length = array.length,
          isCommon = indexOf == baseIndexOf,
          isLarge = isCommon && length >= 200,
          seen = isLarge ? createCache() : null,
          result = [];

      if (seen) {
        indexOf = cacheIndexOf;
        isCommon = false;
      } else {
        isLarge = false;
        seen = iteratee ? [] : result;
      }
      outer:
      while (++index < length) {
        var value = array[index],
            computed = iteratee ? iteratee(value, index, array) : value;

        if (isCommon && value === value) {
          var seenIndex = seen.length;
          while (seenIndex--) {
            if (seen[seenIndex] === computed) {
              continue outer;
            }
          }
          if (iteratee) {
            seen.push(computed);
          }
          result.push(value);
        }
        else if (indexOf(seen, computed, 0) < 0) {
          if (iteratee || isLarge) {
            seen.push(computed);
          }
          result.push(value);
        }
      }
      return result;
    }

    /**
     * The base implementation of `_.values` and `_.valuesIn` which creates an
     * array of `object` property values corresponding to the property names
     * of `props`.
     *
     * @private
     * @param {Object} object The object to query.
     * @param {Array} props The property names to get values for.
     * @returns {Object} Returns the array of property values.
     */
    function baseValues(object, props) {
      var index = -1,
          length = props.length,
          result = Array(length);

      while (++index < length) {
        result[index] = object[props[index]];
      }
      return result;
    }

    /**
     * The base implementation of `_.dropRightWhile`, `_.dropWhile`, `_.takeRightWhile`,
     * and `_.takeWhile` without support for callback shorthands and `this` binding.
     *
     * @private
     * @param {Array} array The array to query.
     * @param {Function} predicate The function invoked per iteration.
     * @param {boolean} [isDrop] Specify dropping elements instead of taking them.
     * @param {boolean} [fromRight] Specify iterating from right to left.
     * @returns {Array} Returns the slice of `array`.
     */
    function baseWhile(array, predicate, isDrop, fromRight) {
      var length = array.length,
          index = fromRight ? length : -1;

      while ((fromRight ? index-- : ++index < length) && predicate(array[index], index, array)) {}
      return isDrop
        ? baseSlice(array, (fromRight ? 0 : index), (fromRight ? index + 1 : length))
        : baseSlice(array, (fromRight ? index + 1 : 0), (fromRight ? length : index));
    }

    /**
     * The base implementation of `wrapperValue` which returns the result of
     * performing a sequence of actions on the unwrapped `value`, where each
     * successive action is supplied the return value of the previous.
     *
     * @private
     * @param {*} value The unwrapped value.
     * @param {Array} actions Actions to peform to resolve the unwrapped value.
     * @returns {*} Returns the resolved value.
     */
    function baseWrapperValue(value, actions) {
      var result = value;
      if (result instanceof LazyWrapper) {
        result = result.value();
      }
      var index = -1,
          length = actions.length;

      while (++index < length) {
        var args = [result],
            action = actions[index];

        push.apply(args, action.args);
        result = action.func.apply(action.thisArg, args);
      }
      return result;
    }

    /**
     * Performs a binary search of `array` to determine the index at which `value`
     * should be inserted into `array` in order to maintain its sort order.
     *
     * @private
     * @param {Array} array The sorted array to inspect.
     * @param {*} value The value to evaluate.
     * @param {boolean} [retHighest] Specify returning the highest qualified index.
     * @returns {number} Returns the index at which `value` should be inserted
     *  into `array`.
     */
    function binaryIndex(array, value, retHighest) {
      var low = 0,
          high = array ? array.length : low;

      if (typeof value == 'number' && value === value && high <= HALF_MAX_ARRAY_LENGTH) {
        while (low < high) {
          var mid = (low + high) >>> 1,
              computed = array[mid];

          if (retHighest ? (computed <= value) : (computed < value)) {
            low = mid + 1;
          } else {
            high = mid;
          }
        }
        return high;
      }
      return binaryIndexBy(array, value, identity, retHighest);
    }

    /**
     * This function is like `binaryIndex` except that it invokes `iteratee` for
     * `value` and each element of `array` to compute their sort ranking. The
     * iteratee is invoked with one argument; (value).
     *
     * @private
     * @param {Array} array The sorted array to inspect.
     * @param {*} value The value to evaluate.
     * @param {Function} iteratee The function invoked per iteration.
     * @param {boolean} [retHighest] Specify returning the highest qualified index.
     * @returns {number} Returns the index at which `value` should be inserted
     *  into `array`.
     */
    function binaryIndexBy(array, value, iteratee, retHighest) {
      value = iteratee(value);

      var low = 0,
          high = array ? array.length : 0,
          valIsNaN = value !== value,
          valIsUndef = value === undefined;

      while (low < high) {
        var mid = floor((low + high) / 2),
            computed = iteratee(array[mid]),
            isReflexive = computed === computed;

        if (valIsNaN) {
          var setLow = isReflexive || retHighest;
        } else if (valIsUndef) {
          setLow = isReflexive && (retHighest || computed !== undefined);
        } else {
          setLow = retHighest ? (computed <= value) : (computed < value);
        }
        if (setLow) {
          low = mid + 1;
        } else {
          high = mid;
        }
      }
      return nativeMin(high, MAX_ARRAY_INDEX);
    }

    /**
     * A specialized version of `baseCallback` which only supports `this` binding
     * and specifying the number of arguments to provide to `func`.
     *
     * @private
     * @param {Function} func The function to bind.
     * @param {*} thisArg The `this` binding of `func`.
     * @param {number} [argCount] The number of arguments to provide to `func`.
     * @returns {Function} Returns the callback.
     */
    function bindCallback(func, thisArg, argCount) {
      if (typeof func != 'function') {
        return identity;
      }
      if (thisArg === undefined) {
        return func;
      }
      switch (argCount) {
        case 1: return function(value) {
          return func.call(thisArg, value);
        };
        case 3: return function(value, index, collection) {
          return func.call(thisArg, value, index, collection);
        };
        case 4: return function(accumulator, value, index, collection) {
          return func.call(thisArg, accumulator, value, index, collection);
        };
        case 5: return function(value, other, key, object, source) {
          return func.call(thisArg, value, other, key, object, source);
        };
      }
      return function() {
        return func.apply(thisArg, arguments);
      };
    }

    /**
     * Creates a clone of the given array buffer.
     *
     * @private
     * @param {ArrayBuffer} buffer The array buffer to clone.
     * @returns {ArrayBuffer} Returns the cloned array buffer.
     */
    function bufferClone(buffer) {
      return bufferSlice.call(buffer, 0);
    }
    if (!bufferSlice) {
      // PhantomJS has `ArrayBuffer` and `Uint8Array` but not `Float64Array`.
      bufferClone = !(ArrayBuffer && Uint8Array) ? constant(null) : function(buffer) {
        var byteLength = buffer.byteLength,
            floatLength = Float64Array ? floor(byteLength / FLOAT64_BYTES_PER_ELEMENT) : 0,
            offset = floatLength * FLOAT64_BYTES_PER_ELEMENT,
            result = new ArrayBuffer(byteLength);

        if (floatLength) {
          var view = new Float64Array(result, 0, floatLength);
          view.set(new Float64Array(buffer, 0, floatLength));
        }
        if (byteLength != offset) {
          view = new Uint8Array(result, offset);
          view.set(new Uint8Array(buffer, offset));
        }
        return result;
      };
    }

    /**
     * Creates an array that is the composition of partially applied arguments,
     * placeholders, and provided arguments into a single array of arguments.
     *
     * @private
     * @param {Array|Object} args The provided arguments.
     * @param {Array} partials The arguments to prepend to those provided.
     * @param {Array} holders The `partials` placeholder indexes.
     * @returns {Array} Returns the new array of composed arguments.
     */
    function composeArgs(args, partials, holders) {
      var holdersLength = holders.length,
          argsIndex = -1,
          argsLength = nativeMax(args.length - holdersLength, 0),
          leftIndex = -1,
          leftLength = partials.length,
          result = Array(argsLength + leftLength);

      while (++leftIndex < leftLength) {
        result[leftIndex] = partials[leftIndex];
      }
      while (++argsIndex < holdersLength) {
        result[holders[argsIndex]] = args[argsIndex];
      }
      while (argsLength--) {
        result[leftIndex++] = args[argsIndex++];
      }
      return result;
    }

    /**
     * This function is like `composeArgs` except that the arguments composition
     * is tailored for `_.partialRight`.
     *
     * @private
     * @param {Array|Object} args The provided arguments.
     * @param {Array} partials The arguments to append to those provided.
     * @param {Array} holders The `partials` placeholder indexes.
     * @returns {Array} Returns the new array of composed arguments.
     */
    function composeArgsRight(args, partials, holders) {
      var holdersIndex = -1,
          holdersLength = holders.length,
          argsIndex = -1,
          argsLength = nativeMax(args.length - holdersLength, 0),
          rightIndex = -1,
          rightLength = partials.length,
          result = Array(argsLength + rightLength);

      while (++argsIndex < argsLength) {
        result[argsIndex] = args[argsIndex];
      }
      var pad = argsIndex;
      while (++rightIndex < rightLength) {
        result[pad + rightIndex] = partials[rightIndex];
      }
      while (++holdersIndex < holdersLength) {
        result[pad + holders[holdersIndex]] = args[argsIndex++];
      }
      return result;
    }

    /**
     * Creates a function that aggregates a collection, creating an accumulator
     * object composed from the results of running each element in the collection
     * through an iteratee.
     *
     * **Note:** This function is used to create `_.countBy`, `_.groupBy`, `_.indexBy`,
     * and `_.partition`.
     *
     * @private
     * @param {Function} setter The function to set keys and values of the accumulator object.
     * @param {Function} [initializer] The function to initialize the accumulator object.
     * @returns {Function} Returns the new aggregator function.
     */
    function createAggregator(setter, initializer) {
      return function(collection, iteratee, thisArg) {
        var result = initializer ? initializer() : {};
        iteratee = getCallback(iteratee, thisArg, 3);

        if (isArray(collection)) {
          var index = -1,
              length = collection.length;

          while (++index < length) {
            var value = collection[index];
            setter(result, value, iteratee(value, index, collection), collection);
          }
        } else {
          baseEach(collection, function(value, key, collection) {
            setter(result, value, iteratee(value, key, collection), collection);
          });
        }
        return result;
      };
    }

    /**
     * Creates a function that assigns properties of source object(s) to a given
     * destination object.
     *
     * **Note:** This function is used to create `_.assign`, `_.defaults`, and `_.merge`.
     *
     * @private
     * @param {Function} assigner The function to assign values.
     * @returns {Function} Returns the new assigner function.
     */
    function createAssigner(assigner) {
      return restParam(function(object, sources) {
        var index = -1,
            length = object == null ? 0 : sources.length,
            customizer = length > 2 && sources[length - 2],
            guard = length > 2 && sources[2],
            thisArg = length > 1 && sources[length - 1];

        if (typeof customizer == 'function') {
          customizer = bindCallback(customizer, thisArg, 5);
          length -= 2;
        } else {
          customizer = typeof thisArg == 'function' ? thisArg : null;
          length -= (customizer ? 1 : 0);
        }
        if (guard && isIterateeCall(sources[0], sources[1], guard)) {
          customizer = length < 3 ? null : customizer;
          length = 1;
        }
        while (++index < length) {
          var source = sources[index];
          if (source) {
            assigner(object, source, customizer);
          }
        }
        return object;
      });
    }

    /**
     * Creates a `baseEach` or `baseEachRight` function.
     *
     * @private
     * @param {Function} eachFunc The function to iterate over a collection.
     * @param {boolean} [fromRight] Specify iterating from right to left.
     * @returns {Function} Returns the new base function.
     */
    function createBaseEach(eachFunc, fromRight) {
      return function(collection, iteratee) {
        var length = collection ? getLength(collection) : 0;
        if (!isLength(length)) {
          return eachFunc(collection, iteratee);
        }
        var index = fromRight ? length : -1,
            iterable = toObject(collection);

        while ((fromRight ? index-- : ++index < length)) {
          if (iteratee(iterable[index], index, iterable) === false) {
            break;
          }
        }
        return collection;
      };
    }

    /**
     * Creates a base function for `_.forIn` or `_.forInRight`.
     *
     * @private
     * @param {boolean} [fromRight] Specify iterating from right to left.
     * @returns {Function} Returns the new base function.
     */
    function createBaseFor(fromRight) {
      return function(object, iteratee, keysFunc) {
        var iterable = toObject(object),
            props = keysFunc(object),
            length = props.length,
            index = fromRight ? length : -1;

        while ((fromRight ? index-- : ++index < length)) {
          var key = props[index];
          if (iteratee(iterable[key], key, iterable) === false) {
            break;
          }
        }
        return object;
      };
    }

    /**
     * Creates a function that wraps `func` and invokes it with the `this`
     * binding of `thisArg`.
     *
     * @private
     * @param {Function} func The function to bind.
     * @param {*} [thisArg] The `this` binding of `func`.
     * @returns {Function} Returns the new bound function.
     */
    function createBindWrapper(func, thisArg) {
      var Ctor = createCtorWrapper(func);

      function wrapper() {
        var fn = (this && this !== root && this instanceof wrapper) ? Ctor : func;
        return fn.apply(thisArg, arguments);
      }
      return wrapper;
    }

    /**
     * Creates a `Set` cache object to optimize linear searches of large arrays.
     *
     * @private
     * @param {Array} [values] The values to cache.
     * @returns {null|Object} Returns the new cache object if `Set` is supported, else `null`.
     */
    var createCache = !(nativeCreate && Set) ? constant(null) : function(values) {
      return new SetCache(values);
    };

    /**
     * Creates a function that produces compound words out of the words in a
     * given string.
     *
     * @private
     * @param {Function} callback The function to combine each word.
     * @returns {Function} Returns the new compounder function.
     */
    function createCompounder(callback) {
      return function(string) {
        var index = -1,
            array = words(deburr(string)),
            length = array.length,
            result = '';

        while (++index < length) {
          result = callback(result, array[index], index);
        }
        return result;
      };
    }

    /**
     * Creates a function that produces an instance of `Ctor` regardless of
     * whether it was invoked as part of a `new` expression or by `call` or `apply`.
     *
     * @private
     * @param {Function} Ctor The constructor to wrap.
     * @returns {Function} Returns the new wrapped function.
     */
    function createCtorWrapper(Ctor) {
      return function() {
        var thisBinding = baseCreate(Ctor.prototype),
            result = Ctor.apply(thisBinding, arguments);

        // Mimic the constructor's `return` behavior.
        // See https://es5.github.io/#x13.2.2 for more details.
        return isObject(result) ? result : thisBinding;
      };
    }

    /**
     * Creates a `_.curry` or `_.curryRight` function.
     *
     * @private
     * @param {boolean} flag The curry bit flag.
     * @returns {Function} Returns the new curry function.
     */
    function createCurry(flag) {
      function curryFunc(func, arity, guard) {
        if (guard && isIterateeCall(func, arity, guard)) {
          arity = null;
        }
        var result = createWrapper(func, flag, null, null, null, null, null, arity);
        result.placeholder = curryFunc.placeholder;
        return result;
      }
      return curryFunc;
    }

    /**
     * Creates a `_.max` or `_.min` function.
     *
     * @private
     * @param {Function} arrayFunc The function to get the extremum value from an array.
     * @param {boolean} [isMin] Specify returning the minimum, instead of the maximum,
     *  extremum value.
     * @returns {Function} Returns the new extremum function.
     */
    function createExtremum(arrayFunc, isMin) {
      return function(collection, iteratee, thisArg) {
        if (thisArg && isIterateeCall(collection, iteratee, thisArg)) {
          iteratee = null;
        }
        var func = getCallback(),
            noIteratee = iteratee == null;

        if (!(func === baseCallback && noIteratee)) {
          noIteratee = false;
          iteratee = func(iteratee, thisArg, 3);
        }
        if (noIteratee) {
          var isArr = isArray(collection);
          if (!isArr && isString(collection)) {
            iteratee = charAtCallback;
          } else {
            return arrayFunc(isArr ? collection : toIterable(collection));
          }
        }
        return extremumBy(collection, iteratee, isMin);
      };
    }

    /**
     * Creates a `_.find` or `_.findLast` function.
     *
     * @private
     * @param {Function} eachFunc The function to iterate over a collection.
     * @param {boolean} [fromRight] Specify iterating from right to left.
     * @returns {Function} Returns the new find function.
     */
    function createFind(eachFunc, fromRight) {
      return function(collection, predicate, thisArg) {
        predicate = getCallback(predicate, thisArg, 3);
        if (isArray(collection)) {
          var index = baseFindIndex(collection, predicate, fromRight);
          return index > -1 ? collection[index] : undefined;
        }
        return baseFind(collection, predicate, eachFunc);
      }
    }

    /**
     * Creates a `_.findIndex` or `_.findLastIndex` function.
     *
     * @private
     * @param {boolean} [fromRight] Specify iterating from right to left.
     * @returns {Function} Returns the new find function.
     */
    function createFindIndex(fromRight) {
      return function(array, predicate, thisArg) {
        if (!(array && array.length)) {
          return -1;
        }
        predicate = getCallback(predicate, thisArg, 3);
        return baseFindIndex(array, predicate, fromRight);
      };
    }

    /**
     * Creates a `_.findKey` or `_.findLastKey` function.
     *
     * @private
     * @param {Function} objectFunc The function to iterate over an object.
     * @returns {Function} Returns the new find function.
     */
    function createFindKey(objectFunc) {
      return function(object, predicate, thisArg) {
        predicate = getCallback(predicate, thisArg, 3);
        return baseFind(object, predicate, objectFunc, true);
      };
    }

    /**
     * Creates a `_.flow` or `_.flowRight` function.
     *
     * @private
     * @param {boolean} [fromRight] Specify iterating from right to left.
     * @returns {Function} Returns the new flow function.
     */
    function createFlow(fromRight) {
      return function() {
        var length = arguments.length;
        if (!length) {
          return function() { return arguments[0]; };
        }
        var wrapper,
            index = fromRight ? length : -1,
            leftIndex = 0,
            funcs = Array(length);

        while ((fromRight ? index-- : ++index < length)) {
          var func = funcs[leftIndex++] = arguments[index];
          if (typeof func != 'function') {
            throw new TypeError(FUNC_ERROR_TEXT);
          }
          var funcName = wrapper ? '' : getFuncName(func);
          wrapper = funcName == 'wrapper' ? new LodashWrapper([]) : wrapper;
        }
        index = wrapper ? -1 : length;
        while (++index < length) {
          func = funcs[index];
          funcName = getFuncName(func);

          var data = funcName == 'wrapper' ? getData(func) : null;
          if (data && isLaziable(data[0])) {
            wrapper = wrapper[getFuncName(data[0])].apply(wrapper, data[3]);
          } else {
            wrapper = (func.length == 1 && isLaziable(func)) ? wrapper[funcName]() : wrapper.thru(func);
          }
        }
        return function() {
          var args = arguments;
          if (wrapper && args.length == 1 && isArray(args[0])) {
            return wrapper.plant(args[0]).value();
          }
          var index = 0,
              result = funcs[index].apply(this, args);

          while (++index < length) {
            result = funcs[index].call(this, result);
          }
          return result;
        };
      };
    }

    /**
     * Creates a function for `_.forEach` or `_.forEachRight`.
     *
     * @private
     * @param {Function} arrayFunc The function to iterate over an array.
     * @param {Function} eachFunc The function to iterate over a collection.
     * @returns {Function} Returns the new each function.
     */
    function createForEach(arrayFunc, eachFunc) {
      return function(collection, iteratee, thisArg) {
        return (typeof iteratee == 'function' && thisArg === undefined && isArray(collection))
          ? arrayFunc(collection, iteratee)
          : eachFunc(collection, bindCallback(iteratee, thisArg, 3));
      };
    }

    /**
     * Creates a function for `_.forIn` or `_.forInRight`.
     *
     * @private
     * @param {Function} objectFunc The function to iterate over an object.
     * @returns {Function} Returns the new each function.
     */
    function createForIn(objectFunc) {
      return function(object, iteratee, thisArg) {
        if (typeof iteratee != 'function' || thisArg !== undefined) {
          iteratee = bindCallback(iteratee, thisArg, 3);
        }
        return objectFunc(object, iteratee, keysIn);
      };
    }

    /**
     * Creates a function for `_.forOwn` or `_.forOwnRight`.
     *
     * @private
     * @param {Function} objectFunc The function to iterate over an object.
     * @returns {Function} Returns the new each function.
     */
    function createForOwn(objectFunc) {
      return function(object, iteratee, thisArg) {
        if (typeof iteratee != 'function' || thisArg !== undefined) {
          iteratee = bindCallback(iteratee, thisArg, 3);
        }
        return objectFunc(object, iteratee);
      };
    }

    /**
     * Creates a function for `_.padLeft` or `_.padRight`.
     *
     * @private
     * @param {boolean} [fromRight] Specify padding from the right.
     * @returns {Function} Returns the new pad function.
     */
    function createPadDir(fromRight) {
      return function(string, length, chars) {
        string = baseToString(string);
        return string && ((fromRight ? string : '') + createPadding(string, length, chars) + (fromRight ? '' : string));
      };
    }

    /**
     * Creates a `_.partial` or `_.partialRight` function.
     *
     * @private
     * @param {boolean} flag The partial bit flag.
     * @returns {Function} Returns the new partial function.
     */
    function createPartial(flag) {
      var partialFunc = restParam(function(func, partials) {
        var holders = replaceHolders(partials, partialFunc.placeholder);
        return createWrapper(func, flag, null, partials, holders);
      });
      return partialFunc;
    }

    /**
     * Creates a function for `_.reduce` or `_.reduceRight`.
     *
     * @private
     * @param {Function} arrayFunc The function to iterate over an array.
     * @param {Function} eachFunc The function to iterate over a collection.
     * @returns {Function} Returns the new each function.
     */
    function createReduce(arrayFunc, eachFunc) {
      return function(collection, iteratee, accumulator, thisArg) {
        var initFromArray = arguments.length < 3;
        return (typeof iteratee == 'function' && thisArg === undefined && isArray(collection))
          ? arrayFunc(collection, iteratee, accumulator, initFromArray)
          : baseReduce(collection, getCallback(iteratee, thisArg, 4), accumulator, initFromArray, eachFunc);
      };
    }

    /**
     * Creates a function that wraps `func` and invokes it with optional `this`
     * binding of, partial application, and currying.
     *
     * @private
     * @param {Function|string} func The function or method name to reference.
     * @param {number} bitmask The bitmask of flags. See `createWrapper` for more details.
     * @param {*} [thisArg] The `this` binding of `func`.
     * @param {Array} [partials] The arguments to prepend to those provided to the new function.
     * @param {Array} [holders] The `partials` placeholder indexes.
     * @param {Array} [partialsRight] The arguments to append to those provided to the new function.
     * @param {Array} [holdersRight] The `partialsRight` placeholder indexes.
     * @param {Array} [argPos] The argument positions of the new function.
     * @param {number} [ary] The arity cap of `func`.
     * @param {number} [arity] The arity of `func`.
     * @returns {Function} Returns the new wrapped function.
     */
    function createHybridWrapper(func, bitmask, thisArg, partials, holders, partialsRight, holdersRight, argPos, ary, arity) {
      var isAry = bitmask & ARY_FLAG,
          isBind = bitmask & BIND_FLAG,
          isBindKey = bitmask & BIND_KEY_FLAG,
          isCurry = bitmask & CURRY_FLAG,
          isCurryBound = bitmask & CURRY_BOUND_FLAG,
          isCurryRight = bitmask & CURRY_RIGHT_FLAG;

      var Ctor = !isBindKey && createCtorWrapper(func),
          key = func;

      function wrapper() {
        // Avoid `arguments` object use disqualifying optimizations by
        // converting it to an array before providing it to other functions.
        var length = arguments.length,
            index = length,
            args = Array(length);

        while (index--) {
          args[index] = arguments[index];
        }
        if (partials) {
          args = composeArgs(args, partials, holders);
        }
        if (partialsRight) {
          args = composeArgsRight(args, partialsRight, holdersRight);
        }
        if (isCurry || isCurryRight) {
          var placeholder = wrapper.placeholder,
              argsHolders = replaceHolders(args, placeholder);

          length -= argsHolders.length;
          if (length < arity) {
            var newArgPos = argPos ? arrayCopy(argPos) : null,
                newArity = nativeMax(arity - length, 0),
                newsHolders = isCurry ? argsHolders : null,
                newHoldersRight = isCurry ? null : argsHolders,
                newPartials = isCurry ? args : null,
                newPartialsRight = isCurry ? null : args;

            bitmask |= (isCurry ? PARTIAL_FLAG : PARTIAL_RIGHT_FLAG);
            bitmask &= ~(isCurry ? PARTIAL_RIGHT_FLAG : PARTIAL_FLAG);

            if (!isCurryBound) {
              bitmask &= ~(BIND_FLAG | BIND_KEY_FLAG);
            }
            var newData = [func, bitmask, thisArg, newPartials, newsHolders, newPartialsRight, newHoldersRight, newArgPos, ary, newArity],
                result = createHybridWrapper.apply(undefined, newData);

            if (isLaziable(func)) {
              setData(result, newData);
            }
            result.placeholder = placeholder;
            return result;
          }
        }
        var thisBinding = isBind ? thisArg : this;
        if (isBindKey) {
          func = thisBinding[key];
        }
        if (argPos) {
          args = reorder(args, argPos);
        }
        if (isAry && ary < args.length) {
          args.length = ary;
        }
        var fn = (this && this !== root && this instanceof wrapper) ? (Ctor || createCtorWrapper(func)) : func;
        return fn.apply(thisBinding, args);
      }
      return wrapper;
    }

    /**
     * Creates the padding required for `string` based on the given `length`.
     * The `chars` string is truncated if the number of characters exceeds `length`.
     *
     * @private
     * @param {string} string The string to create padding for.
     * @param {number} [length=0] The padding length.
     * @param {string} [chars=' '] The string used as padding.
     * @returns {string} Returns the pad for `string`.
     */
    function createPadding(string, length, chars) {
      var strLength = string.length;
      length = +length;

      if (strLength >= length || !nativeIsFinite(length)) {
        return '';
      }
      var padLength = length - strLength;
      chars = chars == null ? ' ' : (chars + '');
      return repeat(chars, ceil(padLength / chars.length)).slice(0, padLength);
    }

    /**
     * Creates a function that wraps `func` and invokes it with the optional `this`
     * binding of `thisArg` and the `partials` prepended to those provided to
     * the wrapper.
     *
     * @private
     * @param {Function} func The function to partially apply arguments to.
     * @param {number} bitmask The bitmask of flags. See `createWrapper` for more details.
     * @param {*} thisArg The `this` binding of `func`.
     * @param {Array} partials The arguments to prepend to those provided to the new function.
     * @returns {Function} Returns the new bound function.
     */
    function createPartialWrapper(func, bitmask, thisArg, partials) {
      var isBind = bitmask & BIND_FLAG,
          Ctor = createCtorWrapper(func);

      function wrapper() {
        // Avoid `arguments` object use disqualifying optimizations by
        // converting it to an array before providing it `func`.
        var argsIndex = -1,
            argsLength = arguments.length,
            leftIndex = -1,
            leftLength = partials.length,
            args = Array(argsLength + leftLength);

        while (++leftIndex < leftLength) {
          args[leftIndex] = partials[leftIndex];
        }
        while (argsLength--) {
          args[leftIndex++] = arguments[++argsIndex];
        }
        var fn = (this && this !== root && this instanceof wrapper) ? Ctor : func;
        return fn.apply(isBind ? thisArg : this, args);
      }
      return wrapper;
    }

    /**
     * Creates a `_.sortedIndex` or `_.sortedLastIndex` function.
     *
     * @private
     * @param {boolean} [retHighest] Specify returning the highest qualified index.
     * @returns {Function} Returns the new index function.
     */
    function createSortedIndex(retHighest) {
      return function(array, value, iteratee, thisArg) {
        var func = getCallback(iteratee);
        return (func === baseCallback && iteratee == null)
          ? binaryIndex(array, value, retHighest)
          : binaryIndexBy(array, value, func(iteratee, thisArg, 1), retHighest);
      };
    }

    /**
     * Creates a function that either curries or invokes `func` with optional
     * `this` binding and partially applied arguments.
     *
     * @private
     * @param {Function|string} func The function or method name to reference.
     * @param {number} bitmask The bitmask of flags.
     *  The bitmask may be composed of the following flags:
     *     1 - `_.bind`
     *     2 - `_.bindKey`
     *     4 - `_.curry` or `_.curryRight` of a bound function
     *     8 - `_.curry`
     *    16 - `_.curryRight`
     *    32 - `_.partial`
     *    64 - `_.partialRight`
     *   128 - `_.rearg`
     *   256 - `_.ary`
     * @param {*} [thisArg] The `this` binding of `func`.
     * @param {Array} [partials] The arguments to be partially applied.
     * @param {Array} [holders] The `partials` placeholder indexes.
     * @param {Array} [argPos] The argument positions of the new function.
     * @param {number} [ary] The arity cap of `func`.
     * @param {number} [arity] The arity of `func`.
     * @returns {Function} Returns the new wrapped function.
     */
    function createWrapper(func, bitmask, thisArg, partials, holders, argPos, ary, arity) {
      var isBindKey = bitmask & BIND_KEY_FLAG;
      if (!isBindKey && typeof func != 'function') {
        throw new TypeError(FUNC_ERROR_TEXT);
      }
      var length = partials ? partials.length : 0;
      if (!length) {
        bitmask &= ~(PARTIAL_FLAG | PARTIAL_RIGHT_FLAG);
        partials = holders = null;
      }
      length -= (holders ? holders.length : 0);
      if (bitmask & PARTIAL_RIGHT_FLAG) {
        var partialsRight = partials,
            holdersRight = holders;

        partials = holders = null;
      }
      var data = isBindKey ? null : getData(func),
          newData = [func, bitmask, thisArg, partials, holders, partialsRight, holdersRight, argPos, ary, arity];

      if (data) {
        mergeData(newData, data);
        bitmask = newData[1];
        arity = newData[9];
      }
      newData[9] = arity == null
        ? (isBindKey ? 0 : func.length)
        : (nativeMax(arity - length, 0) || 0);

      if (bitmask == BIND_FLAG) {
        var result = createBindWrapper(newData[0], newData[2]);
      } else if ((bitmask == PARTIAL_FLAG || bitmask == (BIND_FLAG | PARTIAL_FLAG)) && !newData[4].length) {
        result = createPartialWrapper.apply(undefined, newData);
      } else {
        result = createHybridWrapper.apply(undefined, newData);
      }
      var setter = data ? baseSetData : setData;
      return setter(result, newData);
    }

    /**
     * A specialized version of `baseIsEqualDeep` for arrays with support for
     * partial deep comparisons.
     *
     * @private
     * @param {Array} array The array to compare.
     * @param {Array} other The other array to compare.
     * @param {Function} equalFunc The function to determine equivalents of values.
     * @param {Function} [customizer] The function to customize comparing arrays.
     * @param {boolean} [isLoose] Specify performing partial comparisons.
     * @param {Array} [stackA] Tracks traversed `value` objects.
     * @param {Array} [stackB] Tracks traversed `other` objects.
     * @returns {boolean} Returns `true` if the arrays are equivalent, else `false`.
     */
    function equalArrays(array, other, equalFunc, customizer, isLoose, stackA, stackB) {
      var index = -1,
          arrLength = array.length,
          othLength = other.length,
          result = true;

      if (arrLength != othLength && !(isLoose && othLength > arrLength)) {
        return false;
      }
      // Deep compare the contents, ignoring non-numeric properties.
      while (result && ++index < arrLength) {
        var arrValue = array[index],
            othValue = other[index];

        result = undefined;
        if (customizer) {
          result = isLoose
            ? customizer(othValue, arrValue, index)
            : customizer(arrValue, othValue, index);
        }
        if (result === undefined) {
          // Recursively compare arrays (susceptible to call stack limits).
          if (isLoose) {
            var othIndex = othLength;
            while (othIndex--) {
              othValue = other[othIndex];
              result = (arrValue && arrValue === othValue) || equalFunc(arrValue, othValue, customizer, isLoose, stackA, stackB);
              if (result) {
                break;
              }
            }
          } else {
            result = (arrValue && arrValue === othValue) || equalFunc(arrValue, othValue, customizer, isLoose, stackA, stackB);
          }
        }
      }
      return !!result;
    }

    /**
     * A specialized version of `baseIsEqualDeep` for comparing objects of
     * the same `toStringTag`.
     *
     * **Note:** This function only supports comparing values with tags of
     * `Boolean`, `Date`, `Error`, `Number`, `RegExp`, or `String`.
     *
     * @private
     * @param {Object} value The object to compare.
     * @param {Object} other The other object to compare.
     * @param {string} tag The `toStringTag` of the objects to compare.
     * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
     */
    function equalByTag(object, other, tag) {
      switch (tag) {
        case boolTag:
        case dateTag:
          // Coerce dates and booleans to numbers, dates to milliseconds and booleans
          // to `1` or `0` treating invalid dates coerced to `NaN` as not equal.
          return +object == +other;

        case errorTag:
          return object.name == other.name && object.message == other.message;

        case numberTag:
          // Treat `NaN` vs. `NaN` as equal.
          return (object != +object)
            ? other != +other
            // But, treat `-0` vs. `+0` as not equal.
            : (object == 0 ? ((1 / object) == (1 / other)) : object == +other);

        case regexpTag:
        case stringTag:
          // Coerce regexes to strings and treat strings primitives and string
          // objects as equal. See https://es5.github.io/#x15.10.6.4 for more details.
          return object == (other + '');
      }
      return false;
    }

    /**
     * A specialized version of `baseIsEqualDeep` for objects with support for
     * partial deep comparisons.
     *
     * @private
     * @param {Object} object The object to compare.
     * @param {Object} other The other object to compare.
     * @param {Function} equalFunc The function to determine equivalents of values.
     * @param {Function} [customizer] The function to customize comparing values.
     * @param {boolean} [isLoose] Specify performing partial comparisons.
     * @param {Array} [stackA] Tracks traversed `value` objects.
     * @param {Array} [stackB] Tracks traversed `other` objects.
     * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
     */
    function equalObjects(object, other, equalFunc, customizer, isLoose, stackA, stackB) {
      var objProps = keys(object),
          objLength = objProps.length,
          othProps = keys(other),
          othLength = othProps.length;

      if (objLength != othLength && !isLoose) {
        return false;
      }
      var skipCtor = isLoose,
          index = -1;

      while (++index < objLength) {
        var key = objProps[index],
            result = isLoose ? key in other : hasOwnProperty.call(other, key);

        if (result) {
          var objValue = object[key],
              othValue = other[key];

          result = undefined;
          if (customizer) {
            result = isLoose
              ? customizer(othValue, objValue, key)
              : customizer(objValue, othValue, key);
          }
          if (result === undefined) {
            // Recursively compare objects (susceptible to call stack limits).
            result = (objValue && objValue === othValue) || equalFunc(objValue, othValue, customizer, isLoose, stackA, stackB);
          }
        }
        if (!result) {
          return false;
        }
        skipCtor || (skipCtor = key == 'constructor');
      }
      if (!skipCtor) {
        var objCtor = object.constructor,
            othCtor = other.constructor;

        // Non `Object` object instances with different constructors are not equal.
        if (objCtor != othCtor &&
            ('constructor' in object && 'constructor' in other) &&
            !(typeof objCtor == 'function' && objCtor instanceof objCtor &&
              typeof othCtor == 'function' && othCtor instanceof othCtor)) {
          return false;
        }
      }
      return true;
    }

    /**
     * Gets the extremum value of `collection` invoking `iteratee` for each value
     * in `collection` to generate the criterion by which the value is ranked.
     * The `iteratee` is invoked with three arguments: (value, index, collection).
     *
     * @private
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function} iteratee The function invoked per iteration.
     * @param {boolean} [isMin] Specify returning the minimum, instead of the
     *  maximum, extremum value.
     * @returns {*} Returns the extremum value.
     */
    function extremumBy(collection, iteratee, isMin) {
      var exValue = isMin ? POSITIVE_INFINITY : NEGATIVE_INFINITY,
          computed = exValue,
          result = computed;

      baseEach(collection, function(value, index, collection) {
        var current = iteratee(value, index, collection);
        if ((isMin ? (current < computed) : (current > computed)) ||
            (current === exValue && current === result)) {
          computed = current;
          result = value;
        }
      });
      return result;
    }

    /**
     * Gets the appropriate "callback" function. If the `_.callback` method is
     * customized this function returns the custom method, otherwise it returns
     * the `baseCallback` function. If arguments are provided the chosen function
     * is invoked with them and its result is returned.
     *
     * @private
     * @returns {Function} Returns the chosen function or its result.
     */
    function getCallback(func, thisArg, argCount) {
      var result = lodash.callback || callback;
      result = result === callback ? baseCallback : result;
      return argCount ? result(func, thisArg, argCount) : result;
    }

    /**
     * Gets metadata for `func`.
     *
     * @private
     * @param {Function} func The function to query.
     * @returns {*} Returns the metadata for `func`.
     */
    var getData = !metaMap ? noop : function(func) {
      return metaMap.get(func);
    };

    /**
     * Gets the name of `func`.
     *
     * @private
     * @param {Function} func The function to query.
     * @returns {string} Returns the function name.
     */
    var getFuncName = (function() {
      if (!support.funcNames) {
        return constant('');
      }
      if (constant.name == 'constant') {
        return baseProperty('name');
      }
      return function(func) {
        var result = func.name,
            array = realNames[result],
            length = array ? array.length : 0;

        while (length--) {
          var data = array[length],
              otherFunc = data.func;

          if (otherFunc == null || otherFunc == func) {
            return data.name;
          }
        }
        return result;
      };
    }());

    /**
     * Gets the appropriate "indexOf" function. If the `_.indexOf` method is
     * customized this function returns the custom method, otherwise it returns
     * the `baseIndexOf` function. If arguments are provided the chosen function
     * is invoked with them and its result is returned.
     *
     * @private
     * @returns {Function|number} Returns the chosen function or its result.
     */
    function getIndexOf(collection, target, fromIndex) {
      var result = lodash.indexOf || indexOf;
      result = result === indexOf ? baseIndexOf : result;
      return collection ? result(collection, target, fromIndex) : result;
    }

    /**
     * Gets the "length" property value of `object`.
     *
     * **Note:** This function is used to avoid a [JIT bug](https://bugs.webkit.org/show_bug.cgi?id=142792)
     * in Safari on iOS 8.1 ARM64.
     *
     * @private
     * @param {Object} object The object to query.
     * @returns {*} Returns the "length" value.
     */
    var getLength = baseProperty('length');

    /**
     * Creates an array of the own symbols of `object`.
     *
     * @private
     * @param {Object} object The object to query.
     * @returns {Array} Returns the array of symbols.
     */
    var getSymbols = !getOwnPropertySymbols ? constant([]) : function(object) {
      return getOwnPropertySymbols(toObject(object));
    };

    /**
     * Gets the view, applying any `transforms` to the `start` and `end` positions.
     *
     * @private
     * @param {number} start The start of the view.
     * @param {number} end The end of the view.
     * @param {Array} [transforms] The transformations to apply to the view.
     * @returns {Object} Returns an object containing the `start` and `end`
     *  positions of the view.
     */
    function getView(start, end, transforms) {
      var index = -1,
          length = transforms ? transforms.length : 0;

      while (++index < length) {
        var data = transforms[index],
            size = data.size;

        switch (data.type) {
          case 'drop':      start += size; break;
          case 'dropRight': end -= size; break;
          case 'take':      end = nativeMin(end, start + size); break;
          case 'takeRight': start = nativeMax(start, end - size); break;
        }
      }
      return { 'start': start, 'end': end };
    }

    /**
     * Initializes an array clone.
     *
     * @private
     * @param {Array} array The array to clone.
     * @returns {Array} Returns the initialized clone.
     */
    function initCloneArray(array) {
      var length = array.length,
          result = new array.constructor(length);

      // Add array properties assigned by `RegExp#exec`.
      if (length && typeof array[0] == 'string' && hasOwnProperty.call(array, 'index')) {
        result.index = array.index;
        result.input = array.input;
      }
      return result;
    }

    /**
     * Initializes an object clone.
     *
     * @private
     * @param {Object} object The object to clone.
     * @returns {Object} Returns the initialized clone.
     */
    function initCloneObject(object) {
      var Ctor = object.constructor;
      if (!(typeof Ctor == 'function' && Ctor instanceof Ctor)) {
        Ctor = Object;
      }
      return new Ctor;
    }

    /**
     * Initializes an object clone based on its `toStringTag`.
     *
     * **Note:** This function only supports cloning values with tags of
     * `Boolean`, `Date`, `Error`, `Number`, `RegExp`, or `String`.
     *
     * @private
     * @param {Object} object The object to clone.
     * @param {string} tag The `toStringTag` of the object to clone.
     * @param {boolean} [isDeep] Specify a deep clone.
     * @returns {Object} Returns the initialized clone.
     */
    function initCloneByTag(object, tag, isDeep) {
      var Ctor = object.constructor;
      switch (tag) {
        case arrayBufferTag:
          return bufferClone(object);

        case boolTag:
        case dateTag:
          return new Ctor(+object);

        case float32Tag: case float64Tag:
        case int8Tag: case int16Tag: case int32Tag:
        case uint8Tag: case uint8ClampedTag: case uint16Tag: case uint32Tag:
          var buffer = object.buffer;
          return new Ctor(isDeep ? bufferClone(buffer) : buffer, object.byteOffset, object.length);

        case numberTag:
        case stringTag:
          return new Ctor(object);

        case regexpTag:
          var result = new Ctor(object.source, reFlags.exec(object));
          result.lastIndex = object.lastIndex;
      }
      return result;
    }

    /**
     * Invokes the method at `path` on `object`.
     *
     * @private
     * @param {Object} object The object to query.
     * @param {Array|string} path The path of the method to invoke.
     * @param {Array} args The arguments to invoke the method with.
     * @returns {*} Returns the result of the invoked method.
     */
    function invokePath(object, path, args) {
      if (object != null && !isKey(path, object)) {
        path = toPath(path);
        object = path.length == 1 ? object : baseGet(object, baseSlice(path, 0, -1));
        path = last(path);
      }
      var func = object == null ? object : object[path];
      return func == null ? undefined : func.apply(object, args);
    }

    /**
     * Checks if `value` is a valid array-like index.
     *
     * @private
     * @param {*} value The value to check.
     * @param {number} [length=MAX_SAFE_INTEGER] The upper bounds of a valid index.
     * @returns {boolean} Returns `true` if `value` is a valid index, else `false`.
     */
    function isIndex(value, length) {
      value = +value;
      length = length == null ? MAX_SAFE_INTEGER : length;
      return value > -1 && value % 1 == 0 && value < length;
    }

    /**
     * Checks if the provided arguments are from an iteratee call.
     *
     * @private
     * @param {*} value The potential iteratee value argument.
     * @param {*} index The potential iteratee index or key argument.
     * @param {*} object The potential iteratee object argument.
     * @returns {boolean} Returns `true` if the arguments are from an iteratee call, else `false`.
     */
    function isIterateeCall(value, index, object) {
      if (!isObject(object)) {
        return false;
      }
      var type = typeof index;
      if (type == 'number') {
        var length = getLength(object),
            prereq = isLength(length) && isIndex(index, length);
      } else {
        prereq = type == 'string' && index in object;
      }
      if (prereq) {
        var other = object[index];
        return value === value ? (value === other) : (other !== other);
      }
      return false;
    }

    /**
     * Checks if `value` is a property name and not a property path.
     *
     * @private
     * @param {*} value The value to check.
     * @param {Object} [object] The object to query keys on.
     * @returns {boolean} Returns `true` if `value` is a property name, else `false`.
     */
    function isKey(value, object) {
      var type = typeof value;
      if ((type == 'string' && reIsPlainProp.test(value)) || type == 'number') {
        return true;
      }
      if (isArray(value)) {
        return false;
      }
      var result = !reIsDeepProp.test(value);
      return result || (object != null && value in toObject(object));
    }

    /**
     * Checks if `func` has a lazy counterpart.
     *
     * @private
     * @param {Function} func The function to check.
     * @returns {boolean} Returns `true` if `func` has a lazy counterpart, else `false`.
     */
    function isLaziable(func) {
      var funcName = getFuncName(func);
      return !!funcName && func === lodash[funcName] && funcName in LazyWrapper.prototype;
    }

    /**
     * Checks if `value` is a valid array-like length.
     *
     * **Note:** This function is based on [`ToLength`](https://people.mozilla.org/~jorendorff/es6-draft.html#sec-tolength).
     *
     * @private
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a valid length, else `false`.
     */
    function isLength(value) {
      return typeof value == 'number' && value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
    }

    /**
     * Checks if `value` is suitable for strict equality comparisons, i.e. `===`.
     *
     * @private
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` if suitable for strict
     *  equality comparisons, else `false`.
     */
    function isStrictComparable(value) {
      return value === value && (value === 0 ? ((1 / value) > 0) : !isObject(value));
    }

    /**
     * Merges the function metadata of `source` into `data`.
     *
     * Merging metadata reduces the number of wrappers required to invoke a function.
     * This is possible because methods like `_.bind`, `_.curry`, and `_.partial`
     * may be applied regardless of execution order. Methods like `_.ary` and `_.rearg`
     * augment function arguments, making the order in which they are executed important,
     * preventing the merging of metadata. However, we make an exception for a safe
     * common case where curried functions have `_.ary` and or `_.rearg` applied.
     *
     * @private
     * @param {Array} data The destination metadata.
     * @param {Array} source The source metadata.
     * @returns {Array} Returns `data`.
     */
    function mergeData(data, source) {
      var bitmask = data[1],
          srcBitmask = source[1],
          newBitmask = bitmask | srcBitmask,
          isCommon = newBitmask < ARY_FLAG;

      var isCombo =
        (srcBitmask == ARY_FLAG && bitmask == CURRY_FLAG) ||
        (srcBitmask == ARY_FLAG && bitmask == REARG_FLAG && data[7].length <= source[8]) ||
        (srcBitmask == (ARY_FLAG | REARG_FLAG) && bitmask == CURRY_FLAG);

      // Exit early if metadata can't be merged.
      if (!(isCommon || isCombo)) {
        return data;
      }
      // Use source `thisArg` if available.
      if (srcBitmask & BIND_FLAG) {
        data[2] = source[2];
        // Set when currying a bound function.
        newBitmask |= (bitmask & BIND_FLAG) ? 0 : CURRY_BOUND_FLAG;
      }
      // Compose partial arguments.
      var value = source[3];
      if (value) {
        var partials = data[3];
        data[3] = partials ? composeArgs(partials, value, source[4]) : arrayCopy(value);
        data[4] = partials ? replaceHolders(data[3], PLACEHOLDER) : arrayCopy(source[4]);
      }
      // Compose partial right arguments.
      value = source[5];
      if (value) {
        partials = data[5];
        data[5] = partials ? composeArgsRight(partials, value, source[6]) : arrayCopy(value);
        data[6] = partials ? replaceHolders(data[5], PLACEHOLDER) : arrayCopy(source[6]);
      }
      // Use source `argPos` if available.
      value = source[7];
      if (value) {
        data[7] = arrayCopy(value);
      }
      // Use source `ary` if it's smaller.
      if (srcBitmask & ARY_FLAG) {
        data[8] = data[8] == null ? source[8] : nativeMin(data[8], source[8]);
      }
      // Use source `arity` if one is not provided.
      if (data[9] == null) {
        data[9] = source[9];
      }
      // Use source `func` and merge bitmasks.
      data[0] = source[0];
      data[1] = newBitmask;

      return data;
    }

    /**
     * A specialized version of `_.pick` that picks `object` properties specified
     * by `props`.
     *
     * @private
     * @param {Object} object The source object.
     * @param {string[]} props The property names to pick.
     * @returns {Object} Returns the new object.
     */
    function pickByArray(object, props) {
      object = toObject(object);

      var index = -1,
          length = props.length,
          result = {};

      while (++index < length) {
        var key = props[index];
        if (key in object) {
          result[key] = object[key];
        }
      }
      return result;
    }

    /**
     * A specialized version of `_.pick` that picks `object` properties `predicate`
     * returns truthy for.
     *
     * @private
     * @param {Object} object The source object.
     * @param {Function} predicate The function invoked per iteration.
     * @returns {Object} Returns the new object.
     */
    function pickByCallback(object, predicate) {
      var result = {};
      baseForIn(object, function(value, key, object) {
        if (predicate(value, key, object)) {
          result[key] = value;
        }
      });
      return result;
    }

    /**
     * Reorder `array` according to the specified indexes where the element at
     * the first index is assigned as the first element, the element at
     * the second index is assigned as the second element, and so on.
     *
     * @private
     * @param {Array} array The array to reorder.
     * @param {Array} indexes The arranged array indexes.
     * @returns {Array} Returns `array`.
     */
    function reorder(array, indexes) {
      var arrLength = array.length,
          length = nativeMin(indexes.length, arrLength),
          oldArray = arrayCopy(array);

      while (length--) {
        var index = indexes[length];
        array[length] = isIndex(index, arrLength) ? oldArray[index] : undefined;
      }
      return array;
    }

    /**
     * Sets metadata for `func`.
     *
     * **Note:** If this function becomes hot, i.e. is invoked a lot in a short
     * period of time, it will trip its breaker and transition to an identity function
     * to avoid garbage collection pauses in V8. See [V8 issue 2070](https://code.google.com/p/v8/issues/detail?id=2070)
     * for more details.
     *
     * @private
     * @param {Function} func The function to associate metadata with.
     * @param {*} data The metadata.
     * @returns {Function} Returns `func`.
     */
    var setData = (function() {
      var count = 0,
          lastCalled = 0;

      return function(key, value) {
        var stamp = now(),
            remaining = HOT_SPAN - (stamp - lastCalled);

        lastCalled = stamp;
        if (remaining > 0) {
          if (++count >= HOT_COUNT) {
            return key;
          }
        } else {
          count = 0;
        }
        return baseSetData(key, value);
      };
    }());

    /**
     * A fallback implementation of `_.isPlainObject` which checks if `value`
     * is an object created by the `Object` constructor or has a `[[Prototype]]`
     * of `null`.
     *
     * @private
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a plain object, else `false`.
     */
    function shimIsPlainObject(value) {
      var Ctor,
          support = lodash.support;

      // Exit early for non `Object` objects.
      if (!(isObjectLike(value) && objToString.call(value) == objectTag) ||
          (!hasOwnProperty.call(value, 'constructor') &&
            (Ctor = value.constructor, typeof Ctor == 'function' && !(Ctor instanceof Ctor)))) {
        return false;
      }
      // IE < 9 iterates inherited properties before own properties. If the first
      // iterated property is an object's own property then there are no inherited
      // enumerable properties.
      var result;
      // In most environments an object's own properties are iterated before
      // its inherited properties. If the last iterated property is an object's
      // own property then there are no inherited enumerable properties.
      baseForIn(value, function(subValue, key) {
        result = key;
      });
      return result === undefined || hasOwnProperty.call(value, result);
    }

    /**
     * A fallback implementation of `Object.keys` which creates an array of the
     * own enumerable property names of `object`.
     *
     * @private
     * @param {Object} object The object to query.
     * @returns {Array} Returns the array of property names.
     */
    function shimKeys(object) {
      var props = keysIn(object),
          propsLength = props.length,
          length = propsLength && object.length,
          support = lodash.support;

      var allowIndexes = length && isLength(length) &&
        (isArray(object) || (support.nonEnumArgs && isArguments(object)));

      var index = -1,
          result = [];

      while (++index < propsLength) {
        var key = props[index];
        if ((allowIndexes && isIndex(key, length)) || hasOwnProperty.call(object, key)) {
          result.push(key);
        }
      }
      return result;
    }

    /**
     * Converts `value` to an array-like object if it is not one.
     *
     * @private
     * @param {*} value The value to process.
     * @returns {Array|Object} Returns the array-like object.
     */
    function toIterable(value) {
      if (value == null) {
        return [];
      }
      if (!isLength(getLength(value))) {
        return values(value);
      }
      return isObject(value) ? value : Object(value);
    }

    /**
     * Converts `value` to an object if it is not one.
     *
     * @private
     * @param {*} value The value to process.
     * @returns {Object} Returns the object.
     */
    function toObject(value) {
      return isObject(value) ? value : Object(value);
    }

    /**
     * Converts `value` to property path array if it is not one.
     *
     * @private
     * @param {*} value The value to process.
     * @returns {Array} Returns the property path array.
     */
    function toPath(value) {
      if (isArray(value)) {
        return value;
      }
      var result = [];
      baseToString(value).replace(rePropName, function(match, number, quote, string) {
        result.push(quote ? string.replace(reEscapeChar, '$1') : (number || match));
      });
      return result;
    }

    /**
     * Creates a clone of `wrapper`.
     *
     * @private
     * @param {Object} wrapper The wrapper to clone.
     * @returns {Object} Returns the cloned wrapper.
     */
    function wrapperClone(wrapper) {
      return wrapper instanceof LazyWrapper
        ? wrapper.clone()
        : new LodashWrapper(wrapper.__wrapped__, wrapper.__chain__, arrayCopy(wrapper.__actions__));
    }

    /*------------------------------------------------------------------------*/

    /**
     * Creates an array of elements split into groups the length of `size`.
     * If `collection` can't be split evenly, the final chunk will be the remaining
     * elements.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The array to process.
     * @param {number} [size=1] The length of each chunk.
     * @param- {Object} [guard] Enables use as a callback for functions like `_.map`.
     * @returns {Array} Returns the new array containing chunks.
     * @example
     *
     * _.chunk(['a', 'b', 'c', 'd'], 2);
     * // => [['a', 'b'], ['c', 'd']]
     *
     * _.chunk(['a', 'b', 'c', 'd'], 3);
     * // => [['a', 'b', 'c'], ['d']]
     */
    function chunk(array, size, guard) {
      if (guard ? isIterateeCall(array, size, guard) : size == null) {
        size = 1;
      } else {
        size = nativeMax(+size || 1, 1);
      }
      var index = 0,
          length = array ? array.length : 0,
          resIndex = -1,
          result = Array(ceil(length / size));

      while (index < length) {
        result[++resIndex] = baseSlice(array, index, (index += size));
      }
      return result;
    }

    /**
     * Creates an array with all falsey values removed. The values `false`, `null`,
     * `0`, `""`, `undefined`, and `NaN` are falsey.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The array to compact.
     * @returns {Array} Returns the new array of filtered values.
     * @example
     *
     * _.compact([0, 1, false, 2, '', 3]);
     * // => [1, 2, 3]
     */
    function compact(array) {
      var index = -1,
          length = array ? array.length : 0,
          resIndex = -1,
          result = [];

      while (++index < length) {
        var value = array[index];
        if (value) {
          result[++resIndex] = value;
        }
      }
      return result;
    }

    /**
     * Creates an array excluding all values of the provided arrays using
     * `SameValueZero` for equality comparisons.
     *
     * **Note:** [`SameValueZero`](https://people.mozilla.org/~jorendorff/es6-draft.html#sec-samevaluezero)
     * comparisons are like strict equality comparisons, e.g. `===`, except that
     * `NaN` matches `NaN`.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The array to inspect.
     * @param {...Array} [values] The arrays of values to exclude.
     * @returns {Array} Returns the new array of filtered values.
     * @example
     *
     * _.difference([1, 2, 3], [4, 2]);
     * // => [1, 3]
     */
    var difference = restParam(function(array, values) {
      return (isArray(array) || isArguments(array))
        ? baseDifference(array, baseFlatten(values, false, true))
        : [];
    });

    /**
     * Creates a slice of `array` with `n` elements dropped from the beginning.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The array to query.
     * @param {number} [n=1] The number of elements to drop.
     * @param- {Object} [guard] Enables use as a callback for functions like `_.map`.
     * @returns {Array} Returns the slice of `array`.
     * @example
     *
     * _.drop([1, 2, 3]);
     * // => [2, 3]
     *
     * _.drop([1, 2, 3], 2);
     * // => [3]
     *
     * _.drop([1, 2, 3], 5);
     * // => []
     *
     * _.drop([1, 2, 3], 0);
     * // => [1, 2, 3]
     */
    function drop(array, n, guard) {
      var length = array ? array.length : 0;
      if (!length) {
        return [];
      }
      if (guard ? isIterateeCall(array, n, guard) : n == null) {
        n = 1;
      }
      return baseSlice(array, n < 0 ? 0 : n);
    }

    /**
     * Creates a slice of `array` with `n` elements dropped from the end.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The array to query.
     * @param {number} [n=1] The number of elements to drop.
     * @param- {Object} [guard] Enables use as a callback for functions like `_.map`.
     * @returns {Array} Returns the slice of `array`.
     * @example
     *
     * _.dropRight([1, 2, 3]);
     * // => [1, 2]
     *
     * _.dropRight([1, 2, 3], 2);
     * // => [1]
     *
     * _.dropRight([1, 2, 3], 5);
     * // => []
     *
     * _.dropRight([1, 2, 3], 0);
     * // => [1, 2, 3]
     */
    function dropRight(array, n, guard) {
      var length = array ? array.length : 0;
      if (!length) {
        return [];
      }
      if (guard ? isIterateeCall(array, n, guard) : n == null) {
        n = 1;
      }
      n = length - (+n || 0);
      return baseSlice(array, 0, n < 0 ? 0 : n);
    }

    /**
     * Creates a slice of `array` excluding elements dropped from the end.
     * Elements are dropped until `predicate` returns falsey. The predicate is
     * bound to `thisArg` and invoked with three arguments: (value, index, array).
     *
     * If a property name is provided for `predicate` the created `_.property`
     * style callback returns the property value of the given element.
     *
     * If a value is also provided for `thisArg` the created `_.matchesProperty`
     * style callback returns `true` for elements that have a matching property
     * value, else `false`.
     *
     * If an object is provided for `predicate` the created `_.matches` style
     * callback returns `true` for elements that match the properties of the given
     * object, else `false`.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The array to query.
     * @param {Function|Object|string} [predicate=_.identity] The function invoked
     *  per iteration.
     * @param {*} [thisArg] The `this` binding of `predicate`.
     * @returns {Array} Returns the slice of `array`.
     * @example
     *
     * _.dropRightWhile([1, 2, 3], function(n) {
     *   return n > 1;
     * });
     * // => [1]
     *
     * var users = [
     *   { 'user': 'barney',  'active': true },
     *   { 'user': 'fred',    'active': false },
     *   { 'user': 'pebbles', 'active': false }
     * ];
     *
     * // using the `_.matches` callback shorthand
     * _.pluck(_.dropRightWhile(users, { 'user': 'pebbles', 'active': false }), 'user');
     * // => ['barney', 'fred']
     *
     * // using the `_.matchesProperty` callback shorthand
     * _.pluck(_.dropRightWhile(users, 'active', false), 'user');
     * // => ['barney']
     *
     * // using the `_.property` callback shorthand
     * _.pluck(_.dropRightWhile(users, 'active'), 'user');
     * // => ['barney', 'fred', 'pebbles']
     */
    function dropRightWhile(array, predicate, thisArg) {
      return (array && array.length)
        ? baseWhile(array, getCallback(predicate, thisArg, 3), true, true)
        : [];
    }

    /**
     * Creates a slice of `array` excluding elements dropped from the beginning.
     * Elements are dropped until `predicate` returns falsey. The predicate is
     * bound to `thisArg` and invoked with three arguments: (value, index, array).
     *
     * If a property name is provided for `predicate` the created `_.property`
     * style callback returns the property value of the given element.
     *
     * If a value is also provided for `thisArg` the created `_.matchesProperty`
     * style callback returns `true` for elements that have a matching property
     * value, else `false`.
     *
     * If an object is provided for `predicate` the created `_.matches` style
     * callback returns `true` for elements that have the properties of the given
     * object, else `false`.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The array to query.
     * @param {Function|Object|string} [predicate=_.identity] The function invoked
     *  per iteration.
     * @param {*} [thisArg] The `this` binding of `predicate`.
     * @returns {Array} Returns the slice of `array`.
     * @example
     *
     * _.dropWhile([1, 2, 3], function(n) {
     *   return n < 3;
     * });
     * // => [3]
     *
     * var users = [
     *   { 'user': 'barney',  'active': false },
     *   { 'user': 'fred',    'active': false },
     *   { 'user': 'pebbles', 'active': true }
     * ];
     *
     * // using the `_.matches` callback shorthand
     * _.pluck(_.dropWhile(users, { 'user': 'barney', 'active': false }), 'user');
     * // => ['fred', 'pebbles']
     *
     * // using the `_.matchesProperty` callback shorthand
     * _.pluck(_.dropWhile(users, 'active', false), 'user');
     * // => ['pebbles']
     *
     * // using the `_.property` callback shorthand
     * _.pluck(_.dropWhile(users, 'active'), 'user');
     * // => ['barney', 'fred', 'pebbles']
     */
    function dropWhile(array, predicate, thisArg) {
      return (array && array.length)
        ? baseWhile(array, getCallback(predicate, thisArg, 3), true)
        : [];
    }

    /**
     * Fills elements of `array` with `value` from `start` up to, but not
     * including, `end`.
     *
     * **Note:** This method mutates `array`.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The array to fill.
     * @param {*} value The value to fill `array` with.
     * @param {number} [start=0] The start position.
     * @param {number} [end=array.length] The end position.
     * @returns {Array} Returns `array`.
     * @example
     *
     * var array = [1, 2, 3];
     *
     * _.fill(array, 'a');
     * console.log(array);
     * // => ['a', 'a', 'a']
     *
     * _.fill(Array(3), 2);
     * // => [2, 2, 2]
     *
     * _.fill([4, 6, 8], '*', 1, 2);
     * // => [4, '*', 8]
     */
    function fill(array, value, start, end) {
      var length = array ? array.length : 0;
      if (!length) {
        return [];
      }
      if (start && typeof start != 'number' && isIterateeCall(array, value, start)) {
        start = 0;
        end = length;
      }
      return baseFill(array, value, start, end);
    }

    /**
     * This method is like `_.find` except that it returns the index of the first
     * element `predicate` returns truthy for instead of the element itself.
     *
     * If a property name is provided for `predicate` the created `_.property`
     * style callback returns the property value of the given element.
     *
     * If a value is also provided for `thisArg` the created `_.matchesProperty`
     * style callback returns `true` for elements that have a matching property
     * value, else `false`.
     *
     * If an object is provided for `predicate` the created `_.matches` style
     * callback returns `true` for elements that have the properties of the given
     * object, else `false`.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The array to search.
     * @param {Function|Object|string} [predicate=_.identity] The function invoked
     *  per iteration.
     * @param {*} [thisArg] The `this` binding of `predicate`.
     * @returns {number} Returns the index of the found element, else `-1`.
     * @example
     *
     * var users = [
     *   { 'user': 'barney',  'active': false },
     *   { 'user': 'fred',    'active': false },
     *   { 'user': 'pebbles', 'active': true }
     * ];
     *
     * _.findIndex(users, function(chr) {
     *   return chr.user == 'barney';
     * });
     * // => 0
     *
     * // using the `_.matches` callback shorthand
     * _.findIndex(users, { 'user': 'fred', 'active': false });
     * // => 1
     *
     * // using the `_.matchesProperty` callback shorthand
     * _.findIndex(users, 'active', false);
     * // => 0
     *
     * // using the `_.property` callback shorthand
     * _.findIndex(users, 'active');
     * // => 2
     */
    var findIndex = createFindIndex();

    /**
     * This method is like `_.findIndex` except that it iterates over elements
     * of `collection` from right to left.
     *
     * If a property name is provided for `predicate` the created `_.property`
     * style callback returns the property value of the given element.
     *
     * If a value is also provided for `thisArg` the created `_.matchesProperty`
     * style callback returns `true` for elements that have a matching property
     * value, else `false`.
     *
     * If an object is provided for `predicate` the created `_.matches` style
     * callback returns `true` for elements that have the properties of the given
     * object, else `false`.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The array to search.
     * @param {Function|Object|string} [predicate=_.identity] The function invoked
     *  per iteration.
     * @param {*} [thisArg] The `this` binding of `predicate`.
     * @returns {number} Returns the index of the found element, else `-1`.
     * @example
     *
     * var users = [
     *   { 'user': 'barney',  'active': true },
     *   { 'user': 'fred',    'active': false },
     *   { 'user': 'pebbles', 'active': false }
     * ];
     *
     * _.findLastIndex(users, function(chr) {
     *   return chr.user == 'pebbles';
     * });
     * // => 2
     *
     * // using the `_.matches` callback shorthand
     * _.findLastIndex(users, { 'user': 'barney', 'active': true });
     * // => 0
     *
     * // using the `_.matchesProperty` callback shorthand
     * _.findLastIndex(users, 'active', false);
     * // => 2
     *
     * // using the `_.property` callback shorthand
     * _.findLastIndex(users, 'active');
     * // => 0
     */
    var findLastIndex = createFindIndex(true);

    /**
     * Gets the first element of `array`.
     *
     * @static
     * @memberOf _
     * @alias head
     * @category Array
     * @param {Array} array The array to query.
     * @returns {*} Returns the first element of `array`.
     * @example
     *
     * _.first([1, 2, 3]);
     * // => 1
     *
     * _.first([]);
     * // => undefined
     */
    function first(array) {
      return array ? array[0] : undefined;
    }

    /**
     * Flattens a nested array. If `isDeep` is `true` the array is recursively
     * flattened, otherwise it is only flattened a single level.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The array to flatten.
     * @param {boolean} [isDeep] Specify a deep flatten.
     * @param- {Object} [guard] Enables use as a callback for functions like `_.map`.
     * @returns {Array} Returns the new flattened array.
     * @example
     *
     * _.flatten([1, [2, 3, [4]]]);
     * // => [1, 2, 3, [4]]
     *
     * // using `isDeep`
     * _.flatten([1, [2, 3, [4]]], true);
     * // => [1, 2, 3, 4]
     */
    function flatten(array, isDeep, guard) {
      var length = array ? array.length : 0;
      if (guard && isIterateeCall(array, isDeep, guard)) {
        isDeep = false;
      }
      return length ? baseFlatten(array, isDeep) : [];
    }

    /**
     * Recursively flattens a nested array.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The array to recursively flatten.
     * @returns {Array} Returns the new flattened array.
     * @example
     *
     * _.flattenDeep([1, [2, 3, [4]]]);
     * // => [1, 2, 3, 4]
     */
    function flattenDeep(array) {
      var length = array ? array.length : 0;
      return length ? baseFlatten(array, true) : [];
    }

    /**
     * Gets the index at which the first occurrence of `value` is found in `array`
     * using `SameValueZero` for equality comparisons. If `fromIndex` is negative,
     * it is used as the offset from the end of `array`. If `array` is sorted
     * providing `true` for `fromIndex` performs a faster binary search.
     *
     * **Note:** [`SameValueZero`](https://people.mozilla.org/~jorendorff/es6-draft.html#sec-samevaluezero)
     * comparisons are like strict equality comparisons, e.g. `===`, except that
     * `NaN` matches `NaN`.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The array to search.
     * @param {*} value The value to search for.
     * @param {boolean|number} [fromIndex=0] The index to search from or `true`
     *  to perform a binary search on a sorted array.
     * @returns {number} Returns the index of the matched value, else `-1`.
     * @example
     *
     * _.indexOf([1, 2, 1, 2], 2);
     * // => 1
     *
     * // using `fromIndex`
     * _.indexOf([1, 2, 1, 2], 2, 2);
     * // => 3
     *
     * // performing a binary search
     * _.indexOf([1, 1, 2, 2], 2, true);
     * // => 2
     */
    function indexOf(array, value, fromIndex) {
      var length = array ? array.length : 0;
      if (!length) {
        return -1;
      }
      if (typeof fromIndex == 'number') {
        fromIndex = fromIndex < 0 ? nativeMax(length + fromIndex, 0) : fromIndex;
      } else if (fromIndex) {
        var index = binaryIndex(array, value),
            other = array[index];

        if (value === value ? (value === other) : (other !== other)) {
          return index;
        }
        return -1;
      }
      return baseIndexOf(array, value, fromIndex || 0);
    }

    /**
     * Gets all but the last element of `array`.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The array to query.
     * @returns {Array} Returns the slice of `array`.
     * @example
     *
     * _.initial([1, 2, 3]);
     * // => [1, 2]
     */
    function initial(array) {
      return dropRight(array, 1);
    }

    /**
     * Creates an array of unique values in all provided arrays using `SameValueZero`
     * for equality comparisons.
     *
     * **Note:** [`SameValueZero`](https://people.mozilla.org/~jorendorff/es6-draft.html#sec-samevaluezero)
     * comparisons are like strict equality comparisons, e.g. `===`, except that
     * `NaN` matches `NaN`.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {...Array} [arrays] The arrays to inspect.
     * @returns {Array} Returns the new array of shared values.
     * @example
     * _.intersection([1, 2], [4, 2], [2, 1]);
     * // => [2]
     */
    function intersection() {
      var args = [],
          argsIndex = -1,
          argsLength = arguments.length,
          caches = [],
          indexOf = getIndexOf(),
          isCommon = indexOf == baseIndexOf,
          result = [];

      while (++argsIndex < argsLength) {
        var value = arguments[argsIndex];
        if (isArray(value) || isArguments(value)) {
          args.push(value);
          caches.push((isCommon && value.length >= 120) ? createCache(argsIndex && value) : null);
        }
      }
      argsLength = args.length;
      if (argsLength < 2) {
        return result;
      }
      var array = args[0],
          index = -1,
          length = array ? array.length : 0,
          seen = caches[0];

      outer:
      while (++index < length) {
        value = array[index];
        if ((seen ? cacheIndexOf(seen, value) : indexOf(result, value, 0)) < 0) {
          argsIndex = argsLength;
          while (--argsIndex) {
            var cache = caches[argsIndex];
            if ((cache ? cacheIndexOf(cache, value) : indexOf(args[argsIndex], value, 0)) < 0) {
              continue outer;
            }
          }
          if (seen) {
            seen.push(value);
          }
          result.push(value);
        }
      }
      return result;
    }

    /**
     * Gets the last element of `array`.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The array to query.
     * @returns {*} Returns the last element of `array`.
     * @example
     *
     * _.last([1, 2, 3]);
     * // => 3
     */
    function last(array) {
      var length = array ? array.length : 0;
      return length ? array[length - 1] : undefined;
    }

    /**
     * This method is like `_.indexOf` except that it iterates over elements of
     * `array` from right to left.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The array to search.
     * @param {*} value The value to search for.
     * @param {boolean|number} [fromIndex=array.length-1] The index to search from
     *  or `true` to perform a binary search on a sorted array.
     * @returns {number} Returns the index of the matched value, else `-1`.
     * @example
     *
     * _.lastIndexOf([1, 2, 1, 2], 2);
     * // => 3
     *
     * // using `fromIndex`
     * _.lastIndexOf([1, 2, 1, 2], 2, 2);
     * // => 1
     *
     * // performing a binary search
     * _.lastIndexOf([1, 1, 2, 2], 2, true);
     * // => 3
     */
    function lastIndexOf(array, value, fromIndex) {
      var length = array ? array.length : 0;
      if (!length) {
        return -1;
      }
      var index = length;
      if (typeof fromIndex == 'number') {
        index = (fromIndex < 0 ? nativeMax(length + fromIndex, 0) : nativeMin(fromIndex || 0, length - 1)) + 1;
      } else if (fromIndex) {
        index = binaryIndex(array, value, true) - 1;
        var other = array[index];
        if (value === value ? (value === other) : (other !== other)) {
          return index;
        }
        return -1;
      }
      if (value !== value) {
        return indexOfNaN(array, index, true);
      }
      while (index--) {
        if (array[index] === value) {
          return index;
        }
      }
      return -1;
    }

    /**
     * Removes all provided values from `array` using `SameValueZero` for equality
     * comparisons.
     *
     * **Notes:**
     *  - Unlike `_.without`, this method mutates `array`
     *  - [`SameValueZero`](https://people.mozilla.org/~jorendorff/es6-draft.html#sec-samevaluezero)
     *    comparisons are like strict equality comparisons, e.g. `===`, except
     *    that `NaN` matches `NaN`
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The array to modify.
     * @param {...*} [values] The values to remove.
     * @returns {Array} Returns `array`.
     * @example
     *
     * var array = [1, 2, 3, 1, 2, 3];
     *
     * _.pull(array, 2, 3);
     * console.log(array);
     * // => [1, 1]
     */
    function pull() {
      var args = arguments,
          array = args[0];

      if (!(array && array.length)) {
        return array;
      }
      var index = 0,
          indexOf = getIndexOf(),
          length = args.length;

      while (++index < length) {
        var fromIndex = 0,
            value = args[index];

        while ((fromIndex = indexOf(array, value, fromIndex)) > -1) {
          splice.call(array, fromIndex, 1);
        }
      }
      return array;
    }

    /**
     * Removes elements from `array` corresponding to the given indexes and returns
     * an array of the removed elements. Indexes may be specified as an array of
     * indexes or as individual arguments.
     *
     * **Note:** Unlike `_.at`, this method mutates `array`.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The array to modify.
     * @param {...(number|number[])} [indexes] The indexes of elements to remove,
     *  specified as individual indexes or arrays of indexes.
     * @returns {Array} Returns the new array of removed elements.
     * @example
     *
     * var array = [5, 10, 15, 20];
     * var evens = _.pullAt(array, 1, 3);
     *
     * console.log(array);
     * // => [5, 15]
     *
     * console.log(evens);
     * // => [10, 20]
     */
    var pullAt = restParam(function(array, indexes) {
      array || (array = []);
      indexes = baseFlatten(indexes);

      var result = baseAt(array, indexes);
      basePullAt(array, indexes.sort(baseCompareAscending));
      return result;
    });

    /**
     * Removes all elements from `array` that `predicate` returns truthy for
     * and returns an array of the removed elements. The predicate is bound to
     * `thisArg` and invoked with three arguments: (value, index, array).
     *
     * If a property name is provided for `predicate` the created `_.property`
     * style callback returns the property value of the given element.
     *
     * If a value is also provided for `thisArg` the created `_.matchesProperty`
     * style callback returns `true` for elements that have a matching property
     * value, else `false`.
     *
     * If an object is provided for `predicate` the created `_.matches` style
     * callback returns `true` for elements that have the properties of the given
     * object, else `false`.
     *
     * **Note:** Unlike `_.filter`, this method mutates `array`.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The array to modify.
     * @param {Function|Object|string} [predicate=_.identity] The function invoked
     *  per iteration.
     * @param {*} [thisArg] The `this` binding of `predicate`.
     * @returns {Array} Returns the new array of removed elements.
     * @example
     *
     * var array = [1, 2, 3, 4];
     * var evens = _.remove(array, function(n) {
     *   return n % 2 == 0;
     * });
     *
     * console.log(array);
     * // => [1, 3]
     *
     * console.log(evens);
     * // => [2, 4]
     */
    function remove(array, predicate, thisArg) {
      var result = [];
      if (!(array && array.length)) {
        return result;
      }
      var index = -1,
          indexes = [],
          length = array.length;

      predicate = getCallback(predicate, thisArg, 3);
      while (++index < length) {
        var value = array[index];
        if (predicate(value, index, array)) {
          result.push(value);
          indexes.push(index);
        }
      }
      basePullAt(array, indexes);
      return result;
    }

    /**
     * Gets all but the first element of `array`.
     *
     * @static
     * @memberOf _
     * @alias tail
     * @category Array
     * @param {Array} array The array to query.
     * @returns {Array} Returns the slice of `array`.
     * @example
     *
     * _.rest([1, 2, 3]);
     * // => [2, 3]
     */
    function rest(array) {
      return drop(array, 1);
    }

    /**
     * Creates a slice of `array` from `start` up to, but not including, `end`.
     *
     * **Note:** This method is used instead of `Array#slice` to support node
     * lists in IE < 9 and to ensure dense arrays are returned.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The array to slice.
     * @param {number} [start=0] The start position.
     * @param {number} [end=array.length] The end position.
     * @returns {Array} Returns the slice of `array`.
     */
    function slice(array, start, end) {
      var length = array ? array.length : 0;
      if (!length) {
        return [];
      }
      if (end && typeof end != 'number' && isIterateeCall(array, start, end)) {
        start = 0;
        end = length;
      }
      return baseSlice(array, start, end);
    }

    /**
     * Uses a binary search to determine the lowest index at which `value` should
     * be inserted into `array` in order to maintain its sort order. If an iteratee
     * function is provided it is invoked for `value` and each element of `array`
     * to compute their sort ranking. The iteratee is bound to `thisArg` and
     * invoked with one argument; (value).
     *
     * If a property name is provided for `iteratee` the created `_.property`
     * style callback returns the property value of the given element.
     *
     * If a value is also provided for `thisArg` the created `_.matchesProperty`
     * style callback returns `true` for elements that have a matching property
     * value, else `false`.
     *
     * If an object is provided for `iteratee` the created `_.matches` style
     * callback returns `true` for elements that have the properties of the given
     * object, else `false`.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The sorted array to inspect.
     * @param {*} value The value to evaluate.
     * @param {Function|Object|string} [iteratee=_.identity] The function invoked
     *  per iteration.
     * @param {*} [thisArg] The `this` binding of `iteratee`.
     * @returns {number} Returns the index at which `value` should be inserted
     *  into `array`.
     * @example
     *
     * _.sortedIndex([30, 50], 40);
     * // => 1
     *
     * _.sortedIndex([4, 4, 5, 5], 5);
     * // => 2
     *
     * var dict = { 'data': { 'thirty': 30, 'forty': 40, 'fifty': 50 } };
     *
     * // using an iteratee function
     * _.sortedIndex(['thirty', 'fifty'], 'forty', function(word) {
     *   return this.data[word];
     * }, dict);
     * // => 1
     *
     * // using the `_.property` callback shorthand
     * _.sortedIndex([{ 'x': 30 }, { 'x': 50 }], { 'x': 40 }, 'x');
     * // => 1
     */
    var sortedIndex = createSortedIndex();

    /**
     * This method is like `_.sortedIndex` except that it returns the highest
     * index at which `value` should be inserted into `array` in order to
     * maintain its sort order.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The sorted array to inspect.
     * @param {*} value The value to evaluate.
     * @param {Function|Object|string} [iteratee=_.identity] The function invoked
     *  per iteration.
     * @param {*} [thisArg] The `this` binding of `iteratee`.
     * @returns {number} Returns the index at which `value` should be inserted
     *  into `array`.
     * @example
     *
     * _.sortedLastIndex([4, 4, 5, 5], 5);
     * // => 4
     */
    var sortedLastIndex = createSortedIndex(true);

    /**
     * Creates a slice of `array` with `n` elements taken from the beginning.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The array to query.
     * @param {number} [n=1] The number of elements to take.
     * @param- {Object} [guard] Enables use as a callback for functions like `_.map`.
     * @returns {Array} Returns the slice of `array`.
     * @example
     *
     * _.take([1, 2, 3]);
     * // => [1]
     *
     * _.take([1, 2, 3], 2);
     * // => [1, 2]
     *
     * _.take([1, 2, 3], 5);
     * // => [1, 2, 3]
     *
     * _.take([1, 2, 3], 0);
     * // => []
     */
    function take(array, n, guard) {
      var length = array ? array.length : 0;
      if (!length) {
        return [];
      }
      if (guard ? isIterateeCall(array, n, guard) : n == null) {
        n = 1;
      }
      return baseSlice(array, 0, n < 0 ? 0 : n);
    }

    /**
     * Creates a slice of `array` with `n` elements taken from the end.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The array to query.
     * @param {number} [n=1] The number of elements to take.
     * @param- {Object} [guard] Enables use as a callback for functions like `_.map`.
     * @returns {Array} Returns the slice of `array`.
     * @example
     *
     * _.takeRight([1, 2, 3]);
     * // => [3]
     *
     * _.takeRight([1, 2, 3], 2);
     * // => [2, 3]
     *
     * _.takeRight([1, 2, 3], 5);
     * // => [1, 2, 3]
     *
     * _.takeRight([1, 2, 3], 0);
     * // => []
     */
    function takeRight(array, n, guard) {
      var length = array ? array.length : 0;
      if (!length) {
        return [];
      }
      if (guard ? isIterateeCall(array, n, guard) : n == null) {
        n = 1;
      }
      n = length - (+n || 0);
      return baseSlice(array, n < 0 ? 0 : n);
    }

    /**
     * Creates a slice of `array` with elements taken from the end. Elements are
     * taken until `predicate` returns falsey. The predicate is bound to `thisArg`
     * and invoked with three arguments: (value, index, array).
     *
     * If a property name is provided for `predicate` the created `_.property`
     * style callback returns the property value of the given element.
     *
     * If a value is also provided for `thisArg` the created `_.matchesProperty`
     * style callback returns `true` for elements that have a matching property
     * value, else `false`.
     *
     * If an object is provided for `predicate` the created `_.matches` style
     * callback returns `true` for elements that have the properties of the given
     * object, else `false`.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The array to query.
     * @param {Function|Object|string} [predicate=_.identity] The function invoked
     *  per iteration.
     * @param {*} [thisArg] The `this` binding of `predicate`.
     * @returns {Array} Returns the slice of `array`.
     * @example
     *
     * _.takeRightWhile([1, 2, 3], function(n) {
     *   return n > 1;
     * });
     * // => [2, 3]
     *
     * var users = [
     *   { 'user': 'barney',  'active': true },
     *   { 'user': 'fred',    'active': false },
     *   { 'user': 'pebbles', 'active': false }
     * ];
     *
     * // using the `_.matches` callback shorthand
     * _.pluck(_.takeRightWhile(users, { 'user': 'pebbles', 'active': false }), 'user');
     * // => ['pebbles']
     *
     * // using the `_.matchesProperty` callback shorthand
     * _.pluck(_.takeRightWhile(users, 'active', false), 'user');
     * // => ['fred', 'pebbles']
     *
     * // using the `_.property` callback shorthand
     * _.pluck(_.takeRightWhile(users, 'active'), 'user');
     * // => []
     */
    function takeRightWhile(array, predicate, thisArg) {
      return (array && array.length)
        ? baseWhile(array, getCallback(predicate, thisArg, 3), false, true)
        : [];
    }

    /**
     * Creates a slice of `array` with elements taken from the beginning. Elements
     * are taken until `predicate` returns falsey. The predicate is bound to
     * `thisArg` and invoked with three arguments: (value, index, array).
     *
     * If a property name is provided for `predicate` the created `_.property`
     * style callback returns the property value of the given element.
     *
     * If a value is also provided for `thisArg` the created `_.matchesProperty`
     * style callback returns `true` for elements that have a matching property
     * value, else `false`.
     *
     * If an object is provided for `predicate` the created `_.matches` style
     * callback returns `true` for elements that have the properties of the given
     * object, else `false`.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The array to query.
     * @param {Function|Object|string} [predicate=_.identity] The function invoked
     *  per iteration.
     * @param {*} [thisArg] The `this` binding of `predicate`.
     * @returns {Array} Returns the slice of `array`.
     * @example
     *
     * _.takeWhile([1, 2, 3], function(n) {
     *   return n < 3;
     * });
     * // => [1, 2]
     *
     * var users = [
     *   { 'user': 'barney',  'active': false },
     *   { 'user': 'fred',    'active': false},
     *   { 'user': 'pebbles', 'active': true }
     * ];
     *
     * // using the `_.matches` callback shorthand
     * _.pluck(_.takeWhile(users, { 'user': 'barney', 'active': false }), 'user');
     * // => ['barney']
     *
     * // using the `_.matchesProperty` callback shorthand
     * _.pluck(_.takeWhile(users, 'active', false), 'user');
     * // => ['barney', 'fred']
     *
     * // using the `_.property` callback shorthand
     * _.pluck(_.takeWhile(users, 'active'), 'user');
     * // => []
     */
    function takeWhile(array, predicate, thisArg) {
      return (array && array.length)
        ? baseWhile(array, getCallback(predicate, thisArg, 3))
        : [];
    }

    /**
     * Creates an array of unique values, in order, of the provided arrays using
     * `SameValueZero` for equality comparisons.
     *
     * **Note:** [`SameValueZero`](https://people.mozilla.org/~jorendorff/es6-draft.html#sec-samevaluezero)
     * comparisons are like strict equality comparisons, e.g. `===`, except that
     * `NaN` matches `NaN`.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {...Array} [arrays] The arrays to inspect.
     * @returns {Array} Returns the new array of combined values.
     * @example
     *
     * _.union([1, 2], [4, 2], [2, 1]);
     * // => [1, 2, 4]
     */
    var union = restParam(function(arrays) {
      return baseUniq(baseFlatten(arrays, false, true));
    });

    /**
     * Creates a duplicate-free version of an array, using `SameValueZero` for
     * equality comparisons, in which only the first occurence of each element
     * is kept. Providing `true` for `isSorted` performs a faster search algorithm
     * for sorted arrays. If an iteratee function is provided it is invoked for
     * each element in the array to generate the criterion by which uniqueness
     * is computed. The `iteratee` is bound to `thisArg` and invoked with three
     * arguments: (value, index, array).
     *
     * If a property name is provided for `iteratee` the created `_.property`
     * style callback returns the property value of the given element.
     *
     * If a value is also provided for `thisArg` the created `_.matchesProperty`
     * style callback returns `true` for elements that have a matching property
     * value, else `false`.
     *
     * If an object is provided for `iteratee` the created `_.matches` style
     * callback returns `true` for elements that have the properties of the given
     * object, else `false`.
     *
     * **Note:** [`SameValueZero`](https://people.mozilla.org/~jorendorff/es6-draft.html#sec-samevaluezero)
     * comparisons are like strict equality comparisons, e.g. `===`, except that
     * `NaN` matches `NaN`.
     *
     * @static
     * @memberOf _
     * @alias unique
     * @category Array
     * @param {Array} array The array to inspect.
     * @param {boolean} [isSorted] Specify the array is sorted.
     * @param {Function|Object|string} [iteratee] The function invoked per iteration.
     * @param {*} [thisArg] The `this` binding of `iteratee`.
     * @returns {Array} Returns the new duplicate-value-free array.
     * @example
     *
     * _.uniq([2, 1, 2]);
     * // => [2, 1]
     *
     * // using `isSorted`
     * _.uniq([1, 1, 2], true);
     * // => [1, 2]
     *
     * // using an iteratee function
     * _.uniq([1, 2.5, 1.5, 2], function(n) {
     *   return this.floor(n);
     * }, Math);
     * // => [1, 2.5]
     *
     * // using the `_.property` callback shorthand
     * _.uniq([{ 'x': 1 }, { 'x': 2 }, { 'x': 1 }], 'x');
     * // => [{ 'x': 1 }, { 'x': 2 }]
     */
    function uniq(array, isSorted, iteratee, thisArg) {
      var length = array ? array.length : 0;
      if (!length) {
        return [];
      }
      if (isSorted != null && typeof isSorted != 'boolean') {
        thisArg = iteratee;
        iteratee = isIterateeCall(array, isSorted, thisArg) ? null : isSorted;
        isSorted = false;
      }
      var func = getCallback();
      if (!(func === baseCallback && iteratee == null)) {
        iteratee = func(iteratee, thisArg, 3);
      }
      return (isSorted && getIndexOf() == baseIndexOf)
        ? sortedUniq(array, iteratee)
        : baseUniq(array, iteratee);
    }

    /**
     * This method is like `_.zip` except that it accepts an array of grouped
     * elements and creates an array regrouping the elements to their pre-`_.zip`
     * configuration.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The array of grouped elements to process.
     * @returns {Array} Returns the new array of regrouped elements.
     * @example
     *
     * var zipped = _.zip(['fred', 'barney'], [30, 40], [true, false]);
     * // => [['fred', 30, true], ['barney', 40, false]]
     *
     * _.unzip(zipped);
     * // => [['fred', 'barney'], [30, 40], [true, false]]
     */
    function unzip(array) {
      var index = -1,
          length = (array && array.length && arrayMax(arrayMap(array, getLength))) >>> 0,
          result = Array(length);

      while (++index < length) {
        result[index] = arrayMap(array, baseProperty(index));
      }
      return result;
    }

    /**
     * Creates an array excluding all provided values using `SameValueZero` for
     * equality comparisons.
     *
     * **Note:** [`SameValueZero`](https://people.mozilla.org/~jorendorff/es6-draft.html#sec-samevaluezero)
     * comparisons are like strict equality comparisons, e.g. `===`, except that
     * `NaN` matches `NaN`.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The array to filter.
     * @param {...*} [values] The values to exclude.
     * @returns {Array} Returns the new array of filtered values.
     * @example
     *
     * _.without([1, 2, 1, 3], 1, 2);
     * // => [3]
     */
    var without = restParam(function(array, values) {
      return (isArray(array) || isArguments(array))
        ? baseDifference(array, values)
        : [];
    });

    /**
     * Creates an array that is the [symmetric difference](https://en.wikipedia.org/wiki/Symmetric_difference)
     * of the provided arrays.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {...Array} [arrays] The arrays to inspect.
     * @returns {Array} Returns the new array of values.
     * @example
     *
     * _.xor([1, 2], [4, 2]);
     * // => [1, 4]
     */
    function xor() {
      var index = -1,
          length = arguments.length;

      while (++index < length) {
        var array = arguments[index];
        if (isArray(array) || isArguments(array)) {
          var result = result
            ? baseDifference(result, array).concat(baseDifference(array, result))
            : array;
        }
      }
      return result ? baseUniq(result) : [];
    }

    /**
     * Creates an array of grouped elements, the first of which contains the first
     * elements of the given arrays, the second of which contains the second elements
     * of the given arrays, and so on.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {...Array} [arrays] The arrays to process.
     * @returns {Array} Returns the new array of grouped elements.
     * @example
     *
     * _.zip(['fred', 'barney'], [30, 40], [true, false]);
     * // => [['fred', 30, true], ['barney', 40, false]]
     */
    var zip = restParam(unzip);

    /**
     * The inverse of `_.pairs`; this method returns an object composed from arrays
     * of property names and values. Provide either a single two dimensional array,
     * e.g. `[[key1, value1], [key2, value2]]` or two arrays, one of property names
     * and one of corresponding values.
     *
     * @static
     * @memberOf _
     * @alias object
     * @category Array
     * @param {Array} props The property names.
     * @param {Array} [values=[]] The property values.
     * @returns {Object} Returns the new object.
     * @example
     *
     * _.zipObject([['fred', 30], ['barney', 40]]);
     * // => { 'fred': 30, 'barney': 40 }
     *
     * _.zipObject(['fred', 'barney'], [30, 40]);
     * // => { 'fred': 30, 'barney': 40 }
     */
    function zipObject(props, values) {
      var index = -1,
          length = props ? props.length : 0,
          result = {};

      if (length && !values && !isArray(props[0])) {
        values = [];
      }
      while (++index < length) {
        var key = props[index];
        if (values) {
          result[key] = values[index];
        } else if (key) {
          result[key[0]] = key[1];
        }
      }
      return result;
    }

    /*------------------------------------------------------------------------*/

    /**
     * Creates a `lodash` object that wraps `value` with explicit method
     * chaining enabled.
     *
     * @static
     * @memberOf _
     * @category Chain
     * @param {*} value The value to wrap.
     * @returns {Object} Returns the new `lodash` wrapper instance.
     * @example
     *
     * var users = [
     *   { 'user': 'barney',  'age': 36 },
     *   { 'user': 'fred',    'age': 40 },
     *   { 'user': 'pebbles', 'age': 1 }
     * ];
     *
     * var youngest = _.chain(users)
     *   .sortBy('age')
     *   .map(function(chr) {
     *     return chr.user + ' is ' + chr.age;
     *   })
     *   .first()
     *   .value();
     * // => 'pebbles is 1'
     */
    function chain(value) {
      var result = lodash(value);
      result.__chain__ = true;
      return result;
    }

    /**
     * This method invokes `interceptor` and returns `value`. The interceptor is
     * bound to `thisArg` and invoked with one argument; (value). The purpose of
     * this method is to "tap into" a method chain in order to perform operations
     * on intermediate results within the chain.
     *
     * @static
     * @memberOf _
     * @category Chain
     * @param {*} value The value to provide to `interceptor`.
     * @param {Function} interceptor The function to invoke.
     * @param {*} [thisArg] The `this` binding of `interceptor`.
     * @returns {*} Returns `value`.
     * @example
     *
     * _([1, 2, 3])
     *  .tap(function(array) {
     *    array.pop();
     *  })
     *  .reverse()
     *  .value();
     * // => [2, 1]
     */
    function tap(value, interceptor, thisArg) {
      interceptor.call(thisArg, value);
      return value;
    }

    /**
     * This method is like `_.tap` except that it returns the result of `interceptor`.
     *
     * @static
     * @memberOf _
     * @category Chain
     * @param {*} value The value to provide to `interceptor`.
     * @param {Function} interceptor The function to invoke.
     * @param {*} [thisArg] The `this` binding of `interceptor`.
     * @returns {*} Returns the result of `interceptor`.
     * @example
     *
     * _('  abc  ')
     *  .chain()
     *  .trim()
     *  .thru(function(value) {
     *    return [value];
     *  })
     *  .value();
     * // => ['abc']
     */
    function thru(value, interceptor, thisArg) {
      return interceptor.call(thisArg, value);
    }

    /**
     * Enables explicit method chaining on the wrapper object.
     *
     * @name chain
     * @memberOf _
     * @category Chain
     * @returns {Object} Returns the new `lodash` wrapper instance.
     * @example
     *
     * var users = [
     *   { 'user': 'barney', 'age': 36 },
     *   { 'user': 'fred',   'age': 40 }
     * ];
     *
     * // without explicit chaining
     * _(users).first();
     * // => { 'user': 'barney', 'age': 36 }
     *
     * // with explicit chaining
     * _(users).chain()
     *   .first()
     *   .pick('user')
     *   .value();
     * // => { 'user': 'barney' }
     */
    function wrapperChain() {
      return chain(this);
    }

    /**
     * Executes the chained sequence and returns the wrapped result.
     *
     * @name commit
     * @memberOf _
     * @category Chain
     * @returns {Object} Returns the new `lodash` wrapper instance.
     * @example
     *
     * var array = [1, 2];
     * var wrapper = _(array).push(3);
     *
     * console.log(array);
     * // => [1, 2]
     *
     * wrapper = wrapper.commit();
     * console.log(array);
     * // => [1, 2, 3]
     *
     * wrapper.last();
     * // => 3
     *
     * console.log(array);
     * // => [1, 2, 3]
     */
    function wrapperCommit() {
      return new LodashWrapper(this.value(), this.__chain__);
    }

    /**
     * Creates a clone of the chained sequence planting `value` as the wrapped value.
     *
     * @name plant
     * @memberOf _
     * @category Chain
     * @returns {Object} Returns the new `lodash` wrapper instance.
     * @example
     *
     * var array = [1, 2];
     * var wrapper = _(array).map(function(value) {
     *   return Math.pow(value, 2);
     * });
     *
     * var other = [3, 4];
     * var otherWrapper = wrapper.plant(other);
     *
     * otherWrapper.value();
     * // => [9, 16]
     *
     * wrapper.value();
     * // => [1, 4]
     */
    function wrapperPlant(value) {
      var result,
          parent = this;

      while (parent instanceof baseLodash) {
        var clone = wrapperClone(parent);
        if (result) {
          previous.__wrapped__ = clone;
        } else {
          result = clone;
        }
        var previous = clone;
        parent = parent.__wrapped__;
      }
      previous.__wrapped__ = value;
      return result;
    }

    /**
     * Reverses the wrapped array so the first element becomes the last, the
     * second element becomes the second to last, and so on.
     *
     * **Note:** This method mutates the wrapped array.
     *
     * @name reverse
     * @memberOf _
     * @category Chain
     * @returns {Object} Returns the new reversed `lodash` wrapper instance.
     * @example
     *
     * var array = [1, 2, 3];
     *
     * _(array).reverse().value()
     * // => [3, 2, 1]
     *
     * console.log(array);
     * // => [3, 2, 1]
     */
    function wrapperReverse() {
      var value = this.__wrapped__;
      if (value instanceof LazyWrapper) {
        if (this.__actions__.length) {
          value = new LazyWrapper(this);
        }
        return new LodashWrapper(value.reverse(), this.__chain__);
      }
      return this.thru(function(value) {
        return value.reverse();
      });
    }

    /**
     * Produces the result of coercing the unwrapped value to a string.
     *
     * @name toString
     * @memberOf _
     * @category Chain
     * @returns {string} Returns the coerced string value.
     * @example
     *
     * _([1, 2, 3]).toString();
     * // => '1,2,3'
     */
    function wrapperToString() {
      return (this.value() + '');
    }

    /**
     * Executes the chained sequence to extract the unwrapped value.
     *
     * @name value
     * @memberOf _
     * @alias run, toJSON, valueOf
     * @category Chain
     * @returns {*} Returns the resolved unwrapped value.
     * @example
     *
     * _([1, 2, 3]).value();
     * // => [1, 2, 3]
     */
    function wrapperValue() {
      return baseWrapperValue(this.__wrapped__, this.__actions__);
    }

    /*------------------------------------------------------------------------*/

    /**
     * Creates an array of elements corresponding to the given keys, or indexes,
     * of `collection`. Keys may be specified as individual arguments or as arrays
     * of keys.
     *
     * @static
     * @memberOf _
     * @category Collection
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {...(number|number[]|string|string[])} [props] The property names
     *  or indexes of elements to pick, specified individually or in arrays.
     * @returns {Array} Returns the new array of picked elements.
     * @example
     *
     * _.at(['a', 'b', 'c'], [0, 2]);
     * // => ['a', 'c']
     *
     * _.at(['barney', 'fred', 'pebbles'], 0, 2);
     * // => ['barney', 'pebbles']
     */
    var at = restParam(function(collection, props) {
      var length = collection ? getLength(collection) : 0;
      if (isLength(length)) {
        collection = toIterable(collection);
      }
      return baseAt(collection, baseFlatten(props));
    });

    /**
     * Creates an object composed of keys generated from the results of running
     * each element of `collection` through `iteratee`. The corresponding value
     * of each key is the number of times the key was returned by `iteratee`.
     * The `iteratee` is bound to `thisArg` and invoked with three arguments:
     * (value, index|key, collection).
     *
     * If a property name is provided for `iteratee` the created `_.property`
     * style callback returns the property value of the given element.
     *
     * If a value is also provided for `thisArg` the created `_.matchesProperty`
     * style callback returns `true` for elements that have a matching property
     * value, else `false`.
     *
     * If an object is provided for `iteratee` the created `_.matches` style
     * callback returns `true` for elements that have the properties of the given
     * object, else `false`.
     *
     * @static
     * @memberOf _
     * @category Collection
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function|Object|string} [iteratee=_.identity] The function invoked
     *  per iteration.
     * @param {*} [thisArg] The `this` binding of `iteratee`.
     * @returns {Object} Returns the composed aggregate object.
     * @example
     *
     * _.countBy([4.3, 6.1, 6.4], function(n) {
     *   return Math.floor(n);
     * });
     * // => { '4': 1, '6': 2 }
     *
     * _.countBy([4.3, 6.1, 6.4], function(n) {
     *   return this.floor(n);
     * }, Math);
     * // => { '4': 1, '6': 2 }
     *
     * _.countBy(['one', 'two', 'three'], 'length');
     * // => { '3': 2, '5': 1 }
     */
    var countBy = createAggregator(function(result, value, key) {
      hasOwnProperty.call(result, key) ? ++result[key] : (result[key] = 1);
    });

    /**
     * Checks if `predicate` returns truthy for **all** elements of `collection`.
     * The predicate is bound to `thisArg` and invoked with three arguments:
     * (value, index|key, collection).
     *
     * If a property name is provided for `predicate` the created `_.property`
     * style callback returns the property value of the given element.
     *
     * If a value is also provided for `thisArg` the created `_.matchesProperty`
     * style callback returns `true` for elements that have a matching property
     * value, else `false`.
     *
     * If an object is provided for `predicate` the created `_.matches` style
     * callback returns `true` for elements that have the properties of the given
     * object, else `false`.
     *
     * @static
     * @memberOf _
     * @alias all
     * @category Collection
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function|Object|string} [predicate=_.identity] The function invoked
     *  per iteration.
     * @param {*} [thisArg] The `this` binding of `predicate`.
     * @returns {boolean} Returns `true` if all elements pass the predicate check,
     *  else `false`.
     * @example
     *
     * _.every([true, 1, null, 'yes'], Boolean);
     * // => false
     *
     * var users = [
     *   { 'user': 'barney', 'active': false },
     *   { 'user': 'fred',   'active': false }
     * ];
     *
     * // using the `_.matches` callback shorthand
     * _.every(users, { 'user': 'barney', 'active': false });
     * // => false
     *
     * // using the `_.matchesProperty` callback shorthand
     * _.every(users, 'active', false);
     * // => true
     *
     * // using the `_.property` callback shorthand
     * _.every(users, 'active');
     * // => false
     */
    function every(collection, predicate, thisArg) {
      var func = isArray(collection) ? arrayEvery : baseEvery;
      if (thisArg && isIterateeCall(collection, predicate, thisArg)) {
        predicate = null;
      }
      if (typeof predicate != 'function' || thisArg !== undefined) {
        predicate = getCallback(predicate, thisArg, 3);
      }
      return func(collection, predicate);
    }

    /**
     * Iterates over elements of `collection`, returning an array of all elements
     * `predicate` returns truthy for. The predicate is bound to `thisArg` and
     * invoked with three arguments: (value, index|key, collection).
     *
     * If a property name is provided for `predicate` the created `_.property`
     * style callback returns the property value of the given element.
     *
     * If a value is also provided for `thisArg` the created `_.matchesProperty`
     * style callback returns `true` for elements that have a matching property
     * value, else `false`.
     *
     * If an object is provided for `predicate` the created `_.matches` style
     * callback returns `true` for elements that have the properties of the given
     * object, else `false`.
     *
     * @static
     * @memberOf _
     * @alias select
     * @category Collection
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function|Object|string} [predicate=_.identity] The function invoked
     *  per iteration.
     * @param {*} [thisArg] The `this` binding of `predicate`.
     * @returns {Array} Returns the new filtered array.
     * @example
     *
     * _.filter([4, 5, 6], function(n) {
     *   return n % 2 == 0;
     * });
     * // => [4, 6]
     *
     * var users = [
     *   { 'user': 'barney', 'age': 36, 'active': true },
     *   { 'user': 'fred',   'age': 40, 'active': false }
     * ];
     *
     * // using the `_.matches` callback shorthand
     * _.pluck(_.filter(users, { 'age': 36, 'active': true }), 'user');
     * // => ['barney']
     *
     * // using the `_.matchesProperty` callback shorthand
     * _.pluck(_.filter(users, 'active', false), 'user');
     * // => ['fred']
     *
     * // using the `_.property` callback shorthand
     * _.pluck(_.filter(users, 'active'), 'user');
     * // => ['barney']
     */
    function filter(collection, predicate, thisArg) {
      var func = isArray(collection) ? arrayFilter : baseFilter;
      predicate = getCallback(predicate, thisArg, 3);
      return func(collection, predicate);
    }

    /**
     * Iterates over elements of `collection`, returning the first element
     * `predicate` returns truthy for. The predicate is bound to `thisArg` and
     * invoked with three arguments: (value, index|key, collection).
     *
     * If a property name is provided for `predicate` the created `_.property`
     * style callback returns the property value of the given element.
     *
     * If a value is also provided for `thisArg` the created `_.matchesProperty`
     * style callback returns `true` for elements that have a matching property
     * value, else `false`.
     *
     * If an object is provided for `predicate` the created `_.matches` style
     * callback returns `true` for elements that have the properties of the given
     * object, else `false`.
     *
     * @static
     * @memberOf _
     * @alias detect
     * @category Collection
     * @param {Array|Object|string} collection The collection to search.
     * @param {Function|Object|string} [predicate=_.identity] The function invoked
     *  per iteration.
     * @param {*} [thisArg] The `this` binding of `predicate`.
     * @returns {*} Returns the matched element, else `undefined`.
     * @example
     *
     * var users = [
     *   { 'user': 'barney',  'age': 36, 'active': true },
     *   { 'user': 'fred',    'age': 40, 'active': false },
     *   { 'user': 'pebbles', 'age': 1,  'active': true }
     * ];
     *
     * _.result(_.find(users, function(chr) {
     *   return chr.age < 40;
     * }), 'user');
     * // => 'barney'
     *
     * // using the `_.matches` callback shorthand
     * _.result(_.find(users, { 'age': 1, 'active': true }), 'user');
     * // => 'pebbles'
     *
     * // using the `_.matchesProperty` callback shorthand
     * _.result(_.find(users, 'active', false), 'user');
     * // => 'fred'
     *
     * // using the `_.property` callback shorthand
     * _.result(_.find(users, 'active'), 'user');
     * // => 'barney'
     */
    var find = createFind(baseEach);

    /**
     * This method is like `_.find` except that it iterates over elements of
     * `collection` from right to left.
     *
     * @static
     * @memberOf _
     * @category Collection
     * @param {Array|Object|string} collection The collection to search.
     * @param {Function|Object|string} [predicate=_.identity] The function invoked
     *  per iteration.
     * @param {*} [thisArg] The `this` binding of `predicate`.
     * @returns {*} Returns the matched element, else `undefined`.
     * @example
     *
     * _.findLast([1, 2, 3, 4], function(n) {
     *   return n % 2 == 1;
     * });
     * // => 3
     */
    var findLast = createFind(baseEachRight, true);

    /**
     * Performs a deep comparison between each element in `collection` and the
     * source object, returning the first element that has equivalent property
     * values.
     *
     * **Note:** This method supports comparing arrays, booleans, `Date` objects,
     * numbers, `Object` objects, regexes, and strings. Objects are compared by
     * their own, not inherited, enumerable properties. For comparing a single
     * own or inherited property value see `_.matchesProperty`.
     *
     * @static
     * @memberOf _
     * @category Collection
     * @param {Array|Object|string} collection The collection to search.
     * @param {Object} source The object of property values to match.
     * @returns {*} Returns the matched element, else `undefined`.
     * @example
     *
     * var users = [
     *   { 'user': 'barney', 'age': 36, 'active': true },
     *   { 'user': 'fred',   'age': 40, 'active': false }
     * ];
     *
     * _.result(_.findWhere(users, { 'age': 36, 'active': true }), 'user');
     * // => 'barney'
     *
     * _.result(_.findWhere(users, { 'age': 40, 'active': false }), 'user');
     * // => 'fred'
     */
    function findWhere(collection, source) {
      return find(collection, baseMatches(source));
    }

    /**
     * Iterates over elements of `collection` invoking `iteratee` for each element.
     * The `iteratee` is bound to `thisArg` and invoked with three arguments:
     * (value, index|key, collection). Iteratee functions may exit iteration early
     * by explicitly returning `false`.
     *
     * **Note:** As with other "Collections" methods, objects with a "length" property
     * are iterated like arrays. To avoid this behavior `_.forIn` or `_.forOwn`
     * may be used for object iteration.
     *
     * @static
     * @memberOf _
     * @alias each
     * @category Collection
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
     * @param {*} [thisArg] The `this` binding of `iteratee`.
     * @returns {Array|Object|string} Returns `collection`.
     * @example
     *
     * _([1, 2]).forEach(function(n) {
     *   console.log(n);
     * }).value();
     * // => logs each value from left to right and returns the array
     *
     * _.forEach({ 'a': 1, 'b': 2 }, function(n, key) {
     *   console.log(n, key);
     * });
     * // => logs each value-key pair and returns the object (iteration order is not guaranteed)
     */
    var forEach = createForEach(arrayEach, baseEach);

    /**
     * This method is like `_.forEach` except that it iterates over elements of
     * `collection` from right to left.
     *
     * @static
     * @memberOf _
     * @alias eachRight
     * @category Collection
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
     * @param {*} [thisArg] The `this` binding of `iteratee`.
     * @returns {Array|Object|string} Returns `collection`.
     * @example
     *
     * _([1, 2]).forEachRight(function(n) {
     *   console.log(n);
     * }).value();
     * // => logs each value from right to left and returns the array
     */
    var forEachRight = createForEach(arrayEachRight, baseEachRight);

    /**
     * Creates an object composed of keys generated from the results of running
     * each element of `collection` through `iteratee`. The corresponding value
     * of each key is an array of the elements responsible for generating the key.
     * The `iteratee` is bound to `thisArg` and invoked with three arguments:
     * (value, index|key, collection).
     *
     * If a property name is provided for `iteratee` the created `_.property`
     * style callback returns the property value of the given element.
     *
     * If a value is also provided for `thisArg` the created `_.matchesProperty`
     * style callback returns `true` for elements that have a matching property
     * value, else `false`.
     *
     * If an object is provided for `iteratee` the created `_.matches` style
     * callback returns `true` for elements that have the properties of the given
     * object, else `false`.
     *
     * @static
     * @memberOf _
     * @category Collection
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function|Object|string} [iteratee=_.identity] The function invoked
     *  per iteration.
     * @param {*} [thisArg] The `this` binding of `iteratee`.
     * @returns {Object} Returns the composed aggregate object.
     * @example
     *
     * _.groupBy([4.2, 6.1, 6.4], function(n) {
     *   return Math.floor(n);
     * });
     * // => { '4': [4.2], '6': [6.1, 6.4] }
     *
     * _.groupBy([4.2, 6.1, 6.4], function(n) {
     *   return this.floor(n);
     * }, Math);
     * // => { '4': [4.2], '6': [6.1, 6.4] }
     *
     * // using the `_.property` callback shorthand
     * _.groupBy(['one', 'two', 'three'], 'length');
     * // => { '3': ['one', 'two'], '5': ['three'] }
     */
    var groupBy = createAggregator(function(result, value, key) {
      if (hasOwnProperty.call(result, key)) {
        result[key].push(value);
      } else {
        result[key] = [value];
      }
    });

    /**
     * Checks if `value` is in `collection` using `SameValueZero` for equality
     * comparisons. If `fromIndex` is negative, it is used as the offset from
     * the end of `collection`.
     *
     * **Note:** [`SameValueZero`](https://people.mozilla.org/~jorendorff/es6-draft.html#sec-samevaluezero)
     * comparisons are like strict equality comparisons, e.g. `===`, except that
     * `NaN` matches `NaN`.
     *
     * @static
     * @memberOf _
     * @alias contains, include
     * @category Collection
     * @param {Array|Object|string} collection The collection to search.
     * @param {*} target The value to search for.
     * @param {number} [fromIndex=0] The index to search from.
     * @param- {Object} [guard] Enables use as a callback for functions like `_.reduce`.
     * @returns {boolean} Returns `true` if a matching element is found, else `false`.
     * @example
     *
     * _.includes([1, 2, 3], 1);
     * // => true
     *
     * _.includes([1, 2, 3], 1, 2);
     * // => false
     *
     * _.includes({ 'user': 'fred', 'age': 40 }, 'fred');
     * // => true
     *
     * _.includes('pebbles', 'eb');
     * // => true
     */
    function includes(collection, target, fromIndex, guard) {
      var length = collection ? getLength(collection) : 0;
      if (!isLength(length)) {
        collection = values(collection);
        length = collection.length;
      }
      if (!length) {
        return false;
      }
      if (typeof fromIndex != 'number' || (guard && isIterateeCall(target, fromIndex, guard))) {
        fromIndex = 0;
      } else {
        fromIndex = fromIndex < 0 ? nativeMax(length + fromIndex, 0) : (fromIndex || 0);
      }
      return (typeof collection == 'string' || !isArray(collection) && isString(collection))
        ? (fromIndex < length && collection.indexOf(target, fromIndex) > -1)
        : (getIndexOf(collection, target, fromIndex) > -1);
    }

    /**
     * Creates an object composed of keys generated from the results of running
     * each element of `collection` through `iteratee`. The corresponding value
     * of each key is the last element responsible for generating the key. The
     * iteratee function is bound to `thisArg` and invoked with three arguments:
     * (value, index|key, collection).
     *
     * If a property name is provided for `iteratee` the created `_.property`
     * style callback returns the property value of the given element.
     *
     * If a value is also provided for `thisArg` the created `_.matchesProperty`
     * style callback returns `true` for elements that have a matching property
     * value, else `false`.
     *
     * If an object is provided for `iteratee` the created `_.matches` style
     * callback returns `true` for elements that have the properties of the given
     * object, else `false`.
     *
     * @static
     * @memberOf _
     * @category Collection
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function|Object|string} [iteratee=_.identity] The function invoked
     *  per iteration.
     * @param {*} [thisArg] The `this` binding of `iteratee`.
     * @returns {Object} Returns the composed aggregate object.
     * @example
     *
     * var keyData = [
     *   { 'dir': 'left', 'code': 97 },
     *   { 'dir': 'right', 'code': 100 }
     * ];
     *
     * _.indexBy(keyData, 'dir');
     * // => { 'left': { 'dir': 'left', 'code': 97 }, 'right': { 'dir': 'right', 'code': 100 } }
     *
     * _.indexBy(keyData, function(object) {
     *   return String.fromCharCode(object.code);
     * });
     * // => { 'a': { 'dir': 'left', 'code': 97 }, 'd': { 'dir': 'right', 'code': 100 } }
     *
     * _.indexBy(keyData, function(object) {
     *   return this.fromCharCode(object.code);
     * }, String);
     * // => { 'a': { 'dir': 'left', 'code': 97 }, 'd': { 'dir': 'right', 'code': 100 } }
     */
    var indexBy = createAggregator(function(result, value, key) {
      result[key] = value;
    });

    /**
     * Invokes the method at `path` on each element in `collection`, returning
     * an array of the results of each invoked method. Any additional arguments
     * are provided to each invoked method. If `methodName` is a function it is
     * invoked for, and `this` bound to, each element in `collection`.
     *
     * @static
     * @memberOf _
     * @category Collection
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Array|Function|string} path The path of the method to invoke or
     *  the function invoked per iteration.
     * @param {...*} [args] The arguments to invoke the method with.
     * @returns {Array} Returns the array of results.
     * @example
     *
     * _.invoke([[5, 1, 7], [3, 2, 1]], 'sort');
     * // => [[1, 5, 7], [1, 2, 3]]
     *
     * _.invoke([123, 456], String.prototype.split, '');
     * // => [['1', '2', '3'], ['4', '5', '6']]
     */
    var invoke = restParam(function(collection, path, args) {
      var index = -1,
          isFunc = typeof path == 'function',
          isProp = isKey(path),
          length = getLength(collection),
          result = isLength(length) ? Array(length) : [];

      baseEach(collection, function(value) {
        var func = isFunc ? path : (isProp && value != null && value[path]);
        result[++index] = func ? func.apply(value, args) : invokePath(value, path, args);
      });
      return result;
    });

    /**
     * Creates an array of values by running each element in `collection` through
     * `iteratee`. The `iteratee` is bound to `thisArg` and invoked with three
     * arguments: (value, index|key, collection).
     *
     * If a property name is provided for `iteratee` the created `_.property`
     * style callback returns the property value of the given element.
     *
     * If a value is also provided for `thisArg` the created `_.matchesProperty`
     * style callback returns `true` for elements that have a matching property
     * value, else `false`.
     *
     * If an object is provided for `iteratee` the created `_.matches` style
     * callback returns `true` for elements that have the properties of the given
     * object, else `false`.
     *
     * Many lodash methods are guarded to work as interatees for methods like
     * `_.every`, `_.filter`, `_.map`, `_.mapValues`, `_.reject`, and `_.some`.
     *
     * The guarded methods are:
     * `ary`, `callback`, `chunk`, `clone`, `create`, `curry`, `curryRight`, `drop`,
     * `dropRight`, `every`, `fill`, `flatten`, `invert`, `max`, `min`, `parseInt`,
     * `slice`, `sortBy`, `take`, `takeRight`, `template`, `trim`, `trimLeft`,
     * `trimRight`, `trunc`, `random`, `range`, `sample`, `some`, `uniq`, and `words`
     *
     * @static
     * @memberOf _
     * @alias collect
     * @category Collection
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function|Object|string} [iteratee=_.identity] The function invoked
     *  per iteration.
     * @param {*} [thisArg] The `this` binding of `iteratee`.
     * @returns {Array} Returns the new mapped array.
     * @example
     *
     * function timesThree(n) {
     *   return n * 3;
     * }
     *
     * _.map([1, 2], timesThree);
     * // => [3, 6]
     *
     * _.map({ 'a': 1, 'b': 2 }, timesThree);
     * // => [3, 6] (iteration order is not guaranteed)
     *
     * var users = [
     *   { 'user': 'barney' },
     *   { 'user': 'fred' }
     * ];
     *
     * // using the `_.property` callback shorthand
     * _.map(users, 'user');
     * // => ['barney', 'fred']
     */
    function map(collection, iteratee, thisArg) {
      var func = isArray(collection) ? arrayMap : baseMap;
      iteratee = getCallback(iteratee, thisArg, 3);
      return func(collection, iteratee);
    }

    /**
     * Creates an array of elements split into two groups, the first of which
     * contains elements `predicate` returns truthy for, while the second of which
     * contains elements `predicate` returns falsey for. The predicate is bound
     * to `thisArg` and invoked with three arguments: (value, index|key, collection).
     *
     * If a property name is provided for `predicate` the created `_.property`
     * style callback returns the property value of the given element.
     *
     * If a value is also provided for `thisArg` the created `_.matchesProperty`
     * style callback returns `true` for elements that have a matching property
     * value, else `false`.
     *
     * If an object is provided for `predicate` the created `_.matches` style
     * callback returns `true` for elements that have the properties of the given
     * object, else `false`.
     *
     * @static
     * @memberOf _
     * @category Collection
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function|Object|string} [predicate=_.identity] The function invoked
     *  per iteration.
     * @param {*} [thisArg] The `this` binding of `predicate`.
     * @returns {Array} Returns the array of grouped elements.
     * @example
     *
     * _.partition([1, 2, 3], function(n) {
     *   return n % 2;
     * });
     * // => [[1, 3], [2]]
     *
     * _.partition([1.2, 2.3, 3.4], function(n) {
     *   return this.floor(n) % 2;
     * }, Math);
     * // => [[1.2, 3.4], [2.3]]
     *
     * var users = [
     *   { 'user': 'barney',  'age': 36, 'active': false },
     *   { 'user': 'fred',    'age': 40, 'active': true },
     *   { 'user': 'pebbles', 'age': 1,  'active': false }
     * ];
     *
     * var mapper = function(array) {
     *   return _.pluck(array, 'user');
     * };
     *
     * // using the `_.matches` callback shorthand
     * _.map(_.partition(users, { 'age': 1, 'active': false }), mapper);
     * // => [['pebbles'], ['barney', 'fred']]
     *
     * // using the `_.matchesProperty` callback shorthand
     * _.map(_.partition(users, 'active', false), mapper);
     * // => [['barney', 'pebbles'], ['fred']]
     *
     * // using the `_.property` callback shorthand
     * _.map(_.partition(users, 'active'), mapper);
     * // => [['fred'], ['barney', 'pebbles']]
     */
    var partition = createAggregator(function(result, value, key) {
      result[key ? 0 : 1].push(value);
    }, function() { return [[], []]; });

    /**
     * Gets the property value of `path` from all elements in `collection`.
     *
     * @static
     * @memberOf _
     * @category Collection
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Array|string} path The path of the property to pluck.
     * @returns {Array} Returns the property values.
     * @example
     *
     * var users = [
     *   { 'user': 'barney', 'age': 36 },
     *   { 'user': 'fred',   'age': 40 }
     * ];
     *
     * _.pluck(users, 'user');
     * // => ['barney', 'fred']
     *
     * var userIndex = _.indexBy(users, 'user');
     * _.pluck(userIndex, 'age');
     * // => [36, 40] (iteration order is not guaranteed)
     */
    function pluck(collection, path) {
      return map(collection, property(path));
    }

    /**
     * Reduces `collection` to a value which is the accumulated result of running
     * each element in `collection` through `iteratee`, where each successive
     * invocation is supplied the return value of the previous. If `accumulator`
     * is not provided the first element of `collection` is used as the initial
     * value. The `iteratee` is bound to `thisArg` and invoked with four arguments:
     * (accumulator, value, index|key, collection).
     *
     * Many lodash methods are guarded to work as interatees for methods like
     * `_.reduce`, `_.reduceRight`, and `_.transform`.
     *
     * The guarded methods are:
     * `assign`, `defaults`, `includes`, `merge`, `sortByAll`, and `sortByOrder`
     *
     * @static
     * @memberOf _
     * @alias foldl, inject
     * @category Collection
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
     * @param {*} [accumulator] The initial value.
     * @param {*} [thisArg] The `this` binding of `iteratee`.
     * @returns {*} Returns the accumulated value.
     * @example
     *
     * _.reduce([1, 2], function(total, n) {
     *   return total + n;
     * });
     * // => 3
     *
     * _.reduce({ 'a': 1, 'b': 2 }, function(result, n, key) {
     *   result[key] = n * 3;
     *   return result;
     * }, {});
     * // => { 'a': 3, 'b': 6 } (iteration order is not guaranteed)
     */
    var reduce = createReduce(arrayReduce, baseEach);

    /**
     * This method is like `_.reduce` except that it iterates over elements of
     * `collection` from right to left.
     *
     * @static
     * @memberOf _
     * @alias foldr
     * @category Collection
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
     * @param {*} [accumulator] The initial value.
     * @param {*} [thisArg] The `this` binding of `iteratee`.
     * @returns {*} Returns the accumulated value.
     * @example
     *
     * var array = [[0, 1], [2, 3], [4, 5]];
     *
     * _.reduceRight(array, function(flattened, other) {
     *   return flattened.concat(other);
     * }, []);
     * // => [4, 5, 2, 3, 0, 1]
     */
    var reduceRight =  createReduce(arrayReduceRight, baseEachRight);

    /**
     * The opposite of `_.filter`; this method returns the elements of `collection`
     * that `predicate` does **not** return truthy for.
     *
     * If a property name is provided for `predicate` the created `_.property`
     * style callback returns the property value of the given element.
     *
     * If a value is also provided for `thisArg` the created `_.matchesProperty`
     * style callback returns `true` for elements that have a matching property
     * value, else `false`.
     *
     * If an object is provided for `predicate` the created `_.matches` style
     * callback returns `true` for elements that have the properties of the given
     * object, else `false`.
     *
     * @static
     * @memberOf _
     * @category Collection
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function|Object|string} [predicate=_.identity] The function invoked
     *  per iteration.
     * @param {*} [thisArg] The `this` binding of `predicate`.
     * @returns {Array} Returns the new filtered array.
     * @example
     *
     * _.reject([1, 2, 3, 4], function(n) {
     *   return n % 2 == 0;
     * });
     * // => [1, 3]
     *
     * var users = [
     *   { 'user': 'barney', 'age': 36, 'active': false },
     *   { 'user': 'fred',   'age': 40, 'active': true }
     * ];
     *
     * // using the `_.matches` callback shorthand
     * _.pluck(_.reject(users, { 'age': 40, 'active': true }), 'user');
     * // => ['barney']
     *
     * // using the `_.matchesProperty` callback shorthand
     * _.pluck(_.reject(users, 'active', false), 'user');
     * // => ['fred']
     *
     * // using the `_.property` callback shorthand
     * _.pluck(_.reject(users, 'active'), 'u