#include "src/objects/module-inl.h"

#include "torque-generated/class-verifiers.h"
#include "src/objects/objects-inl.h"

#include "src/objects/instance-type-inl.h"

#include "src/objects/module.h"

namespace v8 {
namespace internal {

// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/objects/module.tq?l=5&c=1
bool IsModule_NonInline(Tagged<HeapObject> o) {
  return IsModule(o);
}

#ifdef VERIFY_HEAP

template <>
void TorqueGeneratedModule<Module, HeapObject>::ModuleVerify(Isolate* isolate) {
  TorqueGeneratedClassVerifiers::ModuleVerify(TrustedCast<Module>(*this), isolate);
}


#endif  // VERIFY_HEAP
// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/objects/module.tq?l=20&c=1
bool IsJSModuleNamespace_NonInline(Tagged<HeapObject> o) {
  return IsJSModuleNamespace(o);
}

#ifdef VERIFY_HEAP

template <>
void TorqueGeneratedJSModuleNamespace<JSModuleNamespace, JSSpecialObject>::JSModuleNamespaceVerify(Isolate* isolate) {
  TorqueGeneratedClassVerifiers::JSModuleNamespaceVerify(TrustedCast<JSModuleNamespace>(*this), isolate);
}


#endif  // VERIFY_HEAP
// Definition https://source.chromium.org/chromium/chromium/src/+/main:v8/src/objects/module.tq?l=24&c=1
class TorqueGeneratedScriptOrModuleAsserts {
  static constexpr int kStartOfStrongFieldsOffset = sizeof(StructLayout);
  // https://source.chromium.org/chromium/chromium/src/+/main:v8/src/objects/module.tq?l=26&c=3
  static constexpr int kResourceNameOffset = sizeof(StructLayout);
  static constexpr int kResourceNameOffsetEnd = kResourceNameOffset + kTaggedSize - 1;
  // https://source.chromium.org/chromium/chromium/src/+/main:v8/src/objects/module.tq?l=27&c=3
  static constexpr int kHostDefinedOptionsOffset = kResourceNameOffsetEnd + 1;
  static constexpr int kHostDefinedOptionsOffsetEnd = kHostDefinedOptionsOffset + kTaggedSize - 1;
  static constexpr int kEndOfStrongFieldsOffset = kHostDefinedOptionsOffsetEnd + 1;
  static constexpr int kStartOfWeakFieldsOffset = kHostDefinedOptionsOffsetEnd + 1;
  static constexpr int kEndOfWeakFieldsOffset = kHostDefinedOptionsOffsetEnd + 1;
  static constexpr int kHeaderSize = kHostDefinedOptionsOffsetEnd + 1;
  static constexpr int kSize = kHostDefinedOptionsOffsetEnd + 1;

  static_assert(kResourceNameOffset == offsetof(ScriptOrModule, resource_name_),
                "Value of ScriptOrModule::kResourceNameOffset defined in Torque and offset of field ScriptOrModule::resource_name in C++ do not match");
  static_assert(kHostDefinedOptionsOffset == offsetof(ScriptOrModule, host_defined_options_),
                "Value of ScriptOrModule::kHostDefinedOptionsOffset defined in Torque and offset of field ScriptOrModule::host_defined_options in C++ do not match");
  static_assert(kSize == sizeof(ScriptOrModule));
};

} // namespace internal
} // namespace v8
