#include "src/objects/microtask.h"

namespace v8 {
namespace internal {

// Definition https://source.chromium.org/chromium/chromium/src/+/main:v8/src/objects/microtask.tq?l=5&c=1
class TorqueGeneratedMicrotaskAsserts {
  static constexpr int kStartOfStrongFieldsOffset = sizeof(StructLayout);
  // https://source.chromium.org/chromium/chromium/src/+/main:v8/src/objects/microtask.tq?l=9&c=3
  static constexpr int kContinuationPreservedEmbedderDataOffset = sizeof(StructLayout);
  static constexpr int kContinuationPreservedEmbedderDataOffsetEnd = kContinuationPreservedEmbedderDataOffset + kTaggedSize - 1;
  static constexpr int kEndOfStrongFieldsOffset = kContinuationPreservedEmbedderDataOffsetEnd + 1;
  static constexpr int kStartOfWeakFieldsOffset = kContinuationPreservedEmbedderDataOffsetEnd + 1;
  static constexpr int kEndOfWeakFieldsOffset = kContinuationPreservedEmbedderDataOffsetEnd + 1;
  static constexpr int kHeaderSize = kContinuationPreservedEmbedderDataOffsetEnd + 1;

  static_assert(kContinuationPreservedEmbedderDataOffset == offsetof(Microtask, continuation_preserved_embedder_data_),
                "Value of Microtask::kContinuationPreservedEmbedderDataOffset defined in Torque and offset of field Microtask::continuation_preserved_embedder_data in C++ do not match");
};

// Definition https://source.chromium.org/chromium/chromium/src/+/main:v8/src/objects/microtask.tq?l=12&c=1
class TorqueGeneratedCallbackTaskAsserts {
  static constexpr int kStartOfStrongFieldsOffset = sizeof(Microtask);
  // https://source.chromium.org/chromium/chromium/src/+/main:v8/src/objects/microtask.tq?l=14&c=3
  static constexpr int kCallbackOffset = sizeof(Microtask);
  static constexpr int kCallbackOffsetEnd = kCallbackOffset + kTaggedSize - 1;
  // https://source.chromium.org/chromium/chromium/src/+/main:v8/src/objects/microtask.tq?l=15&c=3
  static constexpr int kDataOffset = kCallbackOffsetEnd + 1;
  static constexpr int kDataOffsetEnd = kDataOffset + kTaggedSize - 1;
  static constexpr int kEndOfStrongFieldsOffset = kDataOffsetEnd + 1;
  static constexpr int kStartOfWeakFieldsOffset = kDataOffsetEnd + 1;
  static constexpr int kEndOfWeakFieldsOffset = kDataOffsetEnd + 1;
  static constexpr int kHeaderSize = kDataOffsetEnd + 1;
  static constexpr int kSize = kDataOffsetEnd + 1;

  static_assert(kCallbackOffset == offsetof(CallbackTask, callback_),
                "Value of CallbackTask::kCallbackOffset defined in Torque and offset of field CallbackTask::callback in C++ do not match");
  static_assert(kDataOffset == offsetof(CallbackTask, data_),
                "Value of CallbackTask::kDataOffset defined in Torque and offset of field CallbackTask::data in C++ do not match");
  static_assert(kSize == sizeof(CallbackTask));
};

// Definition https://source.chromium.org/chromium/chromium/src/+/main:v8/src/objects/microtask.tq?l=18&c=1
class TorqueGeneratedCallableTaskAsserts {
  static constexpr int kStartOfStrongFieldsOffset = sizeof(Microtask);
  // https://source.chromium.org/chromium/chromium/src/+/main:v8/src/objects/microtask.tq?l=20&c=3
  static constexpr int kCallableOffset = sizeof(Microtask);
  static constexpr int kCallableOffsetEnd = kCallableOffset + kTaggedSize - 1;
  // https://source.chromium.org/chromium/chromium/src/+/main:v8/src/objects/microtask.tq?l=21&c=3
  static constexpr int kContextOffset = kCallableOffsetEnd + 1;
  static constexpr int kContextOffsetEnd = kContextOffset + kTaggedSize - 1;
  static constexpr int kEndOfStrongFieldsOffset = kContextOffsetEnd + 1;
  static constexpr int kStartOfWeakFieldsOffset = kContextOffsetEnd + 1;
  static constexpr int kEndOfWeakFieldsOffset = kContextOffsetEnd + 1;
  static constexpr int kHeaderSize = kContextOffsetEnd + 1;
  static constexpr int kSize = kContextOffsetEnd + 1;

  static_assert(kCallableOffset == offsetof(CallableTask, callable_),
                "Value of CallableTask::kCallableOffset defined in Torque and offset of field CallableTask::callable in C++ do not match");
  static_assert(kContextOffset == offsetof(CallableTask, context_),
                "Value of CallableTask::kContextOffset defined in Torque and offset of field CallableTask::context in C++ do not match");
  static_assert(kSize == sizeof(CallableTask));
};

} // namespace internal
} // namespace v8
