// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef v8_inspector_protocol_Runtime_h
#define v8_inspector_protocol_Runtime_h

#include "src/inspector/protocol/Protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.
#include "include/inspector/Runtime.h"

namespace v8_inspector {
namespace protocol {
namespace Runtime {
using ScriptId = String;
class SerializationOptions;
class DeepSerializedValue;
using RemoteObjectId = String;
using UnserializableValue = String;
class RemoteObject;
class CustomPreview;
class ObjectPreview;
class PropertyPreview;
class EntryPreview;
class PropertyDescriptor;
class InternalPropertyDescriptor;
class PrivatePropertyDescriptor;
class CallArgument;
using ExecutionContextId = int;
class ExecutionContextDescription;
class ExceptionDetails;
using Timestamp = double;
using TimeDelta = double;
class CallFrame;
class StackTrace;
using UniqueDebuggerId = String;
class StackTraceId;

// ------------- Forward and enum declarations.

namespace ConsoleAPICalled {
namespace TypeEnum {
 extern const char* Log;
 extern const char* Debug;
 extern const char* Info;
 extern const char* Error;
 extern const char* Warning;
 extern const char* Dir;
 extern const char* Dirxml;
 extern const char* Table;
 extern const char* Trace;
 extern const char* Clear;
 extern const char* StartGroup;
 extern const char* StartGroupCollapsed;
 extern const char* EndGroup;
 extern const char* Assert;
 extern const char* Profile;
 extern const char* ProfileEnd;
 extern const char* Count;
 extern const char* TimeEnd;
} // TypeEnum
} // ConsoleAPICalled

// ------------- Type and builder declarations.

class  SerializationOptions : public ::v8_crdtp::ProtocolObject<SerializationOptions> {
public:
    ~SerializationOptions() override;  // Defined below

    struct  SerializationEnum {
        static const char* Deep;
        static const char* Json;
        static const char* IdOnly;
    }; // SerializationEnum

    String getSerialization() { return m_serialization; }
    void setSerialization(const String& value);  // Defined below

    bool hasMaxDepth() { return !!m_maxDepth; }
    int getMaxDepth(int defaultValue) const {
       return m_maxDepth.value_or(defaultValue);
    }
    const std::optional<int>& getMaxDepth() const {
       return m_maxDepth;
    }
    void setMaxDepth(int value);  // Defined below

    bool hasAdditionalParameters() { return !!m_additionalParameters; }
    protocol::DictionaryValue* getAdditionalParameters(protocol::DictionaryValue* defaultValue) {
       return m_additionalParameters ? m_additionalParameters.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DictionaryValue>& getAdditionalParameters() const {
       return m_additionalParameters;
    }
    void setAdditionalParameters(std::unique_ptr<protocol::DictionaryValue> value);  // Defined below

    template<int STATE>
    class SerializationOptionsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            SerializationSet = 1 << 1,
            AllFieldsSet = (SerializationSet | 0)};


        SerializationOptionsBuilder<STATE | SerializationSet>& setSerialization(const String& value);  // Defined below

        SerializationOptionsBuilder<STATE>& setMaxDepth(int value);  // Defined below

        SerializationOptionsBuilder<STATE>& setAdditionalParameters(std::unique_ptr<protocol::DictionaryValue> value);  // Defined below

        std::unique_ptr<SerializationOptions> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SerializationOptions;
        SerializationOptionsBuilder() : m_result(new SerializationOptions()) { }

        template<int STEP> SerializationOptionsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SerializationOptionsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Runtime::SerializationOptions> m_result;
    };

    static SerializationOptionsBuilder<0> create()
    {
        return SerializationOptionsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SerializationOptions();  // Defined below

    String m_serialization;
    std::optional<int> m_maxDepth;
    std::unique_ptr<protocol::DictionaryValue> m_additionalParameters;
};


class  DeepSerializedValue : public ::v8_crdtp::ProtocolObject<DeepSerializedValue> {
public:
    ~DeepSerializedValue() override;  // Defined below

    struct  TypeEnum {
        static const char* Undefined;
        static const char* Null;
        static const char* String;
        static const char* Number;
        static const char* Boolean;
        static const char* Bigint;
        static const char* Regexp;
        static const char* Date;
        static const char* Symbol;
        static const char* Array;
        static const char* Object;
        static const char* Function;
        static const char* Map;
        static const char* Set;
        static const char* Weakmap;
        static const char* Weakset;
        static const char* Error;
        static const char* Proxy;
        static const char* Promise;
        static const char* Typedarray;
        static const char* Arraybuffer;
        static const char* Node;
        static const char* Window;
        static const char* Generator;
    }; // TypeEnum

    String getType() { return m_type; }
    void setType(const String& value);  // Defined below

    bool hasValue() { return !!m_value; }
    protocol::Value* getValue(protocol::Value* defaultValue) {
       return m_value ? m_value.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Value>& getValue() const {
       return m_value;
    }
    void setValue(std::unique_ptr<protocol::Value> value);  // Defined below

    bool hasObjectId() { return !!m_objectId; }
    String getObjectId(const String& defaultValue) const {
       return m_objectId.value_or(defaultValue);
    }
    const std::optional<String>& getObjectId() const {
       return m_objectId;
    }
    void setObjectId(const String& value);  // Defined below

    bool hasWeakLocalObjectReference() { return !!m_weakLocalObjectReference; }
    int getWeakLocalObjectReference(int defaultValue) const {
       return m_weakLocalObjectReference.value_or(defaultValue);
    }
    const std::optional<int>& getWeakLocalObjectReference() const {
       return m_weakLocalObjectReference;
    }
    void setWeakLocalObjectReference(int value);  // Defined below

    template<int STATE>
    class DeepSerializedValueBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TypeSet = 1 << 1,
            AllFieldsSet = (TypeSet | 0)};


        DeepSerializedValueBuilder<STATE | TypeSet>& setType(const String& value);  // Defined below

        DeepSerializedValueBuilder<STATE>& setValue(std::unique_ptr<protocol::Value> value);  // Defined below

        DeepSerializedValueBuilder<STATE>& setObjectId(const String& value);  // Defined below

        DeepSerializedValueBuilder<STATE>& setWeakLocalObjectReference(int value);  // Defined below

        std::unique_ptr<DeepSerializedValue> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class DeepSerializedValue;
        DeepSerializedValueBuilder() : m_result(new DeepSerializedValue()) { }

        template<int STEP> DeepSerializedValueBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<DeepSerializedValueBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Runtime::DeepSerializedValue> m_result;
    };

    static DeepSerializedValueBuilder<0> create()
    {
        return DeepSerializedValueBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    DeepSerializedValue();  // Defined below

    String m_type;
    std::unique_ptr<protocol::Value> m_value;
    std::optional<String> m_objectId;
    std::optional<int> m_weakLocalObjectReference;
};


class  RemoteObject : public ::v8_crdtp::ProtocolObject<RemoteObject>,
    public API::RemoteObject {
public:
    ~RemoteObject() override;  // Defined below

    struct  TypeEnum {
        static const char* Object;
        static const char* Function;
        static const char* Undefined;
        static const char* String;
        static const char* Number;
        static const char* Boolean;
        static const char* Symbol;
        static const char* Bigint;
    }; // TypeEnum

    String getType() { return m_type; }
    void setType(const String& value);  // Defined below

    struct  SubtypeEnum {
        static const char* Array;
        static const char* Null;
        static const char* Node;
        static const char* Regexp;
        static const char* Date;
        static const char* Map;
        static const char* Set;
        static const char* Weakmap;
        static const char* Weakset;
        static const char* Iterator;
        static const char* Generator;
        static const char* Error;
        static const char* Proxy;
        static const char* Promise;
        static const char* Typedarray;
        static const char* Arraybuffer;
        static const char* Dataview;
        static const char* Webassemblymemory;
        static const char* Wasmvalue;
        static const char* Trustedtype;
    }; // SubtypeEnum

    bool hasSubtype() { return !!m_subtype; }
    String getSubtype(const String& defaultValue) const {
       return m_subtype.value_or(defaultValue);
    }
    const std::optional<String>& getSubtype() const {
       return m_subtype;
    }
    void setSubtype(const String& value);  // Defined below

    bool hasClassName() { return !!m_className; }
    String getClassName(const String& defaultValue) const {
       return m_className.value_or(defaultValue);
    }
    const std::optional<String>& getClassName() const {
       return m_className;
    }
    void setClassName(const String& value);  // Defined below

    bool hasValue() { return !!m_value; }
    protocol::Value* getValue(protocol::Value* defaultValue) {
       return m_value ? m_value.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Value>& getValue() const {
       return m_value;
    }
    void setValue(std::unique_ptr<protocol::Value> value);  // Defined below

    bool hasUnserializableValue() { return !!m_unserializableValue; }
    String getUnserializableValue(const String& defaultValue) const {
       return m_unserializableValue.value_or(defaultValue);
    }
    const std::optional<String>& getUnserializableValue() const {
       return m_unserializableValue;
    }
    void setUnserializableValue(const String& value);  // Defined below

    bool hasDescription() { return !!m_description; }
    String getDescription(const String& defaultValue) const {
       return m_description.value_or(defaultValue);
    }
    const std::optional<String>& getDescription() const {
       return m_description;
    }
    void setDescription(const String& value);  // Defined below

    bool hasDeepSerializedValue() { return !!m_deepSerializedValue; }
    protocol::Runtime::DeepSerializedValue* getDeepSerializedValue(protocol::Runtime::DeepSerializedValue* defaultValue) {
       return m_deepSerializedValue ? m_deepSerializedValue.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Runtime::DeepSerializedValue>& getDeepSerializedValue() const {
       return m_deepSerializedValue;
    }
    void setDeepSerializedValue(std::unique_ptr<protocol::Runtime::DeepSerializedValue> value);  // Defined below

    bool hasObjectId() { return !!m_objectId; }
    String getObjectId(const String& defaultValue) const {
       return m_objectId.value_or(defaultValue);
    }
    const std::optional<String>& getObjectId() const {
       return m_objectId;
    }
    void setObjectId(const String& value);  // Defined below

    bool hasPreview() { return !!m_preview; }
    protocol::Runtime::ObjectPreview* getPreview(protocol::Runtime::ObjectPreview* defaultValue) {
       return m_preview ? m_preview.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Runtime::ObjectPreview>& getPreview() const {
       return m_preview;
    }
    void setPreview(std::unique_ptr<protocol::Runtime::ObjectPreview> value);  // Defined below

    bool hasCustomPreview() { return !!m_customPreview; }
    protocol::Runtime::CustomPreview* getCustomPreview(protocol::Runtime::CustomPreview* defaultValue) {
       return m_customPreview ? m_customPreview.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Runtime::CustomPreview>& getCustomPreview() const {
       return m_customPreview;
    }
    void setCustomPreview(std::unique_ptr<protocol::Runtime::CustomPreview> value);  // Defined below

    template<int STATE>
    class RemoteObjectBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TypeSet = 1 << 1,
            AllFieldsSet = (TypeSet | 0)};


        RemoteObjectBuilder<STATE | TypeSet>& setType(const String& value);  // Defined below

        RemoteObjectBuilder<STATE>& setSubtype(const String& value);  // Defined below

        RemoteObjectBuilder<STATE>& setClassName(const String& value);  // Defined below

        RemoteObjectBuilder<STATE>& setValue(std::unique_ptr<protocol::Value> value);  // Defined below

        RemoteObjectBuilder<STATE>& setUnserializableValue(const String& value);  // Defined below

        RemoteObjectBuilder<STATE>& setDescription(const String& value);  // Defined below

        RemoteObjectBuilder<STATE>& setDeepSerializedValue(std::unique_ptr<protocol::Runtime::DeepSerializedValue> value);  // Defined below

        RemoteObjectBuilder<STATE>& setObjectId(const String& value);  // Defined below

        RemoteObjectBuilder<STATE>& setPreview(std::unique_ptr<protocol::Runtime::ObjectPreview> value);  // Defined below

        RemoteObjectBuilder<STATE>& setCustomPreview(std::unique_ptr<protocol::Runtime::CustomPreview> value);  // Defined below

        std::unique_ptr<RemoteObject> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class RemoteObject;
        RemoteObjectBuilder() : m_result(new RemoteObject()) { }

        template<int STEP> RemoteObjectBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<RemoteObjectBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Runtime::RemoteObject> m_result;
    };

    static RemoteObjectBuilder<0> create()
    {
        return RemoteObjectBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    RemoteObject();  // Defined below

    String m_type;
    std::optional<String> m_subtype;
    std::optional<String> m_className;
    std::unique_ptr<protocol::Value> m_value;
    std::optional<String> m_unserializableValue;
    std::optional<String> m_description;
    std::unique_ptr<protocol::Runtime::DeepSerializedValue> m_deepSerializedValue;
    std::optional<String> m_objectId;
    std::unique_ptr<protocol::Runtime::ObjectPreview> m_preview;
    std::unique_ptr<protocol::Runtime::CustomPreview> m_customPreview;
};


class  CustomPreview : public ::v8_crdtp::ProtocolObject<CustomPreview> {
public:
    ~CustomPreview() override;  // Defined below

    String getHeader() { return m_header; }
    void setHeader(const String& value);  // Defined below

    bool hasBodyGetterId() { return !!m_bodyGetterId; }
    String getBodyGetterId(const String& defaultValue) const {
       return m_bodyGetterId.value_or(defaultValue);
    }
    const std::optional<String>& getBodyGetterId() const {
       return m_bodyGetterId;
    }
    void setBodyGetterId(const String& value);  // Defined below

    template<int STATE>
    class CustomPreviewBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            HeaderSet = 1 << 1,
            AllFieldsSet = (HeaderSet | 0)};


        CustomPreviewBuilder<STATE | HeaderSet>& setHeader(const String& value);  // Defined below

        CustomPreviewBuilder<STATE>& setBodyGetterId(const String& value);  // Defined below

        std::unique_ptr<CustomPreview> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CustomPreview;
        CustomPreviewBuilder() : m_result(new CustomPreview()) { }

        template<int STEP> CustomPreviewBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CustomPreviewBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Runtime::CustomPreview> m_result;
    };

    static CustomPreviewBuilder<0> create()
    {
        return CustomPreviewBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CustomPreview();  // Defined below

    String m_header;
    std::optional<String> m_bodyGetterId;
};


class  ObjectPreview : public ::v8_crdtp::ProtocolObject<ObjectPreview> {
public:
    ~ObjectPreview() override;  // Defined below

    struct  TypeEnum {
        static const char* Object;
        static const char* Function;
        static const char* Undefined;
        static const char* String;
        static const char* Number;
        static const char* Boolean;
        static const char* Symbol;
        static const char* Bigint;
    }; // TypeEnum

    String getType() { return m_type; }
    void setType(const String& value);  // Defined below

    struct  SubtypeEnum {
        static const char* Array;
        static const char* Null;
        static const char* Node;
        static const char* Regexp;
        static const char* Date;
        static const char* Map;
        static const char* Set;
        static const char* Weakmap;
        static const char* Weakset;
        static const char* Iterator;
        static const char* Generator;
        static const char* Error;
        static const char* Proxy;
        static const char* Promise;
        static const char* Typedarray;
        static const char* Arraybuffer;
        static const char* Dataview;
        static const char* Webassemblymemory;
        static const char* Wasmvalue;
        static const char* Trustedtype;
    }; // SubtypeEnum

    bool hasSubtype() { return !!m_subtype; }
    String getSubtype(const String& defaultValue) const {
       return m_subtype.value_or(defaultValue);
    }
    const std::optional<String>& getSubtype() const {
       return m_subtype;
    }
    void setSubtype(const String& value);  // Defined below

    bool hasDescription() { return !!m_description; }
    String getDescription(const String& defaultValue) const {
       return m_description.value_or(defaultValue);
    }
    const std::optional<String>& getDescription() const {
       return m_description;
    }
    void setDescription(const String& value);  // Defined below

    bool getOverflow() { return m_overflow; }
    void setOverflow(bool value);  // Defined below

    protocol::Array<protocol::Runtime::PropertyPreview>* getProperties() { return m_properties.get(); }
    void setProperties(std::unique_ptr<protocol::Array<protocol::Runtime::PropertyPreview>> value);  // Defined below

    bool hasEntries() { return !!m_entries; }
    protocol::Array<protocol::Runtime::EntryPreview>* getEntries(protocol::Array<protocol::Runtime::EntryPreview>* defaultValue) {
       return m_entries ? m_entries.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::Runtime::EntryPreview>>& getEntries() const {
       return m_entries;
    }
    void setEntries(std::unique_ptr<protocol::Array<protocol::Runtime::EntryPreview>> value);  // Defined below

    template<int STATE>
    class ObjectPreviewBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TypeSet = 1 << 1,
            OverflowSet = 1 << 2,
            PropertiesSet = 1 << 3,
            AllFieldsSet = (TypeSet | OverflowSet | PropertiesSet | 0)};


        ObjectPreviewBuilder<STATE | TypeSet>& setType(const String& value);  // Defined below

        ObjectPreviewBuilder<STATE>& setSubtype(const String& value);  // Defined below

        ObjectPreviewBuilder<STATE>& setDescription(const String& value);  // Defined below

        ObjectPreviewBuilder<STATE | OverflowSet>& setOverflow(bool value);  // Defined below

        ObjectPreviewBuilder<STATE | PropertiesSet>& setProperties(std::unique_ptr<protocol::Array<protocol::Runtime::PropertyPreview>> value);  // Defined below

        ObjectPreviewBuilder<STATE>& setEntries(std::unique_ptr<protocol::Array<protocol::Runtime::EntryPreview>> value);  // Defined below

        std::unique_ptr<ObjectPreview> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ObjectPreview;
        ObjectPreviewBuilder() : m_result(new ObjectPreview()) { }

        template<int STEP> ObjectPreviewBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ObjectPreviewBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Runtime::ObjectPreview> m_result;
    };

    static ObjectPreviewBuilder<0> create()
    {
        return ObjectPreviewBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ObjectPreview();  // Defined below

    String m_type;
    std::optional<String> m_subtype;
    std::optional<String> m_description;
    bool m_overflow;
    std::unique_ptr<protocol::Array<protocol::Runtime::PropertyPreview>> m_properties;
    std::unique_ptr<protocol::Array<protocol::Runtime::EntryPreview>> m_entries;
};


class  PropertyPreview : public ::v8_crdtp::ProtocolObject<PropertyPreview> {
public:
    ~PropertyPreview() override;  // Defined below

    String getName() { return m_name; }
    void setName(const String& value);  // Defined below

    struct  TypeEnum {
        static const char* Object;
        static const char* Function;
        static const char* Undefined;
        static const char* String;
        static const char* Number;
        static const char* Boolean;
        static const char* Symbol;
        static const char* Accessor;
        static const char* Bigint;
    }; // TypeEnum

    String getType() { return m_type; }
    void setType(const String& value);  // Defined below

    bool hasValue() { return !!m_value; }
    String getValue(const String& defaultValue) const {
       return m_value.value_or(defaultValue);
    }
    const std::optional<String>& getValue() const {
       return m_value;
    }
    void setValue(const String& value);  // Defined below

    bool hasValuePreview() { return !!m_valuePreview; }
    protocol::Runtime::ObjectPreview* getValuePreview(protocol::Runtime::ObjectPreview* defaultValue) {
       return m_valuePreview ? m_valuePreview.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Runtime::ObjectPreview>& getValuePreview() const {
       return m_valuePreview;
    }
    void setValuePreview(std::unique_ptr<protocol::Runtime::ObjectPreview> value);  // Defined below

    struct  SubtypeEnum {
        static const char* Array;
        static const char* Null;
        static const char* Node;
        static const char* Regexp;
        static const char* Date;
        static const char* Map;
        static const char* Set;
        static const char* Weakmap;
        static const char* Weakset;
        static const char* Iterator;
        static const char* Generator;
        static const char* Error;
        static const char* Proxy;
        static const char* Promise;
        static const char* Typedarray;
        static const char* Arraybuffer;
        static const char* Dataview;
        static const char* Webassemblymemory;
        static const char* Wasmvalue;
        static const char* Trustedtype;
    }; // SubtypeEnum

    bool hasSubtype() { return !!m_subtype; }
    String getSubtype(const String& defaultValue) const {
       return m_subtype.value_or(defaultValue);
    }
    const std::optional<String>& getSubtype() const {
       return m_subtype;
    }
    void setSubtype(const String& value);  // Defined below

    template<int STATE>
    class PropertyPreviewBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NameSet = 1 << 1,
            TypeSet = 1 << 2,
            AllFieldsSet = (NameSet | TypeSet | 0)};


        PropertyPreviewBuilder<STATE | NameSet>& setName(const String& value);  // Defined below

        PropertyPreviewBuilder<STATE | TypeSet>& setType(const String& value);  // Defined below

        PropertyPreviewBuilder<STATE>& setValue(const String& value);  // Defined below

        PropertyPreviewBuilder<STATE>& setValuePreview(std::unique_ptr<protocol::Runtime::ObjectPreview> value);  // Defined below

        PropertyPreviewBuilder<STATE>& setSubtype(const String& value);  // Defined below

        std::unique_ptr<PropertyPreview> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class PropertyPreview;
        PropertyPreviewBuilder() : m_result(new PropertyPreview()) { }

        template<int STEP> PropertyPreviewBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<PropertyPreviewBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Runtime::PropertyPreview> m_result;
    };

    static PropertyPreviewBuilder<0> create()
    {
        return PropertyPreviewBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    PropertyPreview();  // Defined below

    String m_name;
    String m_type;
    std::optional<String> m_value;
    std::unique_ptr<protocol::Runtime::ObjectPreview> m_valuePreview;
    std::optional<String> m_subtype;
};


class  EntryPreview : public ::v8_crdtp::ProtocolObject<EntryPreview> {
public:
    ~EntryPreview() override;  // Defined below

    bool hasKey() { return !!m_key; }
    protocol::Runtime::ObjectPreview* getKey(protocol::Runtime::ObjectPreview* defaultValue) {
       return m_key ? m_key.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Runtime::ObjectPreview>& getKey() const {
       return m_key;
    }
    void setKey(std::unique_ptr<protocol::Runtime::ObjectPreview> value);  // Defined below

    protocol::Runtime::ObjectPreview* getValue() { return m_value.get(); }
    void setValue(std::unique_ptr<protocol::Runtime::ObjectPreview> value);  // Defined below

    template<int STATE>
    class EntryPreviewBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ValueSet = 1 << 1,
            AllFieldsSet = (ValueSet | 0)};


        EntryPreviewBuilder<STATE>& setKey(std::unique_ptr<protocol::Runtime::ObjectPreview> value);  // Defined below

        EntryPreviewBuilder<STATE | ValueSet>& setValue(std::unique_ptr<protocol::Runtime::ObjectPreview> value);  // Defined below

        std::unique_ptr<EntryPreview> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class EntryPreview;
        EntryPreviewBuilder() : m_result(new EntryPreview()) { }

        template<int STEP> EntryPreviewBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<EntryPreviewBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Runtime::EntryPreview> m_result;
    };

    static EntryPreviewBuilder<0> create()
    {
        return EntryPreviewBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    EntryPreview();  // Defined below

    std::unique_ptr<protocol::Runtime::ObjectPreview> m_key;
    std::unique_ptr<protocol::Runtime::ObjectPreview> m_value;
};


class  PropertyDescriptor : public ::v8_crdtp::ProtocolObject<PropertyDescriptor> {
public:
    ~PropertyDescriptor() override;  // Defined below

    String getName() { return m_name; }
    void setName(const String& value);  // Defined below

    bool hasValue() { return !!m_value; }
    protocol::Runtime::RemoteObject* getValue(protocol::Runtime::RemoteObject* defaultValue) {
       return m_value ? m_value.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Runtime::RemoteObject>& getValue() const {
       return m_value;
    }
    void setValue(std::unique_ptr<protocol::Runtime::RemoteObject> value);  // Defined below

    bool hasWritable() { return !!m_writable; }
    bool getWritable(bool defaultValue) const {
       return m_writable.value_or(defaultValue);
    }
    const std::optional<bool>& getWritable() const {
       return m_writable;
    }
    void setWritable(bool value);  // Defined below

    bool hasGet() { return !!m_get; }
    protocol::Runtime::RemoteObject* getGet(protocol::Runtime::RemoteObject* defaultValue) {
       return m_get ? m_get.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Runtime::RemoteObject>& getGet() const {
       return m_get;
    }
    void setGet(std::unique_ptr<protocol::Runtime::RemoteObject> value);  // Defined below

    bool hasSet() { return !!m_set; }
    protocol::Runtime::RemoteObject* getSet(protocol::Runtime::RemoteObject* defaultValue) {
       return m_set ? m_set.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Runtime::RemoteObject>& getSet() const {
       return m_set;
    }
    void setSet(std::unique_ptr<protocol::Runtime::RemoteObject> value);  // Defined below

    bool getConfigurable() { return m_configurable; }
    void setConfigurable(bool value);  // Defined below

    bool getEnumerable() { return m_enumerable; }
    void setEnumerable(bool value);  // Defined below

    bool hasWasThrown() { return !!m_wasThrown; }
    bool getWasThrown(bool defaultValue) const {
       return m_wasThrown.value_or(defaultValue);
    }
    const std::optional<bool>& getWasThrown() const {
       return m_wasThrown;
    }
    void setWasThrown(bool value);  // Defined below

    bool hasIsOwn() { return !!m_isOwn; }
    bool getIsOwn(bool defaultValue) const {
       return m_isOwn.value_or(defaultValue);
    }
    const std::optional<bool>& getIsOwn() const {
       return m_isOwn;
    }
    void setIsOwn(bool value);  // Defined below

    bool hasSymbol() { return !!m_symbol; }
    protocol::Runtime::RemoteObject* getSymbol(protocol::Runtime::RemoteObject* defaultValue) {
       return m_symbol ? m_symbol.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Runtime::RemoteObject>& getSymbol() const {
       return m_symbol;
    }
    void setSymbol(std::unique_ptr<protocol::Runtime::RemoteObject> value);  // Defined below

    template<int STATE>
    class PropertyDescriptorBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NameSet = 1 << 1,
            ConfigurableSet = 1 << 2,
            EnumerableSet = 1 << 3,
            AllFieldsSet = (NameSet | ConfigurableSet | EnumerableSet | 0)};


        PropertyDescriptorBuilder<STATE | NameSet>& setName(const String& value);  // Defined below

        PropertyDescriptorBuilder<STATE>& setValue(std::unique_ptr<protocol::Runtime::RemoteObject> value);  // Defined below

        PropertyDescriptorBuilder<STATE>& setWritable(bool value);  // Defined below

        PropertyDescriptorBuilder<STATE>& setGet(std::unique_ptr<protocol::Runtime::RemoteObject> value);  // Defined below

        PropertyDescriptorBuilder<STATE>& setSet(std::unique_ptr<protocol::Runtime::RemoteObject> value);  // Defined below

        PropertyDescriptorBuilder<STATE | ConfigurableSet>& setConfigurable(bool value);  // Defined below

        PropertyDescriptorBuilder<STATE | EnumerableSet>& setEnumerable(bool value);  // Defined below

        PropertyDescriptorBuilder<STATE>& setWasThrown(bool value);  // Defined below

        PropertyDescriptorBuilder<STATE>& setIsOwn(bool value);  // Defined below

        PropertyDescriptorBuilder<STATE>& setSymbol(std::unique_ptr<protocol::Runtime::RemoteObject> value);  // Defined below

        std::unique_ptr<PropertyDescriptor> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class PropertyDescriptor;
        PropertyDescriptorBuilder() : m_result(new PropertyDescriptor()) { }

        template<int STEP> PropertyDescriptorBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<PropertyDescriptorBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Runtime::PropertyDescriptor> m_result;
    };

    static PropertyDescriptorBuilder<0> create()
    {
        return PropertyDescriptorBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    PropertyDescriptor();  // Defined below

    String m_name;
    std::unique_ptr<protocol::Runtime::RemoteObject> m_value;
    std::optional<bool> m_writable;
    std::unique_ptr<protocol::Runtime::RemoteObject> m_get;
    std::unique_ptr<protocol::Runtime::RemoteObject> m_set;
    bool m_configurable;
    bool m_enumerable;
    std::optional<bool> m_wasThrown;
    std::optional<bool> m_isOwn;
    std::unique_ptr<protocol::Runtime::RemoteObject> m_symbol;
};


class  InternalPropertyDescriptor : public ::v8_crdtp::ProtocolObject<InternalPropertyDescriptor> {
public:
    ~InternalPropertyDescriptor() override;  // Defined below

    String getName() { return m_name; }
    void setName(const String& value);  // Defined below

    bool hasValue() { return !!m_value; }
    protocol::Runtime::RemoteObject* getValue(protocol::Runtime::RemoteObject* defaultValue) {
       return m_value ? m_value.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Runtime::RemoteObject>& getValue() const {
       return m_value;
    }
    void setValue(std::unique_ptr<protocol::Runtime::RemoteObject> value);  // Defined below

    template<int STATE>
    class InternalPropertyDescriptorBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NameSet = 1 << 1,
            AllFieldsSet = (NameSet | 0)};


        InternalPropertyDescriptorBuilder<STATE | NameSet>& setName(const String& value);  // Defined below

        InternalPropertyDescriptorBuilder<STATE>& setValue(std::unique_ptr<protocol::Runtime::RemoteObject> value);  // Defined below

        std::unique_ptr<InternalPropertyDescriptor> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class InternalPropertyDescriptor;
        InternalPropertyDescriptorBuilder() : m_result(new InternalPropertyDescriptor()) { }

        template<int STEP> InternalPropertyDescriptorBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<InternalPropertyDescriptorBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Runtime::InternalPropertyDescriptor> m_result;
    };

    static InternalPropertyDescriptorBuilder<0> create()
    {
        return InternalPropertyDescriptorBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    InternalPropertyDescriptor();  // Defined below

    String m_name;
    std::unique_ptr<protocol::Runtime::RemoteObject> m_value;
};


class  PrivatePropertyDescriptor : public ::v8_crdtp::ProtocolObject<PrivatePropertyDescriptor> {
public:
    ~PrivatePropertyDescriptor() override;  // Defined below

    String getName() { return m_name; }
    void setName(const String& value);  // Defined below

    bool hasValue() { return !!m_value; }
    protocol::Runtime::RemoteObject* getValue(protocol::Runtime::RemoteObject* defaultValue) {
       return m_value ? m_value.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Runtime::RemoteObject>& getValue() const {
       return m_value;
    }
    void setValue(std::unique_ptr<protocol::Runtime::RemoteObject> value);  // Defined below

    bool hasGet() { return !!m_get; }
    protocol::Runtime::RemoteObject* getGet(protocol::Runtime::RemoteObject* defaultValue) {
       return m_get ? m_get.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Runtime::RemoteObject>& getGet() const {
       return m_get;
    }
    void setGet(std::unique_ptr<protocol::Runtime::RemoteObject> value);  // Defined below

    bool hasSet() { return !!m_set; }
    protocol::Runtime::RemoteObject* getSet(protocol::Runtime::RemoteObject* defaultValue) {
       return m_set ? m_set.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Runtime::RemoteObject>& getSet() const {
       return m_set;
    }
    void setSet(std::unique_ptr<protocol::Runtime::RemoteObject> value);  // Defined below

    template<int STATE>
    class PrivatePropertyDescriptorBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NameSet = 1 << 1,
            AllFieldsSet = (NameSet | 0)};


        PrivatePropertyDescriptorBuilder<STATE | NameSet>& setName(const String& value);  // Defined below

        PrivatePropertyDescriptorBuilder<STATE>& setValue(std::unique_ptr<protocol::Runtime::RemoteObject> value);  // Defined below

        PrivatePropertyDescriptorBuilder<STATE>& setGet(std::unique_ptr<protocol::Runtime::RemoteObject> value);  // Defined below

        PrivatePropertyDescriptorBuilder<STATE>& setSet(std::unique_ptr<protocol::Runtime::RemoteObject> value);  // Defined below

        std::unique_ptr<PrivatePropertyDescriptor> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class PrivatePropertyDescriptor;
        PrivatePropertyDescriptorBuilder() : m_result(new PrivatePropertyDescriptor()) { }

        template<int STEP> PrivatePropertyDescriptorBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<PrivatePropertyDescriptorBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Runtime::PrivatePropertyDescriptor> m_result;
    };

    static PrivatePropertyDescriptorBuilder<0> create()
    {
        return PrivatePropertyDescriptorBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    PrivatePropertyDescriptor();  // Defined below

    String m_name;
    std::unique_ptr<protocol::Runtime::RemoteObject> m_value;
    std::unique_ptr<protocol::Runtime::RemoteObject> m_get;
    std::unique_ptr<protocol::Runtime::RemoteObject> m_set;
};


class  CallArgument : public ::v8_crdtp::ProtocolObject<CallArgument> {
public:
    ~CallArgument() override;  // Defined below

    bool hasValue() { return !!m_value; }
    protocol::Value* getValue(protocol::Value* defaultValue) {
       return m_value ? m_value.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Value>& getValue() const {
       return m_value;
    }
    void setValue(std::unique_ptr<protocol::Value> value);  // Defined below

    bool hasUnserializableValue() { return !!m_unserializableValue; }
    String getUnserializableValue(const String& defaultValue) const {
       return m_unserializableValue.value_or(defaultValue);
    }
    const std::optional<String>& getUnserializableValue() const {
       return m_unserializableValue;
    }
    void setUnserializableValue(const String& value);  // Defined below

    bool hasObjectId() { return !!m_objectId; }
    String getObjectId(const String& defaultValue) const {
       return m_objectId.value_or(defaultValue);
    }
    const std::optional<String>& getObjectId() const {
       return m_objectId;
    }
    void setObjectId(const String& value);  // Defined below

    template<int STATE>
    class CallArgumentBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        CallArgumentBuilder<STATE>& setValue(std::unique_ptr<protocol::Value> value);  // Defined below

        CallArgumentBuilder<STATE>& setUnserializableValue(const String& value);  // Defined below

        CallArgumentBuilder<STATE>& setObjectId(const String& value);  // Defined below

        std::unique_ptr<CallArgument> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CallArgument;
        CallArgumentBuilder() : m_result(new CallArgument()) { }

        template<int STEP> CallArgumentBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CallArgumentBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Runtime::CallArgument> m_result;
    };

    static CallArgumentBuilder<0> create()
    {
        return CallArgumentBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CallArgument();  // Defined below

    std::unique_ptr<protocol::Value> m_value;
    std::optional<String> m_unserializableValue;
    std::optional<String> m_objectId;
};


class  ExecutionContextDescription : public ::v8_crdtp::ProtocolObject<ExecutionContextDescription> {
public:
    ~ExecutionContextDescription() override;  // Defined below

    int getId() { return m_id; }
    void setId(int value);  // Defined below

    String getOrigin() { return m_origin; }
    void setOrigin(const String& value);  // Defined below

    String getName() { return m_name; }
    void setName(const String& value);  // Defined below

    String getUniqueId() { return m_uniqueId; }
    void setUniqueId(const String& value);  // Defined below

    bool hasAuxData() { return !!m_auxData; }
    protocol::DictionaryValue* getAuxData(protocol::DictionaryValue* defaultValue) {
       return m_auxData ? m_auxData.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DictionaryValue>& getAuxData() const {
       return m_auxData;
    }
    void setAuxData(std::unique_ptr<protocol::DictionaryValue> value);  // Defined below

    template<int STATE>
    class ExecutionContextDescriptionBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            IdSet = 1 << 1,
            OriginSet = 1 << 2,
            NameSet = 1 << 3,
            UniqueIdSet = 1 << 4,
            AllFieldsSet = (IdSet | OriginSet | NameSet | UniqueIdSet | 0)};


        ExecutionContextDescriptionBuilder<STATE | IdSet>& setId(int value);  // Defined below

        ExecutionContextDescriptionBuilder<STATE | OriginSet>& setOrigin(const String& value);  // Defined below

        ExecutionContextDescriptionBuilder<STATE | NameSet>& setName(const String& value);  // Defined below

        ExecutionContextDescriptionBuilder<STATE | UniqueIdSet>& setUniqueId(const String& value);  // Defined below

        ExecutionContextDescriptionBuilder<STATE>& setAuxData(std::unique_ptr<protocol::DictionaryValue> value);  // Defined below

        std::unique_ptr<ExecutionContextDescription> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ExecutionContextDescription;
        ExecutionContextDescriptionBuilder() : m_result(new ExecutionContextDescription()) { }

        template<int STEP> ExecutionContextDescriptionBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ExecutionContextDescriptionBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Runtime::ExecutionContextDescription> m_result;
    };

    static ExecutionContextDescriptionBuilder<0> create()
    {
        return ExecutionContextDescriptionBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ExecutionContextDescription();  // Defined below

    int m_id;
    String m_origin;
    String m_name;
    String m_uniqueId;
    std::unique_ptr<protocol::DictionaryValue> m_auxData;
};


class  ExceptionDetails : public ::v8_crdtp::ProtocolObject<ExceptionDetails> {
public:
    ~ExceptionDetails() override;  // Defined below

    int getExceptionId() { return m_exceptionId; }
    void setExceptionId(int value);  // Defined below

    String getText() { return m_text; }
    void setText(const String& value);  // Defined below

    int getLineNumber() { return m_lineNumber; }
    void setLineNumber(int value);  // Defined below

    int getColumnNumber() { return m_columnNumber; }
    void setColumnNumber(int value);  // Defined below

    bool hasScriptId() { return !!m_scriptId; }
    String getScriptId(const String& defaultValue) const {
       return m_scriptId.value_or(defaultValue);
    }
    const std::optional<String>& getScriptId() const {
       return m_scriptId;
    }
    void setScriptId(const String& value);  // Defined below

    bool hasUrl() { return !!m_url; }
    String getUrl(const String& defaultValue) const {
       return m_url.value_or(defaultValue);
    }
    const std::optional<String>& getUrl() const {
       return m_url;
    }
    void setUrl(const String& value);  // Defined below

    bool hasStackTrace() { return !!m_stackTrace; }
    protocol::Runtime::StackTrace* getStackTrace(protocol::Runtime::StackTrace* defaultValue) {
       return m_stackTrace ? m_stackTrace.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Runtime::StackTrace>& getStackTrace() const {
       return m_stackTrace;
    }
    void setStackTrace(std::unique_ptr<protocol::Runtime::StackTrace> value);  // Defined below

    bool hasException() { return !!m_exception; }
    protocol::Runtime::RemoteObject* getException(protocol::Runtime::RemoteObject* defaultValue) {
       return m_exception ? m_exception.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Runtime::RemoteObject>& getException() const {
       return m_exception;
    }
    void setException(std::unique_ptr<protocol::Runtime::RemoteObject> value);  // Defined below

    bool hasExecutionContextId() { return !!m_executionContextId; }
    int getExecutionContextId(int defaultValue) const {
       return m_executionContextId.value_or(defaultValue);
    }
    const std::optional<int>& getExecutionContextId() const {
       return m_executionContextId;
    }
    void setExecutionContextId(int value);  // Defined below

    bool hasExceptionMetaData() { return !!m_exceptionMetaData; }
    protocol::DictionaryValue* getExceptionMetaData(protocol::DictionaryValue* defaultValue) {
       return m_exceptionMetaData ? m_exceptionMetaData.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DictionaryValue>& getExceptionMetaData() const {
       return m_exceptionMetaData;
    }
    void setExceptionMetaData(std::unique_ptr<protocol::DictionaryValue> value);  // Defined below

    template<int STATE>
    class ExceptionDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ExceptionIdSet = 1 << 1,
            TextSet = 1 << 2,
            LineNumberSet = 1 << 3,
            ColumnNumberSet = 1 << 4,
            AllFieldsSet = (ExceptionIdSet | TextSet | LineNumberSet | ColumnNumberSet | 0)};


        ExceptionDetailsBuilder<STATE | ExceptionIdSet>& setExceptionId(int value);  // Defined below

        ExceptionDetailsBuilder<STATE | TextSet>& setText(const String& value);  // Defined below

        ExceptionDetailsBuilder<STATE | LineNumberSet>& setLineNumber(int value);  // Defined below

        ExceptionDetailsBuilder<STATE | ColumnNumberSet>& setColumnNumber(int value);  // Defined below

        ExceptionDetailsBuilder<STATE>& setScriptId(const String& value);  // Defined below

        ExceptionDetailsBuilder<STATE>& setUrl(const String& value);  // Defined below

        ExceptionDetailsBuilder<STATE>& setStackTrace(std::unique_ptr<protocol::Runtime::StackTrace> value);  // Defined below

        ExceptionDetailsBuilder<STATE>& setException(std::unique_ptr<protocol::Runtime::RemoteObject> value);  // Defined below

        ExceptionDetailsBuilder<STATE>& setExecutionContextId(int value);  // Defined below

        ExceptionDetailsBuilder<STATE>& setExceptionMetaData(std::unique_ptr<protocol::DictionaryValue> value);  // Defined below

        std::unique_ptr<ExceptionDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ExceptionDetails;
        ExceptionDetailsBuilder() : m_result(new ExceptionDetails()) { }

        template<int STEP> ExceptionDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ExceptionDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Runtime::ExceptionDetails> m_result;
    };

    static ExceptionDetailsBuilder<0> create()
    {
        return ExceptionDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ExceptionDetails();  // Defined below

    int m_exceptionId;
    String m_text;
    int m_lineNumber;
    int m_columnNumber;
    std::optional<String> m_scriptId;
    std::optional<String> m_url;
    std::unique_ptr<protocol::Runtime::StackTrace> m_stackTrace;
    std::unique_ptr<protocol::Runtime::RemoteObject> m_exception;
    std::optional<int> m_executionContextId;
    std::unique_ptr<protocol::DictionaryValue> m_exceptionMetaData;
};


class  CallFrame : public ::v8_crdtp::ProtocolObject<CallFrame> {
public:
    ~CallFrame() override;  // Defined below

    String getFunctionName() { return m_functionName; }
    void setFunctionName(const String& value);  // Defined below

    String getScriptId() { return m_scriptId; }
    void setScriptId(const String& value);  // Defined below

    String getUrl() { return m_url; }
    void setUrl(const String& value);  // Defined below

    int getLineNumber() { return m_lineNumber; }
    void setLineNumber(int value);  // Defined below

    int getColumnNumber() { return m_columnNumber; }
    void setColumnNumber(int value);  // Defined below

    template<int STATE>
    class CallFrameBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            FunctionNameSet = 1 << 1,
            ScriptIdSet = 1 << 2,
            UrlSet = 1 << 3,
            LineNumberSet = 1 << 4,
            ColumnNumberSet = 1 << 5,
            AllFieldsSet = (FunctionNameSet | ScriptIdSet | UrlSet | LineNumberSet | ColumnNumberSet | 0)};


        CallFrameBuilder<STATE | FunctionNameSet>& setFunctionName(const String& value);  // Defined below

        CallFrameBuilder<STATE | ScriptIdSet>& setScriptId(const String& value);  // Defined below

        CallFrameBuilder<STATE | UrlSet>& setUrl(const String& value);  // Defined below

        CallFrameBuilder<STATE | LineNumberSet>& setLineNumber(int value);  // Defined below

        CallFrameBuilder<STATE | ColumnNumberSet>& setColumnNumber(int value);  // Defined below

        std::unique_ptr<CallFrame> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CallFrame;
        CallFrameBuilder() : m_result(new CallFrame()) { }

        template<int STEP> CallFrameBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CallFrameBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Runtime::CallFrame> m_result;
    };

    static CallFrameBuilder<0> create()
    {
        return CallFrameBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CallFrame();  // Defined below

    String m_functionName;
    String m_scriptId;
    String m_url;
    int m_lineNumber;
    int m_columnNumber;
};


class  StackTrace : public ::v8_crdtp::ProtocolObject<StackTrace>,
    public API::StackTrace {
public:
    ~StackTrace() override;  // Defined below

    bool hasDescription() { return !!m_description; }
    String getDescription(const String& defaultValue) const {
       return m_description.value_or(defaultValue);
    }
    const std::optional<String>& getDescription() const {
       return m_description;
    }
    void setDescription(const String& value);  // Defined below

    protocol::Array<protocol::Runtime::CallFrame>* getCallFrames() { return m_callFrames.get(); }
    void setCallFrames(std::unique_ptr<protocol::Array<protocol::Runtime::CallFrame>> value);  // Defined below

    bool hasParent() { return !!m_parent; }
    protocol::Runtime::StackTrace* getParent(protocol::Runtime::StackTrace* defaultValue) {
       return m_parent ? m_parent.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Runtime::StackTrace>& getParent() const {
       return m_parent;
    }
    void setParent(std::unique_ptr<protocol::Runtime::StackTrace> value);  // Defined below

    bool hasParentId() { return !!m_parentId; }
    protocol::Runtime::StackTraceId* getParentId(protocol::Runtime::StackTraceId* defaultValue) {
       return m_parentId ? m_parentId.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Runtime::StackTraceId>& getParentId() const {
       return m_parentId;
    }
    void setParentId(std::unique_ptr<protocol::Runtime::StackTraceId> value);  // Defined below

    template<int STATE>
    class StackTraceBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            CallFramesSet = 1 << 1,
            AllFieldsSet = (CallFramesSet | 0)};


        StackTraceBuilder<STATE>& setDescription(const String& value);  // Defined below

        StackTraceBuilder<STATE | CallFramesSet>& setCallFrames(std::unique_ptr<protocol::Array<protocol::Runtime::CallFrame>> value);  // Defined below

        StackTraceBuilder<STATE>& setParent(std::unique_ptr<protocol::Runtime::StackTrace> value);  // Defined below

        StackTraceBuilder<STATE>& setParentId(std::unique_ptr<protocol::Runtime::StackTraceId> value);  // Defined below

        std::unique_ptr<StackTrace> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class StackTrace;
        StackTraceBuilder() : m_result(new StackTrace()) { }

        template<int STEP> StackTraceBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<StackTraceBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Runtime::StackTrace> m_result;
    };

    static StackTraceBuilder<0> create()
    {
        return StackTraceBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    StackTrace();  // Defined below

    std::optional<String> m_description;
    std::unique_ptr<protocol::Array<protocol::Runtime::CallFrame>> m_callFrames;
    std::unique_ptr<protocol::Runtime::StackTrace> m_parent;
    std::unique_ptr<protocol::Runtime::StackTraceId> m_parentId;
};


class  StackTraceId : public ::v8_crdtp::ProtocolObject<StackTraceId>,
    public API::StackTraceId {
public:
    ~StackTraceId() override;  // Defined below

    String getId() { return m_id; }
    void setId(const String& value);  // Defined below

    bool hasDebuggerId() { return !!m_debuggerId; }
    String getDebuggerId(const String& defaultValue) const {
       return m_debuggerId.value_or(defaultValue);
    }
    const std::optional<String>& getDebuggerId() const {
       return m_debuggerId;
    }
    void setDebuggerId(const String& value);  // Defined below

    template<int STATE>
    class StackTraceIdBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            IdSet = 1 << 1,
            AllFieldsSet = (IdSet | 0)};


        StackTraceIdBuilder<STATE | IdSet>& setId(const String& value);  // Defined below

        StackTraceIdBuilder<STATE>& setDebuggerId(const String& value);  // Defined below

        std::unique_ptr<StackTraceId> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class StackTraceId;
        StackTraceIdBuilder() : m_result(new StackTraceId()) { }

        template<int STEP> StackTraceIdBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<StackTraceIdBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Runtime::StackTraceId> m_result;
    };

    static StackTraceIdBuilder<0> create()
    {
        return StackTraceIdBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    StackTraceId();  // Defined below

    String m_id;
    std::optional<String> m_debuggerId;
};


// ------------- Type and builder method definitions.
//
// These methods separate from the type declaration because of
// https://github.com/llvm/llvm-project/issues/59966. The DevTools protocol has
// mutually recursive types, so we cannot simply reorder the types.
inline SerializationOptions::~SerializationOptions() = default;
inline void SerializationOptions::setSerialization(const String& value) { m_serialization = value; }
inline void SerializationOptions::setMaxDepth(int value) { m_maxDepth = value; }
inline void SerializationOptions::setAdditionalParameters(std::unique_ptr<protocol::DictionaryValue> value) { m_additionalParameters = std::move(value); }

template<int STATE>
inline SerializationOptions::SerializationOptionsBuilder<STATE | SerializationOptions::SerializationOptionsBuilder<STATE>::SerializationSet>&
SerializationOptions::SerializationOptionsBuilder<STATE>::setSerialization(const String& value) {
  static_assert(!(STATE & SerializationSet), "property serialization should not be set yet");
  m_result->setSerialization(value);
  return castState<SerializationSet>();
}
template<int STATE>
inline SerializationOptions::SerializationOptionsBuilder<STATE>& SerializationOptions::SerializationOptionsBuilder<STATE>::setMaxDepth(int value) {
  m_result->setMaxDepth(value);
  return *this;
}
template<int STATE>
inline SerializationOptions::SerializationOptionsBuilder<STATE>& SerializationOptions::SerializationOptionsBuilder<STATE>::setAdditionalParameters(std::unique_ptr<protocol::DictionaryValue> value) {
  m_result->setAdditionalParameters(std::move(value));
  return *this;
}

inline SerializationOptions::SerializationOptions() {
}
inline DeepSerializedValue::~DeepSerializedValue() = default;
inline void DeepSerializedValue::setType(const String& value) { m_type = value; }
inline void DeepSerializedValue::setValue(std::unique_ptr<protocol::Value> value) { m_value = std::move(value); }
inline void DeepSerializedValue::setObjectId(const String& value) { m_objectId = value; }
inline void DeepSerializedValue::setWeakLocalObjectReference(int value) { m_weakLocalObjectReference = value; }

template<int STATE>
inline DeepSerializedValue::DeepSerializedValueBuilder<STATE | DeepSerializedValue::DeepSerializedValueBuilder<STATE>::TypeSet>&
DeepSerializedValue::DeepSerializedValueBuilder<STATE>::setType(const String& value) {
  static_assert(!(STATE & TypeSet), "property type should not be set yet");
  m_result->setType(value);
  return castState<TypeSet>();
}
template<int STATE>
inline DeepSerializedValue::DeepSerializedValueBuilder<STATE>& DeepSerializedValue::DeepSerializedValueBuilder<STATE>::setValue(std::unique_ptr<protocol::Value> value) {
  m_result->setValue(std::move(value));
  return *this;
}
template<int STATE>
inline DeepSerializedValue::DeepSerializedValueBuilder<STATE>& DeepSerializedValue::DeepSerializedValueBuilder<STATE>::setObjectId(const String& value) {
  m_result->setObjectId(value);
  return *this;
}
template<int STATE>
inline DeepSerializedValue::DeepSerializedValueBuilder<STATE>& DeepSerializedValue::DeepSerializedValueBuilder<STATE>::setWeakLocalObjectReference(int value) {
  m_result->setWeakLocalObjectReference(value);
  return *this;
}

inline DeepSerializedValue::DeepSerializedValue() {
}
inline RemoteObject::~RemoteObject() = default;
inline void RemoteObject::setType(const String& value) { m_type = value; }
inline void RemoteObject::setSubtype(const String& value) { m_subtype = value; }
inline void RemoteObject::setClassName(const String& value) { m_className = value; }
inline void RemoteObject::setValue(std::unique_ptr<protocol::Value> value) { m_value = std::move(value); }
inline void RemoteObject::setUnserializableValue(const String& value) { m_unserializableValue = value; }
inline void RemoteObject::setDescription(const String& value) { m_description = value; }
inline void RemoteObject::setDeepSerializedValue(std::unique_ptr<protocol::Runtime::DeepSerializedValue> value) { m_deepSerializedValue = std::move(value); }
inline void RemoteObject::setObjectId(const String& value) { m_objectId = value; }
inline void RemoteObject::setPreview(std::unique_ptr<protocol::Runtime::ObjectPreview> value) { m_preview = std::move(value); }
inline void RemoteObject::setCustomPreview(std::unique_ptr<protocol::Runtime::CustomPreview> value) { m_customPreview = std::move(value); }

template<int STATE>
inline RemoteObject::RemoteObjectBuilder<STATE | RemoteObject::RemoteObjectBuilder<STATE>::TypeSet>&
RemoteObject::RemoteObjectBuilder<STATE>::setType(const String& value) {
  static_assert(!(STATE & TypeSet), "property type should not be set yet");
  m_result->setType(value);
  return castState<TypeSet>();
}
template<int STATE>
inline RemoteObject::RemoteObjectBuilder<STATE>& RemoteObject::RemoteObjectBuilder<STATE>::setSubtype(const String& value) {
  m_result->setSubtype(value);
  return *this;
}
template<int STATE>
inline RemoteObject::RemoteObjectBuilder<STATE>& RemoteObject::RemoteObjectBuilder<STATE>::setClassName(const String& value) {
  m_result->setClassName(value);
  return *this;
}
template<int STATE>
inline RemoteObject::RemoteObjectBuilder<STATE>& RemoteObject::RemoteObjectBuilder<STATE>::setValue(std::unique_ptr<protocol::Value> value) {
  m_result->setValue(std::move(value));
  return *this;
}
template<int STATE>
inline RemoteObject::RemoteObjectBuilder<STATE>& RemoteObject::RemoteObjectBuilder<STATE>::setUnserializableValue(const String& value) {
  m_result->setUnserializableValue(value);
  return *this;
}
template<int STATE>
inline RemoteObject::RemoteObjectBuilder<STATE>& RemoteObject::RemoteObjectBuilder<STATE>::setDescription(const String& value) {
  m_result->setDescription(value);
  return *this;
}
template<int STATE>
inline RemoteObject::RemoteObjectBuilder<STATE>& RemoteObject::RemoteObjectBuilder<STATE>::setDeepSerializedValue(std::unique_ptr<protocol::Runtime::DeepSerializedValue> value) {
  m_result->setDeepSerializedValue(std::move(value));
  return *this;
}
template<int STATE>
inline RemoteObject::RemoteObjectBuilder<STATE>& RemoteObject::RemoteObjectBuilder<STATE>::setObjectId(const String& value) {
  m_result->setObjectId(value);
  return *this;
}
template<int STATE>
inline RemoteObject::RemoteObjectBuilder<STATE>& RemoteObject::RemoteObjectBuilder<STATE>::setPreview(std::unique_ptr<protocol::Runtime::ObjectPreview> value) {
  m_result->setPreview(std::move(value));
  return *this;
}
template<int STATE>
inline RemoteObject::RemoteObjectBuilder<STATE>& RemoteObject::RemoteObjectBuilder<STATE>::setCustomPreview(std::unique_ptr<protocol::Runtime::CustomPreview> value) {
  m_result->setCustomPreview(std::move(value));
  return *this;
}

inline RemoteObject::RemoteObject() {
}
inline CustomPreview::~CustomPreview() = default;
inline void CustomPreview::setHeader(const String& value) { m_header = value; }
inline void CustomPreview::setBodyGetterId(const String& value) { m_bodyGetterId = value; }

template<int STATE>
inline CustomPreview::CustomPreviewBuilder<STATE | CustomPreview::CustomPreviewBuilder<STATE>::HeaderSet>&
CustomPreview::CustomPreviewBuilder<STATE>::setHeader(const String& value) {
  static_assert(!(STATE & HeaderSet), "property header should not be set yet");
  m_result->setHeader(value);
  return castState<HeaderSet>();
}
template<int STATE>
inline CustomPreview::CustomPreviewBuilder<STATE>& CustomPreview::CustomPreviewBuilder<STATE>::setBodyGetterId(const String& value) {
  m_result->setBodyGetterId(value);
  return *this;
}

inline CustomPreview::CustomPreview() {
}
inline ObjectPreview::~ObjectPreview() = default;
inline void ObjectPreview::setType(const String& value) { m_type = value; }
inline void ObjectPreview::setSubtype(const String& value) { m_subtype = value; }
inline void ObjectPreview::setDescription(const String& value) { m_description = value; }
inline void ObjectPreview::setOverflow(bool value) { m_overflow = value; }
inline void ObjectPreview::setProperties(std::unique_ptr<protocol::Array<protocol::Runtime::PropertyPreview>> value) { m_properties = std::move(value); }
inline void ObjectPreview::setEntries(std::unique_ptr<protocol::Array<protocol::Runtime::EntryPreview>> value) { m_entries = std::move(value); }

template<int STATE>
inline ObjectPreview::ObjectPreviewBuilder<STATE | ObjectPreview::ObjectPreviewBuilder<STATE>::TypeSet>&
ObjectPreview::ObjectPreviewBuilder<STATE>::setType(const String& value) {
  static_assert(!(STATE & TypeSet), "property type should not be set yet");
  m_result->setType(value);
  return castState<TypeSet>();
}
template<int STATE>
inline ObjectPreview::ObjectPreviewBuilder<STATE>& ObjectPreview::ObjectPreviewBuilder<STATE>::setSubtype(const String& value) {
  m_result->setSubtype(value);
  return *this;
}
template<int STATE>
inline ObjectPreview::ObjectPreviewBuilder<STATE>& ObjectPreview::ObjectPreviewBuilder<STATE>::setDescription(const String& value) {
  m_result->setDescription(value);
  return *this;
}
template<int STATE>
inline ObjectPreview::ObjectPreviewBuilder<STATE | ObjectPreview::ObjectPreviewBuilder<STATE>::OverflowSet>&
ObjectPreview::ObjectPreviewBuilder<STATE>::setOverflow(bool value) {
  static_assert(!(STATE & OverflowSet), "property overflow should not be set yet");
  m_result->setOverflow(value);
  return castState<OverflowSet>();
}
template<int STATE>
inline ObjectPreview::ObjectPreviewBuilder<STATE | ObjectPreview::ObjectPreviewBuilder<STATE>::PropertiesSet>&
ObjectPreview::ObjectPreviewBuilder<STATE>::setProperties(std::unique_ptr<protocol::Array<protocol::Runtime::PropertyPreview>> value) {
  static_assert(!(STATE & PropertiesSet), "property properties should not be set yet");
  m_result->setProperties(std::move(value));
  return castState<PropertiesSet>();
}
template<int STATE>
inline ObjectPreview::ObjectPreviewBuilder<STATE>& ObjectPreview::ObjectPreviewBuilder<STATE>::setEntries(std::unique_ptr<protocol::Array<protocol::Runtime::EntryPreview>> value) {
  m_result->setEntries(std::move(value));
  return *this;
}

inline ObjectPreview::ObjectPreview() {
  m_overflow = false;
}
inline PropertyPreview::~PropertyPreview() = default;
inline void PropertyPreview::setName(const String& value) { m_name = value; }
inline void PropertyPreview::setType(const String& value) { m_type = value; }
inline void PropertyPreview::setValue(const String& value) { m_value = value; }
inline void PropertyPreview::setValuePreview(std::unique_ptr<protocol::Runtime::ObjectPreview> value) { m_valuePreview = std::move(value); }
inline void PropertyPreview::setSubtype(const String& value) { m_subtype = value; }

template<int STATE>
inline PropertyPreview::PropertyPreviewBuilder<STATE | PropertyPreview::PropertyPreviewBuilder<STATE>::NameSet>&
PropertyPreview::PropertyPreviewBuilder<STATE>::setName(const String& value) {
  static_assert(!(STATE & NameSet), "property name should not be set yet");
  m_result->setName(value);
  return castState<NameSet>();
}
template<int STATE>
inline PropertyPreview::PropertyPreviewBuilder<STATE | PropertyPreview::PropertyPreviewBuilder<STATE>::TypeSet>&
PropertyPreview::PropertyPreviewBuilder<STATE>::setType(const String& value) {
  static_assert(!(STATE & TypeSet), "property type should not be set yet");
  m_result->setType(value);
  return castState<TypeSet>();
}
template<int STATE>
inline PropertyPreview::PropertyPreviewBuilder<STATE>& PropertyPreview::PropertyPreviewBuilder<STATE>::setValue(const String& value) {
  m_result->setValue(value);
  return *this;
}
template<int STATE>
inline PropertyPreview::PropertyPreviewBuilder<STATE>& PropertyPreview::PropertyPreviewBuilder<STATE>::setValuePreview(std::unique_ptr<protocol::Runtime::ObjectPreview> value) {
  m_result->setValuePreview(std::move(value));
  return *this;
}
template<int STATE>
inline PropertyPreview::PropertyPreviewBuilder<STATE>& PropertyPreview::PropertyPreviewBuilder<STATE>::setSubtype(const String& value) {
  m_result->setSubtype(value);
  return *this;
}

inline PropertyPreview::PropertyPreview() {
}
inline EntryPreview::~EntryPreview() = default;
inline void EntryPreview::setKey(std::unique_ptr<protocol::Runtime::ObjectPreview> value) { m_key = std::move(value); }
inline void EntryPreview::setValue(std::unique_ptr<protocol::Runtime::ObjectPreview> value) { m_value = std::move(value); }

template<int STATE>
inline EntryPreview::EntryPreviewBuilder<STATE>& EntryPreview::EntryPreviewBuilder<STATE>::setKey(std::unique_ptr<protocol::Runtime::ObjectPreview> value) {
  m_result->setKey(std::move(value));
  return *this;
}
template<int STATE>
inline EntryPreview::EntryPreviewBuilder<STATE | EntryPreview::EntryPreviewBuilder<STATE>::ValueSet>&
EntryPreview::EntryPreviewBuilder<STATE>::setValue(std::unique_ptr<protocol::Runtime::ObjectPreview> value) {
  static_assert(!(STATE & ValueSet), "property value should not be set yet");
  m_result->setValue(std::move(value));
  return castState<ValueSet>();
}

inline EntryPreview::EntryPreview() {
}
inline PropertyDescriptor::~PropertyDescriptor() = default;
inline void PropertyDescriptor::setName(const String& value) { m_name = value; }
inline void PropertyDescriptor::setValue(std::unique_ptr<protocol::Runtime::RemoteObject> value) { m_value = std::move(value); }
inline void PropertyDescriptor::setWritable(bool value) { m_writable = value; }
inline void PropertyDescriptor::setGet(std::unique_ptr<protocol::Runtime::RemoteObject> value) { m_get = std::move(value); }
inline void PropertyDescriptor::setSet(std::unique_ptr<protocol::Runtime::RemoteObject> value) { m_set = std::move(value); }
inline void PropertyDescriptor::setConfigurable(bool value) { m_configurable = value; }
inline void PropertyDescriptor::setEnumerable(bool value) { m_enumerable = value; }
inline void PropertyDescriptor::setWasThrown(bool value) { m_wasThrown = value; }
inline void PropertyDescriptor::setIsOwn(bool value) { m_isOwn = value; }
inline void PropertyDescriptor::setSymbol(std::unique_ptr<protocol::Runtime::RemoteObject> value) { m_symbol = std::move(value); }

template<int STATE>
inline PropertyDescriptor::PropertyDescriptorBuilder<STATE | PropertyDescriptor::PropertyDescriptorBuilder<STATE>::NameSet>&
PropertyDescriptor::PropertyDescriptorBuilder<STATE>::setName(const String& value) {
  static_assert(!(STATE & NameSet), "property name should not be set yet");
  m_result->setName(value);
  return castState<NameSet>();
}
template<int STATE>
inline PropertyDescriptor::PropertyDescriptorBuilder<STATE>& PropertyDescriptor::PropertyDescriptorBuilder<STATE>::setValue(std::unique_ptr<protocol::Runtime::RemoteObject> value) {
  m_result->setValue(std::move(value));
  return *this;
}
template<int STATE>
inline PropertyDescriptor::PropertyDescriptorBuilder<STATE>& PropertyDescriptor::PropertyDescriptorBuilder<STATE>::setWritable(bool value) {
  m_result->setWritable(value);
  return *this;
}
template<int STATE>
inline PropertyDescriptor::PropertyDescriptorBuilder<STATE>& PropertyDescriptor::PropertyDescriptorBuilder<STATE>::setGet(std::unique_ptr<protocol::Runtime::RemoteObject> value) {
  m_result->setGet(std::move(value));
  return *this;
}
template<int STATE>
inline PropertyDescriptor::PropertyDescriptorBuilder<STATE>& PropertyDescriptor::PropertyDescriptorBuilder<STATE>::setSet(std::unique_ptr<protocol::Runtime::RemoteObject> value) {
  m_result->setSet(std::move(value));
  return *this;
}
template<int STATE>
inline PropertyDescriptor::PropertyDescriptorBuilder<STATE | PropertyDescriptor::PropertyDescriptorBuilder<STATE>::ConfigurableSet>&
PropertyDescriptor::PropertyDescriptorBuilder<STATE>::setConfigurable(bool value) {
  static_assert(!(STATE & ConfigurableSet), "property configurable should not be set yet");
  m_result->setConfigurable(value);
  return castState<ConfigurableSet>();
}
template<int STATE>
inline PropertyDescriptor::PropertyDescriptorBuilder<STATE | PropertyDescriptor::PropertyDescriptorBuilder<STATE>::EnumerableSet>&
PropertyDescriptor::PropertyDescriptorBuilder<STATE>::setEnumerable(bool value) {
  static_assert(!(STATE & EnumerableSet), "property enumerable should not be set yet");
  m_result->setEnumerable(value);
  return castState<EnumerableSet>();
}
template<int STATE>
inline PropertyDescriptor::PropertyDescriptorBuilder<STATE>& PropertyDescriptor::PropertyDescriptorBuilder<STATE>::setWasThrown(bool value) {
  m_result->setWasThrown(value);
  return *this;
}
template<int STATE>
inline PropertyDescriptor::PropertyDescriptorBuilder<STATE>& PropertyDescriptor::PropertyDescriptorBuilder<STATE>::setIsOwn(bool value) {
  m_result->setIsOwn(value);
  return *this;
}
template<int STATE>
inline PropertyDescriptor::PropertyDescriptorBuilder<STATE>& PropertyDescriptor::PropertyDescriptorBuilder<STATE>::setSymbol(std::unique_ptr<protocol::Runtime::RemoteObject> value) {
  m_result->setSymbol(std::move(value));
  return *this;
}

inline PropertyDescriptor::PropertyDescriptor() {
  m_configurable = false;
  m_enumerable = false;
}
inline InternalPropertyDescriptor::~InternalPropertyDescriptor() = default;
inline void InternalPropertyDescriptor::setName(const String& value) { m_name = value; }
inline void InternalPropertyDescriptor::setValue(std::unique_ptr<protocol::Runtime::RemoteObject> value) { m_value = std::move(value); }

template<int STATE>
inline InternalPropertyDescriptor::InternalPropertyDescriptorBuilder<STATE | InternalPropertyDescriptor::InternalPropertyDescriptorBuilder<STATE>::NameSet>&
InternalPropertyDescriptor::InternalPropertyDescriptorBuilder<STATE>::setName(const String& value) {
  static_assert(!(STATE & NameSet), "property name should not be set yet");
  m_result->setName(value);
  return castState<NameSet>();
}
template<int STATE>
inline InternalPropertyDescriptor::InternalPropertyDescriptorBuilder<STATE>& InternalPropertyDescriptor::InternalPropertyDescriptorBuilder<STATE>::setValue(std::unique_ptr<protocol::Runtime::RemoteObject> value) {
  m_result->setValue(std::move(value));
  return *this;
}

inline InternalPropertyDescriptor::InternalPropertyDescriptor() {
}
inline PrivatePropertyDescriptor::~PrivatePropertyDescriptor() = default;
inline void PrivatePropertyDescriptor::setName(const String& value) { m_name = value; }
inline void PrivatePropertyDescriptor::setValue(std::unique_ptr<protocol::Runtime::RemoteObject> value) { m_value = std::move(value); }
inline void PrivatePropertyDescriptor::setGet(std::unique_ptr<protocol::Runtime::RemoteObject> value) { m_get = std::move(value); }
inline void PrivatePropertyDescriptor::setSet(std::unique_ptr<protocol::Runtime::RemoteObject> value) { m_set = std::move(value); }

template<int STATE>
inline PrivatePropertyDescriptor::PrivatePropertyDescriptorBuilder<STATE | PrivatePropertyDescriptor::PrivatePropertyDescriptorBuilder<STATE>::NameSet>&
PrivatePropertyDescriptor::PrivatePropertyDescriptorBuilder<STATE>::setName(const String& value) {
  static_assert(!(STATE & NameSet), "property name should not be set yet");
  m_result->setName(value);
  return castState<NameSet>();
}
template<int STATE>
inline PrivatePropertyDescriptor::PrivatePropertyDescriptorBuilder<STATE>& PrivatePropertyDescriptor::PrivatePropertyDescriptorBuilder<STATE>::setValue(std::unique_ptr<protocol::Runtime::RemoteObject> value) {
  m_result->setValue(std::move(value));
  return *this;
}
template<int STATE>
inline PrivatePropertyDescriptor::PrivatePropertyDescriptorBuilder<STATE>& PrivatePropertyDescriptor::PrivatePropertyDescriptorBuilder<STATE>::setGet(std::unique_ptr<protocol::Runtime::RemoteObject> value) {
  m_result->setGet(std::move(value));
  return *this;
}
template<int STATE>
inline PrivatePropertyDescriptor::PrivatePropertyDescriptorBuilder<STATE>& PrivatePropertyDescriptor::PrivatePropertyDescriptorBuilder<STATE>::setSet(std::unique_ptr<protocol::Runtime::RemoteObject> value) {
  m_result->setSet(std::move(value));
  return *this;
}

inline PrivatePropertyDescriptor::PrivatePropertyDescriptor() {
}
inline CallArgument::~CallArgument() = default;
inline void CallArgument::setValue(std::unique_ptr<protocol::Value> value) { m_value = std::move(value); }
inline void CallArgument::setUnserializableValue(const String& value) { m_unserializableValue = value; }
inline void CallArgument::setObjectId(const String& value) { m_objectId = value; }

template<int STATE>
inline CallArgument::CallArgumentBuilder<STATE>& CallArgument::CallArgumentBuilder<STATE>::setValue(std::unique_ptr<protocol::Value> value) {
  m_result->setValue(std::move(value));
  return *this;
}
template<int STATE>
inline CallArgument::CallArgumentBuilder<STATE>& CallArgument::CallArgumentBuilder<STATE>::setUnserializableValue(const String& value) {
  m_result->setUnserializableValue(value);
  return *this;
}
template<int STATE>
inline CallArgument::CallArgumentBuilder<STATE>& CallArgument::CallArgumentBuilder<STATE>::setObjectId(const String& value) {
  m_result->setObjectId(value);
  return *this;
}

inline CallArgument::CallArgument() {
}
inline ExecutionContextDescription::~ExecutionContextDescription() = default;
inline void ExecutionContextDescription::setId(int value) { m_id = value; }
inline void ExecutionContextDescription::setOrigin(const String& value) { m_origin = value; }
inline void ExecutionContextDescription::setName(const String& value) { m_name = value; }
inline void ExecutionContextDescription::setUniqueId(const String& value) { m_uniqueId = value; }
inline void ExecutionContextDescription::setAuxData(std::unique_ptr<protocol::DictionaryValue> value) { m_auxData = std::move(value); }

template<int STATE>
inline ExecutionContextDescription::ExecutionContextDescriptionBuilder<STATE | ExecutionContextDescription::ExecutionContextDescriptionBuilder<STATE>::IdSet>&
ExecutionContextDescription::ExecutionContextDescriptionBuilder<STATE>::setId(int value) {
  static_assert(!(STATE & IdSet), "property id should not be set yet");
  m_result->setId(value);
  return castState<IdSet>();
}
template<int STATE>
inline ExecutionContextDescription::ExecutionContextDescriptionBuilder<STATE | ExecutionContextDescription::ExecutionContextDescriptionBuilder<STATE>::OriginSet>&
ExecutionContextDescription::ExecutionContextDescriptionBuilder<STATE>::setOrigin(const String& value) {
  static_assert(!(STATE & OriginSet), "property origin should not be set yet");
  m_result->setOrigin(value);
  return castState<OriginSet>();
}
template<int STATE>
inline ExecutionContextDescription::ExecutionContextDescriptionBuilder<STATE | ExecutionContextDescription::ExecutionContextDescriptionBuilder<STATE>::NameSet>&
ExecutionContextDescription::ExecutionContextDescriptionBuilder<STATE>::setName(const String& value) {
  static_assert(!(STATE & NameSet), "property name should not be set yet");
  m_result->setName(value);
  return castState<NameSet>();
}
template<int STATE>
inline ExecutionContextDescription::ExecutionContextDescriptionBuilder<STATE | ExecutionContextDescription::ExecutionContextDescriptionBuilder<STATE>::UniqueIdSet>&
ExecutionContextDescription::ExecutionContextDescriptionBuilder<STATE>::setUniqueId(const String& value) {
  static_assert(!(STATE & UniqueIdSet), "property uniqueId should not be set yet");
  m_result->setUniqueId(value);
  return castState<UniqueIdSet>();
}
template<int STATE>
inline ExecutionContextDescription::ExecutionContextDescriptionBuilder<STATE>& ExecutionContextDescription::ExecutionContextDescriptionBuilder<STATE>::setAuxData(std::unique_ptr<protocol::DictionaryValue> value) {
  m_result->setAuxData(std::move(value));
  return *this;
}

inline ExecutionContextDescription::ExecutionContextDescription() {
  m_id = 0;
}
inline ExceptionDetails::~ExceptionDetails() = default;
inline void ExceptionDetails::setExceptionId(int value) { m_exceptionId = value; }
inline void ExceptionDetails::setText(const String& value) { m_text = value; }
inline void ExceptionDetails::setLineNumber(int value) { m_lineNumber = value; }
inline void ExceptionDetails::setColumnNumber(int value) { m_columnNumber = value; }
inline void ExceptionDetails::setScriptId(const String& value) { m_scriptId = value; }
inline void ExceptionDetails::setUrl(const String& value) { m_url = value; }
inline void ExceptionDetails::setStackTrace(std::unique_ptr<protocol::Runtime::StackTrace> value) { m_stackTrace = std::move(value); }
inline void ExceptionDetails::setException(std::unique_ptr<protocol::Runtime::RemoteObject> value) { m_exception = std::move(value); }
inline void ExceptionDetails::setExecutionContextId(int value) { m_executionContextId = value; }
inline void ExceptionDetails::setExceptionMetaData(std::unique_ptr<protocol::DictionaryValue> value) { m_exceptionMetaData = std::move(value); }

template<int STATE>
inline ExceptionDetails::ExceptionDetailsBuilder<STATE | ExceptionDetails::ExceptionDetailsBuilder<STATE>::ExceptionIdSet>&
ExceptionDetails::ExceptionDetailsBuilder<STATE>::setExceptionId(int value) {
  static_assert(!(STATE & ExceptionIdSet), "property exceptionId should not be set yet");
  m_result->setExceptionId(value);
  return castState<ExceptionIdSet>();
}
template<int STATE>
inline ExceptionDetails::ExceptionDetailsBuilder<STATE | ExceptionDetails::ExceptionDetailsBuilder<STATE>::TextSet>&
ExceptionDetails::ExceptionDetailsBuilder<STATE>::setText(const String& value) {
  static_assert(!(STATE & TextSet), "property text should not be set yet");
  m_result->setText(value);
  return castState<TextSet>();
}
template<int STATE>
inline ExceptionDetails::ExceptionDetailsBuilder<STATE | ExceptionDetails::ExceptionDetailsBuilder<STATE>::LineNumberSet>&
ExceptionDetails::ExceptionDetailsBuilder<STATE>::setLineNumber(int value) {
  static_assert(!(STATE & LineNumberSet), "property lineNumber should not be set yet");
  m_result->setLineNumber(value);
  return castState<LineNumberSet>();
}
template<int STATE>
inline ExceptionDetails::ExceptionDetailsBuilder<STATE | ExceptionDetails::ExceptionDetailsBuilder<STATE>::ColumnNumberSet>&
ExceptionDetails::ExceptionDetailsBuilder<STATE>::setColumnNumber(int value) {
  static_assert(!(STATE & ColumnNumberSet), "property columnNumber should not be set yet");
  m_result->setColumnNumber(value);
  return castState<ColumnNumberSet>();
}
template<int STATE>
inline ExceptionDetails::ExceptionDetailsBuilder<STATE>& ExceptionDetails::ExceptionDetailsBuilder<STATE>::setScriptId(const String& value) {
  m_result->setScriptId(value);
  return *this;
}
template<int STATE>
inline ExceptionDetails::ExceptionDetailsBuilder<STATE>& ExceptionDetails::ExceptionDetailsBuilder<STATE>::setUrl(const String& value) {
  m_result->setUrl(value);
  return *this;
}
template<int STATE>
inline ExceptionDetails::ExceptionDetailsBuilder<STATE>& ExceptionDetails::ExceptionDetailsBuilder<STATE>::setStackTrace(std::unique_ptr<protocol::Runtime::StackTrace> value) {
  m_result->setStackTrace(std::move(value));
  return *this;
}
template<int STATE>
inline ExceptionDetails::ExceptionDetailsBuilder<STATE>& ExceptionDetails::ExceptionDetailsBuilder<STATE>::setException(std::unique_ptr<protocol::Runtime::RemoteObject> value) {
  m_result->setException(std::move(value));
  return *this;
}
template<int STATE>
inline ExceptionDetails::ExceptionDetailsBuilder<STATE>& ExceptionDetails::ExceptionDetailsBuilder<STATE>::setExecutionContextId(int value) {
  m_result->setExecutionContextId(value);
  return *this;
}
template<int STATE>
inline ExceptionDetails::ExceptionDetailsBuilder<STATE>& ExceptionDetails::ExceptionDetailsBuilder<STATE>::setExceptionMetaData(std::unique_ptr<protocol::DictionaryValue> value) {
  m_result->setExceptionMetaData(std::move(value));
  return *this;
}

inline ExceptionDetails::ExceptionDetails() {
  m_exceptionId = 0;
  m_lineNumber = 0;
  m_columnNumber = 0;
}
inline CallFrame::~CallFrame() = default;
inline void CallFrame::setFunctionName(const String& value) { m_functionName = value; }
inline void CallFrame::setScriptId(const String& value) { m_scriptId = value; }
inline void CallFrame::setUrl(const String& value) { m_url = value; }
inline void CallFrame::setLineNumber(int value) { m_lineNumber = value; }
inline void CallFrame::setColumnNumber(int value) { m_columnNumber = value; }

template<int STATE>
inline CallFrame::CallFrameBuilder<STATE | CallFrame::CallFrameBuilder<STATE>::FunctionNameSet>&
CallFrame::CallFrameBuilder<STATE>::setFunctionName(const String& value) {
  static_assert(!(STATE & FunctionNameSet), "property functionName should not be set yet");
  m_result->setFunctionName(value);
  return castState<FunctionNameSet>();
}
template<int STATE>
inline CallFrame::CallFrameBuilder<STATE | CallFrame::CallFrameBuilder<STATE>::ScriptIdSet>&
CallFrame::CallFrameBuilder<STATE>::setScriptId(const String& value) {
  static_assert(!(STATE & ScriptIdSet), "property scriptId should not be set yet");
  m_result->setScriptId(value);
  return castState<ScriptIdSet>();
}
template<int STATE>
inline CallFrame::CallFrameBuilder<STATE | CallFrame::CallFrameBuilder<STATE>::UrlSet>&
CallFrame::CallFrameBuilder<STATE>::setUrl(const String& value) {
  static_assert(!(STATE & UrlSet), "property url should not be set yet");
  m_result->setUrl(value);
  return castState<UrlSet>();
}
template<int STATE>
inline CallFrame::CallFrameBuilder<STATE | CallFrame::CallFrameBuilder<STATE>::LineNumberSet>&
CallFrame::CallFrameBuilder<STATE>::setLineNumber(int value) {
  static_assert(!(STATE & LineNumberSet), "property lineNumber should not be set yet");
  m_result->setLineNumber(value);
  return castState<LineNumberSet>();
}
template<int STATE>
inline CallFrame::CallFrameBuilder<STATE | CallFrame::CallFrameBuilder<STATE>::ColumnNumberSet>&
CallFrame::CallFrameBuilder<STATE>::setColumnNumber(int value) {
  static_assert(!(STATE & ColumnNumberSet), "property columnNumber should not be set yet");
  m_result->setColumnNumber(value);
  return castState<ColumnNumberSet>();
}

inline CallFrame::CallFrame() {
  m_lineNumber = 0;
  m_columnNumber = 0;
}
inline StackTrace::~StackTrace() = default;
inline void StackTrace::setDescription(const String& value) { m_description = value; }
inline void StackTrace::setCallFrames(std::unique_ptr<protocol::Array<protocol::Runtime::CallFrame>> value) { m_callFrames = std::move(value); }
inline void StackTrace::setParent(std::unique_ptr<protocol::Runtime::StackTrace> value) { m_parent = std::move(value); }
inline void StackTrace::setParentId(std::unique_ptr<protocol::Runtime::StackTraceId> value) { m_parentId = std::move(value); }

template<int STATE>
inline StackTrace::StackTraceBuilder<STATE>& StackTrace::StackTraceBuilder<STATE>::setDescription(const String& value) {
  m_result->setDescription(value);
  return *this;
}
template<int STATE>
inline StackTrace::StackTraceBuilder<STATE | StackTrace::StackTraceBuilder<STATE>::CallFramesSet>&
StackTrace::StackTraceBuilder<STATE>::setCallFrames(std::unique_ptr<protocol::Array<protocol::Runtime::CallFrame>> value) {
  static_assert(!(STATE & CallFramesSet), "property callFrames should not be set yet");
  m_result->setCallFrames(std::move(value));
  return castState<CallFramesSet>();
}
template<int STATE>
inline StackTrace::StackTraceBuilder<STATE>& StackTrace::StackTraceBuilder<STATE>::setParent(std::unique_ptr<protocol::Runtime::StackTrace> value) {
  m_result->setParent(std::move(value));
  return *this;
}
template<int STATE>
inline StackTrace::StackTraceBuilder<STATE>& StackTrace::StackTraceBuilder<STATE>::setParentId(std::unique_ptr<protocol::Runtime::StackTraceId> value) {
  m_result->setParentId(std::move(value));
  return *this;
}

inline StackTrace::StackTrace() {
}
inline StackTraceId::~StackTraceId() = default;
inline void StackTraceId::setId(const String& value) { m_id = value; }
inline void StackTraceId::setDebuggerId(const String& value) { m_debuggerId = value; }

template<int STATE>
inline StackTraceId::StackTraceIdBuilder<STATE | StackTraceId::StackTraceIdBuilder<STATE>::IdSet>&
StackTraceId::StackTraceIdBuilder<STATE>::setId(const String& value) {
  static_assert(!(STATE & IdSet), "property id should not be set yet");
  m_result->setId(value);
  return castState<IdSet>();
}
template<int STATE>
inline StackTraceId::StackTraceIdBuilder<STATE>& StackTraceId::StackTraceIdBuilder<STATE>::setDebuggerId(const String& value) {
  m_result->setDebuggerId(value);
  return *this;
}

inline StackTraceId::StackTraceId() {
}

// ------------- Backend interface.

class  Backend {
public:
    virtual ~Backend() { }

    class  AwaitPromiseCallback {
    public:
        virtual void sendSuccess(std::unique_ptr<protocol::Runtime::RemoteObject> result, std::unique_ptr<protocol::Runtime::ExceptionDetails> exceptionDetails) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~AwaitPromiseCallback() { }
    };
    virtual void awaitPromise(const String& in_promiseObjectId, std::optional<bool> in_returnByValue, std::optional<bool> in_generatePreview, std::unique_ptr<AwaitPromiseCallback> callback) = 0;
    class  CallFunctionOnCallback {
    public:
        virtual void sendSuccess(std::unique_ptr<protocol::Runtime::RemoteObject> result, std::unique_ptr<protocol::Runtime::ExceptionDetails> exceptionDetails) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~CallFunctionOnCallback() { }
    };
    virtual void callFunctionOn(const String& in_functionDeclaration, std::optional<String> in_objectId, std::unique_ptr<protocol::Array<protocol::Runtime::CallArgument>> in_arguments, std::optional<bool> in_silent, std::optional<bool> in_returnByValue, std::optional<bool> in_generatePreview, std::optional<bool> in_userGesture, std::optional<bool> in_awaitPromise, std::optional<int> in_executionContextId, std::optional<String> in_objectGroup, std::optional<bool> in_throwOnSideEffect, std::optional<String> in_uniqueContextId, std::unique_ptr<protocol::Runtime::SerializationOptions> in_serializationOptions, std::unique_ptr<CallFunctionOnCallback> callback) = 0;
    virtual DispatchResponse compileScript(const String& in_expression, const String& in_sourceURL, bool in_persistScript, std::optional<int> in_executionContextId, std::optional<String>* out_scriptId, std::unique_ptr<protocol::Runtime::ExceptionDetails>* out_exceptionDetails) = 0;
    virtual DispatchResponse disable() = 0;
    virtual DispatchResponse discardConsoleEntries() = 0;
    virtual DispatchResponse enable() = 0;
    class  EvaluateCallback {
    public:
        virtual void sendSuccess(std::unique_ptr<protocol::Runtime::RemoteObject> result, std::unique_ptr<protocol::Runtime::ExceptionDetails> exceptionDetails) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~EvaluateCallback() { }
    };
    virtual void evaluate(const String& in_expression, std::optional<String> in_objectGroup, std::optional<bool> in_includeCommandLineAPI, std::optional<bool> in_silent, std::optional<int> in_contextId, std::optional<bool> in_returnByValue, std::optional<bool> in_generatePreview, std::optional<bool> in_userGesture, std::optional<bool> in_awaitPromise, std::optional<bool> in_throwOnSideEffect, std::optional<double> in_timeout, std::optional<bool> in_disableBreaks, std::optional<bool> in_replMode, std::optional<bool> in_allowUnsafeEvalBlockedByCSP, std::optional<String> in_uniqueContextId, std::unique_ptr<protocol::Runtime::SerializationOptions> in_serializationOptions, std::unique_ptr<EvaluateCallback> callback) = 0;
    virtual DispatchResponse getIsolateId(String* out_id) = 0;
    virtual DispatchResponse getHeapUsage(double* out_usedSize, double* out_totalSize, double* out_embedderHeapUsedSize, double* out_backingStorageSize) = 0;
    virtual DispatchResponse getProperties(const String& in_objectId, std::optional<bool> in_ownProperties, std::optional<bool> in_accessorPropertiesOnly, std::optional<bool> in_generatePreview, std::optional<bool> in_nonIndexedPropertiesOnly, std::unique_ptr<protocol::Array<protocol::Runtime::PropertyDescriptor>>* out_result, std::unique_ptr<protocol::Array<protocol::Runtime::InternalPropertyDescriptor>>* out_internalProperties, std::unique_ptr<protocol::Array<protocol::Runtime::PrivatePropertyDescriptor>>* out_privateProperties, std::unique_ptr<protocol::Runtime::ExceptionDetails>* out_exceptionDetails) = 0;
    virtual DispatchResponse globalLexicalScopeNames(std::optional<int> in_executionContextId, std::unique_ptr<protocol::Array<String>>* out_names) = 0;
    virtual DispatchResponse queryObjects(const String& in_prototypeObjectId, std::optional<String> in_objectGroup, std::unique_ptr<protocol::Runtime::RemoteObject>* out_objects) = 0;
    virtual DispatchResponse releaseObject(const String& in_objectId) = 0;
    virtual DispatchResponse releaseObjectGroup(const String& in_objectGroup) = 0;
    virtual DispatchResponse runIfWaitingForDebugger() = 0;
    class  RunScriptCallback {
    public:
        virtual void sendSuccess(std::unique_ptr<protocol::Runtime::RemoteObject> result, std::unique_ptr<protocol::Runtime::ExceptionDetails> exceptionDetails) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~RunScriptCallback() { }
    };
    virtual void runScript(const String& in_scriptId, std::optional<int> in_executionContextId, std::optional<String> in_objectGroup, std::optional<bool> in_silent, std::optional<bool> in_includeCommandLineAPI, std::optional<bool> in_returnByValue, std::optional<bool> in_generatePreview, std::optional<bool> in_awaitPromise, std::unique_ptr<RunScriptCallback> callback) = 0;
    virtual DispatchResponse setCustomObjectFormatterEnabled(bool in_enabled) = 0;
    virtual DispatchResponse setMaxCallStackSizeToCapture(int in_size) = 0;
    class  TerminateExecutionCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~TerminateExecutionCallback() { }
    };
    virtual void terminateExecution(std::unique_ptr<TerminateExecutionCallback> callback) = 0;
    virtual DispatchResponse addBinding(const String& in_name, std::optional<int> in_executionContextId, std::optional<String> in_executionContextName) = 0;
    virtual DispatchResponse removeBinding(const String& in_name) = 0;
    virtual DispatchResponse getExceptionDetails(const String& in_errorObjectId, std::unique_ptr<protocol::Runtime::ExceptionDetails>* out_exceptionDetails) = 0;

};

// ------------- Frontend interface.

class  Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void bindingCalled(const String& name, const String& payload, int executionContextId);
    void consoleAPICalled(const String& type, std::unique_ptr<protocol::Array<protocol::Runtime::RemoteObject>> args, int executionContextId, double timestamp, std::unique_ptr<protocol::Runtime::StackTrace> stackTrace = {}, std::optional<String> context = {});
    void exceptionRevoked(const String& reason, int exceptionId);
    void exceptionThrown(double timestamp, std::unique_ptr<protocol::Runtime::ExceptionDetails> exceptionDetails);
    void executionContextCreated(std::unique_ptr<protocol::Runtime::ExecutionContextDescription> context);
    void executionContextDestroyed(int executionContextId, const String& executionContextUniqueId);
    void executionContextsCleared();
    void inspectRequested(std::unique_ptr<protocol::Runtime::RemoteObject> object, std::unique_ptr<protocol::DictionaryValue> hints, std::optional<int> executionContextId = {});

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class  Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class  Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Runtime
} // namespace v8_inspector
} // namespace protocol

#endif // !defined(v8_inspector_protocol_Runtime_h)
