// This file is generated by TypeBuilder_cpp.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "src/inspector/protocol/Runtime.h"

#include "src/inspector/protocol/Protocol.h"

#include "v8//third_party/inspector_protocol/crdtp/cbor.h"
#include "v8//third_party/inspector_protocol/crdtp/find_by_first.h"
#include "v8//third_party/inspector_protocol/crdtp/span.h"

namespace v8_inspector {
namespace protocol {
namespace Runtime {

using v8_crdtp::DeserializerState;
using v8_crdtp::ProtocolTypeTraits;

// ------------- Enum values from types.

const char Metainfo::domainName[] = "Runtime";
const char Metainfo::commandPrefix[] = "Runtime.";
const char Metainfo::version[] = "1.3";



const char* SerializationOptions::SerializationEnum::Deep = "deep";
const char* SerializationOptions::SerializationEnum::Json = "json";
const char* SerializationOptions::SerializationEnum::IdOnly = "idOnly";
V8_CRDTP_BEGIN_DESERIALIZER(SerializationOptions)
    V8_CRDTP_DESERIALIZE_FIELD_OPT("additionalParameters", m_additionalParameters),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("maxDepth", m_maxDepth),
    V8_CRDTP_DESERIALIZE_FIELD("serialization", m_serialization),
V8_CRDTP_END_DESERIALIZER()

V8_CRDTP_BEGIN_SERIALIZER(SerializationOptions)
    V8_CRDTP_SERIALIZE_FIELD("serialization", m_serialization);
    V8_CRDTP_SERIALIZE_FIELD("maxDepth", m_maxDepth);
    V8_CRDTP_SERIALIZE_FIELD("additionalParameters", m_additionalParameters);
V8_CRDTP_END_SERIALIZER();



const char* DeepSerializedValue::TypeEnum::Undefined = "undefined";
const char* DeepSerializedValue::TypeEnum::Null = "null";
const char* DeepSerializedValue::TypeEnum::String = "string";
const char* DeepSerializedValue::TypeEnum::Number = "number";
const char* DeepSerializedValue::TypeEnum::Boolean = "boolean";
const char* DeepSerializedValue::TypeEnum::Bigint = "bigint";
const char* DeepSerializedValue::TypeEnum::Regexp = "regexp";
const char* DeepSerializedValue::TypeEnum::Date = "date";
const char* DeepSerializedValue::TypeEnum::Symbol = "symbol";
const char* DeepSerializedValue::TypeEnum::Array = "array";
const char* DeepSerializedValue::TypeEnum::Object = "object";
const char* DeepSerializedValue::TypeEnum::Function = "function";
const char* DeepSerializedValue::TypeEnum::Map = "map";
const char* DeepSerializedValue::TypeEnum::Set = "set";
const char* DeepSerializedValue::TypeEnum::Weakmap = "weakmap";
const char* DeepSerializedValue::TypeEnum::Weakset = "weakset";
const char* DeepSerializedValue::TypeEnum::Error = "error";
const char* DeepSerializedValue::TypeEnum::Proxy = "proxy";
const char* DeepSerializedValue::TypeEnum::Promise = "promise";
const char* DeepSerializedValue::TypeEnum::Typedarray = "typedarray";
const char* DeepSerializedValue::TypeEnum::Arraybuffer = "arraybuffer";
const char* DeepSerializedValue::TypeEnum::Node = "node";
const char* DeepSerializedValue::TypeEnum::Window = "window";
const char* DeepSerializedValue::TypeEnum::Generator = "generator";
V8_CRDTP_BEGIN_DESERIALIZER(DeepSerializedValue)
    V8_CRDTP_DESERIALIZE_FIELD_OPT("objectId", m_objectId),
    V8_CRDTP_DESERIALIZE_FIELD("type", m_type),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("value", m_value),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("weakLocalObjectReference", m_weakLocalObjectReference),
V8_CRDTP_END_DESERIALIZER()

V8_CRDTP_BEGIN_SERIALIZER(DeepSerializedValue)
    V8_CRDTP_SERIALIZE_FIELD("type", m_type);
    V8_CRDTP_SERIALIZE_FIELD("value", m_value);
    V8_CRDTP_SERIALIZE_FIELD("objectId", m_objectId);
    V8_CRDTP_SERIALIZE_FIELD("weakLocalObjectReference", m_weakLocalObjectReference);
V8_CRDTP_END_SERIALIZER();





const char* RemoteObject::TypeEnum::Object = "object";
const char* RemoteObject::TypeEnum::Function = "function";
const char* RemoteObject::TypeEnum::Undefined = "undefined";
const char* RemoteObject::TypeEnum::String = "string";
const char* RemoteObject::TypeEnum::Number = "number";
const char* RemoteObject::TypeEnum::Boolean = "boolean";
const char* RemoteObject::TypeEnum::Symbol = "symbol";
const char* RemoteObject::TypeEnum::Bigint = "bigint";

const char* RemoteObject::SubtypeEnum::Array = "array";
const char* RemoteObject::SubtypeEnum::Null = "null";
const char* RemoteObject::SubtypeEnum::Node = "node";
const char* RemoteObject::SubtypeEnum::Regexp = "regexp";
const char* RemoteObject::SubtypeEnum::Date = "date";
const char* RemoteObject::SubtypeEnum::Map = "map";
const char* RemoteObject::SubtypeEnum::Set = "set";
const char* RemoteObject::SubtypeEnum::Weakmap = "weakmap";
const char* RemoteObject::SubtypeEnum::Weakset = "weakset";
const char* RemoteObject::SubtypeEnum::Iterator = "iterator";
const char* RemoteObject::SubtypeEnum::Generator = "generator";
const char* RemoteObject::SubtypeEnum::Error = "error";
const char* RemoteObject::SubtypeEnum::Proxy = "proxy";
const char* RemoteObject::SubtypeEnum::Promise = "promise";
const char* RemoteObject::SubtypeEnum::Typedarray = "typedarray";
const char* RemoteObject::SubtypeEnum::Arraybuffer = "arraybuffer";
const char* RemoteObject::SubtypeEnum::Dataview = "dataview";
const char* RemoteObject::SubtypeEnum::Webassemblymemory = "webassemblymemory";
const char* RemoteObject::SubtypeEnum::Wasmvalue = "wasmvalue";
const char* RemoteObject::SubtypeEnum::Trustedtype = "trustedtype";
V8_CRDTP_BEGIN_DESERIALIZER(RemoteObject)
    V8_CRDTP_DESERIALIZE_FIELD_OPT("className", m_className),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("customPreview", m_customPreview),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("deepSerializedValue", m_deepSerializedValue),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("description", m_description),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("objectId", m_objectId),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("preview", m_preview),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("subtype", m_subtype),
    V8_CRDTP_DESERIALIZE_FIELD("type", m_type),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("unserializableValue", m_unserializableValue),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("value", m_value),
V8_CRDTP_END_DESERIALIZER()

V8_CRDTP_BEGIN_SERIALIZER(RemoteObject)
    V8_CRDTP_SERIALIZE_FIELD("type", m_type);
    V8_CRDTP_SERIALIZE_FIELD("subtype", m_subtype);
    V8_CRDTP_SERIALIZE_FIELD("className", m_className);
    V8_CRDTP_SERIALIZE_FIELD("value", m_value);
    V8_CRDTP_SERIALIZE_FIELD("unserializableValue", m_unserializableValue);
    V8_CRDTP_SERIALIZE_FIELD("description", m_description);
    V8_CRDTP_SERIALIZE_FIELD("deepSerializedValue", m_deepSerializedValue);
    V8_CRDTP_SERIALIZE_FIELD("objectId", m_objectId);
    V8_CRDTP_SERIALIZE_FIELD("preview", m_preview);
    V8_CRDTP_SERIALIZE_FIELD("customPreview", m_customPreview);
V8_CRDTP_END_SERIALIZER();

// static
std::unique_ptr<API::RemoteObject> API::RemoteObject::fromBinary(const uint8_t* data, size_t length)
{
    return protocol::Runtime::RemoteObject::FromBinary(data, length);
}

V8_CRDTP_BEGIN_DESERIALIZER(CustomPreview)
    V8_CRDTP_DESERIALIZE_FIELD_OPT("bodyGetterId", m_bodyGetterId),
    V8_CRDTP_DESERIALIZE_FIELD("header", m_header),
V8_CRDTP_END_DESERIALIZER()

V8_CRDTP_BEGIN_SERIALIZER(CustomPreview)
    V8_CRDTP_SERIALIZE_FIELD("header", m_header);
    V8_CRDTP_SERIALIZE_FIELD("bodyGetterId", m_bodyGetterId);
V8_CRDTP_END_SERIALIZER();



const char* ObjectPreview::TypeEnum::Object = "object";
const char* ObjectPreview::TypeEnum::Function = "function";
const char* ObjectPreview::TypeEnum::Undefined = "undefined";
const char* ObjectPreview::TypeEnum::String = "string";
const char* ObjectPreview::TypeEnum::Number = "number";
const char* ObjectPreview::TypeEnum::Boolean = "boolean";
const char* ObjectPreview::TypeEnum::Symbol = "symbol";
const char* ObjectPreview::TypeEnum::Bigint = "bigint";

const char* ObjectPreview::SubtypeEnum::Array = "array";
const char* ObjectPreview::SubtypeEnum::Null = "null";
const char* ObjectPreview::SubtypeEnum::Node = "node";
const char* ObjectPreview::SubtypeEnum::Regexp = "regexp";
const char* ObjectPreview::SubtypeEnum::Date = "date";
const char* ObjectPreview::SubtypeEnum::Map = "map";
const char* ObjectPreview::SubtypeEnum::Set = "set";
const char* ObjectPreview::SubtypeEnum::Weakmap = "weakmap";
const char* ObjectPreview::SubtypeEnum::Weakset = "weakset";
const char* ObjectPreview::SubtypeEnum::Iterator = "iterator";
const char* ObjectPreview::SubtypeEnum::Generator = "generator";
const char* ObjectPreview::SubtypeEnum::Error = "error";
const char* ObjectPreview::SubtypeEnum::Proxy = "proxy";
const char* ObjectPreview::SubtypeEnum::Promise = "promise";
const char* ObjectPreview::SubtypeEnum::Typedarray = "typedarray";
const char* ObjectPreview::SubtypeEnum::Arraybuffer = "arraybuffer";
const char* ObjectPreview::SubtypeEnum::Dataview = "dataview";
const char* ObjectPreview::SubtypeEnum::Webassemblymemory = "webassemblymemory";
const char* ObjectPreview::SubtypeEnum::Wasmvalue = "wasmvalue";
const char* ObjectPreview::SubtypeEnum::Trustedtype = "trustedtype";
V8_CRDTP_BEGIN_DESERIALIZER(ObjectPreview)
    V8_CRDTP_DESERIALIZE_FIELD_OPT("description", m_description),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("entries", m_entries),
    V8_CRDTP_DESERIALIZE_FIELD("overflow", m_overflow),
    V8_CRDTP_DESERIALIZE_FIELD("properties", m_properties),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("subtype", m_subtype),
    V8_CRDTP_DESERIALIZE_FIELD("type", m_type),
V8_CRDTP_END_DESERIALIZER()

V8_CRDTP_BEGIN_SERIALIZER(ObjectPreview)
    V8_CRDTP_SERIALIZE_FIELD("type", m_type);
    V8_CRDTP_SERIALIZE_FIELD("subtype", m_subtype);
    V8_CRDTP_SERIALIZE_FIELD("description", m_description);
    V8_CRDTP_SERIALIZE_FIELD("overflow", m_overflow);
    V8_CRDTP_SERIALIZE_FIELD("properties", m_properties);
    V8_CRDTP_SERIALIZE_FIELD("entries", m_entries);
V8_CRDTP_END_SERIALIZER();



const char* PropertyPreview::TypeEnum::Object = "object";
const char* PropertyPreview::TypeEnum::Function = "function";
const char* PropertyPreview::TypeEnum::Undefined = "undefined";
const char* PropertyPreview::TypeEnum::String = "string";
const char* PropertyPreview::TypeEnum::Number = "number";
const char* PropertyPreview::TypeEnum::Boolean = "boolean";
const char* PropertyPreview::TypeEnum::Symbol = "symbol";
const char* PropertyPreview::TypeEnum::Accessor = "accessor";
const char* PropertyPreview::TypeEnum::Bigint = "bigint";

const char* PropertyPreview::SubtypeEnum::Array = "array";
const char* PropertyPreview::SubtypeEnum::Null = "null";
const char* PropertyPreview::SubtypeEnum::Node = "node";
const char* PropertyPreview::SubtypeEnum::Regexp = "regexp";
const char* PropertyPreview::SubtypeEnum::Date = "date";
const char* PropertyPreview::SubtypeEnum::Map = "map";
const char* PropertyPreview::SubtypeEnum::Set = "set";
const char* PropertyPreview::SubtypeEnum::Weakmap = "weakmap";
const char* PropertyPreview::SubtypeEnum::Weakset = "weakset";
const char* PropertyPreview::SubtypeEnum::Iterator = "iterator";
const char* PropertyPreview::SubtypeEnum::Generator = "generator";
const char* PropertyPreview::SubtypeEnum::Error = "error";
const char* PropertyPreview::SubtypeEnum::Proxy = "proxy";
const char* PropertyPreview::SubtypeEnum::Promise = "promise";
const char* PropertyPreview::SubtypeEnum::Typedarray = "typedarray";
const char* PropertyPreview::SubtypeEnum::Arraybuffer = "arraybuffer";
const char* PropertyPreview::SubtypeEnum::Dataview = "dataview";
const char* PropertyPreview::SubtypeEnum::Webassemblymemory = "webassemblymemory";
const char* PropertyPreview::SubtypeEnum::Wasmvalue = "wasmvalue";
const char* PropertyPreview::SubtypeEnum::Trustedtype = "trustedtype";
V8_CRDTP_BEGIN_DESERIALIZER(PropertyPreview)
    V8_CRDTP_DESERIALIZE_FIELD("name", m_name),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("subtype", m_subtype),
    V8_CRDTP_DESERIALIZE_FIELD("type", m_type),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("value", m_value),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("valuePreview", m_valuePreview),
V8_CRDTP_END_DESERIALIZER()

V8_CRDTP_BEGIN_SERIALIZER(PropertyPreview)
    V8_CRDTP_SERIALIZE_FIELD("name", m_name);
    V8_CRDTP_SERIALIZE_FIELD("type", m_type);
    V8_CRDTP_SERIALIZE_FIELD("value", m_value);
    V8_CRDTP_SERIALIZE_FIELD("valuePreview", m_valuePreview);
    V8_CRDTP_SERIALIZE_FIELD("subtype", m_subtype);
V8_CRDTP_END_SERIALIZER();


V8_CRDTP_BEGIN_DESERIALIZER(EntryPreview)
    V8_CRDTP_DESERIALIZE_FIELD_OPT("key", m_key),
    V8_CRDTP_DESERIALIZE_FIELD("value", m_value),
V8_CRDTP_END_DESERIALIZER()

V8_CRDTP_BEGIN_SERIALIZER(EntryPreview)
    V8_CRDTP_SERIALIZE_FIELD("key", m_key);
    V8_CRDTP_SERIALIZE_FIELD("value", m_value);
V8_CRDTP_END_SERIALIZER();


V8_CRDTP_BEGIN_DESERIALIZER(PropertyDescriptor)
    V8_CRDTP_DESERIALIZE_FIELD("configurable", m_configurable),
    V8_CRDTP_DESERIALIZE_FIELD("enumerable", m_enumerable),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("get", m_get),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("isOwn", m_isOwn),
    V8_CRDTP_DESERIALIZE_FIELD("name", m_name),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("set", m_set),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("symbol", m_symbol),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("value", m_value),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("wasThrown", m_wasThrown),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("writable", m_writable),
V8_CRDTP_END_DESERIALIZER()

V8_CRDTP_BEGIN_SERIALIZER(PropertyDescriptor)
    V8_CRDTP_SERIALIZE_FIELD("name", m_name);
    V8_CRDTP_SERIALIZE_FIELD("value", m_value);
    V8_CRDTP_SERIALIZE_FIELD("writable", m_writable);
    V8_CRDTP_SERIALIZE_FIELD("get", m_get);
    V8_CRDTP_SERIALIZE_FIELD("set", m_set);
    V8_CRDTP_SERIALIZE_FIELD("configurable", m_configurable);
    V8_CRDTP_SERIALIZE_FIELD("enumerable", m_enumerable);
    V8_CRDTP_SERIALIZE_FIELD("wasThrown", m_wasThrown);
    V8_CRDTP_SERIALIZE_FIELD("isOwn", m_isOwn);
    V8_CRDTP_SERIALIZE_FIELD("symbol", m_symbol);
V8_CRDTP_END_SERIALIZER();


V8_CRDTP_BEGIN_DESERIALIZER(InternalPropertyDescriptor)
    V8_CRDTP_DESERIALIZE_FIELD("name", m_name),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("value", m_value),
V8_CRDTP_END_DESERIALIZER()

V8_CRDTP_BEGIN_SERIALIZER(InternalPropertyDescriptor)
    V8_CRDTP_SERIALIZE_FIELD("name", m_name);
    V8_CRDTP_SERIALIZE_FIELD("value", m_value);
V8_CRDTP_END_SERIALIZER();


V8_CRDTP_BEGIN_DESERIALIZER(PrivatePropertyDescriptor)
    V8_CRDTP_DESERIALIZE_FIELD_OPT("get", m_get),
    V8_CRDTP_DESERIALIZE_FIELD("name", m_name),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("set", m_set),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("value", m_value),
V8_CRDTP_END_DESERIALIZER()

V8_CRDTP_BEGIN_SERIALIZER(PrivatePropertyDescriptor)
    V8_CRDTP_SERIALIZE_FIELD("name", m_name);
    V8_CRDTP_SERIALIZE_FIELD("value", m_value);
    V8_CRDTP_SERIALIZE_FIELD("get", m_get);
    V8_CRDTP_SERIALIZE_FIELD("set", m_set);
V8_CRDTP_END_SERIALIZER();


V8_CRDTP_BEGIN_DESERIALIZER(CallArgument)
    V8_CRDTP_DESERIALIZE_FIELD_OPT("objectId", m_objectId),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("unserializableValue", m_unserializableValue),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("value", m_value),
V8_CRDTP_END_DESERIALIZER()

V8_CRDTP_BEGIN_SERIALIZER(CallArgument)
    V8_CRDTP_SERIALIZE_FIELD("value", m_value);
    V8_CRDTP_SERIALIZE_FIELD("unserializableValue", m_unserializableValue);
    V8_CRDTP_SERIALIZE_FIELD("objectId", m_objectId);
V8_CRDTP_END_SERIALIZER();



V8_CRDTP_BEGIN_DESERIALIZER(ExecutionContextDescription)
    V8_CRDTP_DESERIALIZE_FIELD_OPT("auxData", m_auxData),
    V8_CRDTP_DESERIALIZE_FIELD("id", m_id),
    V8_CRDTP_DESERIALIZE_FIELD("name", m_name),
    V8_CRDTP_DESERIALIZE_FIELD("origin", m_origin),
    V8_CRDTP_DESERIALIZE_FIELD("uniqueId", m_uniqueId),
V8_CRDTP_END_DESERIALIZER()

V8_CRDTP_BEGIN_SERIALIZER(ExecutionContextDescription)
    V8_CRDTP_SERIALIZE_FIELD("id", m_id);
    V8_CRDTP_SERIALIZE_FIELD("origin", m_origin);
    V8_CRDTP_SERIALIZE_FIELD("name", m_name);
    V8_CRDTP_SERIALIZE_FIELD("uniqueId", m_uniqueId);
    V8_CRDTP_SERIALIZE_FIELD("auxData", m_auxData);
V8_CRDTP_END_SERIALIZER();


V8_CRDTP_BEGIN_DESERIALIZER(ExceptionDetails)
    V8_CRDTP_DESERIALIZE_FIELD("columnNumber", m_columnNumber),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("exception", m_exception),
    V8_CRDTP_DESERIALIZE_FIELD("exceptionId", m_exceptionId),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("exceptionMetaData", m_exceptionMetaData),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("executionContextId", m_executionContextId),
    V8_CRDTP_DESERIALIZE_FIELD("lineNumber", m_lineNumber),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("scriptId", m_scriptId),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("stackTrace", m_stackTrace),
    V8_CRDTP_DESERIALIZE_FIELD("text", m_text),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("url", m_url),
V8_CRDTP_END_DESERIALIZER()

V8_CRDTP_BEGIN_SERIALIZER(ExceptionDetails)
    V8_CRDTP_SERIALIZE_FIELD("exceptionId", m_exceptionId);
    V8_CRDTP_SERIALIZE_FIELD("text", m_text);
    V8_CRDTP_SERIALIZE_FIELD("lineNumber", m_lineNumber);
    V8_CRDTP_SERIALIZE_FIELD("columnNumber", m_columnNumber);
    V8_CRDTP_SERIALIZE_FIELD("scriptId", m_scriptId);
    V8_CRDTP_SERIALIZE_FIELD("url", m_url);
    V8_CRDTP_SERIALIZE_FIELD("stackTrace", m_stackTrace);
    V8_CRDTP_SERIALIZE_FIELD("exception", m_exception);
    V8_CRDTP_SERIALIZE_FIELD("executionContextId", m_executionContextId);
    V8_CRDTP_SERIALIZE_FIELD("exceptionMetaData", m_exceptionMetaData);
V8_CRDTP_END_SERIALIZER();




V8_CRDTP_BEGIN_DESERIALIZER(CallFrame)
    V8_CRDTP_DESERIALIZE_FIELD("columnNumber", m_columnNumber),
    V8_CRDTP_DESERIALIZE_FIELD("functionName", m_functionName),
    V8_CRDTP_DESERIALIZE_FIELD("lineNumber", m_lineNumber),
    V8_CRDTP_DESERIALIZE_FIELD("scriptId", m_scriptId),
    V8_CRDTP_DESERIALIZE_FIELD("url", m_url),
V8_CRDTP_END_DESERIALIZER()

V8_CRDTP_BEGIN_SERIALIZER(CallFrame)
    V8_CRDTP_SERIALIZE_FIELD("functionName", m_functionName);
    V8_CRDTP_SERIALIZE_FIELD("scriptId", m_scriptId);
    V8_CRDTP_SERIALIZE_FIELD("url", m_url);
    V8_CRDTP_SERIALIZE_FIELD("lineNumber", m_lineNumber);
    V8_CRDTP_SERIALIZE_FIELD("columnNumber", m_columnNumber);
V8_CRDTP_END_SERIALIZER();


V8_CRDTP_BEGIN_DESERIALIZER(StackTrace)
    V8_CRDTP_DESERIALIZE_FIELD("callFrames", m_callFrames),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("description", m_description),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("parent", m_parent),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("parentId", m_parentId),
V8_CRDTP_END_DESERIALIZER()

V8_CRDTP_BEGIN_SERIALIZER(StackTrace)
    V8_CRDTP_SERIALIZE_FIELD("description", m_description);
    V8_CRDTP_SERIALIZE_FIELD("callFrames", m_callFrames);
    V8_CRDTP_SERIALIZE_FIELD("parent", m_parent);
    V8_CRDTP_SERIALIZE_FIELD("parentId", m_parentId);
V8_CRDTP_END_SERIALIZER();

// static
std::unique_ptr<API::StackTrace> API::StackTrace::fromBinary(const uint8_t* data, size_t length)
{
    return protocol::Runtime::StackTrace::FromBinary(data, length);
}


V8_CRDTP_BEGIN_DESERIALIZER(StackTraceId)
    V8_CRDTP_DESERIALIZE_FIELD_OPT("debuggerId", m_debuggerId),
    V8_CRDTP_DESERIALIZE_FIELD("id", m_id),
V8_CRDTP_END_DESERIALIZER()

V8_CRDTP_BEGIN_SERIALIZER(StackTraceId)
    V8_CRDTP_SERIALIZE_FIELD("id", m_id);
    V8_CRDTP_SERIALIZE_FIELD("debuggerId", m_debuggerId);
V8_CRDTP_END_SERIALIZER();

// static
std::unique_ptr<API::StackTraceId> API::StackTraceId::fromBinary(const uint8_t* data, size_t length)
{
    return protocol::Runtime::StackTraceId::FromBinary(data, length);
}

// ------------- Enum values from params.


namespace ConsoleAPICalled {
namespace TypeEnum {
const char* Log = "log";
const char* Debug = "debug";
const char* Info = "info";
const char* Error = "error";
const char* Warning = "warning";
const char* Dir = "dir";
const char* Dirxml = "dirxml";
const char* Table = "table";
const char* Trace = "trace";
const char* Clear = "clear";
const char* StartGroup = "startGroup";
const char* StartGroupCollapsed = "startGroupCollapsed";
const char* EndGroup = "endGroup";
const char* Assert = "assert";
const char* Profile = "profile";
const char* ProfileEnd = "profileEnd";
const char* Count = "count";
const char* TimeEnd = "timeEnd";
} // namespace TypeEnum
} // namespace ConsoleAPICalled

// ------------- Frontend notifications.

void Frontend::bindingCalled(const String& name, const String& payload, int executionContextId)
{
    if (!frontend_channel_)
        return;
    v8_crdtp::ObjectSerializer serializer;
    serializer.AddField(v8_crdtp::MakeSpan("name"), name);
    serializer.AddField(v8_crdtp::MakeSpan("payload"), payload);
    serializer.AddField(v8_crdtp::MakeSpan("executionContextId"), executionContextId);
    frontend_channel_->SendProtocolNotification(v8_crdtp::CreateNotification("Runtime.bindingCalled", serializer.Finish()));
}

void Frontend::consoleAPICalled(const String& type, std::unique_ptr<protocol::Array<protocol::Runtime::RemoteObject>> args, int executionContextId, double timestamp, std::unique_ptr<protocol::Runtime::StackTrace> stackTrace, std::optional<String> context)
{
    if (!frontend_channel_)
        return;
    v8_crdtp::ObjectSerializer serializer;
    serializer.AddField(v8_crdtp::MakeSpan("type"), type);
    serializer.AddField(v8_crdtp::MakeSpan("args"), args);
    serializer.AddField(v8_crdtp::MakeSpan("executionContextId"), executionContextId);
    serializer.AddField(v8_crdtp::MakeSpan("timestamp"), timestamp);
    serializer.AddField(v8_crdtp::MakeSpan("stackTrace"), stackTrace);
    serializer.AddField(v8_crdtp::MakeSpan("context"), context);
    frontend_channel_->SendProtocolNotification(v8_crdtp::CreateNotification("Runtime.consoleAPICalled", serializer.Finish()));
}

void Frontend::exceptionRevoked(const String& reason, int exceptionId)
{
    if (!frontend_channel_)
        return;
    v8_crdtp::ObjectSerializer serializer;
    serializer.AddField(v8_crdtp::MakeSpan("reason"), reason);
    serializer.AddField(v8_crdtp::MakeSpan("exceptionId"), exceptionId);
    frontend_channel_->SendProtocolNotification(v8_crdtp::CreateNotification("Runtime.exceptionRevoked", serializer.Finish()));
}

void Frontend::exceptionThrown(double timestamp, std::unique_ptr<protocol::Runtime::ExceptionDetails> exceptionDetails)
{
    if (!frontend_channel_)
        return;
    v8_crdtp::ObjectSerializer serializer;
    serializer.AddField(v8_crdtp::MakeSpan("timestamp"), timestamp);
    serializer.AddField(v8_crdtp::MakeSpan("exceptionDetails"), exceptionDetails);
    frontend_channel_->SendProtocolNotification(v8_crdtp::CreateNotification("Runtime.exceptionThrown", serializer.Finish()));
}

void Frontend::executionContextCreated(std::unique_ptr<protocol::Runtime::ExecutionContextDescription> context)
{
    if (!frontend_channel_)
        return;
    v8_crdtp::ObjectSerializer serializer;
    serializer.AddField(v8_crdtp::MakeSpan("context"), context);
    frontend_channel_->SendProtocolNotification(v8_crdtp::CreateNotification("Runtime.executionContextCreated", serializer.Finish()));
}

void Frontend::executionContextDestroyed(int executionContextId, const String& executionContextUniqueId)
{
    if (!frontend_channel_)
        return;
    v8_crdtp::ObjectSerializer serializer;
    serializer.AddField(v8_crdtp::MakeSpan("executionContextId"), executionContextId);
    serializer.AddField(v8_crdtp::MakeSpan("executionContextUniqueId"), executionContextUniqueId);
    frontend_channel_->SendProtocolNotification(v8_crdtp::CreateNotification("Runtime.executionContextDestroyed", serializer.Finish()));
}

void Frontend::executionContextsCleared()
{
    if (!frontend_channel_)
        return;
    frontend_channel_->SendProtocolNotification(v8_crdtp::CreateNotification("Runtime.executionContextsCleared"));
}

void Frontend::inspectRequested(std::unique_ptr<protocol::Runtime::RemoteObject> object, std::unique_ptr<protocol::DictionaryValue> hints, std::optional<int> executionContextId)
{
    if (!frontend_channel_)
        return;
    v8_crdtp::ObjectSerializer serializer;
    serializer.AddField(v8_crdtp::MakeSpan("object"), object);
    serializer.AddField(v8_crdtp::MakeSpan("hints"), hints);
    serializer.AddField(v8_crdtp::MakeSpan("executionContextId"), executionContextId);
    frontend_channel_->SendProtocolNotification(v8_crdtp::CreateNotification("Runtime.inspectRequested", serializer.Finish()));
}

void Frontend::flush()
{
    frontend_channel_->FlushProtocolNotifications();
}

void Frontend::sendRawNotification(std::unique_ptr<Serializable> notification)
{
    frontend_channel_->SendProtocolNotification(std::move(notification));
}

// --------------------- Dispatcher.

class DomainDispatcherImpl : public protocol::DomainDispatcher {
public:
    DomainDispatcherImpl(FrontendChannel* frontendChannel, Backend* backend)
        : DomainDispatcher(frontendChannel)
        , m_backend(backend) {}
    ~DomainDispatcherImpl() override { }

    using CallHandler = void (DomainDispatcherImpl::*)(const v8_crdtp::Dispatchable& dispatchable);

    std::function<void(const v8_crdtp::Dispatchable&)> Dispatch(v8_crdtp::span<uint8_t> command_name) override;

    void awaitPromise(const v8_crdtp::Dispatchable& dispatchable);
    void callFunctionOn(const v8_crdtp::Dispatchable& dispatchable);
    void compileScript(const v8_crdtp::Dispatchable& dispatchable);
    void disable(const v8_crdtp::Dispatchable& dispatchable);
    void discardConsoleEntries(const v8_crdtp::Dispatchable& dispatchable);
    void enable(const v8_crdtp::Dispatchable& dispatchable);
    void evaluate(const v8_crdtp::Dispatchable& dispatchable);
    void getIsolateId(const v8_crdtp::Dispatchable& dispatchable);
    void getHeapUsage(const v8_crdtp::Dispatchable& dispatchable);
    void getProperties(const v8_crdtp::Dispatchable& dispatchable);
    void globalLexicalScopeNames(const v8_crdtp::Dispatchable& dispatchable);
    void queryObjects(const v8_crdtp::Dispatchable& dispatchable);
    void releaseObject(const v8_crdtp::Dispatchable& dispatchable);
    void releaseObjectGroup(const v8_crdtp::Dispatchable& dispatchable);
    void runIfWaitingForDebugger(const v8_crdtp::Dispatchable& dispatchable);
    void runScript(const v8_crdtp::Dispatchable& dispatchable);
    void setCustomObjectFormatterEnabled(const v8_crdtp::Dispatchable& dispatchable);
    void setMaxCallStackSizeToCapture(const v8_crdtp::Dispatchable& dispatchable);
    void terminateExecution(const v8_crdtp::Dispatchable& dispatchable);
    void addBinding(const v8_crdtp::Dispatchable& dispatchable);
    void removeBinding(const v8_crdtp::Dispatchable& dispatchable);
    void getExceptionDetails(const v8_crdtp::Dispatchable& dispatchable);
 protected:
    Backend* m_backend;
};

namespace {
// This helper method with a static map of command methods (instance methods
// of DomainDispatcherImpl declared just above) by their name is used immediately below,
// in the DomainDispatcherImpl::Dispatch method.
DomainDispatcherImpl::CallHandler CommandByName(v8_crdtp::span<uint8_t> command_name) {
  static auto* commands = [](){
    auto* commands = new std::vector<std::pair<v8_crdtp::span<uint8_t>,
                              DomainDispatcherImpl::CallHandler>>{
    {
          v8_crdtp::SpanFrom("addBinding"),
          &DomainDispatcherImpl::addBinding
    },
    {
          v8_crdtp::SpanFrom("awaitPromise"),
          &DomainDispatcherImpl::awaitPromise
    },
    {
          v8_crdtp::SpanFrom("callFunctionOn"),
          &DomainDispatcherImpl::callFunctionOn
    },
    {
          v8_crdtp::SpanFrom("compileScript"),
          &DomainDispatcherImpl::compileScript
    },
    {
          v8_crdtp::SpanFrom("disable"),
          &DomainDispatcherImpl::disable
    },
    {
          v8_crdtp::SpanFrom("discardConsoleEntries"),
          &DomainDispatcherImpl::discardConsoleEntries
    },
    {
          v8_crdtp::SpanFrom("enable"),
          &DomainDispatcherImpl::enable
    },
    {
          v8_crdtp::SpanFrom("evaluate"),
          &DomainDispatcherImpl::evaluate
    },
    {
          v8_crdtp::SpanFrom("getExceptionDetails"),
          &DomainDispatcherImpl::getExceptionDetails
    },
    {
          v8_crdtp::SpanFrom("getHeapUsage"),
          &DomainDispatcherImpl::getHeapUsage
    },
    {
          v8_crdtp::SpanFrom("getIsolateId"),
          &DomainDispatcherImpl::getIsolateId
    },
    {
          v8_crdtp::SpanFrom("getProperties"),
          &DomainDispatcherImpl::getProperties
    },
    {
          v8_crdtp::SpanFrom("globalLexicalScopeNames"),
          &DomainDispatcherImpl::globalLexicalScopeNames
    },
    {
          v8_crdtp::SpanFrom("queryObjects"),
          &DomainDispatcherImpl::queryObjects
    },
    {
          v8_crdtp::SpanFrom("releaseObject"),
          &DomainDispatcherImpl::releaseObject
    },
    {
          v8_crdtp::SpanFrom("releaseObjectGroup"),
          &DomainDispatcherImpl::releaseObjectGroup
    },
    {
          v8_crdtp::SpanFrom("removeBinding"),
          &DomainDispatcherImpl::removeBinding
    },
    {
          v8_crdtp::SpanFrom("runIfWaitingForDebugger"),
          &DomainDispatcherImpl::runIfWaitingForDebugger
    },
    {
          v8_crdtp::SpanFrom("runScript"),
          &DomainDispatcherImpl::runScript
    },
    {
          v8_crdtp::SpanFrom("setCustomObjectFormatterEnabled"),
          &DomainDispatcherImpl::setCustomObjectFormatterEnabled
    },
    {
          v8_crdtp::SpanFrom("setMaxCallStackSizeToCapture"),
          &DomainDispatcherImpl::setMaxCallStackSizeToCapture
    },
    {
          v8_crdtp::SpanFrom("terminateExecution"),
          &DomainDispatcherImpl::terminateExecution
    },
    };
    return commands;
  }();
  return v8_crdtp::FindByFirst<DomainDispatcherImpl::CallHandler>(*commands, command_name, nullptr);
}
}  // namespace

std::function<void(const v8_crdtp::Dispatchable&)> DomainDispatcherImpl::Dispatch(v8_crdtp::span<uint8_t> command_name) {
  CallHandler handler = CommandByName(command_name);
  if (!handler) return nullptr;

  return [this, handler](const v8_crdtp::Dispatchable& dispatchable) {
    (this->*handler)(dispatchable);
  };
}


class AwaitPromiseCallbackImpl : public Backend::AwaitPromiseCallback, public DomainDispatcher::Callback {
public:
    AwaitPromiseCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, v8_crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
v8_crdtp::SpanFrom("Runtime.awaitPromise"), message) { }

    void sendSuccess(std::unique_ptr<protocol::Runtime::RemoteObject> result, std::unique_ptr<protocol::Runtime::ExceptionDetails> exceptionDetails) override
    {
        v8_crdtp::ObjectSerializer serializer;
        serializer.AddField(v8_crdtp::MakeSpan("result"), result);
        serializer.AddField(v8_crdtp::MakeSpan("exceptionDetails"), exceptionDetails);
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {

struct awaitPromiseParams : public v8_crdtp::DeserializableProtocolObject<awaitPromiseParams> {
    String promiseObjectId;
    std::optional<bool> returnByValue;
    std::optional<bool> generatePreview;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(awaitPromiseParams)
    V8_CRDTP_DESERIALIZE_FIELD_OPT("generatePreview", generatePreview),
    V8_CRDTP_DESERIALIZE_FIELD("promiseObjectId", promiseObjectId),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("returnByValue", returnByValue),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::awaitPromise(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    awaitPromiseParams params;
    if (!awaitPromiseParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    m_backend->awaitPromise(params.promiseObjectId, std::move(params.returnByValue), std::move(params.generatePreview), std::make_unique<AwaitPromiseCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

class CallFunctionOnCallbackImpl : public Backend::CallFunctionOnCallback, public DomainDispatcher::Callback {
public:
    CallFunctionOnCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, v8_crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
v8_crdtp::SpanFrom("Runtime.callFunctionOn"), message) { }

    void sendSuccess(std::unique_ptr<protocol::Runtime::RemoteObject> result, std::unique_ptr<protocol::Runtime::ExceptionDetails> exceptionDetails) override
    {
        v8_crdtp::ObjectSerializer serializer;
        serializer.AddField(v8_crdtp::MakeSpan("result"), result);
        serializer.AddField(v8_crdtp::MakeSpan("exceptionDetails"), exceptionDetails);
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {

struct callFunctionOnParams : public v8_crdtp::DeserializableProtocolObject<callFunctionOnParams> {
    String functionDeclaration;
    std::optional<String> objectId;
    std::unique_ptr<protocol::Array<protocol::Runtime::CallArgument>> arguments;
    std::optional<bool> silent;
    std::optional<bool> returnByValue;
    std::optional<bool> generatePreview;
    std::optional<bool> userGesture;
    std::optional<bool> awaitPromise;
    std::optional<int> executionContextId;
    std::optional<String> objectGroup;
    std::optional<bool> throwOnSideEffect;
    std::optional<String> uniqueContextId;
    std::unique_ptr<protocol::Runtime::SerializationOptions> serializationOptions;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(callFunctionOnParams)
    V8_CRDTP_DESERIALIZE_FIELD_OPT("arguments", arguments),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("awaitPromise", awaitPromise),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("executionContextId", executionContextId),
    V8_CRDTP_DESERIALIZE_FIELD("functionDeclaration", functionDeclaration),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("generatePreview", generatePreview),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("objectGroup", objectGroup),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("objectId", objectId),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("returnByValue", returnByValue),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("serializationOptions", serializationOptions),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("silent", silent),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("throwOnSideEffect", throwOnSideEffect),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("uniqueContextId", uniqueContextId),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("userGesture", userGesture),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::callFunctionOn(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    callFunctionOnParams params;
    if (!callFunctionOnParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    m_backend->callFunctionOn(params.functionDeclaration, std::move(params.objectId), std::move(params.arguments), std::move(params.silent), std::move(params.returnByValue), std::move(params.generatePreview), std::move(params.userGesture), std::move(params.awaitPromise), std::move(params.executionContextId), std::move(params.objectGroup), std::move(params.throwOnSideEffect), std::move(params.uniqueContextId), std::move(params.serializationOptions), std::make_unique<CallFunctionOnCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

namespace {

struct compileScriptParams : public v8_crdtp::DeserializableProtocolObject<compileScriptParams> {
    String expression;
    String sourceURL;
    bool persistScript;
    std::optional<int> executionContextId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(compileScriptParams)
    V8_CRDTP_DESERIALIZE_FIELD_OPT("executionContextId", executionContextId),
    V8_CRDTP_DESERIALIZE_FIELD("expression", expression),
    V8_CRDTP_DESERIALIZE_FIELD("persistScript", persistScript),
    V8_CRDTP_DESERIALIZE_FIELD("sourceURL", sourceURL),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::compileScript(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    compileScriptParams params;
    if (!compileScriptParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::optional<String> out_scriptId;
    std::unique_ptr<protocol::Runtime::ExceptionDetails> out_exceptionDetails;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->compileScript(params.expression, params.sourceURL, params.persistScript, std::move(params.executionContextId), &out_scriptId, &out_exceptionDetails);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Runtime.compileScript"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<v8_crdtp::Serializable> result;
        if (response.IsSuccess()) {
          v8_crdtp::ObjectSerializer serializer;
          serializer.AddField(v8_crdtp::MakeSpan("scriptId"), out_scriptId);
          serializer.AddField(v8_crdtp::MakeSpan("exceptionDetails"), out_exceptionDetails);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::disable(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->disable();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Runtime.disable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::discardConsoleEntries(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->discardConsoleEntries();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Runtime.discardConsoleEntries"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::enable(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->enable();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Runtime.enable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

class EvaluateCallbackImpl : public Backend::EvaluateCallback, public DomainDispatcher::Callback {
public:
    EvaluateCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, v8_crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
v8_crdtp::SpanFrom("Runtime.evaluate"), message) { }

    void sendSuccess(std::unique_ptr<protocol::Runtime::RemoteObject> result, std::unique_ptr<protocol::Runtime::ExceptionDetails> exceptionDetails) override
    {
        v8_crdtp::ObjectSerializer serializer;
        serializer.AddField(v8_crdtp::MakeSpan("result"), result);
        serializer.AddField(v8_crdtp::MakeSpan("exceptionDetails"), exceptionDetails);
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {

struct evaluateParams : public v8_crdtp::DeserializableProtocolObject<evaluateParams> {
    String expression;
    std::optional<String> objectGroup;
    std::optional<bool> includeCommandLineAPI;
    std::optional<bool> silent;
    std::optional<int> contextId;
    std::optional<bool> returnByValue;
    std::optional<bool> generatePreview;
    std::optional<bool> userGesture;
    std::optional<bool> awaitPromise;
    std::optional<bool> throwOnSideEffect;
    std::optional<double> timeout;
    std::optional<bool> disableBreaks;
    std::optional<bool> replMode;
    std::optional<bool> allowUnsafeEvalBlockedByCSP;
    std::optional<String> uniqueContextId;
    std::unique_ptr<protocol::Runtime::SerializationOptions> serializationOptions;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(evaluateParams)
    V8_CRDTP_DESERIALIZE_FIELD_OPT("allowUnsafeEvalBlockedByCSP", allowUnsafeEvalBlockedByCSP),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("awaitPromise", awaitPromise),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("contextId", contextId),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("disableBreaks", disableBreaks),
    V8_CRDTP_DESERIALIZE_FIELD("expression", expression),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("generatePreview", generatePreview),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("includeCommandLineAPI", includeCommandLineAPI),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("objectGroup", objectGroup),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("replMode", replMode),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("returnByValue", returnByValue),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("serializationOptions", serializationOptions),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("silent", silent),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("throwOnSideEffect", throwOnSideEffect),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("timeout", timeout),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("uniqueContextId", uniqueContextId),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("userGesture", userGesture),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::evaluate(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    evaluateParams params;
    if (!evaluateParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    m_backend->evaluate(params.expression, std::move(params.objectGroup), std::move(params.includeCommandLineAPI), std::move(params.silent), std::move(params.contextId), std::move(params.returnByValue), std::move(params.generatePreview), std::move(params.userGesture), std::move(params.awaitPromise), std::move(params.throwOnSideEffect), std::move(params.timeout), std::move(params.disableBreaks), std::move(params.replMode), std::move(params.allowUnsafeEvalBlockedByCSP), std::move(params.uniqueContextId), std::move(params.serializationOptions), std::make_unique<EvaluateCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

namespace {


}  // namespace

void DomainDispatcherImpl::getIsolateId(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    // Declare output parameters.
    String out_id;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getIsolateId(&out_id);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Runtime.getIsolateId"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<v8_crdtp::Serializable> result;
        if (response.IsSuccess()) {
          v8_crdtp::ObjectSerializer serializer;
          serializer.AddField(v8_crdtp::MakeSpan("id"), out_id);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::getHeapUsage(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    // Declare output parameters.
    double out_usedSize;
    double out_totalSize;
    double out_embedderHeapUsedSize;
    double out_backingStorageSize;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getHeapUsage(&out_usedSize, &out_totalSize, &out_embedderHeapUsedSize, &out_backingStorageSize);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Runtime.getHeapUsage"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<v8_crdtp::Serializable> result;
        if (response.IsSuccess()) {
          v8_crdtp::ObjectSerializer serializer;
          serializer.AddField(v8_crdtp::MakeSpan("usedSize"), out_usedSize);
          serializer.AddField(v8_crdtp::MakeSpan("totalSize"), out_totalSize);
          serializer.AddField(v8_crdtp::MakeSpan("embedderHeapUsedSize"), out_embedderHeapUsedSize);
          serializer.AddField(v8_crdtp::MakeSpan("backingStorageSize"), out_backingStorageSize);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct getPropertiesParams : public v8_crdtp::DeserializableProtocolObject<getPropertiesParams> {
    String objectId;
    std::optional<bool> ownProperties;
    std::optional<bool> accessorPropertiesOnly;
    std::optional<bool> generatePreview;
    std::optional<bool> nonIndexedPropertiesOnly;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(getPropertiesParams)
    V8_CRDTP_DESERIALIZE_FIELD_OPT("accessorPropertiesOnly", accessorPropertiesOnly),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("generatePreview", generatePreview),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("nonIndexedPropertiesOnly", nonIndexedPropertiesOnly),
    V8_CRDTP_DESERIALIZE_FIELD("objectId", objectId),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("ownProperties", ownProperties),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getProperties(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getPropertiesParams params;
    if (!getPropertiesParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::Array<protocol::Runtime::PropertyDescriptor>> out_result;
    std::unique_ptr<protocol::Array<protocol::Runtime::InternalPropertyDescriptor>> out_internalProperties;
    std::unique_ptr<protocol::Array<protocol::Runtime::PrivatePropertyDescriptor>> out_privateProperties;
    std::unique_ptr<protocol::Runtime::ExceptionDetails> out_exceptionDetails;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getProperties(params.objectId, std::move(params.ownProperties), std::move(params.accessorPropertiesOnly), std::move(params.generatePreview), std::move(params.nonIndexedPropertiesOnly), &out_result, &out_internalProperties, &out_privateProperties, &out_exceptionDetails);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Runtime.getProperties"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<v8_crdtp::Serializable> result;
        if (response.IsSuccess()) {
          v8_crdtp::ObjectSerializer serializer;
          serializer.AddField(v8_crdtp::MakeSpan("result"), out_result);
          serializer.AddField(v8_crdtp::MakeSpan("internalProperties"), out_internalProperties);
          serializer.AddField(v8_crdtp::MakeSpan("privateProperties"), out_privateProperties);
          serializer.AddField(v8_crdtp::MakeSpan("exceptionDetails"), out_exceptionDetails);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct globalLexicalScopeNamesParams : public v8_crdtp::DeserializableProtocolObject<globalLexicalScopeNamesParams> {
    std::optional<int> executionContextId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(globalLexicalScopeNamesParams)
    V8_CRDTP_DESERIALIZE_FIELD_OPT("executionContextId", executionContextId),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::globalLexicalScopeNames(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    globalLexicalScopeNamesParams params;
    if (!globalLexicalScopeNamesParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::Array<String>> out_names;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->globalLexicalScopeNames(std::move(params.executionContextId), &out_names);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Runtime.globalLexicalScopeNames"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<v8_crdtp::Serializable> result;
        if (response.IsSuccess()) {
          v8_crdtp::ObjectSerializer serializer;
          serializer.AddField(v8_crdtp::MakeSpan("names"), out_names);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct queryObjectsParams : public v8_crdtp::DeserializableProtocolObject<queryObjectsParams> {
    String prototypeObjectId;
    std::optional<String> objectGroup;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(queryObjectsParams)
    V8_CRDTP_DESERIALIZE_FIELD_OPT("objectGroup", objectGroup),
    V8_CRDTP_DESERIALIZE_FIELD("prototypeObjectId", prototypeObjectId),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::queryObjects(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    queryObjectsParams params;
    if (!queryObjectsParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::Runtime::RemoteObject> out_objects;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->queryObjects(params.prototypeObjectId, std::move(params.objectGroup), &out_objects);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Runtime.queryObjects"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<v8_crdtp::Serializable> result;
        if (response.IsSuccess()) {
          v8_crdtp::ObjectSerializer serializer;
          serializer.AddField(v8_crdtp::MakeSpan("objects"), out_objects);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct releaseObjectParams : public v8_crdtp::DeserializableProtocolObject<releaseObjectParams> {
    String objectId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(releaseObjectParams)
    V8_CRDTP_DESERIALIZE_FIELD("objectId", objectId),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::releaseObject(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    releaseObjectParams params;
    if (!releaseObjectParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->releaseObject(params.objectId);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Runtime.releaseObject"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct releaseObjectGroupParams : public v8_crdtp::DeserializableProtocolObject<releaseObjectGroupParams> {
    String objectGroup;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(releaseObjectGroupParams)
    V8_CRDTP_DESERIALIZE_FIELD("objectGroup", objectGroup),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::releaseObjectGroup(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    releaseObjectGroupParams params;
    if (!releaseObjectGroupParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->releaseObjectGroup(params.objectGroup);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Runtime.releaseObjectGroup"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::runIfWaitingForDebugger(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->runIfWaitingForDebugger();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Runtime.runIfWaitingForDebugger"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

class RunScriptCallbackImpl : public Backend::RunScriptCallback, public DomainDispatcher::Callback {
public:
    RunScriptCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, v8_crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
v8_crdtp::SpanFrom("Runtime.runScript"), message) { }

    void sendSuccess(std::unique_ptr<protocol::Runtime::RemoteObject> result, std::unique_ptr<protocol::Runtime::ExceptionDetails> exceptionDetails) override
    {
        v8_crdtp::ObjectSerializer serializer;
        serializer.AddField(v8_crdtp::MakeSpan("result"), result);
        serializer.AddField(v8_crdtp::MakeSpan("exceptionDetails"), exceptionDetails);
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {

struct runScriptParams : public v8_crdtp::DeserializableProtocolObject<runScriptParams> {
    String scriptId;
    std::optional<int> executionContextId;
    std::optional<String> objectGroup;
    std::optional<bool> silent;
    std::optional<bool> includeCommandLineAPI;
    std::optional<bool> returnByValue;
    std::optional<bool> generatePreview;
    std::optional<bool> awaitPromise;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(runScriptParams)
    V8_CRDTP_DESERIALIZE_FIELD_OPT("awaitPromise", awaitPromise),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("executionContextId", executionContextId),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("generatePreview", generatePreview),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("includeCommandLineAPI", includeCommandLineAPI),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("objectGroup", objectGroup),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("returnByValue", returnByValue),
    V8_CRDTP_DESERIALIZE_FIELD("scriptId", scriptId),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("silent", silent),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::runScript(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    runScriptParams params;
    if (!runScriptParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    m_backend->runScript(params.scriptId, std::move(params.executionContextId), std::move(params.objectGroup), std::move(params.silent), std::move(params.includeCommandLineAPI), std::move(params.returnByValue), std::move(params.generatePreview), std::move(params.awaitPromise), std::make_unique<RunScriptCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

namespace {

struct setCustomObjectFormatterEnabledParams : public v8_crdtp::DeserializableProtocolObject<setCustomObjectFormatterEnabledParams> {
    bool enabled;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(setCustomObjectFormatterEnabledParams)
    V8_CRDTP_DESERIALIZE_FIELD("enabled", enabled),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setCustomObjectFormatterEnabled(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setCustomObjectFormatterEnabledParams params;
    if (!setCustomObjectFormatterEnabledParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setCustomObjectFormatterEnabled(params.enabled);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Runtime.setCustomObjectFormatterEnabled"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setMaxCallStackSizeToCaptureParams : public v8_crdtp::DeserializableProtocolObject<setMaxCallStackSizeToCaptureParams> {
    int size;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(setMaxCallStackSizeToCaptureParams)
    V8_CRDTP_DESERIALIZE_FIELD("size", size),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setMaxCallStackSizeToCapture(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setMaxCallStackSizeToCaptureParams params;
    if (!setMaxCallStackSizeToCaptureParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setMaxCallStackSizeToCapture(params.size);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Runtime.setMaxCallStackSizeToCapture"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

class TerminateExecutionCallbackImpl : public Backend::TerminateExecutionCallback, public DomainDispatcher::Callback {
public:
    TerminateExecutionCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, v8_crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
v8_crdtp::SpanFrom("Runtime.terminateExecution"), message) { }

    void sendSuccess() override
    {
        v8_crdtp::ObjectSerializer serializer;
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {


}  // namespace

void DomainDispatcherImpl::terminateExecution(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    m_backend->terminateExecution(std::make_unique<TerminateExecutionCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

namespace {

struct addBindingParams : public v8_crdtp::DeserializableProtocolObject<addBindingParams> {
    String name;
    std::optional<int> executionContextId;
    std::optional<String> executionContextName;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(addBindingParams)
    V8_CRDTP_DESERIALIZE_FIELD_OPT("executionContextId", executionContextId),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("executionContextName", executionContextName),
    V8_CRDTP_DESERIALIZE_FIELD("name", name),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::addBinding(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    addBindingParams params;
    if (!addBindingParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->addBinding(params.name, std::move(params.executionContextId), std::move(params.executionContextName));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Runtime.addBinding"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct removeBindingParams : public v8_crdtp::DeserializableProtocolObject<removeBindingParams> {
    String name;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(removeBindingParams)
    V8_CRDTP_DESERIALIZE_FIELD("name", name),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::removeBinding(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    removeBindingParams params;
    if (!removeBindingParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->removeBinding(params.name);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Runtime.removeBinding"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct getExceptionDetailsParams : public v8_crdtp::DeserializableProtocolObject<getExceptionDetailsParams> {
    String errorObjectId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(getExceptionDetailsParams)
    V8_CRDTP_DESERIALIZE_FIELD("errorObjectId", errorObjectId),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getExceptionDetails(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getExceptionDetailsParams params;
    if (!getExceptionDetailsParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::Runtime::ExceptionDetails> out_exceptionDetails;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getExceptionDetails(params.errorObjectId, &out_exceptionDetails);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Runtime.getExceptionDetails"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<v8_crdtp::Serializable> result;
        if (response.IsSuccess()) {
          v8_crdtp::ObjectSerializer serializer;
          serializer.AddField(v8_crdtp::MakeSpan("exceptionDetails"), out_exceptionDetails);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {
// This helper method (with a static map of redirects) is used from Dispatcher::wire
// immediately below.
const std::vector<std::pair<v8_crdtp::span<uint8_t>, v8_crdtp::span<uint8_t>>>& SortedRedirects() {
  static auto* redirects = [](){
    auto* redirects = new std::vector<std::pair<v8_crdtp::span<uint8_t>, v8_crdtp::span<uint8_t>>>{
          { v8_crdtp::SpanFrom("Runtime.setAsyncCallStackDepth"), v8_crdtp::SpanFrom("Debugger.setAsyncCallStackDepth") },
    };
    return redirects;
  }();
  return *redirects;
}
}  // namespace

// static
void Dispatcher::wire(UberDispatcher* uber, Backend* backend)
{
    auto dispatcher = std::make_unique<DomainDispatcherImpl>(uber->channel(), backend);
    uber->WireBackend(v8_crdtp::SpanFrom("Runtime"), SortedRedirects(), std::move(dispatcher));
}

} // Runtime
} // namespace v8_inspector
} // namespace protocol
