// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef v8_inspector_protocol_Profiler_h
#define v8_inspector_protocol_Profiler_h

#include "src/inspector/protocol/Protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.
#include "src/inspector/protocol/Runtime.h"
#include "src/inspector/protocol/Debugger.h"

namespace v8_inspector {
namespace protocol {
namespace Profiler {
class ProfileNode;
class Profile;
class PositionTickInfo;
class CoverageRange;
class FunctionCoverage;
class ScriptCoverage;

// ------------- Forward and enum declarations.

// ------------- Type and builder declarations.

class  ProfileNode : public ::v8_crdtp::ProtocolObject<ProfileNode> {
public:
    ~ProfileNode() override;  // Defined below

    int getId() { return m_id; }
    void setId(int value);  // Defined below

    protocol::Runtime::CallFrame* getCallFrame() { return m_callFrame.get(); }
    void setCallFrame(std::unique_ptr<protocol::Runtime::CallFrame> value);  // Defined below

    bool hasHitCount() { return !!m_hitCount; }
    int getHitCount(int defaultValue) const {
       return m_hitCount.value_or(defaultValue);
    }
    const std::optional<int>& getHitCount() const {
       return m_hitCount;
    }
    void setHitCount(int value);  // Defined below

    bool hasChildren() { return !!m_children; }
    protocol::Array<int>* getChildren(protocol::Array<int>* defaultValue) {
       return m_children ? m_children.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<int>>& getChildren() const {
       return m_children;
    }
    void setChildren(std::unique_ptr<protocol::Array<int>> value);  // Defined below

    bool hasDeoptReason() { return !!m_deoptReason; }
    String getDeoptReason(const String& defaultValue) const {
       return m_deoptReason.value_or(defaultValue);
    }
    const std::optional<String>& getDeoptReason() const {
       return m_deoptReason;
    }
    void setDeoptReason(const String& value);  // Defined below

    bool hasPositionTicks() { return !!m_positionTicks; }
    protocol::Array<protocol::Profiler::PositionTickInfo>* getPositionTicks(protocol::Array<protocol::Profiler::PositionTickInfo>* defaultValue) {
       return m_positionTicks ? m_positionTicks.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::Profiler::PositionTickInfo>>& getPositionTicks() const {
       return m_positionTicks;
    }
    void setPositionTicks(std::unique_ptr<protocol::Array<protocol::Profiler::PositionTickInfo>> value);  // Defined below

    template<int STATE>
    class ProfileNodeBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            IdSet = 1 << 1,
            CallFrameSet = 1 << 2,
            AllFieldsSet = (IdSet | CallFrameSet | 0)};


        ProfileNodeBuilder<STATE | IdSet>& setId(int value);  // Defined below

        ProfileNodeBuilder<STATE | CallFrameSet>& setCallFrame(std::unique_ptr<protocol::Runtime::CallFrame> value);  // Defined below

        ProfileNodeBuilder<STATE>& setHitCount(int value);  // Defined below

        ProfileNodeBuilder<STATE>& setChildren(std::unique_ptr<protocol::Array<int>> value);  // Defined below

        ProfileNodeBuilder<STATE>& setDeoptReason(const String& value);  // Defined below

        ProfileNodeBuilder<STATE>& setPositionTicks(std::unique_ptr<protocol::Array<protocol::Profiler::PositionTickInfo>> value);  // Defined below

        std::unique_ptr<ProfileNode> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ProfileNode;
        ProfileNodeBuilder() : m_result(new ProfileNode()) { }

        template<int STEP> ProfileNodeBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ProfileNodeBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Profiler::ProfileNode> m_result;
    };

    static ProfileNodeBuilder<0> create()
    {
        return ProfileNodeBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ProfileNode();  // Defined below

    int m_id;
    std::unique_ptr<protocol::Runtime::CallFrame> m_callFrame;
    std::optional<int> m_hitCount;
    std::unique_ptr<protocol::Array<int>> m_children;
    std::optional<String> m_deoptReason;
    std::unique_ptr<protocol::Array<protocol::Profiler::PositionTickInfo>> m_positionTicks;
};


class  Profile : public ::v8_crdtp::ProtocolObject<Profile> {
public:
    ~Profile() override;  // Defined below

    protocol::Array<protocol::Profiler::ProfileNode>* getNodes() { return m_nodes.get(); }
    void setNodes(std::unique_ptr<protocol::Array<protocol::Profiler::ProfileNode>> value);  // Defined below

    double getStartTime() { return m_startTime; }
    void setStartTime(double value);  // Defined below

    double getEndTime() { return m_endTime; }
    void setEndTime(double value);  // Defined below

    bool hasSamples() { return !!m_samples; }
    protocol::Array<int>* getSamples(protocol::Array<int>* defaultValue) {
       return m_samples ? m_samples.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<int>>& getSamples() const {
       return m_samples;
    }
    void setSamples(std::unique_ptr<protocol::Array<int>> value);  // Defined below

    bool hasTimeDeltas() { return !!m_timeDeltas; }
    protocol::Array<int>* getTimeDeltas(protocol::Array<int>* defaultValue) {
       return m_timeDeltas ? m_timeDeltas.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<int>>& getTimeDeltas() const {
       return m_timeDeltas;
    }
    void setTimeDeltas(std::unique_ptr<protocol::Array<int>> value);  // Defined below

    template<int STATE>
    class ProfileBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NodesSet = 1 << 1,
            StartTimeSet = 1 << 2,
            EndTimeSet = 1 << 3,
            AllFieldsSet = (NodesSet | StartTimeSet | EndTimeSet | 0)};


        ProfileBuilder<STATE | NodesSet>& setNodes(std::unique_ptr<protocol::Array<protocol::Profiler::ProfileNode>> value);  // Defined below

        ProfileBuilder<STATE | StartTimeSet>& setStartTime(double value);  // Defined below

        ProfileBuilder<STATE | EndTimeSet>& setEndTime(double value);  // Defined below

        ProfileBuilder<STATE>& setSamples(std::unique_ptr<protocol::Array<int>> value);  // Defined below

        ProfileBuilder<STATE>& setTimeDeltas(std::unique_ptr<protocol::Array<int>> value);  // Defined below

        std::unique_ptr<Profile> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class Profile;
        ProfileBuilder() : m_result(new Profile()) { }

        template<int STEP> ProfileBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ProfileBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Profiler::Profile> m_result;
    };

    static ProfileBuilder<0> create()
    {
        return ProfileBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    Profile();  // Defined below

    std::unique_ptr<protocol::Array<protocol::Profiler::ProfileNode>> m_nodes;
    double m_startTime;
    double m_endTime;
    std::unique_ptr<protocol::Array<int>> m_samples;
    std::unique_ptr<protocol::Array<int>> m_timeDeltas;
};


class  PositionTickInfo : public ::v8_crdtp::ProtocolObject<PositionTickInfo> {
public:
    ~PositionTickInfo() override;  // Defined below

    int getLine() { return m_line; }
    void setLine(int value);  // Defined below

    int getTicks() { return m_ticks; }
    void setTicks(int value);  // Defined below

    template<int STATE>
    class PositionTickInfoBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            LineSet = 1 << 1,
            TicksSet = 1 << 2,
            AllFieldsSet = (LineSet | TicksSet | 0)};


        PositionTickInfoBuilder<STATE | LineSet>& setLine(int value);  // Defined below

        PositionTickInfoBuilder<STATE | TicksSet>& setTicks(int value);  // Defined below

        std::unique_ptr<PositionTickInfo> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class PositionTickInfo;
        PositionTickInfoBuilder() : m_result(new PositionTickInfo()) { }

        template<int STEP> PositionTickInfoBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<PositionTickInfoBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Profiler::PositionTickInfo> m_result;
    };

    static PositionTickInfoBuilder<0> create()
    {
        return PositionTickInfoBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    PositionTickInfo();  // Defined below

    int m_line;
    int m_ticks;
};


class  CoverageRange : public ::v8_crdtp::ProtocolObject<CoverageRange> {
public:
    ~CoverageRange() override;  // Defined below

    int getStartOffset() { return m_startOffset; }
    void setStartOffset(int value);  // Defined below

    int getEndOffset() { return m_endOffset; }
    void setEndOffset(int value);  // Defined below

    int getCount() { return m_count; }
    void setCount(int value);  // Defined below

    template<int STATE>
    class CoverageRangeBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            StartOffsetSet = 1 << 1,
            EndOffsetSet = 1 << 2,
            CountSet = 1 << 3,
            AllFieldsSet = (StartOffsetSet | EndOffsetSet | CountSet | 0)};


        CoverageRangeBuilder<STATE | StartOffsetSet>& setStartOffset(int value);  // Defined below

        CoverageRangeBuilder<STATE | EndOffsetSet>& setEndOffset(int value);  // Defined below

        CoverageRangeBuilder<STATE | CountSet>& setCount(int value);  // Defined below

        std::unique_ptr<CoverageRange> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CoverageRange;
        CoverageRangeBuilder() : m_result(new CoverageRange()) { }

        template<int STEP> CoverageRangeBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CoverageRangeBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Profiler::CoverageRange> m_result;
    };

    static CoverageRangeBuilder<0> create()
    {
        return CoverageRangeBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CoverageRange();  // Defined below

    int m_startOffset;
    int m_endOffset;
    int m_count;
};


class  FunctionCoverage : public ::v8_crdtp::ProtocolObject<FunctionCoverage> {
public:
    ~FunctionCoverage() override;  // Defined below

    String getFunctionName() { return m_functionName; }
    void setFunctionName(const String& value);  // Defined below

    protocol::Array<protocol::Profiler::CoverageRange>* getRanges() { return m_ranges.get(); }
    void setRanges(std::unique_ptr<protocol::Array<protocol::Profiler::CoverageRange>> value);  // Defined below

    bool getIsBlockCoverage() { return m_isBlockCoverage; }
    void setIsBlockCoverage(bool value);  // Defined below

    template<int STATE>
    class FunctionCoverageBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            FunctionNameSet = 1 << 1,
            RangesSet = 1 << 2,
            IsBlockCoverageSet = 1 << 3,
            AllFieldsSet = (FunctionNameSet | RangesSet | IsBlockCoverageSet | 0)};


        FunctionCoverageBuilder<STATE | FunctionNameSet>& setFunctionName(const String& value);  // Defined below

        FunctionCoverageBuilder<STATE | RangesSet>& setRanges(std::unique_ptr<protocol::Array<protocol::Profiler::CoverageRange>> value);  // Defined below

        FunctionCoverageBuilder<STATE | IsBlockCoverageSet>& setIsBlockCoverage(bool value);  // Defined below

        std::unique_ptr<FunctionCoverage> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class FunctionCoverage;
        FunctionCoverageBuilder() : m_result(new FunctionCoverage()) { }

        template<int STEP> FunctionCoverageBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<FunctionCoverageBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Profiler::FunctionCoverage> m_result;
    };

    static FunctionCoverageBuilder<0> create()
    {
        return FunctionCoverageBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    FunctionCoverage();  // Defined below

    String m_functionName;
    std::unique_ptr<protocol::Array<protocol::Profiler::CoverageRange>> m_ranges;
    bool m_isBlockCoverage;
};


class  ScriptCoverage : public ::v8_crdtp::ProtocolObject<ScriptCoverage> {
public:
    ~ScriptCoverage() override;  // Defined below

    String getScriptId() { return m_scriptId; }
    void setScriptId(const String& value);  // Defined below

    String getUrl() { return m_url; }
    void setUrl(const String& value);  // Defined below

    protocol::Array<protocol::Profiler::FunctionCoverage>* getFunctions() { return m_functions.get(); }
    void setFunctions(std::unique_ptr<protocol::Array<protocol::Profiler::FunctionCoverage>> value);  // Defined below

    template<int STATE>
    class ScriptCoverageBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ScriptIdSet = 1 << 1,
            UrlSet = 1 << 2,
            FunctionsSet = 1 << 3,
            AllFieldsSet = (ScriptIdSet | UrlSet | FunctionsSet | 0)};


        ScriptCoverageBuilder<STATE | ScriptIdSet>& setScriptId(const String& value);  // Defined below

        ScriptCoverageBuilder<STATE | UrlSet>& setUrl(const String& value);  // Defined below

        ScriptCoverageBuilder<STATE | FunctionsSet>& setFunctions(std::unique_ptr<protocol::Array<protocol::Profiler::FunctionCoverage>> value);  // Defined below

        std::unique_ptr<ScriptCoverage> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ScriptCoverage;
        ScriptCoverageBuilder() : m_result(new ScriptCoverage()) { }

        template<int STEP> ScriptCoverageBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ScriptCoverageBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Profiler::ScriptCoverage> m_result;
    };

    static ScriptCoverageBuilder<0> create()
    {
        return ScriptCoverageBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ScriptCoverage();  // Defined below

    String m_scriptId;
    String m_url;
    std::unique_ptr<protocol::Array<protocol::Profiler::FunctionCoverage>> m_functions;
};


// ------------- Type and builder method definitions.
//
// These methods separate from the type declaration because of
// https://github.com/llvm/llvm-project/issues/59966. The DevTools protocol has
// mutually recursive types, so we cannot simply reorder the types.
inline ProfileNode::~ProfileNode() = default;
inline void ProfileNode::setId(int value) { m_id = value; }
inline void ProfileNode::setCallFrame(std::unique_ptr<protocol::Runtime::CallFrame> value) { m_callFrame = std::move(value); }
inline void ProfileNode::setHitCount(int value) { m_hitCount = value; }
inline void ProfileNode::setChildren(std::unique_ptr<protocol::Array<int>> value) { m_children = std::move(value); }
inline void ProfileNode::setDeoptReason(const String& value) { m_deoptReason = value; }
inline void ProfileNode::setPositionTicks(std::unique_ptr<protocol::Array<protocol::Profiler::PositionTickInfo>> value) { m_positionTicks = std::move(value); }

template<int STATE>
inline ProfileNode::ProfileNodeBuilder<STATE | ProfileNode::ProfileNodeBuilder<STATE>::IdSet>&
ProfileNode::ProfileNodeBuilder<STATE>::setId(int value) {
  static_assert(!(STATE & IdSet), "property id should not be set yet");
  m_result->setId(value);
  return castState<IdSet>();
}
template<int STATE>
inline ProfileNode::ProfileNodeBuilder<STATE | ProfileNode::ProfileNodeBuilder<STATE>::CallFrameSet>&
ProfileNode::ProfileNodeBuilder<STATE>::setCallFrame(std::unique_ptr<protocol::Runtime::CallFrame> value) {
  static_assert(!(STATE & CallFrameSet), "property callFrame should not be set yet");
  m_result->setCallFrame(std::move(value));
  return castState<CallFrameSet>();
}
template<int STATE>
inline ProfileNode::ProfileNodeBuilder<STATE>& ProfileNode::ProfileNodeBuilder<STATE>::setHitCount(int value) {
  m_result->setHitCount(value);
  return *this;
}
template<int STATE>
inline ProfileNode::ProfileNodeBuilder<STATE>& ProfileNode::ProfileNodeBuilder<STATE>::setChildren(std::unique_ptr<protocol::Array<int>> value) {
  m_result->setChildren(std::move(value));
  return *this;
}
template<int STATE>
inline ProfileNode::ProfileNodeBuilder<STATE>& ProfileNode::ProfileNodeBuilder<STATE>::setDeoptReason(const String& value) {
  m_result->setDeoptReason(value);
  return *this;
}
template<int STATE>
inline ProfileNode::ProfileNodeBuilder<STATE>& ProfileNode::ProfileNodeBuilder<STATE>::setPositionTicks(std::unique_ptr<protocol::Array<protocol::Profiler::PositionTickInfo>> value) {
  m_result->setPositionTicks(std::move(value));
  return *this;
}

inline ProfileNode::ProfileNode() {
  m_id = 0;
}
inline Profile::~Profile() = default;
inline void Profile::setNodes(std::unique_ptr<protocol::Array<protocol::Profiler::ProfileNode>> value) { m_nodes = std::move(value); }
inline void Profile::setStartTime(double value) { m_startTime = value; }
inline void Profile::setEndTime(double value) { m_endTime = value; }
inline void Profile::setSamples(std::unique_ptr<protocol::Array<int>> value) { m_samples = std::move(value); }
inline void Profile::setTimeDeltas(std::unique_ptr<protocol::Array<int>> value) { m_timeDeltas = std::move(value); }

template<int STATE>
inline Profile::ProfileBuilder<STATE | Profile::ProfileBuilder<STATE>::NodesSet>&
Profile::ProfileBuilder<STATE>::setNodes(std::unique_ptr<protocol::Array<protocol::Profiler::ProfileNode>> value) {
  static_assert(!(STATE & NodesSet), "property nodes should not be set yet");
  m_result->setNodes(std::move(value));
  return castState<NodesSet>();
}
template<int STATE>
inline Profile::ProfileBuilder<STATE | Profile::ProfileBuilder<STATE>::StartTimeSet>&
Profile::ProfileBuilder<STATE>::setStartTime(double value) {
  static_assert(!(STATE & StartTimeSet), "property startTime should not be set yet");
  m_result->setStartTime(value);
  return castState<StartTimeSet>();
}
template<int STATE>
inline Profile::ProfileBuilder<STATE | Profile::ProfileBuilder<STATE>::EndTimeSet>&
Profile::ProfileBuilder<STATE>::setEndTime(double value) {
  static_assert(!(STATE & EndTimeSet), "property endTime should not be set yet");
  m_result->setEndTime(value);
  return castState<EndTimeSet>();
}
template<int STATE>
inline Profile::ProfileBuilder<STATE>& Profile::ProfileBuilder<STATE>::setSamples(std::unique_ptr<protocol::Array<int>> value) {
  m_result->setSamples(std::move(value));
  return *this;
}
template<int STATE>
inline Profile::ProfileBuilder<STATE>& Profile::ProfileBuilder<STATE>::setTimeDeltas(std::unique_ptr<protocol::Array<int>> value) {
  m_result->setTimeDeltas(std::move(value));
  return *this;
}

inline Profile::Profile() {
  m_startTime = 0;
  m_endTime = 0;
}
inline PositionTickInfo::~PositionTickInfo() = default;
inline void PositionTickInfo::setLine(int value) { m_line = value; }
inline void PositionTickInfo::setTicks(int value) { m_ticks = value; }

template<int STATE>
inline PositionTickInfo::PositionTickInfoBuilder<STATE | PositionTickInfo::PositionTickInfoBuilder<STATE>::LineSet>&
PositionTickInfo::PositionTickInfoBuilder<STATE>::setLine(int value) {
  static_assert(!(STATE & LineSet), "property line should not be set yet");
  m_result->setLine(value);
  return castState<LineSet>();
}
template<int STATE>
inline PositionTickInfo::PositionTickInfoBuilder<STATE | PositionTickInfo::PositionTickInfoBuilder<STATE>::TicksSet>&
PositionTickInfo::PositionTickInfoBuilder<STATE>::setTicks(int value) {
  static_assert(!(STATE & TicksSet), "property ticks should not be set yet");
  m_result->setTicks(value);
  return castState<TicksSet>();
}

inline PositionTickInfo::PositionTickInfo() {
  m_line = 0;
  m_ticks = 0;
}
inline CoverageRange::~CoverageRange() = default;
inline void CoverageRange::setStartOffset(int value) { m_startOffset = value; }
inline void CoverageRange::setEndOffset(int value) { m_endOffset = value; }
inline void CoverageRange::setCount(int value) { m_count = value; }

template<int STATE>
inline CoverageRange::CoverageRangeBuilder<STATE | CoverageRange::CoverageRangeBuilder<STATE>::StartOffsetSet>&
CoverageRange::CoverageRangeBuilder<STATE>::setStartOffset(int value) {
  static_assert(!(STATE & StartOffsetSet), "property startOffset should not be set yet");
  m_result->setStartOffset(value);
  return castState<StartOffsetSet>();
}
template<int STATE>
inline CoverageRange::CoverageRangeBuilder<STATE | CoverageRange::CoverageRangeBuilder<STATE>::EndOffsetSet>&
CoverageRange::CoverageRangeBuilder<STATE>::setEndOffset(int value) {
  static_assert(!(STATE & EndOffsetSet), "property endOffset should not be set yet");
  m_result->setEndOffset(value);
  return castState<EndOffsetSet>();
}
template<int STATE>
inline CoverageRange::CoverageRangeBuilder<STATE | CoverageRange::CoverageRangeBuilder<STATE>::CountSet>&
CoverageRange::CoverageRangeBuilder<STATE>::setCount(int value) {
  static_assert(!(STATE & CountSet), "property count should not be set yet");
  m_result->setCount(value);
  return castState<CountSet>();
}

inline CoverageRange::CoverageRange() {
  m_startOffset = 0;
  m_endOffset = 0;
  m_count = 0;
}
inline FunctionCoverage::~FunctionCoverage() = default;
inline void FunctionCoverage::setFunctionName(const String& value) { m_functionName = value; }
inline void FunctionCoverage::setRanges(std::unique_ptr<protocol::Array<protocol::Profiler::CoverageRange>> value) { m_ranges = std::move(value); }
inline void FunctionCoverage::setIsBlockCoverage(bool value) { m_isBlockCoverage = value; }

template<int STATE>
inline FunctionCoverage::FunctionCoverageBuilder<STATE | FunctionCoverage::FunctionCoverageBuilder<STATE>::FunctionNameSet>&
FunctionCoverage::FunctionCoverageBuilder<STATE>::setFunctionName(const String& value) {
  static_assert(!(STATE & FunctionNameSet), "property functionName should not be set yet");
  m_result->setFunctionName(value);
  return castState<FunctionNameSet>();
}
template<int STATE>
inline FunctionCoverage::FunctionCoverageBuilder<STATE | FunctionCoverage::FunctionCoverageBuilder<STATE>::RangesSet>&
FunctionCoverage::FunctionCoverageBuilder<STATE>::setRanges(std::unique_ptr<protocol::Array<protocol::Profiler::CoverageRange>> value) {
  static_assert(!(STATE & RangesSet), "property ranges should not be set yet");
  m_result->setRanges(std::move(value));
  return castState<RangesSet>();
}
template<int STATE>
inline FunctionCoverage::FunctionCoverageBuilder<STATE | FunctionCoverage::FunctionCoverageBuilder<STATE>::IsBlockCoverageSet>&
FunctionCoverage::FunctionCoverageBuilder<STATE>::setIsBlockCoverage(bool value) {
  static_assert(!(STATE & IsBlockCoverageSet), "property isBlockCoverage should not be set yet");
  m_result->setIsBlockCoverage(value);
  return castState<IsBlockCoverageSet>();
}

inline FunctionCoverage::FunctionCoverage() {
  m_isBlockCoverage = false;
}
inline ScriptCoverage::~ScriptCoverage() = default;
inline void ScriptCoverage::setScriptId(const String& value) { m_scriptId = value; }
inline void ScriptCoverage::setUrl(const String& value) { m_url = value; }
inline void ScriptCoverage::setFunctions(std::unique_ptr<protocol::Array<protocol::Profiler::FunctionCoverage>> value) { m_functions = std::move(value); }

template<int STATE>
inline ScriptCoverage::ScriptCoverageBuilder<STATE | ScriptCoverage::ScriptCoverageBuilder<STATE>::ScriptIdSet>&
ScriptCoverage::ScriptCoverageBuilder<STATE>::setScriptId(const String& value) {
  static_assert(!(STATE & ScriptIdSet), "property scriptId should not be set yet");
  m_result->setScriptId(value);
  return castState<ScriptIdSet>();
}
template<int STATE>
inline ScriptCoverage::ScriptCoverageBuilder<STATE | ScriptCoverage::ScriptCoverageBuilder<STATE>::UrlSet>&
ScriptCoverage::ScriptCoverageBuilder<STATE>::setUrl(const String& value) {
  static_assert(!(STATE & UrlSet), "property url should not be set yet");
  m_result->setUrl(value);
  return castState<UrlSet>();
}
template<int STATE>
inline ScriptCoverage::ScriptCoverageBuilder<STATE | ScriptCoverage::ScriptCoverageBuilder<STATE>::FunctionsSet>&
ScriptCoverage::ScriptCoverageBuilder<STATE>::setFunctions(std::unique_ptr<protocol::Array<protocol::Profiler::FunctionCoverage>> value) {
  static_assert(!(STATE & FunctionsSet), "property functions should not be set yet");
  m_result->setFunctions(std::move(value));
  return castState<FunctionsSet>();
}

inline ScriptCoverage::ScriptCoverage() {
}

// ------------- Backend interface.

class  Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse disable() = 0;
    virtual DispatchResponse enable() = 0;
    virtual DispatchResponse getBestEffortCoverage(std::unique_ptr<protocol::Array<protocol::Profiler::ScriptCoverage>>* out_result) = 0;
    virtual DispatchResponse setSamplingInterval(int in_interval) = 0;
    virtual DispatchResponse start() = 0;
    virtual DispatchResponse startPreciseCoverage(std::optional<bool> in_callCount, std::optional<bool> in_detailed, std::optional<bool> in_allowTriggeredUpdates, double* out_timestamp) = 0;
    virtual DispatchResponse stop(std::unique_ptr<protocol::Profiler::Profile>* out_profile) = 0;
    virtual DispatchResponse stopPreciseCoverage() = 0;
    virtual DispatchResponse takePreciseCoverage(std::unique_ptr<protocol::Array<protocol::Profiler::ScriptCoverage>>* out_result, double* out_timestamp) = 0;

};

// ------------- Frontend interface.

class  Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void consoleProfileFinished(const String& id, std::unique_ptr<protocol::Debugger::Location> location, std::unique_ptr<protocol::Profiler::Profile> profile, std::optional<String> title = {});
    void consoleProfileStarted(const String& id, std::unique_ptr<protocol::Debugger::Location> location, std::optional<String> title = {});
    void preciseCoverageDeltaUpdate(double timestamp, const String& occasion, std::unique_ptr<protocol::Array<protocol::Profiler::ScriptCoverage>> result);

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class  Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class  Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Profiler
} // namespace v8_inspector
} // namespace protocol

#endif // !defined(v8_inspector_protocol_Profiler_h)
