// url/mojom/scheme_host_port.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef URL_MOJOM_SCHEME_HOST_PORT_MOJOM_H_
#define URL_MOJOM_SCHEME_HOST_PORT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "url/mojom/scheme_host_port.mojom-features.h"  // IWYU pragma: export
#include "url/mojom/scheme_host_port.mojom-shared.h"  // IWYU pragma: export
#include "url/mojom/scheme_host_port.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "url/mojom/scheme_host_port_mojom_traits.h"




namespace url::mojom {





class  SchemeHostPort {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SchemeHostPort, T>::value>;
  using DataView = SchemeHostPortDataView;
  using Data_ = internal::SchemeHostPort_Data;

  template <typename... Args>
  static SchemeHostPortPtr New(Args&&... args) {
    return SchemeHostPortPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SchemeHostPortPtr From(const U& u) {
    return mojo::TypeConverter<SchemeHostPortPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SchemeHostPort>::Convert(*this);
  }


  SchemeHostPort();

  SchemeHostPort(
      const std::string& scheme,
      const std::string& host,
      uint16_t port);


  ~SchemeHostPort();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SchemeHostPortPtr>
  SchemeHostPortPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SchemeHostPort::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SchemeHostPort::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SchemeHostPort::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SchemeHostPort::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SchemeHostPort::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SchemeHostPort::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SchemeHostPort_UnserializedMessageContext<
            UserType, SchemeHostPort::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SchemeHostPort::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SchemeHostPort::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SchemeHostPort_UnserializedMessageContext<
            UserType, SchemeHostPort::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SchemeHostPort::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string scheme;
  
  std::string host;
  
  uint16_t port;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SchemeHostPort::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SchemeHostPort::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SchemeHostPort::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SchemeHostPort::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
SchemeHostPortPtr SchemeHostPort::Clone() const {
  return New(
      mojo::Clone(scheme),
      mojo::Clone(host),
      mojo::Clone(port)
  );
}

template <typename T, SchemeHostPort::EnableIfSame<T>*>
bool SchemeHostPort::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->scheme, other_struct.scheme))
    return false;
  if (!mojo::Equals(this->host, other_struct.host))
    return false;
  if (!mojo::Equals(this->port, other_struct.port))
    return false;
  return true;
}

template <typename T, SchemeHostPort::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.scheme < rhs.scheme)
    return true;
  if (rhs.scheme < lhs.scheme)
    return false;
  if (lhs.host < rhs.host)
    return true;
  if (rhs.host < lhs.host)
    return false;
  if (lhs.port < rhs.port)
    return true;
  if (rhs.port < lhs.port)
    return false;
  return false;
}


}  // url::mojom

namespace mojo {


template <>
struct  StructTraits<::url::mojom::SchemeHostPort::DataView,
                                         ::url::mojom::SchemeHostPortPtr> {
  static bool IsNull(const ::url::mojom::SchemeHostPortPtr& input) { return !input; }
  static void SetToNull(::url::mojom::SchemeHostPortPtr* output) { output->reset(); }

  static const decltype(::url::mojom::SchemeHostPort::scheme)& scheme(
      const ::url::mojom::SchemeHostPortPtr& input) {
    return input->scheme;
  }

  static const decltype(::url::mojom::SchemeHostPort::host)& host(
      const ::url::mojom::SchemeHostPortPtr& input) {
    return input->host;
  }

  static decltype(::url::mojom::SchemeHostPort::port) port(
      const ::url::mojom::SchemeHostPortPtr& input) {
    return input->port;
  }

  static bool Read(::url::mojom::SchemeHostPort::DataView input, ::url::mojom::SchemeHostPortPtr* output);
};

}  // namespace mojo

#endif  // URL_MOJOM_SCHEME_HOST_PORT_MOJOM_H_