// url/mojom/scheme_host_port.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef URL_MOJOM_SCHEME_HOST_PORT_MOJOM_SHARED_H_
#define URL_MOJOM_SCHEME_HOST_PORT_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "url/mojom/scheme_host_port.mojom-shared-internal.h"




#include "url/mojom/scheme_host_port.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::url::mojom::SchemeHostPortDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::url::mojom::SchemeHostPortDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::url::mojom::internal::SchemeHostPort_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::scheme(input)) in_scheme = Traits::scheme(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->scheme)::BaseType> scheme_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_scheme,
      scheme_fragment);

    fragment->scheme.Set(
        scheme_fragment.is_null() ? nullptr : scheme_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->scheme.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null scheme in SchemeHostPort struct");

    decltype(Traits::host(input)) in_host = Traits::host(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->host)::BaseType> host_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_host,
      host_fragment);

    fragment->host.Set(
        host_fragment.is_null() ? nullptr : host_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->host.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null host in SchemeHostPort struct");

    fragment->port = Traits::port(input);
  }

  static bool Deserialize(::url::mojom::internal::SchemeHostPort_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::url::mojom::SchemeHostPortDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace url::mojom {

inline void SchemeHostPortDataView::GetSchemeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->scheme.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SchemeHostPortDataView::GetHostDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->host.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // url::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // URL_MOJOM_SCHEME_HOST_PORT_MOJOM_SHARED_H_