// url/mojom/scheme_host_port.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef URL_MOJOM_SCHEME_HOST_PORT_MOJOM_SEND_VALIDATION_H_
#define URL_MOJOM_SCHEME_HOST_PORT_MOJOM_SEND_VALIDATION_H_

#include "url/mojom/scheme_host_port.mojom-shared-internal.h"

#include "url/mojom/scheme_host_port.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::url::mojom::SchemeHostPortDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::url::mojom::SchemeHostPortDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::url::mojom::internal::SchemeHostPort_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::scheme(input)) in_scheme = Traits::scheme(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->scheme)::BaseType> scheme_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_scheme,
        scheme_fragment);

      fragment->scheme.Set(
          scheme_fragment.is_null() ? nullptr : scheme_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->scheme.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scheme in SchemeHostPort struct");

      decltype(Traits::host(input)) in_host = Traits::host(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->host)::BaseType> host_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_host,
        host_fragment);

      fragment->host.Set(
          host_fragment.is_null() ? nullptr : host_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->host.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null host in SchemeHostPort struct");

      fragment->port = Traits::port(input);
  }
};

}  // namespace mojo::internal

#endif  // URL_MOJOM_SCHEME_HOST_PORT_MOJOM_SEND_VALIDATION_H_