// url/mojom/origin.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef URL_MOJOM_ORIGIN_MOJOM_H_
#define URL_MOJOM_ORIGIN_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "url/mojom/origin.mojom-features.h"  // IWYU pragma: export
#include "url/mojom/origin.mojom-shared.h"  // IWYU pragma: export
#include "url/mojom/origin.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include <string>
#include <vector>




#include "url/mojom/origin_mojom_traits.h"




namespace url::mojom {








class  Origin {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Origin, T>::value>;
  using DataView = OriginDataView;
  using Data_ = internal::Origin_Data;

  template <typename... Args>
  static OriginPtr New(Args&&... args) {
    return OriginPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static OriginPtr From(const U& u) {
    return mojo::TypeConverter<OriginPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Origin>::Convert(*this);
  }


  Origin();

  Origin(
      const std::string& scheme,
      const std::string& host,
      uint16_t port,
      const std::optional<::base::UnguessableToken>& nonce_if_opaque);


  ~Origin();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = OriginPtr>
  OriginPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Origin::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Origin::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Origin::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Origin::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Origin::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Origin::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Origin_UnserializedMessageContext<
            UserType, Origin::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Origin::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Origin::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Origin_UnserializedMessageContext<
            UserType, Origin::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Origin::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string scheme;
  
  std::string host;
  
  uint16_t port;
  
  std::optional<::base::UnguessableToken> nonce_if_opaque;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Origin::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Origin::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Origin::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Origin::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
OriginPtr Origin::Clone() const {
  return New(
      mojo::Clone(scheme),
      mojo::Clone(host),
      mojo::Clone(port),
      mojo::Clone(nonce_if_opaque)
  );
}

template <typename T, Origin::EnableIfSame<T>*>
bool Origin::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->scheme, other_struct.scheme))
    return false;
  if (!mojo::Equals(this->host, other_struct.host))
    return false;
  if (!mojo::Equals(this->port, other_struct.port))
    return false;
  if (!mojo::Equals(this->nonce_if_opaque, other_struct.nonce_if_opaque))
    return false;
  return true;
}

template <typename T, Origin::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.scheme < rhs.scheme)
    return true;
  if (rhs.scheme < lhs.scheme)
    return false;
  if (lhs.host < rhs.host)
    return true;
  if (rhs.host < lhs.host)
    return false;
  if (lhs.port < rhs.port)
    return true;
  if (rhs.port < lhs.port)
    return false;
  if (lhs.nonce_if_opaque < rhs.nonce_if_opaque)
    return true;
  if (rhs.nonce_if_opaque < lhs.nonce_if_opaque)
    return false;
  return false;
}


}  // url::mojom

namespace mojo {


template <>
struct  StructTraits<::url::mojom::Origin::DataView,
                                         ::url::mojom::OriginPtr> {
  static bool IsNull(const ::url::mojom::OriginPtr& input) { return !input; }
  static void SetToNull(::url::mojom::OriginPtr* output) { output->reset(); }

  static const decltype(::url::mojom::Origin::scheme)& scheme(
      const ::url::mojom::OriginPtr& input) {
    return input->scheme;
  }

  static const decltype(::url::mojom::Origin::host)& host(
      const ::url::mojom::OriginPtr& input) {
    return input->host;
  }

  static decltype(::url::mojom::Origin::port) port(
      const ::url::mojom::OriginPtr& input) {
    return input->port;
  }

  static const decltype(::url::mojom::Origin::nonce_if_opaque)& nonce_if_opaque(
      const ::url::mojom::OriginPtr& input) {
    return input->nonce_if_opaque;
  }

  static bool Read(::url::mojom::Origin::DataView input, ::url::mojom::OriginPtr* output);
};

}  // namespace mojo

#endif  // URL_MOJOM_ORIGIN_MOJOM_H_