// url/mojom/origin.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "url/mojom/origin.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "url/mojom/origin.mojom-params-data.h"
#include "url/mojom/origin.mojom-shared-message-ids.h"

#include "url/mojom/origin.mojom-blink-import-headers.h"
#include "url/mojom/origin.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace url::mojom::blink {
Origin::Origin()
    : scheme(),
      host(),
      port(),
      nonce_if_opaque() {}

Origin::Origin(
    const ::blink::String& scheme_in,
    const ::blink::String& host_in,
    uint16_t port_in,
    const std::optional<::base::UnguessableToken>& nonce_if_opaque_in)
    : scheme(std::move(scheme_in)),
      host(std::move(host_in)),
      port(std::move(port_in)),
      nonce_if_opaque(std::move(nonce_if_opaque_in)) {}

Origin::~Origin() = default;

void Origin::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scheme"), this->scheme,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "host"), this->host,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "port"), this->port,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint16_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "nonce_if_opaque"), this->nonce_if_opaque,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::base::UnguessableToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Origin::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // url::mojom::blink


namespace mojo {


// static
bool StructTraits<::url::mojom::blink::Origin::DataView, ::url::mojom::blink::OriginPtr>::Read(
    ::url::mojom::blink::Origin::DataView input,
    ::url::mojom::blink::OriginPtr* output) {
  bool success = true;
  ::url::mojom::blink::OriginPtr result(::url::mojom::blink::Origin::New());
  
      if (success && !input.ReadScheme(&result->scheme))
        success = false;
      if (success && !input.ReadHost(&result->host))
        success = false;
      if (success)
        result->port = input.port();
      if (success && !input.ReadNonceIfOpaque(&result->nonce_if_opaque))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace url::mojom::blink {




}  // url::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif