import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { RectF as gfx_mojom_RectF } from '../../../../gfx/geometry/mojom/geometry.mojom-webui.js';
export type TrackedElementHandlerPendingReceiverEndpoint = mojo.internal.interfaceSupport.Endpoint<TrackedElementHandlerPendingReceiver>;
export declare class TrackedElementHandlerPendingReceiver implements mojo.internal.interfaceSupport.PendingReceiver<TrackedElementHandler> {
    handle: mojo.internal.interfaceSupport.Endpoint<TrackedElementHandlerPendingReceiver>;
    constructor(handle: MojoHandle | TrackedElementHandlerPendingReceiverEndpoint);
    bindInBrowser(scope?: string): void;
}
export interface TrackedElementHandlerInterface {
    trackedElementVisibilityChanged(nativeIdentifier: string, visible: boolean, rect: gfx_mojom_RectF): void;
    trackedElementActivated(nativeIdentifier: string): void;
    trackedElementCustomEvent(nativeIdentifier: string, customEventName: string): void;
}
export declare class TrackedElementHandlerRemote implements TrackedElementHandlerInterface {
    private proxy;
    $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<TrackedElementHandlerPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(handle?: MojoHandle | TrackedElementHandlerPendingReceiverEndpoint);
    trackedElementVisibilityChanged(nativeIdentifier: string, visible: boolean, rect: gfx_mojom_RectF): void;
    trackedElementActivated(nativeIdentifier: string): void;
    trackedElementCustomEvent(nativeIdentifier: string, customEventName: string): void;
}
/**
 * An object which receives request messages for the TrackedElementHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export declare class TrackedElementHandlerReceiver {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<TrackedElementHandlerRemote, TrackedElementHandlerPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(impl: TrackedElementHandlerInterface);
}
export declare class TrackedElementHandler {
    static get $interfaceName(): string;
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote(): TrackedElementHandlerRemote;
}
/**
 * An object which receives request messages for the TrackedElementHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export declare class TrackedElementHandlerCallbackRouter {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<TrackedElementHandlerRemote, TrackedElementHandlerPendingReceiver>;
    router_: mojo.internal.interfaceSupport.CallbackRouter;
    trackedElementVisibilityChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    trackedElementActivated: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    trackedElementCustomEvent: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor();
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id: number): boolean;
}
export declare const TrackedElementHandler_TrackedElementVisibilityChanged_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const TrackedElementHandler_TrackedElementActivated_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const TrackedElementHandler_TrackedElementCustomEvent_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export interface TrackedElementHandler_TrackedElementVisibilityChanged_ParamsMojoType {
    nativeIdentifier: string;
    visible: boolean;
    rect: gfx_mojom_RectF;
}
export type TrackedElementHandler_TrackedElementVisibilityChanged_Params = TrackedElementHandler_TrackedElementVisibilityChanged_ParamsMojoType;
export interface TrackedElementHandler_TrackedElementActivated_ParamsMojoType {
    nativeIdentifier: string;
}
export type TrackedElementHandler_TrackedElementActivated_Params = TrackedElementHandler_TrackedElementActivated_ParamsMojoType;
export interface TrackedElementHandler_TrackedElementCustomEvent_ParamsMojoType {
    nativeIdentifier: string;
    customEventName: string;
}
export type TrackedElementHandler_TrackedElementCustomEvent_Params = TrackedElementHandler_TrackedElementCustomEvent_ParamsMojoType;
