// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { TrackedElementHandler } from '//resources/mojo/ui/webui/resources/js/tracked_element/tracked_element.mojom-webui.js';
/**
 * Proxy for the TrackedElementHandler mojo interface.
 */
export class TrackedElementProxyImpl {
    handler_ = TrackedElementHandler.getRemote();
    getHandler() {
        return this.handler_;
    }
    static getInstance() {
        return instance || (instance = new TrackedElementProxyImpl());
    }
    static setInstance(obj) {
        instance = obj;
    }
}
let instance = null;
