// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { assert } from '//resources/js/assert.js';
import { TrackedElementHandlerRemote } from '//resources/mojo/ui/webui/resources/js/tracked_element/tracked_element.mojom-webui.js';
import { HelpBubbleClientCallbackRouter, HelpBubbleHandlerRemote, PdfHelpBubbleHandlerFactory } from './help_bubble.mojom-webui.js';
export class PdfHelpBubbleProxyImpl {
    trackedElementHandler_ = new TrackedElementHandlerRemote();
    callbackRouter_ = new HelpBubbleClientCallbackRouter();
    handler_ = new HelpBubbleHandlerRemote();
    constructor(connectToMojo) {
        if (connectToMojo) {
            const factory = PdfHelpBubbleHandlerFactory.getRemote();
            factory.createHelpBubbleHandler(this.callbackRouter_.$.bindNewPipeAndPassRemote(), this.handler_.$.bindNewPipeAndPassReceiver());
            this.handler_.bindTrackedElementHandler(this.trackedElementHandler_.$.bindNewPipeAndPassReceiver());
        }
    }
    static getInstance() {
        return instance || (instance = new PdfHelpBubbleProxyImpl(false));
    }
    static createConnectedInstance() {
        assert(!instance);
        instance = new PdfHelpBubbleProxyImpl(true);
    }
    getTrackedElementHandler() {
        return this.trackedElementHandler_;
    }
    getHandler() {
        return this.handler_;
    }
    getCallbackRouter() {
        return this.callbackRouter_;
    }
}
let instance = null;
