import type { CrLitElement } from '//resources/lit/v3_0/lit.rollup.js';
import type { HelpBubbleElement } from './help_bubble.js';
import type { HelpBubbleParams } from './help_bubble.mojom-webui.js';
import type { Trackable } from './help_bubble_controller.js';
import { HelpBubbleController } from './help_bubble_controller.js';
import type { HelpBubbleProxy } from './help_bubble_proxy.js';
type Constructor<T> = new (...args: any[]) => T;
export declare const HelpBubbleMixinLit: <T extends Constructor<CrLitElement>>(superClass: T) => T & Constructor<HelpBubbleMixinLitInterface>;
export interface HelpBubbleMixinLitInterface {
    createHelpBubbleProxy(): HelpBubbleProxy;
    registerHelpBubble(nativeId: string, trackable: Trackable, options?: Options): HelpBubbleController | null;
    unregisterHelpBubble(nativeId: string): void;
    isHelpBubbleShowing(): boolean;
    isHelpBubbleShowingForTesting(id: string): boolean;
    getHelpBubbleForTesting(id: string): HelpBubbleElement | null;
    getSortedAnchorStatusesForTesting(): Array<[string, boolean]>;
    canShowHelpBubble(controller: HelpBubbleController): boolean;
    showHelpBubble(controller: HelpBubbleController, params: HelpBubbleParams): void;
    hideHelpBubble(nativeId: string): boolean;
    notifyHelpBubbleAnchorActivated(anchorId: string): boolean;
    notifyHelpBubbleAnchorCustomEvent(anchorId: string, customEvent: string): boolean;
}
export interface Options {
    anchorPaddingTop?: number;
    anchorPaddingLeft?: number;
    anchorPaddingBottom?: number;
    anchorPaddingRight?: number;
    fixed?: boolean;
}
export declare function parseOptions(options: Options): {
    padding: import("//resources/mojo/ui/gfx/geometry/mojom/geometry.mojom-webui.js").InsetsFMojoType;
    fixed: boolean;
};
export {};
