// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { html } from '//resources/lit/v3_0/lit.rollup.js';
export function getHtml() {
    // clang-format off
    return this.recentTab ? html `<!--_html_template_start_-->
  <cr-button id="recentTabButton"
      @click="${this.addTabContext_}"
      title="${this.recentTabChipTitle_}"
      aria-label="${this.recentTab.showInCurrentTabChip ?
        this.i18n('askAboutThisPageAriaLabel', this.recentTabChipTitle_) : this.i18n('askAboutPreviousTabAriaLabel', this.recentTabChipTitle_)}">
    <div class="button-content">
      <cr-composebox-tab-favicon
          class="favicon"
          .url="${this.recentTab.url?.url}">
      </cr-composebox-tab-favicon>
      <span class="recent-tab-button-text">
        ${this.recentTab.showInCurrentTabChip ? this.i18n('askAboutThisPage') :
        this.i18n('askAboutPreviousTab')}
      </span>
    </div>
  </cr-button>
<!--_html_template_end_-->` : '';
    //clang-format on
}
