import './composebox_tool_chip.js';
import './context_menu_entrypoint.js';
import './composebox_lens_search.js';
import './file_carousel.js';
import './file_thumbnail.js';
import './icons.html.js';
import './recent_tab_chip.js';
import '//resources/cr_elements/cr_icon_button/cr_icon_button.js';
import type { CrIconButtonElement } from '//resources/cr_elements/cr_icon_button/cr_icon_button.js';
import type { PropertyValues } from '//resources/lit/v3_0/lit.rollup.js';
import { CrLitElement } from '//resources/lit/v3_0/lit.rollup.js';
import type { SearchContext, TabInfo } from '//resources/mojo/components/omnibox/browser/searchbox.mojom-webui.js';
import type { UnguessableToken } from '//resources/mojo/mojo/public/mojom/base/unguessable_token.mojom-webui.js';
import type { Url } from '//resources/mojo/url/mojom/url.mojom-webui.js';
import type { ComposeboxFile, ContextualUpload } from './common.js';
import { TabUploadOrigin } from './common.js';
import { FileUploadErrorType, FileUploadStatus } from './composebox_query.mojom-webui.js';
import { type ContextMenuEntrypointElement, GlifAnimationState } from './context_menu_entrypoint.js';
import type { ComposeboxFileCarouselElement } from './file_carousel.js';
import type { RecentTabChipElement } from './recent_tab_chip.js';
export declare enum ComposeboxMode {
    DEFAULT = "",
    DEEP_SEARCH = "deep-search",
    CREATE_IMAGE = "create-image"
}
export interface ContextualEntrypointAndCarouselElement {
    $: {
        fileInput: HTMLInputElement;
        fileUploadButton: CrIconButtonElement;
        contextEntrypoint: ContextMenuEntrypointElement;
        carousel: ComposeboxFileCarouselElement;
        imageInput: HTMLInputElement;
        imageUploadButton: CrIconButtonElement;
        recentTabChip: RecentTabChipElement;
        voiceSearchButton: CrIconButtonElement;
    };
}
declare const ContextualEntrypointAndCarouselElement_base: typeof CrLitElement & (new (...args: any[]) => import("//resources/cr_elements/i18n_mixin_lit.js").I18nMixinLitInterface);
export declare class ContextualEntrypointAndCarouselElement extends ContextualEntrypointAndCarouselElement_base {
    static get is(): string;
    static get styles(): import("//resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    render(): import("//resources/lit/v3_0/lit.rollup.js").TemplateResult<1>;
    static get properties(): {
        showDropdown: {
            type: BooleanConstructor;
        };
        showLensSearchChip: {
            reflect: boolean;
            type: BooleanConstructor;
        };
        searchboxLayoutMode: {
            type: StringConstructor;
        };
        tabSuggestions: {
            type: ArrayConstructor;
        };
        entrypointName: {
            type: StringConstructor;
        };
        showVoiceSearch: {
            reflect: boolean;
            type: BooleanConstructor;
        };
        contextMenuGlifAnimationState: {
            type: StringConstructor;
            reflect: boolean;
        };
        hideEntrypointButton: {
            type: BooleanConstructor;
        };
        inComposebox: {
            type: BooleanConstructor;
        };
        attachmentFileTypes_: {
            type: StringConstructor;
        };
        contextMenuEnabled_: {
            type: BooleanConstructor;
        };
        files_: {
            type: ObjectConstructor;
        };
        pendingFiles_: {
            type: ObjectConstructor;
        };
        addedTabsIds_: {
            type: ObjectConstructor;
        };
        imageFileTypes_: {
            type: StringConstructor;
        };
        inputsDisabled_: {
            reflect: boolean;
            type: BooleanConstructor;
        };
        composeboxShowPdfUpload_: {
            reflect: boolean;
            type: BooleanConstructor;
        };
        showContextMenuDescription_: {
            type: BooleanConstructor;
        };
        showFileCarousel_: {
            reflect: boolean;
            type: BooleanConstructor;
        };
        showRecentTabChip: {
            type: BooleanConstructor;
        };
        inDeepSearchMode_: {
            reflect: boolean;
            type: BooleanConstructor;
        };
        inCreateImageMode_: {
            reflect: boolean;
            type: BooleanConstructor;
        };
        recentTabForChip_: {
            type: ObjectConstructor;
        };
        carouselOnTop_: {
            type: BooleanConstructor;
        };
        submitButtonShown: {
            type: BooleanConstructor;
        };
        isOmniboxInCompactMode_: {
            type: BooleanConstructor;
            reflect: boolean;
        };
    };
    accessor showDropdown: boolean;
    accessor showLensSearchChip: boolean;
    accessor searchboxLayoutMode: string;
    accessor entrypointName: string;
    accessor tabSuggestions: TabInfo[];
    accessor carouselOnTop_: boolean;
    accessor showVoiceSearch: boolean;
    accessor showRecentTabChip: boolean;
    accessor contextMenuGlifAnimationState: GlifAnimationState;
    accessor inComposebox: boolean;
    accessor isOmniboxInCompactMode_: boolean;
    protected accessor attachmentFileTypes_: string;
    protected accessor contextMenuEnabled_: boolean;
    protected accessor files_: Map<UnguessableToken, ComposeboxFile>;
    protected accessor addedTabsIds_: Map<number, UnguessableToken>;
    protected accessor pendingFiles_: Map<UnguessableToken, FileUploadStatus>;
    protected accessor imageFileTypes_: string;
    protected accessor inputsDisabled_: boolean;
    protected accessor composeboxShowPdfUpload_: boolean;
    protected contextMenuDescriptionEnabled_: boolean;
    protected accessor showContextMenuDescription_: boolean;
    protected accessor showFileCarousel_: boolean;
    protected accessor inDeepSearchMode_: boolean;
    protected accessor inCreateImageMode_: boolean;
    protected accessor recentTabForChip_: TabInfo | null;
    protected accessor submitButtonShown: boolean;
    protected accessor hideEntrypointButton: boolean;
    hasAutomaticActiveTabChipToken(): boolean;
    getAutomaticActiveTabChipElement(): HTMLElement | null;
    protected get inToolMode_(): boolean;
    private shouldShowContextualSearchChips_;
    protected get shouldShowRecentTabChip_(): boolean;
    protected get shouldShowLensSearchChip_(): boolean;
    protected get shouldShowContextualChipsForCompactMode_(): boolean;
    protected get shouldShowToolChipsForTallMode_(): boolean;
    protected get toolChipsVisible_(): boolean;
    protected get shouldShowToolChipsForCompactMode_(): boolean;
    protected get shouldShowDivider_(): boolean;
    protected get shouldHideEntrypointButton_(): boolean;
    private maxFileCount_;
    private maxFileSize_;
    private createImageModeEnabled_;
    private composeboxSource_;
    private automaticActiveTabChipToken_;
    willUpdate(changedProperties: PropertyValues<this>): void;
    addDroppedFiles(files: FileList | null): void;
    addPastedFiles(files: FileList | null): void;
    blurEntrypoint(): void;
    setContextFiles(files: ContextualUpload[]): void;
    setInitialMode(mode: ComposeboxMode): void;
    updateFileStatus(token: UnguessableToken, status: FileUploadStatus, errorType: FileUploadErrorType): {
        file: ComposeboxFile | undefined;
        errorMessage: string | null;
    };
    resetContextFiles(): string[];
    resetModes(): void;
    hasImageFiles(): boolean;
    hasTabFile(): boolean;
    hasDeletableFiles(): boolean;
    onFileContextAdded(file: ComposeboxFile): void;
    updateAutoActiveTabContext(tab: TabInfo | null): void;
    private addFileFromAttachment_;
    private addTabFromAttachment_;
    addSearchContext(context: SearchContext): void;
    protected preventFocus_(e: FocusEvent): void;
    protected onContextMenuContainerClick_(e: MouseEvent): void;
    protected onDeleteFile_(e: CustomEvent<{
        uuid: UnguessableToken;
        fromUserAction?: boolean;
    }>): void;
    private handleProcessFilesError_;
    private isFileAllowed_;
    protected processFiles_(files: FileList | null): void;
    protected onFileChange_(e: Event): void;
    protected addFileContext_(filesToUpload: File[]): void;
    protected addTabContext_(e: CustomEvent<{
        id: number;
        title: string;
        url: Url;
        delayUpload: boolean;
        replaceAutoActiveTabToken: boolean;
        origin: TabUploadOrigin;
    }>): void;
    protected openImageUpload_(): void;
    protected openFileUpload_(): void;
    protected onDeepSearchClick_(): void;
    protected onCreateImageClick_(): void;
    protected onVoiceSearchClick_(): void;
    private recordFileValidationMetric_;
}
declare global {
    interface HTMLElementTagNameMap {
        'contextual-entrypoint-and-carousel': ContextualEntrypointAndCarouselElement;
    }
}
export {};
