import './icons.html.js';
import './composebox_tab_favicon.js';
import '//resources/cr_elements/icons.html.js';
import '//resources/cr_elements/cr_action_menu/cr_action_menu.js';
import '//resources/cr_elements/cr_button/cr_button.js';
import '//resources/cr_elements/cr_icon_button/cr_icon_button.js';
import '//resources/cr_elements/cr_icon/cr_icon.js';
import type { CrActionMenuElement } from '//resources/cr_elements/cr_action_menu/cr_action_menu.js';
import { CrLitElement } from '//resources/lit/v3_0/lit.rollup.js';
import type { TabInfo } from '//resources/mojo/components/omnibox/browser/searchbox.mojom-webui.js';
import type { UnguessableToken } from '//resources/mojo/mojo/public/mojom/base/unguessable_token.mojom-webui.js';
export interface ContextMenuEntrypointElement {
    $: {
        menu: CrActionMenuElement;
    };
}
export declare enum GlifAnimationState {
    INELIGIBLE = "ineligible",
    SPINNER_ONLY = "spinner-only",
    STARTED = "started",
    FINISHED = "finished"
}
declare const ContextMenuEntrypointElementBase: typeof CrLitElement & (new (...args: any[]) => import("//resources/cr_elements/i18n_mixin_lit.js").I18nMixinLitInterface);
export declare class ContextMenuEntrypointElement extends ContextMenuEntrypointElementBase {
    static get is(): string;
    static get styles(): import("//resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    render(): import("//resources/lit/v3_0/lit.rollup.js").TemplateResult<1>;
    static get properties(): {
        inputsDisabled: {
            type: BooleanConstructor;
        };
        fileNum: {
            type: NumberConstructor;
        };
        showContextMenuDescription: {
            type: BooleanConstructor;
        };
        inCreateImageMode: {
            reflect: boolean;
            type: BooleanConstructor;
        };
        hasImageFiles: {
            reflect: boolean;
            type: BooleanConstructor;
        };
        hideEntrypointButton: {
            type: BooleanConstructor;
        };
        disabledTabIds: {
            type: ObjectConstructor;
        };
        tabSuggestions: {
            type: ArrayConstructor;
        };
        entrypointName: {
            type: StringConstructor;
        };
        searchboxLayoutMode: {
            type: StringConstructor;
        };
        glifAnimationState: {
            type: StringConstructor;
            reflect: boolean;
        };
        enableMultiTabSelection_: {
            reflect: boolean;
            type: BooleanConstructor;
        };
        tabPreviewUrl_: {
            type: StringConstructor;
        };
        tabPreviewsEnabled_: {
            type: BooleanConstructor;
        };
        showDeepSearch_: {
            reflect: boolean;
            type: BooleanConstructor;
        };
        showCreateImage_: {
            reflect: boolean;
            type: BooleanConstructor;
        };
        pdfUploadEnabled_: {
            type: BooleanConstructor;
        };
    };
    accessor inputsDisabled: boolean;
    accessor fileNum: number;
    accessor showContextMenuDescription: boolean;
    accessor inCreateImageMode: boolean;
    accessor hasImageFiles: boolean;
    accessor hideEntrypointButton: boolean;
    accessor disabledTabIds: Map<number, UnguessableToken>;
    accessor tabSuggestions: TabInfo[];
    accessor entrypointName: string;
    accessor searchboxLayoutMode: string;
    accessor glifAnimationState: GlifAnimationState;
    protected accessor enableMultiTabSelection_: boolean;
    protected accessor tabPreviewUrl_: string;
    protected accessor tabPreviewsEnabled_: boolean;
    protected accessor showDeepSearch_: boolean;
    protected accessor showCreateImage_: boolean;
    protected accessor pdfUploadEnabled_: boolean;
    protected maxFileCount_: number;
    private metricsSource_;
    constructor();
    openMenuForMultiSelection(): void;
    closeMenu(): void;
    protected get imageUploadDisabled_(): boolean;
    protected get fileUploadDisabled_(): boolean;
    protected get deepSearchDisabled_(): boolean;
    protected get createImageDisabled_(): boolean;
    protected isTabDisabled_(tab: TabInfo): boolean;
    protected onEntrypointClick_(e: Event): void;
    protected onTabClick_(e: Event): void;
    protected deleteTabContext_(uuid: UnguessableToken): void;
    protected addTabContext_(tabInfo: TabInfo): void;
    protected onTabPointerenter_(e: Event): void;
    protected shouldShowTabPreview_(): boolean;
    protected openImageUpload_(): void;
    protected openFileUpload_(): void;
    protected onDeepSearchClick_(): void;
    protected onCreateImageClick_(): void;
    protected onAnimationEnd_(e: AnimationEvent, animationName: string): void;
    protected onMenuClose_(): void;
    private showMenuAtEntrypoint_;
}
declare global {
    interface HTMLElementTagNameMap {
        'cr-composebox-context-menu-entrypoint': ContextMenuEntrypointElement;
    }
}
export {};
