import '//resources/cr_elements/cr_icon_button/cr_icon_button.js';
import { CrLitElement } from '//resources/lit/v3_0/lit.rollup.js';
import type { AutocompleteMatch } from '//resources/mojo/components/omnibox/browser/searchbox.mojom-webui.js';
export interface ComposeboxMatchElement {
    $: {
        remove: HTMLElement;
        textContainer: HTMLElement;
    };
}
export declare class ComposeboxMatchElement extends CrLitElement {
    static get is(): string;
    static get styles(): import("//resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    render(): import("//resources/lit/v3_0/lit.rollup.js").TemplateResult<1>;
    static get properties(): {
        match: {
            type: ObjectConstructor;
        };
        /**
         * Index of the match in the autocomplete result. Used to inform embedder
         * of events such as deletion, click, etc.
         */
        matchIndex: {
            type: NumberConstructor;
        };
        inDeepSearchMode: {
            type: BooleanConstructor;
        };
        removeButtonTitle_: {
            type: StringConstructor;
        };
    };
    accessor match: AutocompleteMatch;
    accessor matchIndex: number;
    accessor inDeepSearchMode: boolean;
    private searchboxHandler_;
    protected accessor removeButtonTitle_: string;
    private resizeObserver_;
    constructor();
    connectedCallback(): void;
    disconnectedCallback(): void;
    private clampDeepSearchContents_;
    protected computeContents_(): string;
    protected computeRemoveButtonAriaLabel_(): string;
    protected iconPath_(): string;
    private onMatchFocusin_;
    private onMouseClick_;
    protected onRemoveButtonClick_(e: MouseEvent): void;
    protected onRemoveButtonMouseDown_(e: Event): void;
}
declare global {
    interface HTMLElementTagNameMap {
        'cr-composebox-match': ComposeboxMatchElement;
    }
}
