import './composebox_tool_chip.js';
import './context_menu_entrypoint.js';
import './contextual_entrypoint_and_carousel.js';
import './composebox_dropdown.js';
import './composebox_voice_search.js';
import './error_scrim.js';
import './file_carousel.js';
import './icons.html.js';
import '//resources/cr_components/localized_link/localized_link.js';
import '//resources/cr_components/search/animated_glow.js';
import '//resources/cr_elements/cr_icon_button/cr_icon_button.js';
import { GlowAnimationState } from '//resources/cr_components/search/constants.js';
import { DragAndDropHandler } from '//resources/cr_components/search/drag_drop_handler.js';
import type { DragAndDropHost } from '//resources/cr_components/search/drag_drop_host.js';
import type { CrIconButtonElement } from '//resources/cr_elements/cr_icon_button/cr_icon_button.js';
import type { PropertyValues } from '//resources/lit/v3_0/lit.rollup.js';
import { CrLitElement } from '//resources/lit/v3_0/lit.rollup.js';
import type { AutocompleteResult, SearchContext, SelectedFileInfo, TabInfo } from '//resources/mojo/components/omnibox/browser/searchbox.mojom-webui.js';
import type { UnguessableToken } from '//resources/mojo/mojo/public/mojom/base/unguessable_token.mojom-webui.js';
import type { Url } from '//resources/mojo/url/mojom/url.mojom-webui.js';
import type { ComposeboxFile, ContextualUpload } from './common.js';
import type { ComposeboxDropdownElement } from './composebox_dropdown.js';
import type { ComposeboxVoiceSearchElement } from './composebox_voice_search.js';
import type { ContextualEntrypointAndCarouselElement } from './contextual_entrypoint_and_carousel.js';
import { ComposeboxMode } from './contextual_entrypoint_and_carousel.js';
import type { ErrorScrimElement } from './error_scrim.js';
export declare enum VoiceSearchAction {
    ACTIVATE = 0,
    QUERY_SUBMITTED = 1
}
export interface ComposeboxElement {
    $: {
        cancelIcon: CrIconButtonElement;
        input: HTMLInputElement;
        composebox: HTMLElement;
        submitContainer: HTMLElement;
        submitOverlay: HTMLElement;
        matches: ComposeboxDropdownElement;
        context: ContextualEntrypointAndCarouselElement;
        errorScrim: ErrorScrimElement;
        voiceSearch: ComposeboxVoiceSearchElement;
    };
}
declare const ComposeboxElement_base: typeof CrLitElement & (new (...args: any[]) => import("//resources/cr_elements/i18n_mixin_lit.js").I18nMixinLitInterface);
export declare class ComposeboxElement extends ComposeboxElement_base implements DragAndDropHost {
    static get is(): string;
    static get styles(): import("//resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    render(): import("//resources/lit/v3_0/lit.rollup.js").TemplateResult<1>;
    static get properties(): {
        showLensButton: {
            type: BooleanConstructor;
        };
        lensButtonTriggersOverlay: {
            type: BooleanConstructor;
        };
        input_: {
            type: StringConstructor;
        };
        isCollapsible: {
            reflect: boolean;
            type: BooleanConstructor;
        };
        expanding_: {
            reflect: boolean;
            type: BooleanConstructor;
        };
        result_: {
            type: ObjectConstructor;
        };
        submitEnabled_: {
            reflect: boolean;
            type: BooleanConstructor;
        };
        /**
         * Index of the currently selected match, if any.
         * Do not modify this. Use <cr-composebox-dropdown> API to change
         * selection.
         */
        selectedMatchIndex_: {
            type: NumberConstructor;
        };
        showDropdown_: {
            reflect: boolean;
            type: BooleanConstructor;
        };
        showSubmit_: {
            reflect: boolean;
            type: BooleanConstructor;
        };
        animationState: {
            reflect: boolean;
            type: StringConstructor;
        };
        enableImageContextualSuggestions_: {
            reflect: boolean;
            type: BooleanConstructor;
        };
        inputPlaceholder_: {
            reflect: boolean;
            type: StringConstructor;
        };
        smartComposeEnabled_: {
            reflect: boolean;
            type: BooleanConstructor;
        };
        smartComposeInlineHint_: {
            type: StringConstructor;
        };
        showFileCarousel_: {
            reflect: boolean;
            type: BooleanConstructor;
        };
        inDeepSearchMode_: {
            reflect: boolean;
            type: BooleanConstructor;
        };
        isDraggingFile: {
            reflect: boolean;
            type: BooleanConstructor;
        };
        inCreateImageMode_: {
            reflect: boolean;
            type: BooleanConstructor;
        };
        /**
         * Feature flag for New Tab Page Realbox Next.
         */
        ntpRealboxNextEnabled: {
            type: BooleanConstructor;
        };
        /**
         * Generic flag indicating a "Next" searchbox (Realbox Next, Omnibox Next,
         * etc.). Used for all styling and behavior shared across 'Next' searchbox
         * implementations.
         */
        searchboxNextEnabled: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        tabSuggestions: {
            type: ArrayConstructor;
        };
        lensButtonDisabled: {
            reflect: boolean;
            type: BooleanConstructor;
        };
        errorScrimVisible_: {
            type: BooleanConstructor;
        };
        contextFilesSize_: {
            type: NumberConstructor;
            reflect: boolean;
        };
        searchboxLayoutMode: {
            type: StringConstructor;
            reflect: boolean;
        };
        carouselOnTop_: {
            type: BooleanConstructor;
        };
        inVoiceSearchMode_: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        entrypointName: {
            type: StringConstructor;
        };
        transcript_: {
            type: StringConstructor;
        };
        receivedSpeech_: {
            type: BooleanConstructor;
        };
        maxSuggestions: {
            type: NumberConstructor;
        };
        disableVoiceSearchAnimation: {
            type: BooleanConstructor;
        };
        disableCaretColorAnimation: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        disableComposeboxAnimation: {
            type: BooleanConstructor;
        };
        fileUploadsComplete: {
            type: BooleanConstructor;
        };
        canSubmitFilesAndInput_: {
            type: BooleanConstructor;
        };
    };
    accessor disableCaretColorAnimation: boolean;
    accessor disableComposeboxAnimation: boolean;
    accessor lensButtonTriggersOverlay: boolean;
    accessor fileUploadsComplete: boolean;
    accessor maxSuggestions: number | null;
    accessor showLensButton: boolean;
    accessor ntpRealboxNextEnabled: boolean;
    accessor searchboxNextEnabled: boolean;
    accessor searchboxLayoutMode: string;
    accessor carouselOnTop_: boolean;
    accessor isDraggingFile: boolean;
    accessor animationState: GlowAnimationState;
    accessor entrypointName: string;
    accessor disableVoiceSearchAnimation: boolean;
    accessor tabSuggestions: TabInfo[];
    accessor lensButtonDisabled: boolean;
    protected composeboxNoFlickerSuggestionsFix_: boolean;
    protected accessor isCollapsible: boolean;
    protected accessor expanding_: boolean;
    protected accessor input_: string;
    protected accessor showDropdown_: boolean;
    protected accessor showSubmit_: boolean;
    protected accessor enableImageContextualSuggestions_: boolean;
    protected accessor selectedMatchIndex_: number;
    protected accessor submitEnabled_: boolean;
    protected accessor result_: AutocompleteResult | null;
    protected accessor smartComposeInlineHint_: string;
    protected accessor smartComposeEnabled_: boolean;
    protected accessor inputPlaceholder_: string;
    protected accessor showFileCarousel_: boolean;
    protected accessor inCreateImageMode_: boolean;
    protected accessor inDeepSearchMode_: boolean;
    protected accessor errorScrimVisible_: boolean;
    protected accessor contextFilesSize_: number;
    protected accessor transcript_: string;
    protected accessor receivedSpeech_: boolean;
    protected accessor canSubmitFilesAndInput_: boolean;
    protected lastQueriedInput_: string;
    protected showVoiceSearchInSteadyComposebox_: boolean;
    protected showVoiceSearchInExpandedComposebox_: boolean;
    protected dragAndDropHandler_: DragAndDropHandler;
    private showTypedSuggest_;
    private showTypedSuggestWithContext_;
    private showZps;
    private browserProxy;
    private searchboxCallbackRouter_;
    private pageHandler_;
    private searchboxHandler_;
    private eventTracker_;
    private searchboxListenerIds;
    private resizeObservers_;
    private composeboxCloseByEscape_;
    private dragAndDropEnabled_;
    private clearAllInputsWhenSubmittingQuery_;
    private autoSubmitVoiceSearch;
    protected accessor inVoiceSearchMode_: boolean;
    private selectedMatch_;
    private haveReceivedAutcompleteResponse_;
    private isVoiceInput_;
    private pendingUploads_;
    constructor();
    connectedCallback(): void;
    private setupResizeObservers_;
    disconnectedCallback(): void;
    willUpdate(changedProperties: PropertyValues<this>): void;
    updated(changedProperties: PropertyValues<this>): void;
    getDropTarget(): ContextualEntrypointAndCarouselElement;
    focusInput(): void;
    getText(): string;
    get isVoiceInput(): boolean;
    playGlowAnimation(): void;
    setText(text: string): void;
    resetModes(): void;
    closeDropdown(): void;
    getSmartComposeForTesting(): string;
    getMatchesElement(): ComposeboxDropdownElement;
    getHasAutomaticActiveTabChipToken(): boolean;
    getAutomaticActiveTabChipElement(): HTMLElement | null;
    protected initializeState_(text?: string, files?: ContextualUpload[], mode?: ComposeboxMode): void;
    protected computeCancelButtonTitle_(): string;
    private computeShowDropdown_;
    private computeSubmitEnabled_;
    protected shouldShowSuggestionActivityLink_(): boolean;
    protected shouldShowSmartComposeInlineHint_(): boolean;
    protected shouldShowVoiceSearch_(): boolean;
    protected shouldShowVoiceSearchAnimation_(): boolean;
    protected onFileValidationError_(e: CustomEvent<{
        errorMessage: string;
    }>): void;
    protected onTranscriptUpdate_(e: CustomEvent<string>): void;
    protected onSpeechReceived_(): void;
    protected deleteContext_(e: CustomEvent<{
        uuid: UnguessableToken;
        fromAutoSuggestedChip?: boolean;
    }>): Promise<void>;
    protected addFileContext_(e: CustomEvent<{
        files: File[];
        onContextAdded: (files: Map<UnguessableToken, ComposeboxFile>) => void;
    }>): Promise<void>;
    protected addFileContextFromBrowser_(uuid: UnguessableToken, fileInfo: SelectedFileInfo): void;
    private updateAutoSuggestedTabContext_;
    protected addTabContext_(e: CustomEvent<{
        id: number;
        title: string;
        url: Url;
        delayUpload: boolean;
        onContextAdded: (file: ComposeboxFile) => void;
    }>): Promise<void>;
    protected onPaste_(event: ClipboardEvent): void;
    protected refreshTabSuggestions_(): Promise<void>;
    protected getTabPreview_(e: CustomEvent<{
        tabId: number;
        onPreviewFetched: (previewDataUrl: string) => void;
    }>): Promise<void>;
    protected voiceSearchEndCleanup_(): void;
    protected onVoiceSearchFinalResult_(e: CustomEvent<string>): Promise<void>;
    protected openAimVoiceSearch_(): void;
    protected onVoiceSearchClose_(): void;
    protected onCancelClick_(): void;
    handleEscapeKeyLogic(): void;
    private hasContent_;
    protected onLensClick_(): void;
    protected onOpenFileDialog_(e: CustomEvent<{
        isImage: boolean;
    }>): void;
    protected onLensIconMouseDown_(e: MouseEvent): void;
    private updateInputPlaceholder_;
    protected setDeepSearchMode_(e: CustomEvent<{
        inDeepSearchMode: boolean;
    }>): Promise<void>;
    protected setCreateImageMode_(e: CustomEvent<{
        inCreateImageMode: boolean;
        imagePresent: boolean;
    }>): Promise<void>;
    protected onErrorScrimVisibilityChanged_(e: CustomEvent<{
        showErrorScrim: boolean;
    }>): void;
    protected handleInput_(e: Event): void;
    protected onKeydown_(e: KeyboardEvent): void;
    protected handleInputFocusIn_(): void;
    protected handleInputFocusOut_(): void;
    protected handleComposeboxFocusIn_(e: FocusEvent): void;
    protected handleComposeboxFocusOut_(e: FocusEvent): void;
    protected handleScroll_(): void;
    protected handleSubmitFocusIn_(): void;
    addSearchContext(context: SearchContext | null): void;
    private closeComposebox_;
    protected submitQuery_(e: KeyboardEvent | MouseEvent): void;
    /**
     * @param e Event containing index of the match that received focus.
     */
    protected onMatchFocusin_(e: CustomEvent<{
        index: number;
    }>): void;
    protected onMatchClick_(): void;
    protected onSelectedMatchIndexChanged_(e: CustomEvent<{
        value: number;
    }>): void;
    /**
     * Clears the autocomplete result on the page and on the autocomplete backend.
     */
    clearAutocompleteMatches(): void;
    getRemainingFilesToUpload(): Set<string>;
    setPendingUploads(files: string[]): void;
    private onAutocompleteResultChanged_;
    private onContextualInputStatusChanged_;
    private adjustInputForSmartCompose;
    private queryAutocomplete;
    clearAllInputs(querySubmitted: boolean): void;
    clearInput(): void;
    getInputText(): string;
    private selectFirstMatch;
}
declare global {
    interface HTMLElementTagNameMap {
        'cr-composebox': ComposeboxElement;
    }
}
export {};
