// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
export var TabUploadOrigin;
(function (TabUploadOrigin) {
    TabUploadOrigin[TabUploadOrigin["CONTEXT_MENU"] = 0] = "CONTEXT_MENU";
    TabUploadOrigin[TabUploadOrigin["RECENT_TAB_CHIP"] = 1] = "RECENT_TAB_CHIP";
    TabUploadOrigin[TabUploadOrigin["ACTION_CHIP"] = 2] = "ACTION_CHIP";
    TabUploadOrigin[TabUploadOrigin["OTHER"] = 3] = "OTHER";
})(TabUploadOrigin || (TabUploadOrigin = {}));
// TODO(crbug.com/468329884): Consider making this a new contextual entry
// source so the realbox and composebox don't both get logged as NTP.
export function recordContextAdditionMethod(additionMethod, composeboxSource) {
    // In rare cases chrome.metricsPrivate is not available.
    if (!chrome.metricsPrivate) {
        return;
    }
    chrome.metricsPrivate.recordEnumerationValue('ContextualSearch.ContextAdded.ContextAddedMethod.' + composeboxSource, additionMethod, 3 /* ComposeboxContextAddedMethod.MAX_VALUE */ + 1);
}
