import { ComposeboxContextAddedMethod } from '//resources/cr_components/search/constants.js';
import type { UnguessableToken } from '//resources/mojo/mojo/public/mojom/base/unguessable_token.mojom-webui.js';
import type { Url } from '//resources/mojo/url/mojom/url.mojom-webui.js';
import type { FileUploadStatus } from './composebox_query.mojom-webui.js';
export interface ComposeboxFile {
    uuid: UnguessableToken;
    name: string;
    objectUrl: string | null;
    dataUrl: string | null;
    type: string;
    status: FileUploadStatus;
    url: Url | null;
    tabId: number | null;
    isDeletable: boolean;
}
export interface FileUpload {
    file: File;
}
export declare enum TabUploadOrigin {
    CONTEXT_MENU = 0,
    RECENT_TAB_CHIP = 1,
    ACTION_CHIP = 2,
    OTHER = 3
}
export interface TabUpload {
    tabId: number;
    url: Url;
    title: string;
    delayUpload: boolean;
    origin: TabUploadOrigin;
}
export type ContextualUpload = TabUpload | FileUpload;
export declare function recordContextAdditionMethod(additionMethod: ComposeboxContextAddedMethod, composeboxSource: string): void;
