// ui/webui/resources/js/tracked_element/tracked_element.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/webui/resources/js/tracked_element/tracked_element.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/webui/resources/js/tracked_element/tracked_element.mojom-params-data.h"
#include "ui/webui/resources/js/tracked_element/tracked_element.mojom-shared-message-ids.h"

#include "ui/webui/resources/js/tracked_element/tracked_element.mojom-import-headers.h"
#include "ui/webui/resources/js/tracked_element/tracked_element.mojom-test-utils.h"


namespace tracked_element::mojom {
// The declaration includes the definition on other builds.

TrackedElementHandler::IPCStableHashFunction TrackedElementHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::TrackedElementHandler>(message.name())) {
    case messages::TrackedElementHandler::kTrackedElementVisibilityChanged: {
      return &TrackedElementHandler::TrackedElementVisibilityChanged_Sym::IPCStableHash;
    }
    case messages::TrackedElementHandler::kTrackedElementActivated: {
      return &TrackedElementHandler::TrackedElementActivated_Sym::IPCStableHash;
    }
    case messages::TrackedElementHandler::kTrackedElementCustomEvent: {
      return &TrackedElementHandler::TrackedElementCustomEvent_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* TrackedElementHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::TrackedElementHandler>(message.name())) {
      case messages::TrackedElementHandler::kTrackedElementVisibilityChanged:
            return "Receive tracked_element::mojom::TrackedElementHandler::TrackedElementVisibilityChanged";
      case messages::TrackedElementHandler::kTrackedElementActivated:
            return "Receive tracked_element::mojom::TrackedElementHandler::TrackedElementActivated";
      case messages::TrackedElementHandler::kTrackedElementCustomEvent:
            return "Receive tracked_element::mojom::TrackedElementHandler::TrackedElementCustomEvent";
    }
  } else {
    switch (static_cast<messages::TrackedElementHandler>(message.name())) {
      case messages::TrackedElementHandler::kTrackedElementVisibilityChanged:
            return "Receive reply tracked_element::mojom::TrackedElementHandler::TrackedElementVisibilityChanged";
      case messages::TrackedElementHandler::kTrackedElementActivated:
            return "Receive reply tracked_element::mojom::TrackedElementHandler::TrackedElementActivated";
      case messages::TrackedElementHandler::kTrackedElementCustomEvent:
            return "Receive reply tracked_element::mojom::TrackedElementHandler::TrackedElementCustomEvent";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t TrackedElementHandler::TrackedElementVisibilityChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4a9b145d;  // IPCStableHash for tracked_element::mojom::TrackedElementHandler::TrackedElementVisibilityChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TrackedElementHandler::TrackedElementActivated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x71a1611d;  // IPCStableHash for tracked_element::mojom::TrackedElementHandler::TrackedElementActivated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TrackedElementHandler::TrackedElementCustomEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3d65a72e;  // IPCStableHash for tracked_element::mojom::TrackedElementHandler::TrackedElementCustomEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

TrackedElementHandlerProxy::TrackedElementHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void TrackedElementHandlerProxy::TrackedElementVisibilityChanged(
    const std::string& in_native_identifier, bool in_visible, const ::gfx::RectF& in_rect) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tracked_element::mojom::TrackedElementHandler::TrackedElementVisibilityChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("native_identifier"), in_native_identifier,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visible"), in_visible,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("rect"), in_rect,
                        "<value of type const ::gfx::RectF&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TrackedElementHandler::kTrackedElementVisibilityChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tracked_element::mojom::internal::TrackedElementHandler_TrackedElementVisibilityChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->native_identifier)::BaseType> native_identifier_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_native_identifier,
    native_identifier_fragment);

  params->native_identifier.Set(
      native_identifier_fragment.is_null() ? nullptr : native_identifier_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->native_identifier.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null native_identifier in TrackedElementHandler.TrackedElementVisibilityChanged request");

  params->visible = in_visible;
  mojo::internal::MessageFragment<
      typename decltype(params->rect)::BaseType> rect_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectFDataView>(
    in_rect,
    rect_fragment);

  params->rect.Set(
      rect_fragment.is_null() ? nullptr : rect_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->rect.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null rect in TrackedElementHandler.TrackedElementVisibilityChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TrackedElementHandler::Name_);
  message.set_method_name("TrackedElementVisibilityChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void TrackedElementHandlerProxy::TrackedElementActivated(
    const std::string& in_native_identifier) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tracked_element::mojom::TrackedElementHandler::TrackedElementActivated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("native_identifier"), in_native_identifier,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TrackedElementHandler::kTrackedElementActivated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tracked_element::mojom::internal::TrackedElementHandler_TrackedElementActivated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->native_identifier)::BaseType> native_identifier_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_native_identifier,
    native_identifier_fragment);

  params->native_identifier.Set(
      native_identifier_fragment.is_null() ? nullptr : native_identifier_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->native_identifier.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null native_identifier in TrackedElementHandler.TrackedElementActivated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TrackedElementHandler::Name_);
  message.set_method_name("TrackedElementActivated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void TrackedElementHandlerProxy::TrackedElementCustomEvent(
    const std::string& in_native_identifier, const std::string& in_custom_event_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tracked_element::mojom::TrackedElementHandler::TrackedElementCustomEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("native_identifier"), in_native_identifier,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("custom_event_name"), in_custom_event_name,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TrackedElementHandler::kTrackedElementCustomEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tracked_element::mojom::internal::TrackedElementHandler_TrackedElementCustomEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->native_identifier)::BaseType> native_identifier_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_native_identifier,
    native_identifier_fragment);

  params->native_identifier.Set(
      native_identifier_fragment.is_null() ? nullptr : native_identifier_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->native_identifier.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null native_identifier in TrackedElementHandler.TrackedElementCustomEvent request");
  mojo::internal::MessageFragment<
      typename decltype(params->custom_event_name)::BaseType> custom_event_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_custom_event_name,
    custom_event_name_fragment);

  params->custom_event_name.Set(
      custom_event_name_fragment.is_null() ? nullptr : custom_event_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->custom_event_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null custom_event_name in TrackedElementHandler.TrackedElementCustomEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TrackedElementHandler::Name_);
  message.set_method_name("TrackedElementCustomEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool TrackedElementHandlerStubDispatch::Accept(
    TrackedElementHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::TrackedElementHandler>(message->header()->name)) {
    case messages::TrackedElementHandler::kTrackedElementVisibilityChanged: {
      DCHECK(message->is_serialized());
      internal::TrackedElementHandler_TrackedElementVisibilityChanged_Params_Data* params =
          reinterpret_cast<internal::TrackedElementHandler_TrackedElementVisibilityChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for TrackedElementHandler.0
      bool success = true;
      std::string p_native_identifier{};
      bool p_visible{};
      ::gfx::RectF p_rect{};
      TrackedElementHandler_TrackedElementVisibilityChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNativeIdentifier(&p_native_identifier))
        success = false;
      if (success)
        p_visible = input_data_view.visible();
      if (success && !input_data_view.ReadRect(&p_rect))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TrackedElementHandler::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TrackedElementVisibilityChanged(        
        std::move(p_native_identifier), 
        std::move(p_visible), 
        std::move(p_rect));
      return true;
    }
    case messages::TrackedElementHandler::kTrackedElementActivated: {
      DCHECK(message->is_serialized());
      internal::TrackedElementHandler_TrackedElementActivated_Params_Data* params =
          reinterpret_cast<internal::TrackedElementHandler_TrackedElementActivated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for TrackedElementHandler.1
      bool success = true;
      std::string p_native_identifier{};
      TrackedElementHandler_TrackedElementActivated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNativeIdentifier(&p_native_identifier))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TrackedElementHandler::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TrackedElementActivated(        
        std::move(p_native_identifier));
      return true;
    }
    case messages::TrackedElementHandler::kTrackedElementCustomEvent: {
      DCHECK(message->is_serialized());
      internal::TrackedElementHandler_TrackedElementCustomEvent_Params_Data* params =
          reinterpret_cast<internal::TrackedElementHandler_TrackedElementCustomEvent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for TrackedElementHandler.2
      bool success = true;
      std::string p_native_identifier{};
      std::string p_custom_event_name{};
      TrackedElementHandler_TrackedElementCustomEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNativeIdentifier(&p_native_identifier))
        success = false;
      if (success && !input_data_view.ReadCustomEventName(&p_custom_event_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TrackedElementHandler::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TrackedElementCustomEvent(        
        std::move(p_native_identifier), 
        std::move(p_custom_event_name));
      return true;
    }
  }
  return false;
}

// static
bool TrackedElementHandlerStubDispatch::AcceptWithResponder(
    TrackedElementHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::TrackedElementHandler>(message->header()->name)) {
    case messages::TrackedElementHandler::kTrackedElementVisibilityChanged: {
      break;
    }
    case messages::TrackedElementHandler::kTrackedElementActivated: {
      break;
    }
    case messages::TrackedElementHandler::kTrackedElementCustomEvent: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kTrackedElementHandlerValidationInfo[] = {
    { &internal::TrackedElementHandler_TrackedElementVisibilityChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::TrackedElementHandler_TrackedElementActivated_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::TrackedElementHandler_TrackedElementCustomEvent_Params_Data::Validate,
     nullptr /* no response */},
};

bool TrackedElementHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::tracked_element::mojom::TrackedElementHandler::Name_,
    kTrackedElementHandlerValidationInfo);
}



}  // tracked_element::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace tracked_element::mojom {


void TrackedElementHandlerInterceptorForTesting::TrackedElementVisibilityChanged(const std::string& native_identifier, bool visible, const ::gfx::RectF& rect) {
  GetForwardingInterface()->TrackedElementVisibilityChanged(
    std::move(native_identifier)
    , 
    std::move(visible)
    , 
    std::move(rect)
    );
}
void TrackedElementHandlerInterceptorForTesting::TrackedElementActivated(const std::string& native_identifier) {
  GetForwardingInterface()->TrackedElementActivated(
    std::move(native_identifier)
    );
}
void TrackedElementHandlerInterceptorForTesting::TrackedElementCustomEvent(const std::string& native_identifier, const std::string& custom_event_name) {
  GetForwardingInterface()->TrackedElementCustomEvent(
    std::move(native_identifier)
    , 
    std::move(custom_event_name)
    );
}
TrackedElementHandlerAsyncWaiter::TrackedElementHandlerAsyncWaiter(
    TrackedElementHandler* proxy) : proxy_(proxy) {}

TrackedElementHandlerAsyncWaiter::~TrackedElementHandlerAsyncWaiter() = default;







}  // tracked_element::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif