// ui/webui/resources/js/tracked_element/tracked_element.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  RectFSpec as gfx_mojom_RectFSpec,
  RectF as gfx_mojom_RectF
} from '../../../../gfx/geometry/mojom/geometry.mojom-webui.js';







export type TrackedElementHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<TrackedElementHandlerPendingReceiver>;

export class TrackedElementHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<TrackedElementHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<TrackedElementHandlerPendingReceiver>;
  constructor(handle: MojoHandle|TrackedElementHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'tracked_element.mojom.TrackedElementHandler',
        scope);
  }
}

export interface TrackedElementHandlerInterface {
  trackedElementVisibilityChanged(nativeIdentifier: string, visible: boolean, rect: gfx_mojom_RectF): void;
  trackedElementActivated(nativeIdentifier: string): void;
  trackedElementCustomEvent(nativeIdentifier: string, customEventName: string): void;
}

export class TrackedElementHandlerRemote implements TrackedElementHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<TrackedElementHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<TrackedElementHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|TrackedElementHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          TrackedElementHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  trackedElementVisibilityChanged(
      nativeIdentifier: string,
      visible: boolean,
      rect: gfx_mojom_RectF): void {
    this.proxy.sendMessage(
        0,
        TrackedElementHandler_TrackedElementVisibilityChanged_ParamsSpec.$,
        null,
        [
          nativeIdentifier,
          visible,
          rect
        ],
        false);
  }

  trackedElementActivated(
      nativeIdentifier: string): void {
    this.proxy.sendMessage(
        1,
        TrackedElementHandler_TrackedElementActivated_ParamsSpec.$,
        null,
        [
          nativeIdentifier
        ],
        false);
  }

  trackedElementCustomEvent(
      nativeIdentifier: string,
      customEventName: string): void {
    this.proxy.sendMessage(
        2,
        TrackedElementHandler_TrackedElementCustomEvent_ParamsSpec.$,
        null,
        [
          nativeIdentifier,
          customEventName
        ],
        false);
  }
};

/**
 * An object which receives request messages for the TrackedElementHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class TrackedElementHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    TrackedElementHandlerRemote, TrackedElementHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    TrackedElementHandlerRemote, TrackedElementHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: TrackedElementHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        TrackedElementHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        TrackedElementHandler_TrackedElementVisibilityChanged_ParamsSpec.$,
        null,
        impl.trackedElementVisibilityChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        TrackedElementHandler_TrackedElementActivated_ParamsSpec.$,
        null,
        impl.trackedElementActivated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        TrackedElementHandler_TrackedElementCustomEvent_ParamsSpec.$,
        null,
        impl.trackedElementCustomEvent.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class TrackedElementHandler {
  static get $interfaceName(): string {
    return "tracked_element.mojom.TrackedElementHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): TrackedElementHandlerRemote {
    let remote = new TrackedElementHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the TrackedElementHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class TrackedElementHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    TrackedElementHandlerRemote, TrackedElementHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    TrackedElementHandlerRemote, TrackedElementHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  trackedElementVisibilityChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  trackedElementActivated: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  trackedElementCustomEvent: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      TrackedElementHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.trackedElementVisibilityChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        TrackedElementHandler_TrackedElementVisibilityChanged_ParamsSpec.$,
        null,
        this.trackedElementVisibilityChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.trackedElementActivated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        TrackedElementHandler_TrackedElementActivated_ParamsSpec.$,
        null,
        this.trackedElementActivated.createReceiverHandler(false /* expectsResponse */),
        false);
    this.trackedElementCustomEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        TrackedElementHandler_TrackedElementCustomEvent_ParamsSpec.$,
        null,
        this.trackedElementCustomEvent.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const TrackedElementHandler_TrackedElementVisibilityChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TrackedElementHandler_TrackedElementActivated_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TrackedElementHandler_TrackedElementCustomEvent_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface TrackedElementHandler_TrackedElementVisibilityChanged_ParamsMojoType {
  nativeIdentifier: string;
  visible: boolean;
  rect: gfx_mojom_RectF;
}


export type TrackedElementHandler_TrackedElementVisibilityChanged_Params = TrackedElementHandler_TrackedElementVisibilityChanged_ParamsMojoType;
mojo.internal.Struct<TrackedElementHandler_TrackedElementVisibilityChanged_ParamsMojoType>(
    TrackedElementHandler_TrackedElementVisibilityChanged_ParamsSpec.$,
    'TrackedElementHandler_TrackedElementVisibilityChanged_Params',
    [
      mojo.internal.StructField<TrackedElementHandler_TrackedElementVisibilityChanged_ParamsMojoType, string>(
        'nativeIdentifier', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TrackedElementHandler_TrackedElementVisibilityChanged_ParamsMojoType, boolean>(
        'visible', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TrackedElementHandler_TrackedElementVisibilityChanged_ParamsMojoType, gfx_mojom_RectF>(
        'rect', 16,
        0,
        gfx_mojom_RectFSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface TrackedElementHandler_TrackedElementActivated_ParamsMojoType {
  nativeIdentifier: string;
}


export type TrackedElementHandler_TrackedElementActivated_Params = TrackedElementHandler_TrackedElementActivated_ParamsMojoType;
mojo.internal.Struct<TrackedElementHandler_TrackedElementActivated_ParamsMojoType>(
    TrackedElementHandler_TrackedElementActivated_ParamsSpec.$,
    'TrackedElementHandler_TrackedElementActivated_Params',
    [
      mojo.internal.StructField<TrackedElementHandler_TrackedElementActivated_ParamsMojoType, string>(
        'nativeIdentifier', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface TrackedElementHandler_TrackedElementCustomEvent_ParamsMojoType {
  nativeIdentifier: string;
  customEventName: string;
}


export type TrackedElementHandler_TrackedElementCustomEvent_Params = TrackedElementHandler_TrackedElementCustomEvent_ParamsMojoType;
mojo.internal.Struct<TrackedElementHandler_TrackedElementCustomEvent_ParamsMojoType>(
    TrackedElementHandler_TrackedElementCustomEvent_ParamsSpec.$,
    'TrackedElementHandler_TrackedElementCustomEvent_Params',
    [
      mojo.internal.StructField<TrackedElementHandler_TrackedElementCustomEvent_ParamsMojoType, string>(
        'nativeIdentifier', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TrackedElementHandler_TrackedElementCustomEvent_ParamsMojoType, string>(
        'customEventName', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);



