// ui/webui/resources/js/metrics_reporter/metrics_reporter.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec,
  TimeDelta as mojoBase_mojom_TimeDelta
} from '//resources/mojo/mojo/public/mojom/base/time.mojom-webui.js';







export type PageMetricsHostPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageMetricsHostPendingReceiver>;

export class PageMetricsHostPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageMetricsHost> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageMetricsHostPendingReceiver>;
  constructor(handle: MojoHandle|PageMetricsHostPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'metrics_reporter.mojom.PageMetricsHost',
        scope);
  }
}

export interface PageMetricsHostInterface {
  onPageRemoteCreated(page: PageMetricsRemote): void;
  onGetMark(name: string): Promise<{
        markedTime: (mojoBase_mojom_TimeDelta | null), }>;
  onClearMark(name: string): void;
  onUmaReportTime(name: string, time: mojoBase_mojom_TimeDelta): void;
}

export class PageMetricsHostRemote implements PageMetricsHostInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageMetricsHostPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageMetricsHostPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageMetricsHostPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageMetricsHostPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  onPageRemoteCreated(
      page: PageMetricsRemote): void {
    this.proxy.sendMessage(
        0,
        PageMetricsHost_OnPageRemoteCreated_ParamsSpec.$,
        null,
        [
          page
        ],
        false);
  }

  onGetMark(
      name: string): Promise<{
        markedTime: (mojoBase_mojom_TimeDelta | null), }> {
    return this.proxy.sendMessage(
        1,
        PageMetricsHost_OnGetMark_ParamsSpec.$,
        PageMetricsHost_OnGetMark_ResponseParamsSpec.$,
        [
          name
        ],
        false);
  }

  onClearMark(
      name: string): void {
    this.proxy.sendMessage(
        2,
        PageMetricsHost_OnClearMark_ParamsSpec.$,
        null,
        [
          name
        ],
        false);
  }

  onUmaReportTime(
      name: string,
      time: mojoBase_mojom_TimeDelta): void {
    this.proxy.sendMessage(
        3,
        PageMetricsHost_OnUmaReportTime_ParamsSpec.$,
        null,
        [
          name,
          time
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageMetricsHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageMetricsHostReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageMetricsHostRemote, PageMetricsHostPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageMetricsHostRemote, PageMetricsHostPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageMetricsHostInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageMetricsHostRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageMetricsHost_OnPageRemoteCreated_ParamsSpec.$,
        null,
        impl.onPageRemoteCreated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PageMetricsHost_OnGetMark_ParamsSpec.$,
        PageMetricsHost_OnGetMark_ResponseParamsSpec.$,
        impl.onGetMark.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        PageMetricsHost_OnClearMark_ParamsSpec.$,
        null,
        impl.onClearMark.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        PageMetricsHost_OnUmaReportTime_ParamsSpec.$,
        null,
        impl.onUmaReportTime.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageMetricsHost {
  static get $interfaceName(): string {
    return "metrics_reporter.mojom.PageMetricsHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageMetricsHostRemote {
    let remote = new PageMetricsHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageMetricsHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageMetricsHostCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageMetricsHostRemote, PageMetricsHostPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageMetricsHostRemote, PageMetricsHostPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  onPageRemoteCreated: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onGetMark: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onClearMark: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onUmaReportTime: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageMetricsHostRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.onPageRemoteCreated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageMetricsHost_OnPageRemoteCreated_ParamsSpec.$,
        null,
        this.onPageRemoteCreated.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onGetMark =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PageMetricsHost_OnGetMark_ParamsSpec.$,
        PageMetricsHost_OnGetMark_ResponseParamsSpec.$,
        this.onGetMark.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onClearMark =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        PageMetricsHost_OnClearMark_ParamsSpec.$,
        null,
        this.onClearMark.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onUmaReportTime =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        PageMetricsHost_OnUmaReportTime_ParamsSpec.$,
        null,
        this.onUmaReportTime.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PageMetricsPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageMetricsPendingReceiver>;

export class PageMetricsPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageMetrics> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageMetricsPendingReceiver>;
  constructor(handle: MojoHandle|PageMetricsPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'metrics_reporter.mojom.PageMetrics',
        scope);
  }
}

export interface PageMetricsInterface {
  onGetMark(name: string): Promise<{
        markedTime: (mojoBase_mojom_TimeDelta | null), }>;
  onClearMark(name: string): void;
}

export class PageMetricsRemote implements PageMetricsInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageMetricsPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageMetricsPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageMetricsPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageMetricsPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  onGetMark(
      name: string): Promise<{
        markedTime: (mojoBase_mojom_TimeDelta | null), }> {
    return this.proxy.sendMessage(
        0,
        PageMetrics_OnGetMark_ParamsSpec.$,
        PageMetrics_OnGetMark_ResponseParamsSpec.$,
        [
          name
        ],
        false);
  }

  onClearMark(
      name: string): void {
    this.proxy.sendMessage(
        1,
        PageMetrics_OnClearMark_ParamsSpec.$,
        null,
        [
          name
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageMetrics
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageMetricsReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageMetricsRemote, PageMetricsPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageMetricsRemote, PageMetricsPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageMetricsInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageMetricsRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageMetrics_OnGetMark_ParamsSpec.$,
        PageMetrics_OnGetMark_ResponseParamsSpec.$,
        impl.onGetMark.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PageMetrics_OnClearMark_ParamsSpec.$,
        null,
        impl.onClearMark.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageMetrics {
  static get $interfaceName(): string {
    return "metrics_reporter.mojom.PageMetrics";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageMetricsRemote {
    let remote = new PageMetricsRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageMetrics
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageMetricsCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageMetricsRemote, PageMetricsPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageMetricsRemote, PageMetricsPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  onGetMark: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onClearMark: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageMetricsRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.onGetMark =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageMetrics_OnGetMark_ParamsSpec.$,
        PageMetrics_OnGetMark_ResponseParamsSpec.$,
        this.onGetMark.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onClearMark =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PageMetrics_OnClearMark_ParamsSpec.$,
        null,
        this.onClearMark.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const PageMetricsHost_OnPageRemoteCreated_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageMetricsHost_OnGetMark_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageMetricsHost_OnGetMark_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageMetricsHost_OnClearMark_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageMetricsHost_OnUmaReportTime_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageMetrics_OnGetMark_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageMetrics_OnGetMark_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageMetrics_OnClearMark_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface PageMetricsHost_OnPageRemoteCreated_ParamsMojoType {
  page: PageMetricsRemote;
}


export type PageMetricsHost_OnPageRemoteCreated_Params = PageMetricsHost_OnPageRemoteCreated_ParamsMojoType;
mojo.internal.Struct<PageMetricsHost_OnPageRemoteCreated_ParamsMojoType>(
    PageMetricsHost_OnPageRemoteCreated_ParamsSpec.$,
    'PageMetricsHost_OnPageRemoteCreated_Params',
    [
      mojo.internal.StructField<PageMetricsHost_OnPageRemoteCreated_ParamsMojoType, PageMetricsRemote>(
        'page', 0,
        0,
        mojo.internal.InterfaceProxy(PageMetricsRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageMetricsHost_OnGetMark_ParamsMojoType {
  name: string;
}


export type PageMetricsHost_OnGetMark_Params = PageMetricsHost_OnGetMark_ParamsMojoType;
mojo.internal.Struct<PageMetricsHost_OnGetMark_ParamsMojoType>(
    PageMetricsHost_OnGetMark_ParamsSpec.$,
    'PageMetricsHost_OnGetMark_Params',
    [
      mojo.internal.StructField<PageMetricsHost_OnGetMark_ParamsMojoType, string>(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageMetricsHost_OnGetMark_ResponseParamsMojoType {
  markedTime: (mojoBase_mojom_TimeDelta | null);
}


export type PageMetricsHost_OnGetMark_ResponseParams = PageMetricsHost_OnGetMark_ResponseParamsMojoType;
mojo.internal.Struct<PageMetricsHost_OnGetMark_ResponseParamsMojoType>(
    PageMetricsHost_OnGetMark_ResponseParamsSpec.$,
    'PageMetricsHost_OnGetMark_ResponseParams',
    [
      mojo.internal.StructField<PageMetricsHost_OnGetMark_ResponseParamsMojoType, mojoBase_mojom_TimeDelta>(
        'markedTime', 0,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageMetricsHost_OnClearMark_ParamsMojoType {
  name: string;
}


export type PageMetricsHost_OnClearMark_Params = PageMetricsHost_OnClearMark_ParamsMojoType;
mojo.internal.Struct<PageMetricsHost_OnClearMark_ParamsMojoType>(
    PageMetricsHost_OnClearMark_ParamsSpec.$,
    'PageMetricsHost_OnClearMark_Params',
    [
      mojo.internal.StructField<PageMetricsHost_OnClearMark_ParamsMojoType, string>(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageMetricsHost_OnUmaReportTime_ParamsMojoType {
  name: string;
  time: mojoBase_mojom_TimeDelta;
}


export type PageMetricsHost_OnUmaReportTime_Params = PageMetricsHost_OnUmaReportTime_ParamsMojoType;
mojo.internal.Struct<PageMetricsHost_OnUmaReportTime_ParamsMojoType>(
    PageMetricsHost_OnUmaReportTime_ParamsSpec.$,
    'PageMetricsHost_OnUmaReportTime_Params',
    [
      mojo.internal.StructField<PageMetricsHost_OnUmaReportTime_ParamsMojoType, string>(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageMetricsHost_OnUmaReportTime_ParamsMojoType, mojoBase_mojom_TimeDelta>(
        'time', 8,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageMetrics_OnGetMark_ParamsMojoType {
  name: string;
}


export type PageMetrics_OnGetMark_Params = PageMetrics_OnGetMark_ParamsMojoType;
mojo.internal.Struct<PageMetrics_OnGetMark_ParamsMojoType>(
    PageMetrics_OnGetMark_ParamsSpec.$,
    'PageMetrics_OnGetMark_Params',
    [
      mojo.internal.StructField<PageMetrics_OnGetMark_ParamsMojoType, string>(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageMetrics_OnGetMark_ResponseParamsMojoType {
  markedTime: (mojoBase_mojom_TimeDelta | null);
}


export type PageMetrics_OnGetMark_ResponseParams = PageMetrics_OnGetMark_ResponseParamsMojoType;
mojo.internal.Struct<PageMetrics_OnGetMark_ResponseParamsMojoType>(
    PageMetrics_OnGetMark_ResponseParamsSpec.$,
    'PageMetrics_OnGetMark_ResponseParams',
    [
      mojo.internal.StructField<PageMetrics_OnGetMark_ResponseParamsMojoType, mojoBase_mojom_TimeDelta>(
        'markedTime', 0,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageMetrics_OnClearMark_ParamsMojoType {
  name: string;
}


export type PageMetrics_OnClearMark_Params = PageMetrics_OnClearMark_ParamsMojoType;
mojo.internal.Struct<PageMetrics_OnClearMark_ParamsMojoType>(
    PageMetrics_OnClearMark_ParamsSpec.$,
    'PageMetrics_OnClearMark_Params',
    [
      mojo.internal.StructField<PageMetrics_OnClearMark_ParamsMojoType, string>(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);



