// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assert}from"//resources/js/assert.js";import{focusWithoutInk}from"//resources/js/focus_without_ink.js";import{FocusRow,VirtualFocusRow}from"//resources/js/focus_row.js";import{FocusRowMixinDelegate}from"./focus_row_mixin_delegate.js";export const FocusRowMixinLit=superClass=>{class FocusRowMixinLit extends superClass{static get properties(){return{row_:{type:Object},mouseFocused_:{type:Boolean},id:{type:String,reflect:true},isFocused:{type:Boolean,notify:true},focusRowIndex:{type:Number},lastFocused:{type:Object,notify:true},listTabIndex:{type:Number},listBlurred:{type:Boolean,notify:true}}}#row__accessor_storage=null;get row_(){return this.#row__accessor_storage}set row_(value){this.#row__accessor_storage=value}#mouseFocused__accessor_storage=false;get mouseFocused_(){return this.#mouseFocused__accessor_storage}set mouseFocused_(value){this.#mouseFocused__accessor_storage=value}#isFocused_accessor_storage=false;get isFocused(){return this.#isFocused_accessor_storage}set isFocused(value){this.#isFocused_accessor_storage=value}#focusRowIndex_accessor_storage;get focusRowIndex(){return this.#focusRowIndex_accessor_storage}set focusRowIndex(value){this.#focusRowIndex_accessor_storage=value}#lastFocused_accessor_storage=null;get lastFocused(){return this.#lastFocused_accessor_storage}set lastFocused(value){this.#lastFocused_accessor_storage=value}#listTabIndex_accessor_storage;get listTabIndex(){return this.#listTabIndex_accessor_storage}set listTabIndex(value){this.#listTabIndex_accessor_storage=value}#listBlurred_accessor_storage=false;get listBlurred(){return this.#listBlurred_accessor_storage}set listBlurred(value){this.#listBlurred_accessor_storage=value}firstControl_=null;controlObservers_=[];subtreeObserver_=null;boundOnFirstControlKeydown_=null;connectedCallback(){super.connectedCallback();this.classList.add("no-outline");this.boundOnFirstControlKeydown_=this.onFirstControlKeydown_.bind(this);this.updateComplete.then((()=>{const rowContainer=this.shadowRoot.querySelector("[focus-row-container]");assert(rowContainer);this.row_=new VirtualFocusRow(rowContainer,new FocusRowMixinDelegate(this));this.addItems_();this.addEventListener("focus",this.onFocus_);this.subtreeObserver_=new MutationObserver((()=>this.addItems_()));this.subtreeObserver_.observe(this.shadowRoot,{childList:true,subtree:true});this.addEventListener("mousedown",this.onMouseDown_);this.addEventListener("blur",this.onBlur_)}))}disconnectedCallback(){super.disconnectedCallback();this.removeEventListener("focus",this.onFocus_);if(this.subtreeObserver_){this.subtreeObserver_.disconnect();this.subtreeObserver_=null}this.removeEventListener("mousedown",this.onMouseDown_);this.removeEventListener("blur",this.onBlur_);this.removeObservers_();if(this.firstControl_&&this.boundOnFirstControlKeydown_){this.firstControl_.removeEventListener("keydown",this.boundOnFirstControlKeydown_);this.boundOnFirstControlKeydown_=null}if(this.row_){this.row_.destroy()}}willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("focusRowIndex")&&this.focusRowIndex!==undefined){this.setAttribute("aria-rowindex",(this.focusRowIndex+1).toString());const oldIndex=changedProperties.get("focusRowIndex");if(this.id===this.computeId_(oldIndex)){this.id=this.computeId_(this.focusRowIndex)||""}}}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("listTabIndex")){this.listTabIndexChanged_()}}computeId_(index){return index!==undefined?`frb${index}`:undefined}getFocusRow(){assert(this.row_);return this.row_}updateFirstControl_(){assert(this.row_);const newFirstControl=this.row_.getFirstFocusable();if(newFirstControl===this.firstControl_){return}if(this.firstControl_){this.firstControl_.removeEventListener("keydown",this.boundOnFirstControlKeydown_)}this.firstControl_=newFirstControl;if(this.firstControl_){this.firstControl_.addEventListener("keydown",this.boundOnFirstControlKeydown_)}}removeObservers_(){if(this.controlObservers_.length>0){this.controlObservers_.forEach((observer=>{observer.disconnect()}))}this.controlObservers_=[]}addItems_(){this.listTabIndexChanged_();if(this.row_){this.removeObservers_();this.row_.destroy();const controls=this.shadowRoot.querySelectorAll("[focus-row-control]");controls.forEach((control=>{assert(control);assert(this.row_);this.row_.addItem(control.getAttribute("focus-type"),FocusRow.getFocusableElement(control));this.addMutationObservers_(control)}));this.updateFirstControl_()}}createObserver_(){return new MutationObserver((mutations=>{const mutation=mutations[0];if(mutation.attributeName==="style"&&mutation.oldValue){const newStyle=window.getComputedStyle(mutation.target);const oldDisplayValue=mutation.oldValue.match(/^display:(.*)(?=;)/);const oldVisibilityValue=mutation.oldValue.match(/^visibility:(.*)(?=;)/);if(oldDisplayValue&&newStyle.display===oldDisplayValue[1].trim()&&oldVisibilityValue&&newStyle.visibility===oldVisibilityValue[1].trim()){return}}this.updateFirstControl_()}))}addMutationObservers_(control){let current=control;while(current&&current!==this.shadowRoot){const currentObserver=this.createObserver_();currentObserver.observe(current,{attributes:true,attributeFilter:["hidden","disabled","style"],attributeOldValue:true});this.controlObservers_.push(currentObserver);current=current.parentNode}}onFocus_(e){if(this.mouseFocused_){this.mouseFocused_=false;return}const restoreFocusToFirst=this.listBlurred&&e.composedPath()[0]===this;if(this.lastFocused&&!restoreFocusToFirst){assert(this.row_);focusWithoutInk(this.row_.getEquivalentElement(this.lastFocused))}else{assert(this.firstControl_);const firstFocusable=this.firstControl_;focusWithoutInk(firstFocusable)}this.listBlurred=false;this.isFocused=true}onFirstControlKeydown_(e){const keyEvent=e;if(keyEvent.shiftKey&&keyEvent.key==="Tab"){this.focus()}}listTabIndexChanged_(){if(this.row_){this.row_.makeActive(this.listTabIndex===0)}if(this.listTabIndex===0){this.listBlurred=false}}onMouseDown_(){this.mouseFocused_=true}onBlur_(e){this.mouseFocused_=false;this.isFocused=false;const node=e.relatedTarget?e.relatedTarget:null;if(!this.parentNode.contains(node)){this.listBlurred=true}}}return FocusRowMixinLit};