// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assert}from"//resources/js/assert.js";import{EventTracker}from"//resources/js/event_tracker.js";import{CrLitElement}from"//resources/lit/v3_0/lit.rollup.js";import{CrRippleMixin}from"../cr_ripple/cr_ripple_mixin.js";import{getCss}from"./cr_slider.css.js";import{getHtml}from"./cr_slider.html.js";function clamp(min,max,value){return Math.min(max,Math.max(min,value))}function getAriaValue(tick){if(Number.isFinite(tick)){return tick}const sliderTick=tick;return sliderTick.ariaValue!==undefined?sliderTick.ariaValue:sliderTick.value}const CrSliderElementBase=CrRippleMixin(CrLitElement);export class CrSliderElement extends CrSliderElementBase{static get is(){return"cr-slider"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{disabled:{type:Boolean},disabled_:{type:Boolean,reflect:true},dragging:{type:Boolean,notify:true},updatingFromKey:{type:Boolean,notify:true},keyPressSliderIncrement:{type:Number},markerCount:{type:Number},max:{type:Number},min:{type:Number},noKeybindings:{type:Boolean},snaps:{type:Boolean},ticks:{type:Array},value:{type:Number},label_:{type:String,state:true},showLabel_:{type:Boolean,reflect:true},transiting_:{type:Boolean,reflect:true}}}#disabled_accessor_storage=false;get disabled(){return this.#disabled_accessor_storage}set disabled(value){this.#disabled_accessor_storage=value}#dragging_accessor_storage=false;get dragging(){return this.#dragging_accessor_storage}set dragging(value){this.#dragging_accessor_storage=value}#updatingFromKey_accessor_storage=false;get updatingFromKey(){return this.#updatingFromKey_accessor_storage}set updatingFromKey(value){this.#updatingFromKey_accessor_storage=value}#keyPressSliderIncrement_accessor_storage=1;get keyPressSliderIncrement(){return this.#keyPressSliderIncrement_accessor_storage}set keyPressSliderIncrement(value){this.#keyPressSliderIncrement_accessor_storage=value}#markerCount_accessor_storage=0;get markerCount(){return this.#markerCount_accessor_storage}set markerCount(value){this.#markerCount_accessor_storage=value}#max_accessor_storage=100;get max(){return this.#max_accessor_storage}set max(value){this.#max_accessor_storage=value}#min_accessor_storage=0;get min(){return this.#min_accessor_storage}set min(value){this.#min_accessor_storage=value}#noKeybindings_accessor_storage=false;get noKeybindings(){return this.#noKeybindings_accessor_storage}set noKeybindings(value){this.#noKeybindings_accessor_storage=value}#snaps_accessor_storage=false;get snaps(){return this.#snaps_accessor_storage}set snaps(value){this.#snaps_accessor_storage=value}#ticks_accessor_storage=[];get ticks(){return this.#ticks_accessor_storage}set ticks(value){this.#ticks_accessor_storage=value}#value_accessor_storage=0;get value(){return this.#value_accessor_storage}set value(value){this.#value_accessor_storage=value}#disabled__accessor_storage=false;get disabled_(){return this.#disabled__accessor_storage}set disabled_(value){this.#disabled__accessor_storage=value}#label__accessor_storage="";get label_(){return this.#label__accessor_storage}set label_(value){this.#label__accessor_storage=value}#showLabel__accessor_storage=false;get showLabel_(){return this.#showLabel__accessor_storage}set showLabel_(value){this.#showLabel__accessor_storage=value}#transiting__accessor_storage=false;get transiting_(){return this.#transiting__accessor_storage}set transiting_(value){this.#transiting__accessor_storage=value}deltaKeyMap_=null;draggingEventTracker_=null;firstUpdated(){this.setAttribute("role","slider");this.addEventListener("blur",this.hideRipple_);this.addEventListener("focus",this.showRipple_);this.addEventListener("keydown",this.onKeyDown_);this.addEventListener("keyup",this.onKeyUp_);this.addEventListener("pointerdown",this.onPointerDown_.bind(this))}connectedCallback(){super.connectedCallback();this.draggingEventTracker_=new EventTracker}willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("keyPressSliderIncrement")){this.onKeyPressSliderIncrementChanged_()}if(changedProperties.has("value")||changedProperties.has("min")||changedProperties.has("max")){if(this.value!==undefined){this.updateValue_(this.value)}}if(changedProperties.has("disabled")||changedProperties.has("ticks")){this.disabled_=this.disabled||this.ticks.length===1}if(changedProperties.has("ticks")){if(this.ticks.length>1){this.snaps=true;this.max=this.ticks.length-1;this.min=0}}}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("disabled_")){this.setAttribute("tabindex",this.disabled_?"-1":"0");this.blur()}if(changedProperties.has("ticks")){if(this.value!==undefined){this.updateValue_(this.value)}}if(changedProperties.has("value")||changedProperties.has("min")||changedProperties.has("max")||changedProperties.has("ticks")){this.updateUi_()}}getMarkers_(){const array=Array.from({length:Math.max(0,this.markerCount-1)});array.fill(0);return array}getMarkerClass_(index){const currentStep=(this.markerCount-1)*this.getRatio();return index<currentStep?"active-marker":"inactive-marker"}getRatio(){return(this.value-this.min)/(this.max-this.min)}stopDragging_(pointerId){this.draggingEventTracker_.removeAll();this.releasePointerCapture(pointerId);this.dragging=false;this.hideRipple_()}hideRipple_(){if(this.noink){return}this.getRipple().clear();this.showLabel_=false}showRipple_(){if(this.noink){return}if(!this.getRipple().holdDown){this.getRipple().showAndHoldDown()}this.showLabel_=true}onKeyDown_(event){if(this.disabled_||this.noKeybindings){return}if(event.metaKey||event.shiftKey||event.altKey||event.ctrlKey){return}let newValue;if(event.key==="Home"){newValue=this.min}else if(event.key==="End"){newValue=this.max}else if(this.deltaKeyMap_.has(event.key)){newValue=this.value+this.deltaKeyMap_.get(event.key)}if(newValue===undefined){return}this.updatingFromKey=true;if(this.updateValue_(newValue)){this.fire("cr-slider-value-changed")}event.preventDefault();event.stopPropagation();this.showRipple_()}onKeyUp_(event){if(event.key==="Home"||event.key==="End"||this.deltaKeyMap_.has(event.key)){setTimeout((()=>{this.updatingFromKey=false}))}}onPointerDown_(event){if(this.disabled_||event.buttons!==1&&event.pointerType==="mouse"){return}this.dragging=true;this.transiting_=true;this.updateValueFromClientX_(event.clientX);this.showRipple_();this.setPointerCapture(event.pointerId);const stopDragging=this.stopDragging_.bind(this,event.pointerId);assert(!!this.draggingEventTracker_);this.draggingEventTracker_.add(this,"pointermove",(e=>{e.preventDefault();if(e.buttons!==1&&e.pointerType==="mouse"){stopDragging();return}this.updateValueFromClientX_(e.clientX)}));this.draggingEventTracker_.add(this,"pointercancel",stopDragging);this.draggingEventTracker_.add(this,"pointerdown",stopDragging);this.draggingEventTracker_.add(this,"pointerup",stopDragging);this.draggingEventTracker_.add(this,"keydown",(e=>{if(e.key==="Escape"||e.key==="Tab"||e.key==="Home"||e.key==="End"||this.deltaKeyMap_.has(e.key)){stopDragging()}}))}onTransitionEnd_(){this.transiting_=false}updateUi_(){const percent=`${this.getRatio()*100}%`;this.$.bar.style.width=percent;this.$.knobAndLabel.style.marginInlineStart=percent;const ticks=this.ticks;const value=this.value;if(ticks&&ticks.length>0&&Number.isInteger(value)&&value>=0&&value<ticks.length){const tick=ticks[this.value];this.label_=Number.isFinite(tick)?"":tick.label;const ariaValueNow=getAriaValue(tick);this.setAttribute("aria-valuetext",String(this.label_||ariaValueNow));this.setAttribute("aria-valuenow",ariaValueNow.toString());this.setAttribute("aria-valuemin",getAriaValue(ticks[0]).toString());this.setAttribute("aria-valuemax",getAriaValue(ticks.slice(-1)[0]).toString())}else{this.setAttribute("aria-valuetext",value!==undefined?value.toString():"");this.setAttribute("aria-valuenow",value!==undefined?value.toString():"");this.setAttribute("aria-valuemin",this.min.toString());this.setAttribute("aria-valuemax",this.max.toString())}}updateValue_(value){if(this.snaps){if(Math.abs(this.value-value)<.8){return false}value=Math.round(value)}value=clamp(this.min,this.max,value);if(this.value===value){return false}this.value=value;return true}isRtl_(){return this.matches(":host-context([dir=rtl]) cr-slider")}updateValueFromClientX_(clientX){const rect=this.$.container.getBoundingClientRect();let ratio=(clientX-rect.left)/rect.width;if(this.isRtl_()){ratio=1-ratio}if(this.updateValue_(ratio*(this.max-this.min)+this.min)){this.fire("cr-slider-value-changed")}}onKeyPressSliderIncrementChanged_(){const isRtl=this.isRtl_();const increment=this.keyPressSliderIncrement;const decrement=-this.keyPressSliderIncrement;this.deltaKeyMap_=new Map([["ArrowDown",decrement],["ArrowUp",increment],["PageDown",decrement],["PageUp",increment],["ArrowLeft",isRtl?increment:decrement],["ArrowRight",isRtl?decrement:increment]])}createRipple(){this.rippleContainer=this.$.knob;const ripple=super.createRipple();ripple.setAttribute("recenters","");ripple.classList.add("circle");return ripple}}customElements.define(CrSliderElement.is,CrSliderElement);