// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"../cr_icon_button/cr_icon_button.js";import{assert}from"//resources/js/assert.js";import{CrLitElement}from"//resources/lit/v3_0/lit.rollup.js";import{getCss}from"./cr_dialog.css.js";import{getHtml}from"./cr_dialog.html.js";export class CrDialogElement extends CrLitElement{static get is(){return"cr-dialog"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{open:{type:Boolean,reflect:true},closeText:{type:String},ignorePopstate:{type:Boolean},ignoreEnterKey:{type:Boolean},consumeKeydownEvent:{type:Boolean},noCancel:{type:Boolean},showCloseButton:{type:Boolean},showOnAttach:{type:Boolean},ariaDescriptionText:{type:String}}}#closeText_accessor_storage;get closeText(){return this.#closeText_accessor_storage}set closeText(value){this.#closeText_accessor_storage=value}#consumeKeydownEvent_accessor_storage=false;get consumeKeydownEvent(){return this.#consumeKeydownEvent_accessor_storage}set consumeKeydownEvent(value){this.#consumeKeydownEvent_accessor_storage=value}#ignoreEnterKey_accessor_storage=false;get ignoreEnterKey(){return this.#ignoreEnterKey_accessor_storage}set ignoreEnterKey(value){this.#ignoreEnterKey_accessor_storage=value}#ignorePopstate_accessor_storage=false;get ignorePopstate(){return this.#ignorePopstate_accessor_storage}set ignorePopstate(value){this.#ignorePopstate_accessor_storage=value}#noCancel_accessor_storage=false;get noCancel(){return this.#noCancel_accessor_storage}set noCancel(value){this.#noCancel_accessor_storage=value}#open_accessor_storage=false;get open(){return this.#open_accessor_storage}set open(value){this.#open_accessor_storage=value}#showCloseButton_accessor_storage=false;get showCloseButton(){return this.#showCloseButton_accessor_storage}set showCloseButton(value){this.#showCloseButton_accessor_storage=value}#showOnAttach_accessor_storage=false;get showOnAttach(){return this.#showOnAttach_accessor_storage}set showOnAttach(value){this.#showOnAttach_accessor_storage=value}#ariaDescriptionText_accessor_storage;get ariaDescriptionText(){return this.#ariaDescriptionText_accessor_storage}set ariaDescriptionText(value){this.#ariaDescriptionText_accessor_storage=value}mutationObserver_=null;boundKeydown_=null;firstUpdated(){window.addEventListener("popstate",(()=>{if(!this.ignorePopstate&&this.$.dialog.open){this.cancel()}}));if(!this.ignoreEnterKey){this.addEventListener("keypress",this.onKeypress_.bind(this))}this.addEventListener("pointerdown",(e=>this.onPointerdown_(e)))}connectedCallback(){super.connectedCallback();const mutationObserverCallback=()=>{if(this.$.dialog.open){this.addKeydownListener_()}else{this.removeKeydownListener_()}};this.mutationObserver_=new MutationObserver(mutationObserverCallback);this.mutationObserver_.observe(this.$.dialog,{attributes:true,attributeFilter:["open"]});mutationObserverCallback();if(this.showOnAttach){this.showModal()}}disconnectedCallback(){super.disconnectedCallback();this.removeKeydownListener_();if(this.mutationObserver_){this.mutationObserver_.disconnect();this.mutationObserver_=null}}addKeydownListener_(){if(!this.consumeKeydownEvent){return}this.boundKeydown_=this.boundKeydown_||this.onKeydown_.bind(this);this.addEventListener("keydown",this.boundKeydown_);document.body.addEventListener("keydown",this.boundKeydown_)}removeKeydownListener_(){if(!this.boundKeydown_){return}this.removeEventListener("keydown",this.boundKeydown_);document.body.removeEventListener("keydown",this.boundKeydown_);this.boundKeydown_=null}async showModal(){if(this.showOnAttach){const element=this.querySelector("[autofocus]");if(element&&element instanceof CrLitElement&&!element.shadowRoot){element.ensureInitialRender()}}this.$.dialog.showModal();assert(this.$.dialog.open);this.open=true;await this.updateComplete;this.fire("cr-dialog-open")}cancel(){this.fire("cancel");this.$.dialog.close();assert(!this.$.dialog.open);this.open=false}close(){this.$.dialog.close("success");assert(!this.$.dialog.open);this.open=false}setTitleAriaLabel(title){this.$.dialog.removeAttribute("aria-labelledby");this.$.dialog.setAttribute("aria-label",title)}onCloseKeypress_(e){e.stopPropagation()}onNativeDialogClose_(e){if(e.target!==this.getNative()){return}this.fire("close")}async onNativeDialogCancel_(e){if(e.target!==this.getNative()){return}if(this.noCancel){e.preventDefault();return}this.open=false;await this.updateComplete;this.fire("cancel")}getNative(){return this.$.dialog}onKeypress_(e){if(e.key!=="Enter"){return}const accept=e.target===this||e.composedPath().some((el=>el.tagName==="CR-INPUT"&&el.type!=="search"));if(!accept){return}const actionButton=this.querySelector(".action-button:not([disabled]):not([hidden])");if(actionButton){actionButton.click();e.preventDefault()}}onKeydown_(e){assert(this.consumeKeydownEvent);if(!this.getNative().open){return}if(this.ignoreEnterKey&&e.key==="Enter"){return}e.stopPropagation()}onPointerdown_(e){if(e.button!==0||e.composedPath()[0].tagName!=="DIALOG"){return}this.$.dialog.animate([{transform:"scale(1)",offset:0},{transform:"scale(1.02)",offset:.4},{transform:"scale(1.02)",offset:.6},{transform:"scale(1)",offset:1}],{duration:180,easing:"ease-in-out",iterations:1});e.preventDefault()}focus(){const titleContainer=this.shadowRoot.querySelector(".title-container");assert(titleContainer);titleContainer.focus()}}customElements.define(CrDialogElement.is,CrDialogElement);