// ui/webui/resources/cr_components/theme_color_picker/theme_color_picker.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_WEBUI_RESOURCES_CR_COMPONENTS_THEME_COLOR_PICKER_THEME_COLOR_PICKER_MOJOM_SHARED_H_
#define UI_WEBUI_RESOURCES_CR_COMPONENTS_THEME_COLOR_PICKER_THEME_COLOR_PICKER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/webui/resources/cr_components/theme_color_picker/theme_color_picker.mojom-shared-internal.h"
#include "skia/public/mojom/skcolor.mojom-shared.h"
#include "ui/base/mojom/themes.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "ui/webui/resources/cr_components/theme_color_picker/theme_color_picker.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::theme_color_picker::mojom::ThemeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::theme_color_picker::mojom::ThemeDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::theme_color_picker::mojom::internal::Theme_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->has_background_image = Traits::has_background_image(input);

    fragment->has_third_party_theme = Traits::has_third_party_theme(input);

    decltype(Traits::background_image_main_color(input)) in_background_image_main_color = Traits::background_image_main_color(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->background_image_main_color)::BaseType> background_image_main_color_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::skia::mojom::SkColorDataView>(
      in_background_image_main_color,
      background_image_main_color_fragment);

    fragment->background_image_main_color.Set(
        background_image_main_color_fragment.is_null() ? nullptr : background_image_main_color_fragment.data());

    fragment->is_dark_mode = Traits::is_dark_mode(input);

    decltype(Traits::seed_color(input)) in_seed_color = Traits::seed_color(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->seed_color)::BaseType> seed_color_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::skia::mojom::SkColorDataView>(
      in_seed_color,
      seed_color_fragment);

    fragment->seed_color.Set(
        seed_color_fragment.is_null() ? nullptr : seed_color_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->seed_color.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null seed_color in Theme struct");

    fragment->seed_color_hue = Traits::seed_color_hue(input);

    decltype(Traits::background_color(input)) in_background_color = Traits::background_color(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->background_color)::BaseType> background_color_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::skia::mojom::SkColorDataView>(
      in_background_color,
      background_color_fragment);

    fragment->background_color.Set(
        background_color_fragment.is_null() ? nullptr : background_color_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->background_color.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null background_color in Theme struct");

    decltype(Traits::foreground_color(input)) in_foreground_color = Traits::foreground_color(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->foreground_color)::BaseType> foreground_color_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::skia::mojom::SkColorDataView>(
      in_foreground_color,
      foreground_color_fragment);

    fragment->foreground_color.Set(
        foreground_color_fragment.is_null() ? nullptr : foreground_color_fragment.data());

    decltype(Traits::color_picker_icon_color(input)) in_color_picker_icon_color = Traits::color_picker_icon_color(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->color_picker_icon_color)::BaseType> color_picker_icon_color_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::skia::mojom::SkColorDataView>(
      in_color_picker_icon_color,
      color_picker_icon_color_fragment);

    fragment->color_picker_icon_color.Set(
        color_picker_icon_color_fragment.is_null() ? nullptr : color_picker_icon_color_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->color_picker_icon_color.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null color_picker_icon_color in Theme struct");

    fragment->colors_managed_by_policy = Traits::colors_managed_by_policy(input);

    fragment->is_grey_baseline = Traits::is_grey_baseline(input);

    
    mojo::internal::Serialize<::ui::mojom::BrowserColorVariant>(
      Traits::browser_color_variant(input),
      &fragment->browser_color_variant);

    fragment->follow_device_theme = Traits::follow_device_theme(input);
  }

  static bool Deserialize(::theme_color_picker::mojom::internal::Theme_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::theme_color_picker::mojom::ThemeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::theme_color_picker::mojom::ChromeColorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::theme_color_picker::mojom::ChromeColorDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::theme_color_picker::mojom::internal::ChromeColor_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in ChromeColor struct");

    decltype(Traits::seed(input)) in_seed = Traits::seed(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->seed)::BaseType> seed_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::skia::mojom::SkColorDataView>(
      in_seed,
      seed_fragment);

    fragment->seed.Set(
        seed_fragment.is_null() ? nullptr : seed_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->seed.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null seed in ChromeColor struct");

    decltype(Traits::background(input)) in_background = Traits::background(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->background)::BaseType> background_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::skia::mojom::SkColorDataView>(
      in_background,
      background_fragment);

    fragment->background.Set(
        background_fragment.is_null() ? nullptr : background_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->background.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null background in ChromeColor struct");

    decltype(Traits::foreground(input)) in_foreground = Traits::foreground(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->foreground)::BaseType> foreground_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::skia::mojom::SkColorDataView>(
      in_foreground,
      foreground_fragment);

    fragment->foreground.Set(
        foreground_fragment.is_null() ? nullptr : foreground_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->foreground.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null foreground in ChromeColor struct");

    decltype(Traits::base(input)) in_base = Traits::base(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->base)::BaseType> base_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::skia::mojom::SkColorDataView>(
      in_base,
      base_fragment);

    fragment->base.Set(
        base_fragment.is_null() ? nullptr : base_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->base.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null base in ChromeColor struct");

    
    mojo::internal::Serialize<::ui::mojom::BrowserColorVariant>(
      Traits::variant(input),
      &fragment->variant);
  }

  static bool Deserialize(::theme_color_picker::mojom::internal::ChromeColor_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::theme_color_picker::mojom::ChromeColorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace theme_color_picker::mojom {

inline void ThemeDataView::GetBackgroundImageMainColorDataView(
    ::skia::mojom::SkColorDataView* output) {
  auto pointer = data_->background_image_main_color.Get();
  *output = ::skia::mojom::SkColorDataView(pointer, message_);
}
inline void ThemeDataView::GetSeedColorDataView(
    ::skia::mojom::SkColorDataView* output) {
  auto pointer = data_->seed_color.Get();
  *output = ::skia::mojom::SkColorDataView(pointer, message_);
}
inline void ThemeDataView::GetBackgroundColorDataView(
    ::skia::mojom::SkColorDataView* output) {
  auto pointer = data_->background_color.Get();
  *output = ::skia::mojom::SkColorDataView(pointer, message_);
}
inline void ThemeDataView::GetForegroundColorDataView(
    ::skia::mojom::SkColorDataView* output) {
  auto pointer = data_->foreground_color.Get();
  *output = ::skia::mojom::SkColorDataView(pointer, message_);
}
inline void ThemeDataView::GetColorPickerIconColorDataView(
    ::skia::mojom::SkColorDataView* output) {
  auto pointer = data_->color_picker_icon_color.Get();
  *output = ::skia::mojom::SkColorDataView(pointer, message_);
}


inline void ChromeColorDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ChromeColorDataView::GetSeedDataView(
    ::skia::mojom::SkColorDataView* output) {
  auto pointer = data_->seed.Get();
  *output = ::skia::mojom::SkColorDataView(pointer, message_);
}
inline void ChromeColorDataView::GetBackgroundDataView(
    ::skia::mojom::SkColorDataView* output) {
  auto pointer = data_->background.Get();
  *output = ::skia::mojom::SkColorDataView(pointer, message_);
}
inline void ChromeColorDataView::GetForegroundDataView(
    ::skia::mojom::SkColorDataView* output) {
  auto pointer = data_->foreground.Get();
  *output = ::skia::mojom::SkColorDataView(pointer, message_);
}
inline void ChromeColorDataView::GetBaseDataView(
    ::skia::mojom::SkColorDataView* output) {
  auto pointer = data_->base.Get();
  *output = ::skia::mojom::SkColorDataView(pointer, message_);
}



}  // theme_color_picker::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // UI_WEBUI_RESOURCES_CR_COMPONENTS_THEME_COLOR_PICKER_THEME_COLOR_PICKER_MOJOM_SHARED_H_