// ui/webui/resources/cr_components/theme_color_picker/theme_color_picker.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_WEBUI_RESOURCES_CR_COMPONENTS_THEME_COLOR_PICKER_THEME_COLOR_PICKER_MOJOM_DATA_VIEW_H_
#define UI_WEBUI_RESOURCES_CR_COMPONENTS_THEME_COLOR_PICKER_THEME_COLOR_PICKER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "ui/webui/resources/cr_components/theme_color_picker/theme_color_picker.mojom-shared-internal.h"
#include "skia/public/mojom/skcolor.mojom-shared.h"
#include "ui/base/mojom/themes.mojom-shared.h"


namespace theme_color_picker::mojom {
class ThemeDataView;

class ChromeColorDataView;



}  // theme_color_picker::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::theme_color_picker::mojom::ThemeDataView> {
  using Data = ::theme_color_picker::mojom::internal::Theme_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::theme_color_picker::mojom::ChromeColorDataView> {
  using Data = ::theme_color_picker::mojom::internal::ChromeColor_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace theme_color_picker::mojom {
// Interface base classes. They are used for type safety check.
class ThemeColorPickerHandlerFactoryInterfaceBase {};

using ThemeColorPickerHandlerFactoryPtrDataView =
    mojo::InterfacePtrDataView<ThemeColorPickerHandlerFactoryInterfaceBase>;
using ThemeColorPickerHandlerFactoryRequestDataView =
    mojo::InterfaceRequestDataView<ThemeColorPickerHandlerFactoryInterfaceBase>;
using ThemeColorPickerHandlerFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ThemeColorPickerHandlerFactoryInterfaceBase>;
using ThemeColorPickerHandlerFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ThemeColorPickerHandlerFactoryInterfaceBase>;
class ThemeColorPickerHandlerInterfaceBase {};

using ThemeColorPickerHandlerPtrDataView =
    mojo::InterfacePtrDataView<ThemeColorPickerHandlerInterfaceBase>;
using ThemeColorPickerHandlerRequestDataView =
    mojo::InterfaceRequestDataView<ThemeColorPickerHandlerInterfaceBase>;
using ThemeColorPickerHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ThemeColorPickerHandlerInterfaceBase>;
using ThemeColorPickerHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ThemeColorPickerHandlerInterfaceBase>;
class ThemeColorPickerClientInterfaceBase {};

using ThemeColorPickerClientPtrDataView =
    mojo::InterfacePtrDataView<ThemeColorPickerClientInterfaceBase>;
using ThemeColorPickerClientRequestDataView =
    mojo::InterfaceRequestDataView<ThemeColorPickerClientInterfaceBase>;
using ThemeColorPickerClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ThemeColorPickerClientInterfaceBase>;
using ThemeColorPickerClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ThemeColorPickerClientInterfaceBase>;


class ThemeDataView {
 public:
  ThemeDataView() = default;

  ThemeDataView(
      internal::Theme_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool has_background_image() const {
    return data_->has_background_image;
  }
  bool has_third_party_theme() const {
    return data_->has_third_party_theme;
  }
  inline void GetBackgroundImageMainColorDataView(
      ::skia::mojom::SkColorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBackgroundImageMainColor(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::skia::mojom::SkColorDataView, UserType>(),
    "Attempting to read the optional `background_image_main_color` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBackgroundImageMainColor` instead "
    "of `ReadBackgroundImageMainColor if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->background_image_main_color.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColorDataView>(
        pointer, output, message_);
  }
  bool is_dark_mode() const {
    return data_->is_dark_mode;
  }
  inline void GetSeedColorDataView(
      ::skia::mojom::SkColorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSeedColor(UserType* output) {
    
    auto* pointer = data_->seed_color.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColorDataView>(
        pointer, output, message_);
  }
  float seed_color_hue() const {
    return data_->seed_color_hue;
  }
  inline void GetBackgroundColorDataView(
      ::skia::mojom::SkColorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBackgroundColor(UserType* output) {
    
    auto* pointer = data_->background_color.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColorDataView>(
        pointer, output, message_);
  }
  inline void GetForegroundColorDataView(
      ::skia::mojom::SkColorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadForegroundColor(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::skia::mojom::SkColorDataView, UserType>(),
    "Attempting to read the optional `foreground_color` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadForegroundColor` instead "
    "of `ReadForegroundColor if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->foreground_color.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColorDataView>(
        pointer, output, message_);
  }
  inline void GetColorPickerIconColorDataView(
      ::skia::mojom::SkColorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadColorPickerIconColor(UserType* output) {
    
    auto* pointer = data_->color_picker_icon_color.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColorDataView>(
        pointer, output, message_);
  }
  bool colors_managed_by_policy() const {
    return data_->colors_managed_by_policy;
  }
  bool is_grey_baseline() const {
    return data_->is_grey_baseline;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadBrowserColorVariant(UserType* output) const {
    auto data_value = data_->browser_color_variant;
    return mojo::internal::Deserialize<::ui::mojom::BrowserColorVariant>(
        data_value, output);
  }
  ::ui::mojom::BrowserColorVariant browser_color_variant() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ui::mojom::BrowserColorVariant>(data_->browser_color_variant));
  }
  bool follow_device_theme() const {
    return data_->follow_device_theme;
  }
 private:
  internal::Theme_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ChromeColorDataView {
 public:
  ChromeColorDataView() = default;

  ChromeColorDataView(
      internal::ChromeColor_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSeedDataView(
      ::skia::mojom::SkColorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSeed(UserType* output) {
    
    auto* pointer = data_->seed.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColorDataView>(
        pointer, output, message_);
  }
  inline void GetBackgroundDataView(
      ::skia::mojom::SkColorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBackground(UserType* output) {
    
    auto* pointer = data_->background.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColorDataView>(
        pointer, output, message_);
  }
  inline void GetForegroundDataView(
      ::skia::mojom::SkColorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadForeground(UserType* output) {
    
    auto* pointer = data_->foreground.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColorDataView>(
        pointer, output, message_);
  }
  inline void GetBaseDataView(
      ::skia::mojom::SkColorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBase(UserType* output) {
    
    auto* pointer = data_->base.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColorDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadVariant(UserType* output) const {
    auto data_value = data_->variant;
    return mojo::internal::Deserialize<::ui::mojom::BrowserColorVariant>(
        data_value, output);
  }
  ::ui::mojom::BrowserColorVariant variant() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ui::mojom::BrowserColorVariant>(data_->variant));
  }
 private:
  internal::ChromeColor_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // theme_color_picker::mojom

#endif  // UI_WEBUI_RESOURCES_CR_COMPONENTS_THEME_COLOR_PICKER_THEME_COLOR_PICKER_MOJOM_DATA_VIEW_H_