// ui/webui/resources/cr_components/most_visited/most_visited.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/webui/resources/cr_components/most_visited/most_visited.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/webui/resources/cr_components/most_visited/most_visited.mojom-params-data.h"
#include "ui/webui/resources/cr_components/most_visited/most_visited.mojom-shared-message-ids.h"

#include "ui/webui/resources/cr_components/most_visited/most_visited.mojom-import-headers.h"
#include "ui/webui/resources/cr_components/most_visited/most_visited.mojom-test-utils.h"


namespace most_visited::mojom {
MostVisitedTile::MostVisitedTile()
    : title(),
      title_direction(),
      url(),
      is_query_tile(),
      allow_user_edit(),
      allow_user_delete(),
      source(),
      title_source() {}

MostVisitedTile::MostVisitedTile(
    const std::string& title_in,
    ::base::i18n::TextDirection title_direction_in,
    const ::GURL& url_in,
    bool is_query_tile_in,
    bool allow_user_edit_in,
    bool allow_user_delete_in,
    ::ntp_tiles::mojom::TileSource source_in,
    int32_t title_source_in)
    : title(std::move(title_in)),
      title_direction(std::move(title_direction_in)),
      url(std::move(url_in)),
      is_query_tile(std::move(is_query_tile_in)),
      allow_user_edit(std::move(allow_user_edit_in)),
      allow_user_delete(std::move(allow_user_delete_in)),
      source(std::move(source_in)),
      title_source(std::move(title_source_in)) {}

MostVisitedTile::~MostVisitedTile() = default;

void MostVisitedTile::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title_direction"), this->title_direction,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::i18n::TextDirection>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_query_tile"), this->is_query_tile,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_user_edit"), this->allow_user_edit,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_user_delete"), this->allow_user_delete,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source"), this->source,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::ntp_tiles::mojom::TileSource>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title_source"), this->title_source,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool MostVisitedTile::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
MostVisitedTheme::MostVisitedTheme()
    : background_color(),
      use_white_tile_icon(),
      is_dark() {}

MostVisitedTheme::MostVisitedTheme(
    ::SkColor background_color_in,
    bool use_white_tile_icon_in,
    bool is_dark_in)
    : background_color(std::move(background_color_in)),
      use_white_tile_icon(std::move(use_white_tile_icon_in)),
      is_dark(std::move(is_dark_in)) {}

MostVisitedTheme::~MostVisitedTheme() = default;

void MostVisitedTheme::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "background_color"), this->background_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::SkColor>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "use_white_tile_icon"), this->use_white_tile_icon,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_dark"), this->is_dark,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool MostVisitedTheme::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
MostVisitedInfo::MostVisitedInfo()
    : custom_links_enabled(),
      enterprise_shortcuts_enabled(),
      visible(),
      tiles() {}

MostVisitedInfo::MostVisitedInfo(
    bool custom_links_enabled_in,
    bool enterprise_shortcuts_enabled_in,
    bool visible_in,
    std::vector<MostVisitedTilePtr> tiles_in)
    : custom_links_enabled(std::move(custom_links_enabled_in)),
      enterprise_shortcuts_enabled(std::move(enterprise_shortcuts_enabled_in)),
      visible(std::move(visible_in)),
      tiles(std::move(tiles_in)) {}

MostVisitedInfo::~MostVisitedInfo() = default;

void MostVisitedInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "custom_links_enabled"), this->custom_links_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enterprise_shortcuts_enabled"), this->enterprise_shortcuts_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "visible"), this->visible,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tiles"), this->tiles,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<MostVisitedTilePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool MostVisitedInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

MostVisitedPageHandlerFactory::IPCStableHashFunction MostVisitedPageHandlerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MostVisitedPageHandlerFactory>(message.name())) {
    case messages::MostVisitedPageHandlerFactory::kCreatePageHandler: {
      return &MostVisitedPageHandlerFactory::CreatePageHandler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MostVisitedPageHandlerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MostVisitedPageHandlerFactory>(message.name())) {
      case messages::MostVisitedPageHandlerFactory::kCreatePageHandler:
            return "Receive most_visited::mojom::MostVisitedPageHandlerFactory::CreatePageHandler";
    }
  } else {
    switch (static_cast<messages::MostVisitedPageHandlerFactory>(message.name())) {
      case messages::MostVisitedPageHandlerFactory::kCreatePageHandler:
            return "Receive reply most_visited::mojom::MostVisitedPageHandlerFactory::CreatePageHandler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MostVisitedPageHandlerFactory::CreatePageHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc2c07bc2;  // IPCStableHash for most_visited::mojom::MostVisitedPageHandlerFactory::CreatePageHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

MostVisitedPageHandlerFactoryProxy::MostVisitedPageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MostVisitedPageHandlerFactoryProxy::CreatePageHandler(
    ::mojo::PendingRemote<MostVisitedPage> in_page, ::mojo::PendingReceiver<MostVisitedPageHandler> in_handler) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send most_visited::mojom::MostVisitedPageHandlerFactory::CreatePageHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page"), in_page,
                        "<value of type ::mojo::PendingRemote<MostVisitedPage>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler"), in_handler,
                        "<value of type ::mojo::PendingReceiver<MostVisitedPageHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MostVisitedPageHandlerFactory::kCreatePageHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::most_visited::mojom::internal::MostVisitedPageHandlerFactory_CreatePageHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::most_visited::mojom::MostVisitedPageInterfaceBase>>(
    in_page,
    &params->page,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->page)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid page in MostVisitedPageHandlerFactory.CreatePageHandler request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::most_visited::mojom::MostVisitedPageHandlerInterfaceBase>>(
    in_handler,
    &params->handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handler in MostVisitedPageHandlerFactory.CreatePageHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MostVisitedPageHandlerFactory::Name_);
  message.set_method_name("CreatePageHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool MostVisitedPageHandlerFactoryStubDispatch::Accept(
    MostVisitedPageHandlerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MostVisitedPageHandlerFactory>(message->header()->name)) {
    case messages::MostVisitedPageHandlerFactory::kCreatePageHandler: {
      DCHECK(message->is_serialized());
      internal::MostVisitedPageHandlerFactory_CreatePageHandler_Params_Data* params =
          reinterpret_cast<internal::MostVisitedPageHandlerFactory_CreatePageHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MostVisitedPageHandlerFactory.0
      bool success = true;
      ::mojo::PendingRemote<MostVisitedPage> p_page{};
      ::mojo::PendingReceiver<MostVisitedPageHandler> p_handler{};
      MostVisitedPageHandlerFactory_CreatePageHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_page =
            input_data_view.TakePage<decltype(p_page)>();
      }
      if (success) {
        p_handler =
            input_data_view.TakeHandler<decltype(p_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MostVisitedPageHandlerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreatePageHandler(        
        std::move(p_page), 
        std::move(p_handler));
      return true;
    }
  }
  return false;
}

// static
bool MostVisitedPageHandlerFactoryStubDispatch::AcceptWithResponder(
    MostVisitedPageHandlerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MostVisitedPageHandlerFactory>(message->header()->name)) {
    case messages::MostVisitedPageHandlerFactory::kCreatePageHandler: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kMostVisitedPageHandlerFactoryValidationInfo[] = {
    { &internal::MostVisitedPageHandlerFactory_CreatePageHandler_Params_Data::Validate,
     nullptr /* no response */},
};

bool MostVisitedPageHandlerFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::most_visited::mojom::MostVisitedPageHandlerFactory::Name_,
    kMostVisitedPageHandlerFactoryValidationInfo);
}

// The declaration includes the definition on other builds.

MostVisitedPageHandler::IPCStableHashFunction MostVisitedPageHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MostVisitedPageHandler>(message.name())) {
    case messages::MostVisitedPageHandler::kAddMostVisitedTile: {
      return &MostVisitedPageHandler::AddMostVisitedTile_Sym::IPCStableHash;
    }
    case messages::MostVisitedPageHandler::kDeleteMostVisitedTile: {
      return &MostVisitedPageHandler::DeleteMostVisitedTile_Sym::IPCStableHash;
    }
    case messages::MostVisitedPageHandler::kReorderMostVisitedTile: {
      return &MostVisitedPageHandler::ReorderMostVisitedTile_Sym::IPCStableHash;
    }
    case messages::MostVisitedPageHandler::kRestoreMostVisitedDefaults: {
      return &MostVisitedPageHandler::RestoreMostVisitedDefaults_Sym::IPCStableHash;
    }
    case messages::MostVisitedPageHandler::kUndoMostVisitedAutoRemoval: {
      return &MostVisitedPageHandler::UndoMostVisitedAutoRemoval_Sym::IPCStableHash;
    }
    case messages::MostVisitedPageHandler::kUndoMostVisitedTileAction: {
      return &MostVisitedPageHandler::UndoMostVisitedTileAction_Sym::IPCStableHash;
    }
    case messages::MostVisitedPageHandler::kUpdateMostVisitedInfo: {
      return &MostVisitedPageHandler::UpdateMostVisitedInfo_Sym::IPCStableHash;
    }
    case messages::MostVisitedPageHandler::kUpdateMostVisitedTile: {
      return &MostVisitedPageHandler::UpdateMostVisitedTile_Sym::IPCStableHash;
    }
    case messages::MostVisitedPageHandler::kPrerenderMostVisitedTile: {
      return &MostVisitedPageHandler::PrerenderMostVisitedTile_Sym::IPCStableHash;
    }
    case messages::MostVisitedPageHandler::kPrefetchMostVisitedTile: {
      return &MostVisitedPageHandler::PrefetchMostVisitedTile_Sym::IPCStableHash;
    }
    case messages::MostVisitedPageHandler::kPreconnectMostVisitedTile: {
      return &MostVisitedPageHandler::PreconnectMostVisitedTile_Sym::IPCStableHash;
    }
    case messages::MostVisitedPageHandler::kCancelPrerender: {
      return &MostVisitedPageHandler::CancelPrerender_Sym::IPCStableHash;
    }
    case messages::MostVisitedPageHandler::kGetMostVisitedExpandedState: {
      return &MostVisitedPageHandler::GetMostVisitedExpandedState_Sym::IPCStableHash;
    }
    case messages::MostVisitedPageHandler::kSetMostVisitedExpandedState: {
      return &MostVisitedPageHandler::SetMostVisitedExpandedState_Sym::IPCStableHash;
    }
    case messages::MostVisitedPageHandler::kOnMostVisitedTilesRendered: {
      return &MostVisitedPageHandler::OnMostVisitedTilesRendered_Sym::IPCStableHash;
    }
    case messages::MostVisitedPageHandler::kOnMostVisitedTileNavigation: {
      return &MostVisitedPageHandler::OnMostVisitedTileNavigation_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MostVisitedPageHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MostVisitedPageHandler>(message.name())) {
      case messages::MostVisitedPageHandler::kAddMostVisitedTile:
            return "Receive most_visited::mojom::MostVisitedPageHandler::AddMostVisitedTile";
      case messages::MostVisitedPageHandler::kDeleteMostVisitedTile:
            return "Receive most_visited::mojom::MostVisitedPageHandler::DeleteMostVisitedTile";
      case messages::MostVisitedPageHandler::kReorderMostVisitedTile:
            return "Receive most_visited::mojom::MostVisitedPageHandler::ReorderMostVisitedTile";
      case messages::MostVisitedPageHandler::kRestoreMostVisitedDefaults:
            return "Receive most_visited::mojom::MostVisitedPageHandler::RestoreMostVisitedDefaults";
      case messages::MostVisitedPageHandler::kUndoMostVisitedAutoRemoval:
            return "Receive most_visited::mojom::MostVisitedPageHandler::UndoMostVisitedAutoRemoval";
      case messages::MostVisitedPageHandler::kUndoMostVisitedTileAction:
            return "Receive most_visited::mojom::MostVisitedPageHandler::UndoMostVisitedTileAction";
      case messages::MostVisitedPageHandler::kUpdateMostVisitedInfo:
            return "Receive most_visited::mojom::MostVisitedPageHandler::UpdateMostVisitedInfo";
      case messages::MostVisitedPageHandler::kUpdateMostVisitedTile:
            return "Receive most_visited::mojom::MostVisitedPageHandler::UpdateMostVisitedTile";
      case messages::MostVisitedPageHandler::kPrerenderMostVisitedTile:
            return "Receive most_visited::mojom::MostVisitedPageHandler::PrerenderMostVisitedTile";
      case messages::MostVisitedPageHandler::kPrefetchMostVisitedTile:
            return "Receive most_visited::mojom::MostVisitedPageHandler::PrefetchMostVisitedTile";
      case messages::MostVisitedPageHandler::kPreconnectMostVisitedTile:
            return "Receive most_visited::mojom::MostVisitedPageHandler::PreconnectMostVisitedTile";
      case messages::MostVisitedPageHandler::kCancelPrerender:
            return "Receive most_visited::mojom::MostVisitedPageHandler::CancelPrerender";
      case messages::MostVisitedPageHandler::kGetMostVisitedExpandedState:
            return "Receive most_visited::mojom::MostVisitedPageHandler::GetMostVisitedExpandedState";
      case messages::MostVisitedPageHandler::kSetMostVisitedExpandedState:
            return "Receive most_visited::mojom::MostVisitedPageHandler::SetMostVisitedExpandedState";
      case messages::MostVisitedPageHandler::kOnMostVisitedTilesRendered:
            return "Receive most_visited::mojom::MostVisitedPageHandler::OnMostVisitedTilesRendered";
      case messages::MostVisitedPageHandler::kOnMostVisitedTileNavigation:
            return "Receive most_visited::mojom::MostVisitedPageHandler::OnMostVisitedTileNavigation";
    }
  } else {
    switch (static_cast<messages::MostVisitedPageHandler>(message.name())) {
      case messages::MostVisitedPageHandler::kAddMostVisitedTile:
            return "Receive reply most_visited::mojom::MostVisitedPageHandler::AddMostVisitedTile";
      case messages::MostVisitedPageHandler::kDeleteMostVisitedTile:
            return "Receive reply most_visited::mojom::MostVisitedPageHandler::DeleteMostVisitedTile";
      case messages::MostVisitedPageHandler::kReorderMostVisitedTile:
            return "Receive reply most_visited::mojom::MostVisitedPageHandler::ReorderMostVisitedTile";
      case messages::MostVisitedPageHandler::kRestoreMostVisitedDefaults:
            return "Receive reply most_visited::mojom::MostVisitedPageHandler::RestoreMostVisitedDefaults";
      case messages::MostVisitedPageHandler::kUndoMostVisitedAutoRemoval:
            return "Receive reply most_visited::mojom::MostVisitedPageHandler::UndoMostVisitedAutoRemoval";
      case messages::MostVisitedPageHandler::kUndoMostVisitedTileAction:
            return "Receive reply most_visited::mojom::MostVisitedPageHandler::UndoMostVisitedTileAction";
      case messages::MostVisitedPageHandler::kUpdateMostVisitedInfo:
            return "Receive reply most_visited::mojom::MostVisitedPageHandler::UpdateMostVisitedInfo";
      case messages::MostVisitedPageHandler::kUpdateMostVisitedTile:
            return "Receive reply most_visited::mojom::MostVisitedPageHandler::UpdateMostVisitedTile";
      case messages::MostVisitedPageHandler::kPrerenderMostVisitedTile:
            return "Receive reply most_visited::mojom::MostVisitedPageHandler::PrerenderMostVisitedTile";
      case messages::MostVisitedPageHandler::kPrefetchMostVisitedTile:
            return "Receive reply most_visited::mojom::MostVisitedPageHandler::PrefetchMostVisitedTile";
      case messages::MostVisitedPageHandler::kPreconnectMostVisitedTile:
            return "Receive reply most_visited::mojom::MostVisitedPageHandler::PreconnectMostVisitedTile";
      case messages::MostVisitedPageHandler::kCancelPrerender:
            return "Receive reply most_visited::mojom::MostVisitedPageHandler::CancelPrerender";
      case messages::MostVisitedPageHandler::kGetMostVisitedExpandedState:
            return "Receive reply most_visited::mojom::MostVisitedPageHandler::GetMostVisitedExpandedState";
      case messages::MostVisitedPageHandler::kSetMostVisitedExpandedState:
            return "Receive reply most_visited::mojom::MostVisitedPageHandler::SetMostVisitedExpandedState";
      case messages::MostVisitedPageHandler::kOnMostVisitedTilesRendered:
            return "Receive reply most_visited::mojom::MostVisitedPageHandler::OnMostVisitedTilesRendered";
      case messages::MostVisitedPageHandler::kOnMostVisitedTileNavigation:
            return "Receive reply most_visited::mojom::MostVisitedPageHandler::OnMostVisitedTileNavigation";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MostVisitedPageHandler::AddMostVisitedTile_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3f381e6f;  // IPCStableHash for most_visited::mojom::MostVisitedPageHandler::AddMostVisitedTile
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MostVisitedPageHandler::DeleteMostVisitedTile_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4e3cab3f;  // IPCStableHash for most_visited::mojom::MostVisitedPageHandler::DeleteMostVisitedTile
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MostVisitedPageHandler::ReorderMostVisitedTile_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x172e1582;  // IPCStableHash for most_visited::mojom::MostVisitedPageHandler::ReorderMostVisitedTile
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MostVisitedPageHandler::RestoreMostVisitedDefaults_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2054518e;  // IPCStableHash for most_visited::mojom::MostVisitedPageHandler::RestoreMostVisitedDefaults
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MostVisitedPageHandler::UndoMostVisitedAutoRemoval_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5c330a93;  // IPCStableHash for most_visited::mojom::MostVisitedPageHandler::UndoMostVisitedAutoRemoval
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MostVisitedPageHandler::UndoMostVisitedTileAction_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4a7fcb9a;  // IPCStableHash for most_visited::mojom::MostVisitedPageHandler::UndoMostVisitedTileAction
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MostVisitedPageHandler::UpdateMostVisitedInfo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb1cd0aae;  // IPCStableHash for most_visited::mojom::MostVisitedPageHandler::UpdateMostVisitedInfo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MostVisitedPageHandler::UpdateMostVisitedTile_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa5c3f99a;  // IPCStableHash for most_visited::mojom::MostVisitedPageHandler::UpdateMostVisitedTile
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MostVisitedPageHandler::PrerenderMostVisitedTile_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x800760a2;  // IPCStableHash for most_visited::mojom::MostVisitedPageHandler::PrerenderMostVisitedTile
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MostVisitedPageHandler::PrefetchMostVisitedTile_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcb9fdc0c;  // IPCStableHash for most_visited::mojom::MostVisitedPageHandler::PrefetchMostVisitedTile
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MostVisitedPageHandler::PreconnectMostVisitedTile_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfde62652;  // IPCStableHash for most_visited::mojom::MostVisitedPageHandler::PreconnectMostVisitedTile
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MostVisitedPageHandler::CancelPrerender_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2cda972c;  // IPCStableHash for most_visited::mojom::MostVisitedPageHandler::CancelPrerender
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MostVisitedPageHandler::GetMostVisitedExpandedState_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc2b8025d;  // IPCStableHash for most_visited::mojom::MostVisitedPageHandler::GetMostVisitedExpandedState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MostVisitedPageHandler::SetMostVisitedExpandedState_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0f940ded;  // IPCStableHash for most_visited::mojom::MostVisitedPageHandler::SetMostVisitedExpandedState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MostVisitedPageHandler::OnMostVisitedTilesRendered_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x66f7ab90;  // IPCStableHash for most_visited::mojom::MostVisitedPageHandler::OnMostVisitedTilesRendered
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MostVisitedPageHandler::OnMostVisitedTileNavigation_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5174fda0;  // IPCStableHash for most_visited::mojom::MostVisitedPageHandler::OnMostVisitedTileNavigation
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class MostVisitedPageHandler_AddMostVisitedTile_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MostVisitedPageHandler_AddMostVisitedTile_ForwardToCallback(
      MostVisitedPageHandler::AddMostVisitedTileCallback callback
      ) : callback_(std::move(callback)) {
  }

  MostVisitedPageHandler_AddMostVisitedTile_ForwardToCallback(const MostVisitedPageHandler_AddMostVisitedTile_ForwardToCallback&) = delete;
  MostVisitedPageHandler_AddMostVisitedTile_ForwardToCallback& operator=(const MostVisitedPageHandler_AddMostVisitedTile_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  MostVisitedPageHandler::AddMostVisitedTileCallback callback_;
};

class MostVisitedPageHandler_UpdateMostVisitedTile_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MostVisitedPageHandler_UpdateMostVisitedTile_ForwardToCallback(
      MostVisitedPageHandler::UpdateMostVisitedTileCallback callback
      ) : callback_(std::move(callback)) {
  }

  MostVisitedPageHandler_UpdateMostVisitedTile_ForwardToCallback(const MostVisitedPageHandler_UpdateMostVisitedTile_ForwardToCallback&) = delete;
  MostVisitedPageHandler_UpdateMostVisitedTile_ForwardToCallback& operator=(const MostVisitedPageHandler_UpdateMostVisitedTile_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  MostVisitedPageHandler::UpdateMostVisitedTileCallback callback_;
};

class MostVisitedPageHandler_GetMostVisitedExpandedState_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MostVisitedPageHandler_GetMostVisitedExpandedState_ForwardToCallback(
      MostVisitedPageHandler::GetMostVisitedExpandedStateCallback callback
      ) : callback_(std::move(callback)) {
  }

  MostVisitedPageHandler_GetMostVisitedExpandedState_ForwardToCallback(const MostVisitedPageHandler_GetMostVisitedExpandedState_ForwardToCallback&) = delete;
  MostVisitedPageHandler_GetMostVisitedExpandedState_ForwardToCallback& operator=(const MostVisitedPageHandler_GetMostVisitedExpandedState_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  MostVisitedPageHandler::GetMostVisitedExpandedStateCallback callback_;
};

MostVisitedPageHandlerProxy::MostVisitedPageHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MostVisitedPageHandlerProxy::AddMostVisitedTile(
    const ::GURL& in_url, const std::string& in_title, AddMostVisitedTileCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send most_visited::mojom::MostVisitedPageHandler::AddMostVisitedTile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("title"), in_title,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MostVisitedPageHandler::kAddMostVisitedTile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::most_visited::mojom::internal::MostVisitedPageHandler_AddMostVisitedTile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in MostVisitedPageHandler.AddMostVisitedTile request");
  mojo::internal::MessageFragment<
      typename decltype(params->title)::BaseType> title_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_title,
    title_fragment);

  params->title.Set(
      title_fragment.is_null() ? nullptr : title_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->title.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null title in MostVisitedPageHandler.AddMostVisitedTile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MostVisitedPageHandler::Name_);
  message.set_method_name("AddMostVisitedTile");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MostVisitedPageHandler_AddMostVisitedTile_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void MostVisitedPageHandlerProxy::DeleteMostVisitedTile(
    MostVisitedTilePtr in_tile) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send most_visited::mojom::MostVisitedPageHandler::DeleteMostVisitedTile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tile"), in_tile,
                        "<value of type MostVisitedTilePtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MostVisitedPageHandler::kDeleteMostVisitedTile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::most_visited::mojom::internal::MostVisitedPageHandler_DeleteMostVisitedTile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->tile)::BaseType> tile_fragment(
          params.message());
  
  mojo::internal::Serialize<::most_visited::mojom::MostVisitedTileDataView>(
    in_tile,
    tile_fragment);

  params->tile.Set(
      tile_fragment.is_null() ? nullptr : tile_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tile.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tile in MostVisitedPageHandler.DeleteMostVisitedTile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MostVisitedPageHandler::Name_);
  message.set_method_name("DeleteMostVisitedTile");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MostVisitedPageHandlerProxy::ReorderMostVisitedTile(
    MostVisitedTilePtr in_tile, uint8_t in_new_pos) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send most_visited::mojom::MostVisitedPageHandler::ReorderMostVisitedTile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tile"), in_tile,
                        "<value of type MostVisitedTilePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_pos"), in_new_pos,
                        "<value of type uint8_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MostVisitedPageHandler::kReorderMostVisitedTile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::most_visited::mojom::internal::MostVisitedPageHandler_ReorderMostVisitedTile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->tile)::BaseType> tile_fragment(
          params.message());
  
  mojo::internal::Serialize<::most_visited::mojom::MostVisitedTileDataView>(
    in_tile,
    tile_fragment);

  params->tile.Set(
      tile_fragment.is_null() ? nullptr : tile_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tile.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tile in MostVisitedPageHandler.ReorderMostVisitedTile request");

  params->new_pos = in_new_pos;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MostVisitedPageHandler::Name_);
  message.set_method_name("ReorderMostVisitedTile");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MostVisitedPageHandlerProxy::RestoreMostVisitedDefaults(
    ::ntp_tiles::mojom::TileSource in_source) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send most_visited::mojom::MostVisitedPageHandler::RestoreMostVisitedDefaults", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type ::ntp_tiles::mojom::TileSource>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MostVisitedPageHandler::kRestoreMostVisitedDefaults), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::most_visited::mojom::internal::MostVisitedPageHandler_RestoreMostVisitedDefaults_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::ntp_tiles::mojom::TileSource>(
    in_source,
    &params->source);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MostVisitedPageHandler::Name_);
  message.set_method_name("RestoreMostVisitedDefaults");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MostVisitedPageHandlerProxy::UndoMostVisitedAutoRemoval(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send most_visited::mojom::MostVisitedPageHandler::UndoMostVisitedAutoRemoval");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MostVisitedPageHandler::kUndoMostVisitedAutoRemoval), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::most_visited::mojom::internal::MostVisitedPageHandler_UndoMostVisitedAutoRemoval_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MostVisitedPageHandler::Name_);
  message.set_method_name("UndoMostVisitedAutoRemoval");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MostVisitedPageHandlerProxy::UndoMostVisitedTileAction(
    ::ntp_tiles::mojom::TileSource in_source) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send most_visited::mojom::MostVisitedPageHandler::UndoMostVisitedTileAction", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type ::ntp_tiles::mojom::TileSource>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MostVisitedPageHandler::kUndoMostVisitedTileAction), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::most_visited::mojom::internal::MostVisitedPageHandler_UndoMostVisitedTileAction_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::ntp_tiles::mojom::TileSource>(
    in_source,
    &params->source);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MostVisitedPageHandler::Name_);
  message.set_method_name("UndoMostVisitedTileAction");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MostVisitedPageHandlerProxy::UpdateMostVisitedInfo(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send most_visited::mojom::MostVisitedPageHandler::UpdateMostVisitedInfo");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MostVisitedPageHandler::kUpdateMostVisitedInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::most_visited::mojom::internal::MostVisitedPageHandler_UpdateMostVisitedInfo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MostVisitedPageHandler::Name_);
  message.set_method_name("UpdateMostVisitedInfo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MostVisitedPageHandlerProxy::UpdateMostVisitedTile(
    MostVisitedTilePtr in_tile, const ::GURL& in_new_url, const std::string& in_new_title, UpdateMostVisitedTileCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send most_visited::mojom::MostVisitedPageHandler::UpdateMostVisitedTile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tile"), in_tile,
                        "<value of type MostVisitedTilePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_url"), in_new_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_title"), in_new_title,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MostVisitedPageHandler::kUpdateMostVisitedTile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::most_visited::mojom::internal::MostVisitedPageHandler_UpdateMostVisitedTile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->tile)::BaseType> tile_fragment(
          params.message());
  
  mojo::internal::Serialize<::most_visited::mojom::MostVisitedTileDataView>(
    in_tile,
    tile_fragment);

  params->tile.Set(
      tile_fragment.is_null() ? nullptr : tile_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tile.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tile in MostVisitedPageHandler.UpdateMostVisitedTile request");
  mojo::internal::MessageFragment<
      typename decltype(params->new_url)::BaseType> new_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_new_url,
    new_url_fragment);

  params->new_url.Set(
      new_url_fragment.is_null() ? nullptr : new_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->new_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null new_url in MostVisitedPageHandler.UpdateMostVisitedTile request");
  mojo::internal::MessageFragment<
      typename decltype(params->new_title)::BaseType> new_title_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_new_title,
    new_title_fragment);

  params->new_title.Set(
      new_title_fragment.is_null() ? nullptr : new_title_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->new_title.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null new_title in MostVisitedPageHandler.UpdateMostVisitedTile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MostVisitedPageHandler::Name_);
  message.set_method_name("UpdateMostVisitedTile");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MostVisitedPageHandler_UpdateMostVisitedTile_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void MostVisitedPageHandlerProxy::PrerenderMostVisitedTile(
    MostVisitedTilePtr in_tile) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send most_visited::mojom::MostVisitedPageHandler::PrerenderMostVisitedTile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tile"), in_tile,
                        "<value of type MostVisitedTilePtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MostVisitedPageHandler::kPrerenderMostVisitedTile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::most_visited::mojom::internal::MostVisitedPageHandler_PrerenderMostVisitedTile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->tile)::BaseType> tile_fragment(
          params.message());
  
  mojo::internal::Serialize<::most_visited::mojom::MostVisitedTileDataView>(
    in_tile,
    tile_fragment);

  params->tile.Set(
      tile_fragment.is_null() ? nullptr : tile_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tile.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tile in MostVisitedPageHandler.PrerenderMostVisitedTile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MostVisitedPageHandler::Name_);
  message.set_method_name("PrerenderMostVisitedTile");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MostVisitedPageHandlerProxy::PrefetchMostVisitedTile(
    MostVisitedTilePtr in_tile) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send most_visited::mojom::MostVisitedPageHandler::PrefetchMostVisitedTile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tile"), in_tile,
                        "<value of type MostVisitedTilePtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MostVisitedPageHandler::kPrefetchMostVisitedTile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::most_visited::mojom::internal::MostVisitedPageHandler_PrefetchMostVisitedTile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->tile)::BaseType> tile_fragment(
          params.message());
  
  mojo::internal::Serialize<::most_visited::mojom::MostVisitedTileDataView>(
    in_tile,
    tile_fragment);

  params->tile.Set(
      tile_fragment.is_null() ? nullptr : tile_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tile.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tile in MostVisitedPageHandler.PrefetchMostVisitedTile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MostVisitedPageHandler::Name_);
  message.set_method_name("PrefetchMostVisitedTile");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MostVisitedPageHandlerProxy::PreconnectMostVisitedTile(
    MostVisitedTilePtr in_tile) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send most_visited::mojom::MostVisitedPageHandler::PreconnectMostVisitedTile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tile"), in_tile,
                        "<value of type MostVisitedTilePtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MostVisitedPageHandler::kPreconnectMostVisitedTile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::most_visited::mojom::internal::MostVisitedPageHandler_PreconnectMostVisitedTile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->tile)::BaseType> tile_fragment(
          params.message());
  
  mojo::internal::Serialize<::most_visited::mojom::MostVisitedTileDataView>(
    in_tile,
    tile_fragment);

  params->tile.Set(
      tile_fragment.is_null() ? nullptr : tile_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tile.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tile in MostVisitedPageHandler.PreconnectMostVisitedTile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MostVisitedPageHandler::Name_);
  message.set_method_name("PreconnectMostVisitedTile");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MostVisitedPageHandlerProxy::CancelPrerender(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send most_visited::mojom::MostVisitedPageHandler::CancelPrerender");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MostVisitedPageHandler::kCancelPrerender), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::most_visited::mojom::internal::MostVisitedPageHandler_CancelPrerender_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MostVisitedPageHandler::Name_);
  message.set_method_name("CancelPrerender");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MostVisitedPageHandlerProxy::GetMostVisitedExpandedState(
    GetMostVisitedExpandedStateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send most_visited::mojom::MostVisitedPageHandler::GetMostVisitedExpandedState");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MostVisitedPageHandler::kGetMostVisitedExpandedState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::most_visited::mojom::internal::MostVisitedPageHandler_GetMostVisitedExpandedState_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MostVisitedPageHandler::Name_);
  message.set_method_name("GetMostVisitedExpandedState");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MostVisitedPageHandler_GetMostVisitedExpandedState_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void MostVisitedPageHandlerProxy::SetMostVisitedExpandedState(
    bool in_is_expanded) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send most_visited::mojom::MostVisitedPageHandler::SetMostVisitedExpandedState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_expanded"), in_is_expanded,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MostVisitedPageHandler::kSetMostVisitedExpandedState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::most_visited::mojom::internal::MostVisitedPageHandler_SetMostVisitedExpandedState_Params_Data> params(
          message);
  params.Allocate();

  params->is_expanded = in_is_expanded;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MostVisitedPageHandler::Name_);
  message.set_method_name("SetMostVisitedExpandedState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MostVisitedPageHandlerProxy::OnMostVisitedTilesRendered(
    std::vector<MostVisitedTilePtr> in_tiles, double in_time) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send most_visited::mojom::MostVisitedPageHandler::OnMostVisitedTilesRendered", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tiles"), in_tiles,
                        "<value of type std::vector<MostVisitedTilePtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("time"), in_time,
                        "<value of type double>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MostVisitedPageHandler::kOnMostVisitedTilesRendered), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::most_visited::mojom::internal::MostVisitedPageHandler_OnMostVisitedTilesRendered_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->tiles)::BaseType>
      tiles_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& tiles_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::most_visited::mojom::MostVisitedTileDataView>>(
    in_tiles,
    tiles_fragment,
    &tiles_validate_params);

  params->tiles.Set(
      tiles_fragment.is_null() ? nullptr : tiles_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tiles.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tiles in MostVisitedPageHandler.OnMostVisitedTilesRendered request");

  params->time = in_time;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MostVisitedPageHandler::Name_);
  message.set_method_name("OnMostVisitedTilesRendered");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MostVisitedPageHandlerProxy::OnMostVisitedTileNavigation(
    MostVisitedTilePtr in_tile, uint32_t in_index, uint8_t in_mouse_button, bool in_alt_key, bool in_ctrl_key, bool in_meta_key, bool in_shift_key) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send most_visited::mojom::MostVisitedPageHandler::OnMostVisitedTileNavigation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tile"), in_tile,
                        "<value of type MostVisitedTilePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("index"), in_index,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mouse_button"), in_mouse_button,
                        "<value of type uint8_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("alt_key"), in_alt_key,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ctrl_key"), in_ctrl_key,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("meta_key"), in_meta_key,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("shift_key"), in_shift_key,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MostVisitedPageHandler::kOnMostVisitedTileNavigation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::most_visited::mojom::internal::MostVisitedPageHandler_OnMostVisitedTileNavigation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->tile)::BaseType> tile_fragment(
          params.message());
  
  mojo::internal::Serialize<::most_visited::mojom::MostVisitedTileDataView>(
    in_tile,
    tile_fragment);

  params->tile.Set(
      tile_fragment.is_null() ? nullptr : tile_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tile.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tile in MostVisitedPageHandler.OnMostVisitedTileNavigation request");

  params->index = in_index;

  params->mouse_button = in_mouse_button;

  params->alt_key = in_alt_key;

  params->ctrl_key = in_ctrl_key;

  params->meta_key = in_meta_key;

  params->shift_key = in_shift_key;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MostVisitedPageHandler::Name_);
  message.set_method_name("OnMostVisitedTileNavigation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class MostVisitedPageHandler_AddMostVisitedTile_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static MostVisitedPageHandler::AddMostVisitedTileCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<MostVisitedPageHandler_AddMostVisitedTile_ProxyToResponder> proxy(
        new MostVisitedPageHandler_AddMostVisitedTile_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&MostVisitedPageHandler_AddMostVisitedTile_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MostVisitedPageHandler_AddMostVisitedTile_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  MostVisitedPageHandler_AddMostVisitedTile_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "MostVisitedPageHandler::AddMostVisitedTileCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool MostVisitedPageHandler_AddMostVisitedTile_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::MostVisitedPageHandler_AddMostVisitedTile_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MostVisitedPageHandler_AddMostVisitedTile_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for MostVisitedPageHandler.0
  bool success = true;
  bool p_success{};
  MostVisitedPageHandler_AddMostVisitedTile_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MostVisitedPageHandler::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void MostVisitedPageHandler_AddMostVisitedTile_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply most_visited::mojom::MostVisitedPageHandler::AddMostVisitedTile", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MostVisitedPageHandler::kAddMostVisitedTile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::most_visited::mojom::internal::MostVisitedPageHandler_AddMostVisitedTile_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MostVisitedPageHandler::Name_);
  message.set_method_name("AddMostVisitedTile");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class MostVisitedPageHandler_UpdateMostVisitedTile_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static MostVisitedPageHandler::UpdateMostVisitedTileCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<MostVisitedPageHandler_UpdateMostVisitedTile_ProxyToResponder> proxy(
        new MostVisitedPageHandler_UpdateMostVisitedTile_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&MostVisitedPageHandler_UpdateMostVisitedTile_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MostVisitedPageHandler_UpdateMostVisitedTile_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  MostVisitedPageHandler_UpdateMostVisitedTile_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "MostVisitedPageHandler::UpdateMostVisitedTileCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool MostVisitedPageHandler_UpdateMostVisitedTile_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::MostVisitedPageHandler_UpdateMostVisitedTile_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MostVisitedPageHandler_UpdateMostVisitedTile_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for MostVisitedPageHandler.7
  bool success = true;
  bool p_success{};
  MostVisitedPageHandler_UpdateMostVisitedTile_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MostVisitedPageHandler::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void MostVisitedPageHandler_UpdateMostVisitedTile_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply most_visited::mojom::MostVisitedPageHandler::UpdateMostVisitedTile", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MostVisitedPageHandler::kUpdateMostVisitedTile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::most_visited::mojom::internal::MostVisitedPageHandler_UpdateMostVisitedTile_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MostVisitedPageHandler::Name_);
  message.set_method_name("UpdateMostVisitedTile");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class MostVisitedPageHandler_GetMostVisitedExpandedState_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static MostVisitedPageHandler::GetMostVisitedExpandedStateCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<MostVisitedPageHandler_GetMostVisitedExpandedState_ProxyToResponder> proxy(
        new MostVisitedPageHandler_GetMostVisitedExpandedState_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&MostVisitedPageHandler_GetMostVisitedExpandedState_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MostVisitedPageHandler_GetMostVisitedExpandedState_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  MostVisitedPageHandler_GetMostVisitedExpandedState_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "MostVisitedPageHandler::GetMostVisitedExpandedStateCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_is_expanded);
};

bool MostVisitedPageHandler_GetMostVisitedExpandedState_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::MostVisitedPageHandler_GetMostVisitedExpandedState_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MostVisitedPageHandler_GetMostVisitedExpandedState_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for MostVisitedPageHandler.12
  bool success = true;
  bool p_is_expanded{};
  MostVisitedPageHandler_GetMostVisitedExpandedState_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_is_expanded = input_data_view.is_expanded();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MostVisitedPageHandler::Name_, 12, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_is_expanded));
  }
  return true;
}

void MostVisitedPageHandler_GetMostVisitedExpandedState_ProxyToResponder::Run(
    bool in_is_expanded) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply most_visited::mojom::MostVisitedPageHandler::GetMostVisitedExpandedState", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_expanded"), in_is_expanded,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MostVisitedPageHandler::kGetMostVisitedExpandedState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::most_visited::mojom::internal::MostVisitedPageHandler_GetMostVisitedExpandedState_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->is_expanded = in_is_expanded;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MostVisitedPageHandler::Name_);
  message.set_method_name("GetMostVisitedExpandedState");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool MostVisitedPageHandlerStubDispatch::Accept(
    MostVisitedPageHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MostVisitedPageHandler>(message->header()->name)) {
    case messages::MostVisitedPageHandler::kAddMostVisitedTile: {
      break;
    }
    case messages::MostVisitedPageHandler::kDeleteMostVisitedTile: {
      DCHECK(message->is_serialized());
      internal::MostVisitedPageHandler_DeleteMostVisitedTile_Params_Data* params =
          reinterpret_cast<internal::MostVisitedPageHandler_DeleteMostVisitedTile_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MostVisitedPageHandler.1
      bool success = true;
      MostVisitedTilePtr p_tile{};
      MostVisitedPageHandler_DeleteMostVisitedTile_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTile(&p_tile))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MostVisitedPageHandler::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteMostVisitedTile(        
        std::move(p_tile));
      return true;
    }
    case messages::MostVisitedPageHandler::kReorderMostVisitedTile: {
      DCHECK(message->is_serialized());
      internal::MostVisitedPageHandler_ReorderMostVisitedTile_Params_Data* params =
          reinterpret_cast<internal::MostVisitedPageHandler_ReorderMostVisitedTile_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MostVisitedPageHandler.2
      bool success = true;
      MostVisitedTilePtr p_tile{};
      uint8_t p_new_pos{};
      MostVisitedPageHandler_ReorderMostVisitedTile_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTile(&p_tile))
        success = false;
      if (success)
        p_new_pos = input_data_view.new_pos();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MostVisitedPageHandler::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReorderMostVisitedTile(        
        std::move(p_tile), 
        std::move(p_new_pos));
      return true;
    }
    case messages::MostVisitedPageHandler::kRestoreMostVisitedDefaults: {
      DCHECK(message->is_serialized());
      internal::MostVisitedPageHandler_RestoreMostVisitedDefaults_Params_Data* params =
          reinterpret_cast<internal::MostVisitedPageHandler_RestoreMostVisitedDefaults_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MostVisitedPageHandler.3
      bool success = true;
      ::ntp_tiles::mojom::TileSource p_source{};
      MostVisitedPageHandler_RestoreMostVisitedDefaults_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MostVisitedPageHandler::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RestoreMostVisitedDefaults(        
        std::move(p_source));
      return true;
    }
    case messages::MostVisitedPageHandler::kUndoMostVisitedAutoRemoval: {
      DCHECK(message->is_serialized());
      internal::MostVisitedPageHandler_UndoMostVisitedAutoRemoval_Params_Data* params =
          reinterpret_cast<internal::MostVisitedPageHandler_UndoMostVisitedAutoRemoval_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MostVisitedPageHandler.4
      bool success = true;
      MostVisitedPageHandler_UndoMostVisitedAutoRemoval_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MostVisitedPageHandler::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UndoMostVisitedAutoRemoval(        );
      return true;
    }
    case messages::MostVisitedPageHandler::kUndoMostVisitedTileAction: {
      DCHECK(message->is_serialized());
      internal::MostVisitedPageHandler_UndoMostVisitedTileAction_Params_Data* params =
          reinterpret_cast<internal::MostVisitedPageHandler_UndoMostVisitedTileAction_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MostVisitedPageHandler.5
      bool success = true;
      ::ntp_tiles::mojom::TileSource p_source{};
      MostVisitedPageHandler_UndoMostVisitedTileAction_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MostVisitedPageHandler::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UndoMostVisitedTileAction(        
        std::move(p_source));
      return true;
    }
    case messages::MostVisitedPageHandler::kUpdateMostVisitedInfo: {
      DCHECK(message->is_serialized());
      internal::MostVisitedPageHandler_UpdateMostVisitedInfo_Params_Data* params =
          reinterpret_cast<internal::MostVisitedPageHandler_UpdateMostVisitedInfo_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MostVisitedPageHandler.6
      bool success = true;
      MostVisitedPageHandler_UpdateMostVisitedInfo_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MostVisitedPageHandler::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateMostVisitedInfo(        );
      return true;
    }
    case messages::MostVisitedPageHandler::kUpdateMostVisitedTile: {
      break;
    }
    case messages::MostVisitedPageHandler::kPrerenderMostVisitedTile: {
      DCHECK(message->is_serialized());
      internal::MostVisitedPageHandler_PrerenderMostVisitedTile_Params_Data* params =
          reinterpret_cast<internal::MostVisitedPageHandler_PrerenderMostVisitedTile_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MostVisitedPageHandler.8
      bool success = true;
      MostVisitedTilePtr p_tile{};
      MostVisitedPageHandler_PrerenderMostVisitedTile_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTile(&p_tile))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MostVisitedPageHandler::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PrerenderMostVisitedTile(        
        std::move(p_tile));
      return true;
    }
    case messages::MostVisitedPageHandler::kPrefetchMostVisitedTile: {
      DCHECK(message->is_serialized());
      internal::MostVisitedPageHandler_PrefetchMostVisitedTile_Params_Data* params =
          reinterpret_cast<internal::MostVisitedPageHandler_PrefetchMostVisitedTile_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MostVisitedPageHandler.9
      bool success = true;
      MostVisitedTilePtr p_tile{};
      MostVisitedPageHandler_PrefetchMostVisitedTile_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTile(&p_tile))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MostVisitedPageHandler::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PrefetchMostVisitedTile(        
        std::move(p_tile));
      return true;
    }
    case messages::MostVisitedPageHandler::kPreconnectMostVisitedTile: {
      DCHECK(message->is_serialized());
      internal::MostVisitedPageHandler_PreconnectMostVisitedTile_Params_Data* params =
          reinterpret_cast<internal::MostVisitedPageHandler_PreconnectMostVisitedTile_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MostVisitedPageHandler.10
      bool success = true;
      MostVisitedTilePtr p_tile{};
      MostVisitedPageHandler_PreconnectMostVisitedTile_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTile(&p_tile))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MostVisitedPageHandler::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PreconnectMostVisitedTile(        
        std::move(p_tile));
      return true;
    }
    case messages::MostVisitedPageHandler::kCancelPrerender: {
      DCHECK(message->is_serialized());
      internal::MostVisitedPageHandler_CancelPrerender_Params_Data* params =
          reinterpret_cast<internal::MostVisitedPageHandler_CancelPrerender_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MostVisitedPageHandler.11
      bool success = true;
      MostVisitedPageHandler_CancelPrerender_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MostVisitedPageHandler::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CancelPrerender(        );
      return true;
    }
    case messages::MostVisitedPageHandler::kGetMostVisitedExpandedState: {
      break;
    }
    case messages::MostVisitedPageHandler::kSetMostVisitedExpandedState: {
      DCHECK(message->is_serialized());
      internal::MostVisitedPageHandler_SetMostVisitedExpandedState_Params_Data* params =
          reinterpret_cast<internal::MostVisitedPageHandler_SetMostVisitedExpandedState_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MostVisitedPageHandler.13
      bool success = true;
      bool p_is_expanded{};
      MostVisitedPageHandler_SetMostVisitedExpandedState_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_expanded = input_data_view.is_expanded();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MostVisitedPageHandler::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetMostVisitedExpandedState(        
        std::move(p_is_expanded));
      return true;
    }
    case messages::MostVisitedPageHandler::kOnMostVisitedTilesRendered: {
      DCHECK(message->is_serialized());
      internal::MostVisitedPageHandler_OnMostVisitedTilesRendered_Params_Data* params =
          reinterpret_cast<internal::MostVisitedPageHandler_OnMostVisitedTilesRendered_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MostVisitedPageHandler.14
      bool success = true;
      std::vector<MostVisitedTilePtr> p_tiles{};
      double p_time{};
      MostVisitedPageHandler_OnMostVisitedTilesRendered_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTiles(&p_tiles))
        success = false;
      if (success)
        p_time = input_data_view.time();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MostVisitedPageHandler::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnMostVisitedTilesRendered(        
        std::move(p_tiles), 
        std::move(p_time));
      return true;
    }
    case messages::MostVisitedPageHandler::kOnMostVisitedTileNavigation: {
      DCHECK(message->is_serialized());
      internal::MostVisitedPageHandler_OnMostVisitedTileNavigation_Params_Data* params =
          reinterpret_cast<internal::MostVisitedPageHandler_OnMostVisitedTileNavigation_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MostVisitedPageHandler.15
      bool success = true;
      MostVisitedTilePtr p_tile{};
      uint32_t p_index{};
      uint8_t p_mouse_button{};
      bool p_alt_key{};
      bool p_ctrl_key{};
      bool p_meta_key{};
      bool p_shift_key{};
      MostVisitedPageHandler_OnMostVisitedTileNavigation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTile(&p_tile))
        success = false;
      if (success)
        p_index = input_data_view.index();
      if (success)
        p_mouse_button = input_data_view.mouse_button();
      if (success)
        p_alt_key = input_data_view.alt_key();
      if (success)
        p_ctrl_key = input_data_view.ctrl_key();
      if (success)
        p_meta_key = input_data_view.meta_key();
      if (success)
        p_shift_key = input_data_view.shift_key();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MostVisitedPageHandler::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnMostVisitedTileNavigation(        
        std::move(p_tile), 
        std::move(p_index), 
        std::move(p_mouse_button), 
        std::move(p_alt_key), 
        std::move(p_ctrl_key), 
        std::move(p_meta_key), 
        std::move(p_shift_key));
      return true;
    }
  }
  return false;
}

// static
bool MostVisitedPageHandlerStubDispatch::AcceptWithResponder(
    MostVisitedPageHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MostVisitedPageHandler>(message->header()->name)) {
    case messages::MostVisitedPageHandler::kAddMostVisitedTile: {
      internal::MostVisitedPageHandler_AddMostVisitedTile_Params_Data* params =
          reinterpret_cast<
              internal::MostVisitedPageHandler_AddMostVisitedTile_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for MostVisitedPageHandler.0
      bool success = true;
      ::GURL p_url{};
      std::string p_title{};
      MostVisitedPageHandler_AddMostVisitedTile_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadTitle(&p_title))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MostVisitedPageHandler::Name_, 0, false);
        return false;
      }
      auto callback =
          MostVisitedPageHandler_AddMostVisitedTile_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddMostVisitedTile(        
        std::move(p_url), 
        std::move(p_title), std::move(callback));
      return true;
    }
    case messages::MostVisitedPageHandler::kDeleteMostVisitedTile: {
      break;
    }
    case messages::MostVisitedPageHandler::kReorderMostVisitedTile: {
      break;
    }
    case messages::MostVisitedPageHandler::kRestoreMostVisitedDefaults: {
      break;
    }
    case messages::MostVisitedPageHandler::kUndoMostVisitedAutoRemoval: {
      break;
    }
    case messages::MostVisitedPageHandler::kUndoMostVisitedTileAction: {
      break;
    }
    case messages::MostVisitedPageHandler::kUpdateMostVisitedInfo: {
      break;
    }
    case messages::MostVisitedPageHandler::kUpdateMostVisitedTile: {
      internal::MostVisitedPageHandler_UpdateMostVisitedTile_Params_Data* params =
          reinterpret_cast<
              internal::MostVisitedPageHandler_UpdateMostVisitedTile_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for MostVisitedPageHandler.7
      bool success = true;
      MostVisitedTilePtr p_tile{};
      ::GURL p_new_url{};
      std::string p_new_title{};
      MostVisitedPageHandler_UpdateMostVisitedTile_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTile(&p_tile))
        success = false;
      if (success && !input_data_view.ReadNewUrl(&p_new_url))
        success = false;
      if (success && !input_data_view.ReadNewTitle(&p_new_title))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MostVisitedPageHandler::Name_, 7, false);
        return false;
      }
      auto callback =
          MostVisitedPageHandler_UpdateMostVisitedTile_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateMostVisitedTile(        
        std::move(p_tile), 
        std::move(p_new_url), 
        std::move(p_new_title), std::move(callback));
      return true;
    }
    case messages::MostVisitedPageHandler::kPrerenderMostVisitedTile: {
      break;
    }
    case messages::MostVisitedPageHandler::kPrefetchMostVisitedTile: {
      break;
    }
    case messages::MostVisitedPageHandler::kPreconnectMostVisitedTile: {
      break;
    }
    case messages::MostVisitedPageHandler::kCancelPrerender: {
      break;
    }
    case messages::MostVisitedPageHandler::kGetMostVisitedExpandedState: {
      internal::MostVisitedPageHandler_GetMostVisitedExpandedState_Params_Data* params =
          reinterpret_cast<
              internal::MostVisitedPageHandler_GetMostVisitedExpandedState_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for MostVisitedPageHandler.12
      bool success = true;
      MostVisitedPageHandler_GetMostVisitedExpandedState_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MostVisitedPageHandler::Name_, 12, false);
        return false;
      }
      auto callback =
          MostVisitedPageHandler_GetMostVisitedExpandedState_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetMostVisitedExpandedState(std::move(callback));
      return true;
    }
    case messages::MostVisitedPageHandler::kSetMostVisitedExpandedState: {
      break;
    }
    case messages::MostVisitedPageHandler::kOnMostVisitedTilesRendered: {
      break;
    }
    case messages::MostVisitedPageHandler::kOnMostVisitedTileNavigation: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kMostVisitedPageHandlerValidationInfo[] = {
    { &internal::MostVisitedPageHandler_AddMostVisitedTile_Params_Data::Validate,
     &internal::MostVisitedPageHandler_AddMostVisitedTile_ResponseParams_Data::Validate},
    { &internal::MostVisitedPageHandler_DeleteMostVisitedTile_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MostVisitedPageHandler_ReorderMostVisitedTile_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MostVisitedPageHandler_RestoreMostVisitedDefaults_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MostVisitedPageHandler_UndoMostVisitedAutoRemoval_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MostVisitedPageHandler_UndoMostVisitedTileAction_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MostVisitedPageHandler_UpdateMostVisitedInfo_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MostVisitedPageHandler_UpdateMostVisitedTile_Params_Data::Validate,
     &internal::MostVisitedPageHandler_UpdateMostVisitedTile_ResponseParams_Data::Validate},
    { &internal::MostVisitedPageHandler_PrerenderMostVisitedTile_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MostVisitedPageHandler_PrefetchMostVisitedTile_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MostVisitedPageHandler_PreconnectMostVisitedTile_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MostVisitedPageHandler_CancelPrerender_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MostVisitedPageHandler_GetMostVisitedExpandedState_Params_Data::Validate,
     &internal::MostVisitedPageHandler_GetMostVisitedExpandedState_ResponseParams_Data::Validate},
    { &internal::MostVisitedPageHandler_SetMostVisitedExpandedState_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MostVisitedPageHandler_OnMostVisitedTilesRendered_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MostVisitedPageHandler_OnMostVisitedTileNavigation_Params_Data::Validate,
     nullptr /* no response */},
};

bool MostVisitedPageHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::most_visited::mojom::MostVisitedPageHandler::Name_,
    kMostVisitedPageHandlerValidationInfo);
}

bool MostVisitedPageHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::most_visited::mojom::MostVisitedPageHandler::Name_,
    kMostVisitedPageHandlerValidationInfo);
}
// The declaration includes the definition on other builds.

MostVisitedPage::IPCStableHashFunction MostVisitedPage::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MostVisitedPage>(message.name())) {
    case messages::MostVisitedPage::kSetMostVisitedInfo: {
      return &MostVisitedPage::SetMostVisitedInfo_Sym::IPCStableHash;
    }
    case messages::MostVisitedPage::kOnMostVisitedTilesAutoRemoval: {
      return &MostVisitedPage::OnMostVisitedTilesAutoRemoval_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MostVisitedPage::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MostVisitedPage>(message.name())) {
      case messages::MostVisitedPage::kSetMostVisitedInfo:
            return "Receive most_visited::mojom::MostVisitedPage::SetMostVisitedInfo";
      case messages::MostVisitedPage::kOnMostVisitedTilesAutoRemoval:
            return "Receive most_visited::mojom::MostVisitedPage::OnMostVisitedTilesAutoRemoval";
    }
  } else {
    switch (static_cast<messages::MostVisitedPage>(message.name())) {
      case messages::MostVisitedPage::kSetMostVisitedInfo:
            return "Receive reply most_visited::mojom::MostVisitedPage::SetMostVisitedInfo";
      case messages::MostVisitedPage::kOnMostVisitedTilesAutoRemoval:
            return "Receive reply most_visited::mojom::MostVisitedPage::OnMostVisitedTilesAutoRemoval";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MostVisitedPage::SetMostVisitedInfo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x97306b3b;  // IPCStableHash for most_visited::mojom::MostVisitedPage::SetMostVisitedInfo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MostVisitedPage::OnMostVisitedTilesAutoRemoval_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa4ca39af;  // IPCStableHash for most_visited::mojom::MostVisitedPage::OnMostVisitedTilesAutoRemoval
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

MostVisitedPageProxy::MostVisitedPageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MostVisitedPageProxy::SetMostVisitedInfo(
    MostVisitedInfoPtr in_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send most_visited::mojom::MostVisitedPage::SetMostVisitedInfo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info,
                        "<value of type MostVisitedInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MostVisitedPage::kSetMostVisitedInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::most_visited::mojom::internal::MostVisitedPage_SetMostVisitedInfo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType> info_fragment(
          params.message());
  
  mojo::internal::Serialize<::most_visited::mojom::MostVisitedInfoDataView>(
    in_info,
    info_fragment);

  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null info in MostVisitedPage.SetMostVisitedInfo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MostVisitedPage::Name_);
  message.set_method_name("SetMostVisitedInfo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MostVisitedPageProxy::OnMostVisitedTilesAutoRemoval(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send most_visited::mojom::MostVisitedPage::OnMostVisitedTilesAutoRemoval");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MostVisitedPage::kOnMostVisitedTilesAutoRemoval), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::most_visited::mojom::internal::MostVisitedPage_OnMostVisitedTilesAutoRemoval_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MostVisitedPage::Name_);
  message.set_method_name("OnMostVisitedTilesAutoRemoval");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool MostVisitedPageStubDispatch::Accept(
    MostVisitedPage* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MostVisitedPage>(message->header()->name)) {
    case messages::MostVisitedPage::kSetMostVisitedInfo: {
      DCHECK(message->is_serialized());
      internal::MostVisitedPage_SetMostVisitedInfo_Params_Data* params =
          reinterpret_cast<internal::MostVisitedPage_SetMostVisitedInfo_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MostVisitedPage.0
      bool success = true;
      MostVisitedInfoPtr p_info{};
      MostVisitedPage_SetMostVisitedInfo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInfo(&p_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MostVisitedPage::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetMostVisitedInfo(        
        std::move(p_info));
      return true;
    }
    case messages::MostVisitedPage::kOnMostVisitedTilesAutoRemoval: {
      DCHECK(message->is_serialized());
      internal::MostVisitedPage_OnMostVisitedTilesAutoRemoval_Params_Data* params =
          reinterpret_cast<internal::MostVisitedPage_OnMostVisitedTilesAutoRemoval_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MostVisitedPage.1
      bool success = true;
      MostVisitedPage_OnMostVisitedTilesAutoRemoval_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MostVisitedPage::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnMostVisitedTilesAutoRemoval(        );
      return true;
    }
  }
  return false;
}

// static
bool MostVisitedPageStubDispatch::AcceptWithResponder(
    MostVisitedPage* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MostVisitedPage>(message->header()->name)) {
    case messages::MostVisitedPage::kSetMostVisitedInfo: {
      break;
    }
    case messages::MostVisitedPage::kOnMostVisitedTilesAutoRemoval: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kMostVisitedPageValidationInfo[] = {
    { &internal::MostVisitedPage_SetMostVisitedInfo_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MostVisitedPage_OnMostVisitedTilesAutoRemoval_Params_Data::Validate,
     nullptr /* no response */},
};

bool MostVisitedPageRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::most_visited::mojom::MostVisitedPage::Name_,
    kMostVisitedPageValidationInfo);
}



}  // most_visited::mojom


namespace mojo {


// static
bool StructTraits<::most_visited::mojom::MostVisitedTile::DataView, ::most_visited::mojom::MostVisitedTilePtr>::Read(
    ::most_visited::mojom::MostVisitedTile::DataView input,
    ::most_visited::mojom::MostVisitedTilePtr* output) {
  bool success = true;
  ::most_visited::mojom::MostVisitedTilePtr result(::most_visited::mojom::MostVisitedTile::New());
  
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadTitleDirection(&result->title_direction))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success)
        result->is_query_tile = input.is_query_tile();
      if (success)
        result->allow_user_edit = input.allow_user_edit();
      if (success)
        result->allow_user_delete = input.allow_user_delete();
      if (success && !input.ReadSource(&result->source))
        success = false;
      if (success)
        result->title_source = input.title_source();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::most_visited::mojom::MostVisitedTheme::DataView, ::most_visited::mojom::MostVisitedThemePtr>::Read(
    ::most_visited::mojom::MostVisitedTheme::DataView input,
    ::most_visited::mojom::MostVisitedThemePtr* output) {
  bool success = true;
  ::most_visited::mojom::MostVisitedThemePtr result(::most_visited::mojom::MostVisitedTheme::New());
  
      if (success && !input.ReadBackgroundColor(&result->background_color))
        success = false;
      if (success)
        result->use_white_tile_icon = input.use_white_tile_icon();
      if (success)
        result->is_dark = input.is_dark();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::most_visited::mojom::MostVisitedInfo::DataView, ::most_visited::mojom::MostVisitedInfoPtr>::Read(
    ::most_visited::mojom::MostVisitedInfo::DataView input,
    ::most_visited::mojom::MostVisitedInfoPtr* output) {
  bool success = true;
  ::most_visited::mojom::MostVisitedInfoPtr result(::most_visited::mojom::MostVisitedInfo::New());
  
      if (success)
        result->custom_links_enabled = input.custom_links_enabled();
      if (success)
        result->enterprise_shortcuts_enabled = input.enterprise_shortcuts_enabled();
      if (success)
        result->visible = input.visible();
      if (success && !input.ReadTiles(&result->tiles))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace most_visited::mojom {


void MostVisitedPageHandlerFactoryInterceptorForTesting::CreatePageHandler(::mojo::PendingRemote<MostVisitedPage> page, ::mojo::PendingReceiver<MostVisitedPageHandler> handler) {
  GetForwardingInterface()->CreatePageHandler(
    std::move(page)
    , 
    std::move(handler)
    );
}
MostVisitedPageHandlerFactoryAsyncWaiter::MostVisitedPageHandlerFactoryAsyncWaiter(
    MostVisitedPageHandlerFactory* proxy) : proxy_(proxy) {}

MostVisitedPageHandlerFactoryAsyncWaiter::~MostVisitedPageHandlerFactoryAsyncWaiter() = default;





void MostVisitedPageHandlerInterceptorForTesting::AddMostVisitedTile(const ::GURL& url, const std::string& title, AddMostVisitedTileCallback callback) {
  GetForwardingInterface()->AddMostVisitedTile(
    std::move(url)
    , 
    std::move(title)
    , std::move(callback));
}
void MostVisitedPageHandlerInterceptorForTesting::DeleteMostVisitedTile(MostVisitedTilePtr tile) {
  GetForwardingInterface()->DeleteMostVisitedTile(
    std::move(tile)
    );
}
void MostVisitedPageHandlerInterceptorForTesting::ReorderMostVisitedTile(MostVisitedTilePtr tile, uint8_t new_pos) {
  GetForwardingInterface()->ReorderMostVisitedTile(
    std::move(tile)
    , 
    std::move(new_pos)
    );
}
void MostVisitedPageHandlerInterceptorForTesting::RestoreMostVisitedDefaults(::ntp_tiles::mojom::TileSource source) {
  GetForwardingInterface()->RestoreMostVisitedDefaults(
    std::move(source)
    );
}
void MostVisitedPageHandlerInterceptorForTesting::UndoMostVisitedAutoRemoval() {
  GetForwardingInterface()->UndoMostVisitedAutoRemoval();
}
void MostVisitedPageHandlerInterceptorForTesting::UndoMostVisitedTileAction(::ntp_tiles::mojom::TileSource source) {
  GetForwardingInterface()->UndoMostVisitedTileAction(
    std::move(source)
    );
}
void MostVisitedPageHandlerInterceptorForTesting::UpdateMostVisitedInfo() {
  GetForwardingInterface()->UpdateMostVisitedInfo();
}
void MostVisitedPageHandlerInterceptorForTesting::UpdateMostVisitedTile(MostVisitedTilePtr tile, const ::GURL& new_url, const std::string& new_title, UpdateMostVisitedTileCallback callback) {
  GetForwardingInterface()->UpdateMostVisitedTile(
    std::move(tile)
    , 
    std::move(new_url)
    , 
    std::move(new_title)
    , std::move(callback));
}
void MostVisitedPageHandlerInterceptorForTesting::PrerenderMostVisitedTile(MostVisitedTilePtr tile) {
  GetForwardingInterface()->PrerenderMostVisitedTile(
    std::move(tile)
    );
}
void MostVisitedPageHandlerInterceptorForTesting::PrefetchMostVisitedTile(MostVisitedTilePtr tile) {
  GetForwardingInterface()->PrefetchMostVisitedTile(
    std::move(tile)
    );
}
void MostVisitedPageHandlerInterceptorForTesting::PreconnectMostVisitedTile(MostVisitedTilePtr tile) {
  GetForwardingInterface()->PreconnectMostVisitedTile(
    std::move(tile)
    );
}
void MostVisitedPageHandlerInterceptorForTesting::CancelPrerender() {
  GetForwardingInterface()->CancelPrerender();
}
void MostVisitedPageHandlerInterceptorForTesting::GetMostVisitedExpandedState(GetMostVisitedExpandedStateCallback callback) {
  GetForwardingInterface()->GetMostVisitedExpandedState(std::move(callback));
}
void MostVisitedPageHandlerInterceptorForTesting::SetMostVisitedExpandedState(bool is_expanded) {
  GetForwardingInterface()->SetMostVisitedExpandedState(
    std::move(is_expanded)
    );
}
void MostVisitedPageHandlerInterceptorForTesting::OnMostVisitedTilesRendered(std::vector<MostVisitedTilePtr> tiles, double time) {
  GetForwardingInterface()->OnMostVisitedTilesRendered(
    std::move(tiles)
    , 
    std::move(time)
    );
}
void MostVisitedPageHandlerInterceptorForTesting::OnMostVisitedTileNavigation(MostVisitedTilePtr tile, uint32_t index, uint8_t mouse_button, bool alt_key, bool ctrl_key, bool meta_key, bool shift_key) {
  GetForwardingInterface()->OnMostVisitedTileNavigation(
    std::move(tile)
    , 
    std::move(index)
    , 
    std::move(mouse_button)
    , 
    std::move(alt_key)
    , 
    std::move(ctrl_key)
    , 
    std::move(meta_key)
    , 
    std::move(shift_key)
    );
}
MostVisitedPageHandlerAsyncWaiter::MostVisitedPageHandlerAsyncWaiter(
    MostVisitedPageHandler* proxy) : proxy_(proxy) {}

MostVisitedPageHandlerAsyncWaiter::~MostVisitedPageHandlerAsyncWaiter() = default;


void MostVisitedPageHandlerAsyncWaiter::AddMostVisitedTile(
    const ::GURL& url, const std::string& title, bool* out_success) {
  base::RunLoop loop;
  proxy_->AddMostVisitedTile(
      std::move(url),
      std::move(title),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool MostVisitedPageHandlerAsyncWaiter::AddMostVisitedTile(
    const ::GURL& url, const std::string& title) {
  bool async_wait_result;
  AddMostVisitedTile(std::move(url),std::move(title),&async_wait_result);
  return async_wait_result;
}

void MostVisitedPageHandlerAsyncWaiter::UpdateMostVisitedTile(
    MostVisitedTilePtr tile, const ::GURL& new_url, const std::string& new_title, bool* out_success) {
  base::RunLoop loop;
  proxy_->UpdateMostVisitedTile(
      std::move(tile),
      std::move(new_url),
      std::move(new_title),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool MostVisitedPageHandlerAsyncWaiter::UpdateMostVisitedTile(
    MostVisitedTilePtr tile, const ::GURL& new_url, const std::string& new_title) {
  bool async_wait_result;
  UpdateMostVisitedTile(std::move(tile),std::move(new_url),std::move(new_title),&async_wait_result);
  return async_wait_result;
}

void MostVisitedPageHandlerAsyncWaiter::GetMostVisitedExpandedState(
    bool* out_is_expanded) {
  base::RunLoop loop;
  proxy_->GetMostVisitedExpandedState(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_is_expanded
,
             bool is_expanded) {*out_is_expanded = std::move(is_expanded);
            loop->Quit();
          },
          &loop,
          out_is_expanded));
  loop.Run();
}

bool MostVisitedPageHandlerAsyncWaiter::GetMostVisitedExpandedState(
    ) {
  bool async_wait_result;
  GetMostVisitedExpandedState(&async_wait_result);
  return async_wait_result;
}




void MostVisitedPageInterceptorForTesting::SetMostVisitedInfo(MostVisitedInfoPtr info) {
  GetForwardingInterface()->SetMostVisitedInfo(
    std::move(info)
    );
}
void MostVisitedPageInterceptorForTesting::OnMostVisitedTilesAutoRemoval() {
  GetForwardingInterface()->OnMostVisitedTilesAutoRemoval();
}
MostVisitedPageAsyncWaiter::MostVisitedPageAsyncWaiter(
    MostVisitedPage* proxy) : proxy_(proxy) {}

MostVisitedPageAsyncWaiter::~MostVisitedPageAsyncWaiter() = default;







}  // most_visited::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif