// ui/webui/resources/cr_components/most_visited/most_visited.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_WEBUI_RESOURCES_CR_COMPONENTS_MOST_VISITED_MOST_VISITED_MOJOM_SHARED_H_
#define UI_WEBUI_RESOURCES_CR_COMPONENTS_MOST_VISITED_MOST_VISITED_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/webui/resources/cr_components/most_visited/most_visited.mojom-shared-internal.h"
#include "components/ntp_tiles/tile_source.mojom-shared.h"
#include "mojo/public/mojom/base/text_direction.mojom-shared.h"
#include "skia/public/mojom/skcolor.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "ui/webui/resources/cr_components/most_visited/most_visited.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::most_visited::mojom::MostVisitedTileDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::most_visited::mojom::MostVisitedTileDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::most_visited::mojom::internal::MostVisitedTile_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in MostVisitedTile struct");

    
    mojo::internal::Serialize<::mojo_base::mojom::TextDirection>(
      Traits::title_direction(input),
      &fragment->title_direction);

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in MostVisitedTile struct");

    fragment->is_query_tile = Traits::is_query_tile(input);

    fragment->allow_user_edit = Traits::allow_user_edit(input);

    fragment->allow_user_delete = Traits::allow_user_delete(input);

    
    mojo::internal::Serialize<::ntp_tiles::mojom::TileSource>(
      Traits::source(input),
      &fragment->source);

    fragment->title_source = Traits::title_source(input);
  }

  static bool Deserialize(::most_visited::mojom::internal::MostVisitedTile_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::most_visited::mojom::MostVisitedTileDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::most_visited::mojom::MostVisitedThemeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::most_visited::mojom::MostVisitedThemeDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::most_visited::mojom::internal::MostVisitedTheme_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::background_color(input)) in_background_color = Traits::background_color(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->background_color)::BaseType> background_color_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::skia::mojom::SkColorDataView>(
      in_background_color,
      background_color_fragment);

    fragment->background_color.Set(
        background_color_fragment.is_null() ? nullptr : background_color_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->background_color.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null background_color in MostVisitedTheme struct");

    fragment->use_white_tile_icon = Traits::use_white_tile_icon(input);

    fragment->is_dark = Traits::is_dark(input);
  }

  static bool Deserialize(::most_visited::mojom::internal::MostVisitedTheme_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::most_visited::mojom::MostVisitedThemeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::most_visited::mojom::MostVisitedInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::most_visited::mojom::MostVisitedInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::most_visited::mojom::internal::MostVisitedInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->custom_links_enabled = Traits::custom_links_enabled(input);

    fragment->enterprise_shortcuts_enabled = Traits::enterprise_shortcuts_enabled(input);

    fragment->visible = Traits::visible(input);

    decltype(Traits::tiles(input)) in_tiles = Traits::tiles(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tiles)::BaseType>
        tiles_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& tiles_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::most_visited::mojom::MostVisitedTileDataView>>(
      in_tiles,
      tiles_fragment,
      &tiles_validate_params);

    fragment->tiles.Set(
        tiles_fragment.is_null() ? nullptr : tiles_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->tiles.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null tiles in MostVisitedInfo struct");
  }

  static bool Deserialize(::most_visited::mojom::internal::MostVisitedInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::most_visited::mojom::MostVisitedInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace most_visited::mojom {

inline void MostVisitedTileDataView::GetTitleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->title.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MostVisitedTileDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void MostVisitedThemeDataView::GetBackgroundColorDataView(
    ::skia::mojom::SkColorDataView* output) {
  auto pointer = data_->background_color.Get();
  *output = ::skia::mojom::SkColorDataView(pointer, message_);
}


inline void MostVisitedInfoDataView::GetTilesDataView(
    mojo::ArrayDataView<MostVisitedTileDataView>* output) {
  auto pointer = data_->tiles.Get();
  *output = mojo::ArrayDataView<MostVisitedTileDataView>(pointer, message_);
}



}  // most_visited::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // UI_WEBUI_RESOURCES_CR_COMPONENTS_MOST_VISITED_MOST_VISITED_MOJOM_SHARED_H_