// ui/webui/resources/cr_components/history_embeddings/history_embeddings.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/webui/resources/cr_components/history_embeddings/history_embeddings.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/webui/resources/cr_components/history_embeddings/history_embeddings.mojom-params-data.h"
#include "ui/webui/resources/cr_components/history_embeddings/history_embeddings.mojom-shared-message-ids.h"

#include "ui/webui/resources/cr_components/history_embeddings/history_embeddings.mojom-import-headers.h"
#include "ui/webui/resources/cr_components/history_embeddings/history_embeddings.mojom-test-utils.h"


namespace history_embeddings::mojom {
AnswerData::AnswerData()
    : answer_text_directives() {}

AnswerData::AnswerData(
    std::vector<std::string> answer_text_directives_in)
    : answer_text_directives(std::move(answer_text_directives_in)) {}

AnswerData::~AnswerData() = default;

void AnswerData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "answer_text_directives"), this->answer_text_directives,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AnswerData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SearchResultItem::SearchResultItem()
    : title(),
      url(),
      url_for_display(),
      relative_time(),
      short_date_time(),
      last_url_visit_timestamp(),
      source_passage(),
      answer_data(),
      is_url_known_to_sync() {}

SearchResultItem::SearchResultItem(
    const std::string& title_in,
    const ::GURL& url_in,
    const std::string& url_for_display_in,
    const std::string& relative_time_in,
    const std::string& short_date_time_in,
    double last_url_visit_timestamp_in,
    const std::string& source_passage_in,
    AnswerDataPtr answer_data_in,
    bool is_url_known_to_sync_in)
    : title(std::move(title_in)),
      url(std::move(url_in)),
      url_for_display(std::move(url_for_display_in)),
      relative_time(std::move(relative_time_in)),
      short_date_time(std::move(short_date_time_in)),
      last_url_visit_timestamp(std::move(last_url_visit_timestamp_in)),
      source_passage(std::move(source_passage_in)),
      answer_data(std::move(answer_data_in)),
      is_url_known_to_sync(std::move(is_url_known_to_sync_in)) {}

SearchResultItem::~SearchResultItem() = default;

void SearchResultItem::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url_for_display"), this->url_for_display,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "relative_time"), this->relative_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "short_date_time"), this->short_date_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "last_url_visit_timestamp"), this->last_url_visit_timestamp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_passage"), this->source_passage,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "answer_data"), this->answer_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AnswerDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_url_known_to_sync"), this->is_url_known_to_sync,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SearchResultItem::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SearchQuery::SearchQuery()
    : query(),
      time_range_start() {}

SearchQuery::SearchQuery(
    const std::string& query_in,
    std::optional<::base::Time> time_range_start_in)
    : query(std::move(query_in)),
      time_range_start(std::move(time_range_start_in)) {}

SearchQuery::~SearchQuery() = default;

void SearchQuery::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "query"), this->query,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "time_range_start"), this->time_range_start,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::Time>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SearchQuery::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SearchResult::SearchResult()
    : query(),
      answer_status(),
      answer(),
      items() {}

SearchResult::SearchResult(
    const std::string& query_in,
    AnswerStatus answer_status_in,
    const std::string& answer_in,
    std::vector<SearchResultItemPtr> items_in)
    : query(std::move(query_in)),
      answer_status(std::move(answer_status_in)),
      answer(std::move(answer_in)),
      items(std::move(items_in)) {}

SearchResult::~SearchResult() = default;

void SearchResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "query"), this->query,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "answer_status"), this->answer_status,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AnswerStatus>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "answer"), this->answer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "items"), this->items,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<SearchResultItemPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SearchResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

PageHandler::IPCStableHashFunction PageHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandler>(message.name())) {
    case messages::PageHandler::kSetPage: {
      return &PageHandler::SetPage_Sym::IPCStableHash;
    }
    case messages::PageHandler::kSearch: {
      return &PageHandler::Search_Sym::IPCStableHash;
    }
    case messages::PageHandler::kSendQualityLog: {
      return &PageHandler::SendQualityLog_Sym::IPCStableHash;
    }
    case messages::PageHandler::kRecordSearchResultsMetrics: {
      return &PageHandler::RecordSearchResultsMetrics_Sym::IPCStableHash;
    }
    case messages::PageHandler::kSetUserFeedback: {
      return &PageHandler::SetUserFeedback_Sym::IPCStableHash;
    }
    case messages::PageHandler::kMaybeShowFeaturePromo: {
      return &PageHandler::MaybeShowFeaturePromo_Sym::IPCStableHash;
    }
    case messages::PageHandler::kOpenSettingsPage: {
      return &PageHandler::OpenSettingsPage_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kSetPage:
            return "Receive history_embeddings::mojom::PageHandler::SetPage";
      case messages::PageHandler::kSearch:
            return "Receive history_embeddings::mojom::PageHandler::Search";
      case messages::PageHandler::kSendQualityLog:
            return "Receive history_embeddings::mojom::PageHandler::SendQualityLog";
      case messages::PageHandler::kRecordSearchResultsMetrics:
            return "Receive history_embeddings::mojom::PageHandler::RecordSearchResultsMetrics";
      case messages::PageHandler::kSetUserFeedback:
            return "Receive history_embeddings::mojom::PageHandler::SetUserFeedback";
      case messages::PageHandler::kMaybeShowFeaturePromo:
            return "Receive history_embeddings::mojom::PageHandler::MaybeShowFeaturePromo";
      case messages::PageHandler::kOpenSettingsPage:
            return "Receive history_embeddings::mojom::PageHandler::OpenSettingsPage";
    }
  } else {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kSetPage:
            return "Receive reply history_embeddings::mojom::PageHandler::SetPage";
      case messages::PageHandler::kSearch:
            return "Receive reply history_embeddings::mojom::PageHandler::Search";
      case messages::PageHandler::kSendQualityLog:
            return "Receive reply history_embeddings::mojom::PageHandler::SendQualityLog";
      case messages::PageHandler::kRecordSearchResultsMetrics:
            return "Receive reply history_embeddings::mojom::PageHandler::RecordSearchResultsMetrics";
      case messages::PageHandler::kSetUserFeedback:
            return "Receive reply history_embeddings::mojom::PageHandler::SetUserFeedback";
      case messages::PageHandler::kMaybeShowFeaturePromo:
            return "Receive reply history_embeddings::mojom::PageHandler::MaybeShowFeaturePromo";
      case messages::PageHandler::kOpenSettingsPage:
            return "Receive reply history_embeddings::mojom::PageHandler::OpenSettingsPage";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandler::SetPage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x41dc2b46;  // IPCStableHash for history_embeddings::mojom::PageHandler::SetPage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::Search_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x30764a39;  // IPCStableHash for history_embeddings::mojom::PageHandler::Search
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::SendQualityLog_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe52428bb;  // IPCStableHash for history_embeddings::mojom::PageHandler::SendQualityLog
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::RecordSearchResultsMetrics_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7e3ab384;  // IPCStableHash for history_embeddings::mojom::PageHandler::RecordSearchResultsMetrics
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::SetUserFeedback_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2a667ed9;  // IPCStableHash for history_embeddings::mojom::PageHandler::SetUserFeedback
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::MaybeShowFeaturePromo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4bb40c78;  // IPCStableHash for history_embeddings::mojom::PageHandler::MaybeShowFeaturePromo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::OpenSettingsPage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfd1396a0;  // IPCStableHash for history_embeddings::mojom::PageHandler::OpenSettingsPage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageHandlerProxy::PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerProxy::SetPage(
    ::mojo::PendingRemote<Page> in_page) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send history_embeddings::mojom::PageHandler::SetPage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page"), in_page,
                        "<value of type ::mojo::PendingRemote<Page>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSetPage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history_embeddings::mojom::internal::PageHandler_SetPage_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::history_embeddings::mojom::PageInterfaceBase>>(
    in_page,
    &params->page,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->page)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid page in PageHandler.SetPage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SetPage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::Search(
    SearchQueryPtr in_query) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send history_embeddings::mojom::PageHandler::Search", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("query"), in_query,
                        "<value of type SearchQueryPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSearch), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history_embeddings::mojom::internal::PageHandler_Search_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->query)::BaseType> query_fragment(
          params.message());
  
  mojo::internal::Serialize<::history_embeddings::mojom::SearchQueryDataView>(
    in_query,
    query_fragment);

  params->query.Set(
      query_fragment.is_null() ? nullptr : query_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->query.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null query in PageHandler.Search request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("Search");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::SendQualityLog(
    const std::vector<uint32_t>& in_selected_indices, uint32_t in_num_entered_chars) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send history_embeddings::mojom::PageHandler::SendQualityLog", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("selected_indices"), in_selected_indices,
                        "<value of type const std::vector<uint32_t>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("num_entered_chars"), in_num_entered_chars,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSendQualityLog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history_embeddings::mojom::internal::PageHandler_SendQualityLog_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->selected_indices)::BaseType>
      selected_indices_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& selected_indices_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint32_t>>(
    in_selected_indices,
    selected_indices_fragment,
    &selected_indices_validate_params);

  params->selected_indices.Set(
      selected_indices_fragment.is_null() ? nullptr : selected_indices_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->selected_indices.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null selected_indices in PageHandler.SendQualityLog request");

  params->num_entered_chars = in_num_entered_chars;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SendQualityLog");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::RecordSearchResultsMetrics(
    bool in_nonEmptyResults, bool in_userClickedResult, bool in_answerShown, bool in_answerCitationClicked, bool in_otherHistoryResultClicked, uint32_t in_queryWordCount) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send history_embeddings::mojom::PageHandler::RecordSearchResultsMetrics", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("nonEmptyResults"), in_nonEmptyResults,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("userClickedResult"), in_userClickedResult,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("answerShown"), in_answerShown,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("answerCitationClicked"), in_answerCitationClicked,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("otherHistoryResultClicked"), in_otherHistoryResultClicked,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("queryWordCount"), in_queryWordCount,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kRecordSearchResultsMetrics), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history_embeddings::mojom::internal::PageHandler_RecordSearchResultsMetrics_Params_Data> params(
          message);
  params.Allocate();

  params->nonEmptyResults = in_nonEmptyResults;

  params->userClickedResult = in_userClickedResult;

  params->answerShown = in_answerShown;

  params->answerCitationClicked = in_answerCitationClicked;

  params->otherHistoryResultClicked = in_otherHistoryResultClicked;

  params->queryWordCount = in_queryWordCount;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("RecordSearchResultsMetrics");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::SetUserFeedback(
    UserFeedback in_feedback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send history_embeddings::mojom::PageHandler::SetUserFeedback", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("feedback"), in_feedback,
                        "<value of type UserFeedback>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSetUserFeedback), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history_embeddings::mojom::internal::PageHandler_SetUserFeedback_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::history_embeddings::mojom::UserFeedback>(
    in_feedback,
    &params->feedback);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SetUserFeedback");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::MaybeShowFeaturePromo(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send history_embeddings::mojom::PageHandler::MaybeShowFeaturePromo");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kMaybeShowFeaturePromo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history_embeddings::mojom::internal::PageHandler_MaybeShowFeaturePromo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("MaybeShowFeaturePromo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::OpenSettingsPage(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send history_embeddings::mojom::PageHandler::OpenSettingsPage");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kOpenSettingsPage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history_embeddings::mojom::internal::PageHandler_OpenSettingsPage_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("OpenSettingsPage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageHandlerStubDispatch::Accept(
    PageHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kSetPage: {
      DCHECK(message->is_serialized());
      internal::PageHandler_SetPage_Params_Data* params =
          reinterpret_cast<internal::PageHandler_SetPage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.0
      bool success = true;
      ::mojo::PendingRemote<Page> p_page{};
      PageHandler_SetPage_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_page =
            input_data_view.TakePage<decltype(p_page)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPage(        
        std::move(p_page));
      return true;
    }
    case messages::PageHandler::kSearch: {
      DCHECK(message->is_serialized());
      internal::PageHandler_Search_Params_Data* params =
          reinterpret_cast<internal::PageHandler_Search_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.1
      bool success = true;
      SearchQueryPtr p_query{};
      PageHandler_Search_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadQuery(&p_query))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Search(        
        std::move(p_query));
      return true;
    }
    case messages::PageHandler::kSendQualityLog: {
      DCHECK(message->is_serialized());
      internal::PageHandler_SendQualityLog_Params_Data* params =
          reinterpret_cast<internal::PageHandler_SendQualityLog_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.2
      bool success = true;
      std::vector<uint32_t> p_selected_indices{};
      uint32_t p_num_entered_chars{};
      PageHandler_SendQualityLog_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSelectedIndices(&p_selected_indices))
        success = false;
      if (success)
        p_num_entered_chars = input_data_view.num_entered_chars();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendQualityLog(        
        std::move(p_selected_indices), 
        std::move(p_num_entered_chars));
      return true;
    }
    case messages::PageHandler::kRecordSearchResultsMetrics: {
      DCHECK(message->is_serialized());
      internal::PageHandler_RecordSearchResultsMetrics_Params_Data* params =
          reinterpret_cast<internal::PageHandler_RecordSearchResultsMetrics_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.3
      bool success = true;
      bool p_nonEmptyResults{};
      bool p_userClickedResult{};
      bool p_answerShown{};
      bool p_answerCitationClicked{};
      bool p_otherHistoryResultClicked{};
      uint32_t p_queryWordCount{};
      PageHandler_RecordSearchResultsMetrics_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_nonEmptyResults = input_data_view.nonEmptyResults();
      if (success)
        p_userClickedResult = input_data_view.userClickedResult();
      if (success)
        p_answerShown = input_data_view.answerShown();
      if (success)
        p_answerCitationClicked = input_data_view.answerCitationClicked();
      if (success)
        p_otherHistoryResultClicked = input_data_view.otherHistoryResultClicked();
      if (success)
        p_queryWordCount = input_data_view.queryWordCount();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RecordSearchResultsMetrics(        
        std::move(p_nonEmptyResults), 
        std::move(p_userClickedResult), 
        std::move(p_answerShown), 
        std::move(p_answerCitationClicked), 
        std::move(p_otherHistoryResultClicked), 
        std::move(p_queryWordCount));
      return true;
    }
    case messages::PageHandler::kSetUserFeedback: {
      DCHECK(message->is_serialized());
      internal::PageHandler_SetUserFeedback_Params_Data* params =
          reinterpret_cast<internal::PageHandler_SetUserFeedback_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.4
      bool success = true;
      UserFeedback p_feedback{};
      PageHandler_SetUserFeedback_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFeedback(&p_feedback))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetUserFeedback(        
        std::move(p_feedback));
      return true;
    }
    case messages::PageHandler::kMaybeShowFeaturePromo: {
      DCHECK(message->is_serialized());
      internal::PageHandler_MaybeShowFeaturePromo_Params_Data* params =
          reinterpret_cast<internal::PageHandler_MaybeShowFeaturePromo_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.5
      bool success = true;
      PageHandler_MaybeShowFeaturePromo_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MaybeShowFeaturePromo(        );
      return true;
    }
    case messages::PageHandler::kOpenSettingsPage: {
      DCHECK(message->is_serialized());
      internal::PageHandler_OpenSettingsPage_Params_Data* params =
          reinterpret_cast<internal::PageHandler_OpenSettingsPage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.6
      bool success = true;
      PageHandler_OpenSettingsPage_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenSettingsPage(        );
      return true;
    }
  }
  return false;
}

// static
bool PageHandlerStubDispatch::AcceptWithResponder(
    PageHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kSetPage: {
      break;
    }
    case messages::PageHandler::kSearch: {
      break;
    }
    case messages::PageHandler::kSendQualityLog: {
      break;
    }
    case messages::PageHandler::kRecordSearchResultsMetrics: {
      break;
    }
    case messages::PageHandler::kSetUserFeedback: {
      break;
    }
    case messages::PageHandler::kMaybeShowFeaturePromo: {
      break;
    }
    case messages::PageHandler::kOpenSettingsPage: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageHandlerValidationInfo[] = {
    { &internal::PageHandler_SetPage_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_Search_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_SendQualityLog_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_RecordSearchResultsMetrics_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_SetUserFeedback_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_MaybeShowFeaturePromo_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_OpenSettingsPage_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::history_embeddings::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}

// The declaration includes the definition on other builds.

Page::IPCStableHashFunction Page::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Page>(message.name())) {
    case messages::Page::kSearchResultChanged: {
      return &Page::SearchResultChanged_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Page::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kSearchResultChanged:
            return "Receive history_embeddings::mojom::Page::SearchResultChanged";
    }
  } else {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kSearchResultChanged:
            return "Receive reply history_embeddings::mojom::Page::SearchResultChanged";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Page::SearchResultChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd4f71008;  // IPCStableHash for history_embeddings::mojom::Page::SearchResultChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageProxy::PageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageProxy::SearchResultChanged(
    SearchResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send history_embeddings::mojom::Page::SearchResultChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type SearchResultPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kSearchResultChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history_embeddings::mojom::internal::Page_SearchResultChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::history_embeddings::mojom::SearchResultDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in Page.SearchResultChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("SearchResultChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageStubDispatch::Accept(
    Page* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kSearchResultChanged: {
      DCHECK(message->is_serialized());
      internal::Page_SearchResultChanged_Params_Data* params =
          reinterpret_cast<internal::Page_SearchResultChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.0
      bool success = true;
      SearchResultPtr p_result{};
      Page_SearchResultChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResult(&p_result))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SearchResultChanged(        
        std::move(p_result));
      return true;
    }
  }
  return false;
}

// static
bool PageStubDispatch::AcceptWithResponder(
    Page* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kSearchResultChanged: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageValidationInfo[] = {
    { &internal::Page_SearchResultChanged_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::history_embeddings::mojom::Page::Name_,
    kPageValidationInfo);
}



}  // history_embeddings::mojom


namespace mojo {


// static
bool StructTraits<::history_embeddings::mojom::AnswerData::DataView, ::history_embeddings::mojom::AnswerDataPtr>::Read(
    ::history_embeddings::mojom::AnswerData::DataView input,
    ::history_embeddings::mojom::AnswerDataPtr* output) {
  bool success = true;
  ::history_embeddings::mojom::AnswerDataPtr result(::history_embeddings::mojom::AnswerData::New());
  
      if (success && !input.ReadAnswerTextDirectives(&result->answer_text_directives))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::history_embeddings::mojom::SearchResultItem::DataView, ::history_embeddings::mojom::SearchResultItemPtr>::Read(
    ::history_embeddings::mojom::SearchResultItem::DataView input,
    ::history_embeddings::mojom::SearchResultItemPtr* output) {
  bool success = true;
  ::history_embeddings::mojom::SearchResultItemPtr result(::history_embeddings::mojom::SearchResultItem::New());
  
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadUrlForDisplay(&result->url_for_display))
        success = false;
      if (success && !input.ReadRelativeTime(&result->relative_time))
        success = false;
      if (success && !input.ReadShortDateTime(&result->short_date_time))
        success = false;
      if (success)
        result->last_url_visit_timestamp = input.last_url_visit_timestamp();
      if (success && !input.ReadSourcePassage(&result->source_passage))
        success = false;
      if (success && !input.ReadAnswerData(&result->answer_data))
        success = false;
      if (success)
        result->is_url_known_to_sync = input.is_url_known_to_sync();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::history_embeddings::mojom::SearchQuery::DataView, ::history_embeddings::mojom::SearchQueryPtr>::Read(
    ::history_embeddings::mojom::SearchQuery::DataView input,
    ::history_embeddings::mojom::SearchQueryPtr* output) {
  bool success = true;
  ::history_embeddings::mojom::SearchQueryPtr result(::history_embeddings::mojom::SearchQuery::New());
  
      if (success && !input.ReadQuery(&result->query))
        success = false;
      if (success && !input.ReadTimeRangeStart(&result->time_range_start))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::history_embeddings::mojom::SearchResult::DataView, ::history_embeddings::mojom::SearchResultPtr>::Read(
    ::history_embeddings::mojom::SearchResult::DataView input,
    ::history_embeddings::mojom::SearchResultPtr* output) {
  bool success = true;
  ::history_embeddings::mojom::SearchResultPtr result(::history_embeddings::mojom::SearchResult::New());
  
      if (success && !input.ReadQuery(&result->query))
        success = false;
      if (success && !input.ReadAnswerStatus(&result->answer_status))
        success = false;
      if (success && !input.ReadAnswer(&result->answer))
        success = false;
      if (success && !input.ReadItems(&result->items))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace history_embeddings::mojom {


void PageHandlerInterceptorForTesting::SetPage(::mojo::PendingRemote<Page> page) {
  GetForwardingInterface()->SetPage(
    std::move(page)
    );
}
void PageHandlerInterceptorForTesting::Search(SearchQueryPtr query) {
  GetForwardingInterface()->Search(
    std::move(query)
    );
}
void PageHandlerInterceptorForTesting::SendQualityLog(const std::vector<uint32_t>& selected_indices, uint32_t num_entered_chars) {
  GetForwardingInterface()->SendQualityLog(
    std::move(selected_indices)
    , 
    std::move(num_entered_chars)
    );
}
void PageHandlerInterceptorForTesting::RecordSearchResultsMetrics(bool nonEmptyResults, bool userClickedResult, bool answerShown, bool answerCitationClicked, bool otherHistoryResultClicked, uint32_t queryWordCount) {
  GetForwardingInterface()->RecordSearchResultsMetrics(
    std::move(nonEmptyResults)
    , 
    std::move(userClickedResult)
    , 
    std::move(answerShown)
    , 
    std::move(answerCitationClicked)
    , 
    std::move(otherHistoryResultClicked)
    , 
    std::move(queryWordCount)
    );
}
void PageHandlerInterceptorForTesting::SetUserFeedback(UserFeedback feedback) {
  GetForwardingInterface()->SetUserFeedback(
    std::move(feedback)
    );
}
void PageHandlerInterceptorForTesting::MaybeShowFeaturePromo() {
  GetForwardingInterface()->MaybeShowFeaturePromo();
}
void PageHandlerInterceptorForTesting::OpenSettingsPage() {
  GetForwardingInterface()->OpenSettingsPage();
}
PageHandlerAsyncWaiter::PageHandlerAsyncWaiter(
    PageHandler* proxy) : proxy_(proxy) {}

PageHandlerAsyncWaiter::~PageHandlerAsyncWaiter() = default;





void PageInterceptorForTesting::SearchResultChanged(SearchResultPtr result) {
  GetForwardingInterface()->SearchResultChanged(
    std::move(result)
    );
}
PageAsyncWaiter::PageAsyncWaiter(
    Page* proxy) : proxy_(proxy) {}

PageAsyncWaiter::~PageAsyncWaiter() = default;







}  // history_embeddings::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif