// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"./cluster.js";import"./history_clusters_shared_style.css.js";import"//resources/cr_elements/cr_button/cr_button.js";import"//resources/cr_elements/cr_dialog/cr_dialog.js";import"//resources/cr_elements/cr_infinite_list/cr_infinite_list.js";import"//resources/cr_elements/cr_lazy_render/cr_lazy_render.js";import"//resources/cr_elements/cr_toast/cr_toast.js";import{I18nMixinLit}from"//resources/cr_elements/i18n_mixin_lit.js";import{assert}from"//resources/js/assert.js";import{FocusOutlineManager}from"//resources/js/focus_outline_manager.js";import{loadTimeData}from"//resources/js/load_time_data.js";import{CrLitElement}from"//resources/lit/v3_0/lit.rollup.js";import{BrowserProxyImpl}from"./browser_proxy.js";import{getCss}from"./clusters.css.js";import{getHtml}from"./clusters.html.js";function jsDateToMojoDate(date){const windowsEpoch=Date.UTC(1601,0,1,0,0,0,0);const unixEpoch=Date.UTC(1970,0,1,0,0,0,0);const epochDeltaInMs=unixEpoch-windowsEpoch;const internalValue=BigInt(date.valueOf()+epochDeltaInMs)*BigInt(1e3);return{internalValue:internalValue}}const HistoryClustersElementBase=I18nMixinLit(CrLitElement);export class HistoryClustersElement extends HistoryClustersElementBase{static get is(){return"history-clusters"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{inSidePanel_:{type:Boolean,reflect:true},query:{type:String},timeRangeStart:{type:Object},canLoadMore_:{type:Boolean},clusters_:{type:Array},hasResult_:{type:Boolean},resultQuery_:{type:String},showSpinner_:{type:Boolean},showConfirmationDialog_:{type:Boolean},visitsToBeRemoved_:{type:Array},scrollOffset:{type:Number},scrollTarget:{type:Object},isActive:{type:Boolean,reflect:true},isEmpty:{type:Boolean,reflect:true}}}#isActive_accessor_storage=true;get isActive(){return this.#isActive_accessor_storage}set isActive(value){this.#isActive_accessor_storage=value}#isEmpty_accessor_storage=true;get isEmpty(){return this.#isEmpty_accessor_storage}set isEmpty(value){this.#isEmpty_accessor_storage=value}#query_accessor_storage="";get query(){return this.#query_accessor_storage}set query(value){this.#query_accessor_storage=value}#scrollOffset_accessor_storage=0;get scrollOffset(){return this.#scrollOffset_accessor_storage}set scrollOffset(value){this.#scrollOffset_accessor_storage=value}#scrollTarget_accessor_storage=document.documentElement;get scrollTarget(){return this.#scrollTarget_accessor_storage}set scrollTarget(value){this.#scrollTarget_accessor_storage=value}#timeRangeStart_accessor_storage;get timeRangeStart(){return this.#timeRangeStart_accessor_storage}set timeRangeStart(value){this.#timeRangeStart_accessor_storage=value}#canLoadMore__accessor_storage=false;get canLoadMore_(){return this.#canLoadMore__accessor_storage}set canLoadMore_(value){this.#canLoadMore__accessor_storage=value}#clusters__accessor_storage=[];get clusters_(){return this.#clusters__accessor_storage}set clusters_(value){this.#clusters__accessor_storage=value}#hasResult__accessor_storage=false;get hasResult_(){return this.#hasResult__accessor_storage}set hasResult_(value){this.#hasResult__accessor_storage=value}#resultQuery__accessor_storage="";get resultQuery_(){return this.#resultQuery__accessor_storage}set resultQuery_(value){this.#resultQuery__accessor_storage=value}callbackRouter_;#inSidePanel__accessor_storage=loadTimeData.getBoolean("inSidePanel");get inSidePanel_(){return this.#inSidePanel__accessor_storage}set inSidePanel_(value){this.#inSidePanel__accessor_storage=value}lastOffsetHeight_=0;resizeObserver_=new ResizeObserver((()=>{if(this.lastOffsetHeight_===0){this.lastOffsetHeight_=this.scrollTarget.offsetHeight;return}if(this.scrollTarget.offsetHeight>this.lastOffsetHeight_){this.lastOffsetHeight_=this.scrollTarget.offsetHeight;this.onScrollOrResize_()}}));scrollDebounce_=200;scrollListener_=()=>this.onScrollOrResize_();onClustersQueryResultListenerId_=null;onClusterImageUpdatedListenerId_=null;onVisitsRemovedListenerId_=null;onHistoryDeletedListenerId_=null;onQueryChangedByUserListenerId_=null;pageHandler_;#showConfirmationDialog__accessor_storage=false;get showConfirmationDialog_(){return this.#showConfirmationDialog__accessor_storage}set showConfirmationDialog_(value){this.#showConfirmationDialog__accessor_storage=value}#showSpinner__accessor_storage=false;get showSpinner_(){return this.#showSpinner__accessor_storage}set showSpinner_(value){this.#showSpinner__accessor_storage=value}scrollTimeout_=null;#visitsToBeRemoved__accessor_storage=[];get visitsToBeRemoved_(){return this.#visitsToBeRemoved__accessor_storage}set visitsToBeRemoved_(value){this.#visitsToBeRemoved__accessor_storage=value}constructor(){super();this.pageHandler_=BrowserProxyImpl.getInstance().handler;this.callbackRouter_=BrowserProxyImpl.getInstance().callbackRouter}connectedCallback(){super.connectedCallback();FocusOutlineManager.forDocument(document);this.onClustersQueryResultListenerId_=this.callbackRouter_.onClustersQueryResult.addListener(this.onClustersQueryResult_.bind(this));this.onClusterImageUpdatedListenerId_=this.callbackRouter_.onClusterImageUpdated.addListener(this.onClusterImageUpdated_.bind(this));this.onVisitsRemovedListenerId_=this.callbackRouter_.onVisitsRemoved.addListener(this.onVisitsRemoved_.bind(this));this.onHistoryDeletedListenerId_=this.callbackRouter_.onHistoryDeleted.addListener(this.onHistoryDeleted_.bind(this));this.onQueryChangedByUserListenerId_=this.callbackRouter_.onQueryChangedByUser.addListener(this.onQueryChangedByUser_.bind(this));if(this.inSidePanel_){this.pageHandler_.showSidePanelUI()}}disconnectedCallback(){super.disconnectedCallback();assert(this.onClustersQueryResultListenerId_);this.callbackRouter_.removeListener(this.onClustersQueryResultListenerId_);this.onClustersQueryResultListenerId_=null;assert(this.onVisitsRemovedListenerId_);this.callbackRouter_.removeListener(this.onVisitsRemovedListenerId_);this.onVisitsRemovedListenerId_=null;assert(this.onHistoryDeletedListenerId_);this.callbackRouter_.removeListener(this.onHistoryDeletedListenerId_);this.onHistoryDeletedListenerId_=null;assert(this.onQueryChangedByUserListenerId_);this.callbackRouter_.removeListener(this.onQueryChangedByUserListenerId_);this.onQueryChangedByUserListenerId_=null;assert(this.onClusterImageUpdatedListenerId_);this.callbackRouter_.removeListener(this.onClusterImageUpdatedListenerId_);this.onClusterImageUpdatedListenerId_=null}willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("query")||changedProperties.has("timeRangeStart")){this.onQueryChanged_()}const changedPrivateProperties=changedProperties;if(changedPrivateProperties.has("hasResult_")||changedPrivateProperties.has("clusters_")){this.isEmpty=this.hasResult_&&this.clusters_.length===0}}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("scrollTarget")){const oldTarget=changedProperties.get("scrollTarget");if(oldTarget){this.resizeObserver_.disconnect();if(this.isActive||changedProperties.has("isActive")){oldTarget.removeEventListener("scroll",this.scrollListener_)}}if(this.scrollTarget){this.resizeObserver_.observe(this.scrollTarget);if(this.isActive){this.scrollTarget.addEventListener("scroll",this.scrollListener_)}}}else if(changedProperties.has("isActive")){if(this.isActive){this.scrollTarget.addEventListener("scroll",this.scrollListener_)}else{this.scrollTarget.removeEventListener("scroll",this.scrollListener_)}}const changedPrivateProperties=changedProperties;if(changedPrivateProperties.has("clusters_")){const previous=changedPrivateProperties.get("clusters_");const clustersRemoved=previous&&previous.length>this.clusters_.length;if(clustersRemoved&&this.canLoadMore_&&this.$.clusters.offsetHeight<this.scrollTarget.offsetHeight){this.onLoadMoreButtonClick_()}}}onCancelButtonClick_(){this.visitsToBeRemoved_=[];this.getConfirmationDialog_().close()}onConfirmationDialogCancel_(){this.visitsToBeRemoved_=[]}onLoadMoreButtonClick_(){if(this.hasResult_&&this.canLoadMore_){this.showSpinner_=true;this.canLoadMore_=false;this.pageHandler_.loadMoreClusters(this.resultQuery_)}}onRemoveButtonClick_(){this.removeVisits_();this.getConfirmationDialog_().close()}onHideVisit_(event){this.pageHandler_.hideVisits([event.detail])}onHideVisits_(event){this.pageHandler_.hideVisits(event.detail)}onRemoveCluster_(event){const index=event.detail;this.clusters_=[...this.clusters_.slice(0,index),...this.clusters_.slice(index+1)]}async onRemoveVisits_(event){if(this.visitsToBeRemoved_.length){return}this.visitsToBeRemoved_=event.detail;if(this.visitsToBeRemoved_.length===1){this.removeVisits_();return}if(!this.showConfirmationDialog_){this.showConfirmationDialog_=true;await this.updateComplete}this.getConfirmationDialog_().showModal()}setScrollDebounceForTest(debounce){this.scrollDebounce_=debounce}onScrolledToBottom_(){if(this.shadowRoot.querySelector(":focus-visible")){return}this.onLoadMoreButtonClick_()}getConfirmationDialog_(){const dialog=this.shadowRoot.querySelector("cr-dialog");assert(dialog);return dialog}computePlaceholderText_(){if(!this.hasResult_){return""}return this.clusters_.length?"":loadTimeData.getString(this.resultQuery_?"noSearchResults":"historyClustersNoResults")}getLoadMoreButtonHidden_(){return!this.hasResult_||this.clusters_.length===0||!this.canLoadMore_}isLastCluster_(index){return index===this.clusters_.length-1}onBrowserIdle_(){return new Promise((resolve=>{requestIdleCallback((()=>{resolve()}))}))}onClustersQueryResult_(result){this.hasResult_=true;this.canLoadMore_=result.canLoadMore;if(result.isContinuation){this.clusters_=[...this.clusters_.slice(),...result.clusters]}else{this.scrollTarget.scrollTop=0;this.clusters_=result.clusters;this.resultQuery_=result.query}this.onBrowserIdle_().then((()=>{if((this.$.clusters.offsetHeight<this.scrollTarget.offsetHeight||this.scrollTarget.scrollHeight<=this.scrollTarget.clientHeight)&&this.canLoadMore_){this.onLoadMoreButtonClick_()}}));this.showSpinner_=false}onClusterImageUpdated_(clusterIndex,imageUrl){const cluster=this.clusters_[clusterIndex];const newCluster=Object.assign({},cluster);newCluster.imageUrl=imageUrl;this.clusters_[clusterIndex]=newCluster;this.requestUpdate()}onQueryChanged_(){this.onBrowserIdle_().then((()=>{if(this.hasResult_&&this.canLoadMore_){this.canLoadMore_=false}this.pageHandler_.startQueryClusters(this.query.trim(),this.timeRangeStart?jsDateToMojoDate(this.timeRangeStart):null,new URLSearchParams(window.location.search).has("recluster"))}))}onVisitsRemoved_(removedVisits){if(removedVisits.length===1){this.$.confirmationToast.show()}}onHistoryDeleted_(){this.onQueryChanged_()}onQueryChangedByUser_(query){this.fire("query-changed-by-user",query)}onScrollOrResize_(){if(this.scrollTimeout_){clearTimeout(this.scrollTimeout_)}this.scrollTimeout_=setTimeout((()=>this.onScrollTimeout_()),this.scrollDebounce_)}onScrollTimeout_(){this.scrollTimeout_=null;const lowerScroll=this.scrollTarget.scrollHeight-this.scrollTarget.scrollTop-this.scrollTarget.offsetHeight;if(lowerScroll<500){this.onScrolledToBottom_()}}removeVisits_(){this.pageHandler_.removeVisits(this.visitsToBeRemoved_).then((()=>{this.visitsToBeRemoved_=[]}))}}customElements.define(HistoryClustersElement.is,HistoryClustersElement);