// ui/webui/resources/cr_components/history_clusters/history_clusters.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_WEBUI_RESOURCES_CR_COMPONENTS_HISTORY_CLUSTERS_HISTORY_CLUSTERS_MOJOM_TEST_UTILS_H_
#define UI_WEBUI_RESOURCES_CR_COMPONENTS_HISTORY_CLUSTERS_HISTORY_CLUSTERS_MOJOM_TEST_UTILS_H_

#include "ui/webui/resources/cr_components/history_clusters/history_clusters.mojom.h"


namespace history_clusters::mojom {


class  PageHandlerInterceptorForTesting : public PageHandler {
  virtual PageHandler* GetForwardingInterface() = 0;
  void OpenHistoryUrl(const ::GURL& url, ::ui::mojom::ClickModifiersPtr click_modifiers) override;
  void SetPage(::mojo::PendingRemote<Page> page) override;
  void ShowContextMenuForSearchbox(const std::string& query, const ::gfx::Point& point) override;
  void ShowContextMenuForURL(const ::GURL& url, const ::gfx::Point& point) override;
  void ShowSidePanelUI() override;
  void ToggleVisibility(bool visible, ToggleVisibilityCallback callback) override;
  void StartQueryClusters(const std::string& query, std::optional<::base::Time> begin_time, bool recluster) override;
  void LoadMoreClusters(const std::string& query) override;
  void HideVisits(std::vector<::history_clusters::mojom::URLVisitPtr> visits, HideVisitsCallback callback) override;
  void RemoveVisits(std::vector<::history_clusters::mojom::URLVisitPtr> visits, RemoveVisitsCallback callback) override;
  void RemoveVisitByUrlAndTime(const ::GURL& url, double timestamp, RemoveVisitByUrlAndTimeCallback callback) override;
  void OpenVisitUrlsInTabGroup(std::vector<::history_clusters::mojom::URLVisitPtr> visits, const std::optional<std::string>& tab_group_name) override;
  void RecordVisitAction(VisitAction visit_action, uint32_t visit_index, VisitType visit_type) override;
  void RecordRelatedSearchAction(RelatedSearchAction action, uint32_t visit_index) override;
  void RecordClusterAction(ClusterAction cluster_action, uint32_t cluster_index) override;
  void RecordToggledVisibility(bool visible) override;
};
class  PageHandlerAsyncWaiter {
 public:
  explicit PageHandlerAsyncWaiter(PageHandler* proxy);

  PageHandlerAsyncWaiter(const PageHandlerAsyncWaiter&) = delete;
  PageHandlerAsyncWaiter& operator=(const PageHandlerAsyncWaiter&) = delete;

  ~PageHandlerAsyncWaiter();
  void ToggleVisibility(
      bool visible, bool* out_visible);
  bool ToggleVisibility(bool visible);
  void HideVisits(
      std::vector<::history_clusters::mojom::URLVisitPtr> visits, bool* out_success);
  bool HideVisits(std::vector<::history_clusters::mojom::URLVisitPtr> visits);
  void RemoveVisits(
      std::vector<::history_clusters::mojom::URLVisitPtr> visits, bool* out_success);
  bool RemoveVisits(std::vector<::history_clusters::mojom::URLVisitPtr> visits);
  void RemoveVisitByUrlAndTime(
      const ::GURL& url, double timestamp, bool* out_success);
  bool RemoveVisitByUrlAndTime(const ::GURL& url, double timestamp);

 private:
  PageHandler* const proxy_;
};


class  PageInterceptorForTesting : public Page {
  virtual Page* GetForwardingInterface() = 0;
  void OnClustersQueryResult(QueryResultPtr result) override;
  void OnClusterImageUpdated(int32_t cluster_index, const ::GURL& image_url) override;
  void OnVisitsHidden(std::vector<::history_clusters::mojom::URLVisitPtr> hidden_visits) override;
  void OnVisitsRemoved(std::vector<::history_clusters::mojom::URLVisitPtr> removed_visits) override;
  void OnHistoryDeleted() override;
  void OnQueryChangedByUser(const std::string& query) override;
};
class  PageAsyncWaiter {
 public:
  explicit PageAsyncWaiter(Page* proxy);

  PageAsyncWaiter(const PageAsyncWaiter&) = delete;
  PageAsyncWaiter& operator=(const PageAsyncWaiter&) = delete;

  ~PageAsyncWaiter();

 private:
  Page* const proxy_;
};




}  // history_clusters::mojom

#endif  // UI_WEBUI_RESOURCES_CR_COMPONENTS_HISTORY_CLUSTERS_HISTORY_CLUSTERS_MOJOM_TEST_UTILS_H_