// ui/webui/resources/cr_components/history_clusters/history_clusters.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/webui/resources/cr_components/history_clusters/history_clusters.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/webui/resources/cr_components/history_clusters/history_clusters.mojom-params-data.h"
namespace history_clusters {
namespace mojom {

NOINLINE static const char* ClusterActionToStringHelper(ClusterAction value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ClusterAction::kDeleted:
      return "kDeleted";
    case ClusterAction::kOpenedInTabGroup:
      return "kOpenedInTabGroup";
    case ClusterAction::kRelatedSearchClicked:
      return "kRelatedSearchClicked";
    case ClusterAction::kVisitClicked:
      return "kVisitClicked";
    default:
      return nullptr;
  }
}

std::string ClusterActionToString(ClusterAction value) {
  const char *str = ClusterActionToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ClusterAction value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ClusterAction value) {
  return os << ClusterActionToString(value);
}

NOINLINE static const char* RelatedSearchActionToStringHelper(RelatedSearchAction value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case RelatedSearchAction::kClicked:
      return "kClicked";
    default:
      return nullptr;
  }
}

std::string RelatedSearchActionToString(RelatedSearchAction value) {
  const char *str = RelatedSearchActionToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown RelatedSearchAction value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, RelatedSearchAction value) {
  return os << RelatedSearchActionToString(value);
}

NOINLINE static const char* VisitActionToStringHelper(VisitAction value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case VisitAction::kClicked:
      return "kClicked";
    case VisitAction::kHidden:
      return "kHidden";
    case VisitAction::kDeleted:
      return "kDeleted";
    default:
      return nullptr;
  }
}

std::string VisitActionToString(VisitAction value) {
  const char *str = VisitActionToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown VisitAction value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, VisitAction value) {
  return os << VisitActionToString(value);
}

NOINLINE static const char* VisitTypeToStringHelper(VisitType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case VisitType::kSRP:
      return "kSRP";
    case VisitType::kNonSRP:
      return "kNonSRP";
    default:
      return nullptr;
  }
}

std::string VisitTypeToString(VisitType value) {
  const char *str = VisitTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown VisitType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, VisitType value) {
  return os << VisitTypeToString(value);
}

namespace internal {


// static
bool QueryResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const QueryResult_Data* object =
      static_cast<const QueryResult_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->query, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& query_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->query, validation_context,
                                         &query_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->clusters, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& clusters_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->clusters, validation_context,
                                         &clusters_validate_params)) {
    return false;
  }

  return true;
}

QueryResult_Data::QueryResult_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_OpenHistoryUrl_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_OpenHistoryUrl_Params_Data* object =
      static_cast<const PageHandler_OpenHistoryUrl_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->click_modifiers, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->click_modifiers, validation_context))
    return false;

  return true;
}

PageHandler_OpenHistoryUrl_Params_Data::PageHandler_OpenHistoryUrl_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_SetPage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_SetPage_Params_Data* object =
      static_cast<const PageHandler_SetPage_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->page, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->page,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PageHandler_SetPage_Params_Data::PageHandler_SetPage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_ShowContextMenuForSearchbox_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_ShowContextMenuForSearchbox_Params_Data* object =
      static_cast<const PageHandler_ShowContextMenuForSearchbox_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->query, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& query_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->query, validation_context,
                                         &query_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->point, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->point, validation_context))
    return false;

  return true;
}

PageHandler_ShowContextMenuForSearchbox_Params_Data::PageHandler_ShowContextMenuForSearchbox_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_ShowContextMenuForURL_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_ShowContextMenuForURL_Params_Data* object =
      static_cast<const PageHandler_ShowContextMenuForURL_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->point, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->point, validation_context))
    return false;

  return true;
}

PageHandler_ShowContextMenuForURL_Params_Data::PageHandler_ShowContextMenuForURL_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_ShowSidePanelUI_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_ShowSidePanelUI_Params_Data* object =
      static_cast<const PageHandler_ShowSidePanelUI_Params_Data*>(data);

  return true;
}

PageHandler_ShowSidePanelUI_Params_Data::PageHandler_ShowSidePanelUI_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_ToggleVisibility_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_ToggleVisibility_Params_Data* object =
      static_cast<const PageHandler_ToggleVisibility_Params_Data*>(data);

  return true;
}

PageHandler_ToggleVisibility_Params_Data::PageHandler_ToggleVisibility_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_ToggleVisibility_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_ToggleVisibility_ResponseParams_Data* object =
      static_cast<const PageHandler_ToggleVisibility_ResponseParams_Data*>(data);

  return true;
}

PageHandler_ToggleVisibility_ResponseParams_Data::PageHandler_ToggleVisibility_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_StartQueryClusters_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_StartQueryClusters_Params_Data* object =
      static_cast<const PageHandler_StartQueryClusters_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->query, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& query_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->query, validation_context,
                                         &query_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->begin_time, validation_context))
    return false;

  return true;
}

PageHandler_StartQueryClusters_Params_Data::PageHandler_StartQueryClusters_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_LoadMoreClusters_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_LoadMoreClusters_Params_Data* object =
      static_cast<const PageHandler_LoadMoreClusters_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->query, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& query_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->query, validation_context,
                                         &query_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_LoadMoreClusters_Params_Data::PageHandler_LoadMoreClusters_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_HideVisits_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_HideVisits_Params_Data* object =
      static_cast<const PageHandler_HideVisits_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->visits, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& visits_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->visits, validation_context,
                                         &visits_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_HideVisits_Params_Data::PageHandler_HideVisits_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_HideVisits_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_HideVisits_ResponseParams_Data* object =
      static_cast<const PageHandler_HideVisits_ResponseParams_Data*>(data);

  return true;
}

PageHandler_HideVisits_ResponseParams_Data::PageHandler_HideVisits_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_RemoveVisits_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_RemoveVisits_Params_Data* object =
      static_cast<const PageHandler_RemoveVisits_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->visits, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& visits_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->visits, validation_context,
                                         &visits_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_RemoveVisits_Params_Data::PageHandler_RemoveVisits_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_RemoveVisits_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_RemoveVisits_ResponseParams_Data* object =
      static_cast<const PageHandler_RemoveVisits_ResponseParams_Data*>(data);

  return true;
}

PageHandler_RemoveVisits_ResponseParams_Data::PageHandler_RemoveVisits_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_RemoveVisitByUrlAndTime_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_RemoveVisitByUrlAndTime_Params_Data* object =
      static_cast<const PageHandler_RemoveVisitByUrlAndTime_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

PageHandler_RemoveVisitByUrlAndTime_Params_Data::PageHandler_RemoveVisitByUrlAndTime_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_RemoveVisitByUrlAndTime_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_RemoveVisitByUrlAndTime_ResponseParams_Data* object =
      static_cast<const PageHandler_RemoveVisitByUrlAndTime_ResponseParams_Data*>(data);

  return true;
}

PageHandler_RemoveVisitByUrlAndTime_ResponseParams_Data::PageHandler_RemoveVisitByUrlAndTime_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_OpenVisitUrlsInTabGroup_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_OpenVisitUrlsInTabGroup_Params_Data* object =
      static_cast<const PageHandler_OpenVisitUrlsInTabGroup_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->visits, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& visits_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->visits, validation_context,
                                         &visits_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& tab_group_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->tab_group_name, validation_context,
                                         &tab_group_name_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_OpenVisitUrlsInTabGroup_Params_Data::PageHandler_OpenVisitUrlsInTabGroup_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_RecordVisitAction_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_RecordVisitAction_Params_Data* object =
      static_cast<const PageHandler_RecordVisitAction_Params_Data*>(data);


  if (!::history_clusters::mojom::internal::VisitAction_Data
        ::Validate(object->visit_action, validation_context))
    return false;


  if (!::history_clusters::mojom::internal::VisitType_Data
        ::Validate(object->visit_type, validation_context))
    return false;

  return true;
}

PageHandler_RecordVisitAction_Params_Data::PageHandler_RecordVisitAction_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_RecordRelatedSearchAction_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_RecordRelatedSearchAction_Params_Data* object =
      static_cast<const PageHandler_RecordRelatedSearchAction_Params_Data*>(data);


  if (!::history_clusters::mojom::internal::RelatedSearchAction_Data
        ::Validate(object->action, validation_context))
    return false;

  return true;
}

PageHandler_RecordRelatedSearchAction_Params_Data::PageHandler_RecordRelatedSearchAction_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_RecordClusterAction_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_RecordClusterAction_Params_Data* object =
      static_cast<const PageHandler_RecordClusterAction_Params_Data*>(data);


  if (!::history_clusters::mojom::internal::ClusterAction_Data
        ::Validate(object->cluster_action, validation_context))
    return false;

  return true;
}

PageHandler_RecordClusterAction_Params_Data::PageHandler_RecordClusterAction_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_RecordToggledVisibility_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_RecordToggledVisibility_Params_Data* object =
      static_cast<const PageHandler_RecordToggledVisibility_Params_Data*>(data);

  return true;
}

PageHandler_RecordToggledVisibility_Params_Data::PageHandler_RecordToggledVisibility_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_OnClustersQueryResult_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_OnClustersQueryResult_Params_Data* object =
      static_cast<const Page_OnClustersQueryResult_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

Page_OnClustersQueryResult_Params_Data::Page_OnClustersQueryResult_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_OnClusterImageUpdated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_OnClusterImageUpdated_Params_Data* object =
      static_cast<const Page_OnClusterImageUpdated_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->image_url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->image_url, validation_context))
    return false;

  return true;
}

Page_OnClusterImageUpdated_Params_Data::Page_OnClusterImageUpdated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_OnVisitsHidden_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_OnVisitsHidden_Params_Data* object =
      static_cast<const Page_OnVisitsHidden_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->hidden_visits, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& hidden_visits_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->hidden_visits, validation_context,
                                         &hidden_visits_validate_params)) {
    return false;
  }

  return true;
}

Page_OnVisitsHidden_Params_Data::Page_OnVisitsHidden_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_OnVisitsRemoved_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_OnVisitsRemoved_Params_Data* object =
      static_cast<const Page_OnVisitsRemoved_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->removed_visits, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& removed_visits_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->removed_visits, validation_context,
                                         &removed_visits_validate_params)) {
    return false;
  }

  return true;
}

Page_OnVisitsRemoved_Params_Data::Page_OnVisitsRemoved_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_OnHistoryDeleted_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_OnHistoryDeleted_Params_Data* object =
      static_cast<const Page_OnHistoryDeleted_Params_Data*>(data);

  return true;
}

Page_OnHistoryDeleted_Params_Data::Page_OnHistoryDeleted_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_OnQueryChangedByUser_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_OnQueryChangedByUser_Params_Data* object =
      static_cast<const Page_OnQueryChangedByUser_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->query, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& query_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->query, validation_context,
                                         &query_validate_params)) {
    return false;
  }

  return true;
}

Page_OnQueryChangedByUser_Params_Data::Page_OnQueryChangedByUser_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace history_clusters

namespace perfetto {

// static
void TraceFormatTraits<::history_clusters::mojom::ClusterAction>::WriteIntoTrace(
   perfetto::TracedValue context, ::history_clusters::mojom::ClusterAction value) {
  return std::move(context).WriteString(::history_clusters::mojom::ClusterActionToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::history_clusters::mojom::RelatedSearchAction>::WriteIntoTrace(
   perfetto::TracedValue context, ::history_clusters::mojom::RelatedSearchAction value) {
  return std::move(context).WriteString(::history_clusters::mojom::RelatedSearchActionToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::history_clusters::mojom::VisitAction>::WriteIntoTrace(
   perfetto::TracedValue context, ::history_clusters::mojom::VisitAction value) {
  return std::move(context).WriteString(::history_clusters::mojom::VisitActionToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::history_clusters::mojom::VisitType>::WriteIntoTrace(
   perfetto::TracedValue context, ::history_clusters::mojom::VisitType value) {
  return std::move(context).WriteString(::history_clusters::mojom::VisitTypeToString(value));
}

} // namespace perfetto