// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{mojo}from"//resources/mojo/mojo/public/js/bindings.js";import{UrlSpec as url_mojom_UrlSpec}from"//resources/mojo/url/mojom/url.mojom-webui.js";export const FilteringBehaviorSpec={$:mojo.internal.Enum()};export var FilteringBehavior;(function(FilteringBehavior){FilteringBehavior[FilteringBehavior["MIN_VALUE"]=-1]="MIN_VALUE";FilteringBehavior[FilteringBehavior["MAX_VALUE"]=3]="MAX_VALUE";FilteringBehavior[FilteringBehavior["kUnknown"]=-1]="kUnknown";FilteringBehavior[FilteringBehavior["kAllow"]=0]="kAllow";FilteringBehavior[FilteringBehavior["kBlock"]=2]="kBlock";FilteringBehavior[FilteringBehavior["kInvalid"]=3]="kInvalid"})(FilteringBehavior||(FilteringBehavior={}));export class PageHandlerPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"history.mojom.PageHandler",scope)}}export class PageHandlerRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}setPage(page){this.proxy.sendMessage(0,PageHandler_SetPage_ParamsSpec.$,null,[page],false)}queryHistory(query,maxResults,beginTime){return this.proxy.sendMessage(1,PageHandler_QueryHistory_ParamsSpec.$,PageHandler_QueryHistory_ResponseParamsSpec.$,[query,maxResults,beginTime],false)}queryHistoryContinuation(){return this.proxy.sendMessage(2,PageHandler_QueryHistoryContinuation_ParamsSpec.$,PageHandler_QueryHistoryContinuation_ResponseParamsSpec.$,[],false)}removeVisits(items){return this.proxy.sendMessage(3,PageHandler_RemoveVisits_ParamsSpec.$,PageHandler_RemoveVisits_ResponseParamsSpec.$,[items],false)}openClearBrowsingDataDialog(){this.proxy.sendMessage(4,PageHandler_OpenClearBrowsingDataDialog_ParamsSpec.$,null,[],false)}removeBookmark(url){this.proxy.sendMessage(5,PageHandler_RemoveBookmark_ParamsSpec.$,null,[url],false)}setLastSelectedTab(lastTab){this.proxy.sendMessage(6,PageHandler_SetLastSelectedTab_ParamsSpec.$,null,[lastTab],false)}showSidePanelUI(){this.proxy.sendMessage(7,PageHandler_ShowSidePanelUI_ParamsSpec.$,null,[],false)}requestAccountInfo(){return this.proxy.sendMessage(8,PageHandler_RequestAccountInfo_ParamsSpec.$,PageHandler_RequestAccountInfo_ResponseParamsSpec.$,[],false)}turnOnHistorySync(){this.proxy.sendMessage(9,PageHandler_TurnOnHistorySync_ParamsSpec.$,null,[],false)}shouldShowHistoryPageHistorySyncPromo(){return this.proxy.sendMessage(10,PageHandler_ShouldShowHistoryPageHistorySyncPromo_ParamsSpec.$,PageHandler_ShouldShowHistoryPageHistorySyncPromo_ResponseParamsSpec.$,[],false)}recordHistoryPageHistorySyncPromoDismissed(){this.proxy.sendMessage(11,PageHandler_RecordHistoryPageHistorySyncPromoDismissed_ParamsSpec.$,null,[],false)}incrementHistoryPageHistorySyncPromoShownCount(){this.proxy.sendMessage(12,PageHandler_IncrementHistoryPageHistorySyncPromoShownCount_ParamsSpec.$,null,[],false)}}export class PageHandlerReceiver{helper_internal_;$;onConnectionError;constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,PageHandler_SetPage_ParamsSpec.$,null,impl.setPage.bind(impl),false);this.helper_internal_.registerHandler(1,PageHandler_QueryHistory_ParamsSpec.$,PageHandler_QueryHistory_ResponseParamsSpec.$,impl.queryHistory.bind(impl),false);this.helper_internal_.registerHandler(2,PageHandler_QueryHistoryContinuation_ParamsSpec.$,PageHandler_QueryHistoryContinuation_ResponseParamsSpec.$,impl.queryHistoryContinuation.bind(impl),false);this.helper_internal_.registerHandler(3,PageHandler_RemoveVisits_ParamsSpec.$,PageHandler_RemoveVisits_ResponseParamsSpec.$,impl.removeVisits.bind(impl),false);this.helper_internal_.registerHandler(4,PageHandler_OpenClearBrowsingDataDialog_ParamsSpec.$,null,impl.openClearBrowsingDataDialog.bind(impl),false);this.helper_internal_.registerHandler(5,PageHandler_RemoveBookmark_ParamsSpec.$,null,impl.removeBookmark.bind(impl),false);this.helper_internal_.registerHandler(6,PageHandler_SetLastSelectedTab_ParamsSpec.$,null,impl.setLastSelectedTab.bind(impl),false);this.helper_internal_.registerHandler(7,PageHandler_ShowSidePanelUI_ParamsSpec.$,null,impl.showSidePanelUI.bind(impl),false);this.helper_internal_.registerHandler(8,PageHandler_RequestAccountInfo_ParamsSpec.$,PageHandler_RequestAccountInfo_ResponseParamsSpec.$,impl.requestAccountInfo.bind(impl),false);this.helper_internal_.registerHandler(9,PageHandler_TurnOnHistorySync_ParamsSpec.$,null,impl.turnOnHistorySync.bind(impl),false);this.helper_internal_.registerHandler(10,PageHandler_ShouldShowHistoryPageHistorySyncPromo_ParamsSpec.$,PageHandler_ShouldShowHistoryPageHistorySyncPromo_ResponseParamsSpec.$,impl.shouldShowHistoryPageHistorySyncPromo.bind(impl),false);this.helper_internal_.registerHandler(11,PageHandler_RecordHistoryPageHistorySyncPromoDismissed_ParamsSpec.$,null,impl.recordHistoryPageHistorySyncPromoDismissed.bind(impl),false);this.helper_internal_.registerHandler(12,PageHandler_IncrementHistoryPageHistorySyncPromoShownCount_ParamsSpec.$,null,impl.incrementHistoryPageHistorySyncPromoShownCount.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class PageHandler{static get $interfaceName(){return"history.mojom.PageHandler"}static getRemote(){let remote=new PageHandlerRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class PageHandlerCallbackRouter{helper_internal_;$;router_;setPage;queryHistory;queryHistoryContinuation;removeVisits;openClearBrowsingDataDialog;removeBookmark;setLastSelectedTab;showSidePanelUI;requestAccountInfo;turnOnHistorySync;shouldShowHistoryPageHistorySyncPromo;recordHistoryPageHistorySyncPromoDismissed;incrementHistoryPageHistorySyncPromoShownCount;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.setPage=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,PageHandler_SetPage_ParamsSpec.$,null,this.setPage.createReceiverHandler(false),false);this.queryHistory=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(1,PageHandler_QueryHistory_ParamsSpec.$,PageHandler_QueryHistory_ResponseParamsSpec.$,this.queryHistory.createReceiverHandler(true),false);this.queryHistoryContinuation=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(2,PageHandler_QueryHistoryContinuation_ParamsSpec.$,PageHandler_QueryHistoryContinuation_ResponseParamsSpec.$,this.queryHistoryContinuation.createReceiverHandler(true),false);this.removeVisits=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(3,PageHandler_RemoveVisits_ParamsSpec.$,PageHandler_RemoveVisits_ResponseParamsSpec.$,this.removeVisits.createReceiverHandler(true),false);this.openClearBrowsingDataDialog=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(4,PageHandler_OpenClearBrowsingDataDialog_ParamsSpec.$,null,this.openClearBrowsingDataDialog.createReceiverHandler(false),false);this.removeBookmark=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(5,PageHandler_RemoveBookmark_ParamsSpec.$,null,this.removeBookmark.createReceiverHandler(false),false);this.setLastSelectedTab=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(6,PageHandler_SetLastSelectedTab_ParamsSpec.$,null,this.setLastSelectedTab.createReceiverHandler(false),false);this.showSidePanelUI=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(7,PageHandler_ShowSidePanelUI_ParamsSpec.$,null,this.showSidePanelUI.createReceiverHandler(false),false);this.requestAccountInfo=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(8,PageHandler_RequestAccountInfo_ParamsSpec.$,PageHandler_RequestAccountInfo_ResponseParamsSpec.$,this.requestAccountInfo.createReceiverHandler(true),false);this.turnOnHistorySync=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(9,PageHandler_TurnOnHistorySync_ParamsSpec.$,null,this.turnOnHistorySync.createReceiverHandler(false),false);this.shouldShowHistoryPageHistorySyncPromo=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(10,PageHandler_ShouldShowHistoryPageHistorySyncPromo_ParamsSpec.$,PageHandler_ShouldShowHistoryPageHistorySyncPromo_ResponseParamsSpec.$,this.shouldShowHistoryPageHistorySyncPromo.createReceiverHandler(true),false);this.recordHistoryPageHistorySyncPromoDismissed=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(11,PageHandler_RecordHistoryPageHistorySyncPromoDismissed_ParamsSpec.$,null,this.recordHistoryPageHistorySyncPromoDismissed.createReceiverHandler(false),false);this.incrementHistoryPageHistorySyncPromoShownCount=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(12,PageHandler_IncrementHistoryPageHistorySyncPromoShownCount_ParamsSpec.$,null,this.incrementHistoryPageHistorySyncPromoShownCount.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export class PagePendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"history.mojom.Page",scope)}}export class PageRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(PagePendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}onHistoryDeleted(){this.proxy.sendMessage(0,Page_OnHistoryDeleted_ParamsSpec.$,null,[],false)}onHasOtherFormsChanged(hasOtherForms){this.proxy.sendMessage(1,Page_OnHasOtherFormsChanged_ParamsSpec.$,null,[hasOtherForms],false)}sendAccountInfo(accountInfo){this.proxy.sendMessage(2,Page_SendAccountInfo_ParamsSpec.$,null,[accountInfo],false)}}export class PageReceiver{helper_internal_;$;onConnectionError;constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,Page_OnHistoryDeleted_ParamsSpec.$,null,impl.onHistoryDeleted.bind(impl),false);this.helper_internal_.registerHandler(1,Page_OnHasOtherFormsChanged_ParamsSpec.$,null,impl.onHasOtherFormsChanged.bind(impl),false);this.helper_internal_.registerHandler(2,Page_SendAccountInfo_ParamsSpec.$,null,impl.sendAccountInfo.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class Page{static get $interfaceName(){return"history.mojom.Page"}static getRemote(){let remote=new PageRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class PageCallbackRouter{helper_internal_;$;router_;onHistoryDeleted;onHasOtherFormsChanged;sendAccountInfo;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.onHistoryDeleted=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,Page_OnHistoryDeleted_ParamsSpec.$,null,this.onHistoryDeleted.createReceiverHandler(false),false);this.onHasOtherFormsChanged=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(1,Page_OnHasOtherFormsChanged_ParamsSpec.$,null,this.onHasOtherFormsChanged.createReceiverHandler(false),false);this.sendAccountInfo=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(2,Page_SendAccountInfo_ParamsSpec.$,null,this.sendAccountInfo.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export const QueryStateSpec={$:{}};export const HistoryQuerySpec={$:{}};export const DebugInfoSpec={$:{}};export const HistoryEntrySpec={$:{}};export const QueryResultSpec={$:{}};export const RemovalItemSpec={$:{}};export const AccountInfoSpec={$:{}};export const PageHandler_SetPage_ParamsSpec={$:{}};export const PageHandler_QueryHistory_ParamsSpec={$:{}};export const PageHandler_QueryHistory_ResponseParamsSpec={$:{}};export const PageHandler_QueryHistoryContinuation_ParamsSpec={$:{}};export const PageHandler_QueryHistoryContinuation_ResponseParamsSpec={$:{}};export const PageHandler_RemoveVisits_ParamsSpec={$:{}};export const PageHandler_RemoveVisits_ResponseParamsSpec={$:{}};export const PageHandler_OpenClearBrowsingDataDialog_ParamsSpec={$:{}};export const PageHandler_RemoveBookmark_ParamsSpec={$:{}};export const PageHandler_SetLastSelectedTab_ParamsSpec={$:{}};export const PageHandler_ShowSidePanelUI_ParamsSpec={$:{}};export const PageHandler_RequestAccountInfo_ParamsSpec={$:{}};export const PageHandler_RequestAccountInfo_ResponseParamsSpec={$:{}};export const PageHandler_TurnOnHistorySync_ParamsSpec={$:{}};export const PageHandler_ShouldShowHistoryPageHistorySyncPromo_ParamsSpec={$:{}};export const PageHandler_ShouldShowHistoryPageHistorySyncPromo_ResponseParamsSpec={$:{}};export const PageHandler_RecordHistoryPageHistorySyncPromoDismissed_ParamsSpec={$:{}};export const PageHandler_IncrementHistoryPageHistorySyncPromoShownCount_ParamsSpec={$:{}};export const Page_OnHistoryDeleted_ParamsSpec={$:{}};export const Page_OnHasOtherFormsChanged_ParamsSpec={$:{}};export const Page_SendAccountInfo_ParamsSpec={$:{}};mojo.internal.Struct(QueryStateSpec.$,"QueryState",[mojo.internal.StructField("incremental",0,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("querying",0,1,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("searchTerm",8,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("after",16,0,mojo.internal.String,null,true,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(HistoryQuerySpec.$,"HistoryQuery",[mojo.internal.StructField("term",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("finished",8,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(DebugInfoSpec.$,"DebugInfo",[mojo.internal.StructField("isUrlInLocalDatabase",0,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("visitCount",4,0,mojo.internal.Uint32,0,false,0,undefined,undefined),mojo.internal.StructField("typedCount",8,0,mojo.internal.Uint32,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(HistoryEntrySpec.$,"HistoryEntry",[mojo.internal.StructField("url",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("title",8,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("domain",16,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("fallbackFaviconText",24,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("time",32,0,mojo.internal.Double,0,false,0,undefined,undefined),mojo.internal.StructField("allTimestamps",40,0,mojo.internal.Array(mojo.internal.Double,false),null,false,0,undefined,undefined),mojo.internal.StructField("dateShort",48,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("deviceName",56,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("deviceType",64,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("dateTimeOfDay",72,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("dateRelativeDay",80,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("selected",88,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("readableTimestamp",96,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("snippet",104,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("starred",88,1,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("hostFilteringBehavior",92,0,FilteringBehaviorSpec.$,-1,false,0,undefined,undefined),mojo.internal.StructField("blockedVisit",88,2,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("isUrlInRemoteUserData",88,3,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("isActorVisit",88,4,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("remoteIconUrlForUma",112,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("debug",120,0,DebugInfoSpec.$,null,true,0,undefined,undefined)],[[0,136]]);mojo.internal.Struct(QueryResultSpec.$,"QueryResult",[mojo.internal.StructField("info",0,0,HistoryQuerySpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("value",8,0,mojo.internal.Array(HistoryEntrySpec.$,false),null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(RemovalItemSpec.$,"RemovalItem",[mojo.internal.StructField("url",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("timestamps",8,0,mojo.internal.Array(mojo.internal.Double,false),null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(AccountInfoSpec.$,"AccountInfo",[mojo.internal.StructField("accountImageSrc",0,0,url_mojom_UrlSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("name",8,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("email",16,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(PageHandler_SetPage_ParamsSpec.$,"PageHandler_SetPage_Params",[mojo.internal.StructField("page",0,0,mojo.internal.InterfaceProxy(PageRemote),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_QueryHistory_ParamsSpec.$,"PageHandler_QueryHistory_Params",[mojo.internal.StructField("query",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("maxResults",8,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("begin_time_$flag",12,0,mojo.internal.Bool,false,false,0,{isPrimary:true,linkedValueFieldName:"begin_time_$value",originalFieldName:"beginTime"},undefined),mojo.internal.StructField("begin_time_$value",16,0,mojo.internal.Double,0,false,0,{isPrimary:false,originalFieldName:"beginTime"},undefined)],[[0,32]]);mojo.internal.Struct(PageHandler_QueryHistory_ResponseParamsSpec.$,"PageHandler_QueryHistory_ResponseParams",[mojo.internal.StructField("results",0,0,QueryResultSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_QueryHistoryContinuation_ParamsSpec.$,"PageHandler_QueryHistoryContinuation_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_QueryHistoryContinuation_ResponseParamsSpec.$,"PageHandler_QueryHistoryContinuation_ResponseParams",[mojo.internal.StructField("results",0,0,QueryResultSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_RemoveVisits_ParamsSpec.$,"PageHandler_RemoveVisits_Params",[mojo.internal.StructField("items",0,0,mojo.internal.Array(RemovalItemSpec.$,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_RemoveVisits_ResponseParamsSpec.$,"PageHandler_RemoveVisits_ResponseParams",[mojo.internal.StructField("didDelete",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_OpenClearBrowsingDataDialog_ParamsSpec.$,"PageHandler_OpenClearBrowsingDataDialog_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_RemoveBookmark_ParamsSpec.$,"PageHandler_RemoveBookmark_Params",[mojo.internal.StructField("url",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_SetLastSelectedTab_ParamsSpec.$,"PageHandler_SetLastSelectedTab_Params",[mojo.internal.StructField("lastTab",0,0,mojo.internal.Int32,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_ShowSidePanelUI_ParamsSpec.$,"PageHandler_ShowSidePanelUI_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_RequestAccountInfo_ParamsSpec.$,"PageHandler_RequestAccountInfo_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_RequestAccountInfo_ResponseParamsSpec.$,"PageHandler_RequestAccountInfo_ResponseParams",[mojo.internal.StructField("accountInfo",0,0,AccountInfoSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_TurnOnHistorySync_ParamsSpec.$,"PageHandler_TurnOnHistorySync_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_ShouldShowHistoryPageHistorySyncPromo_ParamsSpec.$,"PageHandler_ShouldShowHistoryPageHistorySyncPromo_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_ShouldShowHistoryPageHistorySyncPromo_ResponseParamsSpec.$,"PageHandler_ShouldShowHistoryPageHistorySyncPromo_ResponseParams",[mojo.internal.StructField("shouldShow",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_RecordHistoryPageHistorySyncPromoDismissed_ParamsSpec.$,"PageHandler_RecordHistoryPageHistorySyncPromoDismissed_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_IncrementHistoryPageHistorySyncPromoShownCount_ParamsSpec.$,"PageHandler_IncrementHistoryPageHistorySyncPromoShownCount_Params",[],[[0,8]]);mojo.internal.Struct(Page_OnHistoryDeleted_ParamsSpec.$,"Page_OnHistoryDeleted_Params",[],[[0,8]]);mojo.internal.Struct(Page_OnHasOtherFormsChanged_ParamsSpec.$,"Page_OnHasOtherFormsChanged_Params",[mojo.internal.StructField("hasOtherForms",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Page_SendAccountInfo_ParamsSpec.$,"Page_SendAccountInfo_Params",[mojo.internal.StructField("accountInfo",0,0,AccountInfoSpec.$,null,false,0,undefined,undefined)],[[0,16]]);