// ui/webui/resources/cr_components/history/history.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_WEBUI_RESOURCES_CR_COMPONENTS_HISTORY_HISTORY_MOJOM_SHARED_H_
#define UI_WEBUI_RESOURCES_CR_COMPONENTS_HISTORY_HISTORY_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/webui/resources/cr_components/history/history.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "ui/webui/resources/cr_components/history/history.mojom-data-view.h"




namespace std {

template <>
struct hash<::history::mojom::FilteringBehavior>
    : public mojo::internal::EnumHashImpl<::history::mojom::FilteringBehavior> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::history::mojom::FilteringBehavior, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::history::mojom::FilteringBehavior, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::history::mojom::FilteringBehavior>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::history::mojom::QueryStateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::history::mojom::QueryStateDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::history::mojom::internal::QueryState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->incremental = Traits::incremental(input);

    fragment->querying = Traits::querying(input);

    decltype(Traits::search_term(input)) in_search_term = Traits::search_term(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->search_term)::BaseType> search_term_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_search_term,
      search_term_fragment);

    fragment->search_term.Set(
        search_term_fragment.is_null() ? nullptr : search_term_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->search_term.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null search_term in QueryState struct");

    decltype(Traits::after(input)) in_after = Traits::after(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->after)::BaseType> after_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_after,
      after_fragment);

    fragment->after.Set(
        after_fragment.is_null() ? nullptr : after_fragment.data());
  }

  static bool Deserialize(::history::mojom::internal::QueryState_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::history::mojom::QueryStateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::history::mojom::HistoryQueryDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::history::mojom::HistoryQueryDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::history::mojom::internal::HistoryQuery_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::term(input)) in_term = Traits::term(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->term)::BaseType> term_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_term,
      term_fragment);

    fragment->term.Set(
        term_fragment.is_null() ? nullptr : term_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->term.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null term in HistoryQuery struct");

    fragment->finished = Traits::finished(input);
  }

  static bool Deserialize(::history::mojom::internal::HistoryQuery_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::history::mojom::HistoryQueryDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::history::mojom::DebugInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::history::mojom::DebugInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::history::mojom::internal::DebugInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->is_url_in_local_database = Traits::is_url_in_local_database(input);

    fragment->visit_count = Traits::visit_count(input);

    fragment->typed_count = Traits::typed_count(input);
  }

  static bool Deserialize(::history::mojom::internal::DebugInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::history::mojom::DebugInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::history::mojom::HistoryEntryDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::history::mojom::HistoryEntryDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::history::mojom::internal::HistoryEntry_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in HistoryEntry struct");

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in HistoryEntry struct");

    decltype(Traits::domain(input)) in_domain = Traits::domain(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->domain)::BaseType> domain_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_domain,
      domain_fragment);

    fragment->domain.Set(
        domain_fragment.is_null() ? nullptr : domain_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->domain.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null domain in HistoryEntry struct");

    decltype(Traits::fallback_favicon_text(input)) in_fallback_favicon_text = Traits::fallback_favicon_text(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->fallback_favicon_text)::BaseType> fallback_favicon_text_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_fallback_favicon_text,
      fallback_favicon_text_fragment);

    fragment->fallback_favicon_text.Set(
        fallback_favicon_text_fragment.is_null() ? nullptr : fallback_favicon_text_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->fallback_favicon_text.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null fallback_favicon_text in HistoryEntry struct");

    fragment->time = Traits::time(input);

    decltype(Traits::all_timestamps(input)) in_all_timestamps = Traits::all_timestamps(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->all_timestamps)::BaseType>
        all_timestamps_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& all_timestamps_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<double>>(
      in_all_timestamps,
      all_timestamps_fragment,
      &all_timestamps_validate_params);

    fragment->all_timestamps.Set(
        all_timestamps_fragment.is_null() ? nullptr : all_timestamps_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->all_timestamps.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null all_timestamps in HistoryEntry struct");

    decltype(Traits::date_short(input)) in_date_short = Traits::date_short(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->date_short)::BaseType> date_short_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_date_short,
      date_short_fragment);

    fragment->date_short.Set(
        date_short_fragment.is_null() ? nullptr : date_short_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->date_short.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null date_short in HistoryEntry struct");

    decltype(Traits::device_name(input)) in_device_name = Traits::device_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->device_name)::BaseType> device_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_device_name,
      device_name_fragment);

    fragment->device_name.Set(
        device_name_fragment.is_null() ? nullptr : device_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->device_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device_name in HistoryEntry struct");

    decltype(Traits::device_type(input)) in_device_type = Traits::device_type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->device_type)::BaseType> device_type_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_device_type,
      device_type_fragment);

    fragment->device_type.Set(
        device_type_fragment.is_null() ? nullptr : device_type_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->device_type.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device_type in HistoryEntry struct");

    decltype(Traits::date_time_of_day(input)) in_date_time_of_day = Traits::date_time_of_day(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->date_time_of_day)::BaseType> date_time_of_day_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_date_time_of_day,
      date_time_of_day_fragment);

    fragment->date_time_of_day.Set(
        date_time_of_day_fragment.is_null() ? nullptr : date_time_of_day_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->date_time_of_day.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null date_time_of_day in HistoryEntry struct");

    decltype(Traits::date_relative_day(input)) in_date_relative_day = Traits::date_relative_day(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->date_relative_day)::BaseType> date_relative_day_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_date_relative_day,
      date_relative_day_fragment);

    fragment->date_relative_day.Set(
        date_relative_day_fragment.is_null() ? nullptr : date_relative_day_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->date_relative_day.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null date_relative_day in HistoryEntry struct");

    fragment->selected = Traits::selected(input);

    decltype(Traits::readableTimestamp(input)) in_readableTimestamp = Traits::readableTimestamp(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->readableTimestamp)::BaseType> readableTimestamp_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_readableTimestamp,
      readableTimestamp_fragment);

    fragment->readableTimestamp.Set(
        readableTimestamp_fragment.is_null() ? nullptr : readableTimestamp_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->readableTimestamp.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null readableTimestamp in HistoryEntry struct");

    decltype(Traits::snippet(input)) in_snippet = Traits::snippet(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->snippet)::BaseType> snippet_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_snippet,
      snippet_fragment);

    fragment->snippet.Set(
        snippet_fragment.is_null() ? nullptr : snippet_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->snippet.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null snippet in HistoryEntry struct");

    fragment->starred = Traits::starred(input);

    
    mojo::internal::Serialize<::history::mojom::FilteringBehavior>(
      Traits::host_filtering_behavior(input),
      &fragment->host_filtering_behavior);

    fragment->blocked_visit = Traits::blocked_visit(input);

    fragment->is_url_in_remote_user_data = Traits::is_url_in_remote_user_data(input);

    fragment->is_actor_visit = Traits::is_actor_visit(input);

    decltype(Traits::remote_icon_url_for_uma(input)) in_remote_icon_url_for_uma = Traits::remote_icon_url_for_uma(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->remote_icon_url_for_uma)::BaseType> remote_icon_url_for_uma_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_remote_icon_url_for_uma,
      remote_icon_url_for_uma_fragment);

    fragment->remote_icon_url_for_uma.Set(
        remote_icon_url_for_uma_fragment.is_null() ? nullptr : remote_icon_url_for_uma_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->remote_icon_url_for_uma.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null remote_icon_url_for_uma in HistoryEntry struct");

    decltype(Traits::debug(input)) in_debug = Traits::debug(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->debug)::BaseType> debug_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::history::mojom::DebugInfoDataView>(
      in_debug,
      debug_fragment);

    fragment->debug.Set(
        debug_fragment.is_null() ? nullptr : debug_fragment.data());
  }

  static bool Deserialize(::history::mojom::internal::HistoryEntry_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::history::mojom::HistoryEntryDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::history::mojom::QueryResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::history::mojom::QueryResultDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::history::mojom::internal::QueryResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::info(input)) in_info = Traits::info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->info)::BaseType> info_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::history::mojom::HistoryQueryDataView>(
      in_info,
      info_fragment);

    fragment->info.Set(
        info_fragment.is_null() ? nullptr : info_fragment.data());

    decltype(Traits::value(input)) in_value = Traits::value(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->value)::BaseType>
        value_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& value_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::history::mojom::HistoryEntryDataView>>(
      in_value,
      value_fragment,
      &value_validate_params);

    fragment->value.Set(
        value_fragment.is_null() ? nullptr : value_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->value.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null value in QueryResult struct");
  }

  static bool Deserialize(::history::mojom::internal::QueryResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::history::mojom::QueryResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::history::mojom::RemovalItemDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::history::mojom::RemovalItemDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::history::mojom::internal::RemovalItem_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in RemovalItem struct");

    decltype(Traits::timestamps(input)) in_timestamps = Traits::timestamps(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->timestamps)::BaseType>
        timestamps_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& timestamps_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<double>>(
      in_timestamps,
      timestamps_fragment,
      &timestamps_validate_params);

    fragment->timestamps.Set(
        timestamps_fragment.is_null() ? nullptr : timestamps_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->timestamps.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null timestamps in RemovalItem struct");
  }

  static bool Deserialize(::history::mojom::internal::RemovalItem_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::history::mojom::RemovalItemDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::history::mojom::AccountInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::history::mojom::AccountInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::history::mojom::internal::AccountInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::account_image_src(input)) in_account_image_src = Traits::account_image_src(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->account_image_src)::BaseType> account_image_src_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_account_image_src,
      account_image_src_fragment);

    fragment->account_image_src.Set(
        account_image_src_fragment.is_null() ? nullptr : account_image_src_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->account_image_src.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null account_image_src in AccountInfo struct");

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in AccountInfo struct");

    decltype(Traits::email(input)) in_email = Traits::email(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->email)::BaseType> email_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_email,
      email_fragment);

    fragment->email.Set(
        email_fragment.is_null() ? nullptr : email_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->email.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null email in AccountInfo struct");
  }

  static bool Deserialize(::history::mojom::internal::AccountInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::history::mojom::AccountInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace history::mojom {

inline void QueryStateDataView::GetSearchTermDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->search_term.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void QueryStateDataView::GetAfterDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->after.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void HistoryQueryDataView::GetTermDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->term.Get();
  *output = mojo::StringDataView(pointer, message_);
}




inline void HistoryEntryDataView::GetUrlDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->url.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void HistoryEntryDataView::GetTitleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->title.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void HistoryEntryDataView::GetDomainDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->domain.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void HistoryEntryDataView::GetFallbackFaviconTextDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->fallback_favicon_text.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void HistoryEntryDataView::GetAllTimestampsDataView(
    mojo::ArrayDataView<double>* output) {
  auto pointer = data_->all_timestamps.Get();
  *output = mojo::ArrayDataView<double>(pointer, message_);
}
inline void HistoryEntryDataView::GetDateShortDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->date_short.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void HistoryEntryDataView::GetDeviceNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->device_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void HistoryEntryDataView::GetDeviceTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->device_type.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void HistoryEntryDataView::GetDateTimeOfDayDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->date_time_of_day.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void HistoryEntryDataView::GetDateRelativeDayDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->date_relative_day.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void HistoryEntryDataView::GetReadableTimestampDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->readableTimestamp.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void HistoryEntryDataView::GetSnippetDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->snippet.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void HistoryEntryDataView::GetRemoteIconUrlForUmaDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->remote_icon_url_for_uma.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void HistoryEntryDataView::GetDebugDataView(
    DebugInfoDataView* output) {
  auto pointer = data_->debug.Get();
  *output = DebugInfoDataView(pointer, message_);
}


inline void QueryResultDataView::GetInfoDataView(
    HistoryQueryDataView* output) {
  auto pointer = data_->info.Get();
  *output = HistoryQueryDataView(pointer, message_);
}
inline void QueryResultDataView::GetValueDataView(
    mojo::ArrayDataView<HistoryEntryDataView>* output) {
  auto pointer = data_->value.Get();
  *output = mojo::ArrayDataView<HistoryEntryDataView>(pointer, message_);
}


inline void RemovalItemDataView::GetUrlDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->url.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void RemovalItemDataView::GetTimestampsDataView(
    mojo::ArrayDataView<double>* output) {
  auto pointer = data_->timestamps.Get();
  *output = mojo::ArrayDataView<double>(pointer, message_);
}


inline void AccountInfoDataView::GetAccountImageSrcDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->account_image_src.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void AccountInfoDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AccountInfoDataView::GetEmailDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->email.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // history::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::history::mojom::FilteringBehavior> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::history::mojom::FilteringBehavior value);
};

} // namespace perfetto

#endif  // UI_WEBUI_RESOURCES_CR_COMPONENTS_HISTORY_HISTORY_MOJOM_SHARED_H_