// ui/webui/resources/cr_components/history/history.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_WEBUI_RESOURCES_CR_COMPONENTS_HISTORY_HISTORY_MOJOM_DATA_VIEW_H_
#define UI_WEBUI_RESOURCES_CR_COMPONENTS_HISTORY_HISTORY_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "ui/webui/resources/cr_components/history/history.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"


namespace history::mojom {
class QueryStateDataView;

class HistoryQueryDataView;

class DebugInfoDataView;

class HistoryEntryDataView;

class QueryResultDataView;

class RemovalItemDataView;

class AccountInfoDataView;



}  // history::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::history::mojom::QueryStateDataView> {
  using Data = ::history::mojom::internal::QueryState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::history::mojom::HistoryQueryDataView> {
  using Data = ::history::mojom::internal::HistoryQuery_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::history::mojom::DebugInfoDataView> {
  using Data = ::history::mojom::internal::DebugInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::history::mojom::HistoryEntryDataView> {
  using Data = ::history::mojom::internal::HistoryEntry_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::history::mojom::QueryResultDataView> {
  using Data = ::history::mojom::internal::QueryResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::history::mojom::RemovalItemDataView> {
  using Data = ::history::mojom::internal::RemovalItem_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::history::mojom::AccountInfoDataView> {
  using Data = ::history::mojom::internal::AccountInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace history::mojom {


enum class FilteringBehavior : int32_t {
  
  kUnknown = -1,
  
  kAllow = 0,
  
  kBlock = 2,
  
  kInvalid = 3,
  kMinValue = -1,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, FilteringBehavior value);
inline bool IsKnownEnumValue(FilteringBehavior value) {
  return internal::FilteringBehavior_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class PageHandlerInterfaceBase {};

using PageHandlerPtrDataView =
    mojo::InterfacePtrDataView<PageHandlerInterfaceBase>;
using PageHandlerRequestDataView =
    mojo::InterfaceRequestDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageHandlerInterfaceBase>;
class PageInterfaceBase {};

using PagePtrDataView =
    mojo::InterfacePtrDataView<PageInterfaceBase>;
using PageRequestDataView =
    mojo::InterfaceRequestDataView<PageInterfaceBase>;
using PageAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageInterfaceBase>;
using PageAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageInterfaceBase>;


class QueryStateDataView {
 public:
  QueryStateDataView() = default;

  QueryStateDataView(
      internal::QueryState_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool incremental() const {
    return data_->incremental;
  }
  bool querying() const {
    return data_->querying;
  }
  inline void GetSearchTermDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSearchTerm(UserType* output) {
    
    auto* pointer = data_->search_term.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetAfterDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAfter(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `after` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAfter` instead "
    "of `ReadAfter if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->after.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::QueryState_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class HistoryQueryDataView {
 public:
  HistoryQueryDataView() = default;

  HistoryQueryDataView(
      internal::HistoryQuery_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTermDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTerm(UserType* output) {
    
    auto* pointer = data_->term.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool finished() const {
    return data_->finished;
  }
 private:
  internal::HistoryQuery_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DebugInfoDataView {
 public:
  DebugInfoDataView() = default;

  DebugInfoDataView(
      internal::DebugInfo_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool is_url_in_local_database() const {
    return data_->is_url_in_local_database;
  }
  uint32_t visit_count() const {
    return data_->visit_count;
  }
  uint32_t typed_count() const {
    return data_->typed_count;
  }
 private:
  internal::DebugInfo_Data* data_ = nullptr;
};


class HistoryEntryDataView {
 public:
  HistoryEntryDataView() = default;

  HistoryEntryDataView(
      internal::HistoryEntry_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDomainDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDomain(UserType* output) {
    
    auto* pointer = data_->domain.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetFallbackFaviconTextDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFallbackFaviconText(UserType* output) {
    
    auto* pointer = data_->fallback_favicon_text.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  double time() const {
    return data_->time;
  }
  inline void GetAllTimestampsDataView(
      mojo::ArrayDataView<double>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAllTimestamps(UserType* output) {
    
    auto* pointer = data_->all_timestamps.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<double>>(
        pointer, output, message_);
  }
  inline void GetDateShortDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDateShort(UserType* output) {
    
    auto* pointer = data_->date_short.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDeviceNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDeviceName(UserType* output) {
    
    auto* pointer = data_->device_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDeviceTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDeviceType(UserType* output) {
    
    auto* pointer = data_->device_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDateTimeOfDayDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDateTimeOfDay(UserType* output) {
    
    auto* pointer = data_->date_time_of_day.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDateRelativeDayDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDateRelativeDay(UserType* output) {
    
    auto* pointer = data_->date_relative_day.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool selected() const {
    return data_->selected;
  }
  inline void GetReadableTimestampDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReadableTimestamp(UserType* output) {
    
    auto* pointer = data_->readableTimestamp.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSnippetDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSnippet(UserType* output) {
    
    auto* pointer = data_->snippet.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool starred() const {
    return data_->starred;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadHostFilteringBehavior(UserType* output) const {
    auto data_value = data_->host_filtering_behavior;
    return mojo::internal::Deserialize<::history::mojom::FilteringBehavior>(
        data_value, output);
  }
  FilteringBehavior host_filtering_behavior() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::history::mojom::FilteringBehavior>(data_->host_filtering_behavior));
  }
  bool blocked_visit() const {
    return data_->blocked_visit;
  }
  bool is_url_in_remote_user_data() const {
    return data_->is_url_in_remote_user_data;
  }
  bool is_actor_visit() const {
    return data_->is_actor_visit;
  }
  inline void GetRemoteIconUrlForUmaDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRemoteIconUrlForUma(UserType* output) {
    
    auto* pointer = data_->remote_icon_url_for_uma.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDebugDataView(
      DebugInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDebug(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::history::mojom::DebugInfoDataView, UserType>(),
    "Attempting to read the optional `debug` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDebug` instead "
    "of `ReadDebug if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->debug.Get();
    return mojo::internal::Deserialize<::history::mojom::DebugInfoDataView>(
        pointer, output, message_);
  }
 private:
  internal::HistoryEntry_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class QueryResultDataView {
 public:
  QueryResultDataView() = default;

  QueryResultDataView(
      internal::QueryResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInfoDataView(
      HistoryQueryDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::history::mojom::HistoryQueryDataView, UserType>(),
    "Attempting to read the optional `info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInfo` instead "
    "of `ReadInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->info.Get();
    return mojo::internal::Deserialize<::history::mojom::HistoryQueryDataView>(
        pointer, output, message_);
  }
  inline void GetValueDataView(
      mojo::ArrayDataView<HistoryEntryDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) {
    
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::history::mojom::HistoryEntryDataView>>(
        pointer, output, message_);
  }
 private:
  internal::QueryResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RemovalItemDataView {
 public:
  RemovalItemDataView() = default;

  RemovalItemDataView(
      internal::RemovalItem_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTimestampsDataView(
      mojo::ArrayDataView<double>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimestamps(UserType* output) {
    
    auto* pointer = data_->timestamps.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<double>>(
        pointer, output, message_);
  }
 private:
  internal::RemovalItem_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AccountInfoDataView {
 public:
  AccountInfoDataView() = default;

  AccountInfoDataView(
      internal::AccountInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAccountImageSrcDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAccountImageSrc(UserType* output) {
    
    auto* pointer = data_->account_image_src.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetEmailDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEmail(UserType* output) {
    
    auto* pointer = data_->email.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::AccountInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // history::mojom

#endif  // UI_WEBUI_RESOURCES_CR_COMPONENTS_HISTORY_HISTORY_MOJOM_DATA_VIEW_H_