// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/cr_elements/cr_button/cr_button.js";import"//resources/cr_elements/cr_icon_button/cr_icon_button.js";import"//resources/cr_elements/cr_icon/cr_icon.js";import"//resources/cr_elements/icons.html.js";import"./help_bubble_icons.html.js";import{assert,assertNotReached}from"//resources/js/assert.js";import{isWindows}from"//resources/js/platform.js";import{debounceEnd}from"//resources/js/util.js";import{CrLitElement}from"//resources/lit/v3_0/lit.rollup.js";import{getCss}from"./help_bubble.css.js";import{getHtml}from"./help_bubble.html.js";import{HelpBubbleArrowPosition}from"./help_bubble.mojom-webui.js";const ACTION_BUTTON_ID_PREFIX="action-button-";export const HELP_BUBBLE_DISMISSED_EVENT="help-bubble-dismissed";export const HELP_BUBBLE_TIMED_OUT_EVENT="help-bubble-timed-out";export const HELP_BUBBLE_SCROLL_ANCHOR_OPTIONS={behavior:"smooth",block:"center"};export class HelpBubbleElement extends CrLitElement{static get is(){return"help-bubble"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{nativeId:{type:String,reflect:true},position:{type:Number,reflect:true},bodyIconName:{type:String},bodyIconAltText:{type:String},progress:{type:Object},titleText:{type:String},bodyText:{type:String},buttons:{type:Array},sortedButtons:{type:Array},closeButtonAltText:{type:String},closeButtonTabIndex:{type:Number},progressData_:{type:Array,state:true}}}#nativeId_accessor_storage="";get nativeId(){return this.#nativeId_accessor_storage}set nativeId(value){this.#nativeId_accessor_storage=value}#bodyText_accessor_storage="";get bodyText(){return this.#bodyText_accessor_storage}set bodyText(value){this.#bodyText_accessor_storage=value}#titleText_accessor_storage="";get titleText(){return this.#titleText_accessor_storage}set titleText(value){this.#titleText_accessor_storage=value}#closeButtonAltText_accessor_storage="";get closeButtonAltText(){return this.#closeButtonAltText_accessor_storage}set closeButtonAltText(value){this.#closeButtonAltText_accessor_storage=value}#closeButtonTabIndex_accessor_storage=0;get closeButtonTabIndex(){return this.#closeButtonTabIndex_accessor_storage}set closeButtonTabIndex(value){this.#closeButtonTabIndex_accessor_storage=value}#position_accessor_storage=HelpBubbleArrowPosition.TOP_CENTER;get position(){return this.#position_accessor_storage}set position(value){this.#position_accessor_storage=value}#buttons_accessor_storage=[];get buttons(){return this.#buttons_accessor_storage}set buttons(value){this.#buttons_accessor_storage=value}#sortedButtons_accessor_storage=[];get sortedButtons(){return this.#sortedButtons_accessor_storage}set sortedButtons(value){this.#sortedButtons_accessor_storage=value}#progress_accessor_storage=null;get progress(){return this.#progress_accessor_storage}set progress(value){this.#progress_accessor_storage=value}#bodyIconName_accessor_storage=null;get bodyIconName(){return this.#bodyIconName_accessor_storage}set bodyIconName(value){this.#bodyIconName_accessor_storage=value}#bodyIconAltText_accessor_storage="";get bodyIconAltText(){return this.#bodyIconAltText_accessor_storage}set bodyIconAltText(value){this.#bodyIconAltText_accessor_storage=value}timeoutMs=null;timeoutTimerId=null;debouncedUpdate=null;padding={top:0,bottom:0,left:0,right:0};fixed=false;focusAnchor=false;buttonListObserver_=null;anchorElement_=null;#progressData__accessor_storage=[];get progressData_(){return this.#progressData__accessor_storage}set progressData_(value){this.#progressData__accessor_storage=value}resizeObserver_=null;willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("buttons")){this.sortedButtons=this.buttons.toSorted(this.buttonSortFunc_)}}show(anchorElement){this.anchorElement_=anchorElement;if(this.progress){this.progressData_=new Array(this.progress.total);this.progressData_.fill(true)}else{this.progressData_=[]}this.closeButtonTabIndex=this.buttons.length?this.buttons.length+2:1;assert(this.anchorElement_,"Tried to show a help bubble but anchorElement does not exist");this.style.display="block";this.style.position=this.fixed?"fixed":"absolute";this.removeAttribute("aria-hidden");this.updatePosition_();this.debouncedUpdate=debounceEnd((()=>{if(this.anchorElement_){this.updatePosition_()}}),50);this.buttonListObserver_=new MutationObserver(this.debouncedUpdate);this.buttonListObserver_.observe(this.$.buttons,{childList:true});window.addEventListener("resize",this.debouncedUpdate);if(this.timeoutMs!==null){const timedOutCallback=()=>{this.fire(HELP_BUBBLE_TIMED_OUT_EVENT,{nativeId:this.nativeId})};this.timeoutTimerId=setTimeout(timedOutCallback,this.timeoutMs)}if(this.offsetParent&&!this.fixed){this.resizeObserver_=new ResizeObserver((()=>{this.updatePosition_();this.anchorElement_?.scrollIntoView(HELP_BUBBLE_SCROLL_ANCHOR_OPTIONS)}));this.resizeObserver_.observe(this.offsetParent)}}hide(){if(this.resizeObserver_){this.resizeObserver_.disconnect();this.resizeObserver_=null}this.style.display="none";this.setAttribute("aria-hidden","true");this.anchorElement_=null;if(this.timeoutTimerId!==null){clearInterval(this.timeoutTimerId);this.timeoutTimerId=null}if(this.buttonListObserver_){this.buttonListObserver_.disconnect();this.buttonListObserver_=null}if(this.debouncedUpdate){window.removeEventListener("resize",this.debouncedUpdate);this.debouncedUpdate=null}}getAnchorElement(){return this.anchorElement_}getButtonForTesting(buttonIndex){return this.$.buttons.querySelector(`[id="${ACTION_BUTTON_ID_PREFIX+buttonIndex}"]`)}focus(){const defaultButton=this.$.buttons.querySelector("cr-button.default-button")||this.$.buttons.querySelector("cr-button");if(defaultButton){defaultButton.focus();return}this.$.close.focus();if(this.anchorElement_&&this.focusAnchor){this.anchorElement_.focus()}}static isDefaultButtonLeading(){return isWindows}dismiss_(){assert(this.nativeId,"Dismiss: expected help bubble to have a native id.");this.fire(HELP_BUBBLE_DISMISSED_EVENT,{nativeId:this.nativeId,fromActionButton:false})}onKeyDown_(e){if(e.key==="Escape"){e.stopPropagation();this.dismiss_()}}blockPropagation_(e){e.stopPropagation()}getProgressClass_(index){return index<this.progress.current?"current-progress":"total-progress"}shouldShowTitleInTopContainer_(){return!!this.titleText&&!this.progress}shouldShowBodyInTopContainer_(){return!this.progress&&!this.titleText}shouldShowBodyInMain_(){return!!this.progress||!!this.titleText}shouldShowBodyIcon_(){return this.bodyIconName!==null&&this.bodyIconName!==""}onButtonClick_(e){assert(this.nativeId,"Action button clicked: expected help bubble to have a native ID.");const index=parseInt(e.target.id.substring(ACTION_BUTTON_ID_PREFIX.length));this.fire(HELP_BUBBLE_DISMISSED_EVENT,{nativeId:this.nativeId,fromActionButton:true,buttonIndex:index})}getButtonId_(item){const index=this.buttons.indexOf(item);assert(index>-1);return ACTION_BUTTON_ID_PREFIX+index}getButtonClass_(isDefault){return isDefault?"default-button focus-outline-visible":"focus-outline-visible"}getButtonTabIndex_(item){const index=this.buttons.indexOf(item);assert(index>-1);return item.isDefault?1:index+2}buttonSortFunc_(button1,button2){if(button1.isDefault){return isWindows?-1:1}if(button2.isDefault){return isWindows?1:-1}return 0}getArrowClass_(){let classList="";switch(this.position){case HelpBubbleArrowPosition.TOP_LEFT:case HelpBubbleArrowPosition.TOP_CENTER:case HelpBubbleArrowPosition.TOP_RIGHT:classList="top-edge ";break;case HelpBubbleArrowPosition.BOTTOM_LEFT:case HelpBubbleArrowPosition.BOTTOM_CENTER:case HelpBubbleArrowPosition.BOTTOM_RIGHT:classList="bottom-edge ";break;case HelpBubbleArrowPosition.LEFT_TOP:case HelpBubbleArrowPosition.LEFT_CENTER:case HelpBubbleArrowPosition.LEFT_BOTTOM:classList="left-edge ";break;case HelpBubbleArrowPosition.RIGHT_TOP:case HelpBubbleArrowPosition.RIGHT_CENTER:case HelpBubbleArrowPosition.RIGHT_BOTTOM:classList="right-edge ";break;default:assertNotReached("Unknown help bubble position: "+this.position)}switch(this.position){case HelpBubbleArrowPosition.TOP_LEFT:case HelpBubbleArrowPosition.BOTTOM_LEFT:classList+="left-position";break;case HelpBubbleArrowPosition.TOP_CENTER:case HelpBubbleArrowPosition.BOTTOM_CENTER:classList+="horizontal-center-position";break;case HelpBubbleArrowPosition.TOP_RIGHT:case HelpBubbleArrowPosition.BOTTOM_RIGHT:classList+="right-position";break;case HelpBubbleArrowPosition.LEFT_TOP:case HelpBubbleArrowPosition.RIGHT_TOP:classList+="top-position";break;case HelpBubbleArrowPosition.LEFT_CENTER:case HelpBubbleArrowPosition.RIGHT_CENTER:classList+="vertical-center-position";break;case HelpBubbleArrowPosition.LEFT_BOTTOM:case HelpBubbleArrowPosition.RIGHT_BOTTOM:classList+="bottom-position";break;default:assertNotReached("Unknown help bubble position: "+this.position)}return classList}updatePosition_(){assert(this.anchorElement_,"Update position: expected valid anchor element.");const ANCHOR_OFFSET=16;const ARROW_WIDTH=16;const ARROW_OFFSET_FROM_EDGE=22+ARROW_WIDTH/2;const anchorRect=this.anchorElement_.getBoundingClientRect();const anchorRectCenter={x:anchorRect.left+anchorRect.width/2,y:anchorRect.top+anchorRect.height/2};const helpBubbleRect=this.getBoundingClientRect();let offsetX=this.anchorElement_.offsetLeft;let offsetY=this.anchorElement_.offsetTop;switch(this.position){case HelpBubbleArrowPosition.TOP_LEFT:case HelpBubbleArrowPosition.TOP_CENTER:case HelpBubbleArrowPosition.TOP_RIGHT:offsetY+=anchorRect.height+ANCHOR_OFFSET+this.padding.bottom;break;case HelpBubbleArrowPosition.BOTTOM_LEFT:case HelpBubbleArrowPosition.BOTTOM_CENTER:case HelpBubbleArrowPosition.BOTTOM_RIGHT:offsetY-=helpBubbleRect.height+ANCHOR_OFFSET+this.padding.top;break;case HelpBubbleArrowPosition.LEFT_TOP:case HelpBubbleArrowPosition.LEFT_CENTER:case HelpBubbleArrowPosition.LEFT_BOTTOM:offsetX+=anchorRect.width+ANCHOR_OFFSET+this.padding.right;break;case HelpBubbleArrowPosition.RIGHT_TOP:case HelpBubbleArrowPosition.RIGHT_CENTER:case HelpBubbleArrowPosition.RIGHT_BOTTOM:offsetX-=helpBubbleRect.width+ANCHOR_OFFSET+this.padding.left;break;default:assertNotReached()}switch(this.position){case HelpBubbleArrowPosition.TOP_LEFT:case HelpBubbleArrowPosition.BOTTOM_LEFT:if(anchorRect.left+ARROW_OFFSET_FROM_EDGE>anchorRectCenter.x){offsetX+=anchorRect.width/2-ARROW_OFFSET_FROM_EDGE}break;case HelpBubbleArrowPosition.TOP_CENTER:case HelpBubbleArrowPosition.BOTTOM_CENTER:offsetX+=anchorRect.width/2-helpBubbleRect.width/2;break;case HelpBubbleArrowPosition.TOP_RIGHT:case HelpBubbleArrowPosition.BOTTOM_RIGHT:if(anchorRect.right-ARROW_OFFSET_FROM_EDGE<anchorRectCenter.x){offsetX+=anchorRect.width/2-helpBubbleRect.width+ARROW_OFFSET_FROM_EDGE}else{offsetX+=anchorRect.width-helpBubbleRect.width}break;case HelpBubbleArrowPosition.LEFT_TOP:case HelpBubbleArrowPosition.RIGHT_TOP:if(anchorRect.top+ARROW_OFFSET_FROM_EDGE>anchorRectCenter.y){offsetY+=anchorRect.height/2-ARROW_OFFSET_FROM_EDGE}break;case HelpBubbleArrowPosition.LEFT_CENTER:case HelpBubbleArrowPosition.RIGHT_CENTER:offsetY+=anchorRect.height/2-helpBubbleRect.height/2;break;case HelpBubbleArrowPosition.LEFT_BOTTOM:case HelpBubbleArrowPosition.RIGHT_BOTTOM:if(anchorRect.bottom-ARROW_OFFSET_FROM_EDGE<anchorRectCenter.y){offsetY+=anchorRect.height/2-helpBubbleRect.height+ARROW_OFFSET_FROM_EDGE}else{offsetY+=anchorRect.height-helpBubbleRect.height}break;default:assertNotReached()}this.style.top=offsetY.toString()+"px";this.style.left=offsetX.toString()+"px"}}customElements.define(HelpBubbleElement.is,HelpBubbleElement);