// ui/webui/resources/cr_components/help_bubble/help_bubble.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_WEBUI_RESOURCES_CR_COMPONENTS_HELP_BUBBLE_HELP_BUBBLE_MOJOM_H_
#define UI_WEBUI_RESOURCES_CR_COMPONENTS_HELP_BUBBLE_HELP_BUBBLE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/webui/resources/cr_components/help_bubble/help_bubble.mojom-features.h"  // IWYU pragma: export
#include "ui/webui/resources/cr_components/help_bubble/help_bubble.mojom-shared.h"  // IWYU pragma: export
#include "ui/webui/resources/cr_components/help_bubble/help_bubble.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom.h"
#include "ui/webui/resources/js/tracked_element/tracked_element.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace help_bubble::mojom {

class HelpBubbleHandlerFactoryProxy;

template <typename ImplRefTraits>
class HelpBubbleHandlerFactoryStub;

class HelpBubbleHandlerFactoryRequestValidator;


class HelpBubbleHandlerFactory
    : public HelpBubbleHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "help_bubble.mojom.HelpBubbleHandlerFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = HelpBubbleHandlerFactoryInterfaceBase;
  using Proxy_ = HelpBubbleHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = HelpBubbleHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = HelpBubbleHandlerFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateHelpBubbleHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateHelpBubbleHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~HelpBubbleHandlerFactory() = default;

  virtual void CreateHelpBubbleHandler(::mojo::PendingRemote<HelpBubbleClient> client, ::mojo::PendingReceiver<HelpBubbleHandler> handler) = 0;
};

class PdfHelpBubbleHandlerFactoryProxy;

template <typename ImplRefTraits>
class PdfHelpBubbleHandlerFactoryStub;

class PdfHelpBubbleHandlerFactoryRequestValidator;


class PdfHelpBubbleHandlerFactory
    : public PdfHelpBubbleHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "help_bubble.mojom.PdfHelpBubbleHandlerFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PdfHelpBubbleHandlerFactoryInterfaceBase;
  using Proxy_ = PdfHelpBubbleHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = PdfHelpBubbleHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = PdfHelpBubbleHandlerFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateHelpBubbleHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateHelpBubbleHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PdfHelpBubbleHandlerFactory() = default;

  virtual void CreateHelpBubbleHandler(::mojo::PendingRemote<HelpBubbleClient> client, ::mojo::PendingReceiver<HelpBubbleHandler> handler) = 0;
};

class HelpBubbleHandlerProxy;

template <typename ImplRefTraits>
class HelpBubbleHandlerStub;

class HelpBubbleHandlerRequestValidator;


class HelpBubbleHandler
    : public HelpBubbleHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "help_bubble.mojom.HelpBubbleHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = HelpBubbleHandlerInterfaceBase;
  using Proxy_ = HelpBubbleHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = HelpBubbleHandlerStub<ImplRefTraits>;

  using RequestValidator_ = HelpBubbleHandlerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kBindTrackedElementHandlerMinVersion = 0,
    kHelpBubbleButtonPressedMinVersion = 0,
    kHelpBubbleClosedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct BindTrackedElementHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct HelpBubbleButtonPressed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct HelpBubbleClosed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~HelpBubbleHandler() = default;

  virtual void BindTrackedElementHandler(::mojo::PendingReceiver<::tracked_element::mojom::TrackedElementHandler> handler) = 0;

  virtual void HelpBubbleButtonPressed(const std::string& native_identifier, uint8_t button_index) = 0;

  virtual void HelpBubbleClosed(const std::string& native_identifier, HelpBubbleClosedReason reason) = 0;
};

class HelpBubbleClientProxy;

template <typename ImplRefTraits>
class HelpBubbleClientStub;

class HelpBubbleClientRequestValidator;


class HelpBubbleClient
    : public HelpBubbleClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "help_bubble.mojom.HelpBubbleClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = HelpBubbleClientInterfaceBase;
  using Proxy_ = HelpBubbleClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = HelpBubbleClientStub<ImplRefTraits>;

  using RequestValidator_ = HelpBubbleClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kShowHelpBubbleMinVersion = 0,
    kToggleFocusForAccessibilityMinVersion = 0,
    kHideHelpBubbleMinVersion = 0,
    kExternalHelpBubbleUpdatedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ShowHelpBubble_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ToggleFocusForAccessibility_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct HideHelpBubble_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ExternalHelpBubbleUpdated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~HelpBubbleClient() = default;

  virtual void ShowHelpBubble(HelpBubbleParamsPtr params) = 0;

  virtual void ToggleFocusForAccessibility(const std::string& native_identifier) = 0;

  virtual void HideHelpBubble(const std::string& native_identifier) = 0;

  virtual void ExternalHelpBubbleUpdated(const std::string& native_identifier, bool shown) = 0;
};



class  HelpBubbleHandlerFactoryProxy
    : public HelpBubbleHandlerFactory {
 public:
  using InterfaceType = HelpBubbleHandlerFactory;

  explicit HelpBubbleHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateHelpBubbleHandler(::mojo::PendingRemote<HelpBubbleClient> client, ::mojo::PendingReceiver<HelpBubbleHandler> handler) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PdfHelpBubbleHandlerFactoryProxy
    : public PdfHelpBubbleHandlerFactory {
 public:
  using InterfaceType = PdfHelpBubbleHandlerFactory;

  explicit PdfHelpBubbleHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateHelpBubbleHandler(::mojo::PendingRemote<HelpBubbleClient> client, ::mojo::PendingReceiver<HelpBubbleHandler> handler) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  HelpBubbleHandlerProxy
    : public HelpBubbleHandler {
 public:
  using InterfaceType = HelpBubbleHandler;

  explicit HelpBubbleHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void BindTrackedElementHandler(::mojo::PendingReceiver<::tracked_element::mojom::TrackedElementHandler> handler) final;
  
  void HelpBubbleButtonPressed(const std::string& native_identifier, uint8_t button_index) final;
  
  void HelpBubbleClosed(const std::string& native_identifier, HelpBubbleClosedReason reason) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  HelpBubbleClientProxy
    : public HelpBubbleClient {
 public:
  using InterfaceType = HelpBubbleClient;

  explicit HelpBubbleClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ShowHelpBubble(HelpBubbleParamsPtr params) final;
  
  void ToggleFocusForAccessibility(const std::string& native_identifier) final;
  
  void HideHelpBubble(const std::string& native_identifier) final;
  
  void ExternalHelpBubbleUpdated(const std::string& native_identifier, bool shown) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  HelpBubbleHandlerFactoryStubDispatch {
 public:
  static bool Accept(HelpBubbleHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      HelpBubbleHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<HelpBubbleHandlerFactory>>
class HelpBubbleHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  HelpBubbleHandlerFactoryStub() = default;
  ~HelpBubbleHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return HelpBubbleHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return HelpBubbleHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PdfHelpBubbleHandlerFactoryStubDispatch {
 public:
  static bool Accept(PdfHelpBubbleHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PdfHelpBubbleHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PdfHelpBubbleHandlerFactory>>
class PdfHelpBubbleHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PdfHelpBubbleHandlerFactoryStub() = default;
  ~PdfHelpBubbleHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PdfHelpBubbleHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PdfHelpBubbleHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  HelpBubbleHandlerStubDispatch {
 public:
  static bool Accept(HelpBubbleHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      HelpBubbleHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<HelpBubbleHandler>>
class HelpBubbleHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  HelpBubbleHandlerStub() = default;
  ~HelpBubbleHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return HelpBubbleHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return HelpBubbleHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  HelpBubbleClientStubDispatch {
 public:
  static bool Accept(HelpBubbleClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      HelpBubbleClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<HelpBubbleClient>>
class HelpBubbleClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  HelpBubbleClientStub() = default;
  ~HelpBubbleClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return HelpBubbleClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return HelpBubbleClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  HelpBubbleHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PdfHelpBubbleHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  HelpBubbleHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  HelpBubbleClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  HelpBubbleButtonParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HelpBubbleButtonParams, T>::value>;
  using DataView = HelpBubbleButtonParamsDataView;
  using Data_ = internal::HelpBubbleButtonParams_Data;

  template <typename... Args>
  static HelpBubbleButtonParamsPtr New(Args&&... args) {
    return HelpBubbleButtonParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HelpBubbleButtonParamsPtr From(const U& u) {
    return mojo::TypeConverter<HelpBubbleButtonParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HelpBubbleButtonParams>::Convert(*this);
  }


  HelpBubbleButtonParams();

  HelpBubbleButtonParams(
      const std::string& text,
      bool is_default);


  ~HelpBubbleButtonParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HelpBubbleButtonParamsPtr>
  HelpBubbleButtonParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HelpBubbleButtonParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, HelpBubbleButtonParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, HelpBubbleButtonParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HelpBubbleButtonParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HelpBubbleButtonParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HelpBubbleButtonParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HelpBubbleButtonParams_UnserializedMessageContext<
            UserType, HelpBubbleButtonParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<HelpBubbleButtonParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return HelpBubbleButtonParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HelpBubbleButtonParams_UnserializedMessageContext<
            UserType, HelpBubbleButtonParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HelpBubbleButtonParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string text;
  
  bool is_default;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HelpBubbleButtonParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HelpBubbleButtonParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HelpBubbleButtonParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HelpBubbleButtonParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  Progress {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Progress, T>::value>;
  using DataView = ProgressDataView;
  using Data_ = internal::Progress_Data;

  template <typename... Args>
  static ProgressPtr New(Args&&... args) {
    return ProgressPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ProgressPtr From(const U& u) {
    return mojo::TypeConverter<ProgressPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Progress>::Convert(*this);
  }


  Progress();

  Progress(
      uint8_t current,
      uint8_t total);


  ~Progress();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ProgressPtr>
  ProgressPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Progress::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Progress::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Progress::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Progress::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Progress::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Progress::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Progress_UnserializedMessageContext<
            UserType, Progress::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Progress::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Progress::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Progress_UnserializedMessageContext<
            UserType, Progress::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Progress::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint8_t current;
  
  uint8_t total;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Progress::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Progress::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Progress::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Progress::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}










class  HelpBubbleParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HelpBubbleParams, T>::value>;
  using DataView = HelpBubbleParamsDataView;
  using Data_ = internal::HelpBubbleParams_Data;

  template <typename... Args>
  static HelpBubbleParamsPtr New(Args&&... args) {
    return HelpBubbleParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HelpBubbleParamsPtr From(const U& u) {
    return mojo::TypeConverter<HelpBubbleParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HelpBubbleParams>::Convert(*this);
  }


  HelpBubbleParams();

  HelpBubbleParams(
      const std::string& native_identifier,
      HelpBubbleArrowPosition position,
      const std::optional<std::string>& title_text,
      const std::string& body_text,
      const std::string& close_button_alt_text,
      const std::optional<std::string>& body_icon_name,
      const std::string& body_icon_alt_text,
      ProgressPtr progress,
      std::vector<HelpBubbleButtonParamsPtr> buttons,
      std::optional<bool> focus_on_show_hint,
      std::optional<::base::TimeDelta> timeout);

HelpBubbleParams(const HelpBubbleParams&) = delete;
HelpBubbleParams& operator=(const HelpBubbleParams&) = delete;

  ~HelpBubbleParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HelpBubbleParamsPtr>
  HelpBubbleParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HelpBubbleParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, HelpBubbleParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, HelpBubbleParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HelpBubbleParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HelpBubbleParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HelpBubbleParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HelpBubbleParams_UnserializedMessageContext<
            UserType, HelpBubbleParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<HelpBubbleParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return HelpBubbleParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HelpBubbleParams_UnserializedMessageContext<
            UserType, HelpBubbleParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HelpBubbleParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string native_identifier;
  
  HelpBubbleArrowPosition position;
  
  std::optional<std::string> title_text;
  
  std::string body_text;
  
  std::string close_button_alt_text;
  
  std::optional<std::string> body_icon_name;
  
  std::string body_icon_alt_text;
  
  ProgressPtr progress;
  
  std::vector<HelpBubbleButtonParamsPtr> buttons;
  
  std::optional<bool> focus_on_show_hint;
  
  std::optional<::base::TimeDelta> timeout;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HelpBubbleParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HelpBubbleParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HelpBubbleParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HelpBubbleParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
HelpBubbleButtonParamsPtr HelpBubbleButtonParams::Clone() const {
  return New(
      mojo::Clone(text),
      mojo::Clone(is_default)
  );
}

template <typename T, HelpBubbleButtonParams::EnableIfSame<T>*>
bool HelpBubbleButtonParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->text, other_struct.text))
    return false;
  if (!mojo::Equals(this->is_default, other_struct.is_default))
    return false;
  return true;
}

template <typename T, HelpBubbleButtonParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.text < rhs.text)
    return true;
  if (rhs.text < lhs.text)
    return false;
  if (lhs.is_default < rhs.is_default)
    return true;
  if (rhs.is_default < lhs.is_default)
    return false;
  return false;
}
template <typename StructPtrType>
ProgressPtr Progress::Clone() const {
  return New(
      mojo::Clone(current),
      mojo::Clone(total)
  );
}

template <typename T, Progress::EnableIfSame<T>*>
bool Progress::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->current, other_struct.current))
    return false;
  if (!mojo::Equals(this->total, other_struct.total))
    return false;
  return true;
}

template <typename T, Progress::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.current < rhs.current)
    return true;
  if (rhs.current < lhs.current)
    return false;
  if (lhs.total < rhs.total)
    return true;
  if (rhs.total < lhs.total)
    return false;
  return false;
}
template <typename StructPtrType>
HelpBubbleParamsPtr HelpBubbleParams::Clone() const {
  return New(
      mojo::Clone(native_identifier),
      mojo::Clone(position),
      mojo::Clone(title_text),
      mojo::Clone(body_text),
      mojo::Clone(close_button_alt_text),
      mojo::Clone(body_icon_name),
      mojo::Clone(body_icon_alt_text),
      mojo::Clone(progress),
      mojo::Clone(buttons),
      mojo::Clone(focus_on_show_hint),
      mojo::Clone(timeout)
  );
}

template <typename T, HelpBubbleParams::EnableIfSame<T>*>
bool HelpBubbleParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->native_identifier, other_struct.native_identifier))
    return false;
  if (!mojo::Equals(this->position, other_struct.position))
    return false;
  if (!mojo::Equals(this->title_text, other_struct.title_text))
    return false;
  if (!mojo::Equals(this->body_text, other_struct.body_text))
    return false;
  if (!mojo::Equals(this->close_button_alt_text, other_struct.close_button_alt_text))
    return false;
  if (!mojo::Equals(this->body_icon_name, other_struct.body_icon_name))
    return false;
  if (!mojo::Equals(this->body_icon_alt_text, other_struct.body_icon_alt_text))
    return false;
  if (!mojo::Equals(this->progress, other_struct.progress))
    return false;
  if (!mojo::Equals(this->buttons, other_struct.buttons))
    return false;
  if (!mojo::Equals(this->focus_on_show_hint, other_struct.focus_on_show_hint))
    return false;
  if (!mojo::Equals(this->timeout, other_struct.timeout))
    return false;
  return true;
}

template <typename T, HelpBubbleParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.native_identifier < rhs.native_identifier)
    return true;
  if (rhs.native_identifier < lhs.native_identifier)
    return false;
  if (lhs.position < rhs.position)
    return true;
  if (rhs.position < lhs.position)
    return false;
  if (lhs.title_text < rhs.title_text)
    return true;
  if (rhs.title_text < lhs.title_text)
    return false;
  if (lhs.body_text < rhs.body_text)
    return true;
  if (rhs.body_text < lhs.body_text)
    return false;
  if (lhs.close_button_alt_text < rhs.close_button_alt_text)
    return true;
  if (rhs.close_button_alt_text < lhs.close_button_alt_text)
    return false;
  if (lhs.body_icon_name < rhs.body_icon_name)
    return true;
  if (rhs.body_icon_name < lhs.body_icon_name)
    return false;
  if (lhs.body_icon_alt_text < rhs.body_icon_alt_text)
    return true;
  if (rhs.body_icon_alt_text < lhs.body_icon_alt_text)
    return false;
  if (lhs.progress < rhs.progress)
    return true;
  if (rhs.progress < lhs.progress)
    return false;
  if (lhs.buttons < rhs.buttons)
    return true;
  if (rhs.buttons < lhs.buttons)
    return false;
  if (lhs.focus_on_show_hint < rhs.focus_on_show_hint)
    return true;
  if (rhs.focus_on_show_hint < lhs.focus_on_show_hint)
    return false;
  if (lhs.timeout < rhs.timeout)
    return true;
  if (rhs.timeout < lhs.timeout)
    return false;
  return false;
}


}  // help_bubble::mojom

namespace mojo {


template <>
struct  StructTraits<::help_bubble::mojom::HelpBubbleButtonParams::DataView,
                                         ::help_bubble::mojom::HelpBubbleButtonParamsPtr> {
  static bool IsNull(const ::help_bubble::mojom::HelpBubbleButtonParamsPtr& input) { return !input; }
  static void SetToNull(::help_bubble::mojom::HelpBubbleButtonParamsPtr* output) { output->reset(); }

  static const decltype(::help_bubble::mojom::HelpBubbleButtonParams::text)& text(
      const ::help_bubble::mojom::HelpBubbleButtonParamsPtr& input) {
    return input->text;
  }

  static decltype(::help_bubble::mojom::HelpBubbleButtonParams::is_default) is_default(
      const ::help_bubble::mojom::HelpBubbleButtonParamsPtr& input) {
    return input->is_default;
  }

  static bool Read(::help_bubble::mojom::HelpBubbleButtonParams::DataView input, ::help_bubble::mojom::HelpBubbleButtonParamsPtr* output);
};


template <>
struct  StructTraits<::help_bubble::mojom::Progress::DataView,
                                         ::help_bubble::mojom::ProgressPtr> {
  static bool IsNull(const ::help_bubble::mojom::ProgressPtr& input) { return !input; }
  static void SetToNull(::help_bubble::mojom::ProgressPtr* output) { output->reset(); }

  static decltype(::help_bubble::mojom::Progress::current) current(
      const ::help_bubble::mojom::ProgressPtr& input) {
    return input->current;
  }

  static decltype(::help_bubble::mojom::Progress::total) total(
      const ::help_bubble::mojom::ProgressPtr& input) {
    return input->total;
  }

  static bool Read(::help_bubble::mojom::Progress::DataView input, ::help_bubble::mojom::ProgressPtr* output);
};


template <>
struct  StructTraits<::help_bubble::mojom::HelpBubbleParams::DataView,
                                         ::help_bubble::mojom::HelpBubbleParamsPtr> {
  static bool IsNull(const ::help_bubble::mojom::HelpBubbleParamsPtr& input) { return !input; }
  static void SetToNull(::help_bubble::mojom::HelpBubbleParamsPtr* output) { output->reset(); }

  static const decltype(::help_bubble::mojom::HelpBubbleParams::native_identifier)& native_identifier(
      const ::help_bubble::mojom::HelpBubbleParamsPtr& input) {
    return input->native_identifier;
  }

  static decltype(::help_bubble::mojom::HelpBubbleParams::position) position(
      const ::help_bubble::mojom::HelpBubbleParamsPtr& input) {
    return input->position;
  }

  static const decltype(::help_bubble::mojom::HelpBubbleParams::title_text)& title_text(
      const ::help_bubble::mojom::HelpBubbleParamsPtr& input) {
    return input->title_text;
  }

  static const decltype(::help_bubble::mojom::HelpBubbleParams::body_text)& body_text(
      const ::help_bubble::mojom::HelpBubbleParamsPtr& input) {
    return input->body_text;
  }

  static const decltype(::help_bubble::mojom::HelpBubbleParams::close_button_alt_text)& close_button_alt_text(
      const ::help_bubble::mojom::HelpBubbleParamsPtr& input) {
    return input->close_button_alt_text;
  }

  static const decltype(::help_bubble::mojom::HelpBubbleParams::body_icon_name)& body_icon_name(
      const ::help_bubble::mojom::HelpBubbleParamsPtr& input) {
    return input->body_icon_name;
  }

  static const decltype(::help_bubble::mojom::HelpBubbleParams::body_icon_alt_text)& body_icon_alt_text(
      const ::help_bubble::mojom::HelpBubbleParamsPtr& input) {
    return input->body_icon_alt_text;
  }

  static const decltype(::help_bubble::mojom::HelpBubbleParams::progress)& progress(
      const ::help_bubble::mojom::HelpBubbleParamsPtr& input) {
    return input->progress;
  }

  static const decltype(::help_bubble::mojom::HelpBubbleParams::buttons)& buttons(
      const ::help_bubble::mojom::HelpBubbleParamsPtr& input) {
    return input->buttons;
  }

  static decltype(::help_bubble::mojom::HelpBubbleParams::focus_on_show_hint) focus_on_show_hint(
      const ::help_bubble::mojom::HelpBubbleParamsPtr& input) {
    return input->focus_on_show_hint;
  }

  static const decltype(::help_bubble::mojom::HelpBubbleParams::timeout)& timeout(
      const ::help_bubble::mojom::HelpBubbleParamsPtr& input) {
    return input->timeout;
  }

  static bool Read(::help_bubble::mojom::HelpBubbleParams::DataView input, ::help_bubble::mojom::HelpBubbleParamsPtr* output);
};

}  // namespace mojo

#endif  // UI_WEBUI_RESOURCES_CR_COMPONENTS_HELP_BUBBLE_HELP_BUBBLE_MOJOM_H_