// ui/webui/resources/cr_components/help_bubble/help_bubble.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/webui/resources/cr_components/help_bubble/help_bubble.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/webui/resources/cr_components/help_bubble/help_bubble.mojom-params-data.h"
#include "ui/webui/resources/cr_components/help_bubble/help_bubble.mojom-shared-message-ids.h"

#include "ui/webui/resources/cr_components/help_bubble/help_bubble.mojom-import-headers.h"
#include "ui/webui/resources/cr_components/help_bubble/help_bubble.mojom-test-utils.h"


namespace help_bubble::mojom {
HelpBubbleButtonParams::HelpBubbleButtonParams()
    : text(),
      is_default(false) {}

HelpBubbleButtonParams::HelpBubbleButtonParams(
    const std::string& text_in,
    bool is_default_in)
    : text(std::move(text_in)),
      is_default(std::move(is_default_in)) {}

HelpBubbleButtonParams::~HelpBubbleButtonParams() = default;
size_t HelpBubbleButtonParams::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->text);
  seed = mojo::internal::Hash(seed, this->is_default);
  return seed;
}

void HelpBubbleButtonParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text"), this->text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_default"), this->is_default,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool HelpBubbleButtonParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Progress::Progress()
    : current(),
      total() {}

Progress::Progress(
    uint8_t current_in,
    uint8_t total_in)
    : current(std::move(current_in)),
      total(std::move(total_in)) {}

Progress::~Progress() = default;
size_t Progress::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->current);
  seed = mojo::internal::Hash(seed, this->total);
  return seed;
}

void Progress::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "current"), this->current,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "total"), this->total,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Progress::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
HelpBubbleParams::HelpBubbleParams()
    : native_identifier(),
      position(HelpBubbleArrowPosition::TOP_CENTER),
      title_text(),
      body_text(),
      close_button_alt_text(),
      body_icon_name(),
      body_icon_alt_text(),
      progress(),
      buttons(),
      focus_on_show_hint(),
      timeout() {}

HelpBubbleParams::HelpBubbleParams(
    const std::string& native_identifier_in,
    HelpBubbleArrowPosition position_in,
    const std::optional<std::string>& title_text_in,
    const std::string& body_text_in,
    const std::string& close_button_alt_text_in,
    const std::optional<std::string>& body_icon_name_in,
    const std::string& body_icon_alt_text_in,
    ProgressPtr progress_in,
    std::vector<HelpBubbleButtonParamsPtr> buttons_in,
    std::optional<bool> focus_on_show_hint_in,
    std::optional<::base::TimeDelta> timeout_in)
    : native_identifier(std::move(native_identifier_in)),
      position(std::move(position_in)),
      title_text(std::move(title_text_in)),
      body_text(std::move(body_text_in)),
      close_button_alt_text(std::move(close_button_alt_text_in)),
      body_icon_name(std::move(body_icon_name_in)),
      body_icon_alt_text(std::move(body_icon_alt_text_in)),
      progress(std::move(progress_in)),
      buttons(std::move(buttons_in)),
      focus_on_show_hint(std::move(focus_on_show_hint_in)),
      timeout(std::move(timeout_in)) {}

HelpBubbleParams::~HelpBubbleParams() = default;

void HelpBubbleParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "native_identifier"), this->native_identifier,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "position"), this->position,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type HelpBubbleArrowPosition>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title_text"), this->title_text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "body_text"), this->body_text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "close_button_alt_text"), this->close_button_alt_text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "body_icon_name"), this->body_icon_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "body_icon_alt_text"), this->body_icon_alt_text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "progress"), this->progress,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ProgressPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "buttons"), this->buttons,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<HelpBubbleButtonParamsPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "focus_on_show_hint"), this->focus_on_show_hint,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<bool>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timeout"), this->timeout,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool HelpBubbleParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

HelpBubbleHandlerFactory::IPCStableHashFunction HelpBubbleHandlerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::HelpBubbleHandlerFactory>(message.name())) {
    case messages::HelpBubbleHandlerFactory::kCreateHelpBubbleHandler: {
      return &HelpBubbleHandlerFactory::CreateHelpBubbleHandler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* HelpBubbleHandlerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::HelpBubbleHandlerFactory>(message.name())) {
      case messages::HelpBubbleHandlerFactory::kCreateHelpBubbleHandler:
            return "Receive help_bubble::mojom::HelpBubbleHandlerFactory::CreateHelpBubbleHandler";
    }
  } else {
    switch (static_cast<messages::HelpBubbleHandlerFactory>(message.name())) {
      case messages::HelpBubbleHandlerFactory::kCreateHelpBubbleHandler:
            return "Receive reply help_bubble::mojom::HelpBubbleHandlerFactory::CreateHelpBubbleHandler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t HelpBubbleHandlerFactory::CreateHelpBubbleHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x186e2d8a;  // IPCStableHash for help_bubble::mojom::HelpBubbleHandlerFactory::CreateHelpBubbleHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

HelpBubbleHandlerFactoryProxy::HelpBubbleHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void HelpBubbleHandlerFactoryProxy::CreateHelpBubbleHandler(
    ::mojo::PendingRemote<HelpBubbleClient> in_client, ::mojo::PendingReceiver<HelpBubbleHandler> in_handler) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send help_bubble::mojom::HelpBubbleHandlerFactory::CreateHelpBubbleHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<HelpBubbleClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler"), in_handler,
                        "<value of type ::mojo::PendingReceiver<HelpBubbleHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::HelpBubbleHandlerFactory::kCreateHelpBubbleHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::help_bubble::mojom::internal::HelpBubbleHandlerFactory_CreateHelpBubbleHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::help_bubble::mojom::HelpBubbleClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in HelpBubbleHandlerFactory.CreateHelpBubbleHandler request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::help_bubble::mojom::HelpBubbleHandlerInterfaceBase>>(
    in_handler,
    &params->handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handler in HelpBubbleHandlerFactory.CreateHelpBubbleHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HelpBubbleHandlerFactory::Name_);
  message.set_method_name("CreateHelpBubbleHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool HelpBubbleHandlerFactoryStubDispatch::Accept(
    HelpBubbleHandlerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::HelpBubbleHandlerFactory>(message->header()->name)) {
    case messages::HelpBubbleHandlerFactory::kCreateHelpBubbleHandler: {
      DCHECK(message->is_serialized());
      internal::HelpBubbleHandlerFactory_CreateHelpBubbleHandler_Params_Data* params =
          reinterpret_cast<internal::HelpBubbleHandlerFactory_CreateHelpBubbleHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for HelpBubbleHandlerFactory.0
      bool success = true;
      ::mojo::PendingRemote<HelpBubbleClient> p_client{};
      ::mojo::PendingReceiver<HelpBubbleHandler> p_handler{};
      HelpBubbleHandlerFactory_CreateHelpBubbleHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success) {
        p_handler =
            input_data_view.TakeHandler<decltype(p_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            HelpBubbleHandlerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateHelpBubbleHandler(        
        std::move(p_client), 
        std::move(p_handler));
      return true;
    }
  }
  return false;
}

// static
bool HelpBubbleHandlerFactoryStubDispatch::AcceptWithResponder(
    HelpBubbleHandlerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::HelpBubbleHandlerFactory>(message->header()->name)) {
    case messages::HelpBubbleHandlerFactory::kCreateHelpBubbleHandler: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kHelpBubbleHandlerFactoryValidationInfo[] = {
    { &internal::HelpBubbleHandlerFactory_CreateHelpBubbleHandler_Params_Data::Validate,
     nullptr /* no response */},
};

bool HelpBubbleHandlerFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::help_bubble::mojom::HelpBubbleHandlerFactory::Name_,
    kHelpBubbleHandlerFactoryValidationInfo);
}

// The declaration includes the definition on other builds.

PdfHelpBubbleHandlerFactory::IPCStableHashFunction PdfHelpBubbleHandlerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PdfHelpBubbleHandlerFactory>(message.name())) {
    case messages::PdfHelpBubbleHandlerFactory::kCreateHelpBubbleHandler: {
      return &PdfHelpBubbleHandlerFactory::CreateHelpBubbleHandler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PdfHelpBubbleHandlerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PdfHelpBubbleHandlerFactory>(message.name())) {
      case messages::PdfHelpBubbleHandlerFactory::kCreateHelpBubbleHandler:
            return "Receive help_bubble::mojom::PdfHelpBubbleHandlerFactory::CreateHelpBubbleHandler";
    }
  } else {
    switch (static_cast<messages::PdfHelpBubbleHandlerFactory>(message.name())) {
      case messages::PdfHelpBubbleHandlerFactory::kCreateHelpBubbleHandler:
            return "Receive reply help_bubble::mojom::PdfHelpBubbleHandlerFactory::CreateHelpBubbleHandler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PdfHelpBubbleHandlerFactory::CreateHelpBubbleHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x30e5efd0;  // IPCStableHash for help_bubble::mojom::PdfHelpBubbleHandlerFactory::CreateHelpBubbleHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PdfHelpBubbleHandlerFactoryProxy::PdfHelpBubbleHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PdfHelpBubbleHandlerFactoryProxy::CreateHelpBubbleHandler(
    ::mojo::PendingRemote<HelpBubbleClient> in_client, ::mojo::PendingReceiver<HelpBubbleHandler> in_handler) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send help_bubble::mojom::PdfHelpBubbleHandlerFactory::CreateHelpBubbleHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<HelpBubbleClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler"), in_handler,
                        "<value of type ::mojo::PendingReceiver<HelpBubbleHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PdfHelpBubbleHandlerFactory::kCreateHelpBubbleHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::help_bubble::mojom::internal::PdfHelpBubbleHandlerFactory_CreateHelpBubbleHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::help_bubble::mojom::HelpBubbleClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in PdfHelpBubbleHandlerFactory.CreateHelpBubbleHandler request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::help_bubble::mojom::HelpBubbleHandlerInterfaceBase>>(
    in_handler,
    &params->handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handler in PdfHelpBubbleHandlerFactory.CreateHelpBubbleHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PdfHelpBubbleHandlerFactory::Name_);
  message.set_method_name("CreateHelpBubbleHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PdfHelpBubbleHandlerFactoryStubDispatch::Accept(
    PdfHelpBubbleHandlerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PdfHelpBubbleHandlerFactory>(message->header()->name)) {
    case messages::PdfHelpBubbleHandlerFactory::kCreateHelpBubbleHandler: {
      DCHECK(message->is_serialized());
      internal::PdfHelpBubbleHandlerFactory_CreateHelpBubbleHandler_Params_Data* params =
          reinterpret_cast<internal::PdfHelpBubbleHandlerFactory_CreateHelpBubbleHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PdfHelpBubbleHandlerFactory.0
      bool success = true;
      ::mojo::PendingRemote<HelpBubbleClient> p_client{};
      ::mojo::PendingReceiver<HelpBubbleHandler> p_handler{};
      PdfHelpBubbleHandlerFactory_CreateHelpBubbleHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success) {
        p_handler =
            input_data_view.TakeHandler<decltype(p_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PdfHelpBubbleHandlerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateHelpBubbleHandler(        
        std::move(p_client), 
        std::move(p_handler));
      return true;
    }
  }
  return false;
}

// static
bool PdfHelpBubbleHandlerFactoryStubDispatch::AcceptWithResponder(
    PdfHelpBubbleHandlerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PdfHelpBubbleHandlerFactory>(message->header()->name)) {
    case messages::PdfHelpBubbleHandlerFactory::kCreateHelpBubbleHandler: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPdfHelpBubbleHandlerFactoryValidationInfo[] = {
    { &internal::PdfHelpBubbleHandlerFactory_CreateHelpBubbleHandler_Params_Data::Validate,
     nullptr /* no response */},
};

bool PdfHelpBubbleHandlerFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::help_bubble::mojom::PdfHelpBubbleHandlerFactory::Name_,
    kPdfHelpBubbleHandlerFactoryValidationInfo);
}

// The declaration includes the definition on other builds.

HelpBubbleHandler::IPCStableHashFunction HelpBubbleHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::HelpBubbleHandler>(message.name())) {
    case messages::HelpBubbleHandler::kBindTrackedElementHandler: {
      return &HelpBubbleHandler::BindTrackedElementHandler_Sym::IPCStableHash;
    }
    case messages::HelpBubbleHandler::kHelpBubbleButtonPressed: {
      return &HelpBubbleHandler::HelpBubbleButtonPressed_Sym::IPCStableHash;
    }
    case messages::HelpBubbleHandler::kHelpBubbleClosed: {
      return &HelpBubbleHandler::HelpBubbleClosed_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* HelpBubbleHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::HelpBubbleHandler>(message.name())) {
      case messages::HelpBubbleHandler::kBindTrackedElementHandler:
            return "Receive help_bubble::mojom::HelpBubbleHandler::BindTrackedElementHandler";
      case messages::HelpBubbleHandler::kHelpBubbleButtonPressed:
            return "Receive help_bubble::mojom::HelpBubbleHandler::HelpBubbleButtonPressed";
      case messages::HelpBubbleHandler::kHelpBubbleClosed:
            return "Receive help_bubble::mojom::HelpBubbleHandler::HelpBubbleClosed";
    }
  } else {
    switch (static_cast<messages::HelpBubbleHandler>(message.name())) {
      case messages::HelpBubbleHandler::kBindTrackedElementHandler:
            return "Receive reply help_bubble::mojom::HelpBubbleHandler::BindTrackedElementHandler";
      case messages::HelpBubbleHandler::kHelpBubbleButtonPressed:
            return "Receive reply help_bubble::mojom::HelpBubbleHandler::HelpBubbleButtonPressed";
      case messages::HelpBubbleHandler::kHelpBubbleClosed:
            return "Receive reply help_bubble::mojom::HelpBubbleHandler::HelpBubbleClosed";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t HelpBubbleHandler::BindTrackedElementHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb178826d;  // IPCStableHash for help_bubble::mojom::HelpBubbleHandler::BindTrackedElementHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t HelpBubbleHandler::HelpBubbleButtonPressed_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x49f32610;  // IPCStableHash for help_bubble::mojom::HelpBubbleHandler::HelpBubbleButtonPressed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t HelpBubbleHandler::HelpBubbleClosed_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4c52dc2e;  // IPCStableHash for help_bubble::mojom::HelpBubbleHandler::HelpBubbleClosed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

HelpBubbleHandlerProxy::HelpBubbleHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void HelpBubbleHandlerProxy::BindTrackedElementHandler(
    ::mojo::PendingReceiver<::tracked_element::mojom::TrackedElementHandler> in_handler) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send help_bubble::mojom::HelpBubbleHandler::BindTrackedElementHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler"), in_handler,
                        "<value of type ::mojo::PendingReceiver<::tracked_element::mojom::TrackedElementHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::HelpBubbleHandler::kBindTrackedElementHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::help_bubble::mojom::internal::HelpBubbleHandler_BindTrackedElementHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::tracked_element::mojom::TrackedElementHandlerInterfaceBase>>(
    in_handler,
    &params->handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handler in HelpBubbleHandler.BindTrackedElementHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HelpBubbleHandler::Name_);
  message.set_method_name("BindTrackedElementHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void HelpBubbleHandlerProxy::HelpBubbleButtonPressed(
    const std::string& in_native_identifier, uint8_t in_button_index) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send help_bubble::mojom::HelpBubbleHandler::HelpBubbleButtonPressed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("native_identifier"), in_native_identifier,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("button_index"), in_button_index,
                        "<value of type uint8_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::HelpBubbleHandler::kHelpBubbleButtonPressed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::help_bubble::mojom::internal::HelpBubbleHandler_HelpBubbleButtonPressed_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->native_identifier)::BaseType> native_identifier_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_native_identifier,
    native_identifier_fragment);

  params->native_identifier.Set(
      native_identifier_fragment.is_null() ? nullptr : native_identifier_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->native_identifier.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null native_identifier in HelpBubbleHandler.HelpBubbleButtonPressed request");

  params->button_index = in_button_index;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HelpBubbleHandler::Name_);
  message.set_method_name("HelpBubbleButtonPressed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void HelpBubbleHandlerProxy::HelpBubbleClosed(
    const std::string& in_native_identifier, HelpBubbleClosedReason in_reason) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send help_bubble::mojom::HelpBubbleHandler::HelpBubbleClosed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("native_identifier"), in_native_identifier,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reason"), in_reason,
                        "<value of type HelpBubbleClosedReason>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::HelpBubbleHandler::kHelpBubbleClosed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::help_bubble::mojom::internal::HelpBubbleHandler_HelpBubbleClosed_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->native_identifier)::BaseType> native_identifier_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_native_identifier,
    native_identifier_fragment);

  params->native_identifier.Set(
      native_identifier_fragment.is_null() ? nullptr : native_identifier_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->native_identifier.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null native_identifier in HelpBubbleHandler.HelpBubbleClosed request");

  
  mojo::internal::Serialize<::help_bubble::mojom::HelpBubbleClosedReason>(
    in_reason,
    &params->reason);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HelpBubbleHandler::Name_);
  message.set_method_name("HelpBubbleClosed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool HelpBubbleHandlerStubDispatch::Accept(
    HelpBubbleHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::HelpBubbleHandler>(message->header()->name)) {
    case messages::HelpBubbleHandler::kBindTrackedElementHandler: {
      DCHECK(message->is_serialized());
      internal::HelpBubbleHandler_BindTrackedElementHandler_Params_Data* params =
          reinterpret_cast<internal::HelpBubbleHandler_BindTrackedElementHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for HelpBubbleHandler.0
      bool success = true;
      ::mojo::PendingReceiver<::tracked_element::mojom::TrackedElementHandler> p_handler{};
      HelpBubbleHandler_BindTrackedElementHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_handler =
            input_data_view.TakeHandler<decltype(p_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            HelpBubbleHandler::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindTrackedElementHandler(        
        std::move(p_handler));
      return true;
    }
    case messages::HelpBubbleHandler::kHelpBubbleButtonPressed: {
      DCHECK(message->is_serialized());
      internal::HelpBubbleHandler_HelpBubbleButtonPressed_Params_Data* params =
          reinterpret_cast<internal::HelpBubbleHandler_HelpBubbleButtonPressed_Params_Data*>(
              message->mutable_payload());
      

      // Validation for HelpBubbleHandler.1
      bool success = true;
      std::string p_native_identifier{};
      uint8_t p_button_index{};
      HelpBubbleHandler_HelpBubbleButtonPressed_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNativeIdentifier(&p_native_identifier))
        success = false;
      if (success)
        p_button_index = input_data_view.button_index();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            HelpBubbleHandler::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HelpBubbleButtonPressed(        
        std::move(p_native_identifier), 
        std::move(p_button_index));
      return true;
    }
    case messages::HelpBubbleHandler::kHelpBubbleClosed: {
      DCHECK(message->is_serialized());
      internal::HelpBubbleHandler_HelpBubbleClosed_Params_Data* params =
          reinterpret_cast<internal::HelpBubbleHandler_HelpBubbleClosed_Params_Data*>(
              message->mutable_payload());
      

      // Validation for HelpBubbleHandler.2
      bool success = true;
      std::string p_native_identifier{};
      HelpBubbleClosedReason p_reason{};
      HelpBubbleHandler_HelpBubbleClosed_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNativeIdentifier(&p_native_identifier))
        success = false;
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            HelpBubbleHandler::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HelpBubbleClosed(        
        std::move(p_native_identifier), 
        std::move(p_reason));
      return true;
    }
  }
  return false;
}

// static
bool HelpBubbleHandlerStubDispatch::AcceptWithResponder(
    HelpBubbleHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::HelpBubbleHandler>(message->header()->name)) {
    case messages::HelpBubbleHandler::kBindTrackedElementHandler: {
      break;
    }
    case messages::HelpBubbleHandler::kHelpBubbleButtonPressed: {
      break;
    }
    case messages::HelpBubbleHandler::kHelpBubbleClosed: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kHelpBubbleHandlerValidationInfo[] = {
    { &internal::HelpBubbleHandler_BindTrackedElementHandler_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::HelpBubbleHandler_HelpBubbleButtonPressed_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::HelpBubbleHandler_HelpBubbleClosed_Params_Data::Validate,
     nullptr /* no response */},
};

bool HelpBubbleHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::help_bubble::mojom::HelpBubbleHandler::Name_,
    kHelpBubbleHandlerValidationInfo);
}

// The declaration includes the definition on other builds.

HelpBubbleClient::IPCStableHashFunction HelpBubbleClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::HelpBubbleClient>(message.name())) {
    case messages::HelpBubbleClient::kShowHelpBubble: {
      return &HelpBubbleClient::ShowHelpBubble_Sym::IPCStableHash;
    }
    case messages::HelpBubbleClient::kToggleFocusForAccessibility: {
      return &HelpBubbleClient::ToggleFocusForAccessibility_Sym::IPCStableHash;
    }
    case messages::HelpBubbleClient::kHideHelpBubble: {
      return &HelpBubbleClient::HideHelpBubble_Sym::IPCStableHash;
    }
    case messages::HelpBubbleClient::kExternalHelpBubbleUpdated: {
      return &HelpBubbleClient::ExternalHelpBubbleUpdated_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* HelpBubbleClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::HelpBubbleClient>(message.name())) {
      case messages::HelpBubbleClient::kShowHelpBubble:
            return "Receive help_bubble::mojom::HelpBubbleClient::ShowHelpBubble";
      case messages::HelpBubbleClient::kToggleFocusForAccessibility:
            return "Receive help_bubble::mojom::HelpBubbleClient::ToggleFocusForAccessibility";
      case messages::HelpBubbleClient::kHideHelpBubble:
            return "Receive help_bubble::mojom::HelpBubbleClient::HideHelpBubble";
      case messages::HelpBubbleClient::kExternalHelpBubbleUpdated:
            return "Receive help_bubble::mojom::HelpBubbleClient::ExternalHelpBubbleUpdated";
    }
  } else {
    switch (static_cast<messages::HelpBubbleClient>(message.name())) {
      case messages::HelpBubbleClient::kShowHelpBubble:
            return "Receive reply help_bubble::mojom::HelpBubbleClient::ShowHelpBubble";
      case messages::HelpBubbleClient::kToggleFocusForAccessibility:
            return "Receive reply help_bubble::mojom::HelpBubbleClient::ToggleFocusForAccessibility";
      case messages::HelpBubbleClient::kHideHelpBubble:
            return "Receive reply help_bubble::mojom::HelpBubbleClient::HideHelpBubble";
      case messages::HelpBubbleClient::kExternalHelpBubbleUpdated:
            return "Receive reply help_bubble::mojom::HelpBubbleClient::ExternalHelpBubbleUpdated";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t HelpBubbleClient::ShowHelpBubble_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa868ff47;  // IPCStableHash for help_bubble::mojom::HelpBubbleClient::ShowHelpBubble
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t HelpBubbleClient::ToggleFocusForAccessibility_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8eb276ad;  // IPCStableHash for help_bubble::mojom::HelpBubbleClient::ToggleFocusForAccessibility
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t HelpBubbleClient::HideHelpBubble_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb7b1fc22;  // IPCStableHash for help_bubble::mojom::HelpBubbleClient::HideHelpBubble
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t HelpBubbleClient::ExternalHelpBubbleUpdated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb84bde91;  // IPCStableHash for help_bubble::mojom::HelpBubbleClient::ExternalHelpBubbleUpdated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

HelpBubbleClientProxy::HelpBubbleClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void HelpBubbleClientProxy::ShowHelpBubble(
    HelpBubbleParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send help_bubble::mojom::HelpBubbleClient::ShowHelpBubble", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type HelpBubbleParamsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::HelpBubbleClient::kShowHelpBubble), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::help_bubble::mojom::internal::HelpBubbleClient_ShowHelpBubble_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::help_bubble::mojom::HelpBubbleParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in HelpBubbleClient.ShowHelpBubble request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HelpBubbleClient::Name_);
  message.set_method_name("ShowHelpBubble");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void HelpBubbleClientProxy::ToggleFocusForAccessibility(
    const std::string& in_native_identifier) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send help_bubble::mojom::HelpBubbleClient::ToggleFocusForAccessibility", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("native_identifier"), in_native_identifier,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::HelpBubbleClient::kToggleFocusForAccessibility), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::help_bubble::mojom::internal::HelpBubbleClient_ToggleFocusForAccessibility_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->native_identifier)::BaseType> native_identifier_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_native_identifier,
    native_identifier_fragment);

  params->native_identifier.Set(
      native_identifier_fragment.is_null() ? nullptr : native_identifier_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->native_identifier.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null native_identifier in HelpBubbleClient.ToggleFocusForAccessibility request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HelpBubbleClient::Name_);
  message.set_method_name("ToggleFocusForAccessibility");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void HelpBubbleClientProxy::HideHelpBubble(
    const std::string& in_native_identifier) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send help_bubble::mojom::HelpBubbleClient::HideHelpBubble", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("native_identifier"), in_native_identifier,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::HelpBubbleClient::kHideHelpBubble), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::help_bubble::mojom::internal::HelpBubbleClient_HideHelpBubble_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->native_identifier)::BaseType> native_identifier_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_native_identifier,
    native_identifier_fragment);

  params->native_identifier.Set(
      native_identifier_fragment.is_null() ? nullptr : native_identifier_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->native_identifier.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null native_identifier in HelpBubbleClient.HideHelpBubble request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HelpBubbleClient::Name_);
  message.set_method_name("HideHelpBubble");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void HelpBubbleClientProxy::ExternalHelpBubbleUpdated(
    const std::string& in_native_identifier, bool in_shown) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send help_bubble::mojom::HelpBubbleClient::ExternalHelpBubbleUpdated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("native_identifier"), in_native_identifier,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("shown"), in_shown,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::HelpBubbleClient::kExternalHelpBubbleUpdated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::help_bubble::mojom::internal::HelpBubbleClient_ExternalHelpBubbleUpdated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->native_identifier)::BaseType> native_identifier_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_native_identifier,
    native_identifier_fragment);

  params->native_identifier.Set(
      native_identifier_fragment.is_null() ? nullptr : native_identifier_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->native_identifier.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null native_identifier in HelpBubbleClient.ExternalHelpBubbleUpdated request");

  params->shown = in_shown;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HelpBubbleClient::Name_);
  message.set_method_name("ExternalHelpBubbleUpdated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool HelpBubbleClientStubDispatch::Accept(
    HelpBubbleClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::HelpBubbleClient>(message->header()->name)) {
    case messages::HelpBubbleClient::kShowHelpBubble: {
      DCHECK(message->is_serialized());
      internal::HelpBubbleClient_ShowHelpBubble_Params_Data* params =
          reinterpret_cast<internal::HelpBubbleClient_ShowHelpBubble_Params_Data*>(
              message->mutable_payload());
      

      // Validation for HelpBubbleClient.0
      bool success = true;
      HelpBubbleParamsPtr p_params{};
      HelpBubbleClient_ShowHelpBubble_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            HelpBubbleClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowHelpBubble(        
        std::move(p_params));
      return true;
    }
    case messages::HelpBubbleClient::kToggleFocusForAccessibility: {
      DCHECK(message->is_serialized());
      internal::HelpBubbleClient_ToggleFocusForAccessibility_Params_Data* params =
          reinterpret_cast<internal::HelpBubbleClient_ToggleFocusForAccessibility_Params_Data*>(
              message->mutable_payload());
      

      // Validation for HelpBubbleClient.1
      bool success = true;
      std::string p_native_identifier{};
      HelpBubbleClient_ToggleFocusForAccessibility_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNativeIdentifier(&p_native_identifier))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            HelpBubbleClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ToggleFocusForAccessibility(        
        std::move(p_native_identifier));
      return true;
    }
    case messages::HelpBubbleClient::kHideHelpBubble: {
      DCHECK(message->is_serialized());
      internal::HelpBubbleClient_HideHelpBubble_Params_Data* params =
          reinterpret_cast<internal::HelpBubbleClient_HideHelpBubble_Params_Data*>(
              message->mutable_payload());
      

      // Validation for HelpBubbleClient.2
      bool success = true;
      std::string p_native_identifier{};
      HelpBubbleClient_HideHelpBubble_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNativeIdentifier(&p_native_identifier))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            HelpBubbleClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HideHelpBubble(        
        std::move(p_native_identifier));
      return true;
    }
    case messages::HelpBubbleClient::kExternalHelpBubbleUpdated: {
      DCHECK(message->is_serialized());
      internal::HelpBubbleClient_ExternalHelpBubbleUpdated_Params_Data* params =
          reinterpret_cast<internal::HelpBubbleClient_ExternalHelpBubbleUpdated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for HelpBubbleClient.3
      bool success = true;
      std::string p_native_identifier{};
      bool p_shown{};
      HelpBubbleClient_ExternalHelpBubbleUpdated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNativeIdentifier(&p_native_identifier))
        success = false;
      if (success)
        p_shown = input_data_view.shown();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            HelpBubbleClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExternalHelpBubbleUpdated(        
        std::move(p_native_identifier), 
        std::move(p_shown));
      return true;
    }
  }
  return false;
}

// static
bool HelpBubbleClientStubDispatch::AcceptWithResponder(
    HelpBubbleClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::HelpBubbleClient>(message->header()->name)) {
    case messages::HelpBubbleClient::kShowHelpBubble: {
      break;
    }
    case messages::HelpBubbleClient::kToggleFocusForAccessibility: {
      break;
    }
    case messages::HelpBubbleClient::kHideHelpBubble: {
      break;
    }
    case messages::HelpBubbleClient::kExternalHelpBubbleUpdated: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kHelpBubbleClientValidationInfo[] = {
    { &internal::HelpBubbleClient_ShowHelpBubble_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::HelpBubbleClient_ToggleFocusForAccessibility_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::HelpBubbleClient_HideHelpBubble_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::HelpBubbleClient_ExternalHelpBubbleUpdated_Params_Data::Validate,
     nullptr /* no response */},
};

bool HelpBubbleClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::help_bubble::mojom::HelpBubbleClient::Name_,
    kHelpBubbleClientValidationInfo);
}



}  // help_bubble::mojom


namespace mojo {


// static
bool StructTraits<::help_bubble::mojom::HelpBubbleButtonParams::DataView, ::help_bubble::mojom::HelpBubbleButtonParamsPtr>::Read(
    ::help_bubble::mojom::HelpBubbleButtonParams::DataView input,
    ::help_bubble::mojom::HelpBubbleButtonParamsPtr* output) {
  bool success = true;
  ::help_bubble::mojom::HelpBubbleButtonParamsPtr result(::help_bubble::mojom::HelpBubbleButtonParams::New());
  
      if (success && !input.ReadText(&result->text))
        success = false;
      if (success)
        result->is_default = input.is_default();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::help_bubble::mojom::Progress::DataView, ::help_bubble::mojom::ProgressPtr>::Read(
    ::help_bubble::mojom::Progress::DataView input,
    ::help_bubble::mojom::ProgressPtr* output) {
  bool success = true;
  ::help_bubble::mojom::ProgressPtr result(::help_bubble::mojom::Progress::New());
  
      if (success)
        result->current = input.current();
      if (success)
        result->total = input.total();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::help_bubble::mojom::HelpBubbleParams::DataView, ::help_bubble::mojom::HelpBubbleParamsPtr>::Read(
    ::help_bubble::mojom::HelpBubbleParams::DataView input,
    ::help_bubble::mojom::HelpBubbleParamsPtr* output) {
  bool success = true;
  ::help_bubble::mojom::HelpBubbleParamsPtr result(::help_bubble::mojom::HelpBubbleParams::New());
  
      if (success && !input.ReadNativeIdentifier(&result->native_identifier))
        success = false;
      if (success && !input.ReadPosition(&result->position))
        success = false;
      if (success && !input.ReadTitleText(&result->title_text))
        success = false;
      if (success && !input.ReadBodyText(&result->body_text))
        success = false;
      if (success && !input.ReadCloseButtonAltText(&result->close_button_alt_text))
        success = false;
      if (success && !input.ReadBodyIconName(&result->body_icon_name))
        success = false;
      if (success && !input.ReadBodyIconAltText(&result->body_icon_alt_text))
        success = false;
      if (success && !input.ReadProgress(&result->progress))
        success = false;
      if (success && !input.ReadButtons(&result->buttons))
        success = false;
      if (success) {
        result->focus_on_show_hint = input.focus_on_show_hint();
      }
      if (success && !input.ReadTimeout(&result->timeout))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace help_bubble::mojom {


void HelpBubbleHandlerFactoryInterceptorForTesting::CreateHelpBubbleHandler(::mojo::PendingRemote<HelpBubbleClient> client, ::mojo::PendingReceiver<HelpBubbleHandler> handler) {
  GetForwardingInterface()->CreateHelpBubbleHandler(
    std::move(client)
    , 
    std::move(handler)
    );
}
HelpBubbleHandlerFactoryAsyncWaiter::HelpBubbleHandlerFactoryAsyncWaiter(
    HelpBubbleHandlerFactory* proxy) : proxy_(proxy) {}

HelpBubbleHandlerFactoryAsyncWaiter::~HelpBubbleHandlerFactoryAsyncWaiter() = default;





void PdfHelpBubbleHandlerFactoryInterceptorForTesting::CreateHelpBubbleHandler(::mojo::PendingRemote<HelpBubbleClient> client, ::mojo::PendingReceiver<HelpBubbleHandler> handler) {
  GetForwardingInterface()->CreateHelpBubbleHandler(
    std::move(client)
    , 
    std::move(handler)
    );
}
PdfHelpBubbleHandlerFactoryAsyncWaiter::PdfHelpBubbleHandlerFactoryAsyncWaiter(
    PdfHelpBubbleHandlerFactory* proxy) : proxy_(proxy) {}

PdfHelpBubbleHandlerFactoryAsyncWaiter::~PdfHelpBubbleHandlerFactoryAsyncWaiter() = default;





void HelpBubbleHandlerInterceptorForTesting::BindTrackedElementHandler(::mojo::PendingReceiver<::tracked_element::mojom::TrackedElementHandler> handler) {
  GetForwardingInterface()->BindTrackedElementHandler(
    std::move(handler)
    );
}
void HelpBubbleHandlerInterceptorForTesting::HelpBubbleButtonPressed(const std::string& native_identifier, uint8_t button_index) {
  GetForwardingInterface()->HelpBubbleButtonPressed(
    std::move(native_identifier)
    , 
    std::move(button_index)
    );
}
void HelpBubbleHandlerInterceptorForTesting::HelpBubbleClosed(const std::string& native_identifier, HelpBubbleClosedReason reason) {
  GetForwardingInterface()->HelpBubbleClosed(
    std::move(native_identifier)
    , 
    std::move(reason)
    );
}
HelpBubbleHandlerAsyncWaiter::HelpBubbleHandlerAsyncWaiter(
    HelpBubbleHandler* proxy) : proxy_(proxy) {}

HelpBubbleHandlerAsyncWaiter::~HelpBubbleHandlerAsyncWaiter() = default;





void HelpBubbleClientInterceptorForTesting::ShowHelpBubble(HelpBubbleParamsPtr params) {
  GetForwardingInterface()->ShowHelpBubble(
    std::move(params)
    );
}
void HelpBubbleClientInterceptorForTesting::ToggleFocusForAccessibility(const std::string& native_identifier) {
  GetForwardingInterface()->ToggleFocusForAccessibility(
    std::move(native_identifier)
    );
}
void HelpBubbleClientInterceptorForTesting::HideHelpBubble(const std::string& native_identifier) {
  GetForwardingInterface()->HideHelpBubble(
    std::move(native_identifier)
    );
}
void HelpBubbleClientInterceptorForTesting::ExternalHelpBubbleUpdated(const std::string& native_identifier, bool shown) {
  GetForwardingInterface()->ExternalHelpBubbleUpdated(
    std::move(native_identifier)
    , 
    std::move(shown)
    );
}
HelpBubbleClientAsyncWaiter::HelpBubbleClientAsyncWaiter(
    HelpBubbleClient* proxy) : proxy_(proxy) {}

HelpBubbleClientAsyncWaiter::~HelpBubbleClientAsyncWaiter() = default;







}  // help_bubble::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif