// ui/webui/resources/cr_components/help_bubble/help_bubble.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec,
  TimeDelta as mojoBase_mojom_TimeDelta
} from '//resources/mojo/mojo/public/mojom/base/time.mojom-webui.js';
import {
  TrackedElementHandlerPendingReceiver as trackedElement_mojom_TrackedElementHandlerPendingReceiver
} from '//resources/mojo/ui/webui/resources/js/tracked_element/tracked_element.mojom-webui.js';





export const HelpBubbleArrowPositionSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum HelpBubbleArrowPosition {

  MIN_VALUE = 0,
  MAX_VALUE = 11,
  TOP_LEFT = 0,
  TOP_CENTER = 1,
  TOP_RIGHT = 2,
  BOTTOM_LEFT = 3,
  BOTTOM_CENTER = 4,
  BOTTOM_RIGHT = 5,
  LEFT_TOP = 6,
  LEFT_CENTER = 7,
  LEFT_BOTTOM = 8,
  RIGHT_TOP = 9,
  RIGHT_CENTER = 10,
  RIGHT_BOTTOM = 11,
}

export const HelpBubbleClosedReasonSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum HelpBubbleClosedReason {

  MIN_VALUE = 0,
  MAX_VALUE = 2,
  kPageChanged = 0,
  kDismissedByUser = 1,
  kTimedOut = 2,
}



export type HelpBubbleHandlerFactoryPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<HelpBubbleHandlerFactoryPendingReceiver>;

export class HelpBubbleHandlerFactoryPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<HelpBubbleHandlerFactory> {

  handle: mojo.internal.interfaceSupport.Endpoint<HelpBubbleHandlerFactoryPendingReceiver>;
  constructor(handle: MojoHandle|HelpBubbleHandlerFactoryPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'help_bubble.mojom.HelpBubbleHandlerFactory',
        scope);
  }
}

export interface HelpBubbleHandlerFactoryInterface {
  createHelpBubbleHandler(client: HelpBubbleClientRemote, handler: HelpBubbleHandlerPendingReceiver): void;
}

export class HelpBubbleHandlerFactoryRemote implements HelpBubbleHandlerFactoryInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<HelpBubbleHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<HelpBubbleHandlerFactoryPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|HelpBubbleHandlerFactoryPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          HelpBubbleHandlerFactoryPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  createHelpBubbleHandler(
      client: HelpBubbleClientRemote,
      handler: HelpBubbleHandlerPendingReceiver): void {
    this.proxy.sendMessage(
        0,
        HelpBubbleHandlerFactory_CreateHelpBubbleHandler_ParamsSpec.$,
        null,
        [
          client,
          handler
        ],
        false);
  }
};

/**
 * An object which receives request messages for the HelpBubbleHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class HelpBubbleHandlerFactoryReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    HelpBubbleHandlerFactoryRemote, HelpBubbleHandlerFactoryPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    HelpBubbleHandlerFactoryRemote, HelpBubbleHandlerFactoryPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: HelpBubbleHandlerFactoryInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        HelpBubbleHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        HelpBubbleHandlerFactory_CreateHelpBubbleHandler_ParamsSpec.$,
        null,
        impl.createHelpBubbleHandler.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class HelpBubbleHandlerFactory {
  static get $interfaceName(): string {
    return "help_bubble.mojom.HelpBubbleHandlerFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): HelpBubbleHandlerFactoryRemote {
    let remote = new HelpBubbleHandlerFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the HelpBubbleHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class HelpBubbleHandlerFactoryCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    HelpBubbleHandlerFactoryRemote, HelpBubbleHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    HelpBubbleHandlerFactoryRemote, HelpBubbleHandlerFactoryPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  createHelpBubbleHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      HelpBubbleHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.createHelpBubbleHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        HelpBubbleHandlerFactory_CreateHelpBubbleHandler_ParamsSpec.$,
        null,
        this.createHelpBubbleHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PdfHelpBubbleHandlerFactoryPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PdfHelpBubbleHandlerFactoryPendingReceiver>;

export class PdfHelpBubbleHandlerFactoryPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PdfHelpBubbleHandlerFactory> {

  handle: mojo.internal.interfaceSupport.Endpoint<PdfHelpBubbleHandlerFactoryPendingReceiver>;
  constructor(handle: MojoHandle|PdfHelpBubbleHandlerFactoryPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'help_bubble.mojom.PdfHelpBubbleHandlerFactory',
        scope);
  }
}

export interface PdfHelpBubbleHandlerFactoryInterface {
  createHelpBubbleHandler(client: HelpBubbleClientRemote, handler: HelpBubbleHandlerPendingReceiver): void;
}

export class PdfHelpBubbleHandlerFactoryRemote implements PdfHelpBubbleHandlerFactoryInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PdfHelpBubbleHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PdfHelpBubbleHandlerFactoryPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PdfHelpBubbleHandlerFactoryPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PdfHelpBubbleHandlerFactoryPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  createHelpBubbleHandler(
      client: HelpBubbleClientRemote,
      handler: HelpBubbleHandlerPendingReceiver): void {
    this.proxy.sendMessage(
        0,
        PdfHelpBubbleHandlerFactory_CreateHelpBubbleHandler_ParamsSpec.$,
        null,
        [
          client,
          handler
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PdfHelpBubbleHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PdfHelpBubbleHandlerFactoryReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PdfHelpBubbleHandlerFactoryRemote, PdfHelpBubbleHandlerFactoryPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PdfHelpBubbleHandlerFactoryRemote, PdfHelpBubbleHandlerFactoryPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PdfHelpBubbleHandlerFactoryInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PdfHelpBubbleHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PdfHelpBubbleHandlerFactory_CreateHelpBubbleHandler_ParamsSpec.$,
        null,
        impl.createHelpBubbleHandler.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PdfHelpBubbleHandlerFactory {
  static get $interfaceName(): string {
    return "help_bubble.mojom.PdfHelpBubbleHandlerFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PdfHelpBubbleHandlerFactoryRemote {
    let remote = new PdfHelpBubbleHandlerFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PdfHelpBubbleHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PdfHelpBubbleHandlerFactoryCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PdfHelpBubbleHandlerFactoryRemote, PdfHelpBubbleHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PdfHelpBubbleHandlerFactoryRemote, PdfHelpBubbleHandlerFactoryPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  createHelpBubbleHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PdfHelpBubbleHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.createHelpBubbleHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PdfHelpBubbleHandlerFactory_CreateHelpBubbleHandler_ParamsSpec.$,
        null,
        this.createHelpBubbleHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type HelpBubbleHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<HelpBubbleHandlerPendingReceiver>;

export class HelpBubbleHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<HelpBubbleHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<HelpBubbleHandlerPendingReceiver>;
  constructor(handle: MojoHandle|HelpBubbleHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'help_bubble.mojom.HelpBubbleHandler',
        scope);
  }
}

export interface HelpBubbleHandlerInterface {
  bindTrackedElementHandler(handler: trackedElement_mojom_TrackedElementHandlerPendingReceiver): void;
  helpBubbleButtonPressed(nativeIdentifier: string, buttonIndex: number): void;
  helpBubbleClosed(nativeIdentifier: string, reason: HelpBubbleClosedReason): void;
}

export class HelpBubbleHandlerRemote implements HelpBubbleHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<HelpBubbleHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<HelpBubbleHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|HelpBubbleHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          HelpBubbleHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  bindTrackedElementHandler(
      handler: trackedElement_mojom_TrackedElementHandlerPendingReceiver): void {
    this.proxy.sendMessage(
        0,
        HelpBubbleHandler_BindTrackedElementHandler_ParamsSpec.$,
        null,
        [
          handler
        ],
        false);
  }

  helpBubbleButtonPressed(
      nativeIdentifier: string,
      buttonIndex: number): void {
    this.proxy.sendMessage(
        1,
        HelpBubbleHandler_HelpBubbleButtonPressed_ParamsSpec.$,
        null,
        [
          nativeIdentifier,
          buttonIndex
        ],
        false);
  }

  helpBubbleClosed(
      nativeIdentifier: string,
      reason: HelpBubbleClosedReason): void {
    this.proxy.sendMessage(
        2,
        HelpBubbleHandler_HelpBubbleClosed_ParamsSpec.$,
        null,
        [
          nativeIdentifier,
          reason
        ],
        false);
  }
};

/**
 * An object which receives request messages for the HelpBubbleHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class HelpBubbleHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    HelpBubbleHandlerRemote, HelpBubbleHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    HelpBubbleHandlerRemote, HelpBubbleHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: HelpBubbleHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        HelpBubbleHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        HelpBubbleHandler_BindTrackedElementHandler_ParamsSpec.$,
        null,
        impl.bindTrackedElementHandler.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        HelpBubbleHandler_HelpBubbleButtonPressed_ParamsSpec.$,
        null,
        impl.helpBubbleButtonPressed.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        HelpBubbleHandler_HelpBubbleClosed_ParamsSpec.$,
        null,
        impl.helpBubbleClosed.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class HelpBubbleHandler {
  static get $interfaceName(): string {
    return "help_bubble.mojom.HelpBubbleHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): HelpBubbleHandlerRemote {
    let remote = new HelpBubbleHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the HelpBubbleHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class HelpBubbleHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    HelpBubbleHandlerRemote, HelpBubbleHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    HelpBubbleHandlerRemote, HelpBubbleHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  bindTrackedElementHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  helpBubbleButtonPressed: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  helpBubbleClosed: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      HelpBubbleHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.bindTrackedElementHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        HelpBubbleHandler_BindTrackedElementHandler_ParamsSpec.$,
        null,
        this.bindTrackedElementHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    this.helpBubbleButtonPressed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        HelpBubbleHandler_HelpBubbleButtonPressed_ParamsSpec.$,
        null,
        this.helpBubbleButtonPressed.createReceiverHandler(false /* expectsResponse */),
        false);
    this.helpBubbleClosed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        HelpBubbleHandler_HelpBubbleClosed_ParamsSpec.$,
        null,
        this.helpBubbleClosed.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type HelpBubbleClientPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<HelpBubbleClientPendingReceiver>;

export class HelpBubbleClientPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<HelpBubbleClient> {

  handle: mojo.internal.interfaceSupport.Endpoint<HelpBubbleClientPendingReceiver>;
  constructor(handle: MojoHandle|HelpBubbleClientPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'help_bubble.mojom.HelpBubbleClient',
        scope);
  }
}

export interface HelpBubbleClientInterface {
  showHelpBubble(params: HelpBubbleParams): void;
  toggleFocusForAccessibility(nativeIdentifier: string): void;
  hideHelpBubble(nativeIdentifier: string): void;
  externalHelpBubbleUpdated(nativeIdentifier: string, shown: boolean): void;
}

export class HelpBubbleClientRemote implements HelpBubbleClientInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<HelpBubbleClientPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<HelpBubbleClientPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|HelpBubbleClientPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          HelpBubbleClientPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  showHelpBubble(
      params: HelpBubbleParams): void {
    this.proxy.sendMessage(
        0,
        HelpBubbleClient_ShowHelpBubble_ParamsSpec.$,
        null,
        [
          params
        ],
        false);
  }

  toggleFocusForAccessibility(
      nativeIdentifier: string): void {
    this.proxy.sendMessage(
        1,
        HelpBubbleClient_ToggleFocusForAccessibility_ParamsSpec.$,
        null,
        [
          nativeIdentifier
        ],
        false);
  }

  hideHelpBubble(
      nativeIdentifier: string): void {
    this.proxy.sendMessage(
        2,
        HelpBubbleClient_HideHelpBubble_ParamsSpec.$,
        null,
        [
          nativeIdentifier
        ],
        false);
  }

  externalHelpBubbleUpdated(
      nativeIdentifier: string,
      shown: boolean): void {
    this.proxy.sendMessage(
        3,
        HelpBubbleClient_ExternalHelpBubbleUpdated_ParamsSpec.$,
        null,
        [
          nativeIdentifier,
          shown
        ],
        false);
  }
};

/**
 * An object which receives request messages for the HelpBubbleClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class HelpBubbleClientReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    HelpBubbleClientRemote, HelpBubbleClientPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    HelpBubbleClientRemote, HelpBubbleClientPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: HelpBubbleClientInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        HelpBubbleClientRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        HelpBubbleClient_ShowHelpBubble_ParamsSpec.$,
        null,
        impl.showHelpBubble.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        HelpBubbleClient_ToggleFocusForAccessibility_ParamsSpec.$,
        null,
        impl.toggleFocusForAccessibility.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        HelpBubbleClient_HideHelpBubble_ParamsSpec.$,
        null,
        impl.hideHelpBubble.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        HelpBubbleClient_ExternalHelpBubbleUpdated_ParamsSpec.$,
        null,
        impl.externalHelpBubbleUpdated.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class HelpBubbleClient {
  static get $interfaceName(): string {
    return "help_bubble.mojom.HelpBubbleClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): HelpBubbleClientRemote {
    let remote = new HelpBubbleClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the HelpBubbleClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class HelpBubbleClientCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    HelpBubbleClientRemote, HelpBubbleClientPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    HelpBubbleClientRemote, HelpBubbleClientPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  showHelpBubble: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  toggleFocusForAccessibility: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  hideHelpBubble: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  externalHelpBubbleUpdated: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      HelpBubbleClientRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.showHelpBubble =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        HelpBubbleClient_ShowHelpBubble_ParamsSpec.$,
        null,
        this.showHelpBubble.createReceiverHandler(false /* expectsResponse */),
        false);
    this.toggleFocusForAccessibility =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        HelpBubbleClient_ToggleFocusForAccessibility_ParamsSpec.$,
        null,
        this.toggleFocusForAccessibility.createReceiverHandler(false /* expectsResponse */),
        false);
    this.hideHelpBubble =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        HelpBubbleClient_HideHelpBubble_ParamsSpec.$,
        null,
        this.hideHelpBubble.createReceiverHandler(false /* expectsResponse */),
        false);
    this.externalHelpBubbleUpdated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        HelpBubbleClient_ExternalHelpBubbleUpdated_ParamsSpec.$,
        null,
        this.externalHelpBubbleUpdated.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const HelpBubbleButtonParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ProgressSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const HelpBubbleParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const HelpBubbleHandlerFactory_CreateHelpBubbleHandler_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PdfHelpBubbleHandlerFactory_CreateHelpBubbleHandler_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const HelpBubbleHandler_BindTrackedElementHandler_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const HelpBubbleHandler_HelpBubbleButtonPressed_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const HelpBubbleHandler_HelpBubbleClosed_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const HelpBubbleClient_ShowHelpBubble_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const HelpBubbleClient_ToggleFocusForAccessibility_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const HelpBubbleClient_HideHelpBubble_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const HelpBubbleClient_ExternalHelpBubbleUpdated_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface HelpBubbleButtonParamsMojoType {
  text: string;
  isDefault: boolean;
}


export type HelpBubbleButtonParams = HelpBubbleButtonParamsMojoType;
mojo.internal.Struct<HelpBubbleButtonParamsMojoType>(
    HelpBubbleButtonParamsSpec.$,
    'HelpBubbleButtonParams',
    [
      mojo.internal.StructField<HelpBubbleButtonParamsMojoType, string>(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<HelpBubbleButtonParamsMojoType, boolean>(
        'isDefault', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface ProgressMojoType {
  current: number;
  total: number;
}


export type Progress = ProgressMojoType;
mojo.internal.Struct<ProgressMojoType>(
    ProgressSpec.$,
    'Progress',
    [
      mojo.internal.StructField<ProgressMojoType, number>(
        'current', 0,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ProgressMojoType, number>(
        'total', 1,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface HelpBubbleParamsMojoType {
  nativeIdentifier: string;
  position: HelpBubbleArrowPosition;
  focusOnShowHint: (boolean | null);
  titleText: (string | null);
  bodyText: string;
  closeButtonAltText: string;
  bodyIconName: (string | null);
  bodyIconAltText: string;
  progress: (Progress | null);
  buttons: HelpBubbleButtonParams[];
  timeout: (mojoBase_mojom_TimeDelta | null);
}


export type HelpBubbleParams = HelpBubbleParamsMojoType;
mojo.internal.Struct<HelpBubbleParamsMojoType>(
    HelpBubbleParamsSpec.$,
    'HelpBubbleParams',
    [
      mojo.internal.StructField<HelpBubbleParamsMojoType, string>(
        'nativeIdentifier', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<HelpBubbleParamsMojoType, HelpBubbleArrowPosition>(
        'position', 8,
        0,
        HelpBubbleArrowPositionSpec.$,
        HelpBubbleArrowPosition.TOP_CENTER,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<HelpBubbleParamsMojoType, string>(
        'titleText', 16,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<HelpBubbleParamsMojoType, string>(
        'bodyText', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<HelpBubbleParamsMojoType, string>(
        'closeButtonAltText', 32,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<HelpBubbleParamsMojoType, string>(
        'bodyIconName', 40,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<HelpBubbleParamsMojoType, string>(
        'bodyIconAltText', 48,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<HelpBubbleParamsMojoType, Progress>(
        'progress', 56,
        0,
        ProgressSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<HelpBubbleParamsMojoType, HelpBubbleButtonParams[]>(
        'buttons', 64,
        0,
        mojo.internal.Array(HelpBubbleButtonParamsSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<HelpBubbleParamsMojoType, boolean>(
        'focus_on_show_hint_$flag', 12,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "focus_on_show_hint_$value",
          originalFieldName: "focusOnShowHint",
        },
        undefined,
    ),
      mojo.internal.StructField<HelpBubbleParamsMojoType, boolean>(
        'focus_on_show_hint_$value', 12,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "focusOnShowHint",
        },
        undefined,
    ),
      mojo.internal.StructField<HelpBubbleParamsMojoType, mojoBase_mojom_TimeDelta>(
        'timeout', 72,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 88],]);





export interface HelpBubbleHandlerFactory_CreateHelpBubbleHandler_ParamsMojoType {
  client: HelpBubbleClientRemote;
  handler: HelpBubbleHandlerPendingReceiver;
}


export type HelpBubbleHandlerFactory_CreateHelpBubbleHandler_Params = HelpBubbleHandlerFactory_CreateHelpBubbleHandler_ParamsMojoType;
mojo.internal.Struct<HelpBubbleHandlerFactory_CreateHelpBubbleHandler_ParamsMojoType>(
    HelpBubbleHandlerFactory_CreateHelpBubbleHandler_ParamsSpec.$,
    'HelpBubbleHandlerFactory_CreateHelpBubbleHandler_Params',
    [
      mojo.internal.StructField<HelpBubbleHandlerFactory_CreateHelpBubbleHandler_ParamsMojoType, HelpBubbleClientRemote>(
        'client', 0,
        0,
        mojo.internal.InterfaceProxy(HelpBubbleClientRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<HelpBubbleHandlerFactory_CreateHelpBubbleHandler_ParamsMojoType, HelpBubbleHandlerPendingReceiver>(
        'handler', 8,
        0,
        mojo.internal.InterfaceRequest(HelpBubbleHandlerPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PdfHelpBubbleHandlerFactory_CreateHelpBubbleHandler_ParamsMojoType {
  client: HelpBubbleClientRemote;
  handler: HelpBubbleHandlerPendingReceiver;
}


export type PdfHelpBubbleHandlerFactory_CreateHelpBubbleHandler_Params = PdfHelpBubbleHandlerFactory_CreateHelpBubbleHandler_ParamsMojoType;
mojo.internal.Struct<PdfHelpBubbleHandlerFactory_CreateHelpBubbleHandler_ParamsMojoType>(
    PdfHelpBubbleHandlerFactory_CreateHelpBubbleHandler_ParamsSpec.$,
    'PdfHelpBubbleHandlerFactory_CreateHelpBubbleHandler_Params',
    [
      mojo.internal.StructField<PdfHelpBubbleHandlerFactory_CreateHelpBubbleHandler_ParamsMojoType, HelpBubbleClientRemote>(
        'client', 0,
        0,
        mojo.internal.InterfaceProxy(HelpBubbleClientRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PdfHelpBubbleHandlerFactory_CreateHelpBubbleHandler_ParamsMojoType, HelpBubbleHandlerPendingReceiver>(
        'handler', 8,
        0,
        mojo.internal.InterfaceRequest(HelpBubbleHandlerPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface HelpBubbleHandler_BindTrackedElementHandler_ParamsMojoType {
  handler: trackedElement_mojom_TrackedElementHandlerPendingReceiver;
}


export type HelpBubbleHandler_BindTrackedElementHandler_Params = HelpBubbleHandler_BindTrackedElementHandler_ParamsMojoType;
mojo.internal.Struct<HelpBubbleHandler_BindTrackedElementHandler_ParamsMojoType>(
    HelpBubbleHandler_BindTrackedElementHandler_ParamsSpec.$,
    'HelpBubbleHandler_BindTrackedElementHandler_Params',
    [
      mojo.internal.StructField<HelpBubbleHandler_BindTrackedElementHandler_ParamsMojoType, trackedElement_mojom_TrackedElementHandlerPendingReceiver>(
        'handler', 0,
        0,
        mojo.internal.InterfaceRequest(trackedElement_mojom_TrackedElementHandlerPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface HelpBubbleHandler_HelpBubbleButtonPressed_ParamsMojoType {
  nativeIdentifier: string;
  buttonIndex: number;
}


export type HelpBubbleHandler_HelpBubbleButtonPressed_Params = HelpBubbleHandler_HelpBubbleButtonPressed_ParamsMojoType;
mojo.internal.Struct<HelpBubbleHandler_HelpBubbleButtonPressed_ParamsMojoType>(
    HelpBubbleHandler_HelpBubbleButtonPressed_ParamsSpec.$,
    'HelpBubbleHandler_HelpBubbleButtonPressed_Params',
    [
      mojo.internal.StructField<HelpBubbleHandler_HelpBubbleButtonPressed_ParamsMojoType, string>(
        'nativeIdentifier', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<HelpBubbleHandler_HelpBubbleButtonPressed_ParamsMojoType, number>(
        'buttonIndex', 8,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface HelpBubbleHandler_HelpBubbleClosed_ParamsMojoType {
  nativeIdentifier: string;
  reason: HelpBubbleClosedReason;
}


export type HelpBubbleHandler_HelpBubbleClosed_Params = HelpBubbleHandler_HelpBubbleClosed_ParamsMojoType;
mojo.internal.Struct<HelpBubbleHandler_HelpBubbleClosed_ParamsMojoType>(
    HelpBubbleHandler_HelpBubbleClosed_ParamsSpec.$,
    'HelpBubbleHandler_HelpBubbleClosed_Params',
    [
      mojo.internal.StructField<HelpBubbleHandler_HelpBubbleClosed_ParamsMojoType, string>(
        'nativeIdentifier', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<HelpBubbleHandler_HelpBubbleClosed_ParamsMojoType, HelpBubbleClosedReason>(
        'reason', 8,
        0,
        HelpBubbleClosedReasonSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface HelpBubbleClient_ShowHelpBubble_ParamsMojoType {
  params: HelpBubbleParams;
}


export type HelpBubbleClient_ShowHelpBubble_Params = HelpBubbleClient_ShowHelpBubble_ParamsMojoType;
mojo.internal.Struct<HelpBubbleClient_ShowHelpBubble_ParamsMojoType>(
    HelpBubbleClient_ShowHelpBubble_ParamsSpec.$,
    'HelpBubbleClient_ShowHelpBubble_Params',
    [
      mojo.internal.StructField<HelpBubbleClient_ShowHelpBubble_ParamsMojoType, HelpBubbleParams>(
        'params', 0,
        0,
        HelpBubbleParamsSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface HelpBubbleClient_ToggleFocusForAccessibility_ParamsMojoType {
  nativeIdentifier: string;
}


export type HelpBubbleClient_ToggleFocusForAccessibility_Params = HelpBubbleClient_ToggleFocusForAccessibility_ParamsMojoType;
mojo.internal.Struct<HelpBubbleClient_ToggleFocusForAccessibility_ParamsMojoType>(
    HelpBubbleClient_ToggleFocusForAccessibility_ParamsSpec.$,
    'HelpBubbleClient_ToggleFocusForAccessibility_Params',
    [
      mojo.internal.StructField<HelpBubbleClient_ToggleFocusForAccessibility_ParamsMojoType, string>(
        'nativeIdentifier', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface HelpBubbleClient_HideHelpBubble_ParamsMojoType {
  nativeIdentifier: string;
}


export type HelpBubbleClient_HideHelpBubble_Params = HelpBubbleClient_HideHelpBubble_ParamsMojoType;
mojo.internal.Struct<HelpBubbleClient_HideHelpBubble_ParamsMojoType>(
    HelpBubbleClient_HideHelpBubble_ParamsSpec.$,
    'HelpBubbleClient_HideHelpBubble_Params',
    [
      mojo.internal.StructField<HelpBubbleClient_HideHelpBubble_ParamsMojoType, string>(
        'nativeIdentifier', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface HelpBubbleClient_ExternalHelpBubbleUpdated_ParamsMojoType {
  nativeIdentifier: string;
  shown: boolean;
}


export type HelpBubbleClient_ExternalHelpBubbleUpdated_Params = HelpBubbleClient_ExternalHelpBubbleUpdated_ParamsMojoType;
mojo.internal.Struct<HelpBubbleClient_ExternalHelpBubbleUpdated_ParamsMojoType>(
    HelpBubbleClient_ExternalHelpBubbleUpdated_ParamsSpec.$,
    'HelpBubbleClient_ExternalHelpBubbleUpdated_Params',
    [
      mojo.internal.StructField<HelpBubbleClient_ExternalHelpBubbleUpdated_ParamsMojoType, string>(
        'nativeIdentifier', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<HelpBubbleClient_ExternalHelpBubbleUpdated_ParamsMojoType, boolean>(
        'shown', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);



