// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"./file_thumbnail.js";import{CrLitElement}from"//resources/lit/v3_0/lit.rollup.js";import{getCss}from"./file_carousel.css.js";import{getHtml}from"./file_carousel.html.js";const DEBOUNCE_TIMEOUT_MS=20;const CAROUSEL_HEIGHT_PADDING=18;function debounce(context,func,delay){let timeout;return function(...args){clearTimeout(timeout);timeout=setTimeout((()=>func.apply(context,args)),delay)}}export class ComposeboxFileCarouselElement extends CrLitElement{static get is(){return"cr-composebox-file-carousel"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{files:{type:Array}}}#files_accessor_storage=[];get files(){return this.#files_accessor_storage}set files(value){this.#files_accessor_storage=value}resizeObserver_=null;getThumbnailElementByUuid(uuid){const thumbnails=this.shadowRoot.querySelectorAll("cr-composebox-file-thumbnail");for(const thumbnail of thumbnails){if(thumbnail.file.uuid===uuid){return thumbnail}}return null}connectedCallback(){super.connectedCallback();this.resizeObserver_=new ResizeObserver(debounce(this,(()=>{const height=this.clientHeight?this.clientHeight+CAROUSEL_HEIGHT_PADDING:0;this.dispatchEvent(new CustomEvent("carousel-resize",{bubbles:true,composed:true,detail:{height:height}}))}),DEBOUNCE_TIMEOUT_MS));this.resizeObserver_.observe(this)}disconnectedCallback(){super.disconnectedCallback();if(this.resizeObserver_){this.resizeObserver_.disconnect();this.resizeObserver_=null}}}customElements.define(ComposeboxFileCarouselElement.is,ComposeboxFileCarouselElement);