// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"./icons.html.js";import"./composebox_tab_favicon.js";import"//resources/cr_elements/icons.html.js";import"//resources/cr_elements/cr_action_menu/cr_action_menu.js";import"//resources/cr_elements/cr_button/cr_button.js";import"//resources/cr_elements/cr_icon_button/cr_icon_button.js";import"//resources/cr_elements/cr_icon/cr_icon.js";import{AnchorAlignment}from"//resources/cr_elements/cr_action_menu/cr_action_menu.js";import{I18nMixinLit}from"//resources/cr_elements/i18n_mixin_lit.js";import{assert}from"//resources/js/assert.js";import{loadTimeData}from"//resources/js/load_time_data.js";import{CrLitElement}from"//resources/lit/v3_0/lit.rollup.js";import{recordContextAdditionMethod,TabUploadOrigin}from"./common.js";import{getCss}from"./context_menu_entrypoint.css.js";import{getHtml}from"./context_menu_entrypoint.html.js";const MENU_WIDTH_PX=190;const TALL_BOTTOM_CONTEXT_LAYOUT_MODE="TallBottomContext";export var GlifAnimationState;(function(GlifAnimationState){GlifAnimationState["INELIGIBLE"]="ineligible";GlifAnimationState["SPINNER_ONLY"]="spinner-only";GlifAnimationState["STARTED"]="started";GlifAnimationState["FINISHED"]="finished"})(GlifAnimationState||(GlifAnimationState={}));const ContextMenuEntrypointElementBase=I18nMixinLit(CrLitElement);export class ContextMenuEntrypointElement extends ContextMenuEntrypointElementBase{static get is(){return"cr-composebox-context-menu-entrypoint"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{inputsDisabled:{type:Boolean},fileNum:{type:Number},showContextMenuDescription:{type:Boolean},inCreateImageMode:{reflect:true,type:Boolean},hasImageFiles:{reflect:true,type:Boolean},hideEntrypointButton:{type:Boolean},disabledTabIds:{type:Object},tabSuggestions:{type:Array},entrypointName:{type:String},searchboxLayoutMode:{type:String},glifAnimationState:{type:String,reflect:true},enableMultiTabSelection_:{reflect:true,type:Boolean},tabPreviewUrl_:{type:String},tabPreviewsEnabled_:{type:Boolean},showDeepSearch_:{reflect:true,type:Boolean},showCreateImage_:{reflect:true,type:Boolean},pdfUploadEnabled_:{type:Boolean}}}#inputsDisabled_accessor_storage=false;get inputsDisabled(){return this.#inputsDisabled_accessor_storage}set inputsDisabled(value){this.#inputsDisabled_accessor_storage=value}#fileNum_accessor_storage=0;get fileNum(){return this.#fileNum_accessor_storage}set fileNum(value){this.#fileNum_accessor_storage=value}#showContextMenuDescription_accessor_storage=false;get showContextMenuDescription(){return this.#showContextMenuDescription_accessor_storage}set showContextMenuDescription(value){this.#showContextMenuDescription_accessor_storage=value}#inCreateImageMode_accessor_storage=false;get inCreateImageMode(){return this.#inCreateImageMode_accessor_storage}set inCreateImageMode(value){this.#inCreateImageMode_accessor_storage=value}#hasImageFiles_accessor_storage=false;get hasImageFiles(){return this.#hasImageFiles_accessor_storage}set hasImageFiles(value){this.#hasImageFiles_accessor_storage=value}#hideEntrypointButton_accessor_storage=false;get hideEntrypointButton(){return this.#hideEntrypointButton_accessor_storage}set hideEntrypointButton(value){this.#hideEntrypointButton_accessor_storage=value}#disabledTabIds_accessor_storage=new Map;get disabledTabIds(){return this.#disabledTabIds_accessor_storage}set disabledTabIds(value){this.#disabledTabIds_accessor_storage=value}#tabSuggestions_accessor_storage=[];get tabSuggestions(){return this.#tabSuggestions_accessor_storage}set tabSuggestions(value){this.#tabSuggestions_accessor_storage=value}#entrypointName_accessor_storage="";get entrypointName(){return this.#entrypointName_accessor_storage}set entrypointName(value){this.#entrypointName_accessor_storage=value}#searchboxLayoutMode_accessor_storage="";get searchboxLayoutMode(){return this.#searchboxLayoutMode_accessor_storage}set searchboxLayoutMode(value){this.#searchboxLayoutMode_accessor_storage=value}#glifAnimationState_accessor_storage=GlifAnimationState.INELIGIBLE;get glifAnimationState(){return this.#glifAnimationState_accessor_storage}set glifAnimationState(value){this.#glifAnimationState_accessor_storage=value}#enableMultiTabSelection__accessor_storage=loadTimeData.getBoolean("composeboxContextMenuEnableMultiTabSelection");get enableMultiTabSelection_(){return this.#enableMultiTabSelection__accessor_storage}set enableMultiTabSelection_(value){this.#enableMultiTabSelection__accessor_storage=value}#tabPreviewUrl__accessor_storage="";get tabPreviewUrl_(){return this.#tabPreviewUrl__accessor_storage}set tabPreviewUrl_(value){this.#tabPreviewUrl__accessor_storage=value}#tabPreviewsEnabled__accessor_storage=loadTimeData.getBoolean("composeboxShowContextMenuTabPreviews");get tabPreviewsEnabled_(){return this.#tabPreviewsEnabled__accessor_storage}set tabPreviewsEnabled_(value){this.#tabPreviewsEnabled__accessor_storage=value}#showDeepSearch__accessor_storage=loadTimeData.getBoolean("composeboxShowDeepSearchButton");get showDeepSearch_(){return this.#showDeepSearch__accessor_storage}set showDeepSearch_(value){this.#showDeepSearch__accessor_storage=value}#showCreateImage__accessor_storage=loadTimeData.getBoolean("composeboxShowCreateImageButton");get showCreateImage_(){return this.#showCreateImage__accessor_storage}set showCreateImage_(value){this.#showCreateImage__accessor_storage=value}#pdfUploadEnabled__accessor_storage=loadTimeData.getBoolean("composeboxShowPdfUpload");get pdfUploadEnabled_(){return this.#pdfUploadEnabled__accessor_storage}set pdfUploadEnabled_(value){this.#pdfUploadEnabled__accessor_storage=value}maxFileCount_=loadTimeData.getInteger("composeboxFileMaxCount");metricsSource_=loadTimeData.getString("composeboxSource");constructor(){super()}openMenuForMultiSelection(){if(this.enableMultiTabSelection_&&this.searchboxLayoutMode!==TALL_BOTTOM_CONTEXT_LAYOUT_MODE){this.updateComplete.then(this.showMenuAtEntrypoint_.bind(this))}}closeMenu(){this.$.menu.close()}get imageUploadDisabled_(){return this.fileNum>=this.maxFileCount_||this.inCreateImageMode&&this.hasImageFiles}get fileUploadDisabled_(){return this.inCreateImageMode||this.fileNum>=this.maxFileCount_}get deepSearchDisabled_(){return this.inCreateImageMode||this.fileNum===1||this.fileNum>1}get createImageDisabled_(){return this.inCreateImageMode||this.fileNum>1||this.fileNum===1&&!this.hasImageFiles}isTabDisabled_(tab){const noNewContextAllowed=this.inCreateImageMode||this.fileNum>=this.maxFileCount_;const isTabInContext=this.disabledTabIds.has(tab.tabId);if(this.enableMultiTabSelection_){return noNewContextAllowed&&!isTabInContext}return noNewContextAllowed||isTabInContext}onEntrypointClick_(e){e.stopPropagation();const metricName="ContextualSearch.ContextMenuEntry.Clicked."+this.metricsSource_;chrome.metricsPrivate.recordBoolean(metricName,true);const entrypoint=this.shadowRoot.querySelector("#entrypoint");assert(entrypoint);this.fire("context-menu-entrypoint-click",{x:entrypoint.getBoundingClientRect().left,y:entrypoint.getBoundingClientRect().bottom});if(this.entrypointName!=="Omnibox"){this.showMenuAtEntrypoint_()}}onTabClick_(e){e.stopPropagation();const tabElement=e.currentTarget;const tabInfo=this.tabSuggestions[Number(tabElement.dataset["index"])];assert(tabInfo);if(this.enableMultiTabSelection_&&this.disabledTabIds.has(tabInfo.tabId)){this.deleteTabContext_(this.disabledTabIds.get(tabInfo.tabId));return}this.addTabContext_(tabInfo);recordContextAdditionMethod(0,this.metricsSource_)}deleteTabContext_(uuid){this.fire("delete-tab-context",{uuid:uuid});if(this.searchboxLayoutMode===TALL_BOTTOM_CONTEXT_LAYOUT_MODE){this.$.menu.close()}}addTabContext_(tabInfo){this.fire("add-tab-context",{id:tabInfo.tabId,title:tabInfo.title,url:tabInfo.url,delayUpload:false,origin:TabUploadOrigin.CONTEXT_MENU});if(!this.enableMultiTabSelection_||this.entrypointName==="Realbox"||this.searchboxLayoutMode===TALL_BOTTOM_CONTEXT_LAYOUT_MODE){this.$.menu.close()}}onTabPointerenter_(e){if(!this.tabPreviewsEnabled_){return}const tabElement=e.currentTarget;const tabInfo=this.tabSuggestions[Number(tabElement.dataset["index"])];assert(tabInfo);this.tabPreviewUrl_="";this.fire("get-tab-preview",{tabId:tabInfo.tabId,onPreviewFetched:previewDataUrl=>{this.tabPreviewUrl_=previewDataUrl}})}shouldShowTabPreview_(){return this.tabPreviewsEnabled_&&this.tabPreviewUrl_!==""}openImageUpload_(){this.fire("open-image-upload");this.$.menu.close()}openFileUpload_(){this.fire("open-file-upload");this.$.menu.close()}onDeepSearchClick_(){this.fire("deep-search-click");this.$.menu.close()}onCreateImageClick_(){this.fire("create-image-click");this.$.menu.close()}onAnimationEnd_(e,animationName){if(e.animationName===animationName){this.glifAnimationState=GlifAnimationState.FINISHED}}onMenuClose_(){const entrypoint=this.shadowRoot.querySelector("#entrypoint");assert(entrypoint);entrypoint.classList.remove("menu-open")}showMenuAtEntrypoint_(){const entrypoint=this.shadowRoot.querySelector("#entrypoint");assert(entrypoint);entrypoint?.classList.add("menu-open");this.$.menu.showAt(entrypoint,{top:entrypoint.getBoundingClientRect().bottom,width:MENU_WIDTH_PX,anchorAlignmentX:AnchorAlignment["AFTER_START"]})}}customElements.define(ContextMenuEntrypointElement.is,ContextMenuEntrypointElement);