// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/cr_elements/cr_icon_button/cr_icon_button.js";import{loadTimeData}from"//resources/js/load_time_data.js";import{CrLitElement}from"//resources/lit/v3_0/lit.rollup.js";import{getCss}from"./composebox_match.css.js";import{getHtml}from"./composebox_match.html.js";import{ComposeboxProxyImpl,createAutocompleteMatch}from"./composebox_proxy.js";const LINE_HEIGHT_PX=24;const MAX_DEEP_SEARCH_LINES=2;export class ComposeboxMatchElement extends CrLitElement{static get is(){return"cr-composebox-match"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{match:{type:Object},matchIndex:{type:Number},inDeepSearchMode:{type:Boolean},removeButtonTitle_:{type:String}}}#match_accessor_storage=createAutocompleteMatch();get match(){return this.#match_accessor_storage}set match(value){this.#match_accessor_storage=value}#matchIndex_accessor_storage=-1;get matchIndex(){return this.#matchIndex_accessor_storage}set matchIndex(value){this.#matchIndex_accessor_storage=value}#inDeepSearchMode_accessor_storage=false;get inDeepSearchMode(){return this.#inDeepSearchMode_accessor_storage}set inDeepSearchMode(value){this.#inDeepSearchMode_accessor_storage=value}searchboxHandler_;#removeButtonTitle__accessor_storage=loadTimeData.getString("removeSuggestion");get removeButtonTitle_(){return this.#removeButtonTitle__accessor_storage}set removeButtonTitle_(value){this.#removeButtonTitle__accessor_storage=value}resizeObserver_=null;constructor(){super();this.searchboxHandler_=ComposeboxProxyImpl.getInstance().searchboxHandler}connectedCallback(){super.connectedCallback();this.addEventListener("click",(event=>this.onMouseClick_(event)));this.addEventListener("focusin",(()=>this.onMatchFocusin_()));this.addEventListener("mousedown",(event=>event.preventDefault()));this.resizeObserver_=new ResizeObserver((()=>this.clampDeepSearchContents_()));this.resizeObserver_.observe(this.$.textContainer)}disconnectedCallback(){super.disconnectedCallback();if(this.resizeObserver_){this.resizeObserver_.unobserve(this.$.textContainer)}}clampDeepSearchContents_(){if(!this.inDeepSearchMode){return}const textContainer=this.$.textContainer;textContainer.textContent=this.match.contents;const maxHeight=LINE_HEIGHT_PX*MAX_DEEP_SEARCH_LINES;if(textContainer.scrollHeight<=maxHeight){return}const words=this.match.contents.split(" ");while(words.length>0){words.pop();textContainer.textContent=words.join(" ")+"...";if(textContainer.scrollHeight<=maxHeight){break}}}computeContents_(){return this.match.contents}computeRemoveButtonAriaLabel_(){return this.match.removeButtonA11yLabel}iconPath_(){return this.match.iconPath||""}onMatchFocusin_(){this.fire("match-focusin",{index:this.matchIndex})}onMouseClick_(e){if(e.button>1){return}e.preventDefault();this.searchboxHandler_.openAutocompleteMatch(this.matchIndex,this.match.destinationUrl,true,e.button||0,e.altKey,e.ctrlKey,e.metaKey,e.shiftKey);this.fire("match-click")}onRemoveButtonClick_(e){if(e.button!==0){return}e.preventDefault();e.stopPropagation();this.searchboxHandler_.deleteAutocompleteMatch(this.matchIndex,this.match.destinationUrl)}onRemoveButtonMouseDown_(e){e.preventDefault()}}customElements.define(ComposeboxMatchElement.is,ComposeboxMatchElement);