// ui/webui/resources/cr_components/app_management/app_management.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  UrlSpec as url_mojom_UrlSpec,
  Url as url_mojom_Url
} from '//resources/mojo/url/mojom/url.mojom-webui.js';





export const AppTypeSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum AppType {

  MIN_VALUE = 0,
  MAX_VALUE = 10,
  kUnknown = 0,
  kArc = 1,
  kCrostini = 2,
  kChromeApp = 3,
  kWeb = 4,
  kPluginVm = 5,
  kRemote = 6,
  kBorealis = 7,
  kSystemWeb = 8,
  kExtension = 9,
  kBruschetta = 10,
}

export const PermissionTypeSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum PermissionType {

  MIN_VALUE = 0,
  MAX_VALUE = 8,
  kUnknown = 0,
  kCamera = 1,
  kLocation = 2,
  kMicrophone = 3,
  kNotifications = 4,
  kContacts = 5,
  kStorage = 6,
  kPrinting = 7,
  kFileHandling = 8,
}

export const TriStateSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum TriState {

  MIN_VALUE = 0,
  MAX_VALUE = 2,
  kAllow = 0,
  kBlock = 1,
  kAsk = 2,
}

export const InstallReasonSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum InstallReason {

  MIN_VALUE = 0,
  MAX_VALUE = 9,
  kUnknown = 0,
  kSystem = 1,
  kPolicy = 2,
  kOem = 3,
  kDefault = 4,
  kSync = 5,
  kUser = 6,
  kSubApp = 7,
  kKiosk = 8,
  kCommandLine = 9,
}

export const InstallSourceSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum InstallSource {

  MIN_VALUE = 0,
  MAX_VALUE = 5,
  kUnknown = 0,
  kSystem = 1,
  kSync = 2,
  kPlayStore = 3,
  kChromeWebStore = 4,
  kBrowser = 5,
}

export const WindowModeSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum WindowMode {

  MIN_VALUE = 0,
  MAX_VALUE = 3,
  kUnknown = 0,
  kWindow = 1,
  kBrowser = 2,
  kTabbedWindow = 3,
}

export const RunOnOsLoginModeSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum RunOnOsLoginMode {

  MIN_VALUE = 0,
  MAX_VALUE = 2,
  kUnknown = 0,
  kNotRun = 1,
  kWindowed = 2,
}



export type PageHandlerFactoryPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerFactoryPendingReceiver>;

export class PageHandlerFactoryPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandlerFactory> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerFactoryPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerFactoryPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'app_management.mojom.PageHandlerFactory',
        scope);
  }
}

export interface PageHandlerFactoryInterface {
  createPageHandler(page: PageRemote, handler: PageHandlerPendingReceiver): void;
}

export class PageHandlerFactoryRemote implements PageHandlerFactoryInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerFactoryPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerFactoryPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerFactoryPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  createPageHandler(
      page: PageRemote,
      handler: PageHandlerPendingReceiver): void {
    this.proxy.sendMessage(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        [
          page,
          handler
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerFactoryReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerFactoryInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        impl.createPageHandler.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandlerFactory {
  static get $interfaceName(): string {
    return "app_management.mojom.PageHandlerFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerFactoryRemote {
    let remote = new PageHandlerFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerFactoryCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  createPageHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.createPageHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        this.createPageHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PageHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;

export class PageHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'app_management.mojom.PageHandler',
        scope);
  }
}

export interface PageHandlerInterface {
  getApps(): Promise<{
        apps: App[], }>;
  getApp(appId: string): Promise<{
        app: (App | null), }>;
  getSubAppToParentMap(): Promise<{
        subAppToParentMap: {[key: string]: string}, }>;
  getExtensionAppPermissionMessages(appId: string): Promise<{
        messages: ExtensionAppPermissionMessage[], }>;
  setPinned(appId: string, pinned: boolean): void;
  setPermission(appId: string, permission: Permission): void;
  setResizeLocked(appId: string, locked: boolean): void;
  uninstall(appId: string): void;
  openNativeSettings(appId: string): void;
  setPreferredApp(appId: string, isPreferredApp: boolean): void;
  getOverlappingPreferredApps(appId: string): Promise<{
        appIds: string[], }>;
  updateAppSize(appId: string): void;
  setWindowMode(appId: string, windowMode: WindowMode): void;
  setRunOnOsLoginMode(appId: string, runOnOsLoginMode: RunOnOsLoginMode): void;
  setFileHandlingEnabled(appId: string, enabled: boolean): void;
  showDefaultAppAssociationsUi(): void;
  openStorePage(appId: string): void;
  setAppLocale(appId: string, localeTag: string): void;
  openSystemNotificationSettings(appId: string): void;
}

export class PageHandlerRemote implements PageHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  getApps(): Promise<{
        apps: App[], }> {
    return this.proxy.sendMessage(
        0,
        PageHandler_GetApps_ParamsSpec.$,
        PageHandler_GetApps_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getApp(
      appId: string): Promise<{
        app: (App | null), }> {
    return this.proxy.sendMessage(
        1,
        PageHandler_GetApp_ParamsSpec.$,
        PageHandler_GetApp_ResponseParamsSpec.$,
        [
          appId
        ],
        false);
  }

  getSubAppToParentMap(): Promise<{
        subAppToParentMap: {[key: string]: string}, }> {
    return this.proxy.sendMessage(
        2,
        PageHandler_GetSubAppToParentMap_ParamsSpec.$,
        PageHandler_GetSubAppToParentMap_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getExtensionAppPermissionMessages(
      appId: string): Promise<{
        messages: ExtensionAppPermissionMessage[], }> {
    return this.proxy.sendMessage(
        3,
        PageHandler_GetExtensionAppPermissionMessages_ParamsSpec.$,
        PageHandler_GetExtensionAppPermissionMessages_ResponseParamsSpec.$,
        [
          appId
        ],
        false);
  }

  setPinned(
      appId: string,
      pinned: boolean): void {
    this.proxy.sendMessage(
        4,
        PageHandler_SetPinned_ParamsSpec.$,
        null,
        [
          appId,
          pinned
        ],
        false);
  }

  setPermission(
      appId: string,
      permission: Permission): void {
    this.proxy.sendMessage(
        5,
        PageHandler_SetPermission_ParamsSpec.$,
        null,
        [
          appId,
          permission
        ],
        false);
  }

  setResizeLocked(
      appId: string,
      locked: boolean): void {
    this.proxy.sendMessage(
        6,
        PageHandler_SetResizeLocked_ParamsSpec.$,
        null,
        [
          appId,
          locked
        ],
        false);
  }

  uninstall(
      appId: string): void {
    this.proxy.sendMessage(
        7,
        PageHandler_Uninstall_ParamsSpec.$,
        null,
        [
          appId
        ],
        false);
  }

  openNativeSettings(
      appId: string): void {
    this.proxy.sendMessage(
        8,
        PageHandler_OpenNativeSettings_ParamsSpec.$,
        null,
        [
          appId
        ],
        false);
  }

  setPreferredApp(
      appId: string,
      isPreferredApp: boolean): void {
    this.proxy.sendMessage(
        9,
        PageHandler_SetPreferredApp_ParamsSpec.$,
        null,
        [
          appId,
          isPreferredApp
        ],
        false);
  }

  getOverlappingPreferredApps(
      appId: string): Promise<{
        appIds: string[], }> {
    return this.proxy.sendMessage(
        10,
        PageHandler_GetOverlappingPreferredApps_ParamsSpec.$,
        PageHandler_GetOverlappingPreferredApps_ResponseParamsSpec.$,
        [
          appId
        ],
        false);
  }

  updateAppSize(
      appId: string): void {
    this.proxy.sendMessage(
        11,
        PageHandler_UpdateAppSize_ParamsSpec.$,
        null,
        [
          appId
        ],
        false);
  }

  setWindowMode(
      appId: string,
      windowMode: WindowMode): void {
    this.proxy.sendMessage(
        12,
        PageHandler_SetWindowMode_ParamsSpec.$,
        null,
        [
          appId,
          windowMode
        ],
        false);
  }

  setRunOnOsLoginMode(
      appId: string,
      runOnOsLoginMode: RunOnOsLoginMode): void {
    this.proxy.sendMessage(
        13,
        PageHandler_SetRunOnOsLoginMode_ParamsSpec.$,
        null,
        [
          appId,
          runOnOsLoginMode
        ],
        false);
  }

  setFileHandlingEnabled(
      appId: string,
      enabled: boolean): void {
    this.proxy.sendMessage(
        14,
        PageHandler_SetFileHandlingEnabled_ParamsSpec.$,
        null,
        [
          appId,
          enabled
        ],
        false);
  }

  showDefaultAppAssociationsUi(): void {
    this.proxy.sendMessage(
        15,
        PageHandler_ShowDefaultAppAssociationsUi_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  openStorePage(
      appId: string): void {
    this.proxy.sendMessage(
        16,
        PageHandler_OpenStorePage_ParamsSpec.$,
        null,
        [
          appId
        ],
        false);
  }

  setAppLocale(
      appId: string,
      localeTag: string): void {
    this.proxy.sendMessage(
        17,
        PageHandler_SetAppLocale_ParamsSpec.$,
        null,
        [
          appId,
          localeTag
        ],
        false);
  }

  openSystemNotificationSettings(
      appId: string): void {
    this.proxy.sendMessage(
        18,
        PageHandler_OpenSystemNotificationSettings_ParamsSpec.$,
        null,
        [
          appId
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandler_GetApps_ParamsSpec.$,
        PageHandler_GetApps_ResponseParamsSpec.$,
        impl.getApps.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PageHandler_GetApp_ParamsSpec.$,
        PageHandler_GetApp_ResponseParamsSpec.$,
        impl.getApp.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        PageHandler_GetSubAppToParentMap_ParamsSpec.$,
        PageHandler_GetSubAppToParentMap_ResponseParamsSpec.$,
        impl.getSubAppToParentMap.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        PageHandler_GetExtensionAppPermissionMessages_ParamsSpec.$,
        PageHandler_GetExtensionAppPermissionMessages_ResponseParamsSpec.$,
        impl.getExtensionAppPermissionMessages.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        PageHandler_SetPinned_ParamsSpec.$,
        null,
        impl.setPinned.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        PageHandler_SetPermission_ParamsSpec.$,
        null,
        impl.setPermission.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        PageHandler_SetResizeLocked_ParamsSpec.$,
        null,
        impl.setResizeLocked.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        PageHandler_Uninstall_ParamsSpec.$,
        null,
        impl.uninstall.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        PageHandler_OpenNativeSettings_ParamsSpec.$,
        null,
        impl.openNativeSettings.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        PageHandler_SetPreferredApp_ParamsSpec.$,
        null,
        impl.setPreferredApp.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        PageHandler_GetOverlappingPreferredApps_ParamsSpec.$,
        PageHandler_GetOverlappingPreferredApps_ResponseParamsSpec.$,
        impl.getOverlappingPreferredApps.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        PageHandler_UpdateAppSize_ParamsSpec.$,
        null,
        impl.updateAppSize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        PageHandler_SetWindowMode_ParamsSpec.$,
        null,
        impl.setWindowMode.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        PageHandler_SetRunOnOsLoginMode_ParamsSpec.$,
        null,
        impl.setRunOnOsLoginMode.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        PageHandler_SetFileHandlingEnabled_ParamsSpec.$,
        null,
        impl.setFileHandlingEnabled.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        PageHandler_ShowDefaultAppAssociationsUi_ParamsSpec.$,
        null,
        impl.showDefaultAppAssociationsUi.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        16,
        PageHandler_OpenStorePage_ParamsSpec.$,
        null,
        impl.openStorePage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        17,
        PageHandler_SetAppLocale_ParamsSpec.$,
        null,
        impl.setAppLocale.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        18,
        PageHandler_OpenSystemNotificationSettings_ParamsSpec.$,
        null,
        impl.openSystemNotificationSettings.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandler {
  static get $interfaceName(): string {
    return "app_management.mojom.PageHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerRemote {
    let remote = new PageHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  getApps: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getApp: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getSubAppToParentMap: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getExtensionAppPermissionMessages: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setPinned: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setPermission: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setResizeLocked: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  uninstall: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  openNativeSettings: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setPreferredApp: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getOverlappingPreferredApps: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  updateAppSize: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setWindowMode: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setRunOnOsLoginMode: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setFileHandlingEnabled: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  showDefaultAppAssociationsUi: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  openStorePage: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setAppLocale: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  openSystemNotificationSettings: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.getApps =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandler_GetApps_ParamsSpec.$,
        PageHandler_GetApps_ResponseParamsSpec.$,
        this.getApps.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getApp =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PageHandler_GetApp_ParamsSpec.$,
        PageHandler_GetApp_ResponseParamsSpec.$,
        this.getApp.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getSubAppToParentMap =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        PageHandler_GetSubAppToParentMap_ParamsSpec.$,
        PageHandler_GetSubAppToParentMap_ResponseParamsSpec.$,
        this.getSubAppToParentMap.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getExtensionAppPermissionMessages =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        PageHandler_GetExtensionAppPermissionMessages_ParamsSpec.$,
        PageHandler_GetExtensionAppPermissionMessages_ResponseParamsSpec.$,
        this.getExtensionAppPermissionMessages.createReceiverHandler(true /* expectsResponse */),
        false);
    this.setPinned =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        PageHandler_SetPinned_ParamsSpec.$,
        null,
        this.setPinned.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setPermission =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        PageHandler_SetPermission_ParamsSpec.$,
        null,
        this.setPermission.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setResizeLocked =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        PageHandler_SetResizeLocked_ParamsSpec.$,
        null,
        this.setResizeLocked.createReceiverHandler(false /* expectsResponse */),
        false);
    this.uninstall =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        PageHandler_Uninstall_ParamsSpec.$,
        null,
        this.uninstall.createReceiverHandler(false /* expectsResponse */),
        false);
    this.openNativeSettings =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        PageHandler_OpenNativeSettings_ParamsSpec.$,
        null,
        this.openNativeSettings.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setPreferredApp =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        PageHandler_SetPreferredApp_ParamsSpec.$,
        null,
        this.setPreferredApp.createReceiverHandler(false /* expectsResponse */),
        false);
    this.getOverlappingPreferredApps =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        PageHandler_GetOverlappingPreferredApps_ParamsSpec.$,
        PageHandler_GetOverlappingPreferredApps_ResponseParamsSpec.$,
        this.getOverlappingPreferredApps.createReceiverHandler(true /* expectsResponse */),
        false);
    this.updateAppSize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        PageHandler_UpdateAppSize_ParamsSpec.$,
        null,
        this.updateAppSize.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setWindowMode =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        PageHandler_SetWindowMode_ParamsSpec.$,
        null,
        this.setWindowMode.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setRunOnOsLoginMode =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        PageHandler_SetRunOnOsLoginMode_ParamsSpec.$,
        null,
        this.setRunOnOsLoginMode.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setFileHandlingEnabled =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        PageHandler_SetFileHandlingEnabled_ParamsSpec.$,
        null,
        this.setFileHandlingEnabled.createReceiverHandler(false /* expectsResponse */),
        false);
    this.showDefaultAppAssociationsUi =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        PageHandler_ShowDefaultAppAssociationsUi_ParamsSpec.$,
        null,
        this.showDefaultAppAssociationsUi.createReceiverHandler(false /* expectsResponse */),
        false);
    this.openStorePage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        16,
        PageHandler_OpenStorePage_ParamsSpec.$,
        null,
        this.openStorePage.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setAppLocale =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        17,
        PageHandler_SetAppLocale_ParamsSpec.$,
        null,
        this.setAppLocale.createReceiverHandler(false /* expectsResponse */),
        false);
    this.openSystemNotificationSettings =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        18,
        PageHandler_OpenSystemNotificationSettings_ParamsSpec.$,
        null,
        this.openSystemNotificationSettings.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PagePendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;

export class PagePendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<Page> {

  handle: mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;
  constructor(handle: MojoHandle|PagePendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'app_management.mojom.Page',
        scope);
  }
}

export interface PageInterface {
  onAppAdded(app: App): void;
  onAppChanged(update: App): void;
  onAppRemoved(appId: string): void;
}

export class PageRemote implements PageInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PagePendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PagePendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PagePendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  onAppAdded(
      app: App): void {
    this.proxy.sendMessage(
        0,
        Page_OnAppAdded_ParamsSpec.$,
        null,
        [
          app
        ],
        false);
  }

  onAppChanged(
      update: App): void {
    this.proxy.sendMessage(
        1,
        Page_OnAppChanged_ParamsSpec.$,
        null,
        [
          update
        ],
        false);
  }

  onAppRemoved(
      appId: string): void {
    this.proxy.sendMessage(
        2,
        Page_OnAppRemoved_ParamsSpec.$,
        null,
        [
          appId
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        Page_OnAppAdded_ParamsSpec.$,
        null,
        impl.onAppAdded.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        Page_OnAppChanged_ParamsSpec.$,
        null,
        impl.onAppChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        Page_OnAppRemoved_ParamsSpec.$,
        null,
        impl.onAppRemoved.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Page {
  static get $interfaceName(): string {
    return "app_management.mojom.Page";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageRemote {
    let remote = new PageRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  onAppAdded: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onAppChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onAppRemoved: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.onAppAdded =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        Page_OnAppAdded_ParamsSpec.$,
        null,
        this.onAppAdded.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onAppChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        Page_OnAppChanged_ParamsSpec.$,
        null,
        this.onAppChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onAppRemoved =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        Page_OnAppRemoved_ParamsSpec.$,
        null,
        this.onAppRemoved.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const PermissionSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const RunOnOsLoginSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LocaleSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const AppSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ExtensionAppPermissionMessageSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const FileHandlingStateSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandlerFactory_CreatePageHandler_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetApps_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetApps_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetApp_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetApp_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetSubAppToParentMap_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetSubAppToParentMap_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetExtensionAppPermissionMessages_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetExtensionAppPermissionMessages_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_SetPinned_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_SetPermission_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_SetResizeLocked_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_Uninstall_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_OpenNativeSettings_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_SetPreferredApp_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetOverlappingPreferredApps_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetOverlappingPreferredApps_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_UpdateAppSize_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_SetWindowMode_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_SetRunOnOsLoginMode_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_SetFileHandlingEnabled_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_ShowDefaultAppAssociationsUi_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_OpenStorePage_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_SetAppLocale_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_OpenSystemNotificationSettings_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_OnAppAdded_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_OnAppChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_OnAppRemoved_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PermissionValueSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface PermissionMojoType {
  permissionType: PermissionType;
  isManaged: boolean;
  value: PermissionValue;
  details: (string | null);
}


export type Permission = PermissionMojoType;
mojo.internal.Struct<PermissionMojoType>(
    PermissionSpec.$,
    'Permission',
    [
      mojo.internal.StructField<PermissionMojoType, PermissionType>(
        'permissionType', 0,
        0,
        PermissionTypeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PermissionMojoType, PermissionValue>(
        'value', 8,
        0,
        PermissionValueSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PermissionMojoType, boolean>(
        'isManaged', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PermissionMojoType, string>(
        'details', 24,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 40],]);





export interface RunOnOsLoginMojoType {
  loginMode: RunOnOsLoginMode;
  isManaged: boolean;
}


export type RunOnOsLogin = RunOnOsLoginMojoType;
mojo.internal.Struct<RunOnOsLoginMojoType>(
    RunOnOsLoginSpec.$,
    'RunOnOsLogin',
    [
      mojo.internal.StructField<RunOnOsLoginMojoType, RunOnOsLoginMode>(
        'loginMode', 0,
        0,
        RunOnOsLoginModeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<RunOnOsLoginMojoType, boolean>(
        'isManaged', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface LocaleMojoType {
  localeTag: string;
  displayName: string;
  nativeDisplayName: string;
}


export type Locale = LocaleMojoType;
mojo.internal.Struct<LocaleMojoType>(
    LocaleSpec.$,
    'Locale',
    [
      mojo.internal.StructField<LocaleMojoType, string>(
        'localeTag', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<LocaleMojoType, string>(
        'displayName', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<LocaleMojoType, string>(
        'nativeDisplayName', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface AppMojoType {
  id: string;
  type: AppType;
  isPinned: (boolean | null);
  isPolicyPinned: (boolean | null);
  hideMoreSettings: boolean;
  hidePinToShelf: boolean;
  isPreferredApp: boolean;
  hideWindowMode: boolean;
  resizeLocked: boolean;
  hideResizeLocked: boolean;
  showSystemNotificationsSettingsLink: boolean;
  allowUninstall: boolean;
  disableUserChoiceNavigationCapturing: boolean;
  title: (string | null);
  description: (string | null);
  version: (string | null);
  size: (string | null);
  permissions: {[key in PermissionType]?: Permission};
  installReason: InstallReason;
  installSource: InstallSource;
  windowMode: WindowMode;
  supportedLinks: string[];
  runOnOsLogin: (RunOnOsLogin | null);
  fileHandlingState: (FileHandlingState | null);
  appSize: (string | null);
  dataSize: (string | null);
  publisherId: string;
  formattedOrigin: (string | null);
  scopeExtensions: string[];
  supportedLocales: Locale[];
  selectedLocale: (Locale | null);
}


export type App = AppMojoType;
mojo.internal.Struct<AppMojoType>(
    AppSpec.$,
    'App',
    [
      mojo.internal.StructField<AppMojoType, string>(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AppMojoType, AppType>(
        'type', 8,
        0,
        AppTypeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AppMojoType, string>(
        'title', 16,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AppMojoType, string>(
        'description', 24,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AppMojoType, boolean>(
        'is_pinned_$flag', 12,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "is_pinned_$value",
          originalFieldName: "isPinned",
        },
        undefined,
    ),
      mojo.internal.StructField<AppMojoType, boolean>(
        'is_pinned_$value', 12,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "isPinned",
        },
        undefined,
    ),
      mojo.internal.StructField<AppMojoType, boolean>(
        'is_policy_pinned_$flag', 12,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "is_policy_pinned_$value",
          originalFieldName: "isPolicyPinned",
        },
        undefined,
    ),
      mojo.internal.StructField<AppMojoType, boolean>(
        'is_policy_pinned_$value', 12,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "isPolicyPinned",
        },
        undefined,
    ),
      mojo.internal.StructField<AppMojoType, string>(
        'version', 32,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AppMojoType, string>(
        'size', 40,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AppMojoType, {[key in PermissionType]?: Permission}>(
        'permissions', 48,
        0,
        mojo.internal.Map(PermissionTypeSpec.$, PermissionSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AppMojoType, InstallReason>(
        'installReason', 56,
        0,
        InstallReasonSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AppMojoType, InstallSource>(
        'installSource', 60,
        0,
        InstallSourceSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AppMojoType, boolean>(
        'hideMoreSettings', 12,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AppMojoType, boolean>(
        'hidePinToShelf', 12,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AppMojoType, boolean>(
        'isPreferredApp', 12,
        6,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AppMojoType, WindowMode>(
        'windowMode', 64,
        0,
        WindowModeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AppMojoType, boolean>(
        'hideWindowMode', 12,
        7,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AppMojoType, boolean>(
        'resizeLocked', 13,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AppMojoType, boolean>(
        'hideResizeLocked', 13,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AppMojoType, string[]>(
        'supportedLinks', 72,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AppMojoType, RunOnOsLogin>(
        'runOnOsLogin', 80,
        0,
        RunOnOsLoginSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AppMojoType, FileHandlingState>(
        'fileHandlingState', 88,
        0,
        FileHandlingStateSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AppMojoType, string>(
        'appSize', 96,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AppMojoType, string>(
        'dataSize', 104,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AppMojoType, string>(
        'publisherId', 112,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AppMojoType, string>(
        'formattedOrigin', 120,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AppMojoType, string[]>(
        'scopeExtensions', 128,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AppMojoType, Locale[]>(
        'supportedLocales', 136,
        0,
        mojo.internal.Array(LocaleSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AppMojoType, Locale>(
        'selectedLocale', 144,
        0,
        LocaleSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AppMojoType, boolean>(
        'showSystemNotificationsSettingsLink', 13,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AppMojoType, boolean>(
        'allowUninstall', 13,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AppMojoType, boolean>(
        'disableUserChoiceNavigationCapturing', 13,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 160],]);





export interface ExtensionAppPermissionMessageMojoType {
  message: string;
  submessages: string[];
}


export type ExtensionAppPermissionMessage = ExtensionAppPermissionMessageMojoType;
mojo.internal.Struct<ExtensionAppPermissionMessageMojoType>(
    ExtensionAppPermissionMessageSpec.$,
    'ExtensionAppPermissionMessage',
    [
      mojo.internal.StructField<ExtensionAppPermissionMessageMojoType, string>(
        'message', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ExtensionAppPermissionMessageMojoType, string[]>(
        'submessages', 8,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface FileHandlingStateMojoType {
  enabled: boolean;
  isManaged: boolean;
  userVisibleTypes: string;
  userVisibleTypesLabel: string;
  learnMoreUrl: (url_mojom_Url | null);
}


export type FileHandlingState = FileHandlingStateMojoType;
mojo.internal.Struct<FileHandlingStateMojoType>(
    FileHandlingStateSpec.$,
    'FileHandlingState',
    [
      mojo.internal.StructField<FileHandlingStateMojoType, boolean>(
        'enabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<FileHandlingStateMojoType, boolean>(
        'isManaged', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<FileHandlingStateMojoType, string>(
        'userVisibleTypes', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<FileHandlingStateMojoType, string>(
        'userVisibleTypesLabel', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<FileHandlingStateMojoType, url_mojom_Url>(
        'learnMoreUrl', 24,
        0,
        url_mojom_UrlSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 40],]);





export interface PageHandlerFactory_CreatePageHandler_ParamsMojoType {
  page: PageRemote;
  handler: PageHandlerPendingReceiver;
}


export type PageHandlerFactory_CreatePageHandler_Params = PageHandlerFactory_CreatePageHandler_ParamsMojoType;
mojo.internal.Struct<PageHandlerFactory_CreatePageHandler_ParamsMojoType>(
    PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
    'PageHandlerFactory_CreatePageHandler_Params',
    [
      mojo.internal.StructField<PageHandlerFactory_CreatePageHandler_ParamsMojoType, PageRemote>(
        'page', 0,
        0,
        mojo.internal.InterfaceProxy(PageRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandlerFactory_CreatePageHandler_ParamsMojoType, PageHandlerPendingReceiver>(
        'handler', 8,
        0,
        mojo.internal.InterfaceRequest(PageHandlerPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_GetApps_ParamsMojoType {
}


export type PageHandler_GetApps_Params = PageHandler_GetApps_ParamsMojoType;
mojo.internal.Struct<PageHandler_GetApps_ParamsMojoType>(
    PageHandler_GetApps_ParamsSpec.$,
    'PageHandler_GetApps_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_GetApps_ResponseParamsMojoType {
  apps: App[];
}


export type PageHandler_GetApps_ResponseParams = PageHandler_GetApps_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_GetApps_ResponseParamsMojoType>(
    PageHandler_GetApps_ResponseParamsSpec.$,
    'PageHandler_GetApps_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_GetApps_ResponseParamsMojoType, App[]>(
        'apps', 0,
        0,
        mojo.internal.Array(AppSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_GetApp_ParamsMojoType {
  appId: string;
}


export type PageHandler_GetApp_Params = PageHandler_GetApp_ParamsMojoType;
mojo.internal.Struct<PageHandler_GetApp_ParamsMojoType>(
    PageHandler_GetApp_ParamsSpec.$,
    'PageHandler_GetApp_Params',
    [
      mojo.internal.StructField<PageHandler_GetApp_ParamsMojoType, string>(
        'appId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_GetApp_ResponseParamsMojoType {
  app: (App | null);
}


export type PageHandler_GetApp_ResponseParams = PageHandler_GetApp_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_GetApp_ResponseParamsMojoType>(
    PageHandler_GetApp_ResponseParamsSpec.$,
    'PageHandler_GetApp_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_GetApp_ResponseParamsMojoType, App>(
        'app', 0,
        0,
        AppSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_GetSubAppToParentMap_ParamsMojoType {
}


export type PageHandler_GetSubAppToParentMap_Params = PageHandler_GetSubAppToParentMap_ParamsMojoType;
mojo.internal.Struct<PageHandler_GetSubAppToParentMap_ParamsMojoType>(
    PageHandler_GetSubAppToParentMap_ParamsSpec.$,
    'PageHandler_GetSubAppToParentMap_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_GetSubAppToParentMap_ResponseParamsMojoType {
  subAppToParentMap: {[key: string]: string};
}


export type PageHandler_GetSubAppToParentMap_ResponseParams = PageHandler_GetSubAppToParentMap_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_GetSubAppToParentMap_ResponseParamsMojoType>(
    PageHandler_GetSubAppToParentMap_ResponseParamsSpec.$,
    'PageHandler_GetSubAppToParentMap_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_GetSubAppToParentMap_ResponseParamsMojoType, {[key: string]: string}>(
        'subAppToParentMap', 0,
        0,
        mojo.internal.Map(mojo.internal.String, mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_GetExtensionAppPermissionMessages_ParamsMojoType {
  appId: string;
}


export type PageHandler_GetExtensionAppPermissionMessages_Params = PageHandler_GetExtensionAppPermissionMessages_ParamsMojoType;
mojo.internal.Struct<PageHandler_GetExtensionAppPermissionMessages_ParamsMojoType>(
    PageHandler_GetExtensionAppPermissionMessages_ParamsSpec.$,
    'PageHandler_GetExtensionAppPermissionMessages_Params',
    [
      mojo.internal.StructField<PageHandler_GetExtensionAppPermissionMessages_ParamsMojoType, string>(
        'appId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_GetExtensionAppPermissionMessages_ResponseParamsMojoType {
  messages: ExtensionAppPermissionMessage[];
}


export type PageHandler_GetExtensionAppPermissionMessages_ResponseParams = PageHandler_GetExtensionAppPermissionMessages_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_GetExtensionAppPermissionMessages_ResponseParamsMojoType>(
    PageHandler_GetExtensionAppPermissionMessages_ResponseParamsSpec.$,
    'PageHandler_GetExtensionAppPermissionMessages_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_GetExtensionAppPermissionMessages_ResponseParamsMojoType, ExtensionAppPermissionMessage[]>(
        'messages', 0,
        0,
        mojo.internal.Array(ExtensionAppPermissionMessageSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_SetPinned_ParamsMojoType {
  appId: string;
  pinned: boolean;
}


export type PageHandler_SetPinned_Params = PageHandler_SetPinned_ParamsMojoType;
mojo.internal.Struct<PageHandler_SetPinned_ParamsMojoType>(
    PageHandler_SetPinned_ParamsSpec.$,
    'PageHandler_SetPinned_Params',
    [
      mojo.internal.StructField<PageHandler_SetPinned_ParamsMojoType, string>(
        'appId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_SetPinned_ParamsMojoType, boolean>(
        'pinned', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_SetPermission_ParamsMojoType {
  appId: string;
  permission: Permission;
}


export type PageHandler_SetPermission_Params = PageHandler_SetPermission_ParamsMojoType;
mojo.internal.Struct<PageHandler_SetPermission_ParamsMojoType>(
    PageHandler_SetPermission_ParamsSpec.$,
    'PageHandler_SetPermission_Params',
    [
      mojo.internal.StructField<PageHandler_SetPermission_ParamsMojoType, string>(
        'appId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_SetPermission_ParamsMojoType, Permission>(
        'permission', 8,
        0,
        PermissionSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_SetResizeLocked_ParamsMojoType {
  appId: string;
  locked: boolean;
}


export type PageHandler_SetResizeLocked_Params = PageHandler_SetResizeLocked_ParamsMojoType;
mojo.internal.Struct<PageHandler_SetResizeLocked_ParamsMojoType>(
    PageHandler_SetResizeLocked_ParamsSpec.$,
    'PageHandler_SetResizeLocked_Params',
    [
      mojo.internal.StructField<PageHandler_SetResizeLocked_ParamsMojoType, string>(
        'appId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_SetResizeLocked_ParamsMojoType, boolean>(
        'locked', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_Uninstall_ParamsMojoType {
  appId: string;
}


export type PageHandler_Uninstall_Params = PageHandler_Uninstall_ParamsMojoType;
mojo.internal.Struct<PageHandler_Uninstall_ParamsMojoType>(
    PageHandler_Uninstall_ParamsSpec.$,
    'PageHandler_Uninstall_Params',
    [
      mojo.internal.StructField<PageHandler_Uninstall_ParamsMojoType, string>(
        'appId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_OpenNativeSettings_ParamsMojoType {
  appId: string;
}


export type PageHandler_OpenNativeSettings_Params = PageHandler_OpenNativeSettings_ParamsMojoType;
mojo.internal.Struct<PageHandler_OpenNativeSettings_ParamsMojoType>(
    PageHandler_OpenNativeSettings_ParamsSpec.$,
    'PageHandler_OpenNativeSettings_Params',
    [
      mojo.internal.StructField<PageHandler_OpenNativeSettings_ParamsMojoType, string>(
        'appId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_SetPreferredApp_ParamsMojoType {
  appId: string;
  isPreferredApp: boolean;
}


export type PageHandler_SetPreferredApp_Params = PageHandler_SetPreferredApp_ParamsMojoType;
mojo.internal.Struct<PageHandler_SetPreferredApp_ParamsMojoType>(
    PageHandler_SetPreferredApp_ParamsSpec.$,
    'PageHandler_SetPreferredApp_Params',
    [
      mojo.internal.StructField<PageHandler_SetPreferredApp_ParamsMojoType, string>(
        'appId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_SetPreferredApp_ParamsMojoType, boolean>(
        'isPreferredApp', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_GetOverlappingPreferredApps_ParamsMojoType {
  appId: string;
}


export type PageHandler_GetOverlappingPreferredApps_Params = PageHandler_GetOverlappingPreferredApps_ParamsMojoType;
mojo.internal.Struct<PageHandler_GetOverlappingPreferredApps_ParamsMojoType>(
    PageHandler_GetOverlappingPreferredApps_ParamsSpec.$,
    'PageHandler_GetOverlappingPreferredApps_Params',
    [
      mojo.internal.StructField<PageHandler_GetOverlappingPreferredApps_ParamsMojoType, string>(
        'appId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_GetOverlappingPreferredApps_ResponseParamsMojoType {
  appIds: string[];
}


export type PageHandler_GetOverlappingPreferredApps_ResponseParams = PageHandler_GetOverlappingPreferredApps_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_GetOverlappingPreferredApps_ResponseParamsMojoType>(
    PageHandler_GetOverlappingPreferredApps_ResponseParamsSpec.$,
    'PageHandler_GetOverlappingPreferredApps_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_GetOverlappingPreferredApps_ResponseParamsMojoType, string[]>(
        'appIds', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_UpdateAppSize_ParamsMojoType {
  appId: string;
}


export type PageHandler_UpdateAppSize_Params = PageHandler_UpdateAppSize_ParamsMojoType;
mojo.internal.Struct<PageHandler_UpdateAppSize_ParamsMojoType>(
    PageHandler_UpdateAppSize_ParamsSpec.$,
    'PageHandler_UpdateAppSize_Params',
    [
      mojo.internal.StructField<PageHandler_UpdateAppSize_ParamsMojoType, string>(
        'appId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_SetWindowMode_ParamsMojoType {
  appId: string;
  windowMode: WindowMode;
}


export type PageHandler_SetWindowMode_Params = PageHandler_SetWindowMode_ParamsMojoType;
mojo.internal.Struct<PageHandler_SetWindowMode_ParamsMojoType>(
    PageHandler_SetWindowMode_ParamsSpec.$,
    'PageHandler_SetWindowMode_Params',
    [
      mojo.internal.StructField<PageHandler_SetWindowMode_ParamsMojoType, string>(
        'appId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_SetWindowMode_ParamsMojoType, WindowMode>(
        'windowMode', 8,
        0,
        WindowModeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_SetRunOnOsLoginMode_ParamsMojoType {
  appId: string;
  runOnOsLoginMode: RunOnOsLoginMode;
}


export type PageHandler_SetRunOnOsLoginMode_Params = PageHandler_SetRunOnOsLoginMode_ParamsMojoType;
mojo.internal.Struct<PageHandler_SetRunOnOsLoginMode_ParamsMojoType>(
    PageHandler_SetRunOnOsLoginMode_ParamsSpec.$,
    'PageHandler_SetRunOnOsLoginMode_Params',
    [
      mojo.internal.StructField<PageHandler_SetRunOnOsLoginMode_ParamsMojoType, string>(
        'appId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_SetRunOnOsLoginMode_ParamsMojoType, RunOnOsLoginMode>(
        'runOnOsLoginMode', 8,
        0,
        RunOnOsLoginModeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_SetFileHandlingEnabled_ParamsMojoType {
  appId: string;
  enabled: boolean;
}


export type PageHandler_SetFileHandlingEnabled_Params = PageHandler_SetFileHandlingEnabled_ParamsMojoType;
mojo.internal.Struct<PageHandler_SetFileHandlingEnabled_ParamsMojoType>(
    PageHandler_SetFileHandlingEnabled_ParamsSpec.$,
    'PageHandler_SetFileHandlingEnabled_Params',
    [
      mojo.internal.StructField<PageHandler_SetFileHandlingEnabled_ParamsMojoType, string>(
        'appId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_SetFileHandlingEnabled_ParamsMojoType, boolean>(
        'enabled', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_ShowDefaultAppAssociationsUi_ParamsMojoType {
}


export type PageHandler_ShowDefaultAppAssociationsUi_Params = PageHandler_ShowDefaultAppAssociationsUi_ParamsMojoType;
mojo.internal.Struct<PageHandler_ShowDefaultAppAssociationsUi_ParamsMojoType>(
    PageHandler_ShowDefaultAppAssociationsUi_ParamsSpec.$,
    'PageHandler_ShowDefaultAppAssociationsUi_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_OpenStorePage_ParamsMojoType {
  appId: string;
}


export type PageHandler_OpenStorePage_Params = PageHandler_OpenStorePage_ParamsMojoType;
mojo.internal.Struct<PageHandler_OpenStorePage_ParamsMojoType>(
    PageHandler_OpenStorePage_ParamsSpec.$,
    'PageHandler_OpenStorePage_Params',
    [
      mojo.internal.StructField<PageHandler_OpenStorePage_ParamsMojoType, string>(
        'appId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_SetAppLocale_ParamsMojoType {
  appId: string;
  localeTag: string;
}


export type PageHandler_SetAppLocale_Params = PageHandler_SetAppLocale_ParamsMojoType;
mojo.internal.Struct<PageHandler_SetAppLocale_ParamsMojoType>(
    PageHandler_SetAppLocale_ParamsSpec.$,
    'PageHandler_SetAppLocale_Params',
    [
      mojo.internal.StructField<PageHandler_SetAppLocale_ParamsMojoType, string>(
        'appId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_SetAppLocale_ParamsMojoType, string>(
        'localeTag', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_OpenSystemNotificationSettings_ParamsMojoType {
  appId: string;
}


export type PageHandler_OpenSystemNotificationSettings_Params = PageHandler_OpenSystemNotificationSettings_ParamsMojoType;
mojo.internal.Struct<PageHandler_OpenSystemNotificationSettings_ParamsMojoType>(
    PageHandler_OpenSystemNotificationSettings_ParamsSpec.$,
    'PageHandler_OpenSystemNotificationSettings_Params',
    [
      mojo.internal.StructField<PageHandler_OpenSystemNotificationSettings_ParamsMojoType, string>(
        'appId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_OnAppAdded_ParamsMojoType {
  app: App;
}


export type Page_OnAppAdded_Params = Page_OnAppAdded_ParamsMojoType;
mojo.internal.Struct<Page_OnAppAdded_ParamsMojoType>(
    Page_OnAppAdded_ParamsSpec.$,
    'Page_OnAppAdded_Params',
    [
      mojo.internal.StructField<Page_OnAppAdded_ParamsMojoType, App>(
        'app', 0,
        0,
        AppSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_OnAppChanged_ParamsMojoType {
  update: App;
}


export type Page_OnAppChanged_Params = Page_OnAppChanged_ParamsMojoType;
mojo.internal.Struct<Page_OnAppChanged_ParamsMojoType>(
    Page_OnAppChanged_ParamsSpec.$,
    'Page_OnAppChanged_Params',
    [
      mojo.internal.StructField<Page_OnAppChanged_ParamsMojoType, App>(
        'update', 0,
        0,
        AppSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_OnAppRemoved_ParamsMojoType {
  appId: string;
}


export type Page_OnAppRemoved_Params = Page_OnAppRemoved_ParamsMojoType;
mojo.internal.Struct<Page_OnAppRemoved_ParamsMojoType>(
    Page_OnAppRemoved_ParamsSpec.$,
    'Page_OnAppRemoved_Params',
    [
      mojo.internal.StructField<Page_OnAppRemoved_ParamsMojoType, string>(
        'appId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);



mojo.internal.Union(
    PermissionValueSpec.$, 'PermissionValue',
    {
      'boolValue': {
        'ordinal': 0,
        'type': mojo.internal.Bool,
      },
      'tristateValue': {
        'ordinal': 1,
        'type': TriStateSpec.$,
      },
    });

export interface PermissionValue {
  boolValue?: boolean,
  tristateValue?: TriState,
}

export enum PermissionValueFieldTags {
  BOOL_VALUE,
  TRISTATE_VALUE,
}

export function whichPermissionValue(u: PermissionValue): PermissionValueFieldTags {
  if (u.boolValue !== null && u.boolValue !== undefined) {
    return PermissionValueFieldTags.BOOL_VALUE;
  }
  if (u.tristateValue !== null && u.tristateValue !== undefined) {
    return PermissionValueFieldTags.TRISTATE_VALUE;
  }
  throw new Error("no union field has been set, this is an illegal state");
}
