// ui/webui/resources/cr_components/app_management/app_management.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_WEBUI_RESOURCES_CR_COMPONENTS_APP_MANAGEMENT_APP_MANAGEMENT_MOJOM_SHARED_H_
#define UI_WEBUI_RESOURCES_CR_COMPONENTS_APP_MANAGEMENT_APP_MANAGEMENT_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/webui/resources/cr_components/app_management/app_management.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "ui/webui/resources/cr_components/app_management/app_management.mojom-data-view.h"




namespace std {

template <>
struct hash<::app_management::mojom::AppType>
    : public mojo::internal::EnumHashImpl<::app_management::mojom::AppType> {};

template <>
struct hash<::app_management::mojom::PermissionType>
    : public mojo::internal::EnumHashImpl<::app_management::mojom::PermissionType> {};

template <>
struct hash<::app_management::mojom::TriState>
    : public mojo::internal::EnumHashImpl<::app_management::mojom::TriState> {};

template <>
struct hash<::app_management::mojom::InstallReason>
    : public mojo::internal::EnumHashImpl<::app_management::mojom::InstallReason> {};

template <>
struct hash<::app_management::mojom::InstallSource>
    : public mojo::internal::EnumHashImpl<::app_management::mojom::InstallSource> {};

template <>
struct hash<::app_management::mojom::WindowMode>
    : public mojo::internal::EnumHashImpl<::app_management::mojom::WindowMode> {};

template <>
struct hash<::app_management::mojom::RunOnOsLoginMode>
    : public mojo::internal::EnumHashImpl<::app_management::mojom::RunOnOsLoginMode> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::app_management::mojom::AppType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::app_management::mojom::AppType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::app_management::mojom::AppType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::app_management::mojom::PermissionType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::app_management::mojom::PermissionType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::app_management::mojom::PermissionType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::app_management::mojom::TriState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::app_management::mojom::TriState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::app_management::mojom::TriState>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::app_management::mojom::InstallReason, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::app_management::mojom::InstallReason, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::app_management::mojom::InstallReason>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::app_management::mojom::InstallSource, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::app_management::mojom::InstallSource, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::app_management::mojom::InstallSource>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::app_management::mojom::WindowMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::app_management::mojom::WindowMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::app_management::mojom::WindowMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::app_management::mojom::RunOnOsLoginMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::app_management::mojom::RunOnOsLoginMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::app_management::mojom::RunOnOsLoginMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::app_management::mojom::PermissionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::app_management::mojom::PermissionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::app_management::mojom::internal::Permission_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::app_management::mojom::PermissionType>(
      Traits::permission_type(input),
      &fragment->permission_type);

    decltype(Traits::value(input)) in_value = Traits::value(input);
    mojo::internal::MessageFragment<decltype(fragment->value)>
        value_fragment(fragment.message());
    value_fragment.Claim(&fragment->value);
    
    mojo::internal::Serialize<::app_management::mojom::PermissionValueDataView>(
      in_value,
      value_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->value.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null value in Permission struct");

    fragment->is_managed = Traits::is_managed(input);

    decltype(Traits::details(input)) in_details = Traits::details(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->details)::BaseType> details_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_details,
      details_fragment);

    fragment->details.Set(
        details_fragment.is_null() ? nullptr : details_fragment.data());
  }

  static bool Deserialize(::app_management::mojom::internal::Permission_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::app_management::mojom::PermissionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::app_management::mojom::RunOnOsLoginDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::app_management::mojom::RunOnOsLoginDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::app_management::mojom::internal::RunOnOsLogin_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::app_management::mojom::RunOnOsLoginMode>(
      Traits::login_mode(input),
      &fragment->login_mode);

    fragment->is_managed = Traits::is_managed(input);
  }

  static bool Deserialize(::app_management::mojom::internal::RunOnOsLogin_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::app_management::mojom::RunOnOsLoginDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::app_management::mojom::LocaleDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::app_management::mojom::LocaleDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::app_management::mojom::internal::Locale_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::locale_tag(input)) in_locale_tag = Traits::locale_tag(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->locale_tag)::BaseType> locale_tag_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_locale_tag,
      locale_tag_fragment);

    fragment->locale_tag.Set(
        locale_tag_fragment.is_null() ? nullptr : locale_tag_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->locale_tag.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null locale_tag in Locale struct");

    decltype(Traits::display_name(input)) in_display_name = Traits::display_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->display_name)::BaseType> display_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_display_name,
      display_name_fragment);

    fragment->display_name.Set(
        display_name_fragment.is_null() ? nullptr : display_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->display_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null display_name in Locale struct");

    decltype(Traits::native_display_name(input)) in_native_display_name = Traits::native_display_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->native_display_name)::BaseType> native_display_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_native_display_name,
      native_display_name_fragment);

    fragment->native_display_name.Set(
        native_display_name_fragment.is_null() ? nullptr : native_display_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->native_display_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null native_display_name in Locale struct");
  }

  static bool Deserialize(::app_management::mojom::internal::Locale_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::app_management::mojom::LocaleDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::app_management::mojom::AppDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::app_management::mojom::AppDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::app_management::mojom::internal::App_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in App struct");

    
    mojo::internal::Serialize<::app_management::mojom::AppType>(
      Traits::type(input),
      &fragment->type);

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    decltype(Traits::description(input)) in_description = Traits::description(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->description)::BaseType> description_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_description,
      description_fragment);

    fragment->description.Set(
        description_fragment.is_null() ? nullptr : description_fragment.data());
    fragment->is_pinned_$flag = Traits::is_pinned(input).has_value();
    if (Traits::is_pinned(input).has_value()) {
      fragment->is_pinned_$value = Traits::is_pinned(input).value();
    }
    fragment->is_policy_pinned_$flag = Traits::is_policy_pinned(input).has_value();
    if (Traits::is_policy_pinned(input).has_value()) {
      fragment->is_policy_pinned_$value = Traits::is_policy_pinned(input).value();
    }

    decltype(Traits::version(input)) in_version = Traits::version(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->version)::BaseType> version_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_version,
      version_fragment);

    fragment->version.Set(
        version_fragment.is_null() ? nullptr : version_fragment.data());

    decltype(Traits::size(input)) in_size = Traits::size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->size)::BaseType> size_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_size,
      size_fragment);

    fragment->size.Set(
        size_fragment.is_null() ? nullptr : size_fragment.data());

    decltype(Traits::permissions(input)) in_permissions = Traits::permissions(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->permissions)::BaseType>
        permissions_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& permissions_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayOfEnumsValidator<0, false, ::app_management::mojom::internal::PermissionType_Data::Validate>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<::app_management::mojom::PermissionType, ::app_management::mojom::PermissionDataView>>(
      in_permissions,
      permissions_fragment,
      &permissions_validate_params);

    fragment->permissions.Set(
        permissions_fragment.is_null() ? nullptr : permissions_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->permissions.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null permissions in App struct");

    
    mojo::internal::Serialize<::app_management::mojom::InstallReason>(
      Traits::install_reason(input),
      &fragment->install_reason);

    
    mojo::internal::Serialize<::app_management::mojom::InstallSource>(
      Traits::install_source(input),
      &fragment->install_source);

    fragment->hide_more_settings = Traits::hide_more_settings(input);

    fragment->hide_pin_to_shelf = Traits::hide_pin_to_shelf(input);

    fragment->is_preferred_app = Traits::is_preferred_app(input);

    
    mojo::internal::Serialize<::app_management::mojom::WindowMode>(
      Traits::window_mode(input),
      &fragment->window_mode);

    fragment->hide_window_mode = Traits::hide_window_mode(input);

    fragment->resize_locked = Traits::resize_locked(input);

    fragment->hide_resize_locked = Traits::hide_resize_locked(input);

    decltype(Traits::supported_links(input)) in_supported_links = Traits::supported_links(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->supported_links)::BaseType>
        supported_links_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& supported_links_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_supported_links,
      supported_links_fragment,
      &supported_links_validate_params);

    fragment->supported_links.Set(
        supported_links_fragment.is_null() ? nullptr : supported_links_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->supported_links.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null supported_links in App struct");

    decltype(Traits::run_on_os_login(input)) in_run_on_os_login = Traits::run_on_os_login(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->run_on_os_login)::BaseType> run_on_os_login_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::app_management::mojom::RunOnOsLoginDataView>(
      in_run_on_os_login,
      run_on_os_login_fragment);

    fragment->run_on_os_login.Set(
        run_on_os_login_fragment.is_null() ? nullptr : run_on_os_login_fragment.data());

    decltype(Traits::file_handling_state(input)) in_file_handling_state = Traits::file_handling_state(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->file_handling_state)::BaseType> file_handling_state_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::app_management::mojom::FileHandlingStateDataView>(
      in_file_handling_state,
      file_handling_state_fragment);

    fragment->file_handling_state.Set(
        file_handling_state_fragment.is_null() ? nullptr : file_handling_state_fragment.data());

    decltype(Traits::app_size(input)) in_app_size = Traits::app_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->app_size)::BaseType> app_size_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_app_size,
      app_size_fragment);

    fragment->app_size.Set(
        app_size_fragment.is_null() ? nullptr : app_size_fragment.data());

    decltype(Traits::data_size(input)) in_data_size = Traits::data_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->data_size)::BaseType> data_size_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_data_size,
      data_size_fragment);

    fragment->data_size.Set(
        data_size_fragment.is_null() ? nullptr : data_size_fragment.data());

    decltype(Traits::publisher_id(input)) in_publisher_id = Traits::publisher_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->publisher_id)::BaseType> publisher_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_publisher_id,
      publisher_id_fragment);

    fragment->publisher_id.Set(
        publisher_id_fragment.is_null() ? nullptr : publisher_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->publisher_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null publisher_id in App struct");

    decltype(Traits::formatted_origin(input)) in_formatted_origin = Traits::formatted_origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->formatted_origin)::BaseType> formatted_origin_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_formatted_origin,
      formatted_origin_fragment);

    fragment->formatted_origin.Set(
        formatted_origin_fragment.is_null() ? nullptr : formatted_origin_fragment.data());

    decltype(Traits::scope_extensions(input)) in_scope_extensions = Traits::scope_extensions(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->scope_extensions)::BaseType>
        scope_extensions_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& scope_extensions_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_scope_extensions,
      scope_extensions_fragment,
      &scope_extensions_validate_params);

    fragment->scope_extensions.Set(
        scope_extensions_fragment.is_null() ? nullptr : scope_extensions_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->scope_extensions.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null scope_extensions in App struct");

    decltype(Traits::supported_locales(input)) in_supported_locales = Traits::supported_locales(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->supported_locales)::BaseType>
        supported_locales_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& supported_locales_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::app_management::mojom::LocaleDataView>>(
      in_supported_locales,
      supported_locales_fragment,
      &supported_locales_validate_params);

    fragment->supported_locales.Set(
        supported_locales_fragment.is_null() ? nullptr : supported_locales_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->supported_locales.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null supported_locales in App struct");

    decltype(Traits::selected_locale(input)) in_selected_locale = Traits::selected_locale(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->selected_locale)::BaseType> selected_locale_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::app_management::mojom::LocaleDataView>(
      in_selected_locale,
      selected_locale_fragment);

    fragment->selected_locale.Set(
        selected_locale_fragment.is_null() ? nullptr : selected_locale_fragment.data());

    fragment->show_system_notifications_settings_link = Traits::show_system_notifications_settings_link(input);

    fragment->allow_uninstall = Traits::allow_uninstall(input);

    fragment->disable_user_choice_navigation_capturing = Traits::disable_user_choice_navigation_capturing(input);
  }

  static bool Deserialize(::app_management::mojom::internal::App_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::app_management::mojom::AppDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::app_management::mojom::ExtensionAppPermissionMessageDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::app_management::mojom::ExtensionAppPermissionMessageDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::app_management::mojom::internal::ExtensionAppPermissionMessage_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::message(input)) in_message = Traits::message(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->message)::BaseType> message_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_message,
      message_fragment);

    fragment->message.Set(
        message_fragment.is_null() ? nullptr : message_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->message.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in ExtensionAppPermissionMessage struct");

    decltype(Traits::submessages(input)) in_submessages = Traits::submessages(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->submessages)::BaseType>
        submessages_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& submessages_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_submessages,
      submessages_fragment,
      &submessages_validate_params);

    fragment->submessages.Set(
        submessages_fragment.is_null() ? nullptr : submessages_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->submessages.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null submessages in ExtensionAppPermissionMessage struct");
  }

  static bool Deserialize(::app_management::mojom::internal::ExtensionAppPermissionMessage_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::app_management::mojom::ExtensionAppPermissionMessageDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::app_management::mojom::FileHandlingStateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::app_management::mojom::FileHandlingStateDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::app_management::mojom::internal::FileHandlingState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->enabled = Traits::enabled(input);

    fragment->is_managed = Traits::is_managed(input);

    decltype(Traits::user_visible_types(input)) in_user_visible_types = Traits::user_visible_types(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->user_visible_types)::BaseType> user_visible_types_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_user_visible_types,
      user_visible_types_fragment);

    fragment->user_visible_types.Set(
        user_visible_types_fragment.is_null() ? nullptr : user_visible_types_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->user_visible_types.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null user_visible_types in FileHandlingState struct");

    decltype(Traits::user_visible_types_label(input)) in_user_visible_types_label = Traits::user_visible_types_label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->user_visible_types_label)::BaseType> user_visible_types_label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_user_visible_types_label,
      user_visible_types_label_fragment);

    fragment->user_visible_types_label.Set(
        user_visible_types_label_fragment.is_null() ? nullptr : user_visible_types_label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->user_visible_types_label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null user_visible_types_label in FileHandlingState struct");

    decltype(Traits::learn_more_url(input)) in_learn_more_url = Traits::learn_more_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->learn_more_url)::BaseType> learn_more_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_learn_more_url,
      learn_more_url_fragment);

    fragment->learn_more_url.Set(
        learn_more_url_fragment.is_null() ? nullptr : learn_more_url_fragment.data());
  }

  static bool Deserialize(::app_management::mojom::internal::FileHandlingState_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::app_management::mojom::FileHandlingStateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::app_management::mojom::PermissionValueDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::app_management::mojom::PermissionValueDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::app_management::mojom::internal::PermissionValue_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::app_management::mojom::PermissionValueDataView::Tag::kBoolValue: {
    decltype(Traits::bool_value(input))
    in_bool_value = Traits::bool_value(input);
    fragment->data.f_bool_value = in_bool_value;
    break;
  }
  case ::app_management::mojom::PermissionValueDataView::Tag::kTristateValue: {
    decltype(Traits::tristate_value(input))
    in_tristate_value = Traits::tristate_value(input);
        
mojo::internal::Serialize<::app_management::mojom::TriState>(
  in_tristate_value,
  &fragment->data.f_tristate_value);
    break;
  }
}
  }

  static bool Deserialize(::app_management::mojom::internal::PermissionValue_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::app_management::mojom::PermissionValueDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace app_management::mojom {

inline void PermissionDataView::GetValueDataView(
    PermissionValueDataView* output) {
  auto pointer = &data_->value;
  *output = PermissionValueDataView(pointer, message_);
}
inline void PermissionDataView::GetDetailsDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->details.Get();
  *output = mojo::StringDataView(pointer, message_);
}




inline void LocaleDataView::GetLocaleTagDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->locale_tag.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void LocaleDataView::GetDisplayNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->display_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void LocaleDataView::GetNativeDisplayNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->native_display_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void AppDataView::GetIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AppDataView::GetTitleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->title.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AppDataView::GetDescriptionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->description.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AppDataView::GetVersionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->version.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AppDataView::GetSizeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->size.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AppDataView::GetPermissionsDataView(
    mojo::MapDataView<PermissionType, PermissionDataView>* output) {
  auto pointer = data_->permissions.Get();
  *output = mojo::MapDataView<PermissionType, PermissionDataView>(pointer, message_);
}
inline void AppDataView::GetSupportedLinksDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->supported_links.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void AppDataView::GetRunOnOsLoginDataView(
    RunOnOsLoginDataView* output) {
  auto pointer = data_->run_on_os_login.Get();
  *output = RunOnOsLoginDataView(pointer, message_);
}
inline void AppDataView::GetFileHandlingStateDataView(
    FileHandlingStateDataView* output) {
  auto pointer = data_->file_handling_state.Get();
  *output = FileHandlingStateDataView(pointer, message_);
}
inline void AppDataView::GetAppSizeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->app_size.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AppDataView::GetDataSizeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->data_size.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AppDataView::GetPublisherIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->publisher_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AppDataView::GetFormattedOriginDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->formatted_origin.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AppDataView::GetScopeExtensionsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->scope_extensions.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void AppDataView::GetSupportedLocalesDataView(
    mojo::ArrayDataView<LocaleDataView>* output) {
  auto pointer = data_->supported_locales.Get();
  *output = mojo::ArrayDataView<LocaleDataView>(pointer, message_);
}
inline void AppDataView::GetSelectedLocaleDataView(
    LocaleDataView* output) {
  auto pointer = data_->selected_locale.Get();
  *output = LocaleDataView(pointer, message_);
}


inline void ExtensionAppPermissionMessageDataView::GetMessageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->message.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ExtensionAppPermissionMessageDataView::GetSubmessagesDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->submessages.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}


inline void FileHandlingStateDataView::GetUserVisibleTypesDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->user_visible_types.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void FileHandlingStateDataView::GetUserVisibleTypesLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->user_visible_types_label.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void FileHandlingStateDataView::GetLearnMoreUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->learn_more_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}




}  // app_management::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::app_management::mojom::AppType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::app_management::mojom::AppType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::app_management::mojom::PermissionType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::app_management::mojom::PermissionType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::app_management::mojom::TriState> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::app_management::mojom::TriState value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::app_management::mojom::InstallReason> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::app_management::mojom::InstallReason value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::app_management::mojom::InstallSource> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::app_management::mojom::InstallSource value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::app_management::mojom::WindowMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::app_management::mojom::WindowMode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::app_management::mojom::RunOnOsLoginMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::app_management::mojom::RunOnOsLoginMode value);
};

} // namespace perfetto

#endif  // UI_WEBUI_RESOURCES_CR_COMPONENTS_APP_MANAGEMENT_APP_MANAGEMENT_MOJOM_SHARED_H_