// ui/webui/resources/cr_components/app_management/app_management.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/webui/resources/cr_components/app_management/app_management.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/webui/resources/cr_components/app_management/app_management.mojom-params-data.h"
namespace app_management {
namespace mojom {

NOINLINE static const char* AppTypeToStringHelper(AppType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AppType::kUnknown:
      return "kUnknown";
    case AppType::kArc:
      return "kArc";
    case AppType::kCrostini:
      return "kCrostini";
    case AppType::kChromeApp:
      return "kChromeApp";
    case AppType::kWeb:
      return "kWeb";
    case AppType::kPluginVm:
      return "kPluginVm";
    case AppType::kRemote:
      return "kRemote";
    case AppType::kBorealis:
      return "kBorealis";
    case AppType::kSystemWeb:
      return "kSystemWeb";
    case AppType::kExtension:
      return "kExtension";
    case AppType::kBruschetta:
      return "kBruschetta";
    default:
      return nullptr;
  }
}

std::string AppTypeToString(AppType value) {
  const char *str = AppTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AppType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AppType value) {
  return os << AppTypeToString(value);
}

NOINLINE static const char* PermissionTypeToStringHelper(PermissionType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PermissionType::kUnknown:
      return "kUnknown";
    case PermissionType::kCamera:
      return "kCamera";
    case PermissionType::kLocation:
      return "kLocation";
    case PermissionType::kMicrophone:
      return "kMicrophone";
    case PermissionType::kNotifications:
      return "kNotifications";
    case PermissionType::kContacts:
      return "kContacts";
    case PermissionType::kStorage:
      return "kStorage";
    case PermissionType::kPrinting:
      return "kPrinting";
    case PermissionType::kFileHandling:
      return "kFileHandling";
    default:
      return nullptr;
  }
}

std::string PermissionTypeToString(PermissionType value) {
  const char *str = PermissionTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PermissionType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PermissionType value) {
  return os << PermissionTypeToString(value);
}

NOINLINE static const char* TriStateToStringHelper(TriState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case TriState::kAllow:
      return "kAllow";
    case TriState::kBlock:
      return "kBlock";
    case TriState::kAsk:
      return "kAsk";
    default:
      return nullptr;
  }
}

std::string TriStateToString(TriState value) {
  const char *str = TriStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown TriState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, TriState value) {
  return os << TriStateToString(value);
}

NOINLINE static const char* InstallReasonToStringHelper(InstallReason value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case InstallReason::kUnknown:
      return "kUnknown";
    case InstallReason::kSystem:
      return "kSystem";
    case InstallReason::kPolicy:
      return "kPolicy";
    case InstallReason::kOem:
      return "kOem";
    case InstallReason::kDefault:
      return "kDefault";
    case InstallReason::kSync:
      return "kSync";
    case InstallReason::kUser:
      return "kUser";
    case InstallReason::kSubApp:
      return "kSubApp";
    case InstallReason::kKiosk:
      return "kKiosk";
    case InstallReason::kCommandLine:
      return "kCommandLine";
    default:
      return nullptr;
  }
}

std::string InstallReasonToString(InstallReason value) {
  const char *str = InstallReasonToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown InstallReason value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, InstallReason value) {
  return os << InstallReasonToString(value);
}

NOINLINE static const char* InstallSourceToStringHelper(InstallSource value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case InstallSource::kUnknown:
      return "kUnknown";
    case InstallSource::kSystem:
      return "kSystem";
    case InstallSource::kSync:
      return "kSync";
    case InstallSource::kPlayStore:
      return "kPlayStore";
    case InstallSource::kChromeWebStore:
      return "kChromeWebStore";
    case InstallSource::kBrowser:
      return "kBrowser";
    default:
      return nullptr;
  }
}

std::string InstallSourceToString(InstallSource value) {
  const char *str = InstallSourceToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown InstallSource value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, InstallSource value) {
  return os << InstallSourceToString(value);
}

NOINLINE static const char* WindowModeToStringHelper(WindowMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case WindowMode::kUnknown:
      return "kUnknown";
    case WindowMode::kWindow:
      return "kWindow";
    case WindowMode::kBrowser:
      return "kBrowser";
    case WindowMode::kTabbedWindow:
      return "kTabbedWindow";
    default:
      return nullptr;
  }
}

std::string WindowModeToString(WindowMode value) {
  const char *str = WindowModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown WindowMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, WindowMode value) {
  return os << WindowModeToString(value);
}

NOINLINE static const char* RunOnOsLoginModeToStringHelper(RunOnOsLoginMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case RunOnOsLoginMode::kUnknown:
      return "kUnknown";
    case RunOnOsLoginMode::kNotRun:
      return "kNotRun";
    case RunOnOsLoginMode::kWindowed:
      return "kWindowed";
    default:
      return nullptr;
  }
}

std::string RunOnOsLoginModeToString(RunOnOsLoginMode value) {
  const char *str = RunOnOsLoginModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown RunOnOsLoginMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, RunOnOsLoginMode value) {
  return os << RunOnOsLoginModeToString(value);
}

namespace internal {
// static
bool PermissionValue_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const PermissionValue_Data* object = static_cast<const PermissionValue_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case PermissionValue_Tag::kBoolValue: {

      return true;
    }
    case PermissionValue_Tag::kTristateValue: {


      if (!::app_management::mojom::internal::TriState_Data
            ::Validate(object->data.f_tristate_value, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in PermissionValue");
      return false;
    }
  }
}


// static
bool Permission_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Permission_Data* object =
      static_cast<const Permission_Data*>(data);


  if (!::app_management::mojom::internal::PermissionType_Data
        ::Validate(object->permission_type, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->value, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->value, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& details_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->details, validation_context,
                                         &details_validate_params)) {
    return false;
  }

  return true;
}

Permission_Data::Permission_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RunOnOsLogin_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RunOnOsLogin_Data* object =
      static_cast<const RunOnOsLogin_Data*>(data);


  if (!::app_management::mojom::internal::RunOnOsLoginMode_Data
        ::Validate(object->login_mode, validation_context))
    return false;

  return true;
}

RunOnOsLogin_Data::RunOnOsLogin_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Locale_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Locale_Data* object =
      static_cast<const Locale_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->locale_tag, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& locale_tag_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->locale_tag, validation_context,
                                         &locale_tag_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->display_name, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& display_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->display_name, validation_context,
                                         &display_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->native_display_name, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& native_display_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->native_display_name, validation_context,
                                         &native_display_name_validate_params)) {
    return false;
  }

  return true;
}

Locale_Data::Locale_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool App_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 160, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const App_Data* object =
      static_cast<const App_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }


  if (!::app_management::mojom::internal::AppType_Data
        ::Validate(object->type, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& title_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->title, validation_context,
                                         &title_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& description_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->description, validation_context,
                                         &description_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& version_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->version, validation_context,
                                         &version_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& size_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->size, validation_context,
                                         &size_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->permissions, 11, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& permissions_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayOfEnumsValidator<0, false, ::app_management::mojom::internal::PermissionType_Data::Validate>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->permissions, validation_context,
                                         &permissions_validate_params)) {
    return false;
  }


  if (!::app_management::mojom::internal::InstallReason_Data
        ::Validate(object->install_reason, validation_context))
    return false;


  if (!::app_management::mojom::internal::InstallSource_Data
        ::Validate(object->install_source, validation_context))
    return false;


  if (!::app_management::mojom::internal::WindowMode_Data
        ::Validate(object->window_mode, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->supported_links, 21, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& supported_links_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->supported_links, validation_context,
                                         &supported_links_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->run_on_os_login, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->file_handling_state, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& app_size_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->app_size, validation_context,
                                         &app_size_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& data_size_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->data_size, validation_context,
                                         &data_size_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->publisher_id, 26, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& publisher_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->publisher_id, validation_context,
                                         &publisher_id_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& formatted_origin_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->formatted_origin, validation_context,
                                         &formatted_origin_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scope_extensions, 28, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& scope_extensions_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->scope_extensions, validation_context,
                                         &scope_extensions_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->supported_locales, 29, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& supported_locales_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->supported_locales, validation_context,
                                         &supported_locales_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->selected_locale, validation_context))
    return false;

  return true;
}

App_Data::App_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ExtensionAppPermissionMessage_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ExtensionAppPermissionMessage_Data* object =
      static_cast<const ExtensionAppPermissionMessage_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->submessages, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& submessages_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->submessages, validation_context,
                                         &submessages_validate_params)) {
    return false;
  }

  return true;
}

ExtensionAppPermissionMessage_Data::ExtensionAppPermissionMessage_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileHandlingState_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FileHandlingState_Data* object =
      static_cast<const FileHandlingState_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->user_visible_types, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& user_visible_types_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->user_visible_types, validation_context,
                                         &user_visible_types_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->user_visible_types_label, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& user_visible_types_label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->user_visible_types_label, validation_context,
                                         &user_visible_types_label_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->learn_more_url, validation_context))
    return false;

  return true;
}

FileHandlingState_Data::FileHandlingState_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandlerFactory_CreatePageHandler_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandlerFactory_CreatePageHandler_Params_Data* object =
      static_cast<const PageHandlerFactory_CreatePageHandler_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->page, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->page,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->handler, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->handler,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PageHandlerFactory_CreatePageHandler_Params_Data::PageHandlerFactory_CreatePageHandler_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetApps_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetApps_Params_Data* object =
      static_cast<const PageHandler_GetApps_Params_Data*>(data);

  return true;
}

PageHandler_GetApps_Params_Data::PageHandler_GetApps_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetApps_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetApps_ResponseParams_Data* object =
      static_cast<const PageHandler_GetApps_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->apps, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& apps_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->apps, validation_context,
                                         &apps_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_GetApps_ResponseParams_Data::PageHandler_GetApps_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetApp_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetApp_Params_Data* object =
      static_cast<const PageHandler_GetApp_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& app_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_GetApp_Params_Data::PageHandler_GetApp_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetApp_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetApp_ResponseParams_Data* object =
      static_cast<const PageHandler_GetApp_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->app, validation_context))
    return false;

  return true;
}

PageHandler_GetApp_ResponseParams_Data::PageHandler_GetApp_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetSubAppToParentMap_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetSubAppToParentMap_Params_Data* object =
      static_cast<const PageHandler_GetSubAppToParentMap_Params_Data*>(data);

  return true;
}

PageHandler_GetSubAppToParentMap_Params_Data::PageHandler_GetSubAppToParentMap_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetSubAppToParentMap_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetSubAppToParentMap_ResponseParams_Data* object =
      static_cast<const PageHandler_GetSubAppToParentMap_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sub_app_to_parent_map, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& sub_app_to_parent_map_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  if (!mojo::internal::ValidateContainer(object->sub_app_to_parent_map, validation_context,
                                         &sub_app_to_parent_map_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_GetSubAppToParentMap_ResponseParams_Data::PageHandler_GetSubAppToParentMap_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetExtensionAppPermissionMessages_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetExtensionAppPermissionMessages_Params_Data* object =
      static_cast<const PageHandler_GetExtensionAppPermissionMessages_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& app_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_GetExtensionAppPermissionMessages_Params_Data::PageHandler_GetExtensionAppPermissionMessages_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetExtensionAppPermissionMessages_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetExtensionAppPermissionMessages_ResponseParams_Data* object =
      static_cast<const PageHandler_GetExtensionAppPermissionMessages_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->messages, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& messages_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->messages, validation_context,
                                         &messages_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_GetExtensionAppPermissionMessages_ResponseParams_Data::PageHandler_GetExtensionAppPermissionMessages_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_SetPinned_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_SetPinned_Params_Data* object =
      static_cast<const PageHandler_SetPinned_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& app_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_SetPinned_Params_Data::PageHandler_SetPinned_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_SetPermission_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_SetPermission_Params_Data* object =
      static_cast<const PageHandler_SetPermission_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& app_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->permission, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->permission, validation_context))
    return false;

  return true;
}

PageHandler_SetPermission_Params_Data::PageHandler_SetPermission_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_SetResizeLocked_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_SetResizeLocked_Params_Data* object =
      static_cast<const PageHandler_SetResizeLocked_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& app_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_SetResizeLocked_Params_Data::PageHandler_SetResizeLocked_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_Uninstall_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_Uninstall_Params_Data* object =
      static_cast<const PageHandler_Uninstall_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& app_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_Uninstall_Params_Data::PageHandler_Uninstall_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_OpenNativeSettings_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_OpenNativeSettings_Params_Data* object =
      static_cast<const PageHandler_OpenNativeSettings_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& app_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_OpenNativeSettings_Params_Data::PageHandler_OpenNativeSettings_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_SetPreferredApp_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_SetPreferredApp_Params_Data* object =
      static_cast<const PageHandler_SetPreferredApp_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& app_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_SetPreferredApp_Params_Data::PageHandler_SetPreferredApp_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetOverlappingPreferredApps_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetOverlappingPreferredApps_Params_Data* object =
      static_cast<const PageHandler_GetOverlappingPreferredApps_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& app_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_GetOverlappingPreferredApps_Params_Data::PageHandler_GetOverlappingPreferredApps_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetOverlappingPreferredApps_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetOverlappingPreferredApps_ResponseParams_Data* object =
      static_cast<const PageHandler_GetOverlappingPreferredApps_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_ids, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& app_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->app_ids, validation_context,
                                         &app_ids_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_GetOverlappingPreferredApps_ResponseParams_Data::PageHandler_GetOverlappingPreferredApps_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_UpdateAppSize_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_UpdateAppSize_Params_Data* object =
      static_cast<const PageHandler_UpdateAppSize_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& app_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_UpdateAppSize_Params_Data::PageHandler_UpdateAppSize_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_SetWindowMode_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_SetWindowMode_Params_Data* object =
      static_cast<const PageHandler_SetWindowMode_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& app_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }


  if (!::app_management::mojom::internal::WindowMode_Data
        ::Validate(object->window_mode, validation_context))
    return false;

  return true;
}

PageHandler_SetWindowMode_Params_Data::PageHandler_SetWindowMode_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_SetRunOnOsLoginMode_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_SetRunOnOsLoginMode_Params_Data* object =
      static_cast<const PageHandler_SetRunOnOsLoginMode_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& app_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }


  if (!::app_management::mojom::internal::RunOnOsLoginMode_Data
        ::Validate(object->run_on_os_login_mode, validation_context))
    return false;

  return true;
}

PageHandler_SetRunOnOsLoginMode_Params_Data::PageHandler_SetRunOnOsLoginMode_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_SetFileHandlingEnabled_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_SetFileHandlingEnabled_Params_Data* object =
      static_cast<const PageHandler_SetFileHandlingEnabled_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& app_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_SetFileHandlingEnabled_Params_Data::PageHandler_SetFileHandlingEnabled_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_ShowDefaultAppAssociationsUi_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_ShowDefaultAppAssociationsUi_Params_Data* object =
      static_cast<const PageHandler_ShowDefaultAppAssociationsUi_Params_Data*>(data);

  return true;
}

PageHandler_ShowDefaultAppAssociationsUi_Params_Data::PageHandler_ShowDefaultAppAssociationsUi_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_OpenStorePage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_OpenStorePage_Params_Data* object =
      static_cast<const PageHandler_OpenStorePage_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& app_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_OpenStorePage_Params_Data::PageHandler_OpenStorePage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_SetAppLocale_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_SetAppLocale_Params_Data* object =
      static_cast<const PageHandler_SetAppLocale_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& app_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->locale_tag, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& locale_tag_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->locale_tag, validation_context,
                                         &locale_tag_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_SetAppLocale_Params_Data::PageHandler_SetAppLocale_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_OpenSystemNotificationSettings_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_OpenSystemNotificationSettings_Params_Data* object =
      static_cast<const PageHandler_OpenSystemNotificationSettings_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& app_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_OpenSystemNotificationSettings_Params_Data::PageHandler_OpenSystemNotificationSettings_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_OnAppAdded_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_OnAppAdded_Params_Data* object =
      static_cast<const Page_OnAppAdded_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->app, validation_context))
    return false;

  return true;
}

Page_OnAppAdded_Params_Data::Page_OnAppAdded_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_OnAppChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_OnAppChanged_Params_Data* object =
      static_cast<const Page_OnAppChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->update, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->update, validation_context))
    return false;

  return true;
}

Page_OnAppChanged_Params_Data::Page_OnAppChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_OnAppRemoved_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_OnAppRemoved_Params_Data* object =
      static_cast<const Page_OnAppRemoved_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& app_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  return true;
}

Page_OnAppRemoved_Params_Data::Page_OnAppRemoved_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace app_management

namespace perfetto {

// static
void TraceFormatTraits<::app_management::mojom::AppType>::WriteIntoTrace(
   perfetto::TracedValue context, ::app_management::mojom::AppType value) {
  return std::move(context).WriteString(::app_management::mojom::AppTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::app_management::mojom::PermissionType>::WriteIntoTrace(
   perfetto::TracedValue context, ::app_management::mojom::PermissionType value) {
  return std::move(context).WriteString(::app_management::mojom::PermissionTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::app_management::mojom::TriState>::WriteIntoTrace(
   perfetto::TracedValue context, ::app_management::mojom::TriState value) {
  return std::move(context).WriteString(::app_management::mojom::TriStateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::app_management::mojom::InstallReason>::WriteIntoTrace(
   perfetto::TracedValue context, ::app_management::mojom::InstallReason value) {
  return std::move(context).WriteString(::app_management::mojom::InstallReasonToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::app_management::mojom::InstallSource>::WriteIntoTrace(
   perfetto::TracedValue context, ::app_management::mojom::InstallSource value) {
  return std::move(context).WriteString(::app_management::mojom::InstallSourceToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::app_management::mojom::WindowMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::app_management::mojom::WindowMode value) {
  return std::move(context).WriteString(::app_management::mojom::WindowModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::app_management::mojom::RunOnOsLoginMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::app_management::mojom::RunOnOsLoginMode value) {
  return std::move(context).WriteString(::app_management::mojom::RunOnOsLoginModeToString(value));
}

} // namespace perfetto